/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class InvChangeAcctSettingPlugin
extends AbstractBaseFormPlugin
implements BeforeF7SelectListener {
    public static final String KEY_INVCHANGEACCT_ENTITY = "bcm_invchangeacct";
    public static final String KEY_INVCHANGEACCT_F7 = "invchangeacct";
    private static final String MODEL = "model";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";

    private String getOperationStstusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"InvChangeAcctSettingPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"InvChangeAcctSettingPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private OpNameMultiLangEnumBridge getOperationSetUpEquityAccount() {
        return new OpNameMultiLangEnumBridge("\u8bbe\u7f6e\u6743\u76ca\u79d1\u76ee", "InvChangeAcctSettingPlugin_0", FI_BCM_FORMPLUGIN, "Setting equity accounts");
    }

    private OpNameMultiLangEnumBridge getOperationDelEquityAccount() {
        return new OpNameMultiLangEnumBridge("\u5220\u9664\u6743\u76ca\u79d1\u76ee", "InvChangeAcctSettingPlugin_8", FI_BCM_FORMPLUGIN, "Delete equity accounts");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        if (this.getModelIds() == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvChangeAcctSettingPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap"});
        } else {
            this.refreshBillList();
        }
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("advcontoolbarap");
        MulBasedataEdit edit = (MulBasedataEdit)this.getControl(KEY_INVCHANGEACCT_F7);
        if (edit != null) {
            edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            edit.addAfterF7SelectListener(new AfterF7SelectListener(){

                public void afterF7Select(AfterF7SelectEvent evt) {
                    ListSelectedRowCollection listSelectedRowCollection = evt.getListSelectedRowCollection();
                    for (int i = 0; i < listSelectedRowCollection.size(); ++i) {
                        InvChangeAcctSettingPlugin.this.writeOperationLog(InvChangeAcctSettingPlugin.this.getOperationSetUpEquityAccount(), listSelectedRowCollection.get(i).getNumber(), listSelectedRowCollection.get(i).getName(), InvChangeAcctSettingPlugin.this.getOperationStstusSuccess());
                    }
                }
            });
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent var1) {
        this.getModel().setValue(KEY_INVCHANGEACCT_F7, new HashMap());
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        qFilterList.add(this.getInitialFilters());
        ((ListShowParameter)var1.getFormShowParameter()).setListFilterParameter(new ListFilterParameter(qFilterList, null));
    }

    private QFilter getInitialFilters() {
        QFilter storagetypeFilters = new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
        QFilter accounttypeFilters = new QFilter("accountpart.isaccountoffset", "=", (Object)"1");
        return accounttypeFilters.and(MODEL, "=", (Object)this.getModelIds()).and(storagetypeFilters);
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl("billlistap");
        QFilter qf1 = this.getQFilter(MODEL, this.getModelIds());
        billList.setFilterParameter(new FilterParameter(qf1, null));
        billList.clearSelection();
        billList.refresh();
    }

    public Long getModelIds() {
        return LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "btnadd": {
                this.getModel().setValue(KEY_INVCHANGEACCT_F7, new HashMap());
                BasedataEdit bsEdit = (BasedataEdit)this.getControl(KEY_INVCHANGEACCT_F7);
                bsEdit.click();
                this.refreshBillList();
                break;
            }
            case "btndelete": {
                this.deleteRowItem();
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (KEY_INVCHANGEACCT_F7.equals(key)) {
            DynamicObjectCollection invchangeaccts = (DynamicObjectCollection)this.getModel().getValue(KEY_INVCHANGEACCT_F7);
            List<String> account = this.getAcctIds();
            ArrayList<DynamicObject> preparedSave = new ArrayList<DynamicObject>();
            for (DynamicObject invchangeacct : invchangeaccts) {
                DynamicObject invchangeacctParam = (DynamicObject)invchangeacct.get("fbasedataid");
                if (account.contains(invchangeacctParam.getString("number"))) continue;
                DynamicObject noRepeatAcct = BusinessDataServiceHelper.newDynamicObject((String)KEY_INVCHANGEACCT_ENTITY);
                noRepeatAcct.set(MODEL, (Object)this.getModelIds());
                noRepeatAcct.set("account", (Object)invchangeacctParam.getString("id"));
                preparedSave.add(noRepeatAcct);
            }
            if (!preparedSave.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])this.toArray(preparedSave));
                this.refreshBillList();
            }
        }
    }

    public DynamicObject[] toArray(List<DynamicObject> noRepeatAccts) {
        DynamicObject[] temp = new DynamicObject[noRepeatAccts.size()];
        for (int i = 0; i < noRepeatAccts.size(); ++i) {
            temp[i] = noRepeatAccts.get(i);
        }
        return temp;
    }

    public void deleteRowItem() {
        ArrayList<String> warnings = new ArrayList<String>();
        ListSelectedRowCollection selectedRowNums = this.getSelectedRows();
        if (selectedRowNums == null) {
            return;
        }
        ArrayList<Object> deleteRowAccountIds = new ArrayList<Object>();
        DynamicObjectCollection invAcct = QueryServiceHelper.query((String)"bcm_invelimtemplate", (String)"invelimtplentry.account,invelimtplentry.ruleexprsource", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)this.getModelId())});
        List<String> accounts = this.toList(invAcct);
        ArrayList<String> unull = new ArrayList<String>();
        DynamicObjectCollection delDoc = new DynamicObjectCollection();
        Object[] primaryKeyValues = selectedRowNums.getPrimaryKeyValues();
        DynamicObjectCollection accountEntity = QueryServiceHelper.query((String)KEY_INVCHANGEACCT_ENTITY, (String)"id,account,account.name,account.number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
        Map<Long, DynamicObject> accountEntityMap = accountEntity.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v, (v1, v2) -> v1));
        for (ListSelectedRow selectedRowNum : selectedRowNums) {
            Object key = selectedRowNum.getPrimaryKeyValue();
            if (!accountEntityMap.containsKey(key)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6743\u76ca\u79d1\u76ee\u4fe1\u606f\u5b58\u5728\u5f02\u5e38\u3002", (String)"InvChangeAcctSettingPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                continue;
            }
            DynamicObject account = accountEntityMap.get(key);
            Long id = account.getLong("account");
            String anumber = account.getString("account.number");
            if (accounts.contains(anumber)) {
                warnings.add(account.getString("account.name"));
                continue;
            }
            if (!this.checkAccountIsEmpty(id)) {
                unull.add(account.getString("account.name"));
                continue;
            }
            deleteRowAccountIds.add(key);
            delDoc.add((Object)account);
        }
        this.showInfor(warnings, unull);
        if (!deleteRowAccountIds.isEmpty()) {
            DeleteServiceHelper.delete((String)KEY_INVCHANGEACCT_ENTITY, (QFilter[])new QFilter[]{new QFilter("id", "in", deleteRowAccountIds)});
            this.writeDelOpLog(delDoc);
        }
        this.refreshBillList();
    }

    private void writeDelOpLog(DynamicObjectCollection delDoc) {
        for (DynamicObject dy : delDoc) {
            String anumber = dy.getString("account.number");
            String aname = dy.getString("account.name");
            this.writeOperationLog(this.getOperationDelEquityAccount(), anumber, aname, this.getOperationStstusSuccess());
        }
    }

    private boolean checkAccountIsEmpty(Long accountId) {
        DynamicObjectCollection accountTemp = QueryServiceHelper.query((String)"bcm_invchangeentry", (String)"investeecompany", (QFilter[])new QFilter[]{new QFilter("account", "=", (Object)accountId), new QFilter(MODEL, "=", (Object)this.getModelIds())});
        return accountTemp == null || accountTemp.isEmpty();
    }

    private void showInfor(List<String> warnings, List<String> unull) {
        String infor = "";
        if (!warnings.isEmpty()) {
            infor = infor + String.format(ResManager.loadKDString((String)"%s\u79d1\u76ee\u88ab\u80a1\u6743\u62b5\u9500\u6a21\u677finv\u516c\u5f0f\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"InvChangeAcctSettingPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), String.join((CharSequence)",", warnings));
        }
        if (!unull.isEmpty()) {
            infor = infor + String.format(ResManager.loadKDString((String)"%s\u79d1\u76ee\u4e0b\u6709\u6743\u76ca\u53d8\u52a8\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"InvChangeAcctSettingPlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), String.join((CharSequence)",", unull));
        }
        if (!infor.equals("")) {
            this.getView().showErrorNotification(infor);
        }
    }

    private List<String> getAcctIds() {
        DynamicObjectCollection data = QueryServiceHelper.query((String)KEY_INVCHANGEACCT_ENTITY, (String)"account.number", (QFilter[])new QFilter[]{this.getQFilter(MODEL, this.getModelIds())});
        ArrayList<String> acctids = new ArrayList<String>();
        for (DynamicObject row : data) {
            acctids.add(row.getString("account.number"));
        }
        return acctids;
    }

    private ListSelectedRowCollection getSelectedRows() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (!selectedRows.isEmpty()) {
            return selectedRows;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u81f3\u5c11\u4e00\u884c\u3002", (String)"InvChangeAcctSettingPlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        return null;
    }

    private QFilter getQFilter(String FieldName, Object parameter) {
        return new QFilter(FieldName, "=", parameter);
    }

    public List<String> toList(DynamicObjectCollection accounts) {
        List<String> lst = accounts.stream().filter(t -> {
            Object rule = t.get("invelimtplentry.ruleexprsource");
            return rule == null ? false : rule.toString().contains("Inv(");
        }).map(a -> {
            String ruleExp = a.getString("invelimtplentry.ruleexprsource");
            String invExp = ruleExp.replaceAll("^.*Inv\\(([^\\)]+)\\).*$", "$1");
            String accountNumb = invExp.split(",")[1];
            return accountNumb.replaceAll("\"", "");
        }).collect(Collectors.toList());
        return lst;
    }
}

