/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.chkcheck.util.CheckedFormulaUtil;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.model.FormulaEnum;
import kd.fi.bcm.business.formula.model.VFormula;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.model.formula.Formula;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.serviceHelper.FormulaServiceHelper;
import kd.fi.bcm.business.util.ResourcesLoaderUtil;
import kd.fi.bcm.common.ParamConstant;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.intergration.formula.validate.FTicket;
import kd.fi.bcm.formplugin.intergration.formula.validate.FormulaTicketer;
import kd.fi.bcm.formplugin.intergration.formula.validate.IValidate;
import kd.fi.bcm.formplugin.intergration.formula.validate.NotNullValidate;
import kd.fi.bcm.formplugin.invest.sheet.formula.InvestFormulaRegisterHelper;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.formula.EncoderService;
import kd.fi.bcm.spread.formula.expr.NameExpr;

public class InvChangeFormulaPlugin
extends AbstractBaseFormPlugin {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(InvChangeFormulaPlugin.class);
    private static final String ENABLE = "enable";
    public static final String FORMULA = "formula";
    public static final String DISABLE_BTN = "disable_btn";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("v", "inv", "esp", "bn", "getinvper", "getinvact", "desp", "confirm", "cancel", "getjlentry", "excrate");
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("v".equals(key)) {
            this.showVPanel("formula_fx_", null, null);
        } else if ("inv".equals(key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bcm_invfunctionset");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "invformulacb");
            formShowParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(formShowParameter);
        } else if ("esp".equals(key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bcm_espfunctionset");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            formShowParameter.setCustomParam("is_draft", this.getFormCustomParam("is_draft"));
            formShowParameter.setCustomParam("invrelationtype", this.getFormCustomParam("invrelationtype"));
            if (this.isViewStatus()) {
                formShowParameter.setStatus(this.getView().getFormShowParameter().getStatus());
            }
            formShowParameter.setCustomParam("sharescaletype", (Object)this.getShareScaleType());
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "espformulacb");
            formShowParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(formShowParameter);
        } else if ("bn".equals(key)) {
            CustomControl custom = (CustomControl)this.getView().getControl("invchangeformulatext");
            HashMap dataCache = Maps.newHashMap();
            dataCache.put(key, "Bn()");
            dataCache.put(key + "name", ParamConstant.getBNFORMULACBName());
            this.getPageCache().put((Map)dataCache);
            FormulaServiceHelper.cacheFormula((Map)dataCache);
            custom.setData(CheckedFormulaUtil.packAddText((String)key, (String)ParamConstant.getBNFORMULACBName()));
        } else if ("confirm".equals(key)) {
            CustomControl custom = (CustomControl)this.getView().getControl("invchangeformulatext");
            custom.setData(CheckedFormulaUtil.packGetText());
        } else if ("getinvper".equals(key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bcm_invperformula");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "getinvperformulacb");
            formShowParameter.setCloseCallBack(closeCallBack);
            if (this.isViewStatus()) {
                formShowParameter.setStatus(this.getView().getFormShowParameter().getStatus());
            }
            this.getView().showForm(formShowParameter);
        } else if ("getinvact".equals(key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bcm_invactformula");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "getinvactformulacb");
            formShowParameter.setCloseCallBack(closeCallBack);
            if (this.isViewStatus()) {
                formShowParameter.setStatus(this.getView().getFormShowParameter().getStatus());
            }
            this.getView().showForm(formShowParameter);
        } else if ("desp".equals(key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bcm_despfunctionset");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            formShowParameter.setCustomParam("is_draft", this.getFormCustomParam("is_draft"));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "despformulacb");
            formShowParameter.setCloseCallBack(closeCallBack);
            if (this.isViewStatus()) {
                formShowParameter.setStatus(this.getView().getFormShowParameter().getStatus());
            }
            this.getView().showForm(formShowParameter);
        } else if ("getjlentry".equals(key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bcm_getjlentryformula_inv");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "getjlentryformulacb");
            formShowParameter.setCloseCallBack(closeCallBack);
            if (this.isViewStatus()) {
                formShowParameter.setStatus(this.getView().getFormShowParameter().getStatus());
            }
            this.getView().showForm(formShowParameter);
        } else if ("excrate".equals(key)) {
            this.showVPanel("excrateacbformulacb", null, null);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        String enableStatus;
        super.afterCreateNewData(e);
        this.disableBtn();
        if (!this.isExistChangeTypeDimension()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"inv"});
        }
        if (this.getFormCustomParam(FORMULA) != null) {
            String invFormula = (String)this.getFormCustomParam(FORMULA);
            String fullFormula = FormulaServiceHelper.analyFullFormulaNew((String)invFormula, (IPageCache)this.getPageCache(), (long)this.getModelId());
            CustomControl custom = (CustomControl)this.getView().getControl("invchangeformulatext");
            custom.setData(FormulaServiceHelper.packUpdateText((String)fullFormula));
        }
        if (this.getFormCustomParam(ENABLE) != null && "C".equals(enableStatus = (String)this.getFormCustomParam(ENABLE))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"confirm"});
        }
    }

    private void disableBtn() {
        Object disableBtn = this.getFormCustomParam(DISABLE_BTN);
        if (disableBtn instanceof JSONArray) {
            JSONArray array = (JSONArray)disableBtn;
            for (Object btn : array) {
                this.getView().setVisible(Boolean.FALSE, new String[]{(String)btn});
            }
        }
        if (this.isViewStatus()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"v", "esp"});
        }
    }

    public void customEvent(CustomEventArgs e) {
        String key = e.getEventArgs();
        switch (e.getEventName()) {
            case "f(x)": {
                if (StringUtils.isEmpty((String)key)) {
                    VFormula v = new VFormula();
                    v.initParam(new ParamList());
                    this.showVPanel("formula_fx_", null, v.toString());
                    break;
                }
                if (key.startsWith("formula_fx_")) {
                    this.showVPanel("formula_fx_", key, this.getPageCache().get(key));
                    break;
                }
                if (key.startsWith("invformulacb")) {
                    this.showVPanel("invformulacb", key, this.getPageCache().get(key));
                    break;
                }
                if (key.startsWith("espformulacb")) {
                    this.showVPanel("espformulacb", key, this.getPageCache().get(key));
                    break;
                }
                if (key.startsWith("getinvperformulacb")) {
                    this.showVPanel("getinvperformulacb", key, this.getPageCache().get(key));
                    break;
                }
                if (key.startsWith("getinvactformulacb")) {
                    this.showVPanel("getinvactformulacb", key, this.getPageCache().get(key));
                    break;
                }
                if (key.startsWith("despformulacb")) {
                    this.showVPanel("despformulacb", key, this.getPageCache().get(key));
                    break;
                }
                if (key.startsWith("getjlentryformulacb")) {
                    this.showVPanel("getjlentryformulacb", key, this.getPageCache().get(key));
                    break;
                }
                if (!key.startsWith("excrateacbformulacb")) break;
                this.showVPanel("excrateacbformulacb", key, this.getPageCache().get(key));
                break;
            }
            case "getText": {
                String text = e.getEventArgs();
                HashMap maps = Maps.newHashMap();
                if (StringUtil.isEmptyString((String)text)) {
                    maps.put(FORMULA, "");
                    maps.put("name", "");
                    this.getView().returnDataToParent((Object)maps);
                    this.getView().close();
                    break;
                }
                text = text.replaceAll("\n", "");
                if ((text = text.replaceAll("\\p{C}", "")).contains("{\"bn\"}") && !"{\"bn\"}".equals(text) || text.contains("%")) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"InvChangeFormulaPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                if (this.getPageCache().get("ismodifer") != null) {
                    String data = FormulaServiceHelper.rebuildFormula((String)text, (IPageCache)this.getPageCache());
                    this.getPageCache().remove("ismodifer");
                    CustomControl custom = (CustomControl)this.getView().getControl("invchangeformulatext");
                    custom.setData(FormulaServiceHelper.packUpdateText((String)data));
                    break;
                }
                if (this.isViewStatus()) {
                    this.getView().close();
                    return;
                }
                if (ChkCheckServiceHelper.isChinese((String)text)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u4e2d\u4e0d\u80fd\u5305\u542b\u4e2d\u6587\u548c\u4e2d\u6587\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"InvChangeFormulaPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                LinkedHashMap fullcache = (LinkedHashMap)AppCacheServiceHelper.get((String)"invchangeformulacache");
                if (fullcache != null) {
                    this.getPageCache().put((Map)fullcache);
                }
                String str = FormulaServiceHelper.transFormula((String)text, (IPageCache)this.getPageCache());
                String invFormula = "";
                String formulaName = "";
                if ("@@@".equalsIgnoreCase(str)) {
                    maps.put(FORMULA, "");
                    maps.put("name", "");
                } else {
                    String[] fs = str.split("@@@");
                    invFormula = fs[0];
                    formulaName = fs[1];
                }
                maps.put(FORMULA, invFormula);
                maps.put("name", formulaName);
                ExpressParser parser = new ExpressParser();
                EncoderService encoder = new EncoderService();
                this.ValidateFormula(invFormula);
                try {
                    parser.parse(invFormula, encoder);
                    boolean hasStr = parser.parse2(invFormula, encoder).stream().anyMatch(p -> p instanceof NameExpr);
                    if (hasStr) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"InvChangeFormulaPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                }
                catch (Exception e1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"InvChangeFormulaPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                this.getView().returnDataToParent((Object)maps);
                this.getView().close();
                break;
            }
        }
    }

    private void ValidateFormula(String invFormula) {
        Boolean isInvSheet = (Boolean)this.getFormCustomParam("is_draft");
        if (Boolean.TRUE.equals(isInvSheet) && invFormula.matches(".*[\\=\\>\\<\\\\].*")) {
            throw new KDBizException("\u8868\u6837\u516c\u5f0f\u4e0d\u80fd\u4f7f\u7528\u7b26\u53f7\uff1a\"=\"\u3001\">\"\u3001\"\u2265\"\u3001\"<\"\u3001\"\u2264\"\u3001\"<>\",\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002");
        }
    }

    private void showVPanel(String type, String key, Object param) {
        CloseCallBack closeCallBack;
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_invvformula");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        formShowParameter.setCustomParam("is_draft", this.getFormCustomParam("is_draft"));
        String enable = (String)this.getView().getFormShowParameter().getCustomParam(ENABLE);
        formShowParameter.setCustomParam(ENABLE, (Object)enable);
        FormulaTicketer ticketer = this.buildTicketer(type, key);
        if ("C".equals(enable)) {
            ticketer.forEach(e -> ((FTicket)e.getValue()).setEnable(false));
        }
        formShowParameter.setCustomParam("FormulaTicketer", (Object)this.toByteSerialized(ticketer));
        formShowParameter.setCustomParam(FORMULA, param);
        if (key != null) {
            if ("invformulacb".equals(type)) {
                formShowParameter.setFormId("bcm_invfunctionset");
            } else if ("espformulacb".equals(type)) {
                formShowParameter.setFormId("bcm_espfunctionset");
            } else if ("getinvperformulacb".equals(type)) {
                formShowParameter.setFormId("bcm_invperformula");
            } else if ("getinvactformulacb".equals(type)) {
                formShowParameter.setFormId("bcm_invactformula");
            } else if ("despformulacb".equals(type)) {
                formShowParameter.setFormId("bcm_despfunctionset");
            } else if ("getjlentryformulacb".equals(type)) {
                formShowParameter.setFormId("bcm_getjlentryformula_inv");
            } else if ("excrateacbformulacb".equals(type)) {
                formShowParameter.setCustomParam("formulanumber", (Object)FormulaEnum.ExcRate.getCode().toUpperCase(Locale.ENGLISH));
                formShowParameter.setFormId("bcm_invexrateformula");
            }
            closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        } else if ("formula_fx_".equals(type)) {
            closeCallBack = new CloseCallBack((IFormPlugin)this, "formulacb");
        } else if ("espformulacb".equals(type)) {
            formShowParameter.setFormId("bcm_espfunctionset");
            closeCallBack = new CloseCallBack((IFormPlugin)this, "espformulacb");
        } else if ("excrateacbformulacb".equals(type)) {
            formShowParameter.setCustomParam("formulanumber", (Object)FormulaEnum.ExcRate.getCode().toUpperCase(Locale.ENGLISH));
            formShowParameter.setFormId("bcm_invexrateformula");
            closeCallBack = new CloseCallBack((IFormPlugin)this, "excrateacbformulacb");
        } else {
            formShowParameter.setFormId("bcm_invfunctionset");
            closeCallBack = new CloseCallBack((IFormPlugin)this, "invformulacb");
        }
        if (this.isViewStatus()) {
            formShowParameter.setStatus(this.getView().getFormShowParameter().getStatus());
        }
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    private FormulaTicketer buildTicketer(String type, String key) {
        FormulaTicketer ticketer = new FormulaTicketer();
        if ("excrateacbformulacb".equals(type)) {
            Formula formula = ResourcesLoaderUtil.getFormulaByNumber((String)FormulaEnum.ExcRate.getCode().toLowerCase(Locale.ENGLISH));
            return InvestFormulaRegisterHelper.buildExcRateTicketer(formula, this.getModelId());
        }
        IValidate notnull = (IValidate)IValidate.build(NotNullValidate.class);
        DynamicObjectCollection alldims = QueryDimensionServiceHelper.getDimensionBaseInfos((Object)this.getModelId());
        for (DynamicObject obj : alldims) {
            String sign;
            String entity = obj.getString("membermodel");
            String number = obj.getString("number");
            String name = obj.getString("name");
            if ("bcm_entitymembertree".equals(entity) || "bcm_icmembertree".equals(entity) || "bcm_mycompanymembertree".equals(entity) || "bcm_currencymembertree".equals(entity)) {
                ticketer.addTicket(entity, new FTicket(entity, name, null, false, false));
                continue;
            }
            if ("bcm_accountmembertree".equals(entity) || "bcm_changetypemembertree".equals(entity) || "bcm_userdefinedmembertree".equals(entity) || "bcm_audittrialmembertree".equals(entity)) {
                sign = this.sugarF7Key(entity, number);
                ticketer.addTicket(sign, new FTicket(entity, name, notnull, true, true, true));
                continue;
            }
            if ("bcm_scenemembertree".equals(entity) || "bcm_fymembertree".equals(entity) || "bcm_periodmembertree".equals(entity) || "bcm_processmembertree".equals(entity)) {
                ticketer.addTicket(entity, new FTicket(entity, name, null, true, true));
                continue;
            }
            sign = this.sugarF7Key(entity, number);
            ticketer.addTicket(sign, new FTicket(entity, name, notnull, true, true, true));
        }
        return ticketer;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String key = e.getActionId();
        CustomControl custom = (CustomControl)this.getView().getControl("invchangeformulatext");
        Object data = e.getReturnData();
        if (data != null) {
            HashMap dataCache = Maps.newHashMapWithExpectedSize((int)16);
            if (key.equals("invformulacb")) {
                String sign = FormulaServiceHelper.getComboSign((String)"invformulacb");
                String invFormula = ((HashMap)data).get(FORMULA).toString();
                String invFormulaName = ((HashMap)data).get("name").toString();
                custom.setData(CheckedFormulaUtil.packAddText((String)sign, (String)invFormulaName));
                dataCache.put(sign, invFormula);
                dataCache.put(sign + "name", invFormulaName);
            } else if (key.equals("espformulacb")) {
                String sign = FormulaServiceHelper.getComboSign((String)"espformulacb");
                String espformula = ((HashMap)data).get(FORMULA).toString();
                String espformulaName = ((HashMap)data).get("name").toString();
                dataCache.put(sign, espformula);
                dataCache.put(sign + "name", espformulaName);
                custom.setData(CheckedFormulaUtil.packAddText((String)sign, (String)espformulaName));
            } else if (key.equals("formulacb")) {
                String sign = FormulaServiceHelper.getComboSign((String)"formula_fx_");
                String vformula = data.toString();
                dataCache.put(sign, vformula);
                try {
                    String returnData = InvestServiceHelper.translateInvformla((String)vformula, (long)this.getModelId());
                    dataCache.put(sign + "name", returnData);
                    custom.setData(CheckedFormulaUtil.packAddText((String)sign, (String)returnData));
                }
                catch (Exception e1) {
                    log.error("error", (Throwable)e1);
                }
            } else if (key.equals("getinvperformulacb")) {
                String sign = FormulaServiceHelper.getComboSign((String)"getinvperformulacb");
                String invFormula = ((HashMap)data).get(FORMULA).toString();
                String invFormulaName = ((HashMap)data).get("name").toString();
                custom.setData(CheckedFormulaUtil.packAddText((String)sign, (String)invFormulaName));
                dataCache.put(sign, invFormula);
                dataCache.put(sign + "name", invFormulaName);
            } else if (key.equals("getinvactformulacb")) {
                String sign = FormulaServiceHelper.getComboSign((String)"getinvactformulacb");
                String invFormula = ((HashMap)data).get(FORMULA).toString();
                String invFormulaName = ((HashMap)data).get("name").toString();
                custom.setData(CheckedFormulaUtil.packAddText((String)sign, (String)invFormulaName));
                dataCache.put(sign, invFormula);
                dataCache.put(sign + "name", invFormulaName);
            } else if (key.equals("despformulacb")) {
                String sign = FormulaServiceHelper.getComboSign((String)"despformulacb");
                String invFormula = ((HashMap)data).get(FORMULA).toString();
                String invFormulaName = ((HashMap)data).get("name").toString();
                custom.setData(CheckedFormulaUtil.packAddText((String)sign, (String)invFormulaName));
                dataCache.put(sign, invFormula);
                dataCache.put(sign + "name", invFormulaName);
            } else if (key.equals("excrateacbformulacb")) {
                String sign = FormulaServiceHelper.getComboSign((String)"excrateacbformulacb");
                String invFormula = data.toString();
                String invFormulaName = ResManager.loadKDString((String)"\u6c47\u7387", (String)"InvChangeFormulaPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                custom.setData(CheckedFormulaUtil.packAddText((String)sign, (String)invFormulaName));
                dataCache.put(sign, invFormula);
                dataCache.put(sign + "name", invFormulaName);
            } else if (key.equals("getjlentryformulacb")) {
                String sign = FormulaServiceHelper.getComboSign((String)"getjlentryformulacb");
                String invFormula = data.toString();
                String invFormulaName = ResManager.loadKDString((String)"\u5206\u5f55\u6570", (String)"InvChangeFormulaPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                custom.setData(CheckedFormulaUtil.packAddText((String)sign, (String)invFormulaName));
                dataCache.put(sign, invFormula);
                dataCache.put(sign + "name", invFormulaName);
            } else {
                if (key.startsWith("invformulacb")) {
                    String invFormula = ((HashMap)data).get(FORMULA).toString();
                    String invFormulaName = ((HashMap)data).get("name").toString();
                    dataCache.put(key, invFormula);
                    dataCache.put(key + "name", invFormulaName);
                } else if (key.startsWith("espformulacb")) {
                    String espformula = ((HashMap)data).get(FORMULA).toString();
                    String espformulaName = ((HashMap)data).get("name").toString();
                    dataCache.put(key, espformula);
                    dataCache.put(key + "name", espformulaName);
                } else if (key.startsWith("getinvperformulacb") || key.startsWith("getinvactformulacb") || key.startsWith("despformulacb")) {
                    String formula = ((HashMap)data).get(FORMULA).toString();
                    String formulaName = ((HashMap)data).get("name").toString();
                    dataCache.put(key, formula);
                    dataCache.put(key + "name", formulaName);
                } else if (key.startsWith("formula_fx_")) {
                    String vformula = data.toString();
                    try {
                        String vFormulaName = InvestServiceHelper.translateInvformla((String)vformula, (long)this.getModelId());
                        dataCache.put(key, vformula);
                        dataCache.put(key + "name", vFormulaName);
                    }
                    catch (Exception e1) {
                        log.error("error", (Throwable)e1);
                    }
                } else if (key.startsWith("getjlentryformulacb")) {
                    String formula = data.toString();
                    String formulaName = ResManager.loadKDString((String)"\u5206\u5f55\u6570", (String)"InvChangeFormulaPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    try {
                        dataCache.put(key, formula);
                        dataCache.put(key + "name", formulaName);
                    }
                    catch (Exception e1) {
                        log.error("error", (Throwable)e1);
                    }
                } else if (key.startsWith("excrateacbformulacb")) {
                    String formula = data.toString();
                    String formulaName = ResManager.loadKDString((String)"\u6c47\u7387", (String)"InvChangeFormulaPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    try {
                        dataCache.put(key, formula);
                        dataCache.put(key + "name", formulaName);
                    }
                    catch (Exception e1) {
                        log.error("error", (Throwable)e1);
                    }
                }
                dataCache.put("ismodifer", "1");
                custom.setData(CheckedFormulaUtil.packGetText());
            }
            this.getPageCache().put((Map)dataCache);
            FormulaServiceHelper.cacheFormula((Map)dataCache);
        }
    }

    private String getShareScaleType() {
        String sharescaletype = (String)this.getFormCustomParam("sharescaletype");
        return StringUtils.isNotEmpty((String)sharescaletype) ? sharescaletype : "1";
    }
}

