/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.helper.InvRelationTypeHelper;
import kd.fi.bcm.business.papertemplate.PaperTemplateService;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;

public class InvChangeTypeListPlugin
extends AbstractBaseListPlugin {
    public void setFilter(SetFilterEvent e) {
        Object modelid = this.getView().getFormShowParameter().getCustomParam("model");
        e.getQFilters().add(new QFilter("model", "=", modelid));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        Object modelid = this.getView().getFormShowParameter().getCustomParam("model");
        if (modelid != null) {
            this.getPageCache().put("KEY_MODEL_ID", modelid.toString());
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("bar_del".equals(key)) {
            boolean hasDefault;
            BillList billlist = (BillList)this.getControl("billlistap");
            Map<Object, String> idNumberMap = billlist.getSelectedRows().stream().collect(Collectors.toMap(ListSelectedRow::getPrimaryKeyValue, ListSelectedRow::getNumber));
            Set<Object> ids = idNumberMap.keySet();
            QFBuilder qf = new QFBuilder("id", "in", ids);
            qf.and("isdefault", "=", (Object)true);
            DynamicObjectCollection defaultdata = QueryServiceHelper.query((String)"bcm_invchangetype", (String)"id", (QFilter[])qf.toArray());
            boolean bl = hasDefault = !defaultdata.isEmpty();
            if (hasDefault) {
                String numbermsg = this.buildMsg(idNumberMap, defaultdata.stream().map(t -> t.get("id")), defaultdata.size());
                String msg = String.format(ResManager.loadKDString((String)"[%s]\u4e3a\u9884\u7f6e\u6570\u636e\uff0c\u4e0d\u53ef\u5220\u9664\uff01", (String)"InvChangeTypeListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), numbermsg);
                this.getView().showErrorNotification(msg);
                evt.setCancel(true);
                return;
            }
            long modelId = this.getModelId();
            Set<String> numbers = billlist.getSelectedRows().stream().map(ListSelectedRow::getNumber).collect(Collectors.toSet());
            ArrayList<String> checkRs = new ArrayList<String>(16);
            this.paperUseCheck(modelId, numbers, checkRs);
            this.orgUseCheck(modelId, numbers, checkRs);
            if (!checkRs.isEmpty()) {
                String deleteFail = ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002", (String)"InvChangeTypeListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(deleteFail, String.join((CharSequence)"\n", checkRs), MessageBoxOptions.OK, ConfirmTypes.Default, null);
                evt.setCancel(true);
                return;
            }
        }
    }

    private void orgUseCheck(long modelId, Set<String> numbers, List<String> checkRs) {
        OrgServiceHelper.checkChangeTypeUsed((long)modelId, numbers, (changeTypeNumber, orgLongNumber) -> {
            String msg = String.format(ResManager.loadKDString((String)"[%1$s]\u5df2\u88ab\u7ec4\u7ec7\u7ef4\u5ea6\u6210\u5458[%2$s]\u4e1a\u52a1\u53d8\u66f4\u7c7b\u578b\u5f15\u7528", (String)"InvChangeTypeListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), changeTypeNumber, orgLongNumber);
            checkRs.add(msg);
        });
    }

    private void paperUseCheck(long modelId, Set<String> numbers, List<String> checkRs) {
        Map relationTypeId2Numbers = InvRelationTypeHelper.getIdsByNumber((long)modelId, numbers);
        PaperTemplateService.checkRelationTypeUsed(relationTypeId2Numbers.keySet(), (paperNumber, relationTypeId) -> {
            String msg = String.format(ResManager.loadKDString((String)"[%1$s]\u5df2\u88ab\u6743\u76ca\u62b5\u9500\u5e95\u7a3f\u6a21\u677f\u3010%2$s\u3011\u5f15\u7528", (String)"InvChangeTypeListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), relationTypeId2Numbers.get(relationTypeId), paperNumber);
            checkRs.add(msg);
        });
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        InvestServiceHelper.clearInvChangetypeSettingCache((Long)this.getModelId());
    }

    private String buildMsg(Map<Object, String> idNumberMap, Stream<Object> stream, int sz) {
        StringJoiner idmsg = new StringJoiner(",");
        stream.limit(3L).forEach(id -> idmsg.add((CharSequence)idNumberMap.get(id)));
        return sz > 3 ? idmsg.toString() + "..." : idmsg.toString();
    }
}

