/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.model.ChangeTypeModel;
import kd.fi.bcm.common.constant.invest.sharerela.InvRelationTypeConstant;
import kd.fi.bcm.common.enums.OrgBizChangeTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class InvChangeTypePlugin
extends AbstractBaseFormPlugin {
    public static final String BTN_SAVE = "bar_save";
    public static final String NUMBER = "number";
    public static final String CHANGE = "change";
    public static final String BCM_INVCHANGETYPE = "bcm_invchangetype";
    public static final String NAME = "name";

    @Override
    public void afterCreateNewData(EventObject e) {
        Object modelid = this.getView().getParentView().getFormShowParameter().getCustomParam("model");
        this.getModel().setValue("model", modelid);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String number = (String)this.getModel().getValue(NUMBER);
        if (this.isEditStatus() && BTN_SAVE.equals(evt.getItemKey())) {
            QFilter invtypeFilter;
            Iterable bizChangedProperties = this.getModel().getDataEntity().getDataEntityState().getBizChangedProperties();
            Iterator iterator = bizChangedProperties.iterator();
            ArrayList<String> changedProperties = new ArrayList<String>(4);
            while (iterator.hasNext()) {
                changedProperties.add(((IDataEntityProperty)iterator.next()).getName());
            }
            if (!changedProperties.contains(CHANGE) && !changedProperties.contains("relatedchangetype")) {
                return;
            }
            QFilter modelFilter = new QFilter("model", "=", (Object)this.getModelId());
            DynamicObject invchangetype = QueryServiceHelper.queryOne((String)BCM_INVCHANGETYPE, (String)"id,name,change,number", (QFilter[])new QFilter[]{modelFilter, invtypeFilter = new QFilter(NUMBER, "=", (Object)number)});
            if (invchangetype != null) {
                String oldChange = (String)invchangetype.get(CHANGE);
                String oldName = (String)invchangetype.get(NAME);
                String oldNumber = (String)invchangetype.get(NUMBER);
                if (QueryServiceHelper.exists((String)"bcm_entitymembertree", (QFilter[])new QFBuilder("bizchangerds.changetype", "=", (Object)oldNumber).and(modelFilter).toArray())) {
                    String msg = ResManager.loadKDString((String)"\u5df2\u88ab\u7ec4\u7ec7\u7ef4\u5ea6\u4e1a\u52a1\u53d8\u66f4\u7c7b\u578b\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5408\u5e76\u8303\u56f4\u53d8\u52a8\u65b9\u5f0f\u3002", (String)"InvChangeTypePlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(msg);
                    this.getModel().setValue(CHANGE, (Object)oldChange);
                    this.getModel().setValue(NAME, (Object)oldName);
                    evt.setCancel(true);
                    return;
                }
                if (QueryServiceHelper.exists((String)"bcm_invsharerela", (QFilter[])new QFBuilder("invchangetype.number", "=", (Object)oldNumber).and(modelFilter).toArray())) {
                    String msg = ResManager.loadKDString((String)"\u5df2\u88ab\u80a1\u6743\u4fe1\u606f\u7ef4\u62a4\u4e1a\u52a1\u53d8\u52a8\u7c7b\u578b\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5408\u5e76\u8303\u56f4\u53d8\u52a8\u65b9\u5f0f\u3002", (String)"InvChangeTypePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(msg);
                    this.getModel().setValue(CHANGE, (Object)oldChange);
                    this.getModel().setValue(NAME, (Object)oldName);
                    evt.setCancel(true);
                    return;
                }
            }
        } else if (this.isAddNewStatus() && BTN_SAVE.equals(evt.getItemKey()) && InvRelationTypeConstant.getCode2InvRelaTypeEnum().containsKey(number)) {
            String msg = ResManager.loadKDString((String)"%1$s\u5df2\u88ab\u7cfb\u7edf\u9884\u7f6e\u5360\u7528\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u3002", (String)"InvChangeTypePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(String.format(msg, number));
            evt.setCancel(true);
            return;
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("relatedchangetype".equals(key)) {
            DynamicObject newValueDy = (DynamicObject)e.getChangeSet()[0].getNewValue();
            String newChangeType = newValueDy == null ? "" : newValueDy.getString(NUMBER);
            this.getModel().setValue(CHANGE, InvestServiceHelper.getInvChangetypeSetting((Long)this.getModelId()).get(newChangeType));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        InvestServiceHelper.clearInvChangetypeSettingCache((Long)this.getModelId());
        if (afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{NUMBER});
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("tbmain");
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("relatedchangetype");
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        if (((BasedataEdit)e.getSource()).getKey().equals("relatedchangetype")) {
            Map changeTypeModelMap = InvestServiceHelper.getInvChangetypeModel((Long)this.getModelId());
            ((ListShowParameter)e.getFormShowParameter()).setListFilterParameter(new ListFilterParameter(new QFBuilder("id", "in", changeTypeModelMap.values().stream().filter(p -> OrgBizChangeTypeEnum.sameControlNewlyAdded.getValue().equals(p.number()) || OrgBizChangeTypeEnum.liquidationDisposal.getValue().equals(p.number()) || OrgBizChangeTypeEnum.sameControlDisposal.getValue().equals(p.number()) || OrgBizChangeTypeEnum.mergerNewlyAdded.getValue().equals(p.number()) || OrgBizChangeTypeEnum.newSetMergeEnable.getValue().equals(p.number()) || OrgBizChangeTypeEnum.newSetMergeDisable.getValue().equals(p.number())).map(ChangeTypeModel::getId).collect(Collectors.toList())).toList(), null));
        }
    }
}

