/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.invest.InvSheetTemplateService;
import kd.fi.bcm.business.invest.changecase.InvChangeTypeServiceHelper;
import kd.fi.bcm.business.invest.helper.InvDynamicStockRatioHelper;
import kd.fi.bcm.business.invest.relation.InvRelationLogContext;
import kd.fi.bcm.business.invest.relation.InvRelationLogService;
import kd.fi.bcm.business.invest.service.InvShareholdingValidator;
import kd.fi.bcm.business.invest.service.InvValidateHelper;
import kd.fi.bcm.business.invest.service.InvValidator;
import kd.fi.bcm.business.invest.sheet.GlobalIdDistributer;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.sharerela.InvDynamicStockRatioConstant;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.impexport.BillResult;
import kd.fi.bcm.formplugin.invest.InvShareRelaImportNewPlugin;

public class InvDynamicStockRadioImportPlugin
extends BatchImportPlugin {
    private static Log log = LogFactory.getLog(InvShareRelaImportNewPlugin.class);
    private static final String FI_BCM_FORM_PLUGIN = "fi-bcm-formplugin";
    private int seq;
    private DynamicObject model;
    private DynamicObject scenario;
    private DynamicObject year;
    private DynamicObject period;
    private Map<String, Long> mergeNumber2BaseId;
    private long selectedNodeId;
    private Map<String, Long> limTempNumber2Dy;
    private Map<String, Long> tempNumberToGroup;
    private final Table<String, String, Long> sheetEntryTable = HashBasedTable.create();

    protected boolean isForceBatch() {
        return true;
    }

    protected int getBatchImportSize() {
        return 50000;
    }

    public void beforeSave(List<ImportBillData> billDatas, ImportLogger logger) {
        this.intModelAndPermMap();
        if (Objects.isNull(this.model) || Objects.isNull(this.year) || Objects.isNull(this.scenario) || Objects.isNull(this.period) || Objects.isNull(this.mergeNumber2BaseId) || this.mergeNumber2BaseId.isEmpty() || this.selectedNodeId == 0L) {
            billDatas.clear();
            this.writeOperationLog(ResManager.loadKDString((String)"F7\u7ef4\u5ea6\u4fe1\u606f\u4e0d\u8db3 \u3002", (String)"InvDynamicStockRadioImportPlugin_2", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), billDatas.size(), 0);
        }
        super.beforeSave(billDatas, logger);
    }

    public ApiResult save(List<ImportBillData> importBillDataList, ImportLogger logger) {
        ApiResult result = new ApiResult();
        result.setSuccess(true);
        long modelId = this.model.getLong("id");
        long yearId = this.year.getLong("id");
        long scenarioId = this.scenario.getLong("id");
        long periodId = this.period.getLong("id");
        Collection<Long> baseIds = this.mergeNumber2BaseId.values();
        InvRelationLogContext logContext = new InvRelationLogContext(modelId, scenarioId, yearId, periodId, MemberReader.findEntityMemberById((Long)modelId, (Long)baseIds.iterator().next()).getBaseTreeNode().getId().longValue());
        InvRelationLogService invRelationLogService = InvRelationLogService.logWithoutStaticChange((InvRelationLogContext)logContext);
        DynamicObjectCollection dynamicObjects = InvDynamicStockRatioHelper.loadGroupChangeTypeRelation((long)scenarioId, (long)yearId, (long)periodId, Collections.emptyList(), baseIds, (String)InvDynamicStockRatioConstant.getSelectFields((String[])new String[]{"shareholder.number", "investeecompany.number", "invchangetype.number", "invchangetype.name"}));
        Map<String, DynamicObject> collect = dynamicObjects.stream().peek(dy -> {
            this.seq = Math.max(this.seq, dy.getInt("seqnum"));
        }).collect(Collectors.toMap(this::generateKey, e -> e, (v1, v2) -> v1));
        this.effectTempCanUse(modelId, yearId, periodId);
        DynamicObjectCollection changeTypes = InvChangeTypeServiceHelper.findChangeType((long)modelId);
        Map<String, DynamicObject> changeTypeNumber2Id = changeTypes.stream().collect(Collectors.toMap(e -> e.getString("number"), e -> e, (v1, v2) -> v1));
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        HashSet<DynamicObject> needUpdateData = new HashSet<DynamicObject>(16);
        HashSet<DynamicObject> needNewSaveData = new HashSet<DynamicObject>(16);
        GlobalIdDistributer idDistributor = new GlobalIdDistributer();
        Date now = TimeServiceHelper.now();
        Long userId = RequestContext.get().getCurrUserId();
        ImportOperateType importType = ImportHelper.getImportType(this.ctx);
        ArrayList<Map<String, Object>> rowRs = new ArrayList<Map<String, Object>>(16);
        InvValidateHelper<JSONObject> jsonValidateHelper = this.jsonObjectValidateHelper();
        InvValidateHelper<DynamicObject> dynamicValidateHelper = this.dynObjectValidateHelper();
        for (int i = 0; i < importBillDataList.size(); ++i) {
            Runnable runLog;
            Consumer<DynamicObject> renderDataCompute;
            ImportBillData importBillData = importBillDataList.get(i);
            JSONObject data = importBillData.getData();
            String key = this.generateKey(data);
            DynamicObject dynamicObject = collect.get(key);
            BillResult rs = this.validationData(importType, data, key, dynamicObject, jsonValidateHelper);
            rs.setIndex(i);
            JSONObject obj = data.getJSONObject("merge");
            if (obj != null && !PeriodSettingHelper.checkPeriodStatus((long)modelId, (String)obj.getString("number"), (long)scenarioId, (long)yearId, (long)periodId, (String)"datastatus")) {
                rs.setSucess(Boolean.FALSE);
                rs.setMessage(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%s\u6570\u636e\u671f\u95f4\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"InvDynamicStockRadioImportPlugin_5", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), obj.getString("number")));
            }
            if (!rs.isSucess()) {
                result.setSuccess(false);
                rowRs.add(rs.toMap());
                continue;
            }
            DynamicObject changeTypeDy = changeTypeNumber2Id.get(this.getNumberFromJson(data, "invchangetype"));
            DynamicObject newDynObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_dynamicstockratio");
            if (Objects.nonNull(dynamicObject)) {
                DynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)newDynObject);
                newDynObject.set("id", (Object)dynamicObject.getLong("id"));
                renderDataCompute = needUpdateData::add;
                if (InvDynamicStockRatioConstant.StatusEnum.DISABLE.getCode().equals(dynamicObject.getString("status"))) {
                    newDynObject.set("seqnum", (Object)(++this.seq));
                    runLog = () -> invRelationLogService.logDynamicAddNew(newDynObject, changeTypeDy);
                } else {
                    runLog = () -> invRelationLogService.logDynamicModify(newDynObject, dynamicObject, changeTypeDy);
                }
            } else {
                newDynObject.set("id", (Object)idDistributor.getLongId());
                newDynObject.set("seqnum", (Object)(++this.seq));
                renderDataCompute = needNewSaveData::add;
                runLog = () -> invRelationLogService.logDynamicAddNew(newDynObject, changeTypeDy);
            }
            newDynObject.set("model", this.getF7Id(data, this.model, "model", "shownumber"));
            newDynObject.set("scenario", this.getF7Id(data, this.scenario, "scenario", "number"));
            newDynObject.set("year", this.getF7Id(data, this.year, "year", "number"));
            newDynObject.set("period", this.getF7Id(data, this.period, "period", "number"));
            newDynObject.set("merge", this.getBaseId(data, this.mergeNumber2BaseId, "merge"));
            newDynObject.set("shareholder", (Object)this.getMemberId(modelNum, data, DimTypesEnum.INTERCOMPANY.getNumber(), "shareholder"));
            newDynObject.set("investeecompany", (Object)this.getMemberId(modelNum, data, DimTypesEnum.ENTITY.getNumber(), "investeecompany"));
            Long changTypeId = changeTypeDy == null ? 0L : changeTypeDy.getLong("id");
            newDynObject.set("invchangetype", (Object)changTypeId);
            newDynObject.set("openscale", (Object)data.getBigDecimal("openscale"));
            newDynObject.set("sharescale", (Object)data.getBigDecimal("sharescale"));
            newDynObject.set("changescale", (Object)data.getBigDecimal("changescale"));
            newDynObject.set("confirmopenscale", (Object)data.getBigDecimal("confirmopenscale"));
            newDynObject.set("confirmsharescale", (Object)data.getBigDecimal("confirmsharescale"));
            newDynObject.set("confirmchangescale", (Object)data.getBigDecimal("confirmchangescale"));
            newDynObject.set("level", (Object)InvDynamicStockRatioConstant.LevelEnum.GROUP_CHANGE_TYPE.getCode());
            newDynObject.set("status", (Object)InvDynamicStockRatioConstant.StatusEnum.ENABLE.getCode());
            newDynObject.set("modifierid", (Object)userId);
            newDynObject.set("modifytime", (Object)now);
            newDynObject.set("sharecase", (Object)0L);
            DynamicObjectCollection limTemplate = newDynObject.getDynamicObjectCollection("invelimtemplate");
            limTemplate.clear();
            DynamicObjectCollection effectTemps = newDynObject.getDynamicObjectCollection("effecttemp");
            Pair<Set<String>, Set<String>> warringNumbers = this.importTemplate(data, effectTemps);
            Pair<Set<String>, Set<String>> warringNewNumbers = this.importNewTemplate(data, effectTemps);
            List dyCheckRs = dynamicValidateHelper.doValidate((Object)newDynObject);
            this.addTemplateCheckMsg(warringNumbers, dyCheckRs);
            this.addNewTemplateCheckMsg(warringNewNumbers, dyCheckRs);
            if (!dyCheckRs.isEmpty()) {
                rs.setMessage(String.join((CharSequence)" ", dyCheckRs));
                rs.setSucess(false);
                result.setSuccess(false);
                rowRs.add(rs.toMap());
                continue;
            }
            rs.setId(newDynObject.getLong("id"));
            rowRs.add(rs.toMap());
            renderDataCompute.accept(newDynObject);
            runLog.run();
        }
        InvDynamicStockRatioHelper.newAddSave(needNewSaveData);
        InvDynamicStockRatioHelper.updateDynStockRadioInfo(needUpdateData);
        invRelationLogService.saveLogs(InvRelationLogService.OperationEnum.IMPORT_DYNAMIC);
        result.setData(rowRs);
        this.logSuccess(importBillDataList, logger, needUpdateData, needNewSaveData);
        return result;
    }

    private void effectTempCanUse(long modelId, long yearId, long periodId) {
        QFilter[] filters = new QFilter[]{new QFilter("model", "=", (Object)modelId)};
        DynamicObjectCollection limTempDys = QueryServiceHelper.query((String)"bcm_invelimtemplatebase", (String)"id,number", (QFilter[])filters);
        this.limTempNumber2Dy = limTempDys.stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getLong("id"), (v1, v2) -> v1));
        DynamicObjectCollection sheetTemp = InvSheetTemplateService.querySheetTemp((Long)modelId, (Long)yearId, (Long)periodId);
        this.tempNumberToGroup = sheetTemp.stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getLong("group"), (v1, v2) -> v1));
        List sheetTempIds = sheetTemp.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        QFBuilder qfSheetEntryBuilder = new QFBuilder("sheettemplate", "in", sheetTempIds);
        String selectFields = "id,number,sheettemplate.number";
        DynamicObjectCollection sheetEntries = QueryServiceHelper.query((String)"bcm_invsheetttplentrys", (String)selectFields, (QFilter[])qfSheetEntryBuilder.toArray());
        for (DynamicObject dy2 : sheetEntries) {
            long sheetEntryId = dy2.getLong("id");
            String sheetEntryNumber = dy2.getString("number");
            String tempNumber = dy2.getString("sheettemplate.number");
            this.sheetEntryTable.put((Object)tempNumber, (Object)sheetEntryNumber, (Object)sheetEntryId);
        }
    }

    private void addNewTemplateCheckMsg(Pair<Set<String>, Set<String>> warringNewNumbers, List<String> dyCheckRs) {
        Set isExceptOutOfEnum;
        Set noThisTempNumbers = (Set)warringNewNumbers.p1;
        if (!noThisTempNumbers.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0d\u5b58\u5728\u6a21\u677f\u7f16\u7801|\u5206\u5f55\u7f16\u7801\u4e3a%1$s\u7684\u5e95\u7a3f\u6a21\u677f\u5206\u5f55\u914d\u7f6e\u3002", (String)"InvDynamicStockRadioImportPlugin_6", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
            dyCheckRs.add(String.format(msg, String.join((CharSequence)"\u3001", noThisTempNumbers)));
        }
        if (!(isExceptOutOfEnum = (Set)warringNewNumbers.p2).isEmpty()) {
            String msg = ResManager.loadKDString((String)"%1$s\u8d85\u51fa\u662f\u5426\u9002\u7528\u53d6\u503c\u8303\u56f4{0\uff1a\u9002\u7528\uff0c1\uff1a\u4f8b\u5916}", (String)"InvDynamicStockRadioImportPlugin_7", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
            dyCheckRs.add(String.format(msg, String.join((CharSequence)"\u3001", isExceptOutOfEnum)));
        }
    }

    private Pair<Set<String>, Set<String>> importNewTemplate(JSONObject data, DynamicObjectCollection effectTemps) {
        String[] numbers;
        HashSet<String> noThisTempNumbers = new HashSet<String>(16);
        HashSet<String> isExceptOutOfEnum = new HashSet<String>(16);
        for (String number : numbers = Optional.ofNullable(data.getString("effectnewtempnumbers")).map(templates -> templates.split(",")).orElseGet(() -> new String[0])) {
            String sheetEntryNumber;
            String tempNumber;
            Long id;
            String[] tempNumbers;
            String[] numberAndIsExceptConfig = number.split("@");
            if (numberAndIsExceptConfig.length < 2 || (tempNumbers = numberAndIsExceptConfig[0].split("\\|")).length < 2 || (id = (Long)this.sheetEntryTable.get((Object)(tempNumber = tempNumbers[0]), (Object)(sheetEntryNumber = tempNumbers[1]))) == null) {
                noThisTempNumbers.add(number);
                continue;
            }
            String isExcept = numberAndIsExceptConfig[1];
            if (InvDynamicStockRatioConstant.ExceptEnum.getExceptByCode((String)isExcept) == null) {
                isExceptOutOfEnum.add(isExcept);
                continue;
            }
            DynamicObject configRow = effectTemps.addNew();
            Long group = this.tempNumberToGroup.getOrDefault(tempNumber, 0L);
            configRow.set("temtype", (Object)"bcm_invsheetttplentrys");
            configRow.set("temp", (Object)id);
            configRow.set("isexcept", (Object)isExcept);
            configRow.set("group", (Object)group);
            configRow.set("number", (Object)sheetEntryNumber);
        }
        return Pair.onePair(noThisTempNumbers, isExceptOutOfEnum);
    }

    private void addTemplateCheckMsg(Pair<Set<String>, Set<String>> setSetPair, List<String> dyCheckRs) {
        Set isExceptOutOfEnum;
        Set noThisTempNumbers = (Set)setSetPair.p1;
        if (!noThisTempNumbers.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%1$s\u7684\u6743\u76ca\u6a21\u677f\u3002", (String)"InvDynamicStockRadioImportPlugin_8", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
            dyCheckRs.add(String.format(msg, String.join((CharSequence)"\u3001", noThisTempNumbers)));
        }
        if (!(isExceptOutOfEnum = (Set)setSetPair.p2).isEmpty()) {
            String msg = ResManager.loadKDString((String)"%1$s\u8d85\u51fa\u662f\u5426\u9002\u7528\u53d6\u503c\u8303\u56f4{0\uff1a\u9002\u7528\uff0c1\uff1a\u4f8b\u5916}", (String)"InvDynamicStockRadioImportPlugin_7", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
            dyCheckRs.add(String.format(msg, String.join((CharSequence)"\u3001", isExceptOutOfEnum)));
        }
    }

    private Pair<Set<String>, Set<String>> importTemplate(JSONObject data, DynamicObjectCollection limTemplate) {
        String[] numbers;
        HashSet<String> noThisTempNumbers = new HashSet<String>(16);
        HashSet<String> isExceptOutOfEnum = new HashSet<String>(16);
        for (String number : numbers = Optional.ofNullable(data.getString("invelimtemplatenumbers")).map(templates -> templates.split(",")).orElseGet(() -> new String[0])) {
            Long id;
            String isExcept = InvDynamicStockRatioConstant.ExceptEnum.APPLICABLE.getCode();
            if (number.contains("@")) {
                String[] split = number.split("@");
                number = split[0];
                isExcept = split[1];
            }
            if ((id = this.limTempNumber2Dy.get(number)) == null) {
                noThisTempNumbers.add(number);
                continue;
            }
            if (InvDynamicStockRatioConstant.ExceptEnum.getExceptByCode((String)isExcept) == null) {
                isExceptOutOfEnum.add(isExcept);
                continue;
            }
            DynamicObject configRow = limTemplate.addNew();
            configRow.set("temtype", (Object)"bcm_invelimtemplatebase");
            configRow.set("temp", (Object)id);
            configRow.set("isexcept", (Object)isExcept);
        }
        return Pair.onePair(noThisTempNumbers, isExceptOutOfEnum);
    }

    private Object getF7Id(JSONObject data, DynamicObject f7Dy, String member, String number) {
        if (data.getJSONObject(member).get((Object)number).equals(f7Dy.getString(number))) {
            return f7Dy.get("id");
        }
        return null;
    }

    private Object getBaseId(JSONObject data, Map<String, Long> mergeNumber2BaseId, String member) {
        return mergeNumber2BaseId.getOrDefault(data.getJSONObject(member).getString("number"), null);
    }

    private BillResult validationData(ImportOperateType importType, JSONObject data, String key, DynamicObject dynamicObject, InvValidateHelper<JSONObject> validate) {
        String msg;
        BillResult rs = new BillResult();
        rs.setSucess(true);
        rs.setData((Map<String, Object>)data);
        List validateRs = validate.doValidate((Object)data);
        if (dynamicObject != null && ImportOperateType.NEW == importType && InvDynamicStockRatioConstant.StatusEnum.ENABLE.getCode().equals(dynamicObject.getString("status"))) {
            msg = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5408\u5e76\u8282\u70b9+\u6295\u8d44\u5355\u4f4d+\u88ab\u6295\u5355\u4f4d+\u53d8\u66f4\u7c7b\u578b\u3010%1$s\u3011\u7684\u52a8\u6001\u80a1\u6bd4\u5173\u7cfb\u3002", (String)"InvDynamicStockRadioImportPlugin_0", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
            validateRs.add(String.format(msg, key));
        }
        if (ImportOperateType.OVERRIDE == importType && (dynamicObject == null || InvDynamicStockRatioConstant.StatusEnum.DISABLE.getCode().equals(dynamicObject.getString("status")))) {
            msg = ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5408\u5e76\u8282\u70b9+\u6295\u8d44\u5355\u4f4d+\u88ab\u6295\u5355\u4f4d+\u53d8\u66f4\u7c7b\u578b\u3010%1$s\u3011\u7684\u52a8\u6001\u80a1\u6bd4\u5173\u7cfb\u3002", (String)"InvDynamicStockRadioImportPlugin_1", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
            validateRs.add(String.format(msg, key));
        }
        if (!validateRs.isEmpty()) {
            rs.setMessage(String.join((CharSequence)" ", validateRs));
            rs.setSucess(false);
        }
        return rs;
    }

    private InvValidateHelper<JSONObject> jsonObjectValidateHelper() {
        InvShareholdingValidator validator = new InvShareholdingValidator(this.model.getLong("id"));
        String confirmOpen = ResManager.loadKDString((String)"\u786e\u8ba4\u671f\u521d\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationSearchPlugin_104", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        String confirmShare = ResManager.loadKDString((String)"\u786e\u8ba4\u671f\u672b\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationSearchPlugin_105", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        String investedCompanyPropName = ResManager.loadKDString((String)"\u88ab\u6295\u8d44\u5355\u4f4d", (String)"InvRelationSearchPlugin_102", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        String shareholderPropName = ResManager.loadKDString((String)"\u6295\u8d44\u5355\u4f4d", (String)"InvRelationSearchPlugin_101", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        return new InvValidateHelper((InvValidator)validator).add(() -> validator.notNull("confirmopenscale", confirmOpen)).add(() -> validator.notNull("confirmsharescale", confirmShare)).add(() -> validator.notNull("confirmchangescale", ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u52a8\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationSearchPlugin_106", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]))).add(() -> validator.ratioBetween0To100("confirmopenscale", confirmOpen)).add(() -> validator.ratioBetween0To100("confirmsharescale", confirmShare)).add(() -> validator.independentOrg("shareholder.number", shareholderPropName)).add(() -> validator.independentOrg("investeecompany.number", investedCompanyPropName)).add(() -> validator.notEquals("shareholder.number", "investeecompany.number")).add(() -> validator.uniqueComboByKey("invchangetype.number", new String[]{"merge.number", "shareholder.number", "investeecompany.number"}));
    }

    private InvValidateHelper<DynamicObject> dynObjectValidateHelper() {
        long modelId = this.model.getLong("id");
        InvShareholdingValidator validator = new InvShareholdingValidator(modelId);
        String investedCompanyPropName = ResManager.loadKDString((String)"\u88ab\u6295\u8d44\u5355\u4f4d", (String)"InvRelationSearchPlugin_102", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        String merge = ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9", (String)"InvSheetRankPlugin_1", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        PermissionService permissionService = PermissionServiceImpl.getInstance((Long)modelId);
        Long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity");
        return new InvValidateHelper((InvValidator)validator).add(() -> validator.baseDataNotNull("model", ResManager.loadKDString((String)"\u4f53\u7cfb", (String)"DmMyReportListPlugin_11", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]))).add(() -> validator.baseDataNotNull("scenario", ResManager.loadKDString((String)"\u60c5\u666f", (String)"DmMyReportListPlugin_13", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]))).add(() -> validator.baseDataNotNull("year", ResManager.loadKDString((String)"\u8d22\u5e74", (String)"DmMyReportListPlugin_15", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]))).add(() -> validator.baseDataNotNull("period", ResManager.loadKDString((String)"\u671f\u95f4", (String)"DmMyReportListPlugin_16", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]))).add(() -> validator.baseDataNotNull("merge", merge)).add(() -> validator.baseDataNotNull("shareholder", ResManager.loadKDString((String)"\u6295\u8d44\u5355\u4f4d", (String)"InvRelationSearchPlugin_101", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]))).add(() -> validator.baseDataNotNull("investeecompany", investedCompanyPropName)).add(() -> validator.baseDataNotNull("invchangetype", ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578b", (String)"InvRelationSearchPlugin_103", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]))).add(() -> validator.entHaveReadwritePerm("merge", permissionService, dimensionId, merge)).add(() -> validator.entHavePerm("investeecompany", permissionService, dimensionId, investedCompanyPropName)).add(() -> validator.sceneHavePeriod("model", "scenario", "period", ResManager.loadKDString((String)"\u671f\u95f4%1$s\u4e0d\u5b58\u5728\u4e8e\u201c\u60c5\u666f%2$s\u201d\u7684\u9002\u7528\u671f\u95f4\u3002", (String)"InvDynamicStockRadioImportPlugin_4", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0])));
    }

    private String getNumberFromJson(JSONObject data, String key) {
        return data.getJSONObject(key).getString("number");
    }

    private Long getMemberId(String modelNum, JSONObject data, String dimNum, String key) {
        String number = this.getNumberFromJson(data, key);
        IDNumberTreeNode mc = MemberReader.findMemberByNumber((String)modelNum, (String)dimNum, (String)number);
        return mc.getId();
    }

    private String generateKey(DynamicObject dynamicObject) {
        return this.generateKey(dynamicObject.getString("merge.number"), dynamicObject.getString("shareholder.number"), dynamicObject.getString("investeecompany.number"), dynamicObject.getString("invchangetype.number"));
    }

    private String generateKey(JSONObject dynamicObject) {
        return this.generateKey(this.getNumberFromJson(dynamicObject, "merge"), this.getNumberFromJson(dynamicObject, "shareholder"), this.getNumberFromJson(dynamicObject, "investeecompany"), this.getNumberFromJson(dynamicObject, "invchangetype"));
    }

    private String generateKey(String merge, String shareholder, String investedCompany, String changeType) {
        return String.join((CharSequence)"&", merge, shareholder, investedCompany, changeType);
    }

    private void intModelAndPermMap() {
        try {
            Class<?> aClass = this.ctx.getClass();
            Field view = aClass.getDeclaredField("view");
            ReflectionUtils.makeAccessible((Field)view);
            IFormView formView = (IFormView)view.get(this.ctx);
            IFormView parentView = formView.getParentView();
            this.model = (DynamicObject)parentView.getModel().getValue("model");
            this.scenario = (DynamicObject)parentView.getModel().getValue("scenario");
            this.year = (DynamicObject)parentView.getModel().getValue("year");
            this.period = (DynamicObject)parentView.getModel().getValue("period");
            this.mergeNumber2BaseId = this.selectOrgRanges(parentView);
            String selectedNodeId = parentView.getPageCache().get("nodeSelected");
            this.selectedNodeId = LongUtil.toLong((Object)selectedNodeId);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private Map<String, Long> selectOrgRanges(IFormView view) {
        HashMap<String, Long> mergeNumber2BaseId = new HashMap<String, Long>(16);
        String temp = view.getPageCache().get("delOrgMenberPerm");
        List delOrgMemberPerm = (List)ObjectSerialUtil.deSerializedBytes((String)temp);
        Set selectOrgRanges = ConvertUtil.convertObjsToLongArray((Collection)delOrgMemberPerm);
        DynamicObjectCollection selectOrgRangeDys = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,number,copyfrom", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectOrgRanges)});
        for (DynamicObject selectOrgRangeDy : selectOrgRangeDys) {
            long baseId = selectOrgRangeDy.getLong("copyfrom");
            if (baseId == 0L) {
                baseId = selectOrgRangeDy.getLong("id");
            }
            String number = selectOrgRangeDy.getString("number");
            mergeNumber2BaseId.put(number, baseId);
        }
        return mergeNumber2BaseId;
    }

    private void logSuccess(List<ImportBillData> importBillDataList, ImportLogger logger, Set<DynamicObject> needUpdateData, Set<DynamicObject> needNewSaveData) {
        String f7Msg = String.format(ResManager.loadKDString((String)"%1$s\u4f53\u7cfb%2$s\u60c5\u666f%3$s\u8d22\u5e74%4$s\u671f\u95f4%5$s\u5408\u5e76\u8282\u70b9 ", (String)"InvRelationSearchPlugin_33", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), this.model.getString("shownumber"), this.scenario.getString("number"), this.year.getString("number"), this.period.getString("number"), MemberReader.findEntityMemberById((Long)this.model.getLong("id"), (Long)LongUtil.toLong((Object)this.selectedNodeId)).getLongNumber());
        this.writeOperationLog(f7Msg, importBillDataList.size() + logger.getTotal(), needNewSaveData.size() + needUpdateData.size());
    }

    public void writeOperationLog(String f7Msg, int total, int success) {
        String opName = ResManager.loadKDString((String)"\u5bfc\u5165", (String)"MergeStructImportPlugin_0", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        String desc = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u52a8\u6001\u80a1\u6bd4\u6210\u529f%1$s\uff0c\u5931\u8d25%2$s\u3002", (String)"InvDynamicStockRadioImportPlugin_3", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), success, total - success);
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((String)opName, (String)(f7Msg + desc), this.model == null ? null : (Long)this.model.getPkValue(), (String)"bcm_invrelation_search");
        logService.addLog(logInfo);
    }
}

