/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.formula.AdjustFormulaParseHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.serviceHelper.FormulaServiceHelper;
import kd.fi.bcm.business.util.BCMNumberRule;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.constant.invest.sharerela.InvRelationTypeConstant;
import kd.fi.bcm.common.enums.BalanceTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.enums.invest.InvProcessEnum;
import kd.fi.bcm.common.enums.invest.InvRelaTypeEnum;
import kd.fi.bcm.common.util.DataEntityUtils;
import kd.fi.bcm.common.util.KDAssert;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.BatchImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.impexport.BillResult;
import kd.fi.bcm.formplugin.invest.util.InvRelaTypeConfigUtil;
import kd.fi.bcm.formplugin.util.AdjustCatalogUtil;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class InvElimTemplatetImportPlugin
extends BatchImportPlugin {
    public static final String SEPARATOR = "@@@";
    public static final String MYCOMPANY = "mycompany";
    public static final String INTERNALCOMPANY = "internalcompany";
    private static Log log = LogFactory.getLog(InvElimTemplatetImportPlugin.class);
    private static final String NUMBER = "number";
    private static final String MODEL = "model";
    private static final String FI_BCM_FORM_PLUGIN = "fi-bcm-formplugin";
    private long modelId;
    IPageCache pageCache;
    DynamicObject modelDy;
    private String[] noDealDims = new String[]{"scenario", "model", "entity", "period", "year", "currency"};
    private String[] entityDims = new String[]{"process"};
    private Map<String, String> userDefineDimName;
    private Map<String, String> dimNumMapped;
    private final Map<String, String> userdefineMap2Nums = new HashMap<String, String>();
    private final Map<String, String> userdefineMap2fields = new HashMap<String, String>();

    public InvElimTemplatetImportPlugin() {
        this.userdefineMap2Nums.put("dim1", "userdefine1");
        this.userdefineMap2Nums.put("dim2", "userdefine2");
        this.userdefineMap2Nums.put("dim3", "userdefine3");
        this.userdefineMap2Nums.put("dim4", "userdefine4");
        this.userdefineMap2Nums.put("dim5", "userdefine5");
        this.userdefineMap2Nums.put("dim6", "userdefine6");
        this.userdefineMap2fields.put("userdefine1", "dim1");
        this.userdefineMap2fields.put("userdefine2", "dim2");
        this.userdefineMap2fields.put("userdefine3", "dim3");
        this.userdefineMap2fields.put("userdefine4", "dim4");
        this.userdefineMap2fields.put("userdefine5", "dim5");
        this.userdefineMap2fields.put("userdefine6", "dim6");
    }

    protected boolean isForceBatch() {
        return true;
    }

    protected int getBatchImportSize() {
        return 50000;
    }

    public void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
    }

    public ApiResult save(List<ImportBillData> importBillDataList, ImportLogger logger) {
        ApiResult result;
        if (logger.getFailed() != 0) {
            return this.failedBeforeSave(importBillDataList, logger);
        }
        try {
            this.intModelAndPermMap();
            Tuple<Table<String, String, EffectiveData>, List<EffectiveData>, Map<String, EffectiveData>> effectiveDataFromImport = this.getEffectiveData(importBillDataList, logger, this.modelId, "bcm_invelimtemplate");
            KDAssert.assertTrue((logger.getFailed() == 0 ? 1 : 0) != 0, () -> new KDBizException(this.getFailMsg()));
            Map<String, DynamicObject> dataFromDB = this.selectDataFromDB((Table<String, String, EffectiveData>)((Table)effectiveDataFromImport.p1));
            Set<DynamicObject> dataCollection = this.collectionData((Table<String, String, EffectiveData>)((Table)effectiveDataFromImport.p1), (List)effectiveDataFromImport.p2, dataFromDB, logger);
            KDAssert.assertTrue((logger.getFailed() == 0 ? 1 : 0) != 0, () -> new KDBizException(this.getFailMsg()));
            this.dbUniValid(logger, (Map)effectiveDataFromImport.p3, dataFromDB);
            KDAssert.assertTrue((logger.getFailed() == 0 ? 1 : 0) != 0, () -> new KDBizException(this.getFailMsg()));
            DynamicObject[] entryEntity = this.doSave(dataCollection);
            result = this.buildResult((Table<String, String, EffectiveData>)((Table)effectiveDataFromImport.p1), entryEntity);
        }
        catch (KDBizException e) {
            log.error((Throwable)e);
            int lastFailRow = (Integer)logger.getLogCache().keySet().stream().max(Integer::compareTo).orElseThrow(() -> e);
            logger.log(Integer.valueOf(lastFailRow), e.getMessage()).setFailed(importBillDataList.size());
            result = new ApiResult();
            result.setSuccess(true);
            result.setData(Collections.emptyList());
        }
        return result;
    }

    private void dbUniValid(ImportLogger logger, Map<String, EffectiveData> effectiveDataFromImport, Map<String, DynamicObject> dataFromDB) {
        Map<String, DynamicObject> dataFromDBByBizKey = this.selectDataFromDBByBizKey();
        effectiveDataFromImport.entrySet().stream().forEach(data -> {
            String key = (String)data.getKey();
            EffectiveData value = (EffectiveData)data.getValue();
            String bizUniKey = this.buildBizUniKey(value.data);
            String rowKey = this.buildRowKey(value.data);
            DynamicObject dyFromDb = (DynamicObject)dataFromDB.get(rowKey);
            if (dataFromDBByBizKey.containsKey(key) && (dyFromDb == null || !bizUniKey.equals(this.buildBizUniKey(dyFromDb)))) {
                logger.logAll(Integer.valueOf(value.startIndex), new String[]{ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d\u3001\u201c\u4f53\u7cfb\u201d\u7684\u7ec4\u5408\u503c\u4e0e\u5176\u4ed6\u8868\u5355\u91cd\u590d\u3002", (String)"InvElimTemplatetImportPlugin_9", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0])}).fail();
            }
        });
    }

    private Map<String, DynamicObject> selectDataFromDBByBizKey() {
        QFBuilder qfBuilder = new QFBuilder(MODEL, "=", (Object)this.modelId);
        DynamicObjectCollection tpls = QueryServiceHelper.query((String)"bcm_invelimtemplate", (String)"id,name,model", (QFilter[])qfBuilder.toArray(), (String)"name,model");
        Map<String, DynamicObject> collect = tpls.stream().collect(Collectors.toMap(k -> this.buildBizUniKey((DynamicObject)k), v -> v, (v1, v2) -> v1));
        return collect;
    }

    private Map<String, DynamicObject> selectDataFromDB(Table<String, String, EffectiveData> effectiveDataFromImport) {
        Set allInvestedCompany = effectiveDataFromImport.rowKeySet();
        QFBuilder qfBuilder = new QFBuilder(MODEL, "=", (Object)this.modelId).and("billno", "in", (Object)allInvestedCompany);
        DynamicObjectCollection tpls = QueryServiceHelper.query((String)"bcm_invelimtemplate", (String)"id", (QFilter[])qfBuilder.toArray());
        List<Long> ids = tpls.stream().map(tpl -> tpl.getLong("id")).collect(Collectors.toList());
        DynamicObject[] tplDys = BusinessDataServiceHelper.load((Object[])ids.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_invelimtemplate"));
        return Arrays.stream(tplDys).collect(Collectors.toMap(dy -> dy.getString("billno"), dy -> dy));
    }

    private Set<DynamicObject> collectionData(Table<String, String, EffectiveData> effectiveDataMap, List<EffectiveData> effectiveDataList, Map<String, DynamicObject> dataFromDB, ImportLogger logger) {
        HashSet updateSet = new HashSet(16);
        HashSet addSet = new HashSet(16);
        HashSet<DynamicObject> resultSet = new HashSet<DynamicObject>();
        ImportOperateType importType = ImportHelper.getImportType(this.ctx);
        effectiveDataMap.cellSet().forEach(cell -> {
            DynamicObject dyfromdb;
            String key = (String)cell.getRowKey();
            EffectiveData data = (EffectiveData)cell.getValue();
            DynamicObject dynamicObject = dyfromdb = dataFromDB != null ? (DynamicObject)dataFromDB.get(key) : null;
            if (dyfromdb != null) {
                if (ImportOperateType.NEW == importType) {
                    String msg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u65b0\u589e\u3002", (String)"InvElimTemplatetImportPlugin_0", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
                    logger.logAll(Integer.valueOf(data.startIndex), new String[]{msg}).fail();
                } else {
                    if ("C".equals(dyfromdb.getString("billstatus"))) {
                        String msg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u542f\u7528\uff0c\u4e0d\u53ef\u66f4\u65b0\u3002", (String)"InvElimTemplatetImportPlugin_10", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
                        logger.logAll(Integer.valueOf(data.startIndex), new String[]{msg}).fail();
                    }
                    DynamicObject dynamicObject2 = this.cvtDynamicObject(this.modelDy, (DynamicObject)dataFromDB.get(key), data.dataJson, data.dimdys);
                    updateSet.add(dynamicObject2);
                }
            } else if (BCMNumberRule.checkNumber((String)data.data.getString("billno"))) {
                addSet.add(data.data);
            } else {
                String msg = ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"InvElimTemplatetImportPlugin_14", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
                logger.logAll(Integer.valueOf(data.startIndex), new String[]{msg}).fail();
            }
        });
        resultSet.addAll(updateSet);
        if (ImportOperateType.OVERRIDE != importType) {
            if (CollectionUtils.isNotEmpty(effectiveDataList)) {
                String[] billNos;
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_invelimtemplate");
                try {
                    billNos = CodeRuleServiceHelper.getBatchNumber((String)"bcm_invelimtemplate", (DynamicObject)dynamicObject, null, (int)effectiveDataList.size());
                    if (billNos.length < 1 || billNos.length != effectiveDataList.size()) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u914d\u7f6e\u7ba1\u7406\u4e2d\u7f16\u7801\u89c4\u5219\u751f\u6210\u7f16\u7801\u4e0d\u8db3\u6216\u8005\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u7f16\u7801\u89c4\u5219\u3002", (String)"InvElimTemplatetImportPlugin_11", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]));
                    }
                }
                catch (Exception e) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u914d\u7f6e\u7ba1\u7406\u4e2d\u7f16\u7801\u89c4\u5219\u751f\u6210\u7f16\u7801\u4e0d\u8db3\u6216\u8005\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u7f16\u7801\u89c4\u5219\u3002", (String)"InvElimTemplatetImportPlugin_11", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]));
                }
                AtomicInteger index = new AtomicInteger();
                effectiveDataList.stream().forEach(data -> {
                    String billNo = billNos[index.get()];
                    data.data.set("billno", (Object)billNo);
                    index.getAndIncrement();
                    addSet.add(data.data);
                    effectiveDataMap.put((Object)billNo, (Object)this.buildBizUniKey(data.data), data);
                });
            }
            resultSet.addAll(addSet);
        }
        return resultSet;
    }

    private ApiResult failedBeforeSave(List<ImportBillData> importBillDataList, ImportLogger logger) {
        int lastFailRow = logger.getLogCache().keySet().stream().max(Integer::compareTo).orElseGet(() -> 5);
        logger.log(Integer.valueOf(lastFailRow), this.getFailMsg()).setFailed(importBillDataList.size() + logger.getFailed());
        ApiResult result = new ApiResult();
        result.setSuccess(true);
        result.setData(Collections.emptyList());
        return result;
    }

    private String getFailMsg() {
        return ResManager.loadKDString((String)"\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u6309\u63d0\u793a\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"InvShareRelaImportNewPlugin_0", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
    }

    private DynamicObject[] doSave(Set<DynamicObject> data) {
        HashSet update = Sets.newHashSet();
        HashSet addNew = Sets.newHashSet();
        for (DynamicObject datum : data) {
            if (datum.getLong("id") == 0L) {
                addNew.add(datum);
                continue;
            }
            update.add(datum);
        }
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            DynamicObject[] dynamicObjects;
            if (!update.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])update.toArray(new DynamicObject[0]));
            }
            if (!addNew.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])addNew.toArray(new DynamicObject[0]));
            }
            DynamicObject[] dynamicObjectArray = dynamicObjects = data.toArray(new DynamicObject[0]);
            return dynamicObjectArray;
        }
        catch (Exception e) {
            try {
                tx.markRollback();
                log.error((Throwable)e);
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private ApiResult buildResult(Table<String, String, EffectiveData> effectiveData, DynamicObject[] entryEntity) {
        ArrayList<Map<String, Object>> billResults = new ArrayList<Map<String, Object>>(16);
        for (DynamicObject dynamicObject : entryEntity) {
            long id = dynamicObject.getLong("id");
            String rowKey = this.buildRowKey(dynamicObject);
            String bizkey = this.buildBizUniKey(dynamicObject);
            EffectiveData effectiveData1 = (EffectiveData)effectiveData.row((Object)rowKey).get(bizkey);
            BillResult billResult = new BillResult();
            billResult.setId(id);
            billResult.setIndex(effectiveData1.dataIndex);
            billResult.setSucess(true);
            billResults.add(billResult.toMap());
        }
        ApiResult result = new ApiResult();
        result.setSuccess(true);
        result.setData(billResults);
        return result;
    }

    private String buildRowKey(DynamicObject relation) {
        return relation.getString("billno");
    }

    private String buildBizUniKey(DynamicObject dy) {
        return dy.getString("name") + SEPARATOR + dy.get(MODEL);
    }

    private void intModelAndPermMap() {
        try {
            Class<?> aClass = this.ctx.getClass();
            Field view = aClass.getDeclaredField("view");
            ReflectionUtils.makeAccessible((Field)view);
            IFormView formView = (IFormView)view.get(this.ctx);
            IFormView parentView = formView.getParentView();
            this.pageCache = parentView.getPageCache();
            this.modelId = Long.parseLong(this.pageCache.get("KEY_MODEL_ID"));
            this.modelDy = QueryServiceHelper.queryOne((String)"bcm_model", (String)"id,shownumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.modelId)});
            this.userDefineDimName = DimensionServiceHelper.getUserDefineDimensionNumAndNameByModel((Object)this.modelId, (boolean)false);
            this.dimNumMapped = DimensionServiceHelper.getDimensionNumMapped((Object)this.modelId);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private Tuple<Table<String, String, EffectiveData>, List<EffectiveData>, Map<String, EffectiveData>> getEffectiveData(List<ImportBillData> importBillDataList, ImportLogger logger, Long modelId, String entityName) {
        List<String> allDim = this.getAllDims(modelId);
        KDAssert.assertFalse((modelId == 0L ? 1 : 0) != 0, () -> new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u4f53\u7cfb\u5f02\u5e38\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"InvShareRelaImportNewPlugin_17", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0])));
        HashMultimap multimap = HashMultimap.create();
        HashSet<String> templateCatalogNumbers = new HashSet<String>(16);
        HashSet<String> templateRelationNumbers = new HashSet<String>(16);
        HashSet<String> templateChangeTypeNumbers = new HashSet<String>(16);
        HashSet<String> templateScenariosNumbers = new HashSet<String>(16);
        HashSet<String> templateEffectYearsNumbers = new HashSet<String>(16);
        HashSet<String> templateEffectPeriodsNumbers = new HashSet<String>(16);
        HashSet<String> templateElimCatalogNumbers = new HashSet<String>(16);
        importBillDataList.stream().map(ImportBillData::getData).forEach(data -> {
            Optional<String> number;
            JSONArray invelimtplentry = data.getJSONArray("invelimtplentry");
            this.collectDimNumbers(allDim, multimap, (JSONObject)data, invelimtplentry);
            Optional<String> templatCatalogNumber = Optional.ofNullable((JSONObject)data.get((Object)"templatecatalog")).map(catalog -> catalog.getString(NUMBER));
            if (templatCatalogNumber.isPresent()) {
                templateCatalogNumbers.add(templatCatalogNumber.get());
            }
            if ((number = Optional.ofNullable((JSONObject)data.get((Object)"adjustcatalog")).map(catalog -> catalog.getString(NUMBER))).isPresent()) {
                templateElimCatalogNumbers.add(number.get());
            }
            this.collectRelationNubmers((Set<String>)templateRelationNumbers, (Set<String>)templateChangeTypeNumbers, (JSONObject)data);
            this.collectScenceNumbers((Set<String>)templateScenariosNumbers, (JSONObject)data);
            this.collectPeriodNumbers((Set<String>)templateEffectYearsNumbers, (Set<String>)templateEffectPeriodsNumbers, (JSONObject)data);
        });
        Map<String, Map<String, DynamicObject>> dbNumberS = this.dataFromDB(multimap, allDim);
        Map<String, DynamicObject> templateCatalogFromDB = this.templateCatalogFromDB(templateCatalogNumbers);
        Map<String, DynamicObject> templateElimCatalogFromDB = this.templateElimCatalogFromDB(templateElimCatalogNumbers);
        Map<String, DynamicObject> templateRelationTypeFromDB = this.templateRelationTypeFromDB(templateRelationNumbers, templateChangeTypeNumbers);
        Map<String, DynamicObject> templateScenariosFromDB = this.templateScenariosFromDB(templateScenariosNumbers);
        Map<String, Map<String, DynamicObject>> templateEffectPeriodFromDB = this.templateEffectPeriodFromDB(templateEffectYearsNumbers, templateEffectPeriodsNumbers);
        HashBasedTable effectiveDatas = HashBasedTable.create();
        HashMap bizDatas = new HashMap(16);
        ArrayList addNewEffectiveDatas = new ArrayList(16);
        ArrayList rowLogs = new ArrayList(16);
        List<String> entityDimList = Arrays.asList(this.entityDims);
        allDim.removeAll(Arrays.asList(this.noDealDims));
        allDim.removeAll(entityDimList);
        Map<String, InvRelaTypeConfigUtil> invRelaTypeConfig = InvRelaTypeConfigUtil.getInvRelaTypeConfig(modelId);
        importBillDataList.stream().forEach(arg_0 -> this.lambda$getEffectiveData$18(rowLogs, logger, entityDimList, dbNumberS, templateCatalogFromDB, invRelaTypeConfig, templateRelationTypeFromDB, templateScenariosFromDB, templateEffectPeriodFromDB, templateElimCatalogFromDB, allDim, entityName, importBillDataList, bizDatas, (Table)effectiveDatas, addNewEffectiveDatas, arg_0));
        return new Tuple((Object)effectiveDatas, addNewEffectiveDatas, bizDatas);
    }

    private Map<String, DynamicObject> templateElimCatalogFromDB(Set<String> templateElimCatalogNumbers) {
        if (CollectionUtils.isNotEmpty(templateElimCatalogNumbers)) {
            QFilter adjustCatalogFilter = AdjustCatalogUtil.getAdjustCatalogFilterWithPerm(this.modelId);
            return QueryServiceHelper.query((String)"bcm_templatecatalog", (String)"id,number", (QFilter[])new QFilter[]{adjustCatalogFilter}).stream().collect(Collectors.toMap(dy -> dy.getString(NUMBER), dy -> dy, (v1, v2) -> v2));
        }
        return Collections.emptyMap();
    }

    private void collectRelationNubmers(Set<String> templateRelationNumbers, Set<String> templateChangeTypeNumbers, JSONObject data) {
        String categorized = data.getString("categorized");
        if (InvRelationTypeConstant.CatalogEnum.relation.getCode().equals(categorized)) {
            templateRelationNumbers.add(data.getString("invrelatypenum"));
        } else {
            templateChangeTypeNumbers.add(data.getString("invrelatypenum"));
        }
    }

    private void collectPeriodNumbers(Set<String> templateEffectYearsNumbers, Set<String> templateEffectPeriodsNumbers, JSONObject data) {
        JSONArray effectPeriods = (JSONArray)data.get((Object)"effective");
        if (Optional.ofNullable(effectPeriods).isPresent()) {
            effectPeriods.forEach(effectPeriod -> {
                Optional<Object> periodNumber;
                Optional<Object> yearNumber = Optional.ofNullable(((JSONObject)effectPeriod).get((Object)"effectiveyear")).map(meb -> ((JSONObject)meb).get((Object)NUMBER));
                if (yearNumber.isPresent()) {
                    templateEffectYearsNumbers.add((String)yearNumber.get());
                }
                if ((periodNumber = Optional.ofNullable(((JSONObject)effectPeriod).get((Object)"effectiveperiod")).map(meb -> ((JSONObject)meb).get((Object)NUMBER))).isPresent()) {
                    templateEffectPeriodsNumbers.add((String)periodNumber.get());
                }
            });
        }
    }

    private void collectScenceNumbers(Set<String> templateScenariosNumbers, JSONObject data) {
        JSONArray scenarios = (JSONArray)data.get((Object)"scenarios");
        if (Optional.ofNullable(scenarios).isPresent()) {
            scenarios.forEach(scen -> {
                Optional<Object> number = Optional.ofNullable(((JSONObject)scen).get((Object)"scenariomeb")).map(meb -> ((JSONObject)meb).get((Object)NUMBER));
                if (number.isPresent()) {
                    templateScenariosNumbers.add((String)number.get());
                }
            });
        }
    }

    private void validEffectPeriod(Map<String, Map<String, DynamicObject>> templateEffectPeriodFromDB, List<ImportLogger.ImportLog> rowLogs, JSONObject dataEntity, Map<String, Map<String, DynamicObject>> dimDys) {
        JSONArray effectperiods = (JSONArray)dataEntity.get((Object)"effective");
        String yearName = ResManager.loadKDString((String)"\u8d22\u5e74", (String)"InvElimTemplatetImportPlugin_18", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        String periodName = ResManager.loadKDString((String)"\u671f\u95f4", (String)"InvElimTemplatetImportPlugin_19", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        ArrayList checkUp = new ArrayList(16);
        if (Optional.ofNullable(effectperiods).isPresent()) {
            AtomicBoolean flag = new AtomicBoolean(true);
            effectperiods.forEach(effectperiod -> {
                JSONObject yearJson = ((JSONObject)effectperiod).getJSONObject("effectiveyear");
                JSONObject periodJson = ((JSONObject)effectperiod).getJSONObject("effectiveperiod");
                String yearScop = ((JSONObject)effectperiod).getString("yearscope");
                String applytype = ((JSONObject)effectperiod).getString("applytype");
                if (StringUtils.isBlank((CharSequence)yearScop) || StringUtils.isBlank((CharSequence)applytype)) {
                    String msg = ResManager.loadKDString((String)"\u9002\u7528\u7c7b\u578b\u6216\u8d22\u5e74\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckTmplBatchImportPlugin_55", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
                    rowLogs.add(new ImportLogger.ImportLog(msg));
                    return;
                }
                if (Objects.isNull(yearJson) && Objects.isNull(periodJson)) {
                    String msg = ResManager.loadKDString((String)"\u8d22\u5e74\u7f16\u7801\u671f\u95f4\u7f16\u7801\u4e0d\u80fd\u90fd\u4e3a\u7a7a\u3002", (String)"CheckTmplBatchImportPlugin_58", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
                    rowLogs.add(new ImportLogger.ImportLog(msg));
                    return;
                }
                if (Objects.nonNull(yearJson)) {
                    this.validApplyDim(rowLogs, (JSONObject)effectperiod, (Map)templateEffectPeriodFromDB.get(DimTypesEnum.YEAR.getNumber()), dimDys, yearName, "effectiveyear");
                }
                if (Objects.nonNull(periodJson)) {
                    this.validApplyDim(rowLogs, (JSONObject)effectperiod, (Map)templateEffectPeriodFromDB.get(DimTypesEnum.PERIOD.getNumber()), dimDys, periodName, "effectiveperiod");
                }
                if (flag.get()) {
                    String yearNumber = "";
                    String periodNumber = "";
                    if (Optional.ofNullable(yearJson).isPresent()) {
                        yearNumber = yearJson.getString(NUMBER);
                    }
                    if (Optional.ofNullable(periodJson).isPresent()) {
                        periodNumber = periodJson.getString(NUMBER);
                    }
                    Map<String, Object> temp = this.getRowMap(yearScop, yearNumber, periodNumber);
                    flag.set(this.checkRepeatEffectPeriod(rowLogs, checkUp, temp));
                    checkUp.add(temp);
                }
            });
        }
    }

    private void validApplyScence(Map<String, DynamicObject> templateScenariosFromDB, List<ImportLogger.ImportLog> rowLogs, JSONObject dataEntity, Map<String, Map<String, DynamicObject>> dimDys) {
        JSONArray scenarios = (JSONArray)dataEntity.get((Object)"scenarios");
        String scenarioName = ResManager.loadKDString((String)"\u60c5\u666f", (String)"InvElimTemplatetImportPlugin_16", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        if (Optional.ofNullable(scenarios).isPresent()) {
            scenarios.forEach(scen -> this.validApplyDim(rowLogs, (JSONObject)scen, templateScenariosFromDB, dimDys, scenarioName, "scenariomeb"));
        } else {
            String msg = ResManager.loadKDString((String)"\u65e0\u9002\u7528\u60c5\u666f\u8bbe\u7f6e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvElimTemplatetImportPlugin_17", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
            rowLogs.add(new ImportLogger.ImportLog(msg));
        }
    }

    private void collectDimNumbers(List<String> allDim, HashMultimap multimap, JSONObject data, JSONArray invelimtplentry) {
        allDim.stream().forEach(dim -> {
            String dimValue;
            String dimLow = dim.toLowerCase(Locale.ENGLISH);
            String string = dimValue = data.getJSONObject(dimLow) != null ? data.getJSONObject(dimLow).getString(NUMBER) : null;
            if (StringUtils.isNotEmpty(dimValue)) {
                multimap.put((Object)dimLow, (Object)dimValue);
            }
            if (dim.equals(DimTypesEnum.DATASORT.getNumber().toLowerCase(Locale.ROOT))) {
                dimLow = "datasource";
            }
            for (Object json : invelimtplentry) {
                JSONObject finalJson = (JSONObject)json;
                String entryValue = finalJson.getJSONObject(dimLow) != null ? finalJson.getJSONObject(dimLow).getString(NUMBER) : null;
                if (!StringUtils.isNotEmpty(entryValue)) continue;
                dimValue = entryValue;
                multimap.put(dim, (Object)dimValue);
            }
        });
    }

    private void moreNewAdd(DynamicObject dynamicObject) {
        if (dynamicObject.get("balancetype") == null) {
            dynamicObject.set("balancetype", (Object)BalanceTypeEnum.BALANCE.getIndex());
        }
    }

    private boolean checkRepeatEffectPeriod(List<ImportLogger.ImportLog> rowLogs, List<Map<String, Object>> checkUp, Map<String, Object> temp) {
        for (Map<String, Object> check : checkUp) {
            String sourceType = temp.get("type").toString();
            String targetType = check.get("type").toString();
            String sourceYear = temp.get("year").toString();
            String targetYear = check.get("year").toString();
            Set sourcePeriod = (Set)temp.get("period");
            Set targetPeriod = (Set)check.get("period");
            if (!"ALL".equals(sourceType) && !"ALL".equals(targetType) && !this.sourceIsInTarget(sourceType, targetType, sourceYear, targetYear) || !sourcePeriod.removeAll(targetPeriod) && !sourcePeriod.contains("ALL") && !targetPeriod.contains("ALL")) continue;
            String msg = ResManager.loadKDString((String)"\u8d22\u5e74\u671f\u95f4\u7ec4\u5408\u5b58\u5728\u91cd\u590d\u884c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EffectiveYearPeriodUtil_1", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
            rowLogs.add(new ImportLogger.ImportLog(msg));
            return false;
        }
        return true;
    }

    private Map<String, Object> getRowMap(String yearscope, String yearNum, String period) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        String type = "ALL";
        HashSet<String> periodSet = new HashSet<String>(Collections.singletonList("ALL"));
        switch (yearscope) {
            case "2": {
                type = "=";
                break;
            }
            case "3": {
                type = "<=";
                break;
            }
            case "4": {
                type = ">=";
                break;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)period)) {
            periodSet.clear();
            periodSet.add(period);
        }
        map.put("type", type);
        map.put("year", yearNum == null ? "" : yearNum);
        map.put("period", periodSet);
        return map;
    }

    private boolean sourceIsInTarget(String sourceType, String targetType, String sourceYear, String targetYear) {
        if (sourceYear.equals(targetYear)) {
            return true;
        }
        if (sourceYear.compareTo(targetYear) > 0) {
            return ">=".equals(targetType) || "<=".equals(sourceType);
        }
        return "<=".equals(targetType) || ">=".equals(sourceType);
    }

    private Map<String, Map<String, DynamicObject>> templateEffectPeriodFromDB(Set<String> templateEffectYearsNumbers, Set<String> templateEffectPeriodsNumbers) {
        Map<String, DynamicObject> maps;
        QFilter qFilters;
        HashMap<String, Map<String, DynamicObject>> resultMap = new HashMap<String, Map<String, DynamicObject>>(16);
        if (CollectionUtils.isNotEmpty(templateEffectYearsNumbers)) {
            qFilters = new QFilter(MODEL, "=", (Object)this.modelId).and(NUMBER, "in", templateEffectYearsNumbers);
            qFilters.and(new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex()));
            maps = QueryServiceHelper.query((String)"bcm_fymembertree", (String)InvElimTemplatetImportPlugin.getDimField("scenario"), (QFilter[])new QFilter[]{qFilters}).stream().collect(Collectors.toMap(dy -> dy.getString(NUMBER), dy -> dy, (v1, v2) -> v2));
            resultMap.put(DimTypesEnum.YEAR.getNumber(), maps);
        }
        if (CollectionUtils.isNotEmpty(templateEffectPeriodsNumbers)) {
            qFilters = new QFilter(MODEL, "=", (Object)this.modelId).and(NUMBER, "in", templateEffectPeriodsNumbers);
            qFilters.and(new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex()));
            maps = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)InvElimTemplatetImportPlugin.getDimField("scenario"), (QFilter[])new QFilter[]{qFilters}).stream().collect(Collectors.toMap(dy -> dy.getString(NUMBER), dy -> dy, (v1, v2) -> v2));
            resultMap.put(DimTypesEnum.PERIOD.getNumber(), maps);
        }
        return resultMap;
    }

    private void validApplyDim(List<ImportLogger.ImportLog> rowLogs, JSONObject dataEntity, Map<String, DynamicObject> templateScenariosFromDB, Map<String, Map<String, DynamicObject>> dimDys, String dimName, String dimMappingField) {
        DynamicObject dynamicObject = BatchImportHelper.doCheckNumberThenGet(rowLogs, dataEntity, dimMappingField, dimName, templateScenariosFromDB, dy -> {});
        if (dynamicObject != null) {
            Map<String, DynamicObject> dimMap = dimDys.get(dimMappingField);
            if (dimMap == null) {
                dimMap = new HashMap<String, DynamicObject>(16);
            }
            dimMap.put(dynamicObject.getString(NUMBER), dynamicObject);
            dimDys.put(dimMappingField, dimMap);
        }
    }

    private Map<String, DynamicObject> templateScenariosFromDB(Set<String> templateScenariosNumbers) {
        HashMap<String, DynamicObject> resultMap = new HashMap<String, DynamicObject>(16);
        if (CollectionUtils.isNotEmpty(templateScenariosNumbers)) {
            QFilter qFilters = new QFilter(MODEL, "=", (Object)this.modelId).and(NUMBER, "in", templateScenariosNumbers);
            qFilters.and(new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex()));
            Map<String, DynamicObject> maps = QueryServiceHelper.query((String)"bcm_scenemembertree", (String)InvElimTemplatetImportPlugin.getDimField("scenario"), (QFilter[])new QFilter[]{qFilters}).stream().collect(Collectors.toMap(dy -> dy.getString(NUMBER), dy -> dy, (v1, v2) -> v2));
            resultMap.putAll(maps);
        }
        return resultMap;
    }

    private Map<String, DynamicObject> templateRelationTypeFromDB(Set<String> templateRelationNumbers, Set<String> templateChangeTypeNumbers) {
        Map<String, DynamicObject> maps;
        QFilter qFilters;
        HashMap<String, DynamicObject> resultMap = new HashMap<String, DynamicObject>(16);
        if (CollectionUtils.isNotEmpty(templateRelationNumbers)) {
            qFilters = new QFilter(MODEL, "=", (Object)this.modelId).and(NUMBER, "in", templateRelationNumbers).and("categorized", "=", (Object)InvRelationTypeConstant.CatalogEnum.relation.getCode());
            maps = QueryServiceHelper.query((String)"bcm_invrelatype", (String)InvRelationTypeConstant.getSelectFields(), (QFilter[])new QFilter[]{qFilters}).stream().collect(Collectors.toMap(dy -> dy.getString(NUMBER) + "_" + dy.get("categorized"), dy -> dy, (v1, v2) -> v2));
            resultMap.putAll(maps);
        }
        if (CollectionUtils.isNotEmpty(templateChangeTypeNumbers)) {
            qFilters = new QFilter(MODEL, "=", (Object)this.modelId).and(NUMBER, "in", templateChangeTypeNumbers).and("categorized", "=", (Object)InvRelationTypeConstant.CatalogEnum.change_type.getCode());
            maps = QueryServiceHelper.query((String)"bcm_invrelatype", (String)InvRelationTypeConstant.getSelectFields(), (QFilter[])new QFilter[]{qFilters}).stream().collect(Collectors.toMap(dy -> dy.getString(NUMBER) + "_" + dy.get("categorized"), dy -> dy, (v1, v2) -> v2));
            resultMap.putAll(maps);
        }
        return resultMap;
    }

    private void validEntity(JSONObject data, List<ImportLogger.ImportLog> entryRowLogs, Boolean adjustment) {
        String entityComb = data.getString("entitycomb");
        if (adjustment.booleanValue() && !entityComb.equals("1")) {
            entryRowLogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8c03\u6574\u7c7b\u6a21\u677f\uff0c\u201c\u7ec4\u7ec7\u201d\u5b57\u6bb5\u53ea\u80fd\u9009\u62e9\u6295\u8d44\u5355\u4f4d\u3002", (String)"InvElimTemplatetImportPlugin_7", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0])));
        }
    }

    private void validInvrelaType(Map<String, InvRelaTypeConfigUtil> invRelaTypeConfig, List<ImportLogger.ImportLog> rowLogs, JSONObject dataEntity, Map<String, DynamicObject> templateRelationTypeFromDB) {
        String invrelatype = dataEntity.getString("invrelatypenum");
        String categorized = dataEntity.getString("categorized");
        if (InvRelationTypeConstant.CatalogEnum.relation.getCode().equals(categorized) && (Objects.isNull(invRelaTypeConfig.get(invrelatype)) || !invRelaTypeConfig.get(invrelatype).getInUse().booleanValue())) {
            String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u6301\u80a1\u7c7b\u578b\u3010%s\u3011\u4e0d\u53ef\u7528\u3002", (String)"InvElimTemplatetImportPlugin_8", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), InvRelaTypeEnum.valueof((String)invrelatype).getDesc());
            rowLogs.add(new ImportLogger.ImportLog(msg));
            return;
        }
        DynamicObject relationTypeDy = templateRelationTypeFromDB.get(invrelatype + "_" + categorized);
        if (Objects.isNull(relationTypeDy)) {
            String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u6301\u80a1\u7c7b\u578b\u3010%s\u3011\u4e0d\u5b58\u5728\u3002", (String)"InvElimTemplatetImportPlugin_15", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), invrelatype);
            rowLogs.add(new ImportLogger.ImportLog(msg));
            return;
        }
        dataEntity.put("invrelatypebase", (Object)relationTypeDy.getLong("id"));
    }

    private List<String> getAllDims(Long modelId) {
        List<String> allDim = DimensionServiceHelper.getDimensionNumMapped((Object)modelId).values().stream().map(dim -> {
            if (StringUtils.isNotEmpty((CharSequence)this.userdefineMap2Nums.get(dim))) {
                dim = this.userdefineMap2Nums.get(dim);
            }
            return dim;
        }).collect(Collectors.toList());
        return allDim;
    }

    private void validProcess(List<ImportLogger.ImportLog> rowLogs, JSONObject dataEntity) {
        String process = ((JSONObject)dataEntity.get((Object)DimTypesEnum.PROCESS.getNumber().toLowerCase(Locale.ENGLISH))).getString(NUMBER);
        if (!InvProcessEnum.getAllNumber().contains(process)) {
            rowLogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8fc7\u7a0b\u914d\u7f6e\u4e0d\u5728\u8303\u56f4EJE\u3001CCADJ\u3001CADJ\u3001ADJ\u3001RAdj\u3001ERAdj\u4e2d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvElimTemplatetImportPlugin_4", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0])));
        }
    }

    private void validRuleexpr(JSONObject data, List<ImportLogger.ImportLog> rowLogs, AtomicInteger index) {
        String ruleexpr = data.getString("ruleexpr");
        String ruleexprdept = data.getString("ruleexprdept");
        boolean isCreditBlank = StringUtils.isBlank((CharSequence)ruleexpr);
        boolean isDebitBlank = StringUtils.isBlank((CharSequence)ruleexprdept);
        String val = null;
        if (!(isCreditBlank ^ isDebitBlank)) {
            String msg = ResManager.loadKDString((String)"\u501f\u8d37\u65b9\u4e0d\u80fd\u540c\u65f6\u8d4b\u503c\u6216\u8005\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"InvElimTemplatetImportPlugin_22", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
            rowLogs.add(new ImportLogger.ImportLog(msg));
            return;
        }
        val = isCreditBlank ? ruleexprdept : ruleexpr;
        try {
            Expression expression = ExcelFormulaPaserHelper.parse((String)val);
            AtomicBoolean isBlanceLine = new AtomicBoolean(false);
            AdjustFormulaParseHelper.walkExpress((Expression)expression, p -> {
                String funcName;
                if (p instanceof FunctionExpr && "BN".equalsIgnoreCase(funcName = ((FunctionExpr)p).getFuncionName())) {
                    isBlanceLine.set(true);
                }
                return p;
            });
            if (isBlanceLine.get() && index.getAndIncrement() > 0) {
                rowLogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5206\u7ec4\u5185\u53ea\u80fd\u51fa\u73b0\u4e00\u4e2a\u5e73\u8861\u6570\u3002", (String)"InvelimTemplatePlugin_11", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0])));
                return;
            }
        }
        catch (Throwable t) {
            rowLogs.add(new ImportLogger.ImportLog(AdjustmentServiceHelper.toString_Adj((Throwable)t)));
        }
        if (StringUtils.isNotEmpty((CharSequence)ruleexpr) || StringUtils.isNotEmpty((CharSequence)ruleexprdept)) {
            String ruleexprSoruce = "";
            if (StringUtils.isNotEmpty((CharSequence)ruleexpr)) {
                ruleexprSoruce = ruleexpr;
            }
            if (StringUtils.isNotEmpty((CharSequence)ruleexprdept)) {
                ruleexprSoruce = ruleexprdept;
            }
            try {
                String fullFormula = FormulaServiceHelper.analyFullFormula((String)ruleexprSoruce, (IPageCache)this.pageCache, (long)this.modelId, null, (boolean)false);
                String formulaName = InvElimTemplatetImportPlugin.transFormula(fullFormula);
                if (StringUtils.isNotEmpty((CharSequence)ruleexpr)) {
                    data.put("ruleexpr", (Object)formulaName);
                } else {
                    data.put("ruleexprdept", (Object)formulaName);
                }
                data.put("ruleexprsource", (Object)ruleexprSoruce);
            }
            catch (Exception e) {
                String msg = ResManager.loadKDString((String)"\u516c\u5f0f\u89e3\u6790\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"InvElimTemplatetImportPlugin_3", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
                rowLogs.add(new ImportLogger.ImportLog(msg));
                return;
            }
        }
    }

    public static String transFormula(String formula) {
        String[] leftStrs;
        ArrayList strLs = Lists.newArrayList();
        for (String leftStr : leftStrs = formula.split("\\{")) {
            String[] rightStrs = leftStr.split("\\}");
            strLs.addAll(Arrays.asList(rightStrs));
        }
        StringBuilder name = new StringBuilder();
        for (String str : strLs) {
            String[] split = str.split(",");
            if (split.length == 1) {
                name.append(split[0]);
                continue;
            }
            if (split.length != 2) continue;
            name.append(split[1].trim().substring(1, split[1].length() - 1));
        }
        return name.toString();
    }

    private Map<String, DynamicObject> templateCatalogFromDB(Set<String> templateCatalogNumbers) {
        if (CollectionUtils.isNotEmpty(templateCatalogNumbers)) {
            QFilter qFilters = new QFilter(MODEL, "=", (Object)this.modelId).and(NUMBER, "in", templateCatalogNumbers);
            return QueryServiceHelper.query((String)"bcm_invtemplatecatalog", (String)InvElimTemplatetImportPlugin.getDimField("templatecatalog"), (QFilter[])new QFilter[]{qFilters}).stream().collect(Collectors.toMap(dy -> dy.getString(NUMBER), dy -> dy, (v1, v2) -> v2));
        }
        return Collections.emptyMap();
    }

    private void validTemplateCatalog(Map<String, DynamicObject> templateCatalogFromDB, List<ImportLogger.ImportLog> rowLogs, Map<String, Map<String, DynamicObject>> dimDys, JSONObject dataEntity) {
        String tplName = ResManager.loadKDString((String)"\u6a21\u677f\u5206\u7c7b", (String)"InvLimListPlugin_6", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        DynamicObject dynamicObject = BatchImportHelper.doCheckNumberThenGet(rowLogs, dataEntity, "templatecatalog", tplName, templateCatalogFromDB, dy -> {});
        if (dynamicObject != null) {
            Map<String, DynamicObject> dimMap = dimDys.get("templatecatalog");
            if (dimMap == null) {
                dimMap = new HashMap<String, DynamicObject>(16);
            }
            dimMap.put(dynamicObject.getString(NUMBER), dynamicObject);
            dimDys.put("templatecatalog", dimMap);
        }
    }

    private void validTemplateElimCatalog(Map<String, DynamicObject> templateElimCatalogFromDB, List<ImportLogger.ImportLog> rowLogs, Map<String, Map<String, DynamicObject>> dimDys, JSONObject dataEntity) {
        DynamicObject dynamicObject;
        String tplName = ResManager.loadKDString((String)"\u5206\u5f55\u5206\u7c7b", (String)"InvElimTemplatetImportPlugin_21", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        JSONObject adjustcatalog = (JSONObject)dataEntity.get((Object)"adjustcatalog");
        if (Optional.ofNullable(adjustcatalog).isPresent() && (dynamicObject = BatchImportHelper.doCheckNumberThenGet(rowLogs, dataEntity, "adjustcatalog", tplName, templateElimCatalogFromDB, dy -> {})) != null) {
            Map<String, DynamicObject> dimMap = dimDys.get("adjustcatalog");
            if (dimMap == null) {
                dimMap = new HashMap<String, DynamicObject>(16);
            }
            dimMap.put(dynamicObject.getString(NUMBER), dynamicObject);
            dimDys.put("adjustcatalog", dimMap);
        }
    }

    private void validDimMember(List<String> allDim, Map<String, Map<String, DynamicObject>> dbNumberS, List<ImportLogger.ImportLog> rowLogs, Map<String, Map<String, DynamicObject>> dimDys, JSONObject data) {
        allDim.stream().forEach(dim -> {
            AtomicReference<String> dimName = new AtomicReference<String>("");
            String finalDim = dim;
            if (this.userdefineMap2fields.containsKey(dim)) {
                this.dimNumMapped.entrySet().stream().forEach(e -> {
                    if (((String)e.getValue()).equals(this.userdefineMap2fields.get(finalDim))) {
                        dimName.set(this.userDefineDimName.get(e.getKey()));
                    }
                });
            } else {
                dimName.set(DimTypesEnum.getDimTypesEnumByNumber((String)dim).getName());
            }
            if (dim.equals(DimTypesEnum.DATASORT.getNumber().toLowerCase(Locale.ROOT))) {
                dim = "datasource";
            }
            Map dynamicObjectMap = (Map)dbNumberS.get(dim);
            DynamicObject dynamicObject = BatchImportHelper.doCheckNumberThenGet(rowLogs, data, dim, dimName.get(), dynamicObjectMap, dy -> {
                if (!(Arrays.asList(this.entityDims).contains(finalDim) || finalDim.equals(DimTypesEnum.ACCOUNT.getNumber().toLowerCase(Locale.ROOT)) || dy.getBoolean("isleaf"))) {
                    String msg = String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4fe1\u606f\u3010%s\u3011\u4e0d\u80fd\u4e3a\u975e\u660e\u7ec6\u6210\u5458\u3002", (String)"InvElimTemplatetImportPlugin_5", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), dimName);
                    rowLogs.add(new ImportLogger.ImportLog(msg));
                }
            });
            if (dynamicObject != null) {
                HashMap<String, DynamicObject> dimMap = (HashMap<String, DynamicObject>)dimDys.get(dim);
                if (dimMap == null) {
                    dimMap = new HashMap<String, DynamicObject>(16);
                }
                dimMap.put(dynamicObject.getString(NUMBER), dynamicObject);
                dimDys.put((String)dim, (Map<String, DynamicObject>)dimMap);
            }
        });
    }

    private DynamicObject cvtDynamicObject(DynamicObject modelDy, DynamicObject dynamicObject, JSONObject data, Map<String, Map<String, DynamicObject>> dimDys) {
        DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
        properties.stream().forEach(field -> {
            String name = field.getName();
            if (name.equals(MODEL)) {
                dynamicObject.set(MODEL, modelDy.get("id"));
            } else if (dimDys.get(name) != null) {
                DynamicObject dynamicObject1;
                Optional map = Optional.ofNullable(dimDys.get(name));
                Optional<String> dataNumber = Optional.ofNullable(data.get((Object)name)).map(obj -> ((JSONObject)obj).getString(NUMBER));
                if (map.isPresent() && dataNumber.isPresent() && Objects.nonNull(dynamicObject1 = (DynamicObject)((Map)map.get()).get(dataNumber.get()))) {
                    dynamicObject.set(name, (Object)dynamicObject1.getLong("id"));
                }
            } else if (name.equals("creator") || name.equals("modifier")) {
                Date now = TimeServiceHelper.now();
                long currUserId = RequestContext.get().getCurrUserId();
                dynamicObject.set("creator", (Object)currUserId);
                dynamicObject.set("createtime", (Object)now);
                dynamicObject.set("modifier", (Object)currUserId);
                dynamicObject.set("modifytime", (Object)now);
            } else if (field instanceof EntryProp) {
                DynamicObjectCollection entryDyCol = dynamicObject.getDynamicObjectCollection(name);
                entryDyCol.clear();
                JSONArray entryJsons = (JSONArray)data.get((Object)name);
                if (CollectionUtils.isNotEmpty((Collection)entryJsons)) {
                    for (int i = 0; i < entryJsons.size(); ++i) {
                        JSONObject entryData = (JSONObject)entryJsons.get(i);
                        DynamicObject entryDynamicObject = entryDyCol.addNew();
                        entryDynamicObject.set("Seq", (Object)(i + 1));
                        this.cvtDynamicObject(null, entryDynamicObject, entryData, dimDys);
                    }
                }
                dynamicObject.set(name, (Object)entryDyCol);
            } else if (field instanceof MuliLangTextProp) {
                dynamicObject.set(name, (Object)LocaleString.fromMap((Map)((Map)data.get((Object)name))).toString().trim());
            } else if (data.get((Object)name) != null) {
                dynamicObject.set(name, data.get((Object)name));
            }
        });
        return dynamicObject;
    }

    private void collectEffectiveData(EffectiveData effectiveData, ImportLogger logger, List<ImportBillData> importBillDataList, Map<String, EffectiveData> bizDatas, Table<String, String, EffectiveData> dataMap, List<EffectiveData> addNewData) {
        String rowKey = this.buildRowKey(effectiveData.data);
        String bizKey = this.buildBizUniKey(effectiveData.data);
        if (Objects.nonNull(bizDatas.putIfAbsent(bizKey, effectiveData))) {
            int startIndex = effectiveData.startIndex;
            int startIndex1 = bizDatas.get((Object)bizKey).startIndex;
            String msg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u884c\u4e0e\u7b2c%1$s\u884c\u76f8\u540c\u3002", (String)"InvElimTemplatetImportPlugin_12", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), startIndex1 + 1);
            logger.log(Integer.valueOf(startIndex), msg).fail();
            return;
        }
        if (StringUtils.isEmpty((CharSequence)rowKey)) {
            addNewData.add(effectiveData);
            return;
        }
        Map row = dataMap.row((Object)rowKey);
        if (row.isEmpty()) {
            dataMap.put((Object)rowKey, (Object)bizKey, (Object)effectiveData);
        } else {
            int startIndex = effectiveData.startIndex;
            int startIndex1 = row.values().stream().map(v -> v.startIndex).findFirst().get();
            String msg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u884c\u4e0e\u7b2c%1$s\u884c\u7f16\u7801\u76f8\u540c\u3002", (String)"InvElimTemplatetImportPlugin_13", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), startIndex1 + 1);
            logger.log(Integer.valueOf(startIndex), msg).fail();
        }
    }

    private boolean checkModel(DynamicObject modelDy, List<ImportLogger.ImportLog> rowLogs, JSONObject data) {
        JSONObject modelJson = data.getJSONObject(MODEL);
        if (modelJson == null) {
            rowLogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvShareRelaImportNewPlugin_15", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0])));
            return false;
        }
        String shownumber = modelJson.getString("shownumber");
        if (shownumber == null) {
            shownumber = modelJson.getString(NUMBER);
        }
        if (!modelDy.getString("shownumber").equals(shownumber)) {
            rowLogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5f55\u5165\u4f53\u7cfb\u7f16\u7801\u4e3a\u5f53\u524d\u4f53\u7cfb\u3002", (String)"InvShareRelaImportNewPlugin_16", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0])));
            return false;
        }
        return true;
    }

    private Map<String, Map<String, DynamicObject>> dataFromDB(HashMultimap multimap, List<String> allDim) {
        HashMap<String, Map<String, DynamicObject>> dimDatas = new HashMap<String, Map<String, DynamicObject>>(16);
        allDim.stream().forEach(dim -> {
            String dimLow = dim.toLowerCase(Locale.ENGLISH);
            Set set = multimap.get((Object)dimLow);
            if (CollectionUtils.isNotEmpty((Collection)set)) {
                QFilter qFilters = new QFilter(MODEL, "=", (Object)this.modelId).and(NUMBER, "in", (Object)set);
                String entityNum = DimensionServiceHelper.getDimMembEntityNumByDimNum((String)dimLow);
                if (DataEntityUtils.isIncludeShareField((String)entityNum)) {
                    qFilters.and(new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex()));
                }
                if (MYCOMPANY.equals(dimLow) || INTERNALCOMPANY.equals(dimLow)) {
                    qFilters.or(NUMBER, "in", (Object)new String[]{SystemVarsEnum.MC_INV_UNIT.getNumber(), SystemVarsEnum.MC_SUB_UNIT.getNumber()});
                }
                if ("account".equals(dimLow)) {
                    qFilters.and(QFilter.of((String)"accountpart.isaccountoffset = ?", (Object[])new Object[]{true}));
                    qFilters.and(QFilter.of((String)"storagetype != ?", (Object[])new Object[]{"3"}));
                    qFilters.and(QFilter.of((String)"isleaf =?", (Object[])new Object[]{"1"}));
                }
                if ("audittrail".equals(dimLow)) {
                    qFilters.and("datasource", "=", (Object)"3");
                }
                Map<String, DynamicObject> dimValues = QueryServiceHelper.query((String)entityNum, (String)InvElimTemplatetImportPlugin.getDimField(dimLow), (QFilter[])new QFilter[]{qFilters}).stream().collect(Collectors.toMap(dy -> dy.getString(NUMBER), dy -> dy, (v1, v2) -> v2));
                if (dim.equals(DimTypesEnum.DATASORT.getNumber().toLowerCase(Locale.ROOT))) {
                    dimLow = "datasource";
                }
                dimDatas.put(dimLow, dimValues);
            }
        });
        return dimDatas;
    }

    public static String getDimField(String dimNum) {
        switch (dimNum.toLowerCase(Locale.ENGLISH)) {
            case "entity": {
                return "id,name,number,currency,isindependentorg,isleaf";
            }
            case "internalcompany": {
                return "id,name,number,longnumber,isleaf";
            }
        }
        return "id,name,number,isleaf";
    }

    private /* synthetic */ void lambda$getEffectiveData$18(List rowLogs, ImportLogger logger, List entityDimList, Map dbNumberS, Map templateCatalogFromDB, Map invRelaTypeConfig, Map templateRelationTypeFromDB, Map templateScenariosFromDB, Map templateEffectPeriodFromDB, Map templateElimCatalogFromDB, List allDim, String entityName, List importBillDataList, Map bizDatas, Table effectiveDatas, List addNewEffectiveDatas, ImportBillData importBillData) {
        JSONObject dataEntity = importBillData.getData();
        if (!this.checkModel(this.modelDy, rowLogs, dataEntity)) {
            logger.logAll(Integer.valueOf(importBillData.getStartIndex()), rowLogs).fail();
            rowLogs.clear();
            return;
        }
        HashMap<String, Map<String, DynamicObject>> dimDys = new HashMap<String, Map<String, DynamicObject>>(16);
        this.validDimMember(entityDimList, dbNumberS, rowLogs, dimDys, dataEntity);
        this.validProcess(rowLogs, dataEntity);
        this.validTemplateCatalog(templateCatalogFromDB, rowLogs, dimDys, dataEntity);
        this.validInvrelaType(invRelaTypeConfig, rowLogs, dataEntity, templateRelationTypeFromDB);
        this.validApplyScence(templateScenariosFromDB, rowLogs, dataEntity, dimDys);
        this.validEffectPeriod(templateEffectPeriodFromDB, rowLogs, dataEntity, dimDys);
        this.validTemplateElimCatalog(templateElimCatalogFromDB, rowLogs, dimDys, dataEntity);
        Boolean adjustment = dataEntity.getBoolean("adjustment");
        JSONArray invelimtplentry = dataEntity.getJSONArray("invelimtplentry");
        AtomicInteger index = new AtomicInteger();
        int logIndex = 0;
        for (Object json : invelimtplentry) {
            JSONObject data = (JSONObject)json;
            ArrayList<ImportLogger.ImportLog> entryRowLogs = new ArrayList<ImportLogger.ImportLog>(16);
            this.validDimMember(allDim, dbNumberS, entryRowLogs, dimDys, data);
            this.validRuleexpr(data, entryRowLogs, index);
            this.validEntity(data, entryRowLogs, adjustment);
            if (!entryRowLogs.isEmpty()) {
                if (logIndex == 0) {
                    rowLogs.addAll(entryRowLogs);
                } else {
                    logger.logAll(Integer.valueOf(importBillData.getStartIndex() + logIndex), entryRowLogs).fail();
                }
                entryRowLogs.clear();
            }
            ++logIndex;
        }
        if (rowLogs.isEmpty()) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
            dynamicObject = this.cvtDynamicObject(this.modelDy, dynamicObject, dataEntity, dimDys);
            this.moreNewAdd(dynamicObject);
            EffectiveData effectiveData = new EffectiveData(importBillData.getDataIndex(), importBillData.getStartIndex(), dynamicObject, dataEntity, dimDys);
            this.collectEffectiveData(effectiveData, logger, importBillDataList, bizDatas, (Table<String, String, EffectiveData>)effectiveDatas, addNewEffectiveDatas);
        } else {
            logger.logAll(Integer.valueOf(importBillData.getStartIndex()), rowLogs).fail();
            rowLogs.clear();
        }
    }

    private static class EffectiveData {
        final int dataIndex;
        final int startIndex;
        final DynamicObject data;
        final Map<String, Map<String, DynamicObject>> dimdys;
        public JSONObject dataJson;

        public EffectiveData(int dataIndex, int startIndex, DynamicObject data, JSONObject dataJson, Map<String, Map<String, DynamicObject>> dimdys) {
            this.dataIndex = dataIndex;
            this.startIndex = startIndex;
            this.data = data;
            this.dimdys = dimdys;
            this.dataJson = dataJson;
        }
    }
}

