/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FieldsetPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.invest.InvCurrencyType;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.intergration.formula.VFormulaPlugin;

public class InvExcRateFormulaPlugin
extends VFormulaPlugin {
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String COMBO_CURRENCY_SRC = "combo_currency_src";
    private static final String COMBO_CURRENCY_TAR = "combo_currency_tar";
    private static final String NUMBER = "number";
    private static final String MODEL = "model";
    private static final String IS_DRAFT = "is_draft";
    public static final String IS_COMMONPAPER = "is_commonpaper";
    private static final String PRE_FIX = "$";
    private Map<String, String> keyToEntity = new LinkedHashMap<String, String>(16);
    private Map<String, String> keyToName = new HashMap<String, String>(16);
    private Map<String, String> entityToKey = new HashMap<String, String>(16);

    public InvExcRateFormulaPlugin() {
        this.keyToEntity.put(COMBO_CURRENCY_SRC, "bcm_processmembertree");
        this.keyToEntity.put(COMBO_CURRENCY_TAR, "bcm_currencymembertree");
        this.entityToKey.put("bcm_processmembertree", COMBO_CURRENCY_SRC);
        this.entityToKey.put("bcm_currencymembertree", COMBO_CURRENCY_TAR);
        this.keyToName.put(COMBO_CURRENCY_SRC, ResManager.loadKDString((String)"\u539f\u5e01", (String)"InvVFormulaPlugin_16", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        this.keyToName.put(COMBO_CURRENCY_TAR, ResManager.loadKDString((String)"\u76ee\u6807\u5e01", (String)"InvVFormulaPlugin_17", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setEnableLock();
    }

    private void setEnableLock() {
        String enableStatus;
        if (this.getFormCustomParam("enable") != null && "C".equals(enableStatus = (String)this.getFormCustomParam("enable"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"confirm"});
            for (String k : this.keyToEntity.keySet()) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{k});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate source;
        super.beforeDoOperation(args);
        if (args.getSource() != null && args.getSource() instanceof FormOperate && "confirm".equals((source = (FormOperate)args.getSource()).getOperateKey())) {
            this.mustInputCheck();
        }
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        if (this.keyToEntity.containsKey(e.getKey())) {
            ComboEdit edit = new ComboEdit();
            edit.setKey(e.getKey());
            edit.setFieldKey(e.getKey());
            edit.setView(this.getView());
            edit.setModel(this.getModel());
            e.setControl((Control)edit);
        } else if ("bcm_processmembertree".equals(e.getKey()) && e.getControl() instanceof BasedataEditSingleMemberF7) {
            BasedataEditSingleMemberF7 processF7 = (BasedataEditSingleMemberF7)e.getControl();
            processF7.setCustomFilter(new QFilter("longnumber", "like", (Object)"Process!TCF!%"));
        } else if ("bcm_currencymembertree".equals(e.getKey()) && e.getControl() instanceof BasedataEditSingleMemberF7) {
            BasedataEditSingleMemberF7 processF7 = (BasedataEditSingleMemberF7)e.getControl();
            processF7.setCustomFilter(new QFilter(NUMBER, "not in", (Object)new String[]{"Currency", "EC", "PC", "DC", "OC"}));
        }
    }

    @Override
    public void addFieldToMemberpanel(FieldsetPanelAp fieldsetpanelap, Style style) {
        super.addFieldToMemberpanel(fieldsetpanelap, style);
        for (String key : this.keyToEntity.keySet()) {
            FieldAp f7Field = new FieldAp();
            f7Field.setName(new LocaleString(this.keyToName.get(key)));
            f7Field.setKey(key);
            f7Field.setFieldId(key);
            f7Field.setLabelDirection("v");
            f7Field.setStyle(this.getWideStyle());
            ComboField comboField = new ComboField();
            comboField.setKey(key);
            List<ComboItem> comboItems = this.getCurrencyComboItems();
            comboField.setItems(comboItems);
            comboField.setDefValue("1");
            comboField.setName(new LocaleString(this.keyToName.get(key)));
            comboField.setMustInput(COMBO_CURRENCY_SRC.equals(key));
            f7Field.setField((Field)comboField);
            f7Field.setFireUpdEvt(true);
            fieldsetpanelap.setHeight(new LocaleString("100%"));
            fieldsetpanelap.getItems().add(f7Field);
        }
    }

    public List<ComboItem> getCurrencyComboItems() {
        ArrayList comboItems = Lists.newArrayList();
        if (Boolean.TRUE.equals(this.getView().getFormShowParameter().getCustomParam(IS_COMMONPAPER))) {
            ComboItem item1 = new ComboItem(1, new LocaleString(InvCurrencyType.CURENTITYEC.getDesc()), InvCurrencyType.CURENTITYEC.getType());
            ComboItem item2 = new ComboItem(2, new LocaleString(InvCurrencyType.CURENTITYPC.getDesc()), InvCurrencyType.CURENTITYPC.getType());
            ComboItem item3 = new ComboItem(3, new LocaleString(InvCurrencyType.MEMBER.getDesc()), "6");
            comboItems.add(item1);
            comboItems.add(item2);
            comboItems.add(item3);
        } else {
            ComboItem item1 = new ComboItem(1, new LocaleString(InvCurrencyType.HOLDEREC.getDesc()), "1");
            ComboItem item2 = new ComboItem(2, new LocaleString(InvCurrencyType.HOLDERPC.getDesc()), "2");
            ComboItem item3 = new ComboItem(3, new LocaleString(InvCurrencyType.SHAREHOLDEREC.getDesc()), "3");
            ComboItem item4 = new ComboItem(4, new LocaleString(InvCurrencyType.SHAREHOLDERPC.getDesc()), "4");
            comboItems.add(item1);
            comboItems.add(item2);
            comboItems.add(item3);
            comboItems.add(item4);
            ComboItem item5 = new ComboItem(5, new LocaleString(InvCurrencyType.COMMONFATHEREC.getDesc()), "5");
            ComboItem item6 = new ComboItem(6, new LocaleString(InvCurrencyType.MEMBER.getDesc()), "6");
            comboItems.add(item5);
            comboItems.add(item6);
        }
        return comboItems;
    }

    @Override
    public void addFormulaParam(StringBuffer formula) {
        super.addFormulaParam(formula);
        String keyCYSrc = (String)this.getModel().getValue(COMBO_CURRENCY_SRC);
        String cySrcParam = DimTypesEnum.PROCESS.getShortNumber() + "." + this.getCYComboMembNumber(keyCYSrc);
        formula.append(",\"");
        formula.append(cySrcParam);
        formula.append('\"');
        String keyCYTar = (String)this.getModel().getValue(COMBO_CURRENCY_TAR);
        if (StringUtils.isNotEmpty((CharSequence)keyCYTar)) {
            String cyTarParam = DimTypesEnum.CURRENCY.getShortNumber() + "." + this.getCYComboMembNumber(keyCYTar);
            formula.append(",\"");
            formula.append(cyTarParam);
            formula.append('\"');
        }
    }

    private String getCYComboMembNumber(String key) {
        String prefix = "";
        if (Boolean.TRUE.equals(this.getView().getFormShowParameter().getCustomParam(IS_DRAFT))) {
            prefix = PRE_FIX;
        }
        switch (key) {
            case "1": {
                return prefix + "HOLDERORGEC";
            }
            case "2": {
                return prefix + "HOLDERORGPC";
            }
            case "3": {
                return prefix + "INVESTORGEC";
            }
            case "4": {
                return prefix + "INVESTORGPC";
            }
            case "5": {
                return prefix + "COMMONORGEC";
            }
            case "10": {
                return prefix + "CURENTITYEC";
            }
            case "11": {
                return prefix + "CURENTITYPC";
            }
        }
        return key.substring(0, key.length() - 3);
    }

    @Override
    public void dealmembValues(Map<String, String> membValues) {
        String cyNumSrc;
        String cyKey;
        super.dealmembValues(membValues);
        if (membValues.isEmpty()) {
            return;
        }
        Predicate<String> iscyMember = "7"::equals;
        String cyNumTar = membValues.get(DimTypesEnum.CURRENCY.getShortNumber());
        if (!StringUtils.isEmpty((CharSequence)cyNumTar)) {
            String cyKey2 = this.getCYComboKey(cyNumTar);
            if (iscyMember.test(cyKey2)) {
                DynamicObject cy = QueryServiceHelper.queryOne((String)"bcm_currencymembertree", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)this.getModelId()), new QFilter(NUMBER, "=", (Object)cyNumTar)});
                if (cy != null) {
                    this.rebuildComboEdit(COMBO_CURRENCY_TAR, cy, cyNumTar);
                }
            } else {
                this.getModel().beginInit();
                this.getModel().setValue(COMBO_CURRENCY_TAR, (Object)cyKey2);
                this.getModel().endInit();
                this.getView().updateView(COMBO_CURRENCY_TAR);
            }
        }
        if (iscyMember.test(cyKey = this.getCYComboKey(cyNumSrc = membValues.get(DimTypesEnum.PROCESS.getShortNumber())))) {
            DynamicObject cy = QueryServiceHelper.queryOne((String)"bcm_processmembertree", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)this.getModelId()), new QFilter(NUMBER, "=", (Object)cyNumSrc)});
            if (cy != null) {
                this.rebuildComboEdit(COMBO_CURRENCY_SRC, cy, cyNumTar);
            }
        } else {
            this.getModel().beginInit();
            this.getModel().setValue(COMBO_CURRENCY_SRC, (Object)cyKey);
            this.getModel().endInit();
            this.getView().updateView(COMBO_CURRENCY_SRC);
        }
        membValues.remove(DimTypesEnum.CURRENCY.getShortNumber());
        membValues.remove(DimTypesEnum.PROCESS.getShortNumber());
    }

    private String getCYComboKey(String key) {
        if (key == null) {
            return "5";
        }
        if (key.startsWith(PRE_FIX) && Boolean.TRUE.equals(this.getView().getFormShowParameter().getCustomParam(IS_DRAFT))) {
            key = key.substring(1);
        }
        switch (key) {
            case "HOLDERORGEC": {
                return "1";
            }
            case "HOLDERORGPC": {
                return "2";
            }
            case "INVESTORGEC": {
                return "3";
            }
            case "INVESTORGPC": {
                return "4";
            }
            case "COMMONORGEC": {
                return "5";
            }
            case "CURENTITYEC": {
                return "10";
            }
            case "CURENTITYPC": {
                return "11";
            }
        }
        return "7";
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (this.keyToEntity.containsKey(propertyName)) {
            String property = this.keyToEntity.get(propertyName);
            String key = (String)e.getChangeSet()[0].getNewValue();
            String oldkey = (String)e.getChangeSet()[0].getOldValue();
            this.getPageCache().put("oldkey", oldkey);
            if (StringUtils.isNotEmpty((CharSequence)property) & "6".equals(key)) {
                BasedataEditSingleMemberF7 changetypeEdit = (BasedataEditSingleMemberF7)this.getView().getControl(property);
                changetypeEdit.setCallBackClassName(this.getClass().getName());
                changetypeEdit.click();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (this.keyToEntity.values().contains(actionId)) {
            String key = this.entityToKey.get(actionId);
            if (e.getReturnData() == null) {
                this.getModel().beginInit();
                this.getModel().setValue(key, (Object)this.getPageCache().get("oldkey"));
                this.getModel().endInit();
                this.getPageCache().remove("oldkey");
                this.getView().updateView(key);
                return;
            }
            DynamicObject dy = (DynamicObject)e.getReturnData();
            this.rebuildComboEdit(key, dy, dy.getString(NUMBER));
        }
    }

    private void rebuildComboEdit(String key, DynamicObject dy, String dimensionnumber) {
        if (dy == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (String)"InvVFormulaPlugin_12", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), dimensionnumber));
            return;
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(key);
        List<kd.bos.form.field.ComboItem> comboItems = this.getComboItems(dy);
        comboEdit.setComboItems(comboItems);
        this.getModel().beginInit();
        this.getModel().setValue(key, (Object)(dy.getString(NUMBER) + "num"));
        this.getModel().endInit();
        comboEdit.getView().updateView(key);
    }

    private List<kd.bos.form.field.ComboItem> getComboItems(DynamicObject dy) {
        kd.bos.form.field.ComboItem item2;
        kd.bos.form.field.ComboItem item1;
        ArrayList comboItems = Lists.newArrayList();
        if (Boolean.TRUE.equals(this.getView().getFormShowParameter().getCustomParam(IS_COMMONPAPER))) {
            item1 = new kd.bos.form.field.ComboItem(new LocaleString(InvCurrencyType.CURENTITYEC.getDesc()), "10");
            item2 = new kd.bos.form.field.ComboItem(new LocaleString(InvCurrencyType.CURENTITYPC.getDesc()), "11");
            comboItems.add(item1);
            comboItems.add(item2);
        } else {
            item1 = new kd.bos.form.field.ComboItem(new LocaleString(InvCurrencyType.HOLDEREC.getDesc()), "1");
            item2 = new kd.bos.form.field.ComboItem(new LocaleString(InvCurrencyType.HOLDERPC.getDesc()), "2");
            kd.bos.form.field.ComboItem item3 = new kd.bos.form.field.ComboItem(new LocaleString(InvCurrencyType.SHAREHOLDEREC.getDesc()), "3");
            kd.bos.form.field.ComboItem item4 = new kd.bos.form.field.ComboItem(new LocaleString(InvCurrencyType.SHAREHOLDERPC.getDesc()), "4");
            comboItems.add(item1);
            comboItems.add(item2);
            comboItems.add(item3);
            comboItems.add(item4);
            kd.bos.form.field.ComboItem item5 = new kd.bos.form.field.ComboItem(new LocaleString(InvCurrencyType.COMMONFATHEREC.getDesc()), "5");
            comboItems.add(item5);
        }
        kd.bos.form.field.ComboItem item6 = new kd.bos.form.field.ComboItem(new LocaleString(InvCurrencyType.MEMBER.getDesc()), "6");
        kd.bos.form.field.ComboItem item7 = new kd.bos.form.field.ComboItem(new LocaleString(dy.getString("name")), dy.getString(NUMBER) + "num");
        item7.setItemVisible(false);
        comboItems.add(item6);
        comboItems.add(item7);
        return comboItems;
    }

    private void mustInputCheck() {
        Object value1 = this.getModel().getValue(COMBO_CURRENCY_SRC);
        String name1 = ResManager.loadKDString((String)"\u539f\u5e01", (String)"InvVFormulaPlugin_16", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
        String msg = ResManager.loadKDString((String)"\u3010%1$s\u3011\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvVFormulaPlugin_15", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
        if (Objects.isNull(value1)) {
            throw new KDBizException(String.format(msg, name1));
        }
    }
}

