/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.exchangeRate.BasedataEditSingleMemberF7Ext;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import kd.fi.bcm.spread.formula.EncoderService;

public class InvFunctionSettingPlugin
extends AbstractBaseFormPlugin {
    private static final WatchLogger WATCH_LOGGER = BcmLogFactory.getWatchLogInstance(InvFunctionSettingPlugin.class);
    private static final String CHANGE_TYPE = "changetype";
    private static final String CURRENCY = "currency";
    private static final List<String> DIMKEYS = Lists.newArrayList((Object[])new String[]{"changetype", "currency"});
    private static final String ACCOUNT = "account";
    private static final String NUMBER = "number";
    private static final String NUMBER_TYPE = "numbertype";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(DIMKEYS, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("confirm");
        BasedataEdit accountEdit = (BasedataEdit)this.getView().getControl(ACCOUNT);
        accountEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit ctEdit = (BasedataEdit)this.getView().getControl(CHANGE_TYPE);
        ctEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit cyEdit = (BasedataEdit)this.getView().getControl(CURRENCY);
        cyEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.getFormCustomParam("formula") != null) {
            String formula = (String)this.getFormCustomParam("formula");
            ExpressParser parser = new ExpressParser();
            EncoderService encoder = new EncoderService();
            try {
                Pair pair = parser.parse(formula, encoder);
                String aNumber = ((ParamItem)((IFormula)((List)pair.p2).get(0)).getParamList().get(1)).toString();
                String ctNumber = ((ParamItem)((IFormula)((List)pair.p2).get(0)).getParamList().get(2)).toString();
                String cyNumber = ((ParamItem)((IFormula)((List)pair.p2).get(0)).getParamList().get(3)).toString();
                String numbertype = ((ParamItem)((IFormula)((List)pair.p2).get(0)).getParamList().get(4)).toString();
                String startDate = ((ParamItem)((IFormula)((List)pair.p2).get(0)).getParamList().get(5)).toString();
                String endDate = ((ParamItem)((IFormula)((List)pair.p2).get(0)).getParamList().get(6)).toString();
                DynamicObject a = DimensionServiceHelper.queryMemberIdByNumber((String)"bcm_accountmembertree", (Object)this.getModelId(), (String)aNumber);
                DynamicObject ct = DimensionServiceHelper.queryMemberIdByNumber((String)"bcm_changetypemembertree", (Object)this.getModelId(), (String)ctNumber);
                DynamicObject cy = DimensionServiceHelper.queryMemberIdByNumber((String)"bcm_currencymembertree", (Object)this.getModelId(), (String)cyNumber);
                this.getModel().setValue(ACCOUNT, (Object)a.getLong("id"));
                this.getModel().setValue(CHANGE_TYPE, (Object)ct.getLong("id"));
                this.getModel().setValue(NUMBER_TYPE, (Object)numbertype);
                if (StringUtils.isNotEmpty((String)startDate) && StringUtils.isNotEmpty((String)endDate)) {
                    this.getModel().setValue(START_DATE, (Object)DateTimeUtils.parseDate((String)startDate, (String)"yyyy-MM-dd"));
                    this.getModel().setValue(END_DATE, (Object)DateTimeUtils.parseDate((String)endDate, (String)"yyyy-MM-dd"));
                }
                this.getModel().setValue(CURRENCY, (Object)(cy == null ? 0L : cy.getLong("id")));
                this.setNumberTYpeEnable(StringUtils.isEmpty((String)numbertype));
            }
            catch (Exception e1) {
                WATCH_LOGGER.error("error", (Throwable)e1);
            }
        } else {
            this.setNumberTYpeEnable(false);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        String f7Key = event.getProperty().getName();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("model.id", "=", (Object)this.getModelId()));
        switch (f7Key) {
            case "account": {
                DynamicObjectCollection doc = InvestServiceHelper.getInvChangeAccountSetting((long)this.getModelId());
                HashSet ids = Sets.newHashSet();
                for (DynamicObject object : doc) {
                    ids.add(object.getLong("account.id"));
                }
                qFilters.add(new QFilter("id", "in", (Object)ids));
                ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().setQFilters(qFilters);
                break;
            }
            case "currency": {
                qFilters.add(new QFilter(NUMBER, "!=", (Object)"DC"));
                ((BasedataEditSingleMemberF7Ext)((Object)event.getSource())).getQFilters().addAll(qFilters);
                BasedataEditSingleMemberF7Ext dataSort = (BasedataEditSingleMemberF7Ext)((Object)event.getSource());
                dataSort.setCustomFilter(new QFilter(NUMBER, "!=", (Object)"DC"));
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("confirm".equals(key)) {
            this.validateData();
            String aNumber = ((DynamicObject)this.getModel().getValue(ACCOUNT)).getString(NUMBER);
            String aName = ((DynamicObject)this.getModel().getValue(ACCOUNT)).getString("name");
            String ctNumber = ((DynamicObject)this.getModel().getValue(CHANGE_TYPE)).getString(NUMBER);
            String ctName = ((DynamicObject)this.getModel().getValue(CHANGE_TYPE)).getString("name");
            String cyNumber = this.getModel().getValue(CURRENCY) == null ? "" : ((DynamicObject)this.getModel().getValue(CURRENCY)).getString(NUMBER);
            String numberType = (String)this.getModel().getValue(NUMBER_TYPE);
            Date startDate = (Date)this.getModel().getValue(START_DATE);
            Date endDate = (Date)this.getModel().getValue(END_DATE);
            String invFormula = "";
            if (startDate != null && endDate != null) {
                invFormula = "Inv(\"\",\"" + aNumber + "\",\"" + ctNumber + "\",\"" + cyNumber + "\",\"" + numberType + "\",\"" + DateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd") + "\",\"" + DateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd") + "\")";
            } else if (startDate == null && endDate == null) {
                invFormula = "Inv(\"\",\"" + aNumber + "\",\"" + ctNumber + "\",\"" + cyNumber + "\",\"" + numberType + "\",\"\",\"\")";
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5e94\u540c\u65f6\u586b\u5199\u6216\u4e0d\u586b\u5199\u3002", (String)"InvFunctionSettingPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            HashMap map = Maps.newHashMap();
            map.put("formula", invFormula);
            map.put("name", aName + "|" + ctName);
            this.getView().returnDataToParent((Object)map);
            this.getView().close();
        }
    }

    private void validateData() {
        if (this.getModel().getValue(ACCOUNT) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79d1\u76ee\u3002", (String)"InvFunctionSettingPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        if (this.getModel().getValue(CHANGE_TYPE) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d8\u52a8\u7c7b\u578b\u3002", (String)"InvFunctionSettingPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (NUMBER_TYPE.equals(key)) {
            boolean flag = StringUtils.isEmpty((String)((String)e.getChangeSet()[0].getNewValue()));
            this.setNumberTYpeEnable(flag);
        }
    }

    private void setNumberTYpeEnable(boolean flag) {
        if (!flag) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{START_DATE, END_DATE});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{START_DATE, END_DATE});
        }
    }
}

