/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.metadata.form.Margin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.adjust.formula.AdjustFormulaParseHelper;
import kd.fi.bcm.business.formula.calculate.adjust.GetJLEntryCalculate;
import kd.fi.bcm.business.formula.model.adjust.GetJLEntryFormula;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaParseHelper;
import kd.fi.bcm.business.page.model.Area;
import kd.fi.bcm.business.page.model.BaseEditElement;
import kd.fi.bcm.business.page.model.ComboEditElement;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.invest.InvCurrencyType;
import kd.fi.bcm.common.enums.invest.InvOrgType;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import kd.fi.bcm.spread.formula.expr.StringExpr;

public class InvGetJLEntryFormulaPlugin
extends AbstractBaseFormPlugin
implements DynamicPage,
SingleMemberF7Util.ISingleMemberF7Handle {
    private SchemeContext sctx;
    private boolean isInit = false;
    private final Map<String, String> keyToName = new HashMap<String, String>(16);

    public InvGetJLEntryFormulaPlugin() {
        this.keyToName.put("Entity".toLowerCase(Locale.ENGLISH), ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"InvGetJLEntryFormulaPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.keyToName.put("InternalCompany".toLowerCase(Locale.ENGLISH), ResManager.loadKDString((String)"\u5f80\u6765\u7ec4\u7ec7", (String)"InvGetJLEntryFormulaPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.keyToName.put("MyCompany".toLowerCase(Locale.ENGLISH), ResManager.loadKDString((String)"\u6211\u65b9\u7ec4\u7ec7", (String)"InvGetJLEntryFormulaPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.keyToName.put("Currency".toLowerCase(Locale.ENGLISH), ResManager.loadKDString((String)"\u5e01\u79cd", (String)"InvGetJLEntryFormulaPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String ctrlKey = e.getKey();
        if (ctrlKey.startsWith("bcm_")) {
            String dimKey = ctrlKey.replace("bcm_", "");
            Dimension dim = this.getSctx().getDimensionByNumber("merge".equals(dimKey) ? "Entity" : dimKey);
            if (dim != null) {
                BasedataEditSingleMemberF7 sf7 = SingleMemberF7Util.createBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), dim.getId(), ctrlKey, this, false, SingleF7TypeEnum.COMMON);
                sf7.setF7title(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9", (String)"InvGetJLEntryFormulaPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                sf7.setDisplayAllFyOrPeriodMemb(true);
                sf7.addBeforeF7SelectListener(this);
                e.setControl((Control)sf7);
            }
        }
    }

    @Override
    public void beforeSingleMemberF7Select(BeforeF7SelectEvent arg0) {
        Object source = arg0.getSource();
        if (source instanceof BasedataEditSingleMemberF7) {
            ((BasedataEditSingleMemberF7)((Object)source)).setCustomFilter(new QFilter("model", "=", (Object)this.getModelId()));
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        if (e.getSource() instanceof BasedataEditSingleMemberF7) {
            BasedataEditSingleMemberF7 sf7 = (BasedataEditSingleMemberF7)((Object)e.getSource());
            e.getCustomQFilters().add(new QFilter("model.id", "=", (Object)this.getModelId()));
            if ("bcm_userdefinedmembertree".equals(sf7.getEntity())) {
                e.getCustomQFilters().add(new QFilter("dimension.id", "=", (Object)sf7.getDimId()));
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.createSingleF7Area();
        this.refreshFomulaValue();
    }

    private void createSingleF7Area() {
        Area area = new Area("membfieldpanel");
        BaseEditElement mergeElement = new BaseEditElement(ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9", (String)"InvGetJLEntryFormulaPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), "bcm_merge", "bcm_entitymembertree");
        mergeElement.getStyle().setMargin(this.createMarginStyle());
        mergeElement.setDisplayProp("number,name");
        area.addElement((Element)mergeElement);
        ComboEditElement mergeScopeElement = new ComboEditElement("mergescope", ResManager.loadKDString((String)"\u5408\u5e76\u8303\u56f4", (String)"InvGetJLEntryFormulaPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (List)Lists.newArrayList());
        mergeScopeElement.getStyle().setMargin(this.createMarginStyle());
        mergeScopeElement.getItems().add(new ComboItem(new LocaleString(RangeEnum.VALUE_10.getName()), RangeEnum.VALUE_10.getNumber()));
        mergeScopeElement.getItems().add(new ComboItem(new LocaleString(RangeEnum.VALUE_110.getName()), RangeEnum.VALUE_110.getNumber()));
        mergeScopeElement.setMustinput(Boolean.FALSE.booleanValue());
        area.addElement((Element)mergeScopeElement);
        for (Dimension p2 : this.getSctx().getDimensions()) {
            BaseEditElement dimElement;
            if ("Scenario".equals(p2.getNumber()) || "Year".equals(p2.getNumber()) || "Period".equals(p2.getNumber())) {
                dimElement = new BaseEditElement(p2.getName(), "bcm_" + p2.getNumber().toLowerCase(), p2.getEntity());
                dimElement.getStyle().setMargin(this.createMarginStyle());
                dimElement.setDisplayProp("number,name");
                dimElement.setNumber(p2.getNumber());
                dimElement.setMustInput(Boolean.FALSE.booleanValue());
                area.addElement((Element)dimElement);
                continue;
            }
            if ("Entity".equals(p2.getNumber()) || "MyCompany".equals(p2.getNumber()) || "InternalCompany".equals(p2.getNumber()) || "Currency".equals(p2.getNumber())) {
                dimElement = new ComboEditElement(p2.getNumber().toLowerCase(), p2.getName(), this.getComboItems(null, p2.getNumber()));
                dimElement.getStyle().setMargin(this.createMarginStyle());
                dimElement.setMustInput(Boolean.TRUE.booleanValue());
                area.addElement((Element)dimElement);
                continue;
            }
            dimElement = new BaseEditElement(p2.getName(), "bcm_" + p2.getNumber().toLowerCase(), p2.getEntity());
            dimElement.getStyle().setMargin(this.createMarginStyle());
            dimElement.setDisplayProp("number,name");
            dimElement.setNumber(p2.getNumber());
            dimElement.setMustInput(Boolean.TRUE.booleanValue());
            area.addElement((Element)dimElement);
        }
        ComboEditElement computeTypeElement = new ComboEditElement("computetype", ResManager.loadKDString((String)"\u8ba1\u7b97\u65b9\u5f0f", (String)"InvGetJLEntryFormulaPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (List)Lists.newArrayList());
        computeTypeElement.getStyle().setMargin(this.createMarginStyle());
        computeTypeElement.getItems().add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838", (String)"InvGetJLEntryFormulaPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "-"));
        computeTypeElement.getItems().add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u975e\u5ba1\u6838", (String)"InvGetJLEntryFormulaPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "0"));
        computeTypeElement.getItems().add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u533a\u5206", (String)"InvGetJLEntryFormulaPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "1"));
        computeTypeElement.setMustinput(Boolean.FALSE.booleanValue());
        area.addElement((Element)computeTypeElement);
        area.getElementListList().forEach(p -> {
            p.setLabelDirection("v");
            p.setLabelWidth(new LocaleString("100%"));
        });
        Page page = new Page();
        page.addArea(area);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
    }

    private void refreshFomulaValue() {
        String formula = (String)this.getFormCustomParam("formula");
        if (formula != null) {
            try {
                FunctionExpr expr = (FunctionExpr)ExcelFormulaPaserHelper.parse((String)formula);
                String mergeNum = AdjustFormulaParseHelper.handelParam(expr.getParameters().get((Integer)GetJLEntryCalculate.indexMap.get("merge")));
                IDNumberTreeNode memeNode = MemberReader.findEntityMemberByNum((String)this.getSctx().getModelNumber(), (String)mergeNum);
                if (memeNode != IDNumberTreeNode.NotFoundTreeNode) {
                    DynamicObject o = BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymembertree");
                    o.set("id", (Object)memeNode.getId());
                    o.set("name", (Object)memeNode.getName());
                    o.set("number", (Object)memeNode.getNumber());
                    this.setValue("bcm_merge", o);
                }
                this.setValue("mergescope", AdjustFormulaParseHelper.handelParam(expr.getParameters().get((Integer)GetJLEntryCalculate.indexMap.get("mergescope"))));
                String dimensionField = AdjustFormulaParseHelper.handelParam(expr.getParameters().get((Integer)GetJLEntryCalculate.indexMap.get("dimensionMem")));
                for (String itemStr : dimensionField.split(",")) {
                    DynamicObject o;
                    IDNumberTreeNode memNode;
                    String[] dimFieldPath = GetJLEntryFormula.splitDimAndMemb((String)itemStr);
                    if (dimFieldPath.length != 2) continue;
                    Dimension dim = this.getSctx().getDimensionByShortNum(dimFieldPath[0]);
                    String membNum = AdjustFormulaParseHelper.handelParam((Object)dimFieldPath[1]);
                    if ("Currency".equals(dim.getNumber())) {
                        membNum = this.getCYComboKeyByMembNum(membNum);
                        memNode = BcmThreadCache.findMemberByNum((String)this.getCurModelNumber(), (String)dim.getNumber(), (String)membNum);
                        if (memNode == IDNumberTreeNode.NotFoundTreeNode) {
                            this.setValue(dim.getFieldmapped(), membNum);
                            continue;
                        }
                        o = BusinessDataServiceHelper.newDynamicObject((String)dim.getEntity());
                        o.set("id", (Object)memNode.getId());
                        o.set("name", (Object)memNode.getName());
                        o.set("number", (Object)memNode.getNumber());
                        this.rebuildComboEdit(dim.getFieldmapped(), o);
                        continue;
                    }
                    if ("Entity".equals(dim.getNumber()) || "MyCompany".equals(dim.getNumber()) || "InternalCompany".equals(dim.getNumber())) {
                        membNum = this.getComboKeyByMembNum(membNum);
                        memNode = BcmThreadCache.findMemberByNum((String)this.getCurModelNumber(), (String)dim.getNumber(), (String)membNum);
                        if (memNode == IDNumberTreeNode.NotFoundTreeNode) {
                            this.setValue(dim.getFieldmapped(), membNum);
                            continue;
                        }
                        o = BusinessDataServiceHelper.newDynamicObject((String)dim.getEntity());
                        o.set("id", (Object)memNode.getId());
                        o.set("name", (Object)memNode.getName());
                        o.set("number", (Object)memNode.getNumber());
                        this.rebuildComboEdit(dim.getFieldmapped(), o);
                        continue;
                    }
                    memNode = BcmThreadCache.findMemberByNum((String)this.getCurModelNumber(), (String)dim.getNumber(), (String)membNum);
                    if (memNode == IDNumberTreeNode.NotFoundTreeNode) continue;
                    o = BusinessDataServiceHelper.newDynamicObject((String)dim.getEntity());
                    o.set("id", (Object)memNode.getId());
                    o.set("name", (Object)memNode.getName());
                    o.set("number", (Object)memNode.getNumber());
                    this.setValue("bcm_" + dim.getNumber().toLowerCase(), o);
                }
                String computetype = AdjustFormulaParseHelper.handelParam(expr.getParameters().get((Integer)GetJLEntryCalculate.indexMap.get("computetype")));
                this.setValue("computetype", StringUtils.isEmpty((CharSequence)computetype) ? "-" : computetype);
            }
            catch (Exception e1) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s \u65e0\u6548\u516c\u5f0f", (String)"InvGetJLEntryFormulaPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), formula));
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (this.isInit) {
            return;
        }
        if (this.keyToName.containsKey(propertyName)) {
            this.isInit = true;
            String key = (String)e.getChangeSet()[0].getNewValue();
            String oldkey = (String)e.getChangeSet()[0].getOldValue();
            if (propertyName.equalsIgnoreCase("Entity") || propertyName.equalsIgnoreCase("InternalCompany") || propertyName.equalsIgnoreCase("MyCompany")) {
                if ("3".equals(key)) {
                    if (StringUtils.isNotEmpty((CharSequence)oldkey)) {
                        this.setValue(propertyName, oldkey);
                    }
                    Dimension dim = this.getSctx().getDimensionByNumber(propertyName);
                    BasedataEditSingleMemberF7 sf7 = SingleMemberF7Util.createBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), dim.getId(), propertyName, this, false, SingleF7TypeEnum.COMMON);
                    sf7.setF7title(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9", (String)"InvGetJLEntryFormulaPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    sf7.setDisplayAllFyOrPeriodMemb(true);
                    sf7.setCallBackClassName(this.getClass().getName());
                    sf7.click();
                }
            } else if (propertyName.equalsIgnoreCase("Currency") && "6".equals(key)) {
                if (StringUtils.isNotEmpty((CharSequence)oldkey)) {
                    this.setValue(propertyName, oldkey);
                }
                Dimension dim = this.getSctx().getDimensionByNumber(propertyName);
                BasedataEditSingleMemberF7 sf7 = SingleMemberF7Util.createBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), dim.getId(), propertyName, this, false, SingleF7TypeEnum.COMMON);
                sf7.setF7title(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9", (String)"InvGetJLEntryFormulaPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                sf7.setDisplayAllFyOrPeriodMemb(true);
                sf7.setCallBackClassName(this.getClass().getName());
                sf7.click();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (this.keyToName.containsKey(actionId) && e.getReturnData() != null) {
            this.rebuildComboEdit(actionId, (DynamicObject)e.getReturnData());
        }
    }

    private void rebuildComboEdit(String sign, DynamicObject dy) {
        Page page = this.getPage(this.getView());
        ((ComboEditElement)page.findElementBySign(sign)).setItems(this.getComboItems(dy, sign));
        page.getAreaList().forEach(area -> area.getElementListList().forEach(element1 -> element1.getStyle().setMargin(this.createMarginStyle())));
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
        this.setValue(sign, dy.getString("number"));
    }

    private List<ComboItem> getComboItems(DynamicObject dy, String key) {
        ArrayList comboItems = Lists.newArrayList();
        if (key.equalsIgnoreCase("Currency")) {
            comboItems.add(new ComboItem(new LocaleString(InvCurrencyType.HOLDEREC.getDesc()), "1"));
            comboItems.add(new ComboItem(new LocaleString(InvCurrencyType.HOLDERPC.getDesc()), "2"));
            comboItems.add(new ComboItem(new LocaleString(InvCurrencyType.SHAREHOLDEREC.getDesc()), "3"));
            comboItems.add(new ComboItem(new LocaleString(InvCurrencyType.SHAREHOLDERPC.getDesc()), "4"));
            comboItems.add(new ComboItem(new LocaleString(InvCurrencyType.COMMONFATHEREC.getDesc()), "5"));
            comboItems.add(new ComboItem(new LocaleString(InvCurrencyType.MEMBER.getDesc()), "6"));
            if (dy != null) {
                comboItems.add(new ComboItem(null, new LocaleString(dy.getString("name")), dy.getString("number"), false));
            }
        } else {
            comboItems.add(new ComboItem(new LocaleString(InvOrgType.HOLDER.getDesc()), "1"));
            comboItems.add(new ComboItem(new LocaleString(InvOrgType.INVESTORG.getDesc()), "2"));
            comboItems.add(new ComboItem(new LocaleString(InvOrgType.MEMBER.getDesc()), "3"));
            if (dy != null) {
                comboItems.add(new ComboItem(null, new LocaleString(dy.getString("name")), dy.getString("number"), false));
            }
        }
        return comboItems;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String oprtId = args.getOperateKey();
        if ("confirm".equals(oprtId)) {
            DynamicObject mergeDy = this.getModel().getDataEntity().getDynamicObject("bcm_merge");
            String mergeNum = mergeDy == null ? "" : mergeDy.getString("number");
            Object mergeScope = this.getModel().getValue("mergescope");
            Object computetype = this.getModel().getValue("computetype");
            this.getView().returnDataToParent((Object)InvestFormulaParseHelper.createFunctionExpr((String)"GETJLENTRY", (Object[])new Object[]{new StringExpr(mergeNum), new StringExpr(mergeScope == null ? "" : mergeScope.toString()), new StringExpr(this.createDimensionStr()), new StringExpr(computetype == null ? "" : computetype.toString())}).toString());
        }
        this.getView().close();
    }

    private String createDimensionStr() {
        StringJoiner sb = new StringJoiner(",");
        for (Dimension p : this.getSctx().getDimensions()) {
            String combKey;
            DynamicObject dyna;
            if ("Scenario".equals(p.getNumber()) || "Year".equals(p.getNumber()) || "Period".equals(p.getNumber())) {
                dyna = this.getModel().getDataEntity().getDynamicObject("bcm_" + p.getFieldmapped());
                if (dyna == null) continue;
                sb.add(p.getShortnum() + '.' + this.getMembNumByCombo(dyna.getString("number")));
                continue;
            }
            if ("Entity".equals(p.getNumber()) || "MyCompany".equals(p.getNumber()) || "InternalCompany".equals(p.getNumber())) {
                combKey = this.getModel().getDataEntity().getString(p.getFieldmapped());
                if (StringUtils.isEmpty((CharSequence)combKey)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvGetJLEntryFormulaPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), p.getName()));
                }
                sb.add(p.getShortnum() + '.' + this.getMembNumByCombo(combKey));
                continue;
            }
            if ("Currency".equals(p.getNumber())) {
                combKey = this.getModel().getDataEntity().getString(p.getFieldmapped());
                if (StringUtils.isEmpty((CharSequence)combKey)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvGetJLEntryFormulaPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), p.getName()));
                }
                sb.add(p.getShortnum() + '.' + this.getCYMembNumByCombo(combKey));
                continue;
            }
            dyna = this.getModel().getDataEntity().getDynamicObject("bcm_" + p.getNumber().toLowerCase());
            if (dyna == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvGetJLEntryFormulaPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), p.getName()));
            }
            sb.add(p.getShortnum() + '.' + this.getMembNumByCombo(dyna.getString("number")));
        }
        return sb.toString();
    }

    private String getMembNumByCombo(String memeNum) {
        switch (memeNum) {
            case "1": {
                return "$HolderOrg";
            }
            case "2": {
                return "$InvestOrg";
            }
        }
        return memeNum.contains(".") ? "[" + memeNum + "]" : memeNum;
    }

    private String getComboKeyByMembNum(String membNum) {
        switch (membNum) {
            case "$HolderOrg": {
                return "1";
            }
            case "$InvestOrg": {
                return "2";
            }
        }
        return membNum;
    }

    private String getCYMembNumByCombo(String key) {
        switch (key) {
            case "1": {
                return "$HOLDERORGEC";
            }
            case "2": {
                return "$HOLDERORGPC";
            }
            case "3": {
                return "$INVESTORGEC";
            }
            case "4": {
                return "$INVESTORGPC";
            }
            case "5": {
                return "$COMMONORGEC";
            }
        }
        return key.contains(".") ? "[" + key + "]" : key;
    }

    private String getCYComboKeyByMembNum(String key) {
        switch (key) {
            case "$HOLDERORGEC": {
                return "1";
            }
            case "$HOLDERORGPC": {
                return "2";
            }
            case "$INVESTORGEC": {
                return "3";
            }
            case "$INVESTORGPC": {
                return "4";
            }
            case "$COMMONORGEC": {
                return "5";
            }
        }
        return key;
    }

    private Margin createMarginStyle() {
        Margin margin = new Margin();
        margin.setTop("1px");
        margin.setBottom("15px");
        margin.setLeft("60px");
        return margin;
    }

    private SchemeContext getSctx() {
        if (this.sctx == null) {
            this.sctx = new SchemeContext(this.getModelId());
        }
        return this.sctx;
    }

    @Override
    public boolean needCache() {
        return false;
    }
}

