/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.operate.Audit;
import kd.bos.entity.operate.UnAudit;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.Copy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.check.CheckUtil;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.KDAssert;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.template.AbstractTemplateListPlugin;
import kd.fi.bcm.formplugin.util.TemplateUtil;
import kd.fi.bcm.spread.common.util.StringUtil;

public class InvLimListPlugin
extends AbstractTemplateListPlugin {
    private static final String CACHE_INIT = "CACHE_INIT";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String MODEL = "model";
    public static final String IMPORTDATABACK = "importdataback";
    public static final String BCM_INVELIMTEMPLATE = "bcm_invelimtemplate";
    private static final String CTL_BILLSTAP = "billlistap";
    private static Set<String> dimKeys = Sets.newHashSet((Object[])new String[]{"scenario"});
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance((boolean)true, InvLimListPlugin.class);

    private String getOperationStstusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"InvLimListPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"InvLimListPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private String getOperationExport() {
        return ResManager.loadKDString((String)"\u5bfc\u51fa", (String)"CheckUpChkListPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private String getOperationView() {
        return ResManager.loadKDString((String)"\u67e5\u770b", (String)"InvLimListPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private String getOperationCopy() {
        return ResManager.loadKDString((String)"\u590d\u5236", (String)"InvLimListPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.getPageCache().get(CACHE_INIT) == null) {
            FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
            fc.setBillFormId(BCM_INVELIMTEMPLATE);
            fc.setTitle(new LocaleString(ResManager.loadKDString((String)"\u6743\u76ca\u62b5\u9500", (String)"InvLimListPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])));
            this.getPageCache().put(CACHE_INIT, "false");
        }
        HashMap map = new HashMap();
        this.asMapF7toType(new ArrayList<String>(dimKeys), SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    protected void newTemplateCatalog(String nodeId, boolean isAddNew) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(MODEL, this.getPageCache().get("KEY_MODEL_ID"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_templatecatalog");
        if (isAddNew) {
            long id = Long.parseLong(nodeId);
            params.put("parent", id);
            params.put("type", "add");
            params.put("catcalogType", Character.valueOf(TemplateCatalogTypeEnum.INVCATALOG.getType()));
            this.showForm(this.getTemplateCataLogEntryEntity(), params, closeCallBack, ShowType.Modal, 0L);
        } else {
            super.newTemplateCatalog(nodeId, isAddNew);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshBillByUserSelect(new ArrayList<String>(dimKeys), true);
        this.refrushTree();
        this.refreshList();
    }

    @Override
    protected void refrushBillList() {
        ArrayList qFilters = Lists.newArrayList();
        this.setFilter(new SetFilterEvent(new Object(), (List)qFilters, ""));
        BillList billList = (BillList)this.getView().getControl(CTL_BILLSTAP);
        FilterParameter filterParameter = new FilterParameter();
        filterParameter.setQFilters((List)qFilters);
        billList.setFilterParameter(filterParameter);
        billList.setClearSelection(true);
        billList.setOrderBy(TemplateUtil.getListEntryOrderBy(true));
        billList.refresh();
    }

    @Override
    protected void initTree() {
        this.updateOldCatalog();
        super.initTree();
    }

    @Override
    protected String getTemplateCataLogEntryEntity() {
        return "bcm_invtemplatecatalog";
    }

    private void updateOldCatalog() {
        String modelID = this.getPageCache().get("KEY_MODEL_ID");
        QFilter fmodelid = new QFilter(MODEL, "=", (Object)LongUtil.toLong((Object)modelID));
        QFilter ftype = new QFilter("parent.id", "=", (Object)0);
        if (!QueryServiceHelper.exists((String)this.getTemplateCataLogEntryEntity(), (QFilter[])fmodelid.and(ftype).toArray())) {
            DynamicObject rootCopy = BusinessDataServiceHelper.newDynamicObject((String)this.getTemplateCataLogEntryEntity());
            rootCopy.set("name", (Object)ResManager.loadKDString((String)"\u6a21\u677f\u5206\u7c7b", (String)"InvLimListPlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            rootCopy.set("number", (Object)"root");
            rootCopy.set("parent", (Object)0);
            rootCopy.set(MODEL, (Object)modelID);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rootCopy});
        }
    }

    @Override
    protected QFilter getCatalogtypeQFilter() {
        return new QFilter("catalogtype", "=", (Object)Character.valueOf(TemplateCatalogTypeEnum.INVCATALOG.getType())).or("parent.id", "=", (Object)0);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        IDataModel model = this.getModel();
        DynamicObject modelDyn = (DynamicObject)model.getValue(MODEL);
        DynamicObject sceneDyn = (DynamicObject)model.getValue("scenario");
        if (modelDyn == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4f53\u7cfb\u6216\u60c5\u666f\u540e\u518d\u8fdb\u884c\u540e\u7eed\u64cd\u4f5c", (String)"InvLimListPlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        BillShowParameter parameter = e.getParameter();
        if (parameter.getStatus() == OperationStatus.ADDNEW) {
            parameter.setCustomParam(MODEL, modelDyn.getPkValue());
            if (Objects.nonNull(sceneDyn)) {
                parameter.setCustomParam("scenario", (Object)this.toByteSerialized(sceneDyn));
            }
            parameter.setCustomParam("templateCatalog", (Object)this.getPageCache().get("focusnodeid"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (e.getChangeSet()[0].getNewValue() == null || e.getChangeSet()[0].getNewValue() instanceof DynamicObject) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (MODEL.equals(propName)) {
                if (this.getPageCache().get("chooseBackModel") != null) {
                    return;
                }
                if (newValue == null) {
                    this.getModel().setValue(MODEL, ((DynamicObject)e.getChangeSet()[0].getOldValue()).get("id"));
                }
                try {
                    this.propertyChangedModelUse(new ArrayList<String>(dimKeys));
                }
                finally {
                    this.getPageCache().remove("chooseBackModel");
                }
                this.refrushTree();
                this.refreshList();
            } else if (dimKeys.contains(propName)) {
                Boolean isSureReturn = this.propertyChangedDimUse(propName, newValue, false, false);
                if (!isSureReturn.booleanValue()) {
                    return;
                }
                this.refrushTree();
                this.refreshList();
            }
        }
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        IDataModel model = this.getModel();
        DynamicObject modelDyn = (DynamicObject)model.getValue(MODEL);
        DynamicObject sceneDyn = (DynamicObject)model.getValue("scenario");
        List qFilters = e.getQFilters();
        if (modelDyn == null) {
            qFilters.clear();
            qFilters.add(new QFilter("1", "!=", (Object)1));
            return;
        }
        qFilters.add(QFilter.of((String)"model = ?", (Object[])new Object[]{modelDyn.getPkValue()}));
        qFilters.add(new QFilter("id", "in", (Object)CheckUtil.getApplySceneTmpls((Long)this.getModelId(), (Long)(sceneDyn != null ? sceneDyn.getLong("id") : 0L), (String)BCM_INVELIMTEMPLATE)));
        e.setOrderBy(this.orderKey());
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (StringUtils.equalsIgnoreCase((CharSequence)evt.getActionId(), (CharSequence)IMPORTDATABACK)) {
            this.refreshList();
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (!"tblcheck".equals(evt.getItemKey()) && !"tblunaudit".equals(evt.getItemKey())) {
            if ("btn_distribute".equals(evt.getItemKey())) {
                this.openElimDistributePage();
            } else if ("btn_export".equals(evt.getItemKey())) {
                this.exportElimTpl();
            } else if ("btn_import".equals(evt.getItemKey())) {
                String str = ResManager.loadKDString((String)"\u6743\u76ca\u62b5\u9500\u6a21\u677f", (String)"InvLimListPlugin_19", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                super.invokeOperation(BCM_INVELIMTEMPLATE, "kd.fi.bcm.formplugin.invest.InvElimTemplatetImportPlugin", str, IMPORTDATABACK);
            }
        }
    }

    private void exportElimTpl() {
        BillList billList = (BillList)this.getControl(CTL_BILLSTAP);
        ListSelectedRowCollection ls = billList.getSelectedRows();
        try {
            if (ls.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8bb0\u5f55\u3002", (String)"InvLimListPlugin_17", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            HashSet<Object> set = new HashSet<Object>(16);
            for (ListSelectedRow row : ls) {
                set.add(row.getPrimaryKeyValue());
            }
            Map fromCache = BusinessDataServiceHelper.loadFromCache((String)BCM_INVELIMTEMPLATE, (QFilter[])new QFilter("id", "in", set).toArray());
            DynamicObject[] dys = fromCache.values().stream().sorted(Comparator.comparing(dy -> dy.getString(this.orderKey()))).collect(Collectors.toList()).toArray(new DynamicObject[0]);
            Arrays.stream(dys).forEach(e -> {
                DynamicObject relationTypeDy = e.getDynamicObject("invrelatypebase");
                KDAssert.assertTrue((relationTypeDy != null ? 1 : 0) != 0, () -> new KDBizException(String.format(ResManager.loadKDString((String)"\u6a21\u677f\u201c%1$s\u201d\u7684\u6301\u80a1\u6bd4\u4f8b\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"InvLimListPlugin_20", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), e.getString("billno"))));
                e.set("invrelatypenum", (Object)relationTypeDy.getString("number"));
                e.set("categorized", (Object)relationTypeDy.getString("categorized"));
                DynamicObjectCollection entryDys = e.getDynamicObjectCollection("invelimtplentry");
                entryDys.forEach(entry -> {
                    String ruleexpr = entry.getString("ruleexpr");
                    String ruleexprdept = entry.getString("ruleexprdept");
                    String ruleexprsource = entry.getString("ruleexprsource");
                    if (StringUtils.isNotBlank((CharSequence)ruleexpr)) {
                        entry.set("ruleexpr", (Object)ruleexprsource);
                    }
                    if (StringUtils.isNotBlank((CharSequence)ruleexprdept)) {
                        entry.set("ruleexprdept", (Object)ruleexprsource);
                    }
                });
            });
            String routeAppId = this.getView().getFormShowParameter().getServiceAppId();
            String url = ExportUtil.export((DynamicObject[])dys, (String)routeAppId, (String)BCM_INVELIMTEMPLATE);
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                this.downloadFile(url, "bcm_invelimlist", "3JQ54S6HP97V");
                this.writeOperationLog(this.getOperationExport(), this.getOperationStstusSuccess());
            }
        }
        catch (Exception e2) {
            for (ListSelectedRow row : ls) {
                this.writeOperationLog(this.getOperationExport(), row.getNumber(), row.getName(), this.getOperationStstusFail());
            }
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u5bfc\u51fa\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s\u3002", (String)"InvRelationSearchPlugin_17", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), e2.getMessage()));
        }
    }

    private String orderKey() {
        return "billno";
    }

    private void openElimDistributePage() {
        IFormView view;
        Set<String> rows;
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_invelim_distribution");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6743\u76ca\u62b5\u9500\u5206\u914d", (String)"InvLimListPlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        long modelId = this.getModelId();
        Object scenarioId = this.getScenarioId();
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)String.valueOf(modelId));
        if (Objects.nonNull(scenarioId)) {
            formShowParameter.setCustomParam("KEY_SCENARIO_ID", (Object)String.valueOf(scenarioId));
        }
        if ((rows = this.getSelectTemplate()) != null && rows.size() > 0) {
            formShowParameter.setCustomParam("rows", rows);
        }
        formShowParameter.setPageId(this.getView().getPageId() + "_" + BCM_INVELIMTEMPLATE + "_" + modelId + "_" + scenarioId);
        if (this.getView().getMainView() != null && (view = this.getView().getMainView().getView(this.getView().getPageId() + "_" + BCM_INVELIMTEMPLATE + "_" + modelId + "_" + scenarioId)) != null) {
            view.activate();
        }
        this.getView().showForm(formShowParameter);
    }

    private Set<String> getSelectTemplate() {
        HashSet<String> templateNumber = new HashSet<String>();
        BillList billList = (BillList)this.getView().getControl(CTL_BILLSTAP);
        ListSelectedRowCollection rows = billList.getSelectedRows();
        rows.stream().forEach(p -> templateNumber.add(p.getBillNo()));
        return templateNumber;
    }

    private Object getScenarioId() {
        Object scenarioId = null;
        Object scenario = this.getModel().getValue("scenario");
        if (null != scenario) {
            scenarioId = ((DynamicObject)scenario).get("id");
        }
        return scenarioId;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        String operateKey = "";
        BeforeDoOperationEventArgs newEvt = evt;
        if (newEvt.getSource() instanceof Audit) {
            operateKey = ((Audit)newEvt.getSource()).getOperateKey();
        } else if (newEvt.getSource() instanceof UnAudit) {
            operateKey = ((UnAudit)newEvt.getSource()).getOperateKey();
        }
        switch (operateKey) {
            case "audit": {
                if (this.isEPM()) break;
                this.checkPerm("tblcheck");
                break;
            }
            case "unaudit": {
                if (this.isEPM()) break;
                this.checkPerm("tblunaudit");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        BillList billlistap = (BillList)this.getView().getControl(CTL_BILLSTAP);
        ListSelectedRowCollection selectedRows = billlistap.getSelectedRows();
        String selectFiels = "billno,name";
        DynamicObjectCollection alls = QueryServiceHelper.query((String)BCM_INVELIMTEMPLATE, (String)selectFiels, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues())});
        ArrayList opDescs = new ArrayList();
        switch (operateKey) {
            case "copy": {
                ListSelectedRow listSelectedRow = ((Copy)afterDoOperationEventArgs.getSource()).getListSelectedData().get(0);
                Object id = listSelectedRow.getPrimaryKeyValue();
                QFilter qcf = new QFilter("id", "=", id);
                DynamicObject data = QueryServiceHelper.queryOne((String)BCM_INVELIMTEMPLATE, (String)"name,billno", (QFilter[])new QFilter[]{qcf});
                this.writeOperationLog(this.getOperationCopy(), data.getString("billno"), data.getString("name"), this.getOperationStstusSuccess());
                break;
            }
            case "audit": {
                List successPkIds = operationResult.getSuccessPkIds();
                if (successPkIds.size() == selectedRows.size()) {
                    String opDesc = operationResult.isSuccess() ? ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f", (String)"InvLimListPlugin_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25", (String)"InvLimListPlugin_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                    alls.forEach(a -> opDescs.add(a.getString("billno") + " " + a.getString("name") + opDesc));
                } else if (successPkIds.size() < selectedRows.size()) {
                    List failes = selectedRows.stream().filter(select -> !successPkIds.contains(select.getPrimaryKeyValue())).collect(Collectors.toList());
                    List failIds = failes.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
                    DynamicObjectCollection fail = QueryServiceHelper.query((String)BCM_INVELIMTEMPLATE, (String)selectFiels, (QFilter[])new QFilter[]{new QFilter("id", "in", failIds)});
                    DynamicObjectCollection sucess = QueryServiceHelper.query((String)BCM_INVELIMTEMPLATE, (String)selectFiels, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)successPkIds)});
                    fail.forEach(f -> opDescs.add(String.format(ResManager.loadKDString((String)"%1$s %2$s\u542f\u7528\u5931\u8d25", (String)"InvLimListPlugin_15", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), f.getString("billno"), f.getString("name"))));
                    sucess.forEach(s -> opDescs.add(String.format(ResManager.loadKDString((String)"%1$s %2$s\u542f\u7528\u6210\u529f", (String)"InvLimListPlugin_16", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), s.getString("billno"), s.getString("name"))));
                }
                OperationLogUtil.batchWriteOperationLog((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u542f\u7528", (String)"InvLimListPlugin_11", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), opDescs, (Long)this.getModelId());
                break;
            }
            case "unaudit": {
                List successIds = operationResult.getSuccessPkIds();
                if (successIds.size() == selectedRows.size()) {
                    String opDesc = operationResult.isSuccess() ? ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f", (String)"InvLimListPlugin_12", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7981\u7528\u5931\u8d25", (String)"InvLimListPlugin_13", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                    alls.forEach(a -> opDescs.add(a.getString("billno") + " " + a.getString("name") + opDesc));
                } else if (successIds.size() < selectedRows.size()) {
                    List failes = selectedRows.stream().filter(select -> !successIds.contains(select.getPrimaryKeyValue())).collect(Collectors.toList());
                    List failIds = failes.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
                    DynamicObjectCollection fail = QueryServiceHelper.query((String)BCM_INVELIMTEMPLATE, (String)selectFiels, (QFilter[])new QFilter[]{new QFilter("id", "in", failIds)});
                    DynamicObjectCollection sucess = QueryServiceHelper.query((String)BCM_INVELIMTEMPLATE, (String)selectFiels, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)successIds)});
                    fail.forEach(f -> opDescs.add(String.format(ResManager.loadKDString((String)"%1$s %2$s\u542f\u7528\u5931\u8d25", (String)"InvLimListPlugin_15", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), f.getString("billno"), f.getString("name"))));
                    sucess.forEach(s -> opDescs.add(String.format(ResManager.loadKDString((String)"%1$s %2$s\u542f\u7528\u6210\u529f", (String)"InvLimListPlugin_16", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), s.getString("billno"), s.getString("name"))));
                }
                OperationLogUtil.batchWriteOperationLog((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u7981\u7528", (String)"InvLimListPlugin_14", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), opDescs, (Long)this.getModelId());
            }
        }
    }

    @Override
    protected QFilter getTemplateIdsQFilter(QFilter qFilter1) {
        Map templates = BusinessDataServiceHelper.loadFromCache((String)BCM_INVELIMTEMPLATE, (String)"id, number", (QFilter[])qFilter1.toArray());
        return new QFilter("id", "in", templates.keySet());
    }

    @Override
    protected String getEntryEntity() {
        return BCM_INVELIMTEMPLATE;
    }

    @Override
    protected QFilter getCatalogqFilter(boolean isContainNull) {
        TreeView tview = (TreeView)this.getControl("templatecatalog");
        String parentid = tview.getTreeState().getFocusNode() == null ? "" : tview.getTreeState().getFocusNode().get("parentid").toString();
        return super.getCatalogqFilter(StringUtil.isEmptyString((String)parentid));
    }

    @Override
    protected String getCatalogType() {
        return TemplateCatalogTypeEnum.INVCATALOG.getType() + "";
    }
}

