/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.business.invest.function.QuadraConsumer;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;

public class InvRelationLogListPlugin
extends AbstractBaseListPlugin {
    private static final List<String> dimKeys = Lists.newArrayList((Object[])new String[]{"scenario", "year", "period"});
    private static final String EXPORT_ALL = "EXPORT_ALL";
    private static final int BATCH_EXPORT = 500000;
    public Map<String, Consumer<ItemClickEvent>> itemClickAction = new HashMap<String, Consumer<ItemClickEvent>>(2);

    public InvRelationLogListPlugin() {
        this.itemClickAction.put("btn_export", (Consumer<ItemClickEvent>)((Consumer)this::export));
        this.itemClickAction.put("btn_refresh", (Consumer<ItemClickEvent>)((Consumer)this::refresh));
    }

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap(16);
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.setOrderBy("createtime DESC");
        billList.addSetFilterListener(setFilterEvent -> {
            QFBuilder qfBuilder = new QFBuilder();
            this.consumerF7((QuadraConsumer<DynamicObject, DynamicObject, DynamicObject, DynamicObject>)((QuadraConsumer)(model, scenario, year, period) -> qfBuilder.and("model", "=", model.getPkValue()).and("scenario", "=", scenario.getPkValue()).and("year", "=", year.getPkValue()).and("period", "=", period.getPkValue())));
            if (qfBuilder.size() == 0) {
                qfBuilder.and("2", "=", (Object)1);
            }
            setFilterEvent.getQFilters().addAll(qfBuilder.toList());
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object modelId = this.getFormCustomParam("modelId");
        Object scenarioId = this.getFormCustomParam("scenario");
        Object yearId = this.getFormCustomParam("yearId");
        Object periodId = this.getFormCustomParam("periodId");
        this.getModel().setValue("model", modelId);
        this.getModel().setValue("scenario", scenarioId);
        this.getModel().setValue("year", yearId);
        this.getModel().setValue("period", periodId);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        this.itemClickAction.getOrDefault(itemKey, (Consumer<ItemClickEvent>)((Consumer)key -> {})).accept((Object)evt);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("model".equals(propertyName)) {
            this.propertyChangedModelUse(new ArrayList<String>(dimKeys));
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
    }

    private void export(ItemClickEvent evt) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection ls = billList.getSelectedRows();
        if (ls.isEmpty()) {
            int dataCount = billList.queryBillDataCount();
            if (dataCount == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6570\u636e\u5bfc\u51fa", (String)"InvRelationLogListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            String msg = ResManager.loadKDString((String)"\u5f53\u524d%1$s\u884c\u6570\u636e\uff0c\u5c06\u5bfc\u51fa%2$s\u4e2a\u6587\u4ef6\u3002", (String)"InvRelationLogListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            int i = dataCount % 500000 != 0 ? 1 : 0;
            billList.selectAllRows();
            billList.refresh();
            this.getView().showConfirm(String.format(msg, dataCount, dataCount / 500000 + i), MessageBoxOptions.YesNo, new ConfirmCallBackListener(EXPORT_ALL, (IFormPlugin)this));
            return;
        }
        int selectedRows = ls.size();
        if (selectedRows > 500000) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d%1$s\u884c\u6570\u636e\uff0c\u5c06\u5bfc\u51fa%2$s\u4e2a\u6587\u4ef6\u3002", (String)"InvRelationLogListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            int i = selectedRows % 500000 != 0 ? 1 : 0;
            this.getView().showConfirm(String.format(msg, selectedRows, selectedRows / 500000 + i), MessageBoxOptions.YesNo, new ConfirmCallBackListener(EXPORT_ALL, (IFormPlugin)this));
            return;
        }
        this.doExport(billList);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String key = messageBoxClosedEvent.getCallBackId();
        if (EXPORT_ALL.equals(key) && MessageBoxResult.Yes.name().equals(messageBoxClosedEvent.getResultValue())) {
            this.doExport((BillList)this.getControl("billlistap"));
        }
    }

    private void refresh(ItemClickEvent evt) {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
    }

    private void doExport(BillList billList) {
        HashMap<String, String> currentExport = new HashMap<String, String>(16);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        EntityType entityType = billList.getEntityType();
        try {
            String routeAppId = this.getView().getFormShowParameter().getServiceAppId();
            Iterator iterator = selectedRows.iterator();
            while (iterator.hasNext()) {
                LinkedList<Object> idOrder = new LinkedList<Object>();
                for (int i = 0; i < 500000; ++i) {
                    ListSelectedRow next = (ListSelectedRow)iterator.next();
                    currentExport.put(next.getNumber(), next.getName());
                    idOrder.add(next.getPrimaryKeyValue());
                    iterator.remove();
                    if (!iterator.hasNext()) break;
                }
                Map load = BusinessDataServiceHelper.loadFromCache((Object[])idOrder.toArray(), (DynamicObjectType)entityType);
                DynamicObject[] dys = new DynamicObject[load.size()];
                int i = 0;
                for (Object e : idOrder) {
                    DynamicObject dynamicObject = (DynamicObject)load.get(e);
                    dys[i++] = dynamicObject;
                }
                String url = ExportUtil.export((DynamicObject[])dys, (String)routeAppId, (String)entityType.getName(), format -> {});
                if (StringUtils.isNotEmpty((CharSequence)url)) {
                    this.downloadFile(url, "bcm_invrelationloglist", "1G2FW/G3YIL8");
                }
                idOrder.clear();
            }
            billList.clearSelection();
            billList.refresh();
            this.writeOperationLog(InvRelationLogListPlugin.getOperationExport(), this.getOperationStatusSuccess());
        }
        catch (Exception e) {
            currentExport.forEach((number, name) -> this.writeOperationLog(InvRelationLogListPlugin.getOperationExport(), (String)number, (String)name, this.getOperationStstusFail()));
            selectedRows.forEach(row -> this.writeOperationLog(InvRelationLogListPlugin.getOperationExport(), row.getNumber(), row.getName(), this.getOperationStstusFail()));
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u5bfc\u51fa\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s\u3002", (String)"InvRelationSearchPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private void consumerF7(QuadraConsumer<DynamicObject, DynamicObject, DynamicObject, DynamicObject> consumer) {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        DynamicObject scenario = (DynamicObject)this.getModel().getValue("scenario");
        DynamicObject year = (DynamicObject)this.getModel().getValue("year");
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        if (Objects.nonNull(model) && Objects.nonNull(scenario) && Objects.nonNull(year) && Objects.nonNull(period)) {
            consumer.accept((Object)model, (Object)scenario, (Object)year, (Object)period);
        }
    }

    private String getOperationStstusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"InvRelationLogListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private static String getOperationExport() {
        return ResManager.loadKDString((String)"\u5bfc\u51fa\u5408\u5e76\u6240\u6709\u6743-\u65e5\u5fd7", (String)"InvRelationLogListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStatusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"InvRelationLogListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }
}

