/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.formop.ExportEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.invstructuretable.InvStructureTableService;
import kd.fi.bcm.business.invest.invstructuretable.model.InvStructureContext;
import kd.fi.bcm.business.invest.model.BusinessResult;
import kd.fi.bcm.business.invest.orgchart.ChartDataConst;
import kd.fi.bcm.business.invest.orgchart.NodeModel;
import kd.fi.bcm.business.invest.orgchart.OrganizationChartData;
import kd.fi.bcm.business.invest.orgchart.OrganizationChartService;
import kd.fi.bcm.business.invest.service.InvShareCaseF7Com;
import kd.fi.bcm.business.invest.shareholder.InvShareRelaService;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.model.UserSelectModel;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.reportlist.OpenReportListHelper;
import kd.fi.bcm.business.tree.AbstractTreeNode;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.business.tree.TreeBuilder;
import kd.fi.bcm.business.tree.TreeModel;
import kd.fi.bcm.business.tree.dimension.OrgTreeNode;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.ReportTypeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.report.ReportLeftTreeTabEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.guidemenu.GuidePageUtils;
import kd.fi.bcm.formplugin.invest.AbstractInvShareBasePlugin;
import kd.fi.bcm.formplugin.tree.invest.InvDynRelationRatioTreeBuilder;
import kd.fi.bcm.formplugin.util.FormShowUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.compress.utils.Sets;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;

public class InvRelationReportPlugin
extends AbstractInvShareBasePlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final List<String> dimKeys = Lists.newArrayList((Object[])new String[]{"scenario", "year", "period"});
    private static final String MODEL = "model";
    private static final String SCENARIO = "scenario";
    private static final String PERIOD = "period";
    private static final String YEAR = "year";
    private static final String PARENT_ORG = "parentOrg";
    private static final DateFormat DF = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat DF_TIME = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String SHARE_CASE = "sharecase";
    public static final String TREE_ENTRY_ENTITY = "treeentryentity";
    private static String MIN_SHARE_HOLDING_STATUS = "minShareHoldingStatus";
    private String ORG_CHART_TYPE = "orgChartType";
    private InvShareCaseF7Com invShareCaseF7Com;
    private InvStructureContext ctx;
    private int currentCol;
    List<Pair<String, MultiLangEnumBridge>> RPT_COLS = Lists.newArrayList((Object[])new Pair[]{Pair.onePair((Object)"investdate", (Object)new MultiLangEnumBridge("\u6295\u8d44\u65e5\u671f\u5206\u7ec4", "InvRelationReportPlugin_13", "fi-bcm-formplugin")), Pair.onePair((Object)"investeecompanynumber", (Object)new MultiLangEnumBridge("\u88ab\u6295\u8d44\u5355\u4f4d\u7f16\u7801", "InvRelationReportPlugin_14", "fi-bcm-formplugin")), Pair.onePair((Object)"investeecompanyname", (Object)new MultiLangEnumBridge("\u88ab\u6295\u8d44\u5355\u4f4d\u540d\u79f0", "InvRelationReportPlugin_15", "fi-bcm-formplugin")), Pair.onePair((Object)"shareholdernumber", (Object)new MultiLangEnumBridge("\u6295\u8d44\u5355\u4f4d\u7f16\u7801", "InvRelationReportPlugin_16", "fi-bcm-formplugin")), Pair.onePair((Object)"shareholdername", (Object)new MultiLangEnumBridge("\u6295\u8d44\u5355\u4f4d\u540d\u79f0", "InvRelationReportPlugin_17", "fi-bcm-formplugin")), Pair.onePair((Object)"invchangetypename", (Object)new MultiLangEnumBridge("\u53d8\u66f4\u7c7b\u578b", "InvRelationReportPlugin_18", "fi-bcm-formplugin")), Pair.onePair((Object)"openscale", (Object)new MultiLangEnumBridge("\u671f\u521d\u6301\u80a1\u6bd4\u4f8b\uff08%\uff09", "InvRelationReportPlugin_19", "fi-bcm-formplugin")), Pair.onePair((Object)"changescale", (Object)new MultiLangEnumBridge("\u53d8\u52a8\u6301\u80a1\u6bd4\u4f8b\uff08%\uff09", "InvRelationReportPlugin_20", "fi-bcm-formplugin")), Pair.onePair((Object)"sharescale", (Object)new MultiLangEnumBridge("\u671f\u672b\u6301\u80a1\u6bd4\u4f8b\uff08%)", "InvRelationReportPlugin_21", "fi-bcm-formplugin")), Pair.onePair((Object)"confirmopenscale", (Object)new MultiLangEnumBridge("\u786e\u8ba4\u671f\u521d\u6301\u80a1\u6bd4\u4f8b\uff08%\uff09", "InvRelationReportPlugin_22", "fi-bcm-formplugin")), Pair.onePair((Object)"confirmchangescale", (Object)new MultiLangEnumBridge("\u786e\u8ba4\u53d8\u52a8\u6301\u80a1\u6bd4\u4f8b\uff08%\uff09", "InvRelationReportPlugin_23", "fi-bcm-formplugin")), Pair.onePair((Object)"confirmsharescale", (Object)new MultiLangEnumBridge("\u786e\u8ba4\u671f\u672b\u6301\u80a1\u6bd4\u4f8b\uff08%)", "InvRelationReportPlugin_24", "fi-bcm-formplugin")), Pair.onePair((Object)"modifytime", (Object)new MultiLangEnumBridge("\u4fee\u6539\u65f6\u95f4", "InvRelationReportPlugin_25", "fi-bcm-formplugin")), Pair.onePair((Object)"modifier", (Object)new MultiLangEnumBridge("\u4fee\u6539\u4eba", "InvRelationReportPlugin_26", "fi-bcm-formplugin"))});
    private static final Set<String> FIELDS = Sets.newHashSet((Object[])new String[]{"investeecompanynumber", "investeecompanyname", "shareholdernumber", "shareholdername", "invchangetypename", "openscale", "sharescale", "confirmopenscale", "confirmsharescale", "modifier"});

    private InvStructureContext getCtx() {
        if (this.ctx == null) {
            long cslScheme = LongUtil.toLong((Object)this.getModel().getValue("cslscheme_id"));
            long scene = LongUtil.toLong((Object)this.getModel().getValue("scenario_id"));
            long year = LongUtil.toLong((Object)this.getModel().getValue("year_id"));
            long period = LongUtil.toLong((Object)this.getModel().getValue("period_id"));
            this.ctx = new InvStructureContext(this.getModelId(), scene, year, period);
            this.ctx.setCslschemeId(Long.valueOf(cslScheme));
            this.ctx.setMergeOrgId(LongUtil.toLong((Object)this.getPageCache().get("nodeSelected")));
            this.ctx.setShareCaseId(Long.valueOf(this.invShareCaseF7Com.getShareCaseId()));
        }
        return this.ctx;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("searchbefore", "searchnext");
        long modelId = this.loadModelId();
        this.invShareCaseF7Com.registerF7Filter(modelId);
        this.invShareCaseF7Com.registerActionAfterModelChange(MODEL);
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREE_ENTRY_ENTITY);
        treeEntry.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap(16);
        this.asMapF7toType(Lists.newArrayList((Object[])new String[]{SCENARIO, YEAR}), SingleF7TypeEnum.LEAF, map);
        this.asMapF7toType(Lists.newArrayList((Object[])new String[]{PERIOD}), SingleF7TypeEnum.COMMON, map);
        this.initSingleMemberF7(map);
        this.invShareCaseF7Com = new InvShareCaseF7Com(this.getView());
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelId = (String)this.getFormCustomParam("KEY_MODEL_ID");
        Long cslScheme = (Long)this.getFormCustomParam("cslscheme");
        this.getModel().setValue(MODEL, (Object)modelId);
        this.getPageCache().put("KEY_MODEL_ID", modelId);
        this.getModel().setValue("cslscheme", (Object)cslScheme);
        Map<String, String> userselectMap = UserSelectUtil.getUserSelectMapById(modelId, "issummury,id,model,model.id,isadjustlisttype,application,entity,year,period,scenario,currency,modifier,modifydate,onlymodel,formid,version,cslscheme,dmmodel", this.getApplicationType(), dimKeys);
        this.getModel().beginInit();
        for (String key : dimKeys) {
            if (userselectMap.size() <= 0) {
                this.getModel().setValue(key, null);
                continue;
            }
            this.getModel().setValue(key, "0".equals(userselectMap.get(key)) ? null : userselectMap.get(key));
        }
        this.getModel().endInit();
        this.getView().updateView();
        if (!StringUtils.isEmpty((CharSequence)modelId)) {
            this.refreshTree(modelId);
        }
        this.switchBillStap(ReportTypeEnum.ORGTABLE);
        this.invShareCaseF7Com.resetDefaultShareCase(MODEL);
        this.refreshBillList();
    }

    private void refreshTree(String modelid) {
        if (modelid != null) {
            this.buildLeftTree(Long.valueOf(modelid));
        } else {
            TreeView tree = (TreeView)this.getControl("tree_org");
            tree.deleteAllNodes();
            this.getPageCache().remove("delOrgMenberPerm");
        }
    }

    private void buildLeftTree(Long modelid) {
        DynamicObjectCollection rootNodecollection = this.getTreeListORM(modelid);
        if (rootNodecollection == null || rootNodecollection.isEmpty()) {
            TreeView tree = (TreeView)this.getControl("tree_org");
            tree.deleteAllNodes();
            this.getPageCache().remove("delOrgMenberPerm");
        } else {
            this.getPageCache().put("delOrgMenberPerm", ObjectSerialUtil.toByteSerialized(this.toList(rootNodecollection)));
            String showType = this.getPageCache().get("showorgtype");
            OrgTreeNode root = TreeBuilder.getOrgCslTree((DynamicObjectCollection)rootNodecollection, (String)showType, (boolean)true);
            root = (OrgTreeNode)TreeBuilder.setOpen((ITreeNode)root);
            root.SetIsOpened(true);
            this.initTree((AbstractTreeNode<Object>)root);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        this.checkPerm(fieldName);
        DynamicObject row = this.getModel().getEntryRowEntity(TREE_ENTRY_ENTITY, event.getRowIndex());
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put(MODEL, this.getModelId());
        DynamicObject cslSchemeDyn = (DynamicObject)this.getModel().getValue("cslscheme");
        param.put("cslscheme", cslSchemeDyn.getLong("id"));
        DynamicObject sceneDyn = (DynamicObject)this.getModel().getValue(SCENARIO);
        param.put(SCENARIO, sceneDyn.getLong("id"));
        param.put(YEAR, row.getLong("yearid"));
        param.put(PERIOD, row.getLong("periodid"));
        if ("investeecompanyname".equals(fieldName)) {
            IDNumberTreeNode entity = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)row.getLong("investeecompanyid"));
            if (IDNumberTreeNode.NotFoundTreeNode == entity) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8df3\u8f6c\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u6570\u636e\u540e\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"InvRelationReportPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            IDNumberTreeNode cslSchemeEntity = this.getCslSchemeEntityNode(cslSchemeDyn.getLong("id"), entity);
            if (IDNumberTreeNode.NotFoundTreeNode != cslSchemeEntity) {
                param.put("entity", cslSchemeEntity.getId());
            } else {
                param.put("cslscheme", entity.getProperty("cslscheme.id"));
                param.put("entity", entity.getId());
            }
            param.put("lefttreetype", ReportLeftTreeTabEnum.ENTITY);
            IDNumberTreeNode currencyDc = MemberReader.findCurrencyMemberByNum((String)this.getCurModelNumber(), (String)CurrencyEnum.DC.getNumber());
            param.put("currency", currencyDc.getId());
            OpenReportListHelper.openReportList(param, (IFormView)this.getView());
        } else if ("invchangetypename".equals(fieldName)) {
            TreeView tree = (TreeView)this.getControl("tree_org");
            Map orgid = tree.getTreeState().getFocusNode();
            param.put("entity", LongUtil.toLong(orgid.get("id")));
            param.put("cslscheme", cslSchemeDyn.getLong("id"));
            this.openForm("bcm_invlimsheetlist", param);
        }
    }

    private IDNumberTreeNode getCslSchemeEntityNode(long cslSchemeId, IDNumberTreeNode entity) {
        if (IDNumberTreeNode.NotFoundTreeNode == entity) {
            return entity;
        }
        IDNumberTreeNode baseTreeNode = entity.getBaseTreeNode();
        if (LongUtil.toLong((Object)baseTreeNode.getProperty("cslscheme.id")) == cslSchemeId) {
            return baseTreeNode;
        }
        if (!CollectionUtils.isEmpty((Collection)baseTreeNode.getShareNodes())) {
            for (IDNumberTreeNode shareNode : baseTreeNode.getShareNodes()) {
                if (LongUtil.toLong((Object)shareNode.getProperty("cslscheme.id")) != cslSchemeId) continue;
                return shareNode;
            }
        }
        return IDNumberTreeNode.NotFoundTreeNode;
    }

    private void openForm(String formId, Map<String, Object> param) {
        String pageId = this.getView().getPageId() + "openInvList" + param.toString();
        IFormView mainPageView = this.getView().getMainView();
        if (mainPageView == null || mainPageView.getView(pageId) == null) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId(formId);
            formShowParameter.setPageId(pageId);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
            formShowParameter.setCustomParam("condition", (Object)ObjectSerialUtil.toByteSerialized(param));
            this.getView().showForm(formShowParameter);
        } else {
            IFormView pageView = mainPageView.getView(pageId);
            pageView.activate();
            this.getView().sendFormAction(pageView);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (MODEL.equals(propertyName) || SCENARIO.equals(propertyName) || YEAR.equals(propertyName) || PERIOD.equals(propertyName) || "cslscheme".equals(propertyName)) {
            IDNumberTreeNode node;
            DynamicObject newValue2 = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (PERIOD.equals(propertyName) && newValue2 != null && ("0".equals((node = MemberReader.findPeriodMemberById((Long)this.getModelId(), (Long)newValue2.getLong("id"))).getProperty("effmonth")) || "0".equals(node.getProperty("expmonth")))) {
                this.getModel().setValue(e.getProperty().getName(), e.getChangeSet()[0].getOldValue());
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u8d77\u59cb\u65e5\u671f\u7684\u671f\u95f4\u3002", (String)"InvRelationReportPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (dimKeys.contains(propertyName)) {
                this.savetUserSelectWhenOtherChange(propertyName, new UserSelectModel());
            }
            if ("cslscheme".equals(propertyName)) {
                this.saveUserChangedCslscheme((DynamicObject)e.getChangeSet()[0].getNewValue());
            }
            if (MODEL.equals(propertyName)) {
                this.getModel().beginInit();
                this.propertyChangedModelUse(dimKeys);
                this.getModel().endInit();
            }
            this.doDimChange(propertyName);
            this.refreshBillList();
        } else if ("showorgtype".equals(propertyName)) {
            this.getPageCache().put("showorgtype", (String)this.getModel().getValue("showorgtype"));
            this.refreshTree(Long.toString(this.getModelId()));
            this.refreshBillList();
        } else if ("reporttype".equals(propertyName)) {
            if (e.getChangeSet()[0].getNewValue() == null || StringUtils.isEmpty((CharSequence)e.getChangeSet()[0].getNewValue().toString())) {
                this.getModel().setValue("reporttype", e.getChangeSet()[0].getOldValue());
            } else {
                this.switchBillStap(ReportTypeEnum.getReportTypeEnum((String)this.getModel().getValue("reporttype").toString()));
                this.refreshBillList();
            }
        } else if (SHARE_CASE.equals(propertyName)) {
            this.invShareCaseF7Com.propertyChanged(e, newValue -> this.refreshBillList());
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        if (this.getModelId() == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"RptAdjustdListPlugin_119", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String selectedId = evt.getNodeId().toString();
        List selectnodes = new ArrayList<String>(10);
        if (this.getPageCache().get("selectorgs") != null) {
            selectnodes = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("selectorgs"));
            selectnodes.remove(selectedId);
        }
        selectnodes.add(selectedId);
        this.getPageCache().put("nodeSelected", selectedId);
        this.getPageCache().put("selectorgs", ObjectSerialUtil.toByteSerialized(selectnodes));
        this.refreshBillList();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (!this.checkSelectNode(itemKey)) {
            return;
        }
        String reporttype = (String)this.getModel().getValue("reporttype");
        if (!"btn_exit".equals(evt.getItemKey()) && !this.checkMustInputIsAccess()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\uff0c\u8d22\u5e74\uff0c\u671f\u95f4\uff0c\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"InvRelationReportPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        switch (evt.getItemKey()) {
            case "btn_report": {
                if (this.getPageCache().get("selectorgs") == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5de6\u6811\u5408\u5e76\u8282\u70b9\u3002", (String)"InvRelationReportPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                IDNumberTreeNode node = MemberReader.findPeriodMemberById((Long)this.getModelId(), (Long)LongUtil.toLong((Object)this.getModel().getValue("period_id")));
                if (!node.isLeaf()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u7684\u660e\u7ec6\u6210\u5458\u3002", (String)"InvRelationReportPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.createReport(reporttype);
                this.writeOperationLog(OpItemEnum.CREATEREPORT.getName(), ResultStatusEnum.SUCCESS.getName());
                break;
            }
            case "btn_refresh": {
                this.refreshBillList();
                this.writeOperationLog(OpItemEnum.REFRESH.getName(), ResultStatusEnum.SUCCESS.getName());
                break;
            }
            case "min_share_holding_show": {
                this.organizationChart(ChartDataConst.MinShareHolding.show);
                this.switchBillStap(ReportTypeEnum.ORGCHART);
                break;
            }
            case "min_share_holding_hide": {
                this.organizationChart(ChartDataConst.MinShareHolding.hide);
                this.switchBillStap(ReportTypeEnum.ORGCHART);
                break;
            }
            case "btn_rpt_export": {
                try {
                    String fileUrl = this.exportRptReport();
                    if (!StringUtils.isNotBlank((CharSequence)fileUrl)) break;
                    this.downloadFile(fileUrl, "bcm_invsharereport", "1G2FW/G3YIL8");
                    this.writeMultiLangLog(OpItemEnum.EXPORT.getOpMultiLangEnumBridge(), new OPDescMultiLangEnumBridge("\u5bfc\u51fa\u80a1\u6743\u53d8\u52a8\u8868\u6210\u529f\u3002", "InvRelationReportPlugin_28", "fi-bcm-formplugin", null));
                }
                catch (IOException e) {
                    log.error("\u5bfc\u51fa\u80a1\u6743\u62a5\u544a\u80a1\u6743\u53d8\u52a8\u8868\u5931\u8d25\u3002", (Throwable)e);
                    this.writeMultiLangLog(OpItemEnum.EXPORT.getOpMultiLangEnumBridge(), new OPDescMultiLangEnumBridge("\u5bfc\u51fa\u80a1\u6743\u53d8\u52a8\u8868\u5931\u8d25\u3002", "InvRelationReportPlugin_29", "fi-bcm-formplugin", null));
                }
                break;
            }
        }
    }

    private boolean checkSelectNode(String itemKey) {
        if (Sets.newHashSet((Object[])new String[]{"btn_refresh", "btn_exit"}).contains(itemKey)) {
            return true;
        }
        return this.isSelectNodeHavePerm(() -> {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u64cd\u4f5c\u5bf9\u5e94\u7684\u7ec4\u7ec7\u6210\u5458\u6743\u9650\u3002", (String)"InvRelationReportPlugin_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        });
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getSource() instanceof ExportEntry) {
            this.writeMultiLangLog(OpItemEnum.EXPORT.getOpMultiLangEnumBridge(), new OPDescMultiLangEnumBridge("\u5bfc\u51fa\u80a1\u6743\u62a5\u544a\u80a1\u6743\u67b6\u6784\u6210\u529f\u3002", "InvRelationReportPlugin_35", "fi-bcm-formplugin", null));
        }
    }

    private boolean isSelectNodeHavePerm() {
        return this.isSelectNodeHavePerm(() -> false);
    }

    private boolean isSelectNodeHavePerm(Supplier<Boolean> noPermReturnFun) {
        String selectedId = this.getPageCache().get("nodeSelected");
        long modelId = this.getModelId();
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)ConvertUtil.convertStrToLong((String)selectedId));
        Long selectNode = orgNode.getId();
        if (orgNode != IDNumberTreeNode.NotFoundTreeNode && PermissionServiceImpl.getInstance((Long)modelId).hasNoPerm(MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity"), selectNode)) {
            return noPermReturnFun.get();
        }
        return true;
    }

    private String exportRptReport() throws IOException {
        DynamicObjectCollection treeEntity = this.getModel().getEntryEntity(TREE_ENTRY_ENTITY);
        if (treeEntity.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5f15\u51fa\u3002", (String)"InvRelationReportPlugin_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return null;
        }
        String fileName = ResManager.loadKDString((String)"\u80a1\u6743\u62a5\u544a_\u80a1\u6743\u53d8\u52a8\u8868", (String)"InvRelationReportPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        SXSSFWorkbook wb = new SXSSFWorkbook(50000);
        wb.setMissingCellPolicy(Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
        SXSSFSheet sheet = wb.createSheet(fileName);
        sheet.createFreezePane(0, 1, 0, 1);
        SXSSFRow head = sheet.createRow(0);
        XSSFCellStyle headStyle = wb.getXSSFWorkbook().createCellStyle();
        headStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        headStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        for (int i = 0; i < this.RPT_COLS.size(); ++i) {
            Pair<String, MultiLangEnumBridge> column = this.RPT_COLS.get(i);
            Cell cell = head.getCell(i);
            cell.setCellStyle((CellStyle)headStyle);
            cell.setCellValue(((MultiLangEnumBridge)column.p2).loadKDString());
            sheet.setColumnWidth(i, 5120);
        }
        int rowIndex = 1;
        for (DynamicObject dyn : treeEntity) {
            SXSSFRow row = sheet.createRow(rowIndex);
            for (int i = 0; i < this.RPT_COLS.size(); ++i) {
                Pair<String, MultiLangEnumBridge> column = this.RPT_COLS.get(i);
                String value = dyn.getString((String)column.p1);
                if (StringUtils.isNotBlank((CharSequence)value) && "modifytime".equals(column.p1)) {
                    value = DF_TIME.format(dyn.getDate((String)column.p1));
                }
                row.getCell(i).setCellValue(value);
            }
            ++rowIndex;
        }
        return ExportUtil.writeFile((SXSSFWorkbook)wb, (String)(fileName + ".xlsx"));
    }

    private void organizationChart(ChartDataConst.MinShareHolding minShareHolding) {
        CustomControl custom = (CustomControl)this.getView().getControl("customcontrolap");
        OrganizationChartData data = new OrganizationChartData();
        data.setShowMinShareHolding(minShareHolding);
        custom.setData((Object)data);
        this.getPageCache().put(MIN_SHARE_HOLDING_STATUS, minShareHolding.toString());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof ExportEntry && !this.checkMustInputIsAccess()) {
            args.setCancel(true);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        Object returnData = evt.getReturnData();
        switch (evt.getActionId()) {
            case "bcm_recalculatereport": {
                if (returnData == null) {
                    return;
                }
                InvStructureTableService structureTableService = new InvStructureTableService(this.getCtx(), ((Map)returnData).get("calcRange").toString());
                BusinessResult result = structureTableService.generate();
                String reportType = (String)this.getModel().getValue("reporttype");
                if (ReportTypeEnum.getReportTypeEnum((String)reportType) == ReportTypeEnum.ORGCHART) {
                    this.reSetGraphData();
                } else {
                    this.refreshBillList();
                }
                result.replace2HighLevelMsg(BusinessResult.NotificationEnum.SUCCESS, ResManager.loadKDString((String)"\u751f\u6210\u62a5\u544a\u6210\u529f\u3002", (String)"InvRelationReportPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                result.notification(this.getView());
                break;
            }
        }
    }

    private void createReport(String reporttype) {
        switch (ReportTypeEnum.getReportTypeEnum((String)reporttype)) {
            case ORGTABLE: {
                this.calculateReport();
                break;
            }
            case ORGCHART: {
                this.calculateReport();
                break;
            }
            case YEAR: 
            case MONTH: 
            case ALL: {
                QFBuilder qfBuilder = this.getIsolationQFilter();
                DeleteServiceHelper.delete((String)"bcm_invsharerela_report", (QFilter[])qfBuilder.toArray());
                this.createInvChangeReport();
                this.refreshBillList();
                break;
            }
        }
    }

    private void calculateReport() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bcm_recalculatereport");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_recalculatereport"));
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        FormShowUtil.openDynamicPage(this.getView(), "bcm_recalculatereport", null, new CloseCallBack((IFormPlugin)this, "bcm_recalculatereport"));
    }

    private void refreshBillList() {
        if (!this.isSelectNodeHavePerm()) {
            this.getModel().deleteEntryData("entryentity");
            this.getModel().deleteEntryData(TREE_ENTRY_ENTITY);
            CustomControl custom = (CustomControl)this.getView().getControl("customcontrolap");
            OrganizationChartData data = new OrganizationChartData();
            data.setRootNode(new NodeModel());
            data.setType(ChartDataConst.InitType.getInitTypeByName((String)this.getPageCache().get(this.ORG_CHART_TYPE)));
            data.setShowMinShareHolding(ChartDataConst.MinShareHolding.getMinShareHoldingByName((String)this.getPageCache().get(MIN_SHARE_HOLDING_STATUS)));
            custom.setData((Object)data);
            return;
        }
        String reporttype = (String)this.getModel().getValue("reporttype");
        switch (ReportTypeEnum.getReportTypeEnum((String)reporttype)) {
            case ORGTABLE: {
                this.rebuildOrgTable();
                break;
            }
            case ORGCHART: {
                this.reSetGraphData();
                break;
            }
            case YEAR: 
            case MONTH: 
            case ALL: {
                this.rebuildRelaChangeTable(reporttype);
                break;
            }
        }
    }

    private void queryDataBeforeDoAction(BiConsumer<DynamicObject, Map<String, List<DynamicObject>>> action) {
        DynamicObject ctrlorg = null;
        Map<String, List<DynamicObject>> holder = Collections.EMPTY_MAP;
        IDNumberTreeNode org = this.getCtx().queryMergeOrg();
        if (!IDNumberTreeNode.NotFoundTreeNode.equals(org) && this.checkMustInputIsAccess()) {
            ArrayList coll = new ArrayList(BusinessDataServiceHelper.loadFromCache((String)"bcm_entitymembertree", (String)"id,number,parent.number", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)this.getModelId()), new QFilter("longnumber", "like", (Object)(org.getLongNumber() + "!%")).or("longnumber", "=", (Object)org.getLongNumber()), new QFilter("cslscheme.id", "=", (Object)this.getCtx().getCslschemeId())}).values());
            FilterOrgStructParam orgParam = new FilterOrgStructParam(this.ctx.getModelId(), this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId());
            EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)orgParam, coll);
            Set orgRange = coll.parallelStream().map(p -> p.getString("number")).collect(Collectors.toSet());
            QFBuilder qfBuilder = new QFBuilder("cslscheme", "=", (Object)this.getCtx().getCslschemeId());
            qfBuilder.add(SCENARIO, "=", (Object)this.getCtx().getScenarioId());
            qfBuilder.add(YEAR, "=", (Object)this.getCtx().getFyId());
            qfBuilder.add(PERIOD, "=", (Object)this.getCtx().getPeriodId());
            qfBuilder.add("entity.number", "in", orgRange);
            qfBuilder.add(MODEL, "=", (Object)this.getModelId());
            qfBuilder.add(SHARE_CASE, "=", (Object)this.getCtx().getShareCaseId());
            Map relas = BusinessDataServiceHelper.loadFromCache((String)"bcm_invstructuretable", (String)"entity.id,entryentity.shareholder,entryentity.indirectscale,entity.name,entity.number,pentity.number,directscale", (QFilter[])qfBuilder.toArray());
            holder = relas.values().parallelStream().collect(Collectors.groupingBy(dy -> dy.get("pentity.number") == null ? "" : dy.getString("pentity.number")));
            ctrlorg = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"ctrlorg.number,ctrlorg.name", (QFilter[])new QFBuilder("id", "=", (Object)this.ctx.getMergeOrgId()).toArray());
        }
        action.accept(ctrlorg, holder);
    }

    private void reSetGraphData() {
        this.queryDataBeforeDoAction((ctrlOrg, holder) -> {
            CustomControl custom = (CustomControl)this.getView().getControl("customcontrolap");
            OrganizationChartData data = new OrganizationChartService(holder).buildData(ctrlOrg);
            data.setType(ChartDataConst.InitType.getInitTypeByName((String)this.getPageCache().get(this.ORG_CHART_TYPE)));
            data.setShowMinShareHolding(ChartDataConst.MinShareHolding.getMinShareHoldingByName((String)this.getPageCache().get(MIN_SHARE_HOLDING_STATUS)));
            custom.setData((Object)data);
        });
    }

    private void rebuildRelaChangeTable(String reporttype) {
        this.getModel().deleteEntryData(TREE_ENTRY_ENTITY);
        DynamicObject scenarioDy = (DynamicObject)this.getModel().getValue(SCENARIO);
        DynamicObject yearobj = (DynamicObject)this.getModel().getValue(YEAR);
        DynamicObject periodobj = (DynamicObject)this.getModel().getValue(PERIOD);
        if (scenarioDy == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u60c5\u666f\u3002", (String)"InvRelationReportPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (yearobj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d22\u5e74\u3002", (String)"InvRelationReportPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (periodobj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u3002", (String)"InvRelationReportPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeView tree = (TreeView)this.getControl("tree_org");
        Map orgid = tree.getTreeState().getFocusNode();
        if (orgid == null || orgid.get("id") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u5408\u5e76\u8282\u70b9\u3002", (String)"InvRelationReportPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        ReportTypeEnum reportType = ReportTypeEnum.getReportTypeEnumNotThrowEx((String)reporttype);
        if (reportType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u62a5\u544a\u7c7b\u578b\u3002", (String)"InvRelationReportPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Long mergeId = Long.valueOf((String)orgid.get("id"));
        DynamicObjectCollection doc = InvestServiceHelper.queryDynamicShareRelation((long)this.getModelId(), (ReportTypeEnum)reportType, (Long)mergeId, (long)scenarioDy.getLong("id"), (long)yearobj.getLong("id"), (long)periodobj.getLong("id"));
        if (doc == null || doc.isEmpty()) {
            return;
        }
        this.getModel().beginInit();
        this.getModel().batchCreateNewEntryRow(TREE_ENTRY_ENTITY, doc.size());
        this.getModel().endInit();
        List<ITreeNode<DynamicObject>> trees = InvDynRelationRatioTreeBuilder.bulidTreeWithOrder(doc);
        AtomicInteger rowIndex = new AtomicInteger(0);
        this.initTreeRowData(trees, rowIndex);
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREE_ENTRY_ENTITY);
        treeEntry.setCollapse(true);
        this.getView().updateView(TREE_ENTRY_ENTITY);
    }

    private void initTreeRowData(List<ITreeNode<DynamicObject>> trees, AtomicInteger rowIndex) {
        for (ITreeNode<DynamicObject> node : trees) {
            DynamicObject row = this.getModel().getEntryRowEntity(TREE_ENTRY_ENTITY, rowIndex.get());
            row.set("id", (Object)node.getId());
            row.set("isgroupnode", (Object)(!CollectionUtils.isEmpty((Collection)node.getChildren()) ? 1 : 0));
            row.set("pid", node.getParent() != null ? node.getParent().getId() : null);
            String date = ((DynamicObject)node.getData()).getInt("level") == 2 ? ((DynamicObject)node.getData()).getString("year.name") + "-" + ((DynamicObject)node.getData()).getString("period.name") : (((DynamicObject)node.getData()).getDate("investdate") == null ? "" : DF.format(((DynamicObject)node.getData()).getDate("investdate")));
            row.set("investdate", (Object)date);
            row.set("yearid", ((DynamicObject)node.getData()).get(YEAR));
            row.set("periodid", ((DynamicObject)node.getData()).get(PERIOD));
            row.set("investeecompanyid", ((DynamicObject)node.getData()).get("investeecompany.id"));
            row.set("modifytime", (Object)((DynamicObject)node.getData()).getDate("modifytime"));
            row.set("changescale", (Object)this.formateValue(((DynamicObject)node.getData()).getBigDecimal("changescale")));
            row.set("confirmchangescale", (Object)this.formateValue(((DynamicObject)node.getData()).getBigDecimal("confirmchangescale")));
            for (String field : FIELDS) {
                Object value = ((DynamicObject)node.getData()).get(field);
                if (value instanceof BigDecimal) {
                    value = ((BigDecimal)value).stripTrailingZeros().toPlainString();
                }
                row.set(field, value);
            }
            rowIndex.incrementAndGet();
            if (CollectionUtils.isEmpty((Collection)node.getChildren())) continue;
            this.initTreeRowData(node.getChildren(), rowIndex);
        }
    }

    private String formateValue(BigDecimal value) {
        if (value == null) {
            return "0";
        }
        return (value.compareTo(BigDecimal.ZERO) > 0 ? "+" : "") + value.stripTrailingZeros().toPlainString();
    }

    private void createInvChangeReport() {
        ArrayList<DynamicObject> batchCeateReportList = new ArrayList<DynamicObject>(10);
        DynamicObjectCollection invRela = InvestServiceHelper.queryInvShareRelaByModelID((long)this.getModelId(), (long)this.invShareCaseF7Com.getShareCaseId());
        Map<Long, List<DynamicObject>> orgInvRela = invRela.stream().collect(Collectors.groupingBy(dy -> dy.getLong("investeecompany")));
        for (Map.Entry<Long, List<DynamicObject>> longListEntry : orgInvRela.entrySet()) {
            ArrayList<Date> reportDate = new ArrayList<Date>(10);
            for (DynamicObject temprela : longListEntry.getValue()) {
                if (reportDate.isEmpty()) {
                    reportDate.add(temprela.getDate("investdate"));
                    continue;
                }
                if (this.checkDateSameMonth(temprela.getDate("investdate"), (Date)reportDate.get(reportDate.size() - 1))) {
                    reportDate.remove(reportDate.size() - 1);
                    reportDate.add(temprela.getDate("investdate"));
                    continue;
                }
                reportDate.add(temprela.getDate("investdate"));
            }
            List<DynamicObject> tempRelaList = longListEntry.getValue();
            Collections.reverse(tempRelaList);
            for (Date date : reportDate) {
                Set cyNumber;
                ArrayList<DynamicObject> createRelaList = new ArrayList<DynamicObject>(10);
                HashSet<Long> groupOrg = new HashSet<Long>(10);
                for (DynamicObject temprela : tempRelaList) {
                    if (temprela.getDate("investdate").compareTo(date) > 0 || groupOrg.contains(temprela.getLong("shareholder"))) continue;
                    Boolean isFirst = Boolean.FALSE;
                    Boolean isSame = Boolean.FALSE;
                    if (createRelaList.isEmpty()) {
                        isFirst = Boolean.TRUE;
                    }
                    if (this.checkDateSameMonth(temprela.getDate("investdate"), date)) {
                        isSame = Boolean.TRUE;
                    }
                    createRelaList.add(this.getNewReport(temprela, isFirst, isSame, date));
                    groupOrg.add(temprela.getLong("shareholder"));
                }
                List cyIds = createRelaList.stream().map(r -> r.getLong("invchangetype")).collect(Collectors.toList());
                QFilter cyFilter = new QFilter("id", "in", cyIds);
                DynamicObject[] cyDynamicObjecs = BusinessDataServiceHelper.load((String)"bcm_invchangetype", (String)"id,name,number", (QFilter[])cyFilter.toArray());
                if (cyDynamicObjecs != null && cyDynamicObjecs.length > 0 && CollectionUtils.isEmpty(cyNumber = Arrays.stream(cyDynamicObjecs).filter(cy -> !"BD001".equals(cy.getString("number"))).map(cy -> cy.getString("number")).collect(Collectors.toSet()))) {
                    createRelaList.clear();
                }
                if (createRelaList.isEmpty()) continue;
                this.copyReport(batchCeateReportList, createRelaList);
            }
        }
        if (!batchCeateReportList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])batchCeateReportList.toArray(new DynamicObject[0]));
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u80a1\u6743\u53d8\u52a8\u8868\u6210\u529f\u3002", (String)"InvRelationReportPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private DynamicObject getNewReport(DynamicObject temprela, Boolean isFirst, Boolean isSame, Date date) {
        String[] fields = "id,shareholder,investeecompany,changescale,sharescale,investdate,isout,investamount,holderec,invcompanycurrency,remark,creatorid,createtime,modifierid,modifytime,model,sharecase,changetype,iscontrol,invchangetype".split(",");
        DynamicObject report = BusinessDataServiceHelper.newDynamicObject((String)"bcm_invsharerela_report");
        for (String field : fields) {
            report.set(field, temprela.get(field));
        }
        report.set("investdategroup", (Object)date);
        report.set("isfirst", (Object)isFirst);
        report.set("issamemon", (Object)isSame);
        report.set("sharescale", (Object)temprela.getBigDecimal("sharescale").setScale(2, RoundingMode.HALF_UP));
        report.set("changescale", (Object)temprela.getBigDecimal("changescale").setScale(2, RoundingMode.HALF_UP));
        if (isSame.booleanValue()) {
            report.set("bopscale", (Object)temprela.getBigDecimal("sharescale").setScale(2, RoundingMode.HALF_UP).subtract(temprela.getBigDecimal("changescale").setScale(2, RoundingMode.HALF_UP)));
        } else {
            report.set("bopscale", (Object)temprela.getBigDecimal("sharescale").setScale(2, RoundingMode.HALF_UP));
            report.set("changescale", (Object)BigDecimal.ZERO);
        }
        return report;
    }

    private void copyReport(List<DynamicObject> batchCeateReportList, List<DynamicObject> createRelaList) {
        batchCeateReportList.addAll(createRelaList);
    }

    private boolean checkDateSameMonth(Date date1, Date date2) {
        SimpleDateFormat dataFormat = new SimpleDateFormat("yyyy-MM");
        return dataFormat.format(date1).equals(dataFormat.format(date2));
    }

    private DynamicObjectCollection getTreeListORM(Long modelid) {
        DynamicObjectCollection doc = null;
        if (this.checkValue()) {
            QFBuilder builder = new QFBuilder();
            builder.add("isleaf", "!=", (Object)true);
            doc = this.getCustomOrgDynamicObjectCollection(modelid, builder);
            if (!doc.isEmpty()) {
                this.delOrgMenberPerm(doc, modelid);
            }
        }
        return doc;
    }

    private boolean checkValue() {
        IDataModel dataModel = this.getModel();
        return dataModel.getValue(MODEL) != null && dataModel.getValue(YEAR) != null && dataModel.getValue(SCENARIO) != null && dataModel.getValue(PERIOD) != null;
    }

    private List<String> toList(DynamicObjectCollection docs) {
        ArrayList<String> temp = new ArrayList<String>();
        for (DynamicObject doc : docs) {
            temp.add(doc.getString("number"));
        }
        return temp;
    }

    private void initTree(AbstractTreeNode<Object> root) {
        TreeView tree = (TreeView)this.getControl("tree_org");
        tree.setRootVisible(false);
        if (root != null) {
            TreeModel treemodel = new TreeModel(root);
            treemodel.buildEntryTree(tree);
            if (root.getChildren() == null) {
                return;
            }
            TreeNode selectnode = this.findCacheNode(root);
            tree.focusNode(selectnode);
            this.getPageCache().put("nodeSelected", selectnode.getId());
            this.expandAllSelected((TreeModel<AbstractTreeNode<Object>>)treemodel, tree);
            treemodel.ache2page(this.getPageCache(), "cache_treeentity");
        }
    }

    private void expandAllSelected(TreeModel<AbstractTreeNode<Object>> treemodel, TreeView treeView) {
        List<String> selects = new ArrayList(10);
        if (this.getPageCache().get("selectorgs") != null) {
            selects = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("selectorgs"));
        }
        if (!StringUtil.isEmptyString((String)this.getPageCache().get("nodeSelected"))) {
            selects.add(this.getPageCache().get("nodeSelected"));
        }
        OrgTreeNode root = (OrgTreeNode)treemodel.getRoot();
        for (String nodeid : selects) {
            OrgTreeNode node = (OrgTreeNode)treemodel.searchByNodeId(nodeid);
            if (node == null || node.getId() == null || node.getId().equals(root.getId())) continue;
            String parentid = node.getParent().getId();
            while (!parentid.equals(root.getId())) {
                treeView.expand(parentid);
                node = (OrgTreeNode)node.getParent();
                parentid = node.getParent().getId();
            }
        }
    }

    private TreeNode findCacheNode(AbstractTreeNode<Object> root) {
        List selects = new ArrayList(16);
        DynamicObject org = this.getParentPageOrg();
        if (org != null) {
            return new TreeNode(org.getString("parent"), org.getString("id"), org.getString("name"));
        }
        String selectnode = GuidePageUtils.getUserSelectOrg(this.getView(), this.getUserId(), this.getModelId(), true, false);
        if (this.getPageCache().get("selectorgs") != null) {
            selects = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("selectorgs"));
            selectnode = (String)selects.get(selects.size() - 1);
        }
        if (selectnode == null || selectnode.equals(root.getId())) {
            return new TreeNode("0", root.getId(), root.getName());
        }
        LinkedList<AbstractTreeNode<Object>> queue = new LinkedList<AbstractTreeNode<Object>>();
        queue.add(root);
        while (!queue.isEmpty()) {
            ITreeNode node = (ITreeNode)queue.poll();
            if (node.getId().equals(selectnode)) {
                return new TreeNode(node.getParent().getId(), node.getId(), "");
            }
            List children = node.getChildren();
            if (children.size() == 0) continue;
            queue.addAll(children);
        }
        return new TreeNode("0", root.getId(), root.getName());
    }

    private DynamicObject getParentPageOrg() {
        String orgid = this.getPageCache().get(PARENT_ORG);
        if (orgid == null) {
            return null;
        }
        this.getPageCache().remove(PARENT_ORG);
        QFilter qf = new QFilter("id", "=", (Object)LongUtil.toLong((Object)orgid));
        return QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,name,number,parent", (QFilter[])qf.toArray());
    }

    private void switchBillStap(ReportTypeEnum reportType) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap", "flexpanelap2", "flexpanelap3", "min_share_holding_hide", "min_share_holding_show", "btn_export", SHARE_CASE, "btn_report", "btn_rpt_export"});
        switch (reportType) {
            case ORGTABLE: {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap", "btn_export", SHARE_CASE, "btn_report"});
                break;
            }
            case ORGCHART: {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap3", SHARE_CASE, "btn_report"});
                if (ChartDataConst.MinShareHolding.getMinShareHoldingByName((String)this.getPageCache().get(MIN_SHARE_HOLDING_STATUS)) == ChartDataConst.MinShareHolding.hide) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap3", "min_share_holding_show"});
                    break;
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap3", "min_share_holding_hide"});
                break;
            }
            case YEAR: 
            case MONTH: 
            case ALL: {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap2", "btn_rpt_export"});
                break;
            }
        }
    }

    private void doDimChange(String propertyName) {
        DynamicObject modelObj;
        String modelId = null;
        if (MODEL.equals(propertyName)) {
            Object value = this.getModel().getValue(MODEL);
            if (value != null) {
                modelId = ((DynamicObject)value).getString("id");
                this.getPageCache().put("KEY_MODEL_ID", modelId);
                this.initCslschemeValue(modelId, false);
            } else {
                this.getPageCache().put("KEY_MODEL_ID", null);
            }
        }
        if ((modelObj = (DynamicObject)this.getModel().getValue(MODEL)) != null && !StringUtils.isEmpty((CharSequence)(modelId = modelObj.getString("id")))) {
            this.refreshTree(modelId);
        }
    }

    private void rebuildOrgTable() {
        this.getModel().deleteEntryData("entryentity");
        this.setShareholderVisible(false, InvStructureTableService.getMaxShareholderLevel());
        this.queryDataBeforeDoAction((ctrlOrg, holder) -> {
            String rootOrgNumber;
            if (ctrlOrg != null && holder.containsKey(rootOrgNumber = ctrlOrg.getString("ctrlorg.number"))) {
                this.getModel().setValue("companylevel1", (Object)this.packShowName(ctrlOrg.getString("ctrlorg.name"), rootOrgNumber), this.getModel().createNewEntryRow("entryentity"));
                this.buildOrgTableByRootNum(rootOrgNumber, (Map<String, List<DynamicObject>>)holder, 2);
            }
        });
    }

    private void setShareholderVisible(boolean isVisible, int maxCol) {
        if (maxCol > this.currentCol) {
            ArrayList<String> props = new ArrayList<String>(maxCol * 2);
            for (int i = this.currentCol; i < maxCol; ++i) {
                props.add("shareholder" + (i + 1));
                props.add("indirectscale" + (i + 1));
            }
            if (isVisible) {
                this.currentCol = maxCol;
            }
            this.getView().setVisible(Boolean.valueOf(isVisible), props.toArray(new String[0]));
        }
    }

    private boolean checkMustInputIsAccess() {
        return this.getCtx().getFyId() != 0L && this.getCtx().getScenarioId() != 0L && this.getCtx().getPeriodId() != 0L && this.getCtx().getModelId() != 0L && this.getCtx().getCslschemeId() != 0L;
    }

    private void buildOrgTableByRootNum(String rootNum, Map<String, List<DynamicObject>> holders, int level) {
        if (level > InvStructureTableService.getMaxCompanyLevel()) {
            return;
        }
        if (holders.containsKey(rootNum)) {
            holders.get(rootNum).stream().sorted((org1, org2) -> {
                if (org1 == null || org2 == null) {
                    return 0;
                }
                IDNumberTreeNode tree1 = MemberReader.findEntityMemberById((String)this.getCtx().getModelNum(), (Long)org1.getLong("entity.id"));
                IDNumberTreeNode tree2 = MemberReader.findEntityMemberById((String)this.getCtx().getModelNum(), (Long)org2.getLong("entity.id"));
                return this.levelCompareReOrg(tree1, tree2);
            }).forEach(holder -> {
                this.createOrgTableNewRow((DynamicObject)holder, level);
                this.buildOrgTableByRootNum(holder.getString("entity.number"), holders, level + 1);
            });
        }
    }

    private int levelCompareReOrg(IDNumberTreeNode tree1, IDNumberTreeNode tree2) {
        int levelCompareRe = 0;
        if (tree1.getLevel() == tree2.getLevel()) {
            levelCompareRe = tree1.getParent() == tree2.getParent() ? tree1.getdSeq() - tree2.getdSeq() : tree1.getParent().getdSeq() - tree2.getParent().getdSeq();
        } else {
            levelCompareRe = Math.min(tree1.getLevel(), tree2.getLevel());
            do {
                if (levelCompareRe != tree1.getLevel()) {
                    tree1 = tree1.getParent();
                }
                if (levelCompareRe == tree2.getLevel()) continue;
                tree2 = tree2.getParent();
            } while (tree1.getLevel() != tree2.getLevel());
            levelCompareRe = this.levelCompareReOrg(tree1, tree2);
        }
        return levelCompareRe;
    }

    private void createOrgTableNewRow(DynamicObject holder, int level) {
        int row = this.getModel().createNewEntryRow("entryentity");
        this.getModel().setValue("companylevel" + level, (Object)this.packShowName(holder.getString("entity.name"), holder.getString("entity.number")), row);
        this.getModel().setValue("directscale", (Object)holder.getBigDecimal("directscale"), row);
        List otherHolders = holder.getDynamicObjectCollection("entryentity").parallelStream().sorted((c1, c2) -> c2.getBigDecimal("indirectscale").compareTo(c1.getBigDecimal("indirectscale"))).collect(Collectors.toList());
        int shareholderNum = Math.min(InvStructureTableService.getMaxShareholderLevel(), otherHolders.size());
        for (int i = 1; i <= shareholderNum; ++i) {
            DynamicObject otherHolder = (DynamicObject)otherHolders.get(i - 1);
            this.setShareholderVisible(true, shareholderNum);
            this.getModel().setValue("shareholder" + i, (Object)this.packShowName(otherHolder.getString("shareholder.name"), otherHolder.getString("shareholder.number")), row);
            this.getModel().setValue("indirectscale" + i, (Object)otherHolder.getBigDecimal("indirectscale"), row);
        }
    }

    private String packShowName(String name, String number) {
        return TreeBuilder.formatDisplayName((String)this.getModel().getValue("showorgtype").toString(), (String)name, (String)number, (String)"");
    }

    public static Date getYearFirst(Long yearid) {
        int year = Integer.parseInt(PeriodUtils.getYear((long)yearid));
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        return calendar.getTime();
    }

    private QFBuilder getIsolationQFilter() {
        long shareCaseId = this.invShareCaseF7Com.getShareCaseId();
        long modelId = this.getModelId();
        return InvShareRelaService.getIsolationQFilter((long)modelId, (long)shareCaseId);
    }
}

