/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.invest.InvSheetTemplateService;
import kd.fi.bcm.business.invest.helper.InvRelationTypeHelper;
import kd.fi.bcm.business.invest.helper.InvStaticStockRatioHelper;
import kd.fi.bcm.business.invest.relation.InvRelationLogContext;
import kd.fi.bcm.business.invest.relation.InvRelationLogService;
import kd.fi.bcm.business.invest.service.InvShareholdingValidator;
import kd.fi.bcm.business.invest.service.InvValidateHelper;
import kd.fi.bcm.business.invest.service.InvValidator;
import kd.fi.bcm.business.invest.sheet.GlobalIdDistributer;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.sharerela.InvStaticStockRatioConstant;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.impexport.BillResult;
import kd.fi.bcm.formplugin.invest.InvShareRelaImportNewPlugin;

public class InvRelationSearchImportNewPlugin
extends BatchImportPlugin {
    private static Log log = LogFactory.getLog(InvShareRelaImportNewPlugin.class);
    private static final String FI_BCM_FORM_PLUGIN = "fi-bcm-formplugin";
    private Map<String, Integer> relationType2Seq = new HashMap<String, Integer>(16);
    private DynamicObject model;
    private DynamicObject cslScheme;
    private DynamicObject scenario;
    private DynamicObject year;
    private DynamicObject period;
    private Map<String, Long> mergeNumber2BaseId;
    private long selectedNodeId;
    private Map<String, String> relationTypeNumber2Name;
    private Map<String, DynamicObject> collect;
    private Map<String, Long> limTempNumber2Dy;
    private Map<String, Long> tempNumberToGroup;
    private final Table<String, String, Long> sheetEntryTable = HashBasedTable.create();

    protected boolean isForceBatch() {
        return true;
    }

    protected int getBatchImportSize() {
        return 50000;
    }

    public void beforeSave(List<ImportBillData> billDatas, ImportLogger logger) {
        this.intModelAndPermMap();
        if (Objects.isNull(this.model) || Objects.isNull(this.cslScheme) || Objects.isNull(this.scenario) || Objects.isNull(this.year) || Objects.isNull(this.period) || Objects.isNull(this.mergeNumber2BaseId) || this.mergeNumber2BaseId.isEmpty() || this.selectedNodeId == 0L) {
            this.writeOperationLog(ResManager.loadKDString((String)"F7\u7ef4\u5ea6\u4fe1\u606f\u4e0d\u8db3 \u3002", (String)"InvRelationSearchImportNewPlugin_1", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), billDatas.size(), 0);
            billDatas.clear();
        }
        ComboProp comboProp = (ComboProp)this.mainEntityType.getProperty("invrelatype");
        comboProp.getComboItems().clear();
        InvRelationTypeHelper.consumeStaticRelationsType((long)this.model.getLong("id"), (number, name, isUse) -> {
            String nameStr = name.getLocaleValue() == null ? "" : name.getLocaleValue();
            comboProp.getComboItems().add(new ValueMapItem(null, number, new LocaleString(nameStr)));
        });
        super.beforeSave(billDatas, logger);
    }

    public ApiResult save(List<ImportBillData> importBillDataList, ImportLogger logger) {
        ApiResult result = new ApiResult();
        result.setSuccess(true);
        long modelId = this.model.getLong("id");
        long yearId = this.year.getLong("id");
        long scenarioId = this.scenario.getLong("id");
        long periodId = this.period.getLong("id");
        Collection<Long> baseIds = this.mergeNumber2BaseId.values();
        this.prepareData(modelId, yearId, scenarioId, periodId, baseIds);
        InvRelationLogContext logContext = new InvRelationLogContext(modelId, scenarioId, yearId, periodId, MemberReader.findEntityMemberById((Long)modelId, (Long)baseIds.iterator().next()).getBaseTreeNode().getId().longValue());
        InvRelationLogService invRelationLogService = InvRelationLogService.logWithStaticChange((InvRelationLogContext)logContext);
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        HashSet<DynamicObject> needUpdateData = new HashSet<DynamicObject>(16);
        HashSet<DynamicObject> needNewSaveData = new HashSet<DynamicObject>(16);
        GlobalIdDistributer idDistributor = new GlobalIdDistributer();
        Date now = TimeServiceHelper.now();
        Long userId = RequestContext.get().getCurrUserId();
        ImportOperateType importType = ImportHelper.getImportType(this.ctx);
        ArrayList<Map<String, Object>> rowRs = new ArrayList<Map<String, Object>>(16);
        InvValidateHelper<JSONObject> jsonValidateHelper = this.jsonObjectValidateHelper();
        InvValidateHelper<DynamicObject> dynamicValidateHelper = this.dynObjectValidateHelper();
        for (int i = 0; i < importBillDataList.size(); ++i) {
            Runnable runLog;
            Integer seq;
            Consumer<DynamicObject> renderDataCompute;
            ImportBillData importBillData = importBillDataList.get(i);
            JSONObject data = importBillData.getData();
            String key = this.generateKey(data);
            DynamicObject dynamicObject = this.collect.get(key);
            BillResult rs = this.validationData(importType, data, this.generateKeyName(data, this.relationTypeNumber2Name), dynamicObject, jsonValidateHelper);
            rs.setIndex(i);
            if (!rs.isSucess()) {
                result.setSuccess(false);
                rowRs.add(rs.toMap());
                continue;
            }
            String relationType = data.getString("invrelatype");
            DynamicObject newDynObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_invrelation");
            if (Objects.nonNull(dynamicObject)) {
                DynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)newDynObject);
                newDynObject.set("id", (Object)dynamicObject.getLong("id"));
                renderDataCompute = needUpdateData::add;
                if (InvStaticStockRatioConstant.DeleteStatus.DELETE.getCode().equals(dynamicObject.getString("isdelete"))) {
                    seq = this.relationType2Seq.computeIfPresent(relationType, (k, v) -> {
                        Integer n = v;
                        Integer n2 = v = Integer.valueOf(v + 1);
                        return n;
                    });
                    newDynObject.set("relaseq", (Object)(seq == null ? Integer.valueOf(0) : seq));
                    runLog = () -> invRelationLogService.collectStaticChange(newDynObject, Collections.emptyList());
                } else {
                    runLog = () -> invRelationLogService.collectStaticChange(newDynObject, (List)Lists.newArrayList((Object[])new DynamicObject[]{dynamicObject}));
                }
            } else {
                newDynObject.set("id", (Object)idDistributor.getLongId());
                seq = this.relationType2Seq.computeIfPresent(relationType, (k, v) -> {
                    Integer n = v;
                    Integer n2 = v = Integer.valueOf(v + 1);
                    return n;
                });
                newDynObject.set("relaseq", (Object)(seq == null ? Integer.valueOf(0) : seq));
                renderDataCompute = needNewSaveData::add;
                runLog = () -> invRelationLogService.collectStaticChange(newDynObject, Collections.emptyList());
            }
            newDynObject.set("model", this.getF7Id(data, this.model, "model", "shownumber"));
            newDynObject.set("scenario", this.getF7Id(data, this.scenario, "scenario", "number"));
            newDynObject.set("year", this.getF7Id(data, this.year, "year", "number"));
            newDynObject.set("period", this.getF7Id(data, this.period, "period", "number"));
            Long baseOrgId = this.getBaseId(data, this.mergeNumber2BaseId, "orgunit");
            newDynObject.set("orgunit", (Object)baseOrgId);
            newDynObject.set("shareholder", (Object)this.getMemberId(modelNum, data, DimTypesEnum.INTERCOMPANY.getNumber(), "shareholder"));
            QFBuilder qfBuilder = new QFBuilder("number", "=", (Object)this.getNumberFromJson(data, "investeecompany")).and("model", "=", (Object)modelId).and("isexchangerate", "=", (Object)"0").and(new QFilter("isleaf", "=", (Object)"1").or("isindependentorg", "=", (Object)"1"));
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id", (QFilter[])qfBuilder.toArray());
            newDynObject.set("investeecompany", (Object)(collection.isEmpty() ? 0L : ((DynamicObject)collection.get(0)).getLong("id")));
            newDynObject.set("invrelatype", (Object)relationType);
            newDynObject.set("equvscale", (Object)data.getBigDecimal("equvscale"));
            newDynObject.set("confirmscale", (Object)data.getBigDecimal("confirmscale"));
            newDynObject.set("minconfirmscale", (Object)data.getBigDecimal("minconfirmscale"));
            newDynObject.set("isusedinvrule", data.get((Object)"isusedinvrule"));
            newDynObject.set("isconfirmed", data.get((Object)"isconfirmed"));
            newDynObject.set("isdelete", (Object)InvStaticStockRatioConstant.DeleteStatus.SAVE.getCode());
            newDynObject.set("modifier", (Object)userId);
            newDynObject.set("modifytime", (Object)now);
            DynamicObjectCollection limTemplate = newDynObject.getDynamicObjectCollection("invelimtemplate");
            limTemplate.clear();
            DynamicObjectCollection effectTemps = newDynObject.getDynamicObjectCollection("effecttemp");
            effectTemps.clear();
            Pair<Set<String>, Set<String>> warringNumbers = this.importTemplate(data, effectTemps);
            Pair<Set<String>, Set<String>> warringNewNumbers = this.importNewTemplate(data, effectTemps);
            List dyCheckRs = dynamicValidateHelper.doValidate((Object)newDynObject);
            this.addTemplateCheckMsg(warringNumbers, dyCheckRs);
            this.addNewTemplateCheckMsg(warringNewNumbers, dyCheckRs);
            if (!dyCheckRs.isEmpty()) {
                rs.setMessage(String.join((CharSequence)" ", dyCheckRs));
                rs.setSucess(false);
                result.setSuccess(false);
                rowRs.add(rs.toMap());
                continue;
            }
            rs.setId(newDynObject.getLong("id"));
            rowRs.add(rs.toMap());
            renderDataCompute.accept(newDynObject);
            runLog.run();
        }
        InvStaticStockRatioHelper.newAddSave(needNewSaveData);
        InvStaticStockRatioHelper.updateStockRadioInfo(needUpdateData);
        invRelationLogService.saveLogs(InvRelationLogService.OperationEnum.IMPORT_STATIC);
        result.setData(rowRs);
        this.logSuccess(importBillDataList, logger, needUpdateData, needNewSaveData);
        return result;
    }

    private void addNewTemplateCheckMsg(Pair<Set<String>, Set<String>> warringNewNumbers, List<String> dyCheckRs) {
        Set isExceptOutOfEnum;
        Set noThisTempNumbers = (Set)warringNewNumbers.p1;
        if (!noThisTempNumbers.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0d\u5b58\u5728\u6a21\u677f\u7f16\u7801|\u5206\u5f55\u7f16\u7801\u4e3a%1$s\u7684\u5e95\u7a3f\u6a21\u677f\u5206\u5f55\u914d\u7f6e\u3002", (String)"InvRelationSearchImportNewPlugin_21", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
            dyCheckRs.add(String.format(msg, String.join((CharSequence)"\u3001", noThisTempNumbers)));
        }
        if (!(isExceptOutOfEnum = (Set)warringNewNumbers.p2).isEmpty()) {
            String msg = ResManager.loadKDString((String)"%1$s\u8d85\u51fa\u662f\u5426\u9002\u7528\u53d6\u503c\u8303\u56f4{0\uff1a\u9002\u7528\uff0c1\uff1a\u4f8b\u5916}", (String)"InvRelationSearchImportNewPlugin_22", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
            dyCheckRs.add(String.format(msg, String.join((CharSequence)"\u3001", isExceptOutOfEnum)));
        }
    }

    private Pair<Set<String>, Set<String>> importNewTemplate(JSONObject data, DynamicObjectCollection effectTemps) {
        String[] numbers;
        HashSet<String> noThisTempNumbers = new HashSet<String>(16);
        HashSet<String> isExceptOutOfEnum = new HashSet<String>(16);
        for (String number : numbers = Optional.ofNullable(data.getString("effectnewtempnumbers")).map(templates -> templates.split(",")).orElseGet(() -> new String[0])) {
            String sheetEntryNumber;
            String tempNumber;
            Long id;
            String[] tempNumbers;
            String[] numberAndIsExceptConfig = number.split("@");
            if (numberAndIsExceptConfig.length < 2 || (tempNumbers = numberAndIsExceptConfig[0].split("\\|")).length < 2 || (id = (Long)this.sheetEntryTable.get((Object)(tempNumber = tempNumbers[0]), (Object)(sheetEntryNumber = tempNumbers[1]))) == null) {
                noThisTempNumbers.add(number);
                continue;
            }
            String isExcept = numberAndIsExceptConfig[1];
            if (InvStaticStockRatioConstant.ExceptEnum.getExceptByCode((String)isExcept) == null) {
                isExceptOutOfEnum.add(isExcept);
                continue;
            }
            DynamicObject configRow = effectTemps.addNew();
            Long group = this.tempNumberToGroup.getOrDefault(tempNumber, 0L);
            configRow.set("temtype", (Object)"bcm_invsheetttplentrys");
            configRow.set("temp", (Object)id);
            configRow.set("isexcept", (Object)isExcept);
            configRow.set("group", (Object)group);
            configRow.set("number", (Object)sheetEntryNumber);
        }
        return Pair.onePair(noThisTempNumbers, isExceptOutOfEnum);
    }

    private void addTemplateCheckMsg(Pair<Set<String>, Set<String>> setSetPair, List<String> dyCheckRs) {
        Set isExceptOutOfEnum;
        Set noThisTempNumbers = (Set)setSetPair.p1;
        if (!noThisTempNumbers.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%1$s\u7684\u6743\u76ca\u6a21\u677f\u3002", (String)"InvRelationSearchImportNewPlugin_23", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
            dyCheckRs.add(String.format(msg, String.join((CharSequence)"\u3001", noThisTempNumbers)));
        }
        if (!(isExceptOutOfEnum = (Set)setSetPair.p2).isEmpty()) {
            String msg = ResManager.loadKDString((String)"%1$s\u8d85\u51fa\u662f\u5426\u9002\u7528\u53d6\u503c\u8303\u56f4{0\uff1a\u9002\u7528\uff0c1\uff1a\u4f8b\u5916}", (String)"InvRelationSearchImportNewPlugin_22", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
            dyCheckRs.add(String.format(msg, String.join((CharSequence)"\u3001", isExceptOutOfEnum)));
        }
    }

    private Pair<Set<String>, Set<String>> importTemplate(JSONObject data, DynamicObjectCollection limTemplate) {
        String[] numbers;
        HashSet<String> noThisTempNumbers = new HashSet<String>(16);
        HashSet<String> isExceptOutOfEnum = new HashSet<String>(16);
        for (String number : numbers = Optional.ofNullable(data.getJSONObject("invelimtemplate")).map(jsonObject -> jsonObject.getString("number")).map(templates -> templates.split(",")).orElseGet(() -> new String[0])) {
            Long id;
            String isExcept = InvStaticStockRatioConstant.ExceptEnum.APPLICABLE.getCode();
            if (number.contains("@")) {
                String[] split = number.split("@");
                number = split[0];
                isExcept = split[1];
            }
            if ((id = this.limTempNumber2Dy.get(number)) == null) {
                noThisTempNumbers.add(number);
                continue;
            }
            if (InvStaticStockRatioConstant.ExceptEnum.getExceptByCode((String)isExcept) == null) {
                isExceptOutOfEnum.add(isExcept);
                continue;
            }
            DynamicObject configRow = limTemplate.addNew();
            configRow.set("temtype", (Object)"bcm_invelimtemplatebase");
            configRow.set("temp", (Object)id);
            configRow.set("isexcept", (Object)isExcept);
        }
        return Pair.onePair(noThisTempNumbers, isExceptOutOfEnum);
    }

    private void prepareData(long modelId, long yearId, long scenarioId, long periodId, Collection<Long> baseIds) {
        this.relationTypeNumber2Name = new HashMap<String, String>(16);
        InvRelationTypeHelper.consumeStaticRelationsType((long)this.model.getLong("id"), (number, name, isUse) -> this.relationTypeNumber2Name.put((String)number, name.getLocaleValue()));
        DynamicObjectCollection dynamicObjects = InvStaticStockRatioHelper.loadRelationByF7((long)modelId, (long)scenarioId, (long)yearId, (long)periodId, baseIds, (String)InvStaticStockRatioConstant.selectFields((String[])new String[]{"orgunit.number", "shareholder.number", "investeecompany.number"}));
        this.effectTempCanUse(modelId, yearId, periodId);
        this.collect = dynamicObjects.stream().peek(dy -> {
            int seq;
            String relationType = dy.getString("invrelatype");
            Integer integer = this.relationType2Seq.computeIfPresent(relationType, (arg_0, arg_1) -> InvRelationSearchImportNewPlugin.lambda$null$12(seq = dy.getInt("relaseq"), arg_0, arg_1));
            if (Objects.isNull(integer)) {
                this.relationType2Seq.put(relationType, seq);
            }
        }).collect(Collectors.toMap(this::generateKey, e -> e, (v1, v2) -> v1));
    }

    private void effectTempCanUse(long modelId, long yearId, long periodId) {
        QFilter[] filters = new QFilter[]{new QFilter("model", "=", (Object)modelId)};
        DynamicObjectCollection limTempDys = QueryServiceHelper.query((String)"bcm_invelimtemplatebase", (String)"id,number", (QFilter[])filters);
        this.limTempNumber2Dy = limTempDys.stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getLong("id"), (v1, v2) -> v1));
        DynamicObjectCollection sheetTemp = InvSheetTemplateService.querySheetTemp((Long)modelId, (Long)yearId, (Long)periodId);
        this.tempNumberToGroup = sheetTemp.stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getLong("group"), (v1, v2) -> v1));
        List sheetTempIds = sheetTemp.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        QFBuilder qfSheetEntryBuilder = new QFBuilder("sheettemplate", "in", sheetTempIds);
        String selectFields = "id,number,sheettemplate.number";
        DynamicObjectCollection sheetEntries = QueryServiceHelper.query((String)"bcm_invsheetttplentrys", (String)selectFields, (QFilter[])qfSheetEntryBuilder.toArray());
        for (DynamicObject dy2 : sheetEntries) {
            long sheetEntryId = dy2.getLong("id");
            String sheetEntryNumber = dy2.getString("number");
            String tempNumber = dy2.getString("sheettemplate.number");
            this.sheetEntryTable.put((Object)tempNumber, (Object)sheetEntryNumber, (Object)sheetEntryId);
        }
    }

    private Object getF7Id(JSONObject data, DynamicObject f7Dy, String member, String number) {
        if (data.getJSONObject(member).get((Object)number).equals(f7Dy.getString(number))) {
            return f7Dy.get("id");
        }
        return null;
    }

    private Long getBaseId(JSONObject data, Map<String, Long> mergeNumber2BaseId, String member) {
        return mergeNumber2BaseId.getOrDefault(data.getJSONObject(member).getString("number"), null);
    }

    private BillResult validationData(ImportOperateType importType, JSONObject data, String key, DynamicObject dynamicObject, InvValidateHelper<JSONObject> validate) {
        String orgUnit;
        String msg;
        BillResult rs = new BillResult();
        rs.setSucess(true);
        rs.setData((Map<String, Object>)data);
        List validateRs = validate.doValidate((Object)data);
        if (dynamicObject != null && ImportOperateType.NEW == importType && InvStaticStockRatioConstant.DeleteStatus.SAVE.getCode().equals(dynamicObject.getString("isdelete"))) {
            msg = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5408\u5e76\u8282\u70b9+\u6295\u8d44\u5355\u4f4d+\u88ab\u6295\u5355\u4f4d+\u80a1\u6bd4\u7c7b\u578b\u3010%1$s\u3011\u7684\u9759\u6001\u80a1\u6bd4\u5173\u7cfb\u3002", (String)"InvRelationSearchImportNewPlugin_2", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
            validateRs.add(String.format(msg, key));
        }
        if (ImportOperateType.OVERRIDE == importType && (dynamicObject == null || InvStaticStockRatioConstant.DeleteStatus.DELETE.getCode().equals(dynamicObject.getString("isdelete")))) {
            msg = ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5408\u5e76\u8282\u70b9+\u6295\u8d44\u5355\u4f4d+\u88ab\u6295\u5355\u4f4d+\u80a1\u6bd4\u7c7b\u578b\u3010%1$s\u3011\u7684\u9759\u6001\u80a1\u6bd4\u5173\u7cfb\u3002", (String)"InvRelationSearchImportNewPlugin_3", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
            validateRs.add(String.format(msg, key));
        }
        if (!this.relationTypeNumber2Name.containsKey(data.getString("invrelatype"))) {
            msg = ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u80a1\u6bd4\u7c7b\u578b\u3010%1$s\u3011\u3002", (String)"InvRelationSearchImportNewPlugin_4", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
            validateRs.add(String.format(msg, data.getString("invrelatype")));
        }
        if (StringUtils.isNotEmpty((String)(orgUnit = data.getJSONObject("orgunit").getString("number"))) && !PeriodSettingHelper.checkPeriodStatus((long)this.model.getLong("id"), (String)orgUnit, (long)this.scenario.getLong("id"), (long)this.year.getLong("id"), (long)this.period.getLong("id"), (String)"datastatus")) {
            String msg2 = ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9\u3010%1$s\u3011\u5728\u5f53\u524d\u671f\u95f4\u672a\u5f00\u542f\u3002", (String)"InvRelationSearchImportNewPlugin_18", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
            validateRs.add(String.format(msg2, orgUnit));
        }
        if (!validateRs.isEmpty()) {
            rs.setMessage(String.join((CharSequence)" ", validateRs));
            rs.setSucess(false);
        }
        return rs;
    }

    private InvValidateHelper<JSONObject> jsonObjectValidateHelper() {
        InvShareholdingValidator validator = new InvShareholdingValidator(this.model.getLong("id"));
        String investedCompanyPropName = ResManager.loadKDString((String)"\u88ab\u6295\u8d44\u5355\u4f4d", (String)"InvRelationSearchImportNewPlugin_5", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        String shareholderPropName = ResManager.loadKDString((String)"\u6295\u8d44\u5355\u4f4d", (String)"InvRelationSearchImportNewPlugin_6", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        return new InvValidateHelper((InvValidator)validator).add(() -> validator.ratioBetween0To100("confirmscale", ResManager.loadKDString((String)"\u786e\u8ba4\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationSearchImportNewPlugin_7", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]))).add(() -> validator.ratioBetween0To100("minconfirmscale", ResManager.loadKDString((String)"\u5c11\u6570\u80a1\u4e1c\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationSearchImportNewPlugin_8", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]))).add(() -> validator.ratioBetween0To100("equvscale", ResManager.loadKDString((String)"\u7b49\u6548\u6301\u80a1\u6bd4\u4f8b", (String)"InvRelationSearchImportNewPlugin_9", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]))).add(() -> validator.independentOrg("shareholder.number", shareholderPropName)).add(() -> validator.independentOrg("investeecompany.number", investedCompanyPropName)).add(() -> validator.notEquals("shareholder.number", "investeecompany.number")).add(() -> validator.uniqueComboByKey("invrelatype", new String[]{"orgunit.number", "shareholder.number", "investeecompany.number"})).add(() -> validator.staticStockRadioRelation("invrelatype", "equvscale", "confirmscale", "minconfirmscale"));
    }

    private InvValidateHelper<DynamicObject> dynObjectValidateHelper() {
        long modelId = this.model.getLong("id");
        InvShareholdingValidator validator = new InvShareholdingValidator(modelId);
        String investedCompanyPropName = ResManager.loadKDString((String)"\u88ab\u6295\u8d44\u5355\u4f4d", (String)"InvRelationSearchImportNewPlugin_5", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        String orgUnit = ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9", (String)"InvRelationSearchImportNewPlugin_10", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        PermissionService permissionService = PermissionServiceImpl.getInstance((Long)modelId);
        Long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity");
        return new InvValidateHelper((InvValidator)validator).add(() -> validator.baseDataNotNull("model", ResManager.loadKDString((String)"\u4f53\u7cfb", (String)"InvRelationSearchImportNewPlugin_11", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]))).add(() -> validator.baseDataNotNull("scenario", ResManager.loadKDString((String)"\u60c5\u666f", (String)"InvRelationSearchImportNewPlugin_12", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]))).add(() -> validator.baseDataNotNull("year", ResManager.loadKDString((String)"\u8d22\u5e74", (String)"InvRelationSearchImportNewPlugin_13", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]))).add(() -> validator.baseDataNotNull("period", ResManager.loadKDString((String)"\u671f\u95f4", (String)"InvRelationSearchImportNewPlugin_14", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]))).add(() -> validator.baseDataNotNull("orgunit", orgUnit)).add(() -> validator.baseDataNotNull("shareholder", ResManager.loadKDString((String)"\u6295\u8d44\u5355\u4f4d", (String)"InvRelationSearchImportNewPlugin_6", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]))).add(() -> validator.staticStockInvestedCompanyNotNull("invrelatype", "investeecompany")).add(() -> validator.entHaveReadwritePerm("orgunit", permissionService, dimensionId, orgUnit)).add(() -> validator.entHavePerm("investeecompany", permissionService, dimensionId, investedCompanyPropName));
    }

    private String getNumberFromJson(JSONObject data, String key) {
        return data.getJSONObject(key).getString("number");
    }

    private Long getMemberId(String modelNum, JSONObject data, String dimNum, String key) {
        String number = this.getNumberFromJson(data, key);
        IDNumberTreeNode mc = MemberReader.findMemberByNumber((String)modelNum, (String)dimNum, (String)number);
        return mc.getId();
    }

    private String generateKey(DynamicObject dynamicObject) {
        return this.generateKey(dynamicObject.getString("orgunit.number"), dynamicObject.getString("shareholder.number"), dynamicObject.getString("investeecompany.number"), dynamicObject.getString("invrelatype"));
    }

    private String generateKey(JSONObject jsonObject) {
        return this.generateKey(this.getNumberFromJson(jsonObject, "orgunit"), this.getNumberFromJson(jsonObject, "shareholder"), this.getNumberFromJson(jsonObject, "investeecompany"), jsonObject.getString("invrelatype"));
    }

    private String generateKeyName(JSONObject dynamicObject, Map<String, String> relationTypeNumber2Name) {
        String invRelaType = dynamicObject.getString("invrelatype");
        return this.generateKey(this.getNumberFromJson(dynamicObject, "orgunit"), this.getNumberFromJson(dynamicObject, "shareholder"), this.getNumberFromJson(dynamicObject, "investeecompany"), relationTypeNumber2Name.getOrDefault(invRelaType, invRelaType));
    }

    private String generateKey(String merge, String shareholder, String investedCompany, String changeType) {
        return String.join((CharSequence)"&", merge, shareholder, investedCompany, changeType);
    }

    private void intModelAndPermMap() {
        try {
            Class<?> aClass = this.ctx.getClass();
            Field view = aClass.getDeclaredField("view");
            ReflectionUtils.makeAccessible((Field)view);
            IFormView formView = (IFormView)view.get(this.ctx);
            IFormView parentView = formView.getParentView();
            this.model = (DynamicObject)parentView.getModel().getValue("model");
            this.cslScheme = (DynamicObject)parentView.getModel().getValue("cslscheme");
            this.scenario = (DynamicObject)parentView.getModel().getValue("scenario");
            this.year = (DynamicObject)parentView.getModel().getValue("year");
            this.period = (DynamicObject)parentView.getModel().getValue("period");
            this.mergeNumber2BaseId = this.selectOrgRanges(parentView);
            String selectedNodeId = parentView.getPageCache().get("nodeSelected");
            this.selectedNodeId = LongUtil.toLong((Object)selectedNodeId);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private Map<String, Long> selectOrgRanges(IFormView view) {
        HashMap<String, Long> mergeNumber2BaseId = new HashMap<String, Long>(16);
        String temp = view.getPageCache().get("delOrgMenberPerm");
        List delOrgMemberPerm = (List)ObjectSerialUtil.deSerializedBytes((String)temp);
        Set selectOrgRanges = ConvertUtil.convertObjsToLongArray((Collection)delOrgMemberPerm);
        DynamicObjectCollection selectOrgRangeDys = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,number,copyfrom", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectOrgRanges)});
        for (DynamicObject selectOrgRangeDy : selectOrgRangeDys) {
            long baseId = selectOrgRangeDy.getLong("copyfrom");
            if (baseId == 0L) {
                baseId = selectOrgRangeDy.getLong("id");
            }
            String number = selectOrgRangeDy.getString("number");
            mergeNumber2BaseId.put(number, baseId);
        }
        return mergeNumber2BaseId;
    }

    private void logSuccess(List<ImportBillData> importBillDataList, ImportLogger logger, Set<DynamicObject> needUpdateData, Set<DynamicObject> needNewSaveData) {
        String f7Msg = String.format(ResManager.loadKDString((String)"%1$s\u4f53\u7cfb%2$s\u60c5\u666f%3$s\u8d22\u5e74%4$s\u671f\u95f4%5$s\u5408\u5e76\u8282\u70b9 ", (String)"InvRelationSearchImportNewPlugin_24", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), this.model.getString("shownumber"), this.scenario.getString("number"), this.year.getString("number"), this.period.getString("number"), MemberReader.findEntityMemberById((Long)this.model.getLong("id"), (Long)LongUtil.toLong((Object)this.selectedNodeId)).getLongNumber());
        this.writeOperationLog(f7Msg, importBillDataList.size() + logger.getTotal(), needNewSaveData.size() + needUpdateData.size());
    }

    public void writeOperationLog(String f7Msg, int total, int success) {
        String opName = ResManager.loadKDString((String)"\u5bfc\u5165", (String)"InvRelationSearchImportNewPlugin_16", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        String desc = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u9759\u6001\u80a1\u6bd4\u6210\u529f%1$s\uff0c\u5931\u8d25%2$s\u3002", (String)"InvRelationSearchImportNewPlugin_17", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), success, total - success);
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((String)opName, (String)(f7Msg + desc), this.model == null ? null : (Long)this.model.getPkValue(), (String)"bcm_invrelation_search");
        logService.addLog(logInfo);
    }

    private static /* synthetic */ Integer lambda$null$12(int seq, String k, Integer v) {
        return Math.max(v, seq);
    }
}

