/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Button;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.business.invest.InvSheetTemplateService;
import kd.fi.bcm.business.invest.api.helper.InvRelationSearchHelper;
import kd.fi.bcm.business.permission.permclass.PermClassCache;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.constant.invest.sharerela.InvStaticStockRatioConstant;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;

public class InvRltEffectTempPlugin
extends AbstractBaseListPlugin {
    public static final String BCM_INV_RLT_EFFECT_TEMP = "bcm_invrlt_effect_temp";
    public static final String ENTITY_TEMP = "entity_temp";
    public static final String ENTITY_TEMP_NEW = "entity_tempnew";
    public static final String TEMP_SHEET = "tempsheet";
    public static final String SELECTED_TEMP = "selectedTemp";
    public static final String SELECTED_TEMP_NEW = "selectedTempNew";
    private static final String IS_EXCEPT_NEW = "isexceptnew";
    private static final String TEMP_NEW = "tempnew";
    private static final String IS_EXCEPT = "isexcept";
    private static final String TEMP = "temp";
    private static final String BTN_OK = "btnok";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_OK);
        Long modelId = (Long)this.getFormCustomParam("model");
        BasedataEdit entityTemp = (BasedataEdit)this.getControl(TEMP);
        entityTemp.addBeforeF7SelectListener(evt -> {
            String relationType = (String)this.getFormCustomParam("bcm_invrelatype");
            String relationTypeCategorized = (String)this.getFormCustomParam("categorized");
            List noPerms = new ArrayList(16);
            boolean adminUserBol = MemberPermHelper.isModelManager((Long)modelId);
            if (!adminUserBol) {
                String entityName = "bcm_invtemplatecatalog";
                PermClassCache.cacheNewPermission((IPageCache)this.getPageCache(), (String)entityName, (String)String.valueOf(modelId));
                noPerms = PermClassCache.getPermissionMap((IPageCache)this.getPageCache(), (String)entityName, (DataTypeEnum)DataTypeEnum.NO);
            }
            QFilter qFilter = new QFilter("model", "=", (Object)modelId).and("billstatus", "=", (Object)"C").and("templatecatalog", "not in", noPerms).and("invrelatypebase.number", "=", (Object)relationType).and("invrelatypebase.categorized", "=", (Object)relationTypeCategorized);
            evt.addCustomQFilter(qFilter);
        });
        BasedataEdit entityTempNew = (BasedataEdit)this.getControl(TEMP_NEW);
        entityTempNew.addBeforeF7SelectListener(evt -> {
            Long year = (Long)this.getFormCustomParam("year");
            Long period = (Long)this.getFormCustomParam("period");
            String relationType = (String)this.getFormCustomParam("bcm_invrelatype");
            String relationTypeCategorized = (String)this.getFormCustomParam("categorized");
            DynamicObjectCollection sheetTemp = InvSheetTemplateService.querySheetTemp((Long)modelId, (Long)year, (Long)period, (String)relationType, (String)relationTypeCategorized);
            List sheetIds = sheetTemp.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
            FormShowParameter param = evt.getFormShowParameter();
            param.setCustomParam("sheettemplate", (Object)sheetTemp);
            QFilter customQFilter = new QFilter("sheettemplate", "in", sheetIds).and("relationtype.categorized", "=", (Object)relationTypeCategorized).and("relationtype.number", "=", (Object)relationType);
            evt.addCustomQFilter(customQFilter);
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initIsExceptCombo();
        this.showSelectedTemp();
    }

    @Override
    public void click(EventObject evt) {
        Button btn;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Button && BTN_OK.equals((btn = (Button)source).getKey())) {
            DynamicObjectCollection effectTemp = this.getModel().getEntryEntity(ENTITY_TEMP);
            DynamicObjectCollection effectTempNew = this.getModel().getEntryEntity(ENTITY_TEMP_NEW);
            List<String> checkTempRs = this.checkTempConfig(effectTemp);
            List<String> checkTempNewRs = this.checkTempNewConfig(effectTempNew);
            checkTempRs.addAll(checkTempNewRs);
            if (!checkTempRs.isEmpty()) {
                this.showTip(checkTempRs);
                return;
            }
            DynamicObjectCollection dynamicObjects = this.entityTempNewDys(effectTempNew);
            HashMap<String, DynamicObjectCollection> data = new HashMap<String, DynamicObjectCollection>(2);
            data.put(ENTITY_TEMP, effectTemp);
            data.put(ENTITY_TEMP_NEW, dynamicObjects);
            this.getView().returnDataToParent(data);
            this.getView().close();
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (TEMP_NEW.equals(e.getProperty().getName())) {
            ChangeData changeData = e.getChangeSet()[0];
            int rowIndex = changeData.getRowIndex();
            DynamicObject newValue = (DynamicObject)changeData.getNewValue();
            Object sheet = newValue == null ? null : newValue.get("sheettemplate");
            this.getModel().setValue(TEMP_SHEET, sheet, rowIndex);
        }
    }

    private DynamicObjectCollection entityTempNewDys(DynamicObjectCollection effectTempNew) {
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        DynamicObject invRelation = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_invrelation"));
        DynamicObjectType effectTempType = invRelation.getDynamicObjectCollection("effecttemp").getDynamicObjectType();
        for (DynamicObject dynamicObject : effectTempNew) {
            DynamicObject dynamicObject1 = new DynamicObject(effectTempType);
            dynamicObject1.set(TEMP, dynamicObject.get(TEMP_NEW));
            dynamicObject1.set(IS_EXCEPT, dynamicObject.get(IS_EXCEPT_NEW));
            dynamicObjects.add((Object)dynamicObject1);
        }
        return dynamicObjects;
    }

    private void initIsExceptCombo() {
        InvStaticStockRatioConstant.ExceptEnum[] values = InvStaticStockRatioConstant.ExceptEnum.values();
        LinkedList<ComboItem> comboItems = new LinkedList<ComboItem>();
        for (InvStaticStockRatioConstant.ExceptEnum value : values) {
            comboItems.add(new ComboItem(new LocaleString(value.getName()), value.getCode()));
        }
        ComboEdit isExceptNew = (ComboEdit)this.getControl(IS_EXCEPT_NEW);
        isExceptNew.setComboItems(comboItems);
        ComboEdit isExcept = (ComboEdit)this.getControl(IS_EXCEPT);
        isExcept.setComboItems(comboItems);
    }

    private void showSelectedTemp() {
        String tmpConfig = (String)this.getFormCustomParam(SELECTED_TEMP);
        Table table = InvRelationSearchHelper.analysisEachRow((String)tmpConfig);
        InvRelationSearchHelper.loadTemp((Table)table, (String)"bcm_invelimtemplatebase", () -> this.getModel().deleteEntryData(ENTITY_TEMP), (i, dynamicObject, isExcept) -> {
            this.getModel().createNewEntryRow(ENTITY_TEMP);
            DynamicObject rowDy = this.getModel().getEntryRowEntity(ENTITY_TEMP, i.intValue());
            rowDy.set(TEMP, dynamicObject);
            rowDy.set(IS_EXCEPT, isExcept);
        });
        String tmpNewConfig = (String)this.getFormCustomParam(SELECTED_TEMP_NEW);
        Table tableNew = InvRelationSearchHelper.analysisEachRow((String)tmpNewConfig);
        InvRelationSearchHelper.loadTemp((Table)tableNew, (String)"bcm_invsheetttplentrys", () -> this.getModel().deleteEntryData(ENTITY_TEMP_NEW), (i, dynamicObject, isExcept) -> {
            this.getModel().createNewEntryRow(ENTITY_TEMP_NEW);
            DynamicObject rowDy = this.getModel().getEntryRowEntity(ENTITY_TEMP_NEW, i.intValue());
            rowDy.set(TEMP_NEW, dynamicObject);
            rowDy.set(IS_EXCEPT_NEW, isExcept);
            rowDy.set(TEMP_SHEET, dynamicObject.get("sheettemplate"));
        });
    }

    private List<String> checkTempConfig(DynamicObjectCollection effectTemp) {
        LinkedList<String> rs = new LinkedList<String>();
        HashMultimap map = HashMultimap.create();
        for (int i = 0; i < effectTemp.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)effectTemp.get(i);
            DynamicObject tempDy = dynamicObject.getDynamicObject(TEMP);
            String isExcept = dynamicObject.getString(IS_EXCEPT);
            if (tempDy == null && isExcept == null) continue;
            if (tempDy == null) {
                rs.add(String.format(ResManager.loadKDString((String)"\u6743\u76ca\u6a21\u677f\u7b2c%1$s\u884c\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvRltEffectTempPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i + 1));
                continue;
            }
            if (isExcept == null) {
                rs.add(String.format(ResManager.loadKDString((String)"\u6743\u76ca\u6a21\u677f\u7b2c%1$s\u884c\u662f\u5426\u9002\u7528\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvRltEffectTempPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i + 1));
                continue;
            }
            map.put((Object)(tempDy.getString("id") + isExcept), (Object)(i + 1));
        }
        List collect = map.keySet().stream().map(arg_0 -> ((Multimap)map).get(arg_0)).filter(rows -> rows.size() > 1).map(rows -> String.format(ResManager.loadKDString((String)"\u6743\u76ca\u6a21\u677f\u7b2c%1$s\u884c\u914d\u7f6e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvRltEffectTempPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), rows)).collect(Collectors.toList());
        rs.addAll(collect);
        return rs;
    }

    private List<String> checkTempNewConfig(DynamicObjectCollection effectTemp) {
        LinkedList<String> rs = new LinkedList<String>();
        HashMultimap map = HashMultimap.create();
        for (int i = 0; i < effectTemp.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)effectTemp.get(i);
            DynamicObject tempDy = dynamicObject.getDynamicObject(TEMP_NEW);
            String isExcept = dynamicObject.getString(IS_EXCEPT_NEW);
            if (tempDy == null && isExcept == null) continue;
            if (tempDy == null) {
                rs.add(String.format(ResManager.loadKDString((String)"\u6743\u76ca\u5e95\u7a3f\u6a21\u677f\u7b2c%1$s\u884c\u5206\u5f55\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvRltEffectTempPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i + 1));
                continue;
            }
            if (isExcept == null) {
                rs.add(String.format(ResManager.loadKDString((String)"\u6743\u76ca\u5e95\u7a3f\u6a21\u677f\u7b2c%1$s\u884c\u662f\u5426\u9002\u7528\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvRltEffectTempPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i + 1));
                continue;
            }
            map.put((Object)(tempDy.getString("id") + isExcept), (Object)(i + 1));
        }
        List collect = map.keySet().stream().map(arg_0 -> ((Multimap)map).get(arg_0)).filter(rows -> rows.size() > 1).map(rows -> String.format(ResManager.loadKDString((String)"\u6743\u76ca\u5e95\u7a3f\u6a21\u677f\u7b2c%1$s\u884c\u914d\u7f6e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvRltEffectTempPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), rows)).collect(Collectors.toList());
        rs.addAll(collect);
        return rs;
    }

    private void showTip(List<String> checkRs) {
        if (checkRs.size() == 1) {
            throw new KDBizException(checkRs.get(0));
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u6821\u9a8c\u4e0d\u901a\u8fc7\u3002", (String)"InvRltEffectTempPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\n", checkRs), MessageBoxOptions.None, ConfirmTypes.Default, null);
    }
}

