/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.invest.model.InvShareCase;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class InvShareCasePlugin
extends AbstractBaseFormPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getControl("permclass")), (Object)this.getModelId());
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel dataModel = this.getModel();
        if (this.isAddNewStatus()) {
            long modelId = (Long)this.getView().getParentView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
            dataModel.setValue(this.getModelSign(), (Object)ConvertUtil.convertObjToLong((Object)modelId));
        }
        this.changePermClassStatus();
        PermClassEntityHelper.loadPermClass((IDataModel)dataModel, (Object)this.getModelId(), (boolean)false);
        dataModel.setDataChanged(false);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("scope".equals(name)) {
            this.changePermClassStatus();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        Object source = e.getSource();
        if (source instanceof Save) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            PermClassEntityHelper.savePermClass((DynamicObject)dataEntity, (Long)dataEntity.getLong("model.id"));
        }
    }

    private void changePermClassStatus() {
        Object scope = this.getModel().getValue("scope");
        boolean isPermClass = InvShareCase.ScopeEnum.PERM_CLASS.getValue().equals(scope);
        this.getView().setVisible(Boolean.valueOf(isPermClass), new String[]{"permclass"});
    }
}

