/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.MemberServiceHelper;
import kd.fi.bcm.business.invest.AccountCacheService;
import kd.fi.bcm.business.invest.AccountTabInfo;
import kd.fi.bcm.business.invest.AccountTabManager;
import kd.fi.bcm.business.invest.AccountTabModel;
import kd.fi.bcm.business.invest.InvChangeModel;
import kd.fi.bcm.business.invest.InvShareRelaModel;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.changecase.InvChangeTypeServiceHelper;
import kd.fi.bcm.business.invest.shareholder.InvShareRelaService;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.ReportServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.BusinessTypeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.tab.TabUtil;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.InvestUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.database.LTreeRListEdit;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import org.apache.commons.collections4.SetUtils;
import org.jetbrains.annotations.NotNull;

public class InvShareChangePlugin
extends AbstractBaseListPlugin {
    private static final String PCMAXKEY = "pcmaxkey";
    private static final String ACCOUNT_TAB = "accounttabap";
    private static final String CHANGEDATA = "changedatasave";
    private static final String TABINIT = "tabinitstate";
    private static final String CHANGE_TYPE = "changetype";
    private static final List<String> dimKeys = Lists.newArrayList((Object[])new String[]{"changetype"});
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String MODEL = "model";
    private static final String NUMBER = "number";
    private static final String AMOUNT = "amount";
    private static final String CHANGE_AMOUNT = "changeamount";
    private static final String SHARE_HOLDER_ID = "shareholderid";
    private static final String SHARE_HOLDER = "shareholder";
    private static final String HOLDEREC = "holderec";
    private static final String ORG_ENTRY_ENTITY = "orgentryentity";
    private static final String CHANGE_ENTRY_ENTITY = "changeentryentity";
    private static final String CHANGE_DATE = "changedate";
    private static boolean invUnique = true;
    private static boolean changeUnique = false;
    private AccountCacheService cacheService;
    private AccountTabManager manager;
    private AccountTabModel currTabModel;
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(InvShareChangePlugin.class);

    private String getOperationStstusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25\u3002", (String)"InvShareChangePlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f\u3002", (String)"InvShareChangePlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private String getOperationSave() {
        return ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"InvShareChangePlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.cacheService = new AccountCacheService(this.getPageCache());
        HashMap map = new HashMap();
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.getView().addCustomControls(new String[]{SHARE_HOLDER_ID});
        this.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("advcontoolbarap1");
        BasedataEdit shareholderidEdit = (BasedataEdit)this.getView().getControl(SHARE_HOLDER_ID);
        shareholderidEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit holderecEdit = (BasedataEdit)this.getView().getControl(HOLDEREC);
        holderecEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit shareholderEdit = (BasedataEdit)this.getView().getControl(SHARE_HOLDER);
        shareholderEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit changetypeEdit = (BasedataEdit)this.getView().getControl(CHANGE_TYPE);
        changetypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit cvt1currenyEdit = (BasedataEdit)this.getView().getControl("cvt1currenyid");
        cvt1currenyEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit cvt2currenyEdit = (BasedataEdit)this.getView().getControl("cvt2currenyid");
        cvt2currenyEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit cvt3currenyEdit = (BasedataEdit)this.getView().getControl("cvt3currenyid");
        cvt3currenyEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit cvt4currenyEdit = (BasedataEdit)this.getView().getControl("cvt4currenyid");
        cvt4currenyEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit cvt5currenyEdit = (BasedataEdit)this.getView().getControl("cvt5currenyid");
        cvt5currenyEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Tab reporttab = (Tab)this.getControl(ACCOUNT_TAB);
        reporttab.addTabSelectListener(this::accountTabSelected);
        BasedataEdit invchangetype = (BasedataEdit)this.getView().getControl("invchangetype1");
        invchangetype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        if (e.getKey().equals(SHARE_HOLDER_ID)) {
            LTreeRListEdit bsEdit = new LTreeRListEdit();
            bsEdit.setF7title(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9", (String)"InvShareChangePlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            bsEdit.setModelId(this.getModelId());
            bsEdit.setEntity("bcm_icmembertree");
            bsEdit.setF7Name(SHARE_HOLDER_ID);
            bsEdit.setKey(SHARE_HOLDER_ID);
            bsEdit.setModel(this.getModel());
            bsEdit.setView(this.getView());
            bsEdit.setEntryKey(ORG_ENTRY_ENTITY);
            bsEdit.setDisplayProp(NUMBER);
            bsEdit.setFieldKey(SHARE_HOLDER_ID);
            bsEdit.setEditSearchProp(NUMBER);
            bsEdit.setQFilter(new QFilter(MODEL, "=", (Object)this.getModelId()));
            bsEdit.getQFilters().add(new QFilter("isleaf", "=", (Object)"1"));
            bsEdit.getQFilters().add(new QFilter(NUMBER, "!=", (Object)"ICNone"));
            HashMap<String, Object> number = new HashMap<String, Object>();
            number.put(NUMBER, this.getModel().getValue(NUMBER));
            bsEdit.setCustomData(number);
            e.setControl((Control)bsEdit);
        }
    }

    private void accountTabSelected(TabSelectEvent event) {
        this.manager = this.getAccountTabManager();
        if (this.manager.getTabs().isEmpty()) {
            return;
        }
        this.cacheInvChangeModels();
        this.updatePresentTabEffective(this.manager);
        this.manager.getCurrSelectReportTabInfo().setSelected(false);
        this.manager.searchTabInfo(event.getTabKey()).setSelected(true);
        this.getPageCache().put(PCMAXKEY, this.manager.getCurrSelectReportTabInfo().getEffectivePCkeys().size() + "");
        this.cacheService.cacheAccountTabManager(this.manager);
        this.setTabInitState(true);
        this.buildEntryGird();
        this.setCvtVisiable(true, 1);
        String initKey = this.getAccountTabManager().getCurrSelectReportTabInfo().getTabKey() + "isload";
        if (this.getPageCache().get(initKey) == null) {
            this.loadInvChangeEntryView(this.isAddNew());
            this.getView().updateView(CHANGE_ENTRY_ENTITY);
            this.cacheInvChangeModels();
            this.updatePresentTabEffective(this.manager);
            this.cacheService.cacheAccountTabManager(this.manager);
        }
        this.setCvtInfoVisiable();
        this.getPageCache().put(initKey, "1");
        this.setTabInitState(false);
    }

    private void updatePresentTabEffective(AccountTabManager manager) {
        AccountTabInfo currSelectReportTabInfo = manager.getCurrSelectReportTabInfo();
        if (currSelectReportTabInfo == null) {
            return;
        }
        DynamicObjectCollection doc = this.getModel().getEntryEntity(CHANGE_ENTRY_ENTITY);
        if (doc == null || doc.isEmpty()) {
            return;
        }
        currSelectReportTabInfo.clearEffivePCkey();
        if (doc.stream().anyMatch(e -> e.get("cvt2currenyid") != null)) {
            currSelectReportTabInfo.addEffivePCkey("2");
        }
        if (doc.stream().anyMatch(e -> e.get("cvt3currenyid") != null)) {
            currSelectReportTabInfo.addEffivePCkey("3");
        }
        if (doc.stream().anyMatch(e -> e.get("cvt4currenyid") != null)) {
            currSelectReportTabInfo.addEffivePCkey("4");
        }
        if (doc.stream().anyMatch(e -> e.get("cvt5currenyid") != null)) {
            currSelectReportTabInfo.addEffivePCkey("5");
        }
    }

    private void setCvtInfoVisiable() {
        AccountTabInfo currSelectReportTabInfo = this.manager.getCurrSelectReportTabInfo();
        if (currSelectReportTabInfo == null) {
            return;
        }
        this.setCvtVisiable(true, 1);
        for (int i = 2; i <= 5; ++i) {
            this.setCvtVisiable(currSelectReportTabInfo.getEffectivePCkeys().contains(i + ""), i);
        }
    }

    private void cacheInvChangeModels() {
        DynamicObjectCollection doc = this.getModel().getEntryEntity(CHANGE_ENTRY_ENTITY);
        if (doc.size() < 1) {
            AccountTabInfo tabinfo = this.getAccountTabManager().getCurrSelectReportTabInfo();
            if (tabinfo == null) {
                return;
            }
            this.currTabModel = this.cacheService.getAccontTabModel(tabinfo);
            this.currTabModel.getDyLists().clear();
            this.cacheService.cacheAccontTabModel(this.currTabModel);
            return;
        }
        DataEntityPropertyCollection properties = ((DynamicObject)doc.get(0)).getDynamicObjectType().getProperties();
        HashSet<String> props = new HashSet<String>();
        ArrayList<InvChangeModel> invChangeModels = new ArrayList<InvChangeModel>();
        for (IDataEntityProperty property : properties) {
            props.add(property.getName());
        }
        for (DynamicObject dy : doc) {
            InvChangeModel invChangeModel = new InvChangeModel("bcm_invchangeentry");
            for (String prop : props) {
                if (prop.equals(CHANGE_TYPE)) continue;
                if (prop.contains("_id")) {
                    invChangeModel.put(prop.split("_")[0], dy.get(prop));
                    continue;
                }
                invChangeModel.put(prop, dy.get(prop));
            }
            invChangeModel.put(MODEL, (Object)this.getModelId());
            if (this.getAccountTabManager().getCurrSelectReportTabInfo() != null) {
                invChangeModel.put("account", (Object)this.getAccountTabManager().getCurrSelectReportTabInfo().getAccountId());
            }
            invChangeModel.put("investeecompany", this.getModel().getValue("invorg"));
            invChangeModel.put("invcompanycurrency", this.getModel().getValue("invcompanycurrency"));
            invChangeModel.put(HOLDEREC, this.getModel().getValue("changeholderec"));
            invChangeModel.put("remark", (Object)dy.getString("invedchangeremark"));
            invChangeModels.add(invChangeModel);
        }
        if (this.getAccountTabManager().getCurrSelectReportTabInfo() != null) {
            this.currTabModel = this.cacheService.getAccontTabModel(this.getAccountTabManager().getCurrSelectReportTabInfo());
            this.currTabModel.getDyLists().clear();
            this.currTabModel.getDyLists().addAll(invChangeModels);
            this.cacheService.cacheAccontTabModel(this.currTabModel);
        }
    }

    public void initTabModel() {
        DynamicObjectCollection doc = InvestServiceHelper.queryInvChangeEntry((long)this.getInvOrgId());
        if (doc == null || doc.isEmpty()) {
            return;
        }
        DataEntityPropertyCollection properties = ((DynamicObject)doc.get(0)).getDynamicObjectType().getProperties();
        HashSet<String> props = new HashSet<String>();
        for (IDataEntityProperty property : properties) {
            props.add(property.getName());
        }
        for (AccountTabInfo accountTabInfo : this.manager.getTabs()) {
            ArrayList<InvChangeModel> invChangeModels = new ArrayList<InvChangeModel>();
            for (DynamicObject dy : doc) {
                if (accountTabInfo.getAccountId() != dy.getLong("account")) continue;
                InvChangeModel invChangeModel = new InvChangeModel("bcm_invchangeentry");
                for (String prop : props) {
                    if (prop.contains("_id")) {
                        invChangeModel.put(prop.split("_")[0], dy.get(prop));
                        continue;
                    }
                    invChangeModel.put(prop, dy.get(prop));
                }
                invChangeModel.put(MODEL, (Object)this.getModelId());
                if (this.getAccountTabManager().getCurrSelectReportTabInfo() != null) {
                    invChangeModel.put("account", (Object)this.getAccountTabManager().getCurrSelectReportTabInfo().getAccountId());
                }
                invChangeModel.put("investeecompany", this.getModel().getValue("invorg"));
                invChangeModel.put("invcompanycurrency", this.getModel().getValue("invcompanycurrency"));
                invChangeModel.put(HOLDEREC, this.getModel().getValue(HOLDEREC));
                invChangeModel.put("remark", (Object)dy.getString("remark"));
                invChangeModels.add(invChangeModel);
            }
            if (this.getAccountTabManager().getTabs().isEmpty()) continue;
            AccountTabModel tabModel = this.cacheService.getAccontTabModel(accountTabInfo);
            tabModel.getDyLists().clear();
            tabModel.getDyLists().addAll(invChangeModels);
            this.cacheService.cacheAccontTabModel(tabModel);
        }
    }

    private List<InvShareRelaModel> getInvShareModels() {
        DynamicObjectCollection doc = this.getModel().getEntryEntity(ORG_ENTRY_ENTITY);
        if (doc.size() < 1) {
            return null;
        }
        ArrayList<InvShareRelaModel> relaModels = new ArrayList<InvShareRelaModel>();
        DataEntityPropertyCollection properties = ((DynamicObject)doc.get(0)).getDynamicObjectType().getProperties();
        HashSet<String> props = new HashSet<String>();
        for (IDataEntityProperty property : properties) {
            props.add(property.getName());
        }
        long shareCase = (Long)this.getFormCustomParam("sharecase");
        for (DynamicObject dy : doc) {
            if (dy.get(SHARE_HOLDER_ID) == null) continue;
            InvShareRelaModel relaModel = new InvShareRelaModel("bcm_invsharerela");
            for (String prop : props) {
                if (prop.contains("_id")) {
                    relaModel.put(prop.split("_")[0], dy.get(prop));
                    continue;
                }
                relaModel.put(prop, dy.get(prop));
            }
            relaModel.put(MODEL, (Object)this.getModelId());
            relaModel.put("id", (Object)GlobalIdUtil.genGlobalLongId());
            relaModel.put("invchangetype", dy.get("invchangetype1"));
            relaModel.put("investeecompany", this.getModel().getValue("invorg"));
            relaModel.put("invcompanycurrency", this.getModel().getValue("invcompanycurrency"));
            relaModel.put(SHARE_HOLDER_ID, (Object)((DynamicObject)dy.get(SHARE_HOLDER_ID)).getLong("id"));
            relaModel.put(SHARE_HOLDER, (Object)dy.getLong("shareholderid.id"));
            relaModel.put("sharecase", (Object)shareCase);
            relaModels.add(relaModel);
        }
        return relaModels;
    }

    private void buildEntryGird() {
        AccountTabModel tabModel = this.cacheService.getAccontTabModel(this.manager.getCurrSelectReportTabInfo());
        List invChangeModels = tabModel.getDyLists();
        this.getModel().deleteEntryData(CHANGE_ENTRY_ENTITY);
        if (invChangeModels.size() < 1) {
            return;
        }
        int[] rows = this.getModel().batchCreateNewEntryRow(CHANGE_ENTRY_ENTITY, invChangeModels.size());
        this.cacheService.cacheAccountTabManager(this.manager);
        Set props = ((InvChangeModel)invChangeModels.get(0)).keySet();
        for (int row : rows) {
            for (String prop : props) {
                if (prop.equals("id") || prop.equals("seq") || prop.equals("dataentitynumber") || prop.equals(MODEL) || prop.equals("account") || prop.equals("investeecompany") || prop.equals(HOLDEREC)) continue;
                if (prop.equals("remark")) {
                    this.getModel().setValue("invedchangeremark", ((InvChangeModel)invChangeModels.get(row)).get(prop), row);
                    continue;
                }
                if (!prop.contains("_id")) {
                    if (((InvChangeModel)invChangeModels.get(row)).get(prop) instanceof DynamicObject) {
                        long id = 0L;
                        if (invChangeModels.get(row) != null) {
                            id = ((DynamicObject)((InvChangeModel)invChangeModels.get(row)).get(prop)).getLong("id");
                        }
                        this.getModel().setValue(prop, (Object)id, row);
                        continue;
                    }
                    this.getModel().setValue(prop, ((InvChangeModel)invChangeModels.get(row)).get(prop), row);
                    continue;
                }
                this.getModel().setValue(prop.split("_")[0], ((InvChangeModel)invChangeModels.get(row)).get(prop.split("_")[0]), row);
            }
        }
        this.getView().updateView(CHANGE_ENTRY_ENTITY);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("addcol".equals(key)) {
            int pcKeyNum = this.getAccountTabManager().getCurrSelectReportTabInfo().getEffectivePCkeys().size();
            if (pcKeyNum >= 5) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b0\u589e\u6298\u7b97\u5e01\u6570\u91cf\u5df2\u8fbe\u4e0a\u9650\u3002", (String)"InvShareChangePlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put(PCMAXKEY, pcKeyNum + "");
            List<String> securableCvtCurrencys = Arrays.asList("2", "3", "4", "5");
            String index = "1";
            for (String securableCvtCurrency : securableCvtCurrencys) {
                if (this.manager.getCurrSelectReportTabInfo().getEffectivePCkeys().contains(securableCvtCurrency)) continue;
                index = securableCvtCurrency;
                break;
            }
            this.manager.getCurrSelectReportTabInfo().addEffivePCkey(index);
            this.cacheService.cacheAccountTabManager(this.manager);
            this.setCvtVisiable(true, Integer.parseInt(index));
            this.getView().updateView(CHANGE_ENTRY_ENTITY);
        } else if ("bar_save".equals(key)) {
            Object number = this.getModel().getValue(NUMBER);
            Object name = this.getModel().getValue("name");
            try {
                this.save();
                this.loadInvShareRelaView(false);
                this.loadInvChangeEntryView(false);
                this.updatePresentTabEffective(this.getAccountTabManager());
                this.setCvtInfoVisiable();
                this.getView().updateView(ORG_ENTRY_ENTITY);
                this.getView().updateView(CHANGE_ENTRY_ENTITY);
                this.setDataChangeSave(true);
                this.writeOperationLog(this.getOperationSave(), number.toString(), name.toString(), this.getOperationStstusSuccess());
            }
            catch (Exception e) {
                this.writeOperationLog(this.getOperationSave(), number.toString(), name.toString(), this.getOperationStstusFail());
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private void save() {
        this.cacheInvChangeModels();
        this.cacheService.cacheAccountTabManager(this.getAccountTabManager());
        this.dataUniqueValidator();
        this.saveData();
        this.setDataChangeSave(true);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"InvShareChangePlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
    }

    private void dataUniqueValidator() {
        HashSet<String> set = new HashSet<String>();
        DynamicObjectCollection doc = this.getModel().getEntryEntity(ORG_ENTRY_ENTITY);
        BigDecimal sum = new BigDecimal(BigInteger.ZERO);
        for (DynamicObject object : doc) {
            if (object.get(SHARE_HOLDER_ID) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6295\u8d44\u5355\u4f4d\u6295\u8d44\u60c5\u51b5\u3002", (String)"InvShareChangePlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            sum = sum.add(object.getBigDecimal("sharescale"));
            invUnique = set.add(object.getLong("shareholderid.id") + object.getString("investdate"));
            if (!invUnique) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6295\u8d44\u5355\u4f4d\u6295\u8d44\u60c5\u51b5:\u6295\u8d44\u5355\u4f4d+\u88ab\u6295\u8d44\u5355\u4f4d+\u6295\u8d44\u65e5\u671f\u7ec4\u5408\u552f\u4e00\u3002", (String)"InvShareChangePlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (object.get("invchangetype1") == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u66f4\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"InvShareChangePlugin_26", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (object.getDate("investdate") == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6295\u8d44\u65e5\u671f\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"InvShareChangePlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (object.getDynamicObject(HOLDEREC) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5e01\u79cd\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"InvShareChangePlugin_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (object.getBigDecimal("sharescale") != null) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u671f\u672b\u6301\u80a1\u6bd4\u4f8b\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"InvShareChangePlugin_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        if (this.holderOrgLeafvalidator()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6295\u8d44\u5355\u4f4d\u5fc5\u987b\u4e3a\u72ec\u7acb\u6cd5\u4eba\u516c\u53f8\u3002", (String)"InvShareRelaImportPlugin_28", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        InvShareRelaService.groupCollectBeforeCheckControlAndSumShareScale(doc.stream().collect(Collectors.toList()), (shareholderConfigMap, calculateUtil) -> InvShareRelaService.buildControlSumAndShareScaleSumThenCheck((Map)shareholderConfigMap, (Pair)calculateUtil, controlSum -> {
            if (controlSum > 1) {
                String investDate = InvShareRelaService.getCheckingDate((Map)shareholderConfigMap);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u8be5\u671f\u95f4\u5b58\u5728\u591a\u4e2a\u63a7\u5236\u80a1\u4e1c\uff0c\u8bf7\u4fee\u6539\u4e3a\u4e00\u4e2a\u3002", (String)"InvShareChangePlugin_29", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), investDate));
            }
        }, shareScaleSum -> {
            if (new BigDecimal("100").compareTo((BigDecimal)shareScaleSum) < 0) {
                String investDate = InvShareRelaService.getCheckingDate((Map)shareholderConfigMap);
                String msg = String.format(ResManager.loadKDString((String)"%1$s\u5f53\u671f\u671f\u672b\u603b\u6301\u80a1\u6bd4\u4f8b\u4e0d\u80fd\u8d85\u8fc7100%%\u3002", (String)"InvShareChangePlugin_12", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), investDate);
                throw new KDBizException(msg);
            }
        }));
        StringJoiner msgJoiner = new StringJoiner("\u3001");
        String msg = ResManager.loadKDString((String)"\u6743\u76ca\u53d8\u52a8\u60c5\u51b5[%1$s]\uff1a%2$s\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"InvShareChangePlugin_22", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
        for (AccountTabInfo tabInfo : this.manager.getTabs()) {
            set.clear();
            AccountTabModel atmodel = this.cacheService.getAccontTabModel(tabInfo);
            for (InvChangeModel changeModel : atmodel.getDyLists()) {
                if (!this.mustInputValidator(changeModel, msgJoiner)) {
                    throw new KDBizException(String.format(msg, tabInfo.getTabName(), msgJoiner.toString()));
                }
                changeUnique = set.add(DateTimeUtils.defaultDateString((Date)((Date)changeModel.get(CHANGE_DATE))));
                if (changeUnique) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6743\u76ca\u53d8\u52a8\u60c5\u51b5:\u88ab\u6295\u8d44\u5355\u4f4d+\u6295\u8d44\u65e5\u671f\u7ec4\u5408\u552f\u4e00\u3002", (String)"InvShareChangePlugin_13", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
        this.checkAddDataDate(doc);
        this.checkNewestDataShareScale(doc);
        this.calculateChangeScale(doc);
    }

    private boolean mustInputValidator(InvChangeModel data, StringJoiner errMsg) {
        Object changeamount;
        Object changetype;
        boolean success = true;
        if (data.get(CHANGE_DATE) == null) {
            errMsg.add(ResManager.loadKDString((String)"\u53d8\u52a8\u65e5\u671f", (String)"InvShareChangePlugin_23", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            success = false;
        }
        if ((changetype = data.get(CHANGE_TYPE)) == null || 0L == (Long)changetype) {
            errMsg.add(ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578b", (String)"InvShareChangePlugin_24", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            success = false;
        }
        if ((changeamount = data.get(CHANGE_AMOUNT)) == null || BigDecimal.ZERO.compareTo((BigDecimal)changeamount) == 0) {
            errMsg.add(ResManager.loadKDString((String)"\u53d8\u52a8\u91d1\u989d", (String)"InvShareChangePlugin_25", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            success = false;
        }
        return success;
    }

    private void calculateChangeScale(DynamicObjectCollection doc) {
        Map<String, List<DynamicObject>> date2dysMap = doc.stream().sorted(Comparator.comparing(dynamicObject -> dynamicObject.getDate("investdate"))).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getString(SHARE_HOLDER_ID)));
        BigDecimal nowScale = null;
        BigDecimal curSharescale = new BigDecimal(0);
        for (Map.Entry<String, List<DynamicObject>> date : date2dysMap.entrySet()) {
            List<DynamicObject> dys = date.getValue();
            nowScale = new BigDecimal(0);
            for (int i = 0; i < dys.size(); ++i) {
                curSharescale = dys.get(i).getBigDecimal("sharescale");
                dys.get(i).set("changescale", (Object)curSharescale.subtract(nowScale));
                nowScale = curSharescale;
            }
        }
    }

    private void checkNewestDataShareScale(DynamicObjectCollection doc) {
        Map collect = doc.stream().collect(Collectors.toMap(dy -> dy.getLong("shareholderid.id"), Function.identity(), (dy1, dy2) -> dy1.getDate("investdate").after(dy2.getDate("investdate")) ? dy1 : dy2));
        BigDecimal count = new BigDecimal("0");
        for (DynamicObject dy3 : collect.values()) {
            if ((count = count.add(dy3.getBigDecimal("sharescale"))).compareTo(new BigDecimal(100)) <= 0) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u540c\u7ec4\u7ec7\u7684\u6700\u65b0\u6301\u80a1\u6bd4\u4f8b\u4e4b\u548c\u4e0d\u80fd\u8d85\u8fc7100%\u3002", (String)"InvShareChangePlugin_14", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private void checkAddDataDate(DynamicObjectCollection doc) {
        DynamicObjectCollection oldDoc = InvestServiceHelper.queryInvShareRela((long)this.getInvOrgId());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HashMap oldDocInvUniqueSet2DyMap = new HashMap(16);
        oldDoc.forEach(dy -> oldDocInvUniqueSet2DyMap.put(dy.getLong(SHARE_HOLDER) + "|" + simpleDateFormat.format(dy.getDate("investdate")), dy));
        HashMap docInvUniqueSet2DyMap = new HashMap(16);
        doc.forEach(dy -> docInvUniqueSet2DyMap.put(dy.getLong("shareholderid.id") + "|" + simpleDateFormat.format(dy.getDate("investdate")), dy));
        Set docInvUniqueSet = docInvUniqueSet2DyMap.keySet();
        Set oldDocInvUniqueSet = oldDocInvUniqueSet2DyMap.keySet();
        Set oldDocIURemoveDelSet = SetUtils.intersection(docInvUniqueSet, oldDocInvUniqueSet).toSet();
        HashMap oldDocId2DateMap = new HashMap(16);
        oldDocIURemoveDelSet.forEach(oldDocIU -> {
            Long shareHolderId = Long.parseLong(oldDocIU.split("\\|")[0]);
            try {
                Date investDate = simpleDateFormat.parse(oldDocIU.split("\\|")[1]);
                if (oldDocId2DateMap.containsKey(shareHolderId)) {
                    oldDocId2DateMap.put(shareHolderId, ((Date)oldDocId2DateMap.get(shareHolderId)).after(investDate) ? (Date)oldDocId2DateMap.get(shareHolderId) : investDate);
                } else {
                    oldDocId2DateMap.put(shareHolderId, investDate);
                }
            }
            catch (ParseException e) {
                logger.error((Throwable)e);
            }
        });
        Set docIUAddSet = SetUtils.difference(docInvUniqueSet, oldDocInvUniqueSet).toSet();
        HashSet addDocDys = new HashSet(docIUAddSet.size());
        docIUAddSet.forEach(docIU -> addDocDys.add(docInvUniqueSet2DyMap.get(docIU)));
        for (DynamicObject docDy : addDocDys) {
            Date investDate = (Date)oldDocId2DateMap.get(docDy.getLong("shareholderid.id"));
            if (null == investDate || !investDate.after(docDy.getDate("investdate"))) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u53d8\u52a8,\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u8be5\u7ec4\u7ec7\u4e4b\u524d\u7684\u6700\u5927\u80a1\u6743\u53d8\u52a8\u65e5\u671f\u3002", (String)"InvShareChangePlugin_15", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), docDy.getString("shareholderid.number")));
        }
    }

    private boolean holderOrgLeafvalidator() {
        DynamicObjectCollection doc = this.getModel().getEntryEntity(ORG_ENTRY_ENTITY);
        if (doc.size() > 0) {
            HashSet numbers = Sets.newHashSet();
            for (DynamicObject object : doc) {
                numbers.add(object.getString("shareholderid.number"));
            }
            QFBuilder qfBuilder = new QFBuilder(MODEL, "=", (Object)this.getModelId());
            qfBuilder.add(NUMBER, "in", (Object)numbers);
            qfBuilder.add("storagetype", "=", (Object)StorageTypeEnum.STORAGE.index);
            qfBuilder.add("isindependentorg", "=", (Object)false);
            return QueryServiceHelper.exists((String)"bcm_entitymembertree", (QFilter[])qfBuilder.toArray());
        }
        return false;
    }

    private void saveData() {
        try (TXHandle tx = TX.required();){
            try {
                QFBuilder qfBuilder = new QFBuilder("investeecompany", "=", (Object)this.getInvOrgId());
                DeleteServiceHelper.delete((String)"bcm_invchangeentry", (QFilter[])qfBuilder.toArray());
                qfBuilder.and("sharecase", "=", this.getFormCustomParam("sharecase"));
                DeleteServiceHelper.delete((String)"bcm_invsharerela", (QFilter[])qfBuilder.toArray());
                this.saveChangeEntryEntity();
                this.saveOrgEntryEntity();
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ORG_ENTRY_ENTITY);
                InvestUtils.updateInvChangeStatus((long)this.getModelId(), (DynamicObject[])((DynamicObject[])entryEntity.toArray((Object[])new DynamicObject[entryEntity.size()])));
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private void saveChangeEntryEntity() {
        ArrayList<DynamicObject> ls = new ArrayList<DynamicObject>();
        for (AccountTabInfo tabInfo : this.manager.getTabs()) {
            AccountTabModel atmodel = this.cacheService.getAccontTabModel(tabInfo);
            ls.addAll(this.buildDynamicObject(atmodel.getDyLists()));
        }
        SaveServiceHelper.save((DynamicObject[])ls.toArray(new DynamicObject[0]));
    }

    private void saveOrgEntryEntity() {
        ArrayList<DynamicObject> ls = new ArrayList<DynamicObject>();
        List<InvShareRelaModel> relaModels = this.getInvShareModels();
        boolean addNew = this.isAddNew();
        String userId = RequestContext.getOrCreate().getUserId();
        Date now = TimeServiceHelper.now();
        if (relaModels != null) {
            for (InvShareRelaModel model : relaModels) {
                DynamicObject dy = model.genDynamicObject();
                if (addNew) {
                    dy.set("creatorid", (Object)userId);
                    dy.set("createtime", (Object)now);
                }
                dy.set("modifierid", (Object)userId);
                dy.set("modifytime", (Object)now);
                ls.add(dy);
            }
        }
        SaveServiceHelper.save((DynamicObject[])ls.toArray(new DynamicObject[0]));
    }

    private boolean isAddNew() {
        return OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus());
    }

    private List<DynamicObject> buildDynamicObject(List<InvChangeModel> invChangeModels) {
        ArrayList<DynamicObject> ls = new ArrayList<DynamicObject>(10);
        for (InvChangeModel model : invChangeModels) {
            if (model.get(CHANGE_AMOUNT) == null || ((BigDecimal)model.get(CHANGE_AMOUNT)).compareTo(BigDecimal.ZERO) == 0 || model.get(CHANGE_DATE) == null || this.isExistChangeTypeDimension() && (model.get(CHANGE_TYPE) == null || (Long)model.get(CHANGE_TYPE) == 0L)) continue;
            DynamicObject dy = model.genDynamicObject();
            for (int i = 1; i < 6; ++i) {
                Object curCvt = dy.get("cvt" + i + "currenyid");
                if ((!(curCvt instanceof Long) || (Long)curCvt != 0L) && (curCvt instanceof Long || curCvt != null)) continue;
                int j = i + 1;
                if (j < 6) {
                    Object nextCvt = dy.get("cvt" + j + "currenyid");
                    if ((!(nextCvt instanceof Long) || (Long)nextCvt == 0L) && (nextCvt instanceof Long || nextCvt == null)) continue;
                    dy.set("cvt" + i + "currenyid", nextCvt);
                    dy.set("rate" + i + "id", dy.get("rate" + j + "id"));
                    dy.set("change" + i + AMOUNT, dy.get("change" + j + AMOUNT));
                    dy.set("cvt" + j + "currenyid", null);
                    dy.set("rate" + j + "id", null);
                    dy.set("change" + j + AMOUNT, null);
                    continue;
                }
                dy.set("cvt" + i + "currenyid", null);
                dy.set("rate" + i + "id", null);
                dy.set("change" + i + AMOUNT, null);
            }
            ls.add(dy);
        }
        return ls;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        String f7Key = event.getProperty().getName();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("model.id", "=", (Object)this.getModelId()));
        switch (f7Key) {
            case "holderec": {
                this.getCurrecyF7Filter(qFilters, false);
                ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().setQFilters(qFilters);
                break;
            }
            case "cvt1currenyid": {
                this.getCurrecyF7Filter(qFilters, true);
                ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().setQFilters(qFilters);
                break;
            }
            case "cvt2currenyid": {
                this.getCurrecyF7Filter(qFilters, true);
                ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().setQFilters(qFilters);
                break;
            }
            case "cvt3currenyid": {
                this.getCurrecyF7Filter(qFilters, true);
                ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().setQFilters(qFilters);
                break;
            }
            case "cvt4currenyid": {
                this.getCurrecyF7Filter(qFilters, true);
                ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().setQFilters(qFilters);
                break;
            }
            case "cvt5currenyid": {
                this.getCurrecyF7Filter(qFilters, true);
                ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().setQFilters(qFilters);
                break;
            }
            case "invchangetype1": {
                QFilter qFilter = InvChangeTypeServiceHelper.invShareRelaF7ChangeTypeFilter((Object)this.getModelId());
                ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().setQFilters((List)Lists.newArrayList((Object[])new QFilter[]{qFilter}));
                break;
            }
            default: {
                if (CHANGE_TYPE.equals(f7Key)) break;
                qFilters.add(new QFilter("isleaf", "=", (Object)1));
                ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().setQFilters(qFilters);
            }
        }
    }

    private void getCurrecyF7Filter(List<QFilter> qFilters, boolean isPC) {
        qFilters.add(new QFilter("isleaf", "=", (Object)"1"));
        qFilters.add(new QFilter(NUMBER, "!=", (Object)"PC"));
        qFilters.add(new QFilter(NUMBER, "!=", (Object)"EC"));
        qFilters.add(new QFilter(NUMBER, "!=", (Object)"CNone"));
        if (isPC) {
            long invECCyId = ((DynamicObject)this.getModel().getValue("invcompanycurrency")).getLong("id");
            qFilters.add(new QFilter("id", "!=", (Object)invECCyId));
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject orgDy = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,number,name,currency.id,currency.number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getInvOrgId())});
        this.getModel().setValue("invorg", (Object)orgDy.getLong("id"));
        this.getModel().setValue(NUMBER, (Object)orgDy.getString(NUMBER));
        this.getModel().setValue("name", (Object)orgDy.getString("name"));
        this.getModel().setValue("invcompanycurrency", (Object)ReportServiceHelper.loadCurrencyMemberByDBCurrency((Object)orgDy.getLong("currency.id"), (Object)this.getModelId()).getLong("id"));
        this.getPageCache().put(PCMAXKEY, "1");
        this.initAccountTab();
        this.loadInvShareRelaView(this.isAddNew());
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_save", "addroworg", "deleteroworg", "addrowchange", "deleterowchange", "addcol"});
        }
        if (this.isAddNew()) {
            this.getModel().createNewEntryRow(ORG_ENTRY_ENTITY);
        }
    }

    private void initAccountTab() {
        boolean isExitAccount = QueryServiceHelper.exists((String)"bcm_invchangeacct", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)this.getModelId())});
        if (!isExitAccount) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
            return;
        }
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_invchangeacct", (String)"account.id,account.number,account.name", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)this.getModelId())});
        ArrayList<AccountTabInfo> ls = new ArrayList<AccountTabInfo>();
        this.manager = this.getAccountTabManager();
        for (DynamicObject dy : doc) {
            AccountTabInfo atabInfo = new AccountTabInfo(dy.getString("account.number"), dy.getLong("account.id"), dy.getString("account.name"));
            ls.add(atabInfo);
            this.manager.getTabs().add(atabInfo);
        }
        this.initTabModel();
        TabUtil.contructMultiTab(ls, (String)ACCOUNT_TAB, (IFormView)this.getView());
        Tab reporttab = (Tab)this.getControl(ACCOUNT_TAB);
        reporttab.activeTab(this.manager.getFirstAccountTabInfo().getTabKey().toLowerCase(Locale.ENGLISH));
        AccountTabInfo tabInfo = this.manager.getFirstAccountTabInfo();
        if (tabInfo != null) {
            tabInfo.setSelected(true);
        }
        this.cacheService.cacheAccountTabManager(this.manager);
    }

    private AccountTabManager getAccountTabManager() {
        if (this.manager == null) {
            if (this.cacheService != null) {
                this.manager = this.cacheService.getAccountTabManager();
            }
            if (this.manager == null) {
                this.manager = new AccountTabManager();
            }
        }
        return this.manager;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        String state = this.getPageCache().get(TABINIT);
        if (state != null) {
            return;
        }
        this.setDataChangeSave(false);
        this.getModel().setDataChanged(true);
        if ("iscontrol".equals(propertyName)) {
            int row = e.getChangeSet()[0].getRowIndex();
            if (e.getChangeSet()[0].getNewValue() == null) {
                this.getModel().setValue("iscontrol", e.getChangeSet()[0].getOldValue(), row);
            }
        } else if (propertyName.equals(SHARE_HOLDER_ID)) {
            String modelnum;
            IDNumberTreeNode icOrg;
            if (((EntryGrid)this.getView().getControl(ORG_ENTRY_ENTITY)).getSelectRows().length < 1) {
                return;
            }
            int selectRow = ((EntryGrid)this.getView().getControl(ORG_ENTRY_ENTITY)).getSelectRows()[0];
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add(new QFilter(MODEL, "=", (Object)this.getModelId()));
            DynamicObject dy = (DynamicObject)this.getModel().getValue(SHARE_HOLDER_ID, selectRow);
            if (dy == null) {
                return;
            }
            if (dy.getString(NUMBER).equals(this.getModel().getValue(NUMBER))) {
                this.getModel().beginInit();
                this.getModel().setValue(SHARE_HOLDER_ID, null, selectRow);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u88ab\u6295\u8d44\u5355\u4f4d\u3002", (String)"InvShareChangePlugin_16", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                this.getModel().endInit();
            }
            boolean isinnerorg = (icOrg = MemberReader.findEntityMemberByNum((String)(modelnum = MemberReader.findModelNumberById((Object)this.getModelId())), (String)dy.getString(NUMBER))) != IDNumberTreeNode.NotFoundTreeNode && (Boolean)icOrg.getProperty("isinnerorg") != false;
            this.getModel().beginInit();
            if (isinnerorg) {
                IDNumberTreeNode ec = MemberReader.findCurrencyMemberByNum((String)modelnum, (String)icOrg.getCurrency());
                this.getView().setEnable(Boolean.valueOf(false), selectRow, new String[]{HOLDEREC});
                this.getModel().setValue("isout", (Object)true, selectRow);
                this.getModel().setValue(HOLDEREC, (Object)ec.getId(), selectRow);
            } else {
                this.getModel().setValue("isout", (Object)false, selectRow);
                this.getView().setEnable(Boolean.valueOf(true), selectRow, new String[]{HOLDEREC});
            }
            this.getView().updateView("isout", selectRow);
            this.getView().updateView(HOLDEREC, selectRow);
            this.getModel().endInit();
        } else if (propertyName.equals(CHANGE_AMOUNT) || propertyName.contains("rate") || propertyName.startsWith("change") && propertyName.endsWith(AMOUNT)) {
            if (((EntryGrid)this.getView().getControl(CHANGE_ENTRY_ENTITY)).getSelectRows().length == 0) {
                return;
            }
            int selectRow = ((EntryGrid)this.getView().getControl(CHANGE_ENTRY_ENTITY)).getSelectRows()[0];
            if (this.getModel().getValue(propertyName, selectRow) == null || this.getModel().getValue(CHANGE_AMOUNT, selectRow) == null) {
                return;
            }
            BigDecimal changeamount = (BigDecimal)this.getModel().getValue(CHANGE_AMOUNT, selectRow);
            if (propertyName.contains("rate")) {
                char index = propertyName.charAt(4);
                BigDecimal rate = (BigDecimal)this.getModel().getValue(propertyName, selectRow);
                if (rate.compareTo(BigDecimal.ZERO) != 0 && changeamount.compareTo(BigDecimal.ZERO) != 0) {
                    this.getModel().beginInit();
                    this.getModel().setValue("change" + index + AMOUNT, (Object)this.calculateChangeAmount(changeamount, rate), selectRow);
                    this.getModel().endInit();
                    this.getView().updateView("change" + index + AMOUNT, selectRow);
                }
            } else if (propertyName.equals(CHANGE_AMOUNT)) {
                this.getModel().beginInit();
                for (int i = 1; i < 6; ++i) {
                    if (this.getModel().getValue("rate" + i + "id", selectRow) == null) continue;
                    BigDecimal rate = (BigDecimal)this.getModel().getValue("rate" + i + "id", selectRow);
                    this.getModel().setValue("change" + i + AMOUNT, (Object)this.calculateChangeAmount(changeamount, rate), selectRow);
                    this.getView().updateView("change" + i + AMOUNT, selectRow);
                }
                this.getModel().endInit();
            } else {
                BigDecimal changeXamount = (BigDecimal)this.getModel().getValue(propertyName, selectRow);
                char index = propertyName.charAt(6);
                if (changeamount.compareTo(BigDecimal.ZERO) != 0 && changeXamount.compareTo(BigDecimal.ZERO) != 0) {
                    this.getModel().beginInit();
                    this.getModel().setValue("rate" + index + "id", (Object)this.divideAmountOrRate(changeamount, changeXamount), selectRow);
                    this.getView().updateView("rate" + index + "id", selectRow);
                    this.getModel().endInit();
                }
            }
        } else if (propertyName.startsWith("cvt") && propertyName.endsWith("currenyid")) {
            if (((EntryGrid)this.getView().getControl(CHANGE_ENTRY_ENTITY)).getSelectRows().length < 1) {
                return;
            }
            HashSet pcs = Sets.newHashSet();
            boolean isNoRepeat = true;
            this.getModel().beginInit();
            DynamicObject dataEntity = e.getChangeSet()[0].getDataEntity();
            for (IDataEntityProperty property : dataEntity.getDynamicObjectType().getProperties()) {
                String name = property.getName();
                if (!name.startsWith("cvt") || !name.endsWith("currenyid") || dataEntity.get(name) == null) continue;
                isNoRepeat = isNoRepeat && pcs.add(dataEntity.getString(name + ".id"));
            }
            if (!isNoRepeat) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6743\u76ca\u79d1\u76ee\u7684\u540c\u4e00\u4e2a\u53d8\u52a8\u65e5\u671f\u6298\u7b97\u5e01\u4e0d\u5141\u8bb8\u76f8\u540c\u3002", (String)"InvShareChangePlugin_17", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                dataEntity.set(propertyName, null);
            }
            pcs.clear();
            this.getModel().endInit();
        }
    }

    @NotNull
    private BigDecimal divideAmountOrRate(BigDecimal changeAmount, BigDecimal changeXAmount) {
        return changeXAmount.divide(changeAmount, 6, RoundingMode.HALF_UP);
    }

    @NotNull
    private BigDecimal calculateChangeAmount(BigDecimal changeAmount, BigDecimal rate) {
        return changeAmount.multiply(rate);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((DefaultDynamicFormOperate)args.getSource()).getOperateKey();
        if ("deleteentry".equalsIgnoreCase(key)) {
            if (!this.checkCanDeleteOrgChangeEntryRow()) {
                args.setCancel(true);
            } else {
                this.setDataChangeSave(false);
            }
            return;
        }
        if ("tightchangedeleteentry".equalsIgnoreCase(key)) {
            this.setDataChangeSave(false);
            return;
        }
    }

    private boolean checkCanDeleteOrgChangeEntryRow() {
        long commonParentOrgId;
        if (((EntryGrid)this.getView().getControl(ORG_ENTRY_ENTITY)).getSelectRows().length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u3002", (String)"InvShareChangePlugin_18", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        int selectRow = ((EntryGrid)this.getView().getControl(ORG_ENTRY_ENTITY)).getSelectRows()[0];
        Object shareholderid = this.getModel().getValue(SHARE_HOLDER_ID, selectRow);
        Object invorgId = this.getModel().getValue("invorg");
        if (shareholderid != null && (commonParentOrgId = this.getCommonParentOrg(shareholderid, invorgId)) != 0L && this.isExitRptAdjustData(selectRow, commonParentOrgId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u6743\u76ca\u62b5\u9500\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u548c\u5220\u9664\u3002", (String)"InvShareChangePlugin_19", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private long getCommonParentOrg(Object shareholderid, Object invorgId) {
        String shareholderNumber = ((DynamicObject)shareholderid).getString(NUMBER);
        String invOrgNumber = ((DynamicObject)invorgId).getString(NUMBER);
        QFBuilder qfBuilder = new QFBuilder(MODEL, "=", (Object)this.getModelId());
        qfBuilder.add(NUMBER, "in", (Object)new String[]{shareholderNumber, invOrgNumber});
        qfBuilder.add("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"longnumber,parent.id", (QFilter[])qfBuilder.toArray());
        if (!doc.isEmpty() && doc.size() > 1) {
            String longnumber1 = ((DynamicObject)doc.get(0)).getString("longnumber");
            String longnumber2 = ((DynamicObject)doc.get(1)).getString("longnumber");
            String commonParentNumber = this.getNearestCommonNodeNumber(longnumber1, longnumber2);
            DynamicObject dy = MemberServiceHelper.queryOneBaseMember((String)"bcm_entitymembertree", (String)"id", (QFBuilder)new QFBuilder(MODEL, "=", (Object)this.getModelId()).add(NUMBER, "=", (Object)commonParentNumber));
            if (dy != null) {
                return dy.getLong("id");
            }
        }
        return 0L;
    }

    private String getNearestCommonNodeNumber(String longnumber1, String longnumber2) {
        String[] strs2;
        String splitStr = String.valueOf('!');
        String[] strs1 = longnumber1.split(splitStr);
        if (strs1.length > (strs2 = longnumber2.split(splitStr)).length) {
            for (int i = strs2.length - 2; i >= 0; --i) {
                for (int k = strs1.length - 2; k >= 0; --k) {
                    if (!strs2[i].equals(strs1[k])) continue;
                    return strs2[i];
                }
            }
        } else {
            for (int i = strs1.length - 2; i >= 0; --i) {
                for (int k = strs2.length - 2; k >= 0; --k) {
                    if (!strs1[i].equals(strs2[k])) continue;
                    return strs1[i];
                }
            }
        }
        return "";
    }

    private boolean isExitRptAdjustData(int selectRow, long parentId) {
        Object date = this.getModel().getValue("investdate", selectRow);
        boolean isExit = false;
        if (date != null) {
            int year = DateTimeUtils.getYear((Date)((Date)date));
            int month = DateTimeUtils.getMonth((Date)((Date)date));
            int day = DateTimeUtils.getDay((Date)((Date)date));
            QFBuilder qfBuilder = new QFBuilder(MODEL, "in", (Object)this.getModelId());
            qfBuilder.add("year.number", "=", (Object)("FY" + year));
            qfBuilder.add(new QFilter("period.effmonth", "<=", (Object)String.valueOf(month)).and("period.effday", "<=", (Object)String.valueOf(day)).and("period.expmonth", ">=", (Object)String.valueOf(month)).and("period.expday", ">=", (Object)String.valueOf(month)));
            qfBuilder.add("entity", "=", (Object)parentId);
            qfBuilder.add("bussnesstype", "=", (Object)BusinessTypeEnum.OFFSETEOE);
            isExit = QueryServiceHelper.exists((String)"bcm_rptadjust", (QFilter[])qfBuilder.toArray());
            return isExit;
        }
        return isExit;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String key = e.getCallBackId();
        if ("change_areacomfirm".equals(key) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            this.setDataChangeSave(true);
            this.getView().close();
        }
    }

    private void setCvtVisiable(boolean isNotNull1, int index) {
        this.getView().setVisible(Boolean.valueOf(isNotNull1), new String[]{"cvt" + index + "currenyid", "rate" + index + "id", "change" + index + AMOUNT});
    }

    private long getInvOrgId() {
        if (this.getFormCustomParam("investeecompany") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u88ab\u6295\u8d44\u516c\u53f8\u3002", (String)"InvShareChangePlugin_20", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        Long icId = Long.valueOf((String)this.getFormCustomParam("investeecompany"));
        DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"storagetype,member.id,copyfrom", (QFilter[])new QFBuilder("id", "=", (Object)icId).toArray());
        String storagetype = dy.getString("storagetype");
        long copyfrom = dy.getLong("copyfrom");
        if (StorageTypeEnum.isShare((String)storagetype)) {
            icId = copyfrom;
        }
        return icId;
    }

    private void loadInvShareRelaView(boolean isAddNew) {
        if (!isAddNew) {
            DynamicObjectCollection doc = InvestServiceHelper.queryInvShareRela((long)this.getInvOrgId(), (long)((Long)this.getFormCustomParam("sharecase")));
            if (doc == null || doc.isEmpty()) {
                return;
            }
            this.getModel().deleteEntryData(ORG_ENTRY_ENTITY);
            int[] rows = this.getModel().batchCreateNewEntryRow(ORG_ENTRY_ENTITY, doc.size());
            int i = 0;
            this.getModel().beginInit();
            for (int row : rows) {
                this.getModel().setValue(SHARE_HOLDER_ID, (Object)((DynamicObject)doc.get(i)).getLong(SHARE_HOLDER), row);
                this.getModel().setValue("isout", (Object)((DynamicObject)doc.get(i)).getBoolean("isout"), row);
                this.getModel().setValue("invchangetype1", ((DynamicObject)doc.get(i)).get("invchangetype"), row);
                this.getModel().setValue(HOLDEREC, (Object)((DynamicObject)doc.get(i)).getLong(HOLDEREC), row);
                this.getModel().setValue("investdate", (Object)((DynamicObject)doc.get(i)).getDate("investdate"), row);
                this.getModel().setValue("sharescale", (Object)((DynamicObject)doc.get(i)).getBigDecimal("sharescale"), row);
                this.getModel().setValue("changescale", (Object)((DynamicObject)doc.get(i)).getBigDecimal("changescale"), row);
                this.getModel().setValue("investamount", (Object)((DynamicObject)doc.get(i)).getBigDecimal("investamount"), row);
                this.getModel().setValue("iscontrol", (Object)((DynamicObject)doc.get(i)).getString("iscontrol"), row);
                this.getModel().setValue("remark", (Object)((DynamicObject)doc.get(i)).getString("remark"), row);
                ++i;
            }
            this.getModel().endInit();
        }
        if (ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM060")) {
            this.getView().setVisible(Boolean.valueOf(!ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"isRealTimeJudgOutRela")), new String[]{"isout"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"isout"});
        }
    }

    private void loadInvChangeEntryView(boolean isAddNew) {
        if (!isAddNew) {
            if (this.getAccountTabManager().getCurrSelectReportTabInfo() == null) {
                return;
            }
            DynamicObjectCollection doc = InvestServiceHelper.queryInvChangeEntry((long)this.getInvOrgId(), (long)this.getAccountTabManager().getCurrSelectReportTabInfo().getAccountId());
            this.getModel().deleteEntryData(CHANGE_ENTRY_ENTITY);
            if (doc == null || doc.isEmpty()) {
                return;
            }
            int[] rows = this.getModel().batchCreateNewEntryRow(CHANGE_ENTRY_ENTITY, doc.size());
            int i = 0;
            this.getModel().beginInit();
            for (int row : rows) {
                this.getModel().setValue(SHARE_HOLDER, (Object)((DynamicObject)doc.get(i)).getLong(SHARE_HOLDER), row);
                this.getModel().setValue("changeholderec", (Object)((DynamicObject)doc.get(i)).getLong(HOLDEREC), row);
                this.getModel().setValue(CHANGE_DATE, (Object)((DynamicObject)doc.get(i)).getDate(CHANGE_DATE), row);
                this.getModel().setValue(CHANGE_TYPE, (Object)((DynamicObject)doc.get(i)).getString(CHANGE_TYPE), row);
                this.getModel().setValue(CHANGE_AMOUNT, (Object)((DynamicObject)doc.get(i)).getBigDecimal(CHANGE_AMOUNT), row);
                this.getModel().setValue("invedchangeremark", (Object)((DynamicObject)doc.get(i)).getString("remark"), row);
                this.getModel().setValue("cvt1currenyid", (Object)((DynamicObject)doc.get(i)).getLong("cvt1currenyid"), row);
                this.getModel().setValue("rate1id", (Object)((DynamicObject)doc.get(i)).getBigDecimal("rate1id"), row);
                this.getModel().setValue("change1amount", (Object)((DynamicObject)doc.get(i)).getBigDecimal("change1amount"), row);
                this.getModel().setValue("cvt2currenyid", (Object)((DynamicObject)doc.get(i)).getLong("cvt2currenyid"), row);
                this.getModel().setValue("rate2id", (Object)((DynamicObject)doc.get(i)).getBigDecimal("rate2id"), row);
                this.getModel().setValue("change2amount", (Object)((DynamicObject)doc.get(i)).getBigDecimal("change2amount"), row);
                this.getModel().setValue("cvt3currenyid", (Object)((DynamicObject)doc.get(i)).getLong("cvt3currenyid"), row);
                this.getModel().setValue("rate3id", (Object)((DynamicObject)doc.get(i)).getBigDecimal("rate3id"), row);
                this.getModel().setValue("change3amount", (Object)((DynamicObject)doc.get(i)).getBigDecimal("change3amount"), row);
                this.getModel().setValue("cvt4currenyid", (Object)((DynamicObject)doc.get(i)).getLong("cvt4currenyid"), row);
                this.getModel().setValue("rate4id", (Object)((DynamicObject)doc.get(i)).getBigDecimal("rate4id"), row);
                this.getModel().setValue("change4amount", (Object)((DynamicObject)doc.get(i)).getBigDecimal("change4amount"), row);
                this.getModel().setValue("cvt5currenyid", (Object)((DynamicObject)doc.get(i)).getLong("cvt5currenyid"), row);
                this.getModel().setValue("rate5id", (Object)((DynamicObject)doc.get(i)).getBigDecimal("rate5id"), row);
                this.getModel().setValue("change5amount", (Object)((DynamicObject)doc.get(i)).getBigDecimal("change5amount"), row);
                ++i;
            }
            this.getModel().endInit();
        }
    }

    private void setDataChangeSave(boolean isSave) {
        if (isSave) {
            this.getPageCache().put(CHANGEDATA, null);
        } else {
            this.getPageCache().put(CHANGEDATA, "1");
        }
    }

    private void setTabInitState(boolean isStart) {
        String state = isStart ? "1" : null;
        this.getPageCache().put(TABINIT, state);
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getPageCache().get(CHANGEDATA) != null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6709\u672a\u4fdd\u5b58\u7684\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"InvShareChangePlugin_21", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("change_areacomfirm", (IFormPlugin)this));
            e.setCancel(true);
        }
    }
}

