/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportEntityMapping;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.invest.api.helper.InvShareRelaHelper;
import kd.fi.bcm.business.invest.shareholder.InvShareRelaService;
import kd.fi.bcm.business.permission.perm.PermCacheKey;
import kd.fi.bcm.business.permission.perm.PermPackageList;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.constant.invest.sharerela.InvShareRelaConstant;
import kd.fi.bcm.common.enums.OrgBizChangeTypeEnum;
import kd.fi.bcm.common.enums.PermEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.InvestUtils;
import kd.fi.bcm.common.util.KDAssert;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.BatchImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.impexport.BillResult;
import org.apache.commons.lang3.StringUtils;

public class InvShareRelaImportNewPlugin
extends BatchImportPlugin {
    private static Log log = LogFactory.getLog(InvShareRelaImportNewPlugin.class);
    private static final String NUMBER = "number";
    private static final String MODEL = "model";
    private static final String FI_BCM_FORM_PLUGIN = "fi-bcm-formplugin";
    private long modelId;
    private DynamicObject currentShareCaseDy;
    private Map<String, Object> option;
    private boolean isAdmin = false;
    private PermPackageList permPackageList;

    public void setOption(Map<String, Object> option) {
        this.option = option;
    }

    protected boolean isForceBatch() {
        return true;
    }

    protected int getBatchImportSize() {
        return 50000;
    }

    public void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
    }

    public ApiResult save(List<ImportBillData> importBillDataList, ImportLogger logger) {
        ApiResult result;
        if (logger.getFailed() != 0) {
            return this.failedBeforeSave(importBillDataList, logger);
        }
        this.intModelAndPermMap();
        try {
            Table<Long, String, EffectiveData> effectiveDataFromImport = this.getEffectiveData(importBillDataList, logger);
            KDAssert.assertTrue((logger.getFailed() == 0 ? 1 : 0) != 0, () -> new KDBizException(this.getFailMsg()));
            Map<Long, List<DynamicObject>> relationFromDB = this.selectRelationFromDB(effectiveDataFromImport);
            for (Long rowKey : effectiveDataFromImport.rowKeySet()) {
                relationFromDB.putIfAbsent(rowKey, Lists.newArrayList());
            }
            HashSet neverChangeId = Sets.newHashSet();
            HashSet overrideData = Sets.newHashSet();
            HashMap dataIndexMap = Maps.newHashMap();
            HashSet relationIds = Sets.newHashSet();
            ImportOperateType importType = BatchImportHelper.getImportOperateType(this.option, this.ctx);
            Set<DynamicObject> data = this.buildFinalShareRelations(effectiveDataFromImport, relationFromDB, neverChangeId, () -> new ShareRelationsUnitedUtilEntity(importBillDataList, logger, importType, overrideData, dataIndexMap, relationIds));
            KDAssert.assertTrue((logger.getFailed() == 0 ? 1 : 0) != 0, () -> new KDBizException(this.getFailMsg()));
            DynamicObject[] entryEntity = InvShareRelaHelper.doSave((Long)this.modelId, data);
            result = this.buildResult(effectiveDataFromImport, neverChangeId, entryEntity);
        }
        catch (KDBizException e) {
            log.error((Throwable)e);
            int lastFailRow = (Integer)logger.getLogCache().keySet().stream().max(Integer::compareTo).orElseThrow(() -> e);
            logger.log(Integer.valueOf(lastFailRow), e.getMessage()).setFailed(importBillDataList.size());
            result = new ApiResult();
            result.setSuccess(true);
            result.setData(Collections.emptyList());
        }
        return result;
    }

    private ApiResult failedBeforeSave(List<ImportBillData> importBillDataList, ImportLogger logger) {
        int lastFailRow = logger.getLogCache().keySet().stream().max(Integer::compareTo).orElseGet(() -> 5);
        logger.log(Integer.valueOf(lastFailRow), this.getFailMsg()).setFailed(importBillDataList.size() + logger.getFailed());
        ApiResult result = new ApiResult();
        result.setSuccess(true);
        result.setData(Collections.emptyList());
        return result;
    }

    private Map<Long, List<DynamicObject>> selectRelationFromDB(Table<Long, String, EffectiveData> effectiveDataFromImport) {
        Set allInvestedCompany = effectiveDataFromImport.rowKeySet();
        QFBuilder qfBuilder = InvShareRelaService.getIsolationQFilter((long)this.modelId, (long)this.currentShareCaseDy.getLong("id"));
        qfBuilder.and("investeecompany", "in", (Object)allInvestedCompany);
        String selectProperties = new StringJoiner(",").add(String.join((CharSequence)",", InvShareRelaConstant.uniqueCombo())).add(String.join((CharSequence)",", InvShareRelaConstant.otherUpdateField())).add("id").add("changescale").add("creatorid").add("createtime").toString();
        return Arrays.stream(InvShareRelaService.loadInvShareRela((String)selectProperties, (QFBuilder)qfBuilder)).collect(Collectors.groupingBy(dy -> dy.getDynamicObject("investeecompany").getLong("id")));
    }

    private Set<DynamicObject> buildFinalShareRelations(Table<Long, String, EffectiveData> effectiveDataFromImport, Map<Long, List<DynamicObject>> relationFromDB, Set<Long> neverChangeId, Supplier<ShareRelationsUnitedUtilEntity> createShareRelationsUnitedUtilEntity) {
        LinkedHashSet data = new LinkedHashSet(16);
        ShareRelationsUnitedUtilEntity shareRelationsUnitedUtilEntity = createShareRelationsUnitedUtilEntity.get();
        relationFromDB.forEach((rowKey, relations) -> {
            Map row = effectiveDataFromImport.row(rowKey);
            shareRelationsUnitedUtilEntity.setRow(row);
            shareRelationsUnitedUtilEntity.getOverrideData().clear();
            shareRelationsUnitedUtilEntity.getDataIndexMap().clear();
            shareRelationsUnitedUtilEntity.getRelationIds().clear();
            relations.forEach(dy -> this.doNewAddCheckOrOverride(shareRelationsUnitedUtilEntity, (DynamicObject)dy));
            this.doUnitCheckAfterOverrideCheckOrNewAdd(shareRelationsUnitedUtilEntity, (List<DynamicObject>)relations);
            neverChangeId.addAll(shareRelationsUnitedUtilEntity.getRelationIds());
            data.addAll(relations);
        });
        LinkedHashSet<DynamicObject> newSets = new LinkedHashSet<DynamicObject>(16);
        data.stream().sorted(Comparator.comparing(p -> p.getDate("investdate"))).forEachOrdered(newSets::add);
        return newSets;
    }

    private void doNewAddCheckOrOverride(ShareRelationsUnitedUtilEntity shareRelationsUnitedUtilEntity, DynamicObject dy) {
        shareRelationsUnitedUtilEntity.getRelationIds().add(dy.getLong("id"));
        shareRelationsUnitedUtilEntity.getDataIndexMap().put(dy, -1);
        String colKey = this.buildColKey(dy);
        EffectiveData effectiveData = shareRelationsUnitedUtilEntity.getRow().get(colKey);
        if (ImportOperateType.NEW != shareRelationsUnitedUtilEntity.getImportType()) {
            shareRelationsUnitedUtilEntity.getRelationIds().remove(this.override(shareRelationsUnitedUtilEntity.getOverrideData(), shareRelationsUnitedUtilEntity.getDataIndexMap(), dy, effectiveData));
        } else {
            this.newAdd(shareRelationsUnitedUtilEntity.getImportBillDataList(), shareRelationsUnitedUtilEntity.getLogger(), shareRelationsUnitedUtilEntity.getRow(), colKey, effectiveData);
        }
    }

    private void doUnitCheckAfterOverrideCheckOrNewAdd(ShareRelationsUnitedUtilEntity shareRelationsUnitedUtilEntity, List<DynamicObject> relations) {
        Map<String, Optional<DynamicObject>> maxDateGroup = relations.stream().collect(Collectors.groupingBy(InvShareRelaService::getShareholderNumber, Collectors.maxBy(Comparator.comparing(dy -> dy.getDate("investdate")))));
        this.iteratorCannotOverrideData(shareRelationsUnitedUtilEntity.getRow(), shareRelationsUnitedUtilEntity.getOverrideData(), effectiveData -> {
            if (ImportOperateType.OVERRIDE != shareRelationsUnitedUtilEntity.getImportType()) {
                DynamicObject upLoadData = effectiveData.data;
                String shareholderNumber = InvShareRelaService.getShareholderNumber((DynamicObject)upLoadData);
                Optional dynamicObject = (Optional)maxDateGroup.get(shareholderNumber);
                if (Objects.nonNull(dynamicObject) && upLoadData.getDate("investdate").before(((DynamicObject)dynamicObject.get()).getDate("investdate"))) {
                    String msg = ResManager.loadKDString((String)"\u6295\u8d44\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u8be5\u6295\u8d44\u5355\u4f4d\u5df2\u6709\u7684\u6700\u5927\u6295\u8d44\u65e5\u671f\u3002", (String)"InvShareRelaImportNewPlugin_1", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
                    shareRelationsUnitedUtilEntity.getLogger().log(Integer.valueOf(shareRelationsUnitedUtilEntity.getImportBillDataList().get(effectiveData.dataIndex).getStartIndex()), msg).fail();
                } else {
                    relations.add(upLoadData);
                    shareRelationsUnitedUtilEntity.getDataIndexMap().put(upLoadData, effectiveData.dataIndex);
                }
            } else {
                String msg = ResManager.loadKDString((String)"\u6295\u8d44\u5355\u4f4d+\u88ab\u6295\u8d44\u5355\u4f4d+\u6295\u8d44\u65e5\u671f\u7ec4\u5408\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u8986\u76d6\u3002", (String)"InvShareRelaImportNewPlugin_2", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
                shareRelationsUnitedUtilEntity.getLogger().log(Integer.valueOf(shareRelationsUnitedUtilEntity.getImportBillDataList().get(effectiveData.dataIndex).getStartIndex()), msg).fail();
            }
        });
        if (this.nonNeedToCheckMoreOrNoDataToSave(shareRelationsUnitedUtilEntity.getLogger(), shareRelationsUnitedUtilEntity.getImportType(), shareRelationsUnitedUtilEntity.getOverrideData(), shareRelationsUnitedUtilEntity.getRow())) {
            return;
        }
        InvShareRelaService.groupCollectBeforeCheckControlAndSumShareScale(relations, (shareholderConfigMap, calculateUtil) -> InvShareRelaService.buildControlSumAndShareScaleSumThenCheck((Map)shareholderConfigMap, (Pair)calculateUtil, controlSum -> {
            if (controlSum > 1) {
                String investDate = InvShareRelaService.getCheckingDate((Map)shareholderConfigMap);
                String msg = String.format(ResManager.loadKDString((String)"\u8be5\u671f%s\u5b58\u5728\u591a\u4e2a\u63a7\u5236\u80a1\u4e1c\uff0c\u8bf7\u4fee\u6539\u4e3a\u4e00\u4e2a\u3002\u8bf7\u6ce8\u610f\u662f\u5426\u53d7\u73b0\u6709\u80a1\u6743\u5173\u7cfb\u7684\u5f71\u54cd\u3002", (String)"InvShareRelaImportNewPlugin_32", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), investDate);
                this.logToLogger(shareRelationsUnitedUtilEntity.getImportBillDataList(), shareRelationsUnitedUtilEntity.getLogger(), shareRelationsUnitedUtilEntity.getDataIndexMap(), (Map<String, DynamicObject>)shareholderConfigMap, msg);
            }
        }, shareScaleSum -> {
            if (new BigDecimal("100").compareTo((BigDecimal)shareScaleSum) < 0) {
                String investDate = InvShareRelaService.getCheckingDate((Map)shareholderConfigMap);
                String msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u671f\u6295\u8d44\u6bd4\u4f8b\u603b\u989d\u8d85\u8fc7100\uff0c\u8bf7\u4fee\u6539\u3002\u8bf7\u6ce8\u610f\u662f\u5426\u53d7\u73b0\u6709\u80a1\u6743\u5173\u7cfb\u5f71\u54cd\u3002", (String)"InvShareRelaImportNewPlugin_33", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), investDate);
                this.logToLogger(shareRelationsUnitedUtilEntity.getImportBillDataList(), shareRelationsUnitedUtilEntity.getLogger(), shareRelationsUnitedUtilEntity.getDataIndexMap(), (Map<String, DynamicObject>)shareholderConfigMap, msg);
            }
            KDAssert.assertTrue((shareRelationsUnitedUtilEntity.getLogger().getFailed() == 0 ? 1 : 0) != 0, () -> new KDBizException(this.getFailMsg()));
        }));
        InvShareRelaService.calculateChangeScale(relations);
    }

    private String getFailMsg() {
        return ResManager.loadKDString((String)"\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u6309\u63d0\u793a\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"InvShareRelaImportNewPlugin_0", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
    }

    private void logToLogger(List<ImportBillData> importBillDataList, ImportLogger logger, Map<DynamicObject, Integer> dataIndexMap, Map<String, DynamicObject> shareholderConfigMap, String msg) {
        shareholderConfigMap.keySet().stream().forEach(number -> {
            Integer index = (Integer)dataIndexMap.get(shareholderConfigMap.get(number));
            if (index > -1) {
                logger.log(Integer.valueOf(((ImportBillData)importBillDataList.get(index)).getStartIndex()), msg).fail();
            }
        });
    }

    private boolean nonNeedToCheckMoreOrNoDataToSave(ImportLogger logger, ImportOperateType importType, Set<EffectiveData> overrideData, Map<String, EffectiveData> row) {
        return logger.getFailed() > 0 || ImportOperateType.NEW == importType && row.isEmpty() || ImportOperateType.OVERRIDE == importType && overrideData.isEmpty() || ImportOperateType.OVERRIDENEW == importType && row.isEmpty() && overrideData.isEmpty();
    }

    private void newAdd(List<ImportBillData> importBillDataList, ImportLogger logger, Map<String, EffectiveData> row, String colKey, EffectiveData effectiveData) {
        if (Objects.nonNull(effectiveData)) {
            logger.log(Integer.valueOf(importBillDataList.get(effectiveData.dataIndex).getStartIndex()), ResManager.loadKDString((String)"\u6295\u8d44\u5355\u4f4d+\u88ab\u6295\u8d44\u5355\u4f4d+\u6295\u8d44\u65e5\u671f\u7ec4\u5408\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u65b0\u589e\u3002", (String)"InvShareRelaImportNewPlugin_3", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0])).fail();
            row.remove(colKey);
        }
    }

    private void iteratorCannotOverrideData(Map<String, EffectiveData> row, Set<EffectiveData> overrideData, Consumer<EffectiveData> action) {
        row.keySet().stream().map(row::get).filter(effectiveData -> !overrideData.contains(effectiveData)).forEach(action::accept);
    }

    private Long override(Set<EffectiveData> overrideData, Map<DynamicObject, Integer> dataIndexMap, DynamicObject dy, EffectiveData effectiveData) {
        if (Objects.nonNull(effectiveData)) {
            String[] otherUpdateField;
            dataIndexMap.put(dy, effectiveData.dataIndex);
            overrideData.add(effectiveData);
            for (String field : otherUpdateField = InvShareRelaConstant.otherUpdateField()) {
                dy.set(field, effectiveData.data.get(field));
            }
            return dy.getLong("id");
        }
        return null;
    }

    private ApiResult buildResult(Table<Long, String, EffectiveData> effectiveData, Set<Long> neverChangeId, DynamicObject[] entryEntity) {
        ArrayList billResults = Lists.newArrayList();
        for (DynamicObject dynamicObject : entryEntity) {
            long id = dynamicObject.getLong("id");
            if (neverChangeId.contains(id)) continue;
            Long rowKey = this.buildRowKey(dynamicObject);
            String colKey = this.buildColKey(dynamicObject);
            EffectiveData effectiveData1 = (EffectiveData)effectiveData.get((Object)rowKey, (Object)colKey);
            BillResult billResult = new BillResult();
            billResult.setId(id);
            billResult.setIndex(effectiveData1.dataIndex);
            billResult.setSucess(true);
            billResults.add(billResult.toMap());
        }
        ApiResult result = new ApiResult();
        result.setSuccess(true);
        result.setData((Object)billResults);
        return result;
    }

    private String buildColKey(DynamicObject relation) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date investedDate = relation.getDate("investdate");
        return relation.getDynamicObject("shareholder").getString("id") + relation.getDynamicObject("investeecompany").getString("id") + dateFormat.format(investedDate);
    }

    private Long buildRowKey(DynamicObject relation) {
        return relation.getDynamicObject("investeecompany").getLong("id");
    }

    private void intModelAndPermMap() {
        try {
            Class<?> aClass = this.ctx.getClass();
            Field view = aClass.getDeclaredField("view");
            ReflectionUtils.makeAccessible((Field)view);
            IFormView formView = (IFormView)view.get(this.ctx);
            IFormView parentView = formView.getParentView();
            IPageCache pageCache = parentView.getPageCache();
            this.modelId = Long.parseLong(pageCache.get("KEY_MODEL_ID"));
            if ("true".equals(pageCache.get("isroot"))) {
                this.isAdmin = true;
            } else {
                this.permPackageList = (PermPackageList)SerializationUtils.fromJsonString((String)pageCache.get(PermCacheKey.ORG_PERM_CACHE_KEY), PermPackageList.class);
            }
            this.currentShareCaseDy = (DynamicObject)parentView.getModel().getValue("sharecase");
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private Table<Long, String, EffectiveData> getEffectiveData(List<ImportBillData> importBillDataList, ImportLogger logger) {
        DbNumberS dbNumberS = this.dataFromDB(importBillDataList);
        HashBasedTable effectiveDatas = HashBasedTable.create();
        ArrayList rowLogs = new ArrayList(16);
        importBillDataList.stream().forEach(arg_0 -> this.lambda$getEffectiveData$17(dbNumberS, rowLogs, logger, importBillDataList, (Table)effectiveDatas, arg_0));
        return effectiveDatas;
    }

    private void collectEffectiveData(DynamicObject dynamicObject, List<ImportBillData> importBillDataList, ImportLogger logger, ImportBillData importBillData, Table<Long, String, EffectiveData> newDataMap) {
        int dataIndex = importBillData.getDataIndex();
        Long rowKey = this.buildRowKey(dynamicObject);
        String colKey = this.buildColKey(dynamicObject);
        Map row = newDataMap.row((Object)rowKey);
        if (Objects.isNull(row)) {
            newDataMap.put((Object)rowKey, (Object)colKey, (Object)new EffectiveData(dataIndex, dynamicObject));
        } else if (Objects.nonNull(row.putIfAbsent(colKey, new EffectiveData(dataIndex, dynamicObject)))) {
            EffectiveData effectiveData = (EffectiveData)row.get(colKey);
            int dataIndex1 = effectiveData.dataIndex;
            int startIndex = importBillDataList.get(dataIndex1).getStartIndex();
            String msg = String.format(ResManager.loadKDString((String)"\u80a1\u6743\u5173\u7cfb\u4e0e\u7b2c%1$s\u884c\u76f8\u540c\uff1b\u8bf7\u68c0\u67e5\u6295\u8d44\u5355\u4f4d\u6295\u8d44\u60c5\u51b5:\u6295\u8d44\u5355\u4f4d+\u88ab\u6295\u8d44\u5355\u4f4d+\u6295\u8d44\u65e5\u671f\u7ec4\u5408\u552f\u4e00\u3002", (String)"InvShareRelaImportNewPlugin_5", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), startIndex + 1);
            logger.log(Integer.valueOf(importBillData.getStartIndex()), msg).fail();
        }
    }

    private BigDecimal checkThenGetShareScale(List<ImportLogger.ImportLog> rowLogs, JSONObject data) {
        if (!StringUtils.isBlank((CharSequence)data.getString("sharescale"))) {
            BigDecimal shareScale = InvestUtils.convertToBigDecimal((Object)data.get((Object)"sharescale"));
            if (shareScale.compareTo(new BigDecimal("100")) > 0 || shareScale.compareTo(BigDecimal.ZERO) < 0) {
                rowLogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u671f\u672b\u6301\u80a1\u6bd4\u4f8b\u5fc5\u987b\u57280~100%\u4e4b\u95f4\u3002", (String)"InvShareRelaImportNewPlugin_7", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0])));
            }
            if (shareScale.scale() > 15) {
                rowLogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u671f\u672b\u6301\u80a1\u6bd4\u4f8b\u7684\u5c0f\u6570\u4e0d\u80fd\u8d85\u8fc715\u4f4d\u3002", (String)"InvShareRelaImportNewPlugin_8", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0])));
            }
            return shareScale;
        }
        rowLogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u671f\u672b\u6301\u80a1\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvShareRelaImportNewPlugin_6", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0])));
        return null;
    }

    private BigDecimal checkThenGetInvestAmount(List<ImportLogger.ImportLog> rowLogs, JSONObject data) {
        BigDecimal investAmount;
        BigDecimal bigDecimal = investAmount = data.get((Object)"investamount") == null ? BigDecimal.ZERO : new BigDecimal(data.getString("investamount"));
        if (!InvestUtils.checkAmountOutOfRange((BigDecimal)investAmount)) {
            rowLogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u6295\u8d44\u91d1\u989d\u6570\u503c\u8d85\u51fa\u8303\u56f4\uff0c\u7cbe\u5ea6\u5e94\u4e3a17\u4f4d\u6574\u6570\u548c4\u4f4d\u5c0f\u6570\u3002", (String)"InvShareRelaImportNewPlugin_9", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0])));
        }
        return investAmount;
    }

    private void checkIsControl(List<ImportLogger.ImportLog> rowLogs, JSONObject data) {
        ArrayList controlValue = Lists.newArrayList((Object[])new String[]{"0", "1"});
        String isControl = data.getString("iscontrol");
        if (Objects.nonNull(isControl) && !controlValue.contains(isControl)) {
            rowLogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u662f\u5426\u8fbe\u6210\u63a7\u5236\u53d6\u503c\u6709\u8bef\uff0c\u8bf7\u4e0b\u62c9\u9009\u62e9\u3010\u662f/\u5426\u3011\u3002", (String)"InvShareRelaImportNewPlugin_11", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0])));
        }
    }

    private Date checkThenGetInvestDate(List<ImportLogger.ImportLog> rowLogs, JSONObject data) {
        Date investDate = null;
        String investedDate = data.getString("investdate");
        if (Objects.isNull(investedDate)) {
            rowLogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u6295\u8d44\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvShareRelaImportNewPlugin_12", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0])));
        }
        for (String dateFormat : BatchImportHelper.IMPORT_DATE_FORMATS) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
                sdf.setLenient(false);
                String date = (String)data.get((Object)"investdate");
                investDate = sdf.parse(date);
                break;
            }
            catch (ParseException e) {
                investDate = null;
            }
        }
        if (Objects.isNull(investDate)) {
            rowLogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u6295\u8d44\u65e5\u671f\u4e0d\u6ee1\u8db3\u683c\u5f0f\u8981\u6c42\u3002", (String)"InvShareRelaImportNewPlugin_13", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0])));
        }
        return investDate;
    }

    private boolean numberColIsNumber(List<ImportLogger.ImportLog> rowLogs, ImportBillData importBillData) {
        JSONObject data = importBillData.getData();
        ImportEntityMapping entityMapping = importBillData.getEntityMapping();
        try {
            entityMapping.getCols().forEach((k, v) -> {
                IDataEntityProperty property = v.getProperty();
                if (Objects.nonNull(data.get(k)) && (property instanceof BigIntProp || property instanceof IntegerProp || property instanceof DecimalProp)) {
                    try {
                        new BigDecimal((String)data.get(k));
                    }
                    catch (NumberFormatException e) {
                        String displayName = v.getDisplayName();
                        String msg = String.format(ResManager.loadKDString((String)"%s\u8bf7\u5f55\u5165\u6570\u5b57\u7c7b\u578b\u3002", (String)"InvShareRelaImportNewPlugin_14", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), displayName);
                        rowLogs.add(new ImportLogger.ImportLog(msg));
                        throw e;
                    }
                }
            });
        }
        catch (NumberFormatException e) {
            log.error((Throwable)e);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private boolean checkModel(DbNumberS dbNumberS, List<ImportLogger.ImportLog> rowLogs, JSONObject data) {
        JSONObject modelJson = data.getJSONObject(MODEL);
        if (modelJson == null) {
            rowLogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvShareRelaImportNewPlugin_15", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0])));
            return false;
        }
        String shownumber = modelJson.getString("shownumber");
        if (shownumber == null) {
            shownumber = modelJson.getString(NUMBER);
        }
        if (!dbNumberS.modelDy.getString("shownumber").equals(shownumber)) {
            rowLogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5f55\u5165\u4f53\u7cfb\u7f16\u7801\u4e3a\u5f53\u524d\u4f53\u7cfb\u3002", (String)"InvShareRelaImportNewPlugin_16", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0])));
            return false;
        }
        return true;
    }

    private DbNumberS dataFromDB(List<ImportBillData> importBillDataList) {
        KDAssert.assertFalse((this.modelId == 0L ? 1 : 0) != 0, () -> new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u4f53\u7cfb\u5f02\u5e38\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"InvShareRelaImportNewPlugin_17", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0])));
        HashSet entitySet = Sets.newHashSet();
        HashSet interCompanySet = Sets.newHashSet();
        HashSet currencySet = Sets.newHashSet();
        HashSet invChangeTypeSet = Sets.newHashSet();
        importBillDataList.stream().map(ImportBillData::getData).forEach(data -> {
            String orgNumber = Optional.ofNullable(data.getJSONObject("shareholder")).map(entity -> entity.getString(NUMBER)).get();
            interCompanySet.add(orgNumber);
            entitySet.add(orgNumber);
            entitySet.add(Optional.ofNullable(data.getJSONObject("investeecompany")).map(entity -> entity.getString(NUMBER)).get());
            currencySet.add(Optional.ofNullable(data.getJSONObject("holderec")).map(entity -> entity.getString(NUMBER)).get());
            invChangeTypeSet.add(Optional.ofNullable(data.getJSONObject("invchangetype")).map(entity -> entity.getString(NUMBER)).get());
        });
        DynamicObject modelDy = BusinessDataServiceHelper.loadSingle((Object)this.modelId, (String)"bcm_model", (String)"id,shownumber");
        Map<String, DynamicObject> entities = Arrays.stream(BusinessDataServiceHelper.load((String)"bcm_entitymembertree", (String)"id,name,number,currency,isindependentorg", (QFilter[])new QFBuilder(MODEL, "=", (Object)this.modelId).and(NUMBER, "in", (Object)entitySet).and("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex()).toArray())).collect(Collectors.toMap(dy -> dy.getString(NUMBER), dy -> dy, (e1, e2) -> e1));
        Map<String, DynamicObject> interCompanies = Arrays.stream(BusinessDataServiceHelper.load((String)"bcm_icmembertree", (String)"id,name,number,longnumber", (QFilter[])new QFBuilder(MODEL, "=", (Object)this.modelId).and(NUMBER, "in", (Object)interCompanySet).toArray())).collect(Collectors.toMap(dy -> dy.getString(NUMBER), dy -> dy, (e1, e2) -> e1));
        Map<String, DynamicObject> currencies = Arrays.stream(BusinessDataServiceHelper.load((String)"bcm_currencymembertree", (String)"id,name,number", (QFilter[])new QFBuilder(MODEL, "=", (Object)this.modelId).and(NUMBER, "in", (Object)currencySet).toArray())).collect(Collectors.toMap(dy -> dy.getString(NUMBER), dy -> dy, (e1, e2) -> e1));
        DynamicObjectCollection invChangeTypeDys = QueryServiceHelper.query((String)"bcm_invchangetype", (String)"id,name,number,model,isdefault", (QFilter[])new QFBuilder(MODEL, "=", (Object)this.modelId).and(NUMBER, "in", (Object)invChangeTypeSet).toArray());
        HashMap<String, DynamicObject> invChangeTypes = new HashMap<String, DynamicObject>(invChangeTypeDys.size());
        for (DynamicObject dynamicObject : invChangeTypeDys) {
            String changeTypeNum = dynamicObject.getString(NUMBER);
            if (dynamicObject.getBoolean("isdefault") && (OrgBizChangeTypeEnum.sameControlParentDisposal.getValue().equals(changeTypeNum) || OrgBizChangeTypeEnum.sameControlParentNewlyAdded.getValue().equals(changeTypeNum))) continue;
            invChangeTypes.compute(changeTypeNum, (number, oldValue) -> {
                if (dynamicObject.getLong(MODEL) == 0L || Objects.isNull(oldValue)) {
                    return dynamicObject;
                }
                return oldValue;
            });
        }
        return new DbNumberS(modelDy, entities, interCompanies, currencies, invChangeTypes);
    }

    private DynamicObject checkThenGetInvChangeTypeDy(DbNumberS dbNumberS, List<ImportLogger.ImportLog> rowLogs, JSONObject data) {
        return BatchImportHelper.doCheckNumberThenGet(rowLogs, data, "invchangetype", ResManager.loadKDString((String)"\u53d8\u66f4\u7c7b\u578b", (String)"InvShareRelaImportNewPlugin_18", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), dbNumberS.invChangeTypes, invChangeTypeDy -> {});
    }

    private DynamicObject checkThenGetHolderEcDy(DbNumberS dbNumberS, List<ImportLogger.ImportLog> rowLogs, JSONObject data) {
        return BatchImportHelper.doCheckNumberThenGet(rowLogs, data, "holderec", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"InvShareRelaImportNewPlugin_19", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), dbNumberS.currencies, holderEcDy -> {});
    }

    private DynamicObject checkThenGetShareholderDy(DbNumberS dbNumberS, List<ImportLogger.ImportLog> rowLogs, JSONObject data) {
        return BatchImportHelper.doCheckNumberThenGet(rowLogs, data, "shareholder", ResManager.loadKDString((String)"\u6295\u8d44\u5355\u4f4d", (String)"InvShareRelaImportNewPlugin_20", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), dbNumberS.interCompanies, shareHolderDy -> {
            String shareHolderNumber = shareHolderDy.getString(NUMBER);
            if (dbNumberS.entities.containsKey(shareHolderNumber)) {
                String importCurrency;
                String targetCurrency;
                DynamicObject dynamicObject = dbNumberS.entities.get(shareHolderNumber);
                if (!dynamicObject.getBoolean("isindependentorg")) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5185\u90e8\u6295\u8d44\uff0c\u6295\u8d44\u5355\u4f4d[%1$s]\u5fc5\u987b\u4e3a\u72ec\u7acb\u6cd5\u4eba\u516c\u53f8\u3002", (String)"InvShareRelaImportNewPlugin_22", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), shareHolderNumber);
                    rowLogs.add(new ImportLogger.ImportLog(msg));
                }
                if (!Objects.equals(targetCurrency = dynamicObject.getString("currency.number"), importCurrency = data.getJSONObject("holderec").getString(NUMBER))) {
                    String msg = String.format(ResManager.loadKDString((String)"\u6295\u8d44\u5355\u4f4d\u4e3a\u5185\u90e8\u7ec4\u7ec7\uff0c\u5e01\u79cd\u5e94\u4e3a[%1$s]\uff0c\u800c\u5bfc\u5165\u7684\u5e01\u79cd\u662f[%2$s]\u3002", (String)"InvShareRelaImportNewPlugin_23", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), targetCurrency, importCurrency);
                    rowLogs.add(new ImportLogger.ImportLog(msg));
                }
            }
        });
    }

    private DynamicObject checkThenGetInvestedCompanyDy(DbNumberS dbNumberS, List<ImportLogger.ImportLog> rowLogs, JSONObject data) {
        return BatchImportHelper.doCheckNumberThenGet(rowLogs, data, "investeecompany", ResManager.loadKDString((String)"\u88ab\u6295\u8d44\u5355\u4f4d", (String)"InvShareRelaImportNewPlugin_24", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), dbNumberS.entities, investedCompanyDy -> {
            String msg;
            String id = investedCompanyDy.getString("id");
            String investedCompanyNumber = investedCompanyDy.getString(NUMBER);
            if (!this.isAdmin && this.permPackageList != null && this.permPackageList.getPermEnum(LongUtil.toLong((Object)id).longValue()) != PermEnum.READWRITE) {
                msg = String.format(ResManager.loadKDString((String)"\u60a8\u65e0\u88ab\u6295\u8d44\u5355\u4f4d[%1$s]\u5199\u6743\u9650\u3002", (String)"InvShareRelaImportNewPlugin_25", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), investedCompanyNumber);
                rowLogs.add(new ImportLogger.ImportLog(msg));
            }
            if (!investedCompanyDy.getBoolean("isindependentorg")) {
                msg = String.format(ResManager.loadKDString((String)"\u88ab\u6295\u8d44\u5355\u4f4d[%1$s]\u5fc5\u987b\u4e3a\u72ec\u7acb\u6cd5\u4eba\u516c\u53f8\u3002", (String)"InvShareRelaImportNewPlugin_26", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), investedCompanyNumber);
                rowLogs.add(new ImportLogger.ImportLog(msg));
            }
        });
    }

    private /* synthetic */ void lambda$getEffectiveData$17(DbNumberS dbNumberS, List rowLogs, ImportLogger logger, List importBillDataList, Table effectiveDatas, ImportBillData importBillData) {
        JSONObject data = importBillData.getData();
        if (!this.checkModel(dbNumberS, rowLogs, data)) {
            logger.logAll(Integer.valueOf(importBillData.getStartIndex()), rowLogs).fail();
            rowLogs.clear();
            return;
        }
        DynamicObject investedCompanyDy = this.checkThenGetInvestedCompanyDy(dbNumberS, rowLogs, data);
        DynamicObject shareholderDy = this.checkThenGetShareholderDy(dbNumberS, rowLogs, data);
        DynamicObject holderEcDy = this.checkThenGetHolderEcDy(dbNumberS, rowLogs, data);
        DynamicObject invChangeTypeDy = this.checkThenGetInvChangeTypeDy(dbNumberS, rowLogs, data);
        Date investDate = this.checkThenGetInvestDate(rowLogs, data);
        this.checkIsControl(rowLogs, data);
        if (data.getJSONObject("investeecompany").getString(NUMBER).equals(data.getJSONObject("shareholder").getString(NUMBER))) {
            rowLogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u88ab\u6295\u8d44\u5355\u4f4d\u4e0d\u80fd\u548c\u6295\u8d44\u5355\u4f4d\u76f8\u540c\u3002", (String)"InvShareRelaImportNewPlugin_4", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0])));
        }
        if (!this.numberColIsNumber(rowLogs, importBillData)) {
            logger.logAll(Integer.valueOf(importBillData.getStartIndex()), rowLogs).fail();
            rowLogs.clear();
            return;
        }
        BigDecimal investAmount = this.checkThenGetInvestAmount(rowLogs, data);
        BigDecimal shareScale = this.checkThenGetShareScale(rowLogs, data);
        if (rowLogs.isEmpty()) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_invsharerela");
            dynamicObject.set(MODEL, (Object)this.modelId);
            dynamicObject.set("shareholder", (Object)shareholderDy);
            dynamicObject.set("investeecompany", (Object)investedCompanyDy);
            dynamicObject.set("sharecase", (Object)this.currentShareCaseDy);
            dynamicObject.set("investamount", (Object)investAmount);
            dynamicObject.set("investdate", (Object)investDate);
            dynamicObject.set("isout", (Object)(shareholderDy.getString("longnumber").startsWith("InternalCompany!ICTotal!ICOEntity!") ? "0" : "1"));
            dynamicObject.set("remark", data.get((Object)"remark"));
            dynamicObject.set("invchangetype", (Object)invChangeTypeDy.getLong("id"));
            dynamicObject.set("sharescale", (Object)shareScale);
            dynamicObject.set("holderec", (Object)holderEcDy);
            dynamicObject.set("invcompanycurrency", investedCompanyDy.get("currency"));
            dynamicObject.set("iscontrol", data.get((Object)"iscontrol"));
            Date now = TimeServiceHelper.now();
            long currUserId = RequestContext.get().getCurrUserId();
            dynamicObject.set("creatorid", (Object)currUserId);
            dynamicObject.set("createtime", (Object)now);
            dynamicObject.set("modifierid", (Object)currUserId);
            dynamicObject.set("modifytime", (Object)now);
            this.collectEffectiveData(dynamicObject, importBillDataList, logger, importBillData, (Table<Long, String, EffectiveData>)effectiveDatas);
        } else {
            logger.logAll(Integer.valueOf(importBillData.getStartIndex()), rowLogs).fail();
            rowLogs.clear();
        }
    }

    private static class ShareRelationsUnitedUtilEntity {
        private final List<ImportBillData> importBillDataList;
        private final ImportLogger logger;
        private final ImportOperateType importType;
        private final Set<EffectiveData> overrideData;
        private final Map<DynamicObject, Integer> dataIndexMap;
        private final Set<Long> relationIds;
        private Map<String, EffectiveData> row;

        public ShareRelationsUnitedUtilEntity(List<ImportBillData> importBillDataList, ImportLogger logger, ImportOperateType importType, Set<EffectiveData> overrideData, Map<DynamicObject, Integer> dataIndexMap, Set<Long> relationIds) {
            this.importBillDataList = importBillDataList;
            this.logger = logger;
            this.importType = importType;
            this.overrideData = overrideData;
            this.dataIndexMap = dataIndexMap;
            this.relationIds = relationIds;
        }

        public List<ImportBillData> getImportBillDataList() {
            return this.importBillDataList;
        }

        public ImportLogger getLogger() {
            return this.logger;
        }

        public ImportOperateType getImportType() {
            return this.importType;
        }

        public Set<EffectiveData> getOverrideData() {
            return this.overrideData;
        }

        public Map<DynamicObject, Integer> getDataIndexMap() {
            return this.dataIndexMap;
        }

        public Set<Long> getRelationIds() {
            return this.relationIds;
        }

        public Map<String, EffectiveData> getRow() {
            return this.row;
        }

        public void setRow(Map<String, EffectiveData> row) {
            this.row = row;
        }
    }

    private static class DbNumberS {
        final DynamicObject modelDy;
        final Map<String, DynamicObject> entities;
        final Map<String, DynamicObject> interCompanies;
        final Map<String, DynamicObject> currencies;
        final Map<String, DynamicObject> invChangeTypes;

        public DbNumberS(DynamicObject modelDy, Map<String, DynamicObject> entities, Map<String, DynamicObject> interCompanies, Map<String, DynamicObject> currencies, Map<String, DynamicObject> invChangeTypes) {
            this.modelDy = modelDy;
            this.entities = entities;
            this.interCompanies = interCompanies;
            this.currencies = currencies;
            this.invChangeTypes = invChangeTypes;
        }
    }

    private static class EffectiveData {
        final int dataIndex;
        final DynamicObject data;

        public EffectiveData(int dataIndex, DynamicObject data) {
            this.dataIndex = dataIndex;
            this.data = data;
        }
    }
}

