/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.business.invest.helper.InvShareCaseHelper;
import kd.fi.bcm.business.invest.model.InvShareCase;
import kd.fi.bcm.business.invest.service.InvShareCaseF7Com;
import kd.fi.bcm.business.invest.shareholder.InvShareRelaService;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.UserSelectServiceHelper;
import kd.fi.bcm.business.tree.AbstractTreeNode;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.business.tree.TreeBuilder;
import kd.fi.bcm.business.tree.TreeModel;
import kd.fi.bcm.business.tree.dimension.OrgTreeNode;
import kd.fi.bcm.business.upgrade.InvChangeTypeUpgradeService;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.common.IRefreshList;
import kd.fi.bcm.formplugin.guidemenu.GuidePageUtils;
import kd.fi.bcm.formplugin.invest.AbstractInvShareBasePlugin;
import kd.fi.bcm.formplugin.invest.InvShareRelaImportNewPlugin;
import kd.fi.bcm.formplugin.util.FormShowUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.spread.common.util.StringUtil;

public class InvShareRelaListPlugin
extends AbstractInvShareBasePlugin
implements HyperLinkClickListener,
TabSelectListener,
TreeNodeClickListener,
IRefreshList,
ListRowClickListener {
    private static final String TAB_SELECTED = "tabSelected";
    private static final String TAB_AP = "tabap";
    private static final String TAB_SHARE_HOLDER = "tab_shareholder";
    private static final String TAB_INVESTEE_COMPANY = "tab_investeecompany";
    private static final String BILLLIST_STAP = "billlistap";
    private static final String NUMBER = "number";
    private static final String BTN_DELETE = "btn_delete";
    private static final String MODEL = "model";
    private static final String SHARE_CASE = "sharecase";
    private static String READ_ONLY_CASE = "ReadOnlyCase";
    private static String BTN_CASE = "btn_case";
    private InvShareCaseF7Com invShareCaseF7Com;

    private String getOperationDel() {
        return ResManager.loadKDString((String)"\u5220\u9664", (String)"InvShareRelaListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationView() {
        return ResManager.loadKDString((String)"\u67e5\u770b", (String)"InvShareRelaListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationDisable() {
        return ResManager.loadKDString((String)"\u7981\u7528", (String)"InvShareRelaListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationEnable() {
        return ResManager.loadKDString((String)"\u542f\u7528", (String)"InvShareRelaListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationBtnShowall() {
        return ResManager.loadKDString((String)"\u663e\u793a\u6240\u6709\u7248\u672c", (String)"InvShareRelaListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationShowlatest() {
        return ResManager.loadKDString((String)"\u663e\u793a\u6700\u65b0\u7248\u672c", (String)"InvShareRelaListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.invShareCaseF7Com = new InvShareCaseF7Com(this.getView());
    }

    @Override
    public void refreshList() {
    }

    public void tabSelected(TabSelectEvent evt) {
        this.checkmodel();
        String tabKey = evt.getTabKey();
        this.getPageCache().put(TAB_SELECTED, tabKey);
        this.refreshBillList();
        this.lockBtn(tabKey);
    }

    private void lockBtn(String tabKey) {
        IFormView view = this.getView();
        view.setEnable(Boolean.valueOf(TAB_INVESTEE_COMPANY.equals(tabKey)), new String[]{"btn_addnew", BTN_DELETE});
    }

    private void checkmodel() {
        String modelid = this.getPageCache().get("KEY_MODEL_ID");
        if (StringUtils.isEmpty((CharSequence)modelid)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"InvShareRelaListPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        BillList billList = (BillList)this.getView().getControl(BILLLIST_STAP);
        billList.clearSelection();
    }

    @Override
    public void listRowDoubleClick(ListRowClickEvent evt) {
        super.listRowDoubleClick(evt);
        BillList billList = (BillList)this.getView().getControl(BILLLIST_STAP);
        billList.clearSelection();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl(TAB_AP);
        tab.addItemClickListener((ItemClickListener)this);
        tab.addTabSelectListener((TabSelectListener)this);
        this.addClickListeners("searchbefore", "searchnext");
        long modelId = this.getModelId();
        this.invShareCaseF7Com.registerF7Filter(modelId);
        this.invShareCaseF7Com.registerActionAfterModelChange(MODEL);
        BillList billList = (BillList)this.getView().getControl(BILLLIST_STAP);
        billList.addListRowClickListener((ListRowClickListener)this);
        billList.addListRowDoubleClickListener((ListRowClickListener)this);
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        IPageCache pageCache;
        String currentTab;
        super.afterCreateNewData(e);
        String modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), MODEL);
        if (modelId != null) {
            this.getModel().setValue(MODEL, (Object)modelId);
            this.getPageCache().put("KEY_MODEL_ID", modelId);
            this.initCslschemeValue(modelId, false);
        }
        if ((currentTab = (pageCache = this.getPageCache()).get(TAB_SELECTED)) == null) {
            Tab tab = (Tab)this.getControl(TAB_AP);
            currentTab = tab.getCurrentTab();
            pageCache.put(TAB_SELECTED, currentTab);
        }
        if (modelId == null || !StringUtils.isEmpty((CharSequence)modelId)) {
            this.refreshTree(modelId);
            this.refreshBillList(new QFilter("1", "!=", (Object)1));
        }
        this.checkGradeOrgScheme();
        this.invShareCaseF7Com.resetDefaultShareCase(MODEL);
        this.getPageCache().put("showorgtype", "4");
        boolean ishowdebug = ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"isDebugInv");
        this.getView().setVisible(Boolean.valueOf(ishowdebug), new String[]{"bar_invdebug"});
    }

    private void refreshTree(String modelid) {
        if (modelid != null) {
            this.buildLeftTree(Long.valueOf(modelid));
        } else {
            TreeView tree = (TreeView)this.getControl("tree_org");
            tree.deleteAllNodes();
        }
    }

    private void buildLeftTree(Long modelid) {
        DynamicObjectCollection rootNodecollection = this.getTreeListORM(modelid);
        if (rootNodecollection == null || rootNodecollection.size() == 0) {
            TreeView tree = (TreeView)this.getControl("tree_org");
            tree.deleteAllNodes();
        } else {
            String showType = this.getPageCache().get("showorgtype");
            OrgTreeNode root = null;
            root = new OrgTreeNode("root", ResManager.loadKDString((String)"\u5168\u90e8", (String)"InvShareRelaListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            root = TreeBuilder.getOrgCslTree((DynamicObjectCollection)rootNodecollection, (String)showType, (boolean)false);
            root = (OrgTreeNode)TreeBuilder.setOpen((ITreeNode)root);
            root.SetIsOpened(true);
            this.initTree((AbstractTreeNode<Object>)root);
        }
    }

    private void initTree(AbstractTreeNode<Object> root) {
        TreeView tree = (TreeView)this.getControl("tree_org");
        if (root != null) {
            TreeModel treemodel = new TreeModel(root);
            treemodel.buildEntryTree(tree);
            if (root.getChildren() == null) {
                return;
            }
            TreeNode selectnode = this.findCacheNode(root);
            tree.focusNode(selectnode);
            this.getPageCache().put("nodeSelected", selectnode.getId());
            this.getPageCache().put("entityselectedNodeId", selectnode.getId());
            this.expandAllSelected((TreeModel<AbstractTreeNode<Object>>)treemodel, tree);
            treemodel.ache2page(this.getPageCache(), "cache_treeentity");
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (MODEL.equals(propertyName)) {
            ChangeData[] changeSet = e.getChangeSet();
            Object newValue2 = changeSet[0].getNewValue();
            String modelId = null;
            if (newValue2 != null) {
                modelId = ((DynamicObject)newValue2).getString("id");
                this.initCslschemeValue(modelId, false);
                this.getPageCache().put("KEY_MODEL_ID", modelId);
                UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId);
            } else {
                this.propertyChangedModelUse(new ArrayList<String>(0));
            }
            if (StringUtils.isNotEmpty((CharSequence)modelId)) {
                this.refreshTree(modelId);
                this.refreshBillList(new QFilter("1", "!=", (Object)1));
            }
        } else if ("cslscheme".equals(propertyName)) {
            this.saveUserChangedCslscheme((DynamicObject)e.getChangeSet()[0].getNewValue());
            this.refreshTree(String.valueOf(this.getModelId()));
            this.refreshBillList(new QFilter("1", "!=", (Object)1));
        } else if ("showorgtype".equals(propertyName)) {
            String showType = (String)this.getModel().getValue("showorgtype");
            this.getPageCache().put("showorgtype", showType);
            String modelId = this.getPageCache().get("KEY_MODEL_ID");
            this.refreshTree(modelId);
        } else if (SHARE_CASE.equals(propertyName)) {
            this.invShareCaseF7Com.propertyChanged(e, newValue -> {
                InvShareCase invShareCase = InvShareCase.genEntityBy((DynamicObject)newValue);
                if (InvShareCaseHelper.isReadOnly((InvShareCase)invShareCase)) {
                    this.getPageCache().put(READ_ONLY_CASE, "true");
                } else {
                    this.getPageCache().remove(READ_ONLY_CASE);
                }
                this.refreshBillList();
            });
        }
    }

    private DynamicObjectCollection getTreeListORM(Long modelid) {
        DynamicObjectCollection doc = this.getOrgDynamicObjectCollection(modelid);
        this.delOrgMenberPerm(doc, modelid);
        this.getPageCache().remove("delOrgMenberPerm");
        if (doc != null && doc.size() != 0) {
            this.getPageCache().put("delOrgMenberPerm", ObjectSerialUtil.toByteSerialized(this.toList(doc)));
        }
        return doc;
    }

    private Set<String> toList(DynamicObjectCollection docs) {
        HashSet<String> temp = new HashSet<String>(docs.size());
        for (DynamicObject doc : docs) {
            temp.add(doc.getString(NUMBER));
        }
        return temp;
    }

    private TreeNode findCacheNode(AbstractTreeNode<Object> root) {
        List<String> selects = new ArrayList();
        String selectnode = GuidePageUtils.getUserSelectOrg(this.getView(), this.getUserId(), this.getModelId(), false, false);
        if (this.getPageCache().get("selectorgs") != null) {
            selects = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("selectorgs"));
            selectnode = (String)selects.get(selects.size() - 1);
        }
        if (!StringUtil.isEmptyString((String)selectnode)) {
            selects.remove(selectnode);
            selects.add(selectnode);
            this.getPageCache().put("selectorgs", ObjectSerialUtil.toByteSerialized(selects));
        }
        if (selectnode == null || selectnode.equals(root.getId())) {
            return new TreeNode("0", root.getId(), root.getName());
        }
        LinkedList<Object> queue = new LinkedList<Object>();
        queue.add(root);
        while (!queue.isEmpty()) {
            ITreeNode node = (ITreeNode)queue.poll();
            if (node.getId().equals(selectnode)) {
                return new TreeNode(node.getParent() == null ? "" : node.getParent().getId(), node.getId(), "");
            }
            List children = node.getChildren();
            if (children.size() == 0) continue;
            for (ITreeNode child : children) {
                queue.add(child);
            }
        }
        return new TreeNode("0", root.getId(), root.getName());
    }

    public DynamicObjectCollection getChildOrgs(Long orgid) {
        QFilter qf = new QFilter("id", "=", (Object)orgid);
        DynamicObject currentOrg = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,number,name,model,longnumber", (QFilter[])qf.toArray());
        if (currentOrg == null) {
            return null;
        }
        String currentLongNumber = currentOrg.getString("longnumber");
        Long modelId = currentOrg.getLong(MODEL);
        QFBuilder qfBuilder = new QFBuilder(MODEL, "=", (Object)modelId).and(this.currentAndAllSubFilter(currentLongNumber));
        return QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,number,name,longnumber", (QFilter[])qfBuilder.toArray(), (String)"level");
    }

    private QFilter currentAndAllSubFilter(String longNumber) {
        return new QFilter("longnumber", "like", (Object)(longNumber + "!%")).or("longnumber", "=", (Object)longNumber);
    }

    private void expandAllSelected(TreeModel<AbstractTreeNode<Object>> treemodel, TreeView treeView) {
        if (this.getPageCache().get("selectorgs") != null) {
            List selects = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("selectorgs"));
            OrgTreeNode root = (OrgTreeNode)treemodel.getRoot();
            for (String nodeid : selects) {
                OrgTreeNode node = (OrgTreeNode)treemodel.searchByNodeId(nodeid);
                if (node == null || node.getId() == null || node.getId().equals(root.getId())) continue;
                String parentid = node.getParent().getId();
                while (!parentid.equals(root.getId())) {
                    treeView.expand(parentid);
                    node = (OrgTreeNode)node.getParent();
                    parentid = node.getParent().getId();
                }
            }
        }
    }

    private void refreshBillList() {
        String tabKey = this.getPageCache().get(TAB_SELECTED);
        String selectedNodeId = this.getPageCache().get("nodeSelected");
        this.refreshBillListByTabKey(tabKey, selectedNodeId);
    }

    private void refreshBillList(QFilter qf) {
        QFBuilder isolationQFilter = this.getIsolationQFilter();
        if (qf != null) {
            isolationQFilter.and(qf);
        }
        BillList billList = (BillList)this.getView().getControl(BILLLIST_STAP);
        billList.clearSelection();
        billList.setFilterParameter(new FilterParameter(isolationQFilter.toList(), null));
        billList.refresh();
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String selectedNodeId = (String)evt.getNodeId();
        if (this.checkOrgMemberIsNoPerm(selectedNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u64cd\u4f5c\u5bf9\u5e94\u7684\u6210\u5458\u6743\u9650\u3002", (String)"InvRelationSearchPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            TreeView tree = (TreeView)this.getControl("tree_org");
            String nodeBeforeChange = this.getPageCache().get("nodeSelected");
            tree.focusNode(new TreeNode("", nodeBeforeChange, ""));
            return;
        }
        this.getPageCache().put("nodeSelected", selectedNodeId);
        List<String> selectnodes = new ArrayList<String>();
        if (this.getPageCache().get("selectorgs") != null) {
            selectnodes = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("selectorgs"));
        }
        if (!selectnodes.contains(selectedNodeId)) {
            selectnodes.add(selectedNodeId);
        } else {
            selectnodes.remove(selectedNodeId);
            selectnodes.add(selectedNodeId);
        }
        this.getPageCache().put("selectorgs", ObjectSerialUtil.toByteSerialized(selectnodes));
        if (selectedNodeId.isEmpty()) {
            this.refreshBillList(new QFilter("1", "=", (Object)0));
            return;
        }
        String tabKey = this.getPageCache().get(TAB_SELECTED);
        if (this.checkOrgMemberIsOnlyRead(selectedNodeId)) {
            UserSelectServiceHelper.setEntity((Long)this.getUserId(), (Long)this.getModelId(), (Object)selectedNodeId);
        }
        this.refreshBillListByTabKey(tabKey, selectedNodeId);
    }

    private void refreshBillListByTabKey(String tabKey, String orgId) {
        QFilter qf = null;
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)NUMBER, (QFilter[])new QFilter("id", "=", (Object)LongUtil.toLong((Object)orgId)).toArray());
        if (queryOne == null) {
            this.refreshBillList(new QFilter("1", "!=", (Object)1));
            return;
        }
        String orgNumber = queryOne.getString(NUMBER);
        IDNumberTreeNode baseOrg = MemberReader.findMemberByNumber((String)this.getCurModelNumber(), (String)(TAB_SHARE_HOLDER.equals(tabKey) ? SysDimensionEnum.InternalCompany.getNumber() : SysDimensionEnum.Entity.getNumber()), (String)orgNumber);
        Set orgIds = baseOrg.getShareNodes().stream().map(e -> e.getId()).collect(Collectors.toSet());
        orgIds.add(baseOrg.getId());
        if (TAB_SHARE_HOLDER.equals(tabKey)) {
            qf = new QFilter("shareholder", "in", orgIds);
        } else if (TAB_INVESTEE_COMPANY.equals(tabKey)) {
            qf = new QFilter("investeecompany", "in", orgIds);
        }
        this.refreshBillList(qf);
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (BTN_DELETE.equals(itemKey)) {
            this.delRecord();
        } else if ("btn_addnew".equals(itemKey)) {
            this.addNewEvent();
        } else if ("btn_conf".equals(itemKey)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bcm_invchangeacctset");
            showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        } else if ("btn_importinvsharerela".equals(itemKey) && this.checkBeforeImpt()) {
            super.invokeOperation("bcm_invsharerela", InvShareRelaImportNewPlugin.class.getName(), ResManager.loadKDString((String)"\u80a1\u6743\u5173\u7cfb", (String)"InvShareRelaListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), "importdataback");
        } else if ("btn_importinvchange".equals(itemKey)) {
            super.invokeOperation("bcm_invchangeentry", "kd.fi.bcm.formplugin.invest.InvChangeAcctImportPlugin", ResManager.loadKDString((String)"\u6743\u76ca\u53d8\u52a8", (String)"InvShareRelaListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), "importdataback");
        } else if (itemKey.startsWith("btn_export")) {
            String nodeid = this.getPageCache().get("nodeSelected");
            Long orgid = LongUtil.toLong((Object)nodeid);
            HashMap<String, Object> shareholder = new HashMap<String, Object>();
            DynamicObjectCollection allchilds = this.getChildOrgs(orgid);
            String temp = this.getPageCache().get("delOrgMenberPerm");
            if (allchilds != null && temp != null) {
                Set delOrgMemberPerm = (Set)ObjectSerialUtil.deSerializedBytes((String)temp);
                List orgnumbers = allchilds.stream().map(d -> d.getString(NUMBER)).filter(delOrgMemberPerm::contains).collect(Collectors.toList());
                shareholder.put(this.getPageCache().get(TAB_SELECTED).substring(4), orgnumbers);
                this.getPageCache().put("export_orgnum", (String)orgnumbers.get(0));
            }
            if ("btn_exportinvchange".equals(itemKey)) {
                super.exportData("bcm_invchangeentry", this.getInvChangeentryQFilter(shareholder), "bcm_invsharerelalist", "1G2FW/G3YIL8");
                return;
            }
            super.exportData("bcm_invsharerela", this.getInvSharerelaQFilter(shareholder), "bcm_invsharerelalist", "1G2FW/G3YIL8");
        } else if ("btn_refresh".equals(itemKey)) {
            String nodeId = this.getPageCache().get("nodeSelected");
            this.refreshTree(this.getPageCache().get("KEY_MODEL_ID"));
            TreeView treeView = (TreeView)this.getControl("tree_org");
            Map focusNode = treeView.getTreeState().getFocusNode();
            if (Objects.nonNull(focusNode)) {
                nodeId = (String)focusNode.get("id");
            }
            if (nodeId == null || nodeId.isEmpty()) {
                this.refreshBillList(new QFilter("1", "=", (Object)0));
                return;
            }
            String tabKey = this.getPageCache().get(TAB_SELECTED);
            this.refreshBillListByTabKey(tabKey, nodeId);
        } else if ("btn_ctset".equals(itemKey)) {
            DynamicObject modeldyn = (DynamicObject)this.getModel().getValue(MODEL);
            if (modeldyn == null) {
                return;
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put(MODEL, modeldyn.get("id"));
            FormShowUtil.openListPage(this.getView(), "bcm_invchangetype", param);
        } else if ("bar_invdebug".equals(itemKey)) {
            new InvChangeTypeUpgradeService().upgrade();
        } else if ("btn_report".equals(itemKey)) {
            IFormView mainPageView = this.getView().getMainView();
            String pageId = this.getView().getPageId() + "_" + this.getModelId();
            DynamicObject cslschemeDy = (DynamicObject)this.getModel().getValue("cslscheme");
            if (Objects.isNull(cslschemeDy)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"InvShareRelaListPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (mainPageView == null || mainPageView.getView(pageId) == null) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("bcm_invsharereport");
                showParameter.setPageId(pageId);
                showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
                showParameter.setCustomParam("cslscheme", (Object)cslschemeDy.getLong("id"));
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                IFormView parentView = this.getView().getParentView();
                if (parentView == null) {
                    this.getView().showForm(showParameter);
                } else {
                    parentView.showForm(showParameter);
                    this.getView().sendFormAction(parentView);
                }
            } else {
                IFormView childFormView = mainPageView.getView(pageId);
                childFormView.activate();
                this.getView().sendFormAction(childFormView);
            }
        } else if (BTN_CASE.equals(itemKey)) {
            this.openCaseList();
        }
    }

    private boolean checkBeforeImpt() {
        String modelId = this.getView().getPageCache().get("KEY_MODEL_ID");
        boolean result = true;
        if (Objects.isNull(modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"InvShareRelaListPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            result = false;
        }
        Object shareCase = this.getView().getModel().getValue(SHARE_CASE);
        return result && this.checkShareCase(shareCase);
    }

    private boolean checkShareCase(Object shareCase) {
        if (Objects.isNull(shareCase)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b9\u6848\u3002", (String)"InvShareRelaListPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        InvShareCase invShareCase = InvShareCase.genEntityBy((DynamicObject)((DynamicObject)shareCase));
        if (InvShareCaseHelper.isReadOnly((InvShareCase)invShareCase)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u65b9\u6848\u7684\u5199\u5165\u6743\u9650\u3002", (String)"InvShareRelaListPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void openCaseList() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
        showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setBillFormId("bcm_invsharecase");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_invsharecase"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private QFilter[] getInvSharerelaQFilter(Map<String, Object> filterParams) {
        QFBuilder isolationQFilter = this.getIsolationQFilter();
        for (Map.Entry<String, Object> entry : filterParams.entrySet()) {
            isolationQFilter.and(new QFilter(entry.getKey() + ".number", "in", entry.getValue()));
        }
        return isolationQFilter.toArray();
    }

    private QFBuilder getIsolationQFilter() {
        long modelId = this.getModelId();
        long shareCaseId = this.invShareCaseF7Com.getShareCaseId();
        return InvShareRelaService.getIsolationQFilter((long)modelId, (long)shareCaseId);
    }

    private QFilter[] getInvChangeentryQFilter(Map<String, Object> filterParams) {
        QFilter filterModel = new QFilter(MODEL, "=", (Object)this.getModelId());
        QFilter filter = null;
        for (Map.Entry<String, Object> entry : filterParams.entrySet()) {
            String key = entry.getKey();
            filter = new QFilter(key + ".number", "in", entry.getValue());
            if (!"shareholder".equals(key)) continue;
            DynamicObjectCollection investeecompany = QueryServiceHelper.query((String)"bcm_invchangeentry", (String)"investeecompany", (QFilter[])new QFilter[]{filter, filterModel});
            ArrayList<String> param = new ArrayList<String>();
            for (DynamicObject temp : investeecompany) {
                param.add(temp.getString("investeecompany"));
            }
            filter = new QFilter("investeecompany", "in", param);
        }
        return new QFilter[]{filterModel, filter};
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        long shareCaseId;
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"bcm_invsharechange")) {
            String nodeId = this.getPageCache().get("nodeSelected");
            if (nodeId.isEmpty()) {
                this.refreshBillList(new QFilter("1", "=", (Object)0));
                return;
            }
            String tabKey = this.getPageCache().get(TAB_SELECTED);
            this.refreshBillListByTabKey(tabKey, nodeId);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"bcm_invsharecase") && (shareCaseId = this.invShareCaseF7Com.getShareCaseId()) == 0L) {
            this.invShareCaseF7Com.resetDefaultShareCase(MODEL);
            this.refreshBillList();
        }
    }

    private void addNewEvent() {
        Recorder isOnlyView = new Recorder((Object)false);
        if (!this.validatorNode((Recorder<Boolean>)isOnlyView)) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setPageId(this.getView().getPageId() + this.getPageCache().get("KEY_MODEL_ID") + this.getPageCache().get("nodeSelected"));
        showParameter.setFormId("bcm_invsharechange");
        showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
        showParameter.setCustomParam(SHARE_CASE, (Object)this.invShareCaseF7Com.getShareCaseId());
        showParameter.setCustomParam("investeecompany", (Object)this.getPageCache().get("nodeSelected"));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_invsharechange"));
        Long icId = Long.valueOf(this.getPageCache().get("nodeSelected"));
        DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"storagetype,copyfrom", (QFilter[])new QFBuilder("id", "=", (Object)icId).toArray());
        String storagetype = dy.getString("storagetype");
        if (StorageTypeEnum.SHARE.index.equals(storagetype) && (icId = Long.valueOf(dy.getLong("copyfrom"))) == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6210\u5458\u4e0d\u5b58\u5728\u5b58\u50a8\u7c7b\u578b\u4e3a\u5b58\u50a8\u6216\u8005\u52a8\u6001\u8ba1\u7b97\u7684\u57fa\u672c\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u4fe1\u606f\u3002", (String)"InvShareRelaListPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        boolean isInvestDataExit = QueryServiceHelper.exists((String)"bcm_invsharerela", (QFilter[])new QFilter[]{new QFilter("investeecompany", "=", (Object)icId), new QFilter(SHARE_CASE, "=", (Object)this.invShareCaseF7Com.getShareCaseId())});
        boolean isInvestCTDataExit = QueryServiceHelper.exists((String)"bcm_invchangeentry", (QFilter[])new QFilter[]{new QFilter("investeecompany", "=", (Object)icId)});
        if (Boolean.TRUE.equals(isOnlyView.getRecord()) || Objects.nonNull(this.getPageCache().get(READ_ONLY_CASE))) {
            showParameter.setStatus(OperationStatus.VIEW);
        } else if (!isInvestDataExit && !isInvestCTDataExit) {
            showParameter.setStatus(OperationStatus.ADDNEW);
        } else {
            showParameter.setStatus(OperationStatus.EDIT);
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }

    private boolean validatorNode(Recorder<Boolean> isOnlyView) {
        IPageCache cache = this.getPageCache();
        String model = cache.get("KEY_MODEL_ID");
        String node = cache.get("nodeSelected");
        String tab = cache.get(TAB_SELECTED);
        if (model == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"InvShareRelaListPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (node == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u88ab\u6295\u8d44\u5355\u4f4d\u3002", (String)"InvShareRelaListPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,isleaf,number,storagetype,isindependentorg", (QFilter[])new QFilter("id", "=", (Object)LongUtil.toLong((Object)node)).toArray());
        if (TAB_SHARE_HOLDER.equals(tab)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u88ab\u6295\u8d44\u5355\u4f4d\u3002", (String)"InvShareRelaListPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!queryOne.getBoolean("isindependentorg") || queryOne.getString(NUMBER).equals("Entity")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u88ab\u6295\u8d44\u5355\u4f4d\u5fc5\u987b\u4e3a\u72ec\u7acb\u6cd5\u4eba\u516c\u53f8\u3002", (String)"InvShareRelaListPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.invShareCaseF7Com.getShareCaseId() == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5f53\u524d\u65b9\u6848\u3002", (String)"InvShareRelaListPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.checkOrgMemberIsOnlyRead(this.getPageCache().get("nodeSelected"))) {
            isOnlyView.setRecord((Object)true);
        }
        return true;
    }

    private void delRecord() {
        if (this.checkOrgMemberIsOnlyRead(this.getPageCache().get("nodeSelected")) || Objects.nonNull(this.getPageCache().get(READ_ONLY_CASE))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u5199\u5165\u6743\u9650\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"InvShareRelaListPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664\u5f53\u524d\u8282\u70b9\u6240\u6709\u6295\u8d44\u5173\u7cfb\uff1f", (String)"InvShareRelaListPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BTN_DELETE));
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        MessageBoxResult result;
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (BTN_DELETE.equals(callBackId) && (result = evt.getResult()) == MessageBoxResult.Yes) {
            String selectId = this.getPageCache().get("nodeSelected");
            DynamicObject queryOne = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"number,name", (QFilter[])new QFilter("id", "=", (Object)LongUtil.toLong((Object)selectId)).toArray());
            if (queryOne == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u64cd\u4f5c\u8bb0\u5f55\u3002", (String)"InvShareRelaListPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            QFBuilder qfBuilder = this.getIsolationQFilter();
            qfBuilder.and("investeecompany.number", "=", queryOne.get(NUMBER));
            DeleteServiceHelper.delete((String)"bcm_invsharerela", (QFilter[])qfBuilder.toArray());
            QFilter modelQF = new QFilter(MODEL, "=", (Object)this.getModelId());
            DeleteServiceHelper.delete((String)"bcm_invchangeentry", (QFilter[])new QFilter("investeecompany.number", "=", queryOne.get(NUMBER)).and(modelQF).toArray());
            this.writeOperationLog(this.getOperationDel(), queryOne.getString(NUMBER), queryOne.getString("name"), this.getOperationStstusSuccess());
            this.getView().updateView(BILLLIST_STAP);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        this.addNewEvent();
        ListSelectedRow currentRow = ((BillListHyperLinkClickEvent)arg0).getCurrentRow();
        QFilter qcf = new QFilter("id", "=", currentRow.getPrimaryKeyValue());
        DynamicObject data = QueryServiceHelper.queryOne((String)"bcm_invsharerela", (String)"shareholder.name,shareholder.number", (QFilter[])new QFilter[]{qcf});
        if (null != data) {
            this.writeOperationLog(this.getOperationView(), data.getString("shareholder.number"), data.getString("shareholder.name"), this.getOperationStstusSuccess());
        }
    }

    @Override
    public long getModelId() {
        DynamicObject modelDyn = (DynamicObject)this.getModel().getValue(MODEL);
        return modelDyn == null ? 0L : modelDyn.getLong("id");
    }
}

