/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.invest.InvSheetTemplateService;
import kd.fi.bcm.business.util.BCMNumberRule;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.constant.invest.sharerela.InvRelationTypeConstant;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.enums.invest.InvRelaTypeEnum;
import kd.fi.bcm.common.util.DataEntityUtils;
import kd.fi.bcm.common.util.KDAssert;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.BatchImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.impexport.BillResult;
import kd.fi.bcm.formplugin.invest.util.InvRelaTypeConfigUtil;
import kd.fi.bcm.formplugin.util.AdjustCatalogUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class InvSheetTemplatetSettingImportPlugin
extends BatchImportPlugin {
    public static final String SEPARATOR = "@@@";
    public static final String SHEETTEMPLATE = "sheettemplate";
    public static final String MYCOMPANY = "mycompany";
    public static final String INTERNALCOMPANY = "internalcompany";
    private static Log log = LogFactory.getLog(InvSheetTemplatetSettingImportPlugin.class);
    private static final String NUMBER = "number";
    private static final String MODEL = "model";
    private static final String FI_BCM_FORM_PLUGIN = "fi-bcm-formplugin";
    private long modelId;
    DynamicObject modelDy;
    DynamicObject sheettemplate;
    DynamicObject process;
    String templateNumber;
    Long templateId;
    List<Long> relationTypeList;
    String maxEntrySeq;
    Map<String, DynamicObject> dimMemberMaps;
    private String[] noDealDims = new String[]{"scenario", "model", "entity", "period", "year", "currency"};
    private String[] entityDims = new String[]{"process"};
    private final Map<String, String> userdefineMap2Nums = new HashMap<String, String>();
    private final Map<String, String> userdefineMap2fields = new HashMap<String, String>();

    public InvSheetTemplatetSettingImportPlugin() {
        this.userdefineMap2Nums.put("dim1", "userdefine1");
        this.userdefineMap2Nums.put("dim2", "userdefine2");
        this.userdefineMap2Nums.put("dim3", "userdefine3");
        this.userdefineMap2Nums.put("dim4", "userdefine4");
        this.userdefineMap2Nums.put("dim5", "userdefine5");
        this.userdefineMap2Nums.put("dim6", "userdefine6");
        this.userdefineMap2fields.put("userdefine1", "dim1");
        this.userdefineMap2fields.put("userdefine2", "dim2");
        this.userdefineMap2fields.put("userdefine3", "dim3");
        this.userdefineMap2fields.put("userdefine4", "dim4");
        this.userdefineMap2fields.put("userdefine5", "dim5");
        this.userdefineMap2fields.put("userdefine6", "dim6");
    }

    protected boolean isForceBatch() {
        return true;
    }

    protected int getBatchImportSize() {
        return 50000;
    }

    public void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
    }

    public ApiResult save(List<ImportBillData> importBillDataList, ImportLogger logger) {
        ApiResult result;
        if (logger.getFailed() != 0) {
            return this.failedBeforeSave(importBillDataList, logger);
        }
        try {
            this.intModelAndPermMap();
            Tuple<Table<String, String, EffectiveData>, List<EffectiveData>, Map<String, EffectiveData>> effectiveDataFromImport = this.getEffectiveData(importBillDataList, logger, this.modelId, "bcm_invsheetttplentrys");
            KDAssert.assertTrue((logger.getFailed() == 0 ? 1 : 0) != 0, () -> new KDBizException(this.getFailMsg()));
            Map<String, DynamicObject> dataFromDB = this.selectDataFromDB((Table<String, String, EffectiveData>)((Table)effectiveDataFromImport.p1));
            ImportOperateType importType = ImportHelper.getImportType(this.ctx);
            Set<DynamicObject> dataCollection = this.collectionData((Table<String, String, EffectiveData>)((Table)effectiveDataFromImport.p1), (List)effectiveDataFromImport.p2, dataFromDB, importType, logger);
            KDAssert.assertTrue((logger.getFailed() == 0 ? 1 : 0) != 0, () -> new KDBizException(this.getFailMsg()));
            DynamicObject[] entryEntity = this.doSave(dataCollection);
            result = this.buildResult((Table<String, String, EffectiveData>)((Table)effectiveDataFromImport.p1), entryEntity);
            this.logSuccess();
        }
        catch (KDBizException e) {
            log.error((Throwable)e);
            int lastFailRow = (Integer)logger.getLogCache().keySet().stream().max(Integer::compareTo).orElseThrow(() -> e);
            logger.log(Integer.valueOf(lastFailRow), e.getMessage()).setFailed(importBillDataList.size());
            result = new ApiResult();
            result.setSuccess(true);
            result.setData(Collections.emptyList());
            this.logFail();
        }
        return result;
    }

    private Map<String, DynamicObject> selectDataFromDB(Table<String, String, EffectiveData> effectiveDataFromImport) {
        Set allInvestedCompany = effectiveDataFromImport.rowKeySet();
        QFBuilder qfBuilder = new QFBuilder(MODEL, "=", (Object)this.modelId).and(SHEETTEMPLATE, "=", (Object)this.templateId).and(NUMBER, "in", (Object)allInvestedCompany);
        DynamicObjectCollection tpls = QueryServiceHelper.query((String)"bcm_invsheetttplentrys", (String)"id", (QFilter[])qfBuilder.toArray());
        List<Long> ids = tpls.stream().map(tpl -> tpl.getLong("id")).collect(Collectors.toList());
        DynamicObject[] tplDys = BusinessDataServiceHelper.load((Object[])ids.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_invsheetttplentrys"));
        return Arrays.stream(tplDys).collect(Collectors.toMap(dy -> dy.getString(NUMBER), dy -> dy, (v1, v2) -> v1));
    }

    private Set<DynamicObject> collectionData(Table<String, String, EffectiveData> effectiveDataMap, List<EffectiveData> effectiveDataList, Map<String, DynamicObject> dataFromDB, ImportOperateType importType, ImportLogger logger) {
        HashSet updateSet = new HashSet(16);
        HashSet addSet = new HashSet(16);
        HashSet<DynamicObject> resultSet = new HashSet<DynamicObject>();
        AtomicInteger maxSeq = new AtomicInteger(Integer.parseInt(this.maxEntrySeq));
        effectiveDataMap.cellSet().forEach(cell -> {
            DynamicObject dyfromdb;
            String key = (String)cell.getRowKey();
            EffectiveData data = (EffectiveData)cell.getValue();
            DynamicObject dynamicObject = dyfromdb = dataFromDB != null ? (DynamicObject)dataFromDB.get(key) : null;
            if (dyfromdb != null) {
                if (ImportOperateType.NEW == importType) {
                    String msg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u65b0\u589e\u3002", (String)"InvElimTemplatetImportPlugin_0", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
                    logger.logAll(Integer.valueOf(data.startIndex), new String[]{msg}).fail();
                } else {
                    DynamicObject dynamicObject2 = this.cvtDynamicObject((DynamicObject)dataFromDB.get(key), data.dataJson, data.dimdys, (dy, dataJson) -> this.cvtExtDimId(this.dimMemberMaps, (DynamicObject)dy, (JSONObject)dataJson));
                    updateSet.add(dynamicObject2);
                }
            } else {
                String substring;
                String msg;
                String number = data.data.getString(NUMBER);
                if (BCMNumberRule.checkNumber((String)number)) {
                    if (number.getBytes().length < 45) {
                        addSet.add(data.data);
                    } else {
                        msg = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5bfc\u5165\u5206\u5f55\u7f16\u7801\uff0c\u540d\u79f0\u4e0d\u8d85\u8fc745\u5b57\u7b26\u3002", (String)"InvSheetTemplatetSettingImportPlugin_3", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
                        logger.logAll(Integer.valueOf(data.startIndex), new String[]{msg}).fail();
                    }
                } else {
                    msg = ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"InvElimTemplatetImportPlugin_14", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
                    logger.logAll(Integer.valueOf(data.startIndex), new String[]{msg}).fail();
                }
                if (number.startsWith(this.templateNumber) && StringUtils.isNumeric((String)(substring = number.substring(this.templateNumber.length()))) && substring.length() == 3) {
                    maxSeq.set(Math.max(maxSeq.get(), Integer.parseInt(substring)));
                }
            }
        });
        resultSet.addAll(updateSet);
        if (ImportOperateType.OVERRIDE != importType) {
            if (CollectionUtils.isNotEmpty(effectiveDataList)) {
                effectiveDataList.stream().forEach(data -> {
                    String number = String.format("%03d", maxSeq.get());
                    maxSeq.getAndIncrement();
                    data.data.set(NUMBER, (Object)(this.templateNumber + number));
                    addSet.add(data.data);
                    effectiveDataMap.put((Object)(this.templateNumber + number), (Object)this.buildBizUniKey(data.data), data);
                });
            }
            resultSet.addAll(addSet);
        }
        return resultSet;
    }

    private ApiResult failedBeforeSave(List<ImportBillData> importBillDataList, ImportLogger logger) {
        int lastFailRow = logger.getLogCache().keySet().stream().max(Integer::compareTo).orElseGet(() -> 5);
        logger.log(Integer.valueOf(lastFailRow), this.getFailMsg()).setFailed(importBillDataList.size() + logger.getFailed());
        ApiResult result = new ApiResult();
        result.setSuccess(true);
        result.setData(Collections.emptyList());
        return result;
    }

    private String getFailMsg() {
        return ResManager.loadKDString((String)"\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u6309\u63d0\u793a\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"InvShareRelaImportNewPlugin_0", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
    }

    private DynamicObject[] doSave(Set<DynamicObject> data) {
        HashSet update = Sets.newHashSet();
        HashSet addNew = Sets.newHashSet();
        for (DynamicObject datum : data) {
            if (datum.getLong("id") == 0L) {
                addNew.add(datum);
                continue;
            }
            update.add(datum);
        }
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            DynamicObject[] dynamicObjects;
            if (!update.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])update.toArray(new DynamicObject[0]));
            }
            if (!addNew.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])addNew.toArray(new DynamicObject[0]));
            }
            DynamicObject[] dynamicObjectArray = dynamicObjects = data.toArray(new DynamicObject[0]);
            return dynamicObjectArray;
        }
        catch (Exception e) {
            try {
                tx.markRollback();
                log.error((Throwable)e);
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private ApiResult buildResult(Table<String, String, EffectiveData> effectiveData, DynamicObject[] entryEntity) {
        ArrayList<Map<String, Object>> billResults = new ArrayList<Map<String, Object>>(16);
        for (DynamicObject dynamicObject : entryEntity) {
            long id = dynamicObject.getLong("id");
            String rowKey = this.buildRowKey(dynamicObject);
            String bizkey = this.buildBizUniKey(dynamicObject);
            EffectiveData effectiveData1 = (EffectiveData)effectiveData.row((Object)rowKey).get(bizkey);
            BillResult billResult = new BillResult();
            billResult.setId(id);
            billResult.setIndex(effectiveData1.dataIndex);
            billResult.setSucess(true);
            billResults.add(billResult.toMap());
        }
        ApiResult result = new ApiResult();
        result.setSuccess(true);
        result.setData(billResults);
        return result;
    }

    private String buildRowKey(DynamicObject relation) {
        return relation.getString(NUMBER);
    }

    private String buildBizUniKey(DynamicObject dy) {
        return dy.getString("name") + SEPARATOR + dy.get(MODEL);
    }

    private void intModelAndPermMap() {
        try {
            Class<?> aClass = this.ctx.getClass();
            Field view = aClass.getDeclaredField("view");
            ReflectionUtils.makeAccessible((Field)view);
            IFormView formView = (IFormView)view.get(this.ctx);
            IFormView parentView = formView.getParentView();
            this.modelDy = (DynamicObject)parentView.getModel().getValue(MODEL);
            this.modelId = this.modelDy.getLong("id");
            this.sheettemplate = (DynamicObject)parentView.getModel().getValue(SHEETTEMPLATE);
            this.process = (DynamicObject)parentView.getModel().getValue("process");
            this.templateId = this.sheettemplate.getLong("id");
            this.templateNumber = this.sheettemplate.getString(NUMBER);
            this.relationTypeList = InvSheetTemplateService.getInvSheetTempRelationType((Long)this.templateId);
            DynamicObject[] tempRefExtdims = InvSheetTemplateService.getInvSheetAccLayout((Long)this.templateId);
            this.dimMemberMaps = Arrays.stream(tempRefExtdims).collect(Collectors.toMap(k -> k.getString(NUMBER), v -> v, (v1, v2) -> v1));
            this.maxEntrySeq = InvSheetTemplateService.getMaxEntrySeq((Long)this.modelId, (Long)this.templateId, (String)this.templateNumber);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private Tuple<Table<String, String, EffectiveData>, List<EffectiveData>, Map<String, EffectiveData>> getEffectiveData(List<ImportBillData> importBillDataList, ImportLogger logger, Long modelId, String entityName) {
        List<String> allDim = this.getAllDims(modelId);
        HashMultimap multimap = HashMultimap.create();
        HashSet<String> templateRelationNumbers = new HashSet<String>(16);
        HashSet<String> templateChangeTypeNumbers = new HashSet<String>(16);
        HashSet<String> templateElimCatalogNumbers = new HashSet<String>(16);
        importBillDataList.stream().map(ImportBillData::getData).forEach(data -> {
            JSONArray invelimtplentry = data.getJSONArray("invelimtplentry");
            this.collectionDimMember(allDim, multimap, (JSONObject)data, invelimtplentry);
            this.collectionRelationType((Set<String>)templateRelationNumbers, (Set<String>)templateChangeTypeNumbers, (JSONObject)data);
            Optional<String> number = Optional.ofNullable((JSONObject)data.get((Object)"adjustcatalog")).map(catalog -> catalog.getString(NUMBER));
            if (number.isPresent()) {
                templateElimCatalogNumbers.add(number.get());
            }
        });
        Map<String, Map<String, DynamicObject>> dbNumbers = this.dataFromDB(multimap, allDim);
        Map<String, DynamicObject> templateRelationTypeFromDB = this.templateRelationTypeFromDB(templateRelationNumbers, templateChangeTypeNumbers);
        Map<String, DynamicObject> templateElimCatalogFromDB = this.templateElimCatalogFromDB(templateElimCatalogNumbers);
        HashBasedTable effectiveDatas = HashBasedTable.create();
        HashMap bizDatas = new HashMap(16);
        ArrayList addNewEffectiveDatas = new ArrayList(16);
        ArrayList rowLogs = new ArrayList(16);
        List<String> entityDimList = Arrays.asList(this.entityDims);
        allDim.removeAll(Arrays.asList(this.noDealDims));
        allDim.removeAll(entityDimList);
        Map<String, InvRelaTypeConfigUtil> invRelaTypeConfig = InvRelaTypeConfigUtil.getInvRelaTypeConfig(modelId);
        AtomicInteger index = new AtomicInteger(0);
        importBillDataList.forEach(arg_0 -> this.lambda$getEffectiveData$17(index, invRelaTypeConfig, rowLogs, templateRelationTypeFromDB, templateElimCatalogFromDB, logger, allDim, dbNumbers, entityName, bizDatas, (Table)effectiveDatas, addNewEffectiveDatas, arg_0));
        return new Tuple((Object)effectiveDatas, addNewEffectiveDatas, bizDatas);
    }

    private void cvtExtDimId(Map<String, DynamicObject> dimMemberMaps, DynamicObject dy, JSONObject data) {
        String ruleexpr = data.getString("ruleexpr");
        String ruleexprdept = data.getString("ruleexprdept");
        if (Objects.nonNull(dimMemberMaps)) {
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)ruleexpr) && !ruleexpr.toLowerCase(Locale.ENGLISH).equals("bn")) {
                dy.set("ruleexpr", dimMemberMaps.get(ruleexpr).get("id"));
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)ruleexprdept) && !ruleexprdept.toLowerCase(Locale.ENGLISH).equals("bn")) {
                dy.set("ruleexprdept", dimMemberMaps.get(ruleexprdept).get("id"));
            }
        }
    }

    private void collectionRelationType(Set<String> templateRelationNumbers, Set<String> templateChangeTypeNumbers, JSONObject data) {
        String categorized = data.getString("categorized");
        if (InvRelationTypeConstant.CatalogEnum.relation.getCode().equals(categorized)) {
            templateRelationNumbers.add(data.getJSONObject("relationtype").getString(NUMBER));
        } else {
            templateChangeTypeNumbers.add(data.getJSONObject("relationtype").getString(NUMBER));
        }
    }

    private void collectionDimMember(List<String> allDim, HashMultimap multimap, JSONObject data, JSONArray invelimtplentry) {
        allDim.stream().forEach(dim -> {
            String dimValue;
            String dimLow = dim.toLowerCase(Locale.ENGLISH);
            String string = dimValue = data.getJSONObject(dimLow) != null ? data.getJSONObject(dimLow).getString(NUMBER) : null;
            if (org.apache.commons.lang3.StringUtils.isNotEmpty(dimValue)) {
                multimap.put((Object)dimLow, (Object)dimValue);
            }
            if (dim.equals(DimTypesEnum.DATASORT.getNumber().toLowerCase(Locale.ROOT))) {
                dimLow = "datasource";
            }
            for (Object json : invelimtplentry) {
                JSONObject finalJson = (JSONObject)json;
                String entryValue = finalJson.getJSONObject(dimLow) != null ? finalJson.getJSONObject(dimLow).getString(NUMBER) : null;
                if (!org.apache.commons.lang3.StringUtils.isNotEmpty(entryValue)) continue;
                dimValue = entryValue;
                multimap.put(dim, (Object)dimValue);
            }
        });
    }

    private Map<String, DynamicObject> templateElimCatalogFromDB(Set<String> templateElimCatalogNumbers) {
        if (CollectionUtils.isNotEmpty(templateElimCatalogNumbers)) {
            QFilter adjustCatalogFilter = AdjustCatalogUtil.getAdjustCatalogFilterWithPerm(this.modelId);
            return QueryServiceHelper.query((String)"bcm_templatecatalog", (String)"id,number", (QFilter[])new QFilter[]{adjustCatalogFilter}).stream().collect(Collectors.toMap(dy -> dy.getString(NUMBER), dy -> dy, (v1, v2) -> v2));
        }
        return Collections.emptyMap();
    }

    private Map<String, DynamicObject> templateRelationTypeFromDB(Set<String> templateRelationNumbers, Set<String> templateChangeTypeNumbers) {
        Map<String, DynamicObject> maps;
        QFilter qFilters;
        HashMap<String, DynamicObject> resultMap = new HashMap<String, DynamicObject>(16);
        if (CollectionUtils.isNotEmpty(templateRelationNumbers)) {
            qFilters = new QFilter(MODEL, "=", (Object)this.modelId).and(NUMBER, "in", templateRelationNumbers).and("categorized", "=", (Object)InvRelationTypeConstant.CatalogEnum.relation.getCode());
            maps = QueryServiceHelper.query((String)"bcm_invrelatype", (String)InvRelationTypeConstant.getSelectFields(), (QFilter[])new QFilter[]{qFilters}).stream().collect(Collectors.toMap(dy -> dy.getString(NUMBER) + "_" + dy.get("categorized"), dy -> dy, (v1, v2) -> v2));
            resultMap.putAll(maps);
        }
        if (CollectionUtils.isNotEmpty(templateChangeTypeNumbers)) {
            qFilters = new QFilter(MODEL, "=", (Object)this.modelId).and(NUMBER, "in", templateChangeTypeNumbers).and("categorized", "=", (Object)InvRelationTypeConstant.CatalogEnum.change_type.getCode());
            maps = QueryServiceHelper.query((String)"bcm_invrelatype", (String)InvRelationTypeConstant.getSelectFields(), (QFilter[])new QFilter[]{qFilters}).stream().collect(Collectors.toMap(dy -> dy.getString(NUMBER) + "_" + dy.get("categorized"), dy -> dy, (v1, v2) -> v2));
            resultMap.putAll(maps);
        }
        return resultMap;
    }

    private void validTemplateElimCatalog(Map<String, DynamicObject> templateElimCatalogFromDB, List<ImportLogger.ImportLog> rowLogs, Map<String, Map<String, DynamicObject>> dimDys, JSONObject dataEntity) {
        DynamicObject dynamicObject;
        String tplName = ResManager.loadKDString((String)"\u5206\u5f55\u5206\u7c7b", (String)"InvElimTemplatetImportPlugin_21", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        JSONObject adjustcatalog = (JSONObject)dataEntity.get((Object)"adjustcatalog");
        if (Optional.ofNullable(adjustcatalog).isPresent() && (dynamicObject = BatchImportHelper.doCheckNumberThenGet(rowLogs, dataEntity, "adjustcatalog", tplName, templateElimCatalogFromDB, dy -> {})) != null) {
            Map<String, DynamicObject> dimMap = dimDys.get("adjustcatalog");
            if (dimMap == null) {
                dimMap = new HashMap<String, DynamicObject>(16);
            }
            dimMap.put(dynamicObject.getString(NUMBER), dynamicObject);
            dimDys.put("adjustcatalog", dimMap);
        }
    }

    private void validEntity(JSONObject data, List<ImportLogger.ImportLog> entryRowLogs, Boolean adjustment) {
        String entityComb = data.getString("entitycomb");
        if (adjustment.booleanValue() && !entityComb.equals("1")) {
            entryRowLogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8c03\u6574\u7c7b\u6a21\u677f\uff0c\u201c\u7ec4\u7ec7\u201d\u5b57\u6bb5\u53ea\u80fd\u9009\u62e9\u6295\u8d44\u5355\u4f4d\u3002", (String)"InvElimTemplatetImportPlugin_7", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0])));
        }
    }

    private void validInvrelaType(Map<String, InvRelaTypeConfigUtil> invRelaTypeConfig, List<ImportLogger.ImportLog> rowLogs, JSONObject dataEntity, Map<String, DynamicObject> templateRelationTypeFromDB) {
        String invrelatype = dataEntity.getJSONObject("relationtype").getString(NUMBER);
        String categorized = dataEntity.getString("categorized");
        if (InvRelationTypeConstant.CatalogEnum.relation.getCode().equals(categorized) && invRelaTypeConfig.get(invrelatype) != null && !invRelaTypeConfig.get(invrelatype).getInUse().booleanValue()) {
            String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u6301\u80a1\u7c7b\u578b\u3010%s\u3011\u4e0d\u53ef\u7528\u3002", (String)"InvElimTemplatetImportPlugin_8", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), InvRelaTypeEnum.valueof((String)invrelatype).getDesc());
            rowLogs.add(new ImportLogger.ImportLog(msg));
            return;
        }
        DynamicObject relationTypeDy = templateRelationTypeFromDB.get(invrelatype + "_" + categorized);
        if (Objects.isNull(relationTypeDy)) {
            String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u6301\u80a1\u7c7b\u578b\u3010%s\u3011\u4e0d\u5b58\u5728\u3002", (String)"InvElimTemplatetImportPlugin_15", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), invrelatype);
            rowLogs.add(new ImportLogger.ImportLog(msg));
            return;
        }
        if (!this.relationTypeList.contains(relationTypeDy.getLong("id"))) {
            String msg = String.format(ResManager.loadKDString((String)"\u6301\u80a1\u7c7b\u578b\u3010%s\u3011\u672a\u5173\u8054\u5f53\u524d\u6a21\u677f\u3002", (String)"InvSheetTemplatetSettingImportPlugin_2", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), invrelatype);
            rowLogs.add(new ImportLogger.ImportLog(msg));
            return;
        }
        if (!OrgRelaProcessMembPool.isRelaProcess((String)this.process.getString(NUMBER)) && !InvRelaTypeEnum.DirectRelaType.getType().equals(invrelatype)) {
            rowLogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5355\u4f53\u8fc7\u7a0b\u5e95\u7a3f\u53ea\u80fd\u9009\u62e9\u76f4\u63a5\u6301\u80a1\u7c7b\u578b", (String)"InvSheetTemplatetSettingImportPlugin_9", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0])));
            return;
        }
        dataEntity.put("relationtype", (Object)relationTypeDy.getLong("id"));
    }

    private List<String> getAllDims(Long modelId) {
        List<String> allDim = DimensionServiceHelper.getDimensionNumMapped((Object)modelId).values().stream().map(dim -> {
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.userdefineMap2Nums.get(dim))) {
                dim = this.userdefineMap2Nums.get(dim);
            }
            return dim;
        }).collect(Collectors.toList());
        return allDim;
    }

    private void validRuleexpr(JSONObject data, List<ImportLogger.ImportLog> rowLogs, AtomicInteger index, Map<String, DynamicObject> extDimMemberFromDB) {
        String ruleexpr = data.getString("ruleexpr");
        String ruleexprdept = data.getString("ruleexprdept");
        boolean isCreditBlank = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)ruleexpr);
        boolean isDebitBlank = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)ruleexprdept);
        String val = null;
        if (!(isCreditBlank ^ isDebitBlank)) {
            String msg = ResManager.loadKDString((String)"\u501f\u8d37\u65b9\u4e0d\u80fd\u540c\u65f6\u8d4b\u503c\u6216\u8005\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"InvSheetTemplatetSettingImportPlugin_8", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
            rowLogs.add(new ImportLogger.ImportLog(msg));
            return;
        }
        val = isCreditBlank ? ruleexprdept : ruleexpr;
        try {
            if ("bn".equalsIgnoreCase(val) && index.getAndIncrement() > 0) {
                rowLogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5206\u7ec4\u5185\u53ea\u80fd\u51fa\u73b0\u4e00\u4e2a\u5e73\u8861\u6570\u3002", (String)"InvelimTemplatePlugin_11", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0])));
                return;
            }
        }
        catch (Throwable t) {
            rowLogs.add(new ImportLogger.ImportLog(AdjustmentServiceHelper.toString_Adj((Throwable)t)));
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)ruleexpr) || org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)ruleexprdept)) {
            String ruleexprSoruce = "";
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)ruleexpr)) {
                ruleexprSoruce = ruleexpr;
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)ruleexprdept)) {
                ruleexprSoruce = ruleexprdept;
            }
            if (Objects.isNull(this.dimMemberMaps) || !this.dimMemberMaps.containsKey(ruleexprSoruce) && !ruleexprSoruce.toLowerCase(Locale.ENGLISH).equals("bn")) {
                String msg = String.format(ResManager.loadKDString((String)"\u5173\u8054\u62d3\u5c55\u7ef4\u6210\u5458\u3010%s\u3011\u672a\u5728\u6a21\u677f\u5e03\u5c40\u4e2d\u914d\u7f6e", (String)"InvElimTemplatetImportPlugin_20", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), ruleexprSoruce);
                rowLogs.add(new ImportLogger.ImportLog(msg));
                return;
            }
        }
    }

    private void validDimMember(List<String> allDim, Map<String, Map<String, DynamicObject>> dbNumberS, List<ImportLogger.ImportLog> rowLogs, Map<String, Map<String, DynamicObject>> dimDys, JSONObject data) {
        Map userName = DimensionServiceHelper.getUserDefineDimensionNumAndNameByModel((Object)this.modelId, (boolean)false);
        Map numMapped = DimensionServiceHelper.getDimensionNumMapped((Object)this.modelId);
        allDim.stream().forEach(dim -> {
            AtomicReference<String> dimName = new AtomicReference<String>("");
            String finalDim = dim;
            if (this.userdefineMap2fields.containsKey(dim)) {
                numMapped.entrySet().forEach(e -> {
                    if (((String)e.getValue()).equals(this.userdefineMap2fields.get(finalDim))) {
                        dimName.set((String)userName.get(e.getKey()));
                    }
                });
            } else {
                dimName.set(DimTypesEnum.getDimTypesEnumByNumber((String)dim).getName());
            }
            if (dim.equals(DimTypesEnum.DATASORT.getNumber().toLowerCase(Locale.ROOT))) {
                dim = "datasource";
            }
            Map dynamicObjectMap = (Map)dbNumberS.get(dim);
            DynamicObject dynamicObject = BatchImportHelper.doCheckNumberThenGet(rowLogs, data, dim, dimName.get(), dynamicObjectMap, dy -> {
                if (!(Arrays.asList(this.entityDims).contains(finalDim) || finalDim.equals(DimTypesEnum.ACCOUNT.getNumber().toLowerCase(Locale.ROOT)) || dy.getBoolean("isleaf"))) {
                    String msg = String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4fe1\u606f\u3010%s\u3011\u4e0d\u80fd\u4e3a\u975e\u660e\u7ec6\u6210\u5458\u3002", (String)"InvElimTemplatetImportPlugin_5", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), dimName);
                    rowLogs.add(new ImportLogger.ImportLog(msg));
                }
            });
            if (dynamicObject != null) {
                HashMap<String, DynamicObject> dimMap = (HashMap<String, DynamicObject>)dimDys.get(dim);
                if (dimMap == null) {
                    dimMap = new HashMap<String, DynamicObject>(16);
                }
                dimMap.put(dynamicObject.getString(NUMBER), dynamicObject);
                dimDys.put((String)dim, (Map<String, DynamicObject>)dimMap);
            }
        });
    }

    private DynamicObject cvtDynamicObject(DynamicObject dynamicObject, JSONObject data, Map<String, Map<String, DynamicObject>> dimDys, BiConsumer<Object, Object> otherCvt) {
        DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
        properties.stream().forEach(field -> {
            String name = field.getName();
            if (name.equals(MODEL)) {
                dynamicObject.set(MODEL, (Object)this.modelDy.getLong("id"));
            } else if (name.equals(SHEETTEMPLATE)) {
                dynamicObject.set(SHEETTEMPLATE, (Object)this.sheettemplate.getLong("id"));
            } else if (dimDys.get(name) != null) {
                dynamicObject.set(name, ((DynamicObject)((Map)dimDys.get(name)).get(((JSONObject)data.get((Object)name)).getString(NUMBER))).get("id"));
            } else if (name.equals("creator") || name.equals("modifier")) {
                Date now = TimeServiceHelper.now();
                long currUserId = RequestContext.get().getCurrUserId();
                dynamicObject.set("creator", (Object)currUserId);
                dynamicObject.set("createtime", (Object)now);
                dynamicObject.set("modifier", (Object)currUserId);
                dynamicObject.set("modifytime", (Object)now);
            } else if (field instanceof EntryProp) {
                DynamicObjectCollection entryDyCol = dynamicObject.getDynamicObjectCollection(name);
                entryDyCol.clear();
                JSONArray entryJsons = (JSONArray)data.get((Object)name);
                if (CollectionUtils.isNotEmpty((Collection)entryJsons)) {
                    for (int i = 0; i < entryJsons.size(); ++i) {
                        JSONObject entryData = (JSONObject)entryJsons.get(i);
                        DynamicObject entryDynamicObject = entryDyCol.addNew();
                        entryDynamicObject.set("Seq", (Object)(i + 1));
                        this.cvtDynamicObject(entryDynamicObject, entryData, dimDys, otherCvt);
                    }
                }
                dynamicObject.set(name, (Object)entryDyCol);
            } else if (field instanceof MuliLangTextProp) {
                Object map = data.get((Object)name);
                if (Objects.nonNull(map)) {
                    dynamicObject.set(name, map);
                }
            } else if (data.get((Object)name) != null) {
                dynamicObject.set(name, data.get((Object)name));
            }
        });
        if (Objects.nonNull(otherCvt)) {
            otherCvt.accept(dynamicObject, data);
        }
        return dynamicObject;
    }

    private void collectEffectiveData(EffectiveData effectiveData, ImportLogger logger, Map<String, EffectiveData> bizDatas, Table<String, String, EffectiveData> dataMap, List<EffectiveData> addNewData) {
        String rowKey = this.buildRowKey(effectiveData.data);
        String bizKey = this.buildBizUniKey(effectiveData.data);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)rowKey)) {
            addNewData.add(effectiveData);
            return;
        }
        Map row = dataMap.row((Object)rowKey);
        if (row.isEmpty()) {
            dataMap.put((Object)rowKey, (Object)bizKey, (Object)effectiveData);
        } else {
            int startIndex = effectiveData.startIndex;
            int startIndex1 = row.values().stream().map(v -> v.startIndex).findFirst().get();
            String msg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u884c\u4e0e\u7b2c%1$s\u884c\u7f16\u7801\u76f8\u540c\u3002", (String)"InvElimTemplatetImportPlugin_13", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), startIndex1 + 1);
            logger.log(Integer.valueOf(startIndex), msg).fail();
        }
    }

    private Map<String, Map<String, DynamicObject>> dataFromDB(HashMultimap multimap, List<String> allDim) {
        KDAssert.assertFalse((this.modelId == 0L ? 1 : 0) != 0, () -> new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u4f53\u7cfb\u5f02\u5e38\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"InvShareRelaImportNewPlugin_17", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0])));
        HashMap<String, Map<String, DynamicObject>> dimDatas = new HashMap<String, Map<String, DynamicObject>>(16);
        allDim.stream().forEach(dim -> {
            String dimLow = dim.toLowerCase(Locale.ENGLISH);
            Set set = multimap.get((Object)dimLow);
            if (CollectionUtils.isNotEmpty((Collection)set)) {
                QFilter qFilters = new QFilter(MODEL, "=", (Object)this.modelId).and(NUMBER, "in", (Object)set);
                String entityNum = DimensionServiceHelper.getDimMembEntityNumByDimNum((String)dimLow);
                if (DataEntityUtils.isIncludeShareField((String)entityNum)) {
                    qFilters.and(new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex()));
                }
                if (MYCOMPANY.equals(dimLow) || INTERNALCOMPANY.equals(dimLow)) {
                    qFilters.or(NUMBER, "in", (Object)new String[]{SystemVarsEnum.MC_INV_UNIT.getNumber(), SystemVarsEnum.MC_SUB_UNIT.getNumber()});
                }
                if ("account".equals(dimLow)) {
                    qFilters.and(QFilter.of((String)"accountpart.isaccountoffset = ?", (Object[])new Object[]{true}));
                    qFilters.and(QFilter.of((String)"storagetype != ?", (Object[])new Object[]{"3"}));
                    qFilters.and(QFilter.of((String)"isleaf =?", (Object[])new Object[]{"1"}));
                }
                if ("audittrail".equals(dimLow)) {
                    qFilters.and("datasource", "=", (Object)"3");
                }
                Map<String, DynamicObject> dimValues = QueryServiceHelper.query((String)entityNum, (String)InvSheetTemplatetSettingImportPlugin.getDimField(dimLow), (QFilter[])new QFilter[]{qFilters}).stream().collect(Collectors.toMap(dy -> dy.getString(NUMBER), dy -> dy, (v1, v2) -> v2));
                if (dim.equals(DimTypesEnum.DATASORT.getNumber().toLowerCase(Locale.ROOT))) {
                    dimLow = "datasource";
                }
                dimDatas.put(dimLow, dimValues);
            }
        });
        return dimDatas;
    }

    public static String getDimField(String dimNum) {
        switch (dimNum.toLowerCase(Locale.ENGLISH)) {
            case "entity": {
                return "id,name,number,currency,isindependentorg,isleaf";
            }
            case "internalcompany": {
                return "id,name,number,longnumber,isleaf";
            }
        }
        return "id,name,number,isleaf";
    }

    private void logSuccess() {
        String f7Msg = String.format(ResManager.loadKDString((String)"%1$s\u6a21\u677f", (String)"InvSheetTemplatetSettingImportPlugin_7", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), this.templateNumber);
        String desc = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6743\u76ca\u5e95\u7a3f\u6a21\u677f\u5206\u5f55\u6210\u529f\u3002", (String)"InvSheetTemplatetSettingImportPlugin_6", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), new Object[0]);
        this.writeOperationLog(f7Msg, desc);
    }

    private void logFail() {
        String f7Msg = String.format(ResManager.loadKDString((String)"%1$s\u6a21\u677f", (String)"InvSheetTemplatetSettingImportPlugin_7", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), this.templateNumber);
        String desc = ResManager.loadKDString((String)"\u5bfc\u5165\u6743\u76ca\u5e95\u7a3f\u6a21\u677f\u5206\u5f55\u5931\u8d25\u3002", (String)"InvSheetTemplatetSettingImportPlugin_5", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        this.writeOperationLog(f7Msg, desc);
    }

    public void writeOperationLog(String f7Msg, String msgDesc) {
        String opName = ResManager.loadKDString((String)"\u5bfc\u5165", (String)"InvSheetTemplatetSettingImportPlugin_4", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((String)opName, (String)(f7Msg + msgDesc), this.modelDy == null ? null : (Long)this.modelDy.getPkValue(), (String)"bcm_invsheetttplentrys");
        logService.addLog(logInfo);
    }

    private /* synthetic */ void lambda$getEffectiveData$17(AtomicInteger index, Map invRelaTypeConfig, List rowLogs, Map templateRelationTypeFromDB, Map templateElimCatalogFromDB, ImportLogger logger, List allDim, Map dbNumbers, String entityName, Map bizDatas, Table effectiveDatas, List addNewEffectiveDatas, ImportBillData importBillData) {
        index.set(0);
        JSONObject dataEntity = importBillData.getData();
        this.validInvrelaType(invRelaTypeConfig, rowLogs, dataEntity, templateRelationTypeFromDB);
        HashMap<String, Map<String, DynamicObject>> dimDys = new HashMap<String, Map<String, DynamicObject>>(16);
        this.validTemplateElimCatalog(templateElimCatalogFromDB, rowLogs, dimDys, dataEntity);
        if (CollectionUtils.isNotEmpty((Collection)rowLogs)) {
            logger.logAll(Integer.valueOf(importBillData.getStartIndex()), rowLogs).fail();
            return;
        }
        JSONArray invelimtplentry = dataEntity.getJSONArray("invelimtplentry");
        int logIndex = 0;
        boolean isPass = true;
        for (Object json : invelimtplentry) {
            JSONObject data2 = (JSONObject)json;
            ArrayList<ImportLogger.ImportLog> entryRowLogs = new ArrayList<ImportLogger.ImportLog>(16);
            this.validDimMember(allDim, dbNumbers, entryRowLogs, dimDys, data2);
            this.validRuleexpr(data2, entryRowLogs, index, this.dimMemberMaps);
            this.validEntity(data2, entryRowLogs, !OrgRelaProcessMembPool.isRelaProcess((String)this.process.getString(NUMBER)));
            if (!entryRowLogs.isEmpty()) {
                isPass = false;
                if (logIndex == 0) {
                    rowLogs.addAll(entryRowLogs);
                } else {
                    logger.logAll(Integer.valueOf(importBillData.getStartIndex() + logIndex), entryRowLogs).fail();
                }
                entryRowLogs.clear();
            }
            ++logIndex;
        }
        if (isPass) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
            dynamicObject = this.cvtDynamicObject(dynamicObject, dataEntity, dimDys, (dy, data) -> this.cvtExtDimId(this.dimMemberMaps, (DynamicObject)dy, (JSONObject)data));
            EffectiveData effectiveData = new EffectiveData(importBillData.getDataIndex(), importBillData.getStartIndex(), dynamicObject, dataEntity, dimDys);
            this.collectEffectiveData(effectiveData, logger, bizDatas, (Table<String, String, EffectiveData>)effectiveDatas, addNewEffectiveDatas);
        } else {
            logger.logAll(Integer.valueOf(importBillData.getStartIndex()), rowLogs).fail();
            rowLogs.clear();
        }
    }

    private static class EffectiveData {
        final int dataIndex;
        final int startIndex;
        final DynamicObject data;
        final Map<String, Map<String, DynamicObject>> dimdys;
        public JSONObject dataJson;

        public EffectiveData(int dataIndex, int startIndex, DynamicObject data, JSONObject dataJson, Map<String, Map<String, DynamicObject>> dimdys) {
            this.dataIndex = dataIndex;
            this.startIndex = startIndex;
            this.data = data;
            this.dimdys = dimdys;
            this.dataJson = dataJson;
        }
    }
}

