/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.formula.model.VFormula;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaParseHelper;
import kd.fi.bcm.business.invest.sheet.formula.handler.VFormulaHandler;
import kd.fi.bcm.business.page.model.Area;
import kd.fi.bcm.business.page.model.BaseEditElement;
import kd.fi.bcm.business.page.model.ComboEditElement;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.MultiBaseEditElement;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.invest.InvCurrencyType;
import kd.fi.bcm.common.enums.invest.InvFsfetchType;
import kd.fi.bcm.common.enums.invest.InvOrgType;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import kd.fi.bcm.spread.formula.expr.StringExpr;

public class InvVFormulaPlugin
extends AbstractBaseFormPlugin
implements DynamicPage {
    private SchemeContext sctx;
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String COMBO_ORG = "comboorg";
    private static final String COMBO_IC = "comboic";
    private static final String COMBO_MYORG = "combomyorg";
    private static final String COMBO_CURRENCY = "combcurrency";
    private static final String COMBO_FSCONFIG = "combofsconfig";
    private static final String RELA_CSL = "relacsl";
    private static final String NUMBER = "number";
    private static final String MODEL = "model";
    private static final String IS_DRAFT = "is_draft";
    private static final String PRE_FIX = "$";
    private static final String DIRECT_SUPER = "DIRECTSUPER";
    private static final String COMMON_PARENT = "COMMONPARENT";
    private static final Map<String, String> comboKeyToName = new LinkedHashMap<String, String>(16);

    public InvVFormulaPlugin() {
        comboKeyToName.put(COMBO_ORG, ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"InvVFormulaPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        comboKeyToName.put(COMBO_IC, ResManager.loadKDString((String)"\u5f80\u6765\u7ec4\u7ec7", (String)"InvVFormulaPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        comboKeyToName.put(COMBO_MYORG, ResManager.loadKDString((String)"\u6211\u65b9\u7ec4\u7ec7", (String)"InvVFormulaPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        comboKeyToName.put(COMBO_CURRENCY, ResManager.loadKDString((String)"\u5e01\u79cd", (String)"InvVFormulaPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        comboKeyToName.put(COMBO_FSCONFIG, ResManager.loadKDString((String)"\u53d6\u6570\u4f4d\u7f6e", (String)"InvVFormulaPlugin_13", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String ctrlKey = e.getKey();
        if (ctrlKey.startsWith("bcm_")) {
            String dimKey = ctrlKey.replace("bcm_", "");
            Dimension dim = this.getSctx().getDimensionByField(dimKey);
            if (dim != null) {
                BasedataEditSingleMemberF7 sf7 = SingleMemberF7Util.createBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), dim.getId(), ctrlKey, this, false, SingleF7TypeEnum.COMMON);
                sf7.setF7title(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9", (String)"GetJLEntryFormulaPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                sf7.setDisplayAllFyOrPeriodMemb(true);
                sf7.addBeforeF7SelectListener(this);
                e.setControl((Control)sf7);
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        if (e.getSource() instanceof BasedataEditSingleMemberF7) {
            BasedataEditSingleMemberF7 sf7 = (BasedataEditSingleMemberF7)((Object)e.getSource());
            e.getCustomQFilters().add(new QFilter("model.id", "=", (Object)this.getModelId()));
            if ("bcm_userdefinedmembertree".equals(sf7.getEntity())) {
                e.getCustomQFilters().add(new QFilter("dimension.id", "=", (Object)sf7.getDimId()));
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.createSingleF7Area();
        this.refreshFomulaValue();
        this.setEnableLock();
    }

    private void createSingleF7Area() {
        Area area = new Area("membfieldpanel");
        for (Object p2 : this.getSctx().getDimensions()) {
            if ("Entity".equals(p2.getNumber()) || "InternalCompany".equals(p2.getNumber()) || "MyCompany".equals(p2.getNumber()) || "Currency".equals(p2.getNumber())) continue;
            BaseEditElement dimElement = new BaseEditElement(p2.getName(), "bcm_" + p2.getFieldmapped(), p2.getEntity());
            dimElement.setStyle(this.createMarginStyle());
            dimElement.setDisplayProp("number,name");
            dimElement.setNumber(p2.getNumber());
            if ("Scenario".equals(p2.getNumber()) || "Year".equals(p2.getNumber()) || "Period".equals(p2.getNumber()) || "Process".equals(p2.getNumber())) {
                dimElement.setMustInput(Boolean.FALSE.booleanValue());
            } else {
                dimElement.setMustInput(Boolean.TRUE.booleanValue());
            }
            area.addElement((Element)dimElement);
        }
        for (Map.Entry entry : comboKeyToName.entrySet()) {
            if (COMBO_MYORG.equalsIgnoreCase((String)entry.getKey()) && !this.getSctx().getNumberMap().containsKey("MyCompany") || COMBO_IC.equalsIgnoreCase((String)entry.getKey()) && !this.getSctx().getNumberMap().containsKey("InternalCompany")) continue;
            ComboEditElement computeTypeElement = new ComboEditElement((String)entry.getKey(), (String)entry.getValue(), this.getComboItems(null, (String)entry.getKey()));
            computeTypeElement.setStyle(this.createMarginStyle());
            computeTypeElement.setMustinput(!COMBO_FSCONFIG.equalsIgnoreCase((String)entry.getKey()));
            area.addElement((Element)computeTypeElement);
        }
        MultiBaseEditElement mutiBaseDataEdit = new MultiBaseEditElement(ResManager.loadKDString((String)"\u5173\u8054\u89c6\u56fe", (String)"InvVFormulaPlugin_18", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), RELA_CSL, "bcm_cslscheme");
        mutiBaseDataEdit.setStyle(this.createMarginStyle());
        area.addElement((Element)mutiBaseDataEdit);
        area.getElementListList().forEach(p -> {
            p.setLabelDirection("v");
            p.setLabelWidth(new LocaleString("100%"));
        });
        Page page = new Page();
        page.addArea(area);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
    }

    private void refreshFomulaValue() {
        String formula = (String)this.getFormCustomParam("formula");
        if (StringUtils.isNotEmpty((CharSequence)formula)) {
            try {
                FunctionExpr expr = (FunctionExpr)ExcelFormulaPaserHelper.parse((String)formula);
                for (Object param : expr.getParameters()) {
                    DynamicObject memeDy;
                    IDNumberTreeNode node;
                    String valStr;
                    String paramStr = InvestFormulaParseHelper.handelParam(param);
                    String[] dim2Mem = VFormula.splitDimAndMemb((String)paramStr);
                    if (dim2Mem.length != 2) continue;
                    if ("RC".equalsIgnoreCase(dim2Mem[0])) {
                        if (StringUtils.isBlank((CharSequence)dim2Mem[1])) continue;
                        DynamicObjectCollection relaCsls = (DynamicObjectCollection)this.getModel().getValue(RELA_CSL);
                        Arrays.stream(BusinessDataServiceHelper.load((String)"bcm_cslscheme", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)this.getModelId()), new QFilter(NUMBER, "in", (Object)dim2Mem[1].split("\\|"))}, null, (int)-1)).forEach(pk -> relaCsls.addNew().set("fbasedataid", pk));
                        this.setValue(RELA_CSL, relaCsls);
                        continue;
                    }
                    if ("FS".equalsIgnoreCase(dim2Mem[0])) {
                        this.setValue(COMBO_FSCONFIG, this.getFsComboKey(dim2Mem[1]));
                        continue;
                    }
                    Dimension p = this.getSctx().getDimensionByShortNum(dim2Mem[0]);
                    if (p == null) continue;
                    if ("Entity".equals(p.getNumber())) {
                        valStr = this.getComboKey(dim2Mem[1]);
                        if ("4".equals(valStr)) {
                            node = BcmThreadCache.findMemberByNum((String)this.getCurModelNumber(), (String)p.getNumber(), (String)dim2Mem[1]);
                            memeDy = BusinessDataServiceHelper.newDynamicObject((String)p.getEntity());
                            memeDy.set("id", (Object)node.getId());
                            memeDy.set(NUMBER, (Object)node.getNumber());
                            memeDy.set("name", (Object)node.getName());
                            this.rebuildComboEdit(COMBO_ORG, memeDy);
                            valStr = node.getNumber();
                        }
                        this.setValue(COMBO_ORG, valStr);
                        continue;
                    }
                    if ("InternalCompany".equals(p.getNumber())) {
                        valStr = this.getComboKey(dim2Mem[1]);
                        if ("4".equals(valStr)) {
                            node = BcmThreadCache.findMemberByNum((String)this.getCurModelNumber(), (String)p.getNumber(), (String)dim2Mem[1]);
                            memeDy = BusinessDataServiceHelper.newDynamicObject((String)p.getEntity());
                            memeDy.set("id", (Object)node.getId());
                            memeDy.set(NUMBER, (Object)node.getNumber());
                            memeDy.set("name", (Object)node.getName());
                            this.rebuildComboEdit(COMBO_IC, memeDy);
                            valStr = node.getNumber();
                        }
                        this.setValue(COMBO_IC, valStr);
                        continue;
                    }
                    if ("MyCompany".equals(p.getNumber())) {
                        valStr = this.getComboKey(dim2Mem[1]);
                        if ("4".equals(valStr)) {
                            node = BcmThreadCache.findMemberByNum((String)this.getCurModelNumber(), (String)p.getNumber(), (String)dim2Mem[1]);
                            memeDy = BusinessDataServiceHelper.newDynamicObject((String)p.getEntity());
                            memeDy.set("id", (Object)node.getId());
                            memeDy.set(NUMBER, (Object)node.getNumber());
                            memeDy.set("name", (Object)node.getName());
                            this.rebuildComboEdit(COMBO_MYORG, memeDy);
                            valStr = node.getNumber();
                        }
                        this.setValue(COMBO_MYORG, valStr);
                        continue;
                    }
                    if ("Currency".equals(p.getNumber())) {
                        valStr = this.getCYComboKey(dim2Mem[1]);
                        if ("7".equals(valStr)) {
                            node = BcmThreadCache.findMemberByNum((String)this.getCurModelNumber(), (String)p.getNumber(), (String)dim2Mem[1]);
                            memeDy = BusinessDataServiceHelper.newDynamicObject((String)p.getEntity());
                            memeDy.set("id", (Object)node.getId());
                            memeDy.set(NUMBER, (Object)node.getNumber());
                            memeDy.set("name", (Object)node.getName());
                            this.rebuildComboEdit(COMBO_CURRENCY, memeDy);
                            valStr = node.getNumber();
                        }
                        this.setValue(COMBO_CURRENCY, valStr);
                        continue;
                    }
                    IDNumberTreeNode memeNode = MemberReader.findMemberByNumber((String)this.getSctx().getModelNumber(), (String)p.getNumber(), (String)dim2Mem[1]);
                    if (memeNode == IDNumberTreeNode.NotFoundTreeNode) continue;
                    DynamicObject o = BusinessDataServiceHelper.newDynamicObject((String)p.getEntity());
                    o.set("id", (Object)memeNode.getId());
                    o.set("name", (Object)memeNode.getName());
                    o.set(NUMBER, (Object)memeNode.getNumber());
                    this.setValue("bcm_" + p.getFieldmapped(), o);
                }
            }
            catch (Exception e1) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u65e0\u6548\u516c\u5f0f\u3002", (String)"GetJLEntryFormulaPlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), formula));
            }
        } else {
            this.setValue(COMBO_FSCONFIG, this.getFsComboKey(DIRECT_SUPER));
        }
    }

    private Style createMarginStyle() {
        Style style = new Style();
        Margin margin = new Margin();
        margin.setTop("1px");
        margin.setLeft("60px");
        margin.setBottom("15px");
        style.setMargin(margin);
        return style;
    }

    private SchemeContext getSctx() {
        if (this.sctx == null) {
            this.sctx = new SchemeContext(this.getModelId());
        }
        return this.sctx;
    }

    private void setEnableLock() {
        String enableStatus;
        if (this.getFormCustomParam("enable") != null && "C".equals(enableStatus = (String)this.getFormCustomParam("enable"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bcm_invvformula"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("confirm".equals(operateKey)) {
            DynamicObjectCollection rela_Csls;
            ArrayList valueList = Lists.newArrayList();
            String val = null;
            for (Dimension p : this.getSctx().getDimensions()) {
                val = null;
                if ("Entity".equals(p.getNumber())) {
                    if (this.getValue(COMBO_ORG) != null) {
                        val = this.getComboMembNumber((String)this.getValue(COMBO_ORG));
                    }
                } else if ("InternalCompany".equals(p.getNumber())) {
                    if (this.getValue(COMBO_IC) != null) {
                        val = this.getComboMembNumber((String)this.getValue(COMBO_IC));
                    }
                } else if ("MyCompany".equals(p.getNumber())) {
                    if (this.getValue(COMBO_MYORG) != null) {
                        val = this.getComboMembNumber((String)this.getValue(COMBO_MYORG));
                    }
                } else if ("Currency".equals(p.getNumber())) {
                    if (this.getValue(COMBO_CURRENCY) != null) {
                        val = this.getCYComboMembNumber((String)this.getValue(COMBO_CURRENCY));
                    }
                } else {
                    DynamicObject dyna = this.getModel().getDataEntity().getDynamicObject("bcm_" + p.getFieldmapped());
                    if (dyna != null) {
                        val = dyna.getString(NUMBER);
                    }
                }
                if (val == null) {
                    if ("Scenario".equalsIgnoreCase(p.getNumber()) || "Year".equalsIgnoreCase(p.getNumber()) || "Period".equalsIgnoreCase(p.getNumber()) || "Process".equalsIgnoreCase(p.getNumber())) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvVFormulaPlugin_21", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), p.getName()));
                }
                valueList.add(new StringExpr(VFormulaHandler.packDimAndMemb((String)p.getShortnum(), (String)val)));
            }
            String keyFS = (String)this.getModel().getValue(COMBO_FSCONFIG);
            if (StringUtils.isNotEmpty((CharSequence)keyFS)) {
                valueList.add(new StringExpr(VFormulaHandler.packDimAndMemb((String)"FS", (String)this.getFSComboMembNumber(keyFS))));
            }
            if (!CollectionUtil.isEmpty((Collection)(rela_Csls = (DynamicObjectCollection)this.getModel().getValue(RELA_CSL)))) {
                valueList.add(new StringExpr(VFormulaHandler.packDimAndMemb((String)"RC", (String)this.getRelaCslMembNumber(rela_Csls))));
            }
            this.getView().returnDataToParent((Object)InvestFormulaParseHelper.createFunctionExpr((String)"V", (Object[])valueList.toArray()).toString());
            this.getView().close();
        }
    }

    private String getRelaCslMembNumber(DynamicObjectCollection relaCsls) {
        StringJoiner joiner = new StringJoiner("|");
        relaCsls.forEach(relaCsl -> joiner.add(relaCsl.getString("fbasedataid.number")));
        return joiner.toString();
    }

    private String getFSComboMembNumber(String key) {
        String prefix = "";
        if (Boolean.TRUE.equals(this.getView().getFormShowParameter().getCustomParam(IS_DRAFT))) {
            prefix = PRE_FIX;
        }
        switch (key) {
            case "1": {
                return prefix + InvFsfetchType.DIRECT_SUPER.getCode();
            }
            case "2": {
                return prefix + InvFsfetchType.COMMON_PARENT.getCode();
            }
        }
        return key;
    }

    private String getComboMembNumber(String key) {
        String prefix = "";
        if (Boolean.TRUE.equals(this.getView().getFormShowParameter().getCustomParam(IS_DRAFT))) {
            prefix = PRE_FIX;
        }
        switch (key) {
            case "1": {
                return prefix + "HolderOrg";
            }
            case "2": {
                return prefix + "InvestOrg";
            }
        }
        return key;
    }

    private String getCYComboMembNumber(String key) {
        String prefix = "";
        if (Boolean.TRUE.equals(this.getView().getFormShowParameter().getCustomParam(IS_DRAFT))) {
            prefix = PRE_FIX;
        }
        switch (key) {
            case "1": {
                return prefix + "HOLDERORGEC";
            }
            case "2": {
                return prefix + "HOLDERORGPC";
            }
            case "3": {
                return prefix + "INVESTORGEC";
            }
            case "4": {
                return prefix + "INVESTORGPC";
            }
            case "5": {
                return prefix + "COMMONORGEC";
            }
        }
        return key;
    }

    private String getComboKey(String key) {
        if (key == null) {
            return "4";
        }
        if (key.startsWith(PRE_FIX) && Boolean.TRUE.equals(this.getView().getFormShowParameter().getCustomParam(IS_DRAFT))) {
            key = key.substring(1);
        }
        switch (key) {
            case "InvestOrg": {
                return "2";
            }
            case "HolderOrg": {
                return "1";
            }
        }
        return "4";
    }

    private String getCYComboKey(String key) {
        if (key == null) {
            return "5";
        }
        if (key.startsWith(PRE_FIX) && Boolean.TRUE.equals(this.getView().getFormShowParameter().getCustomParam(IS_DRAFT))) {
            key = key.substring(1);
        }
        switch (key) {
            case "HOLDERORGEC": {
                return "1";
            }
            case "HOLDERORGPC": {
                return "2";
            }
            case "INVESTORGEC": {
                return "3";
            }
            case "INVESTORGPC": {
                return "4";
            }
            case "COMMONORGEC": {
                return "5";
            }
        }
        return "7";
    }

    private String getFsComboKey(String key) {
        if (key == null) {
            return "";
        }
        if (key.startsWith(PRE_FIX) && Boolean.TRUE.equals(this.getView().getFormShowParameter().getCustomParam(IS_DRAFT))) {
            key = key.substring(1);
        }
        switch (key) {
            case "DIRECTSUPER": {
                return "1";
            }
            case "COMMONPARENT": {
                return "2";
            }
        }
        return "";
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (comboKeyToName.containsKey(propertyName)) {
            String value = (String)e.getChangeSet()[0].getNewValue();
            String oldValue = (String)e.getChangeSet()[0].getOldValue();
            this.getPageCache().put("oldkey", oldValue);
            switch (propertyName) {
                case "combcurrency": {
                    if (!"6".equals(value)) break;
                    long dimId = this.getSctx().getDimensionByNumber("Currency").getId();
                    BasedataEditSingleMemberF7 sf7 = SingleMemberF7Util.createBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), dimId, propertyName, this, false, SingleF7TypeEnum.COMMON);
                    sf7.setCallBackClassName(this.getClass().getName());
                    sf7.click();
                    break;
                }
                case "comboic": {
                    if (!"3".equals(value)) break;
                    long dimId = this.getSctx().getDimensionByNumber("InternalCompany").getId();
                    BasedataEditSingleMemberF7 sf7 = SingleMemberF7Util.createBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), dimId, propertyName, this, false, SingleF7TypeEnum.COMMON);
                    sf7.setCallBackClassName(this.getClass().getName());
                    sf7.click();
                    break;
                }
                case "comboorg": {
                    if (!"3".equals(value)) break;
                    long dimId = this.getSctx().getDimensionByNumber("Entity").getId();
                    BasedataEditSingleMemberF7 sf7 = SingleMemberF7Util.createBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), dimId, propertyName, this, false, SingleF7TypeEnum.COMMON);
                    sf7.setCallBackClassName(this.getClass().getName());
                    sf7.click();
                    break;
                }
                case "combomyorg": {
                    if (!"3".equals(value)) break;
                    long dimId = this.getSctx().getDimensionByNumber("MyCompany").getId();
                    BasedataEditSingleMemberF7 sf7 = SingleMemberF7Util.createBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), dimId, propertyName, this, false, SingleF7TypeEnum.COMMON);
                    sf7.setCallBackClassName(this.getClass().getName());
                    sf7.click();
                    break;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (comboKeyToName.containsKey(actionId)) {
            if (e.getReturnData() == null) {
                this.setValue(actionId, this.getPageCache().get("oldkey"));
                this.getPageCache().remove("oldkey");
            } else {
                DynamicObject dy = (DynamicObject)e.getReturnData();
                this.rebuildComboEdit(actionId, dy);
                this.setValue(actionId, dy.getString(NUMBER));
            }
        }
    }

    private void rebuildComboEdit(String sign, DynamicObject dy) {
        Page page = this.getPage(this.getView());
        ((ComboEditElement)page.findElementBySign(sign)).setItems(this.getComboItems(dy, sign));
        page.getAreaList().forEach(area -> area.getElementListList().forEach(element1 -> element1.setStyle(this.createMarginStyle())));
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
    }

    private List<ComboItem> getComboItems(DynamicObject dy, String key) {
        ArrayList comboItems = Lists.newArrayList();
        if (COMBO_CURRENCY.equals(key)) {
            comboItems.add(new ComboItem(new LocaleString(InvCurrencyType.HOLDEREC.getDesc()), InvCurrencyType.HOLDEREC.getType()));
            comboItems.add(new ComboItem(new LocaleString(InvCurrencyType.HOLDERPC.getDesc()), InvCurrencyType.HOLDERPC.getType()));
            comboItems.add(new ComboItem(new LocaleString(InvCurrencyType.SHAREHOLDEREC.getDesc()), InvCurrencyType.SHAREHOLDEREC.getType()));
            comboItems.add(new ComboItem(new LocaleString(InvCurrencyType.SHAREHOLDERPC.getDesc()), InvCurrencyType.SHAREHOLDERPC.getType()));
            comboItems.add(new ComboItem(new LocaleString(InvCurrencyType.COMMONFATHEREC.getDesc()), InvCurrencyType.COMMONFATHEREC.getType()));
            comboItems.add(new ComboItem(new LocaleString(InvCurrencyType.MEMBER.getDesc()), InvCurrencyType.MEMBER.getType()));
            if (dy != null) {
                comboItems.add(new ComboItem(null, new LocaleString(dy.getString("name")), dy.getString(NUMBER), false));
            }
        } else if (COMBO_FSCONFIG.equals(key)) {
            comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u76f4\u63a5\u4e0a\u7ea7", (String)"InvVFormulaPlugin_19", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])), this.getFsComboKey(DIRECT_SUPER)));
            comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5171\u540c\u7236\u7ea7", (String)"InvVFormulaPlugin_20", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])), this.getFsComboKey(COMMON_PARENT)));
        } else {
            comboItems.add(new ComboItem(new LocaleString(InvOrgType.HOLDER.getDesc()), InvOrgType.HOLDER.getType()));
            comboItems.add(new ComboItem(new LocaleString(InvOrgType.INVESTORG.getDesc()), InvOrgType.INVESTORG.getType()));
            comboItems.add(new ComboItem(new LocaleString(InvOrgType.MEMBER.getDesc()), InvOrgType.MEMBER.getType()));
            if (dy != null) {
                comboItems.add(new ComboItem(null, new LocaleString(dy.getString("name")), dy.getString(NUMBER), false));
            }
        }
        return comboItems;
    }
}

