/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Delete;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;

public class InvelimTemplateListPlugin
extends AbstractBaseListPlugin {
    private static final String BILL_LIST_AP = "billlistap";
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance((boolean)true, InvelimTemplateListPlugin.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Delete) {
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            Object[] primaryKeyValues = listSelectedData.getPrimaryKeyValues();
            QFilter qf = new QFilter("id", "in", (Object)primaryKeyValues);
            DynamicObjectCollection datas = QueryServiceHelper.query((String)"bcm_invelimtemplate", (String)"id,name", (QFilter[])qf.toArray());
            HashMap<Long, String> nameMap = new HashMap<Long, String>(16);
            for (DynamicObject dyn : datas) {
                nameMap.put(dyn.getLong("id"), dyn.getString("name"));
            }
            this.getPageCache().put("nameMap", JSON.toJSONString(nameMap));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("delete".equals(afterDoOperationEventArgs.getOperateKey())) {
            String nameMapStr = this.getPageCache().get("nameMap");
            Map nameMap = (Map)JSON.parseObject((String)nameMapStr, HashMap.class);
            OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
            Map billNos = operationResult.getBillNos();
            StringBuilder result = new StringBuilder();
            for (Map.Entry map : billNos.entrySet()) {
                result.append((String)map.getValue()).append(" ").append((String)nameMap.get(Long.valueOf((String)map.getKey())));
            }
            if (afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                result.append(ResultStatusEnum.SUCCESS.getName());
                this.writeOperationLog(OpItemEnum.DELETE.getName(), result.toString());
            } else {
                result.append(ResultStatusEnum.FAIL.getName());
                this.writeOperationLog(OpItemEnum.DELETE.getName(), result.toString());
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.addPackageDataListener(arg_0 -> ((InvelimTemplateListPlugin)this).packageData(arg_0));
    }

    @Override
    protected void doCheckPermission(String entityNum, String permItemId) {
    }
}

