/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Audit;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.UnAudit;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.Copy;
import kd.bos.form.operate.New;
import kd.bos.form.operate.formop.CopyEntryRow;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.formula.AdjustFormulaParseHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.util.AccountMemberUtil;
import kd.fi.bcm.business.invest.InvElimTemplateService;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.YearScopeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.enums.invest.InvProcessEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.papertemplate.PaperTemplateSceneSettingHelper;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.util.AdjustCatalogUtil;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import org.apache.commons.collections.CollectionUtils;

public class InvelimTemplatePlugin
extends AbstractBaseFormPlugin
implements IBillPlugin {
    private static final String CTL_ENTRYENTITY = "invelimtplentry";
    private static final String CACHE_DIM = "cache_dim";
    private static final String CACHE_DEFAULT_DIM = "cache_default_dim";
    private static final String CTL_RULEEXPR = "ruleexpr";
    private static final String CTL_RULEEXPRDEPT = "ruleexprdept";
    private static final String CTL_DESCRIPTION = "description";
    private static final String CTL_DATASORT = "datasource";
    private static final String CTL_MULTIGAAP = "multigaap";
    private static final String CTL_CHANGETYPE = "changetype";
    private static final String CTL_ACCOUNT = "account";
    private static final String CTL_MYCOMPANY = "commycompany";
    private static final String CTL_INTERCOMPANY = "comintercompany";
    private static final String BILLNO = "billno";
    private static final String NAME = "name";
    public static final String SCENARIOSET = "scenarioset";
    public static final String SCENARIOS = "scenarios";
    private static final String ctr_effectivetext = "effectivetext";
    private static final String ctr_effectivedata = "effectivedata";
    private static final String ctr_effectivecache = "effectivecache";
    public static final String EXPIRED_PERIOD = "expiredPeriod";
    private static final String ctr_effective = "effective";
    public static final String NUMBER = "number";
    private final Map<String, String> dimKeys = new HashMap<String, String>();
    private final Map<String, String> userdefineMap2Nums = new HashMap<String, String>();
    public static final String MYCOMPANY = "mycompany";
    public static final String INTERCOMPANY = "internalcompany";
    private boolean isCopy;

    public InvelimTemplatePlugin() {
        this.dimKeys.put("entity", "entity");
        this.dimKeys.put(MYCOMPANY, MYCOMPANY);
        this.dimKeys.put(INTERCOMPANY, INTERCOMPANY);
        this.dimKeys.put("process", "process");
        this.dimKeys.put(CTL_CHANGETYPE, CTL_CHANGETYPE);
        this.dimKeys.put("audittrail", "audittrail");
        this.dimKeys.put(CTL_DATASORT, "datasort");
        this.dimKeys.put(CTL_MULTIGAAP, CTL_MULTIGAAP);
        this.dimKeys.put("userdefine1", "");
        this.dimKeys.put("userdefine2", "");
        this.dimKeys.put("userdefine3", "");
        this.dimKeys.put("userdefine4", "");
        this.dimKeys.put("userdefine5", "");
        this.dimKeys.put("userdefine6", "");
        this.userdefineMap2Nums.put("dim1", "userdefine1");
        this.userdefineMap2Nums.put("dim2", "userdefine2");
        this.userdefineMap2Nums.put("dim3", "userdefine3");
        this.userdefineMap2Nums.put("dim4", "userdefine4");
        this.userdefineMap2Nums.put("dim5", "userdefine5");
        this.userdefineMap2Nums.put("dim6", "userdefine6");
        this.isCopy = false;
    }

    private OpNameMultiLangEnumBridge getOperationSave() {
        return new OpNameMultiLangEnumBridge("\u65b0\u589e\u4fdd\u5b58", "InvelimTemplatePlugin_0", "fi-bcm-formplugin", "Add Save");
    }

    private OpNameMultiLangEnumBridge getOperationDelete() {
        return new OpNameMultiLangEnumBridge("\u5220\u9664", "InvelimTemplatePlugin_1", "fi-bcm-formplugin", "Delete");
    }

    private String getOperationCopy() {
        return ResManager.loadKDString((String)"\u590d\u5236", (String)"InvelimTemplatePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"InvelimTemplatePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStstusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"InvelimTemplatePlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(new ArrayList<String>(this.dimKeys.keySet()), SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
        TextEdit scenarioset = (TextEdit)this.getView().getControl(SCENARIOSET);
        scenarioset.setMustInput(true);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String f7Key = beforeF7SelectEvent.getProperty().getName();
        if (CTL_ACCOUNT.equals(f7Key)) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("model.id", "=", (Object)this.getModelId()));
            qFilters.add(QFilter.of((String)"accountpart.isaccountoffset = ?", (Object[])new Object[]{true}));
            qFilters.add(QFilter.of((String)"storagetype != ?", (Object[])new Object[]{"3"}));
            qFilters.add(QFilter.of((String)"isleaf =?", (Object[])new Object[]{"1"}));
            if (!QueryServiceHelper.exists((String)"bcm_accountmembertree", (QFilter[])qFilters.toArray(new QFilter[3]))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u53c2\u4e0e\u62b5\u9500\u7684\u79d1\u76ee\uff0c\u8bf7\u5728\u7ef4\u5ea6\u7ba1\u7406\u4e2d\u5bf9\u79d1\u76ee\u8fdb\u884c\u76f8\u5173\u5c5e\u6027\u8bbe\u7f6e\u3002", (String)"InvelimTemplatePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setFormId("bos_listf7");
            formShowParameter.getListFilterParameter().setQFilters(qFilters);
        } else if ("audittrail".equals(f7Key)) {
            if (beforeF7SelectEvent.getFormShowParameter() instanceof ListShowParameter) {
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                qFilters.add(new QFilter(CTL_DATASORT, "=", (Object)"3"));
                ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                formShowParameter.setFormId("bos_listf7");
                formShowParameter.getListFilterParameter().getQFilters().addAll(qFilters);
            }
        } else if ("invrelatypebase".equals(f7Key)) {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setCustomParam("model", (Object)this.getModelId());
            formShowParameter.setCustomParam("process", (Object)"Adj");
            formShowParameter.setCustomParam("isShowChangeType", (Object)true);
            QFilter modelFilter = new QFilter("model", "=", (Object)this.getModelId());
            beforeF7SelectEvent.addCustomQFilter(modelFilter);
        } else if (MYCOMPANY.equals(f7Key) || INTERCOMPANY.equals(f7Key)) {
            BasedataEditSingleMemberF7 source = (BasedataEditSingleMemberF7)((Object)beforeF7SelectEvent.getSource());
            source.setSystemVariables(SystemVarsEnum.getInvDimVars());
            if ("getLookUpList".equals(beforeF7SelectEvent.getSourceMethod()) || "setItemByIdFromClient".equals(beforeF7SelectEvent.getSourceMethod())) {
                ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                List qFilters = formShowParameter.getListFilterParameter().getQFilters();
                AtomicReference qFilter = new AtomicReference();
                qFilters.stream().forEach(filter -> {
                    if (!Optional.ofNullable(qFilter.get()).isPresent()) {
                        qFilter.set(filter);
                        return;
                    }
                    ((QFilter)qFilter.get()).and(filter);
                });
                QFBuilder qfBuilders = new QFBuilder().add(new QFilter("model", "=", (Object)SystemVarsEnum.getDefaultModelId()).and("dimension", "=", (Object)SystemVarsEnum.getDefaultDimension()).and(NUMBER, "in", (Object)SystemVarsEnum.getInvDimVars())).or((QFilter)qFilter.get());
                formShowParameter.getListFilterParameter().setQFilters(qfBuilders.toList());
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        Control changeType;
        Control multiGap;
        super.registerListener(e);
        this.addClickListeners(CTL_RULEEXPR, CTL_RULEEXPRDEPT, CTL_DESCRIPTION, SCENARIOSET, ctr_effectivetext);
        this.addItemClickListeners("tbmain");
        BasedataEdit account = (BasedataEdit)this.getControl(CTL_ACCOUNT);
        BasedataEdit at = (BasedataEdit)this.getControl("audittrail");
        BasedataEdit invrelatype = (BasedataEdit)this.getControl("invrelatypebase");
        BasedataEdit mycompany = (BasedataEdit)this.getControl(MYCOMPANY);
        BasedataEdit intercompany = (BasedataEdit)this.getControl(INTERCOMPANY);
        account.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        at.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        invrelatype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        mycompany.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        intercompany.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Control dataSort = this.getControl(CTL_DATASORT);
        if (dataSort instanceof BasedataEditSingleMemberF7) {
            ((BasedataEditSingleMemberF7)dataSort).setCustomFilter(this.getDimMapFilter(DimTypesEnum.DATASORT.getNumber(), CTL_ACCOUNT));
        }
        if ((multiGap = this.getControl(CTL_MULTIGAAP)) instanceof BasedataEditSingleMemberF7) {
            ((BasedataEditSingleMemberF7)multiGap).setCustomFilter(this.getDimMapFilter(DimTypesEnum.MULTIGAAP.getNumber(), CTL_ACCOUNT));
        }
        if ((changeType = this.getControl(CTL_CHANGETYPE)) instanceof BasedataEditSingleMemberF7) {
            ((BasedataEditSingleMemberF7)changeType).setCustomFilter(this.getDimMapFilter(DimTypesEnum.CHANGETYPE.getNumber(), CTL_ACCOUNT));
        }
        Map<String, String> dimKeyCache = this.getDimKeyCache();
        for (int i = 1; i <= 6; ++i) {
            Control userControl;
            String userDefinedIndex = "userdefine" + i;
            String userDefinedNumber = dimKeyCache.get(userDefinedIndex);
            if (!StringUtils.isNotEmpty((String)userDefinedNumber) || !((userControl = this.getControl(userDefinedIndex)) instanceof BasedataEditSingleMemberF7)) continue;
            ((BasedataEditSingleMemberF7)userControl).setCustomFilter(this.getDimMapFilter(userDefinedNumber, CTL_ACCOUNT));
        }
        AdjustCatalogUtil.setAdjustCatalogFilter((BasedataEdit)this.getControl("adjustcatalog"), String.valueOf(this.getModelId()));
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (StringUtils.isEmpty((String)key)) {
            return;
        }
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        if (CTL_ACCOUNT.equals(key)) {
            DynamicObject account = (DynamicObject)this.getModel().getValue(CTL_ACCOUNT, rowIndex);
            if (account != null) {
                long accId = account.getLong("id");
                Map map = AccountMemberUtil.getAccountDimValMapWithCache((Long)accId, (long)this.getModelId(), (IPageCache)this.getPageCache());
                Map<String, String> dimNumberMap = this.getDimNumberMap();
                for (Map.Entry<String, String> entry : dimNumberMap.entrySet()) {
                    this.setDimMemFilter(rowIndex, map, entry.getKey(), entry.getValue());
                }
            }
        } else if ("cb_process".equals(key)) {
            String newvalue = changeData.getNewValue().toString();
            if (newvalue == null || newvalue.length() <= 0) {
                this.getModel().setValue("cb_process", changeData.getOldValue());
                return;
            }
            DynamicObject process = this.getProcess(this.getModelId(), InvProcessEnum.getNumber((char)changeData.getNewValue().toString().charAt(0)));
            if (process != null) {
                this.getModel().setValue("process", (Object)process.getLong("id"));
            }
        } else if ("adjustment".equals(key)) {
            boolean isAdjust = (Boolean)changeData.getNewValue();
            this.initComboItems();
            if (!isAdjust) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"cb_process"});
                String number = this.setDefaultProcess(this.getModelId());
                this.getModel().setValue("cb_process", (Object)Character.valueOf(InvProcessEnum.getIndex((String)number)));
            } else {
                DynamicObject process = this.getProcess(this.getModelId(), "ERAdj");
                if (process != null) {
                    this.getModel().setValue("process", (Object)process.getLong("id"));
                    this.getModel().setValue("cb_process", (Object)Character.valueOf(InvProcessEnum.getIndex((String)process.getString(NUMBER))));
                }
            }
        } else if ("isonlylinked".equals(key)) {
            boolean isonlylinked = (Boolean)changeData.getNewValue();
            if (isonlylinked) {
                String msg = ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u540e\uff0c\u8bf7\u5728\u5408\u5e76\u6240\u6709\u6743\u8bbe\u7f6e\u754c\u9762\u8fdb\u884c\u5173\u8054\u3002", (String)"InvelimTemplatePlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                this.getView().showSuccessNotification(msg, Integer.valueOf(3000));
            }
        } else if (CTL_DESCRIPTION.equals(key) || CTL_RULEEXPR.equals(key) || CTL_RULEEXPRDEPT.equals(key)) {
            if (BillStatus.C.name().equals(this.getBillStatus()) && StringUtils.isEmpty((String)((String)changeData.getNewValue())) && changeData.getOldValue() != null) {
                this.getModel().setValue(key, changeData.getOldValue());
            }
        } else if (SCENARIOSET.equals(key)) {
            if (StringUtils.isBlank((String)((String)this.getModel().getValue(SCENARIOSET)))) {
                this.getPageCache().remove(SCENARIOSET);
                this.getModel().deleteEntryData(SCENARIOS);
            }
        } else if (ctr_effectivetext.equals(key) && StringUtils.isBlank((String)((String)this.getModel().getValue(ctr_effectivetext)))) {
            this.getPageCache().remove(ctr_effectivedata);
            this.getModel().deleteEntryData(ctr_effective);
        }
    }

    private Map<String, String> getDimNumberMap() {
        HashMap<String, String> dimNumberMap = new HashMap<String, String>();
        dimNumberMap.put(DimTypesEnum.DATASORT.getNumber(), CTL_DATASORT);
        dimNumberMap.put(DimTypesEnum.MULTIGAAP.getNumber(), CTL_MULTIGAAP);
        if (this.isExistChangeTypeDimension()) {
            dimNumberMap.put(DimTypesEnum.CHANGETYPE.getNumber(), CTL_CHANGETYPE);
        }
        Map<String, String> dimKeyCache = this.getDimKeyCache();
        for (int i = 1; i <= 6; ++i) {
            String userDefinedIndex = "userdefine" + i;
            String userDefinedNumber = dimKeyCache.get(userDefinedIndex);
            if (!StringUtils.isNotEmpty((String)userDefinedNumber)) continue;
            dimNumberMap.put(userDefinedNumber, userDefinedIndex);
        }
        return dimNumberMap;
    }

    private void setDimMemFilter(int rowIndex, Map<String, Set<Long>> map, String dimNumber, String fieldName) {
        Collection dataSortIds = map.get(dimNumber);
        if (dataSortIds != null) {
            QFilter idFilter = new QFilter("id", "in", (Object)dataSortIds);
            QFilter leafFiler = new QFilter("isleaf", "=", (Object)"1");
            String dsEntityId = DimensionServiceHelper.getDimMembEntityNumByDimNum((String)dimNumber);
            DynamicObjectCollection dync = QueryServiceHelper.query((String)dsEntityId, (String)"id,name,number,isleaf", (QFilter[])new QFilter[]{idFilter, leafFiler});
            if (dync.size() == 1) {
                DynamicObject dynamicObject = (DynamicObject)dync.get(0);
                this.getModel().setValue(fieldName, (Object)dynamicObject.getLong("id"), rowIndex);
            } else {
                DynamicObject dyn = (DynamicObject)this.getModel().getValue(fieldName, rowIndex);
                if (dyn != null) {
                    long id = dyn.getLong("id");
                    List ids = dync.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
                    if (!ids.contains(id)) {
                        this.getModel().setValue(fieldName, null, rowIndex);
                    }
                }
            }
        }
    }

    private QFilter getDimMapFilter(String dimNumber, String accKey) {
        long accId;
        Map map;
        Collection ids;
        int index;
        IDataModel model = this.getModel();
        DynamicObject acct = (DynamicObject)model.getValue(accKey, index = model.getEntryCurrentRowIndex(CTL_ENTRYENTITY));
        if (acct != null && (ids = (Collection)(map = AccountMemberUtil.getAccountDimValMapWithCache((Long)(accId = acct.getLong("id")), (long)this.getModelId(), (IPageCache)this.getPageCache())).get(dimNumber)) != null) {
            return new QFilter("id", "in", (Object)ids);
        }
        return null;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        IDataModel model = this.getModel();
        DynamicObject modelDyn = (DynamicObject)model.getValue("model");
        if (!(modelDyn == null || this.isCopy || SCENARIOS.equals(e.getEntryProp().getName()) || ctr_effective.equals(e.getEntryProp().getName()))) {
            RowDataEntity[] rowDataEntities;
            Map<String, String> dimDefaultId = this.geneDimDefaultId(modelDyn);
            for (RowDataEntity rowData : rowDataEntities = e.getRowDataEntities()) {
                this.initComboItems();
                for (Map.Entry<String, String> entry : dimDefaultId.entrySet()) {
                    model.setValue(entry.getKey(), (Object)Long.valueOf(entry.getValue()), rowData.getRowIndex());
                }
            }
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IDataModel model = this.getModel();
        String name = model.getDataEntity(true).getString(NAME);
        model.setValue(NAME, (Object)(name + "copy"));
    }

    public void afterLoadData(EventObject e) {
        IDataModel model = this.getModel();
        String status = (String)model.getValue("billstatus");
        this.initComboItems();
        Object object = this.getModel().getValue("process");
        if (object != null) {
            char index = InvProcessEnum.getIndex((String)((DynamicObject)object).getString(NUMBER));
            this.getModel().setValue("cb_process", (Object)Character.valueOf(index));
            this.getModel().setDataChanged(false);
        } else {
            boolean isGenerate = (Boolean)this.getModel().getValue("adjustment");
            DynamicObject process = isGenerate ? this.getProcess(this.getModelId(), "ERAdj") : this.getProcess(this.getModelId(), "EOE", "EJE");
            char index = InvProcessEnum.getIndex((String)process.getString(NUMBER));
            this.getModel().setValue("cb_process", (Object)Character.valueOf(index));
            this.getModel().setValue("process", (Object)process.getLong("id"));
        }
        if ("C".equals(status)) {
            int entryRowCount = model.getEntryRowCount(CTL_ENTRYENTITY);
            boolean modify = false;
            Map<String, String> dimDefaultId = null;
            DynamicObject modelDyn = (DynamicObject)model.getValue("model");
            if (entryRowCount > 0) {
                String value;
                Map<String, String> dimKeys = this.getDimKeyCache();
                for (int i = 1; i <= 6 && StringUtils.isNotEmpty((String)(value = dimKeys.get("userdefine" + i))); ++i) {
                    if (model.getValue("userdefine" + i, 0) != null) continue;
                    for (int j = 0; j < entryRowCount; ++j) {
                        if (dimDefaultId == null) {
                            dimDefaultId = this.geneDimDefaultId(modelDyn);
                        }
                        if (!Objects.nonNull(dimDefaultId.get("userdefine" + i))) continue;
                        model.setValue("userdefine" + i, (Object)Long.valueOf(dimDefaultId.get("userdefine" + i)), j);
                        modify = true;
                    }
                }
            }
            if (modify) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{model.getDataEntity(true)});
            }
        }
    }

    private Map<String, String> geneDimDefaultId(DynamicObject modelDyn) {
        HashMap<String, String> dimDefaultId;
        String defaultCache = this.getPageCache().get(CACHE_DEFAULT_DIM);
        if (StringUtils.isEmpty((String)defaultCache)) {
            String value;
            DynamicObject icBaseMember;
            DynamicObject mcBaseMember;
            DynamicObject queryOne;
            QFilter numberFilter;
            boolean isspptdatasort = modelDyn.getBoolean("isspptdatasort");
            boolean isspptmultrule = modelDyn.getBoolean("isspptmultrule");
            dimDefaultId = new HashMap<String, String>();
            Long modelId = modelDyn.getLong("id");
            QFilter modelFilter = QFilter.of((String)"model = ?", (Object[])new Object[]{modelId});
            if (isspptdatasort) {
                numberFilter = QFilter.of((String)"number = ?", (Object[])new Object[]{"Actual"});
                numberFilter.and("isleaf", "=", (Object)"1");
                queryOne = QueryServiceHelper.queryOne((String)SysDimensionEnum.DataSort.getMemberTreemodel(), (String)"id", (QFilter[])numberFilter.and(modelFilter).toArray());
                if (queryOne != null) {
                    dimDefaultId.put(CTL_DATASORT, queryOne.getString("id"));
                }
            }
            if (isspptmultrule) {
                numberFilter = QFilter.of((String)"number = ?", (Object[])new Object[]{"PRCGAAP"});
                numberFilter.and("isleaf", "=", (Object)"1");
                queryOne = QueryServiceHelper.queryOne((String)SysDimensionEnum.MultiGAAP.getMemberTreemodel(), (String)"id", (QFilter[])numberFilter.and(modelFilter).toArray());
                if (queryOne != null) {
                    dimDefaultId.put(CTL_MULTIGAAP, queryOne.getString("id"));
                }
            }
            if ((mcBaseMember = QueryServiceHelper.queryOne((String)SysDimensionEnum.MyCompany.getMemberTreemodel(), (String)"id", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)"MCNone").and("model", "=", (Object)modelId)})) != null) {
                dimDefaultId.put(MYCOMPANY, mcBaseMember.getString("id"));
            }
            if ((icBaseMember = QueryServiceHelper.queryOne((String)SysDimensionEnum.InternalCompany.getMemberTreemodel(), (String)"id", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)"ICNone").and("model", "=", (Object)modelId)})) != null) {
                dimDefaultId.put(INTERCOMPANY, icBaseMember.getString("id"));
            }
            String cacheDim = this.getPageCache().get(CACHE_DIM);
            Map dimKeys = (Map)ObjectSerialUtil.deSerializedBytes((String)cacheDim);
            for (int i = 1; i <= 6 && StringUtils.isNotEmpty((String)(value = (String)dimKeys.get("userdefine" + i))); ++i) {
                QFilter numberFilter2 = QFilter.of((String)"number = ?", (Object[])new Object[]{value + "None"});
                numberFilter2.and("isleaf", "=", (Object)"1");
                DynamicObject queryOne2 = QueryServiceHelper.queryOne((String)"bcm_userdefinedmembertree", (String)"id", (QFilter[])numberFilter2.and(modelFilter).toArray());
                if (queryOne2 == null) continue;
                dimDefaultId.put("userdefine" + i, queryOne2.getString("id"));
            }
            this.getPageCache().put(CACHE_DEFAULT_DIM, this.toByteSerialized(dimDefaultId));
        } else {
            dimDefaultId = (HashMap<String, String>)this.deSerializedBytes(defaultCache);
        }
        return dimDefaultId;
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        String f7Key = e.getKey();
        String cacheDim = this.getPageCache().get(CACHE_DIM);
        if (!StringUtils.isEmpty((String)cacheDim)) {
            Map dimKeys = (Map)ObjectSerialUtil.deSerializedBytes((String)cacheDim);
            String pagekey = (String)dimKeys.get(f7Key);
            if (this.getDimKeysFromCache().containsKey(f7Key)) {
                SingleF7TypeEnum type = this.getDimKeysFromCache().get(f7Key);
                Control ctrl = (Control)this.cacheControls.get(f7Key);
                if (ctrl != null) {
                    e.setControl(ctrl);
                } else {
                    BasedataEditSingleMemberF7 f7 = SingleMemberF7Util.getBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), pagekey, f7Key, ev -> this.getSingleMemberF7Handle(Lists.newArrayList(this.getDimKeysFromCache().keySet())).beforeSingleMemberF7Select(ev), false, type);
                    f7.setDisplayProp(NAME);
                    Map<String, Object> customData = f7.getCustomData();
                    if (customData == null) {
                        customData = new HashMap<String, Object>();
                        f7.setCustomData(customData);
                    }
                    customData.put("isContainShare", false);
                    e.setControl((Control)f7);
                    this.cacheControls.put(f7Key, f7);
                }
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long modelId = (Long)formShowParameter.getCustomParam("model");
        Object templateCatalog = formShowParameter.getCustomParam("templateCatalog");
        if (modelId == null) {
            return;
        }
        IDataModel iDataModel = this.getModel();
        iDataModel.setValue("model", (Object)modelId);
        iDataModel.setValue("templatecatalog", templateCatalog);
        this.initComboItems();
        this.setDefaultProcess(modelId);
    }

    private List<Map<String, Object>> cvtDyToList(DynamicObjectCollection dynamicObjects) {
        ArrayList<Map<String, Object>> selecteditems = new ArrayList<Map<String, Object>>(16);
        dynamicObjects.forEach(dy -> selecteditems.add(MapInitHelper.ofMap((Object)"id", (Object)dy.getLong("scenariomeb.id"), (Object)"scope", (Object)dy.getString("scenarioscope"), (Object)"isexcept", (Object)dy.getString("isexcept"))));
        return selecteditems;
    }

    public DynamicObjectCollection getEffectivePeriod(Long templateid) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)templateid, (String)"bcm_invelimtemplate");
        if (Objects.nonNull(dynamicObject)) {
            return dynamicObject.getDynamicObjectCollection(ctr_effective);
        }
        return null;
    }

    private void initComboItems() {
        this.initProcessCombo();
        InvElimTemplateService.initLinkCreateTypeCombo((IFormView)this.getView());
    }

    private void initProcessCombo() {
        ComboEdit ce = (ComboEdit)this.getControl("cb_process");
        ArrayList items = new ArrayList(10);
        InvElimTemplateService.getProcessCombo((long)this.getModelId(), (number, name) -> items.add(new ComboItem(new LocaleString(number + " " + name), InvProcessEnum.getIndex((String)number) + "")));
        ce.setComboItems(items);
    }

    private void openExpiredDateF7(String key) {
        long modelIdl = this.getModelId();
        if (0L == modelIdl) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ConvertSettingPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_expire_date_f7");
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6709\u6548\u671f\u95f4", (String)"ConvertSettingPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)modelIdl);
        formShowParameter.setCustomParam("entryId", (Object)key);
        String data = this.getPageCache().get(ctr_effectivedata);
        if (!StringUtils.isEmpty((String)data)) {
            formShowParameter.setCustomParam(ctr_effective, (Object)data);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, EXPIRED_PERIOD);
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    public String setDefaultProcess(Long modelId) {
        DynamicObject process = this.getProcess(modelId, "EOE", "EJE");
        if (process != null) {
            char index = InvProcessEnum.getIndex((String)process.getString(NUMBER));
            this.getModel().setValue("cb_process", (Object)Character.valueOf(index));
            this.getModel().setValue("process", (Object)process.getLong("id"));
            return process.getString(NUMBER);
        }
        return "EJE";
    }

    public DynamicObject getProcess(Long modelId, String ... processNumber) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        qfBuilder.add(NUMBER, "in", (Object)processNumber);
        qfBuilder.add("isleaf", "=", (Object)true);
        return QueryServiceHelper.queryOne((String)"bcm_processmembertree", (String)"id,number", (QFilter[])qfBuilder.toArray());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        New event;
        String operateKey = "";
        if (args.getSource() instanceof Audit) {
            operateKey = ((Audit)args.getSource()).getOperateKey();
        } else if (args.getSource() instanceof UnAudit) {
            operateKey = ((UnAudit)args.getSource()).getOperateKey();
        } else if (args.getSource() instanceof Save) {
            operateKey = ((Save)args.getSource()).getOperateKey();
        }
        switch (operateKey) {
            case "audit": {
                this.checkPerm("bar_audit");
                break;
            }
            case "unaudit": {
                this.checkPerm("bar_unaudit");
                break;
            }
            case "save": {
                this.checkPerm("bar_save");
                this.checkMutiBalance();
            }
        }
        if (args.getSource() instanceof New) {
            event = (New)args.getSource();
            this.setParameters(args, event.getParameter());
        } else if (args.getSource() instanceof Copy) {
            event = (Copy)args.getSource();
            this.setParameters(args, event.getParameter());
        } else if (args.getSource() instanceof Save || args.getSource() instanceof Audit) {
            TextEdit scenarioset = (TextEdit)this.getView().getControl(SCENARIOSET);
            scenarioset.setMustInput(true);
            MainEntityType mainEntityType = this.getModel().getDataEntityType();
            ((TextProp)mainEntityType.getProperties().get((Object)SCENARIOSET)).setMustInput(true);
        } else if (args.getSource() instanceof CopyEntryRow) {
            this.isCopy = true;
        }
    }

    private void checkMutiBalance() {
        DynamicObjectCollection dc = this.getModel().getDataEntity(true).getDynamicObjectCollection(CTL_ENTRYENTITY);
        AtomicInteger index = new AtomicInteger();
        dc.forEach(entry -> {
            try {
                String ruleexprsource = entry.getString("ruleexprsource");
                Expression expression = ExcelFormulaPaserHelper.parse((String)ruleexprsource);
                AtomicBoolean isBlanceLine = new AtomicBoolean(false);
                AdjustFormulaParseHelper.walkExpress((Expression)expression, p -> {
                    String funcName;
                    if (p instanceof FunctionExpr && "BN".equalsIgnoreCase(funcName = ((FunctionExpr)p).getFuncionName())) {
                        isBlanceLine.set(true);
                    }
                    return p;
                });
                if (isBlanceLine.get() && index.getAndIncrement() > 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5206\u7ec4\u5185\u53ea\u80fd\u51fa\u73b0\u4e00\u4e2a\u5e73\u8861\u6570\u3002", (String)"InvelimTemplatePlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            }
            catch (Throwable t) {
                throw new KDBizException(AdjustmentServiceHelper.toString_Adj((Throwable)t));
            }
        });
    }

    @Override
    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            e.setNewEntityType((MainEntityType)e.getOriginalEntityType().clone());
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void setParameters(BeforeDoOperationEventArgs args, Map<String, Object> parameter) {
        DynamicObject modelId = (DynamicObject)this.getModel().getValue("model");
        DynamicObject scenario = (DynamicObject)this.getModel().getValue("scenario");
        if (modelId == null) {
            args.setCancel(true);
        }
        if (modelId != null) {
            parameter.put("model", modelId.getPkValue());
        }
        if (scenario != null) {
            parameter.put("scenario", this.toByteSerialized(scenario));
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("bar_new".equals(evt.getItemKey())) {
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId("bcm_invelimtemplate");
            billShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
            DynamicObject modelId = (DynamicObject)this.getModel().getValue("model");
            DynamicObject scenario = (DynamicObject)this.getModel().getValue("scenario");
            if (modelId == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u672a\u8bbe\u7f6e\u3002", (String)"InvelimTemplatePlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            billShowParameter.setCustomParam("model", modelId.getPkValue());
            if (Objects.nonNull(scenario)) {
                billShowParameter.setCustomParam("scenario", (Object)this.toByteSerialized(scenario));
            }
            billShowParameter.setCustomParam("templateCatalog", this.getValue("templateCatalog_id"));
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    public Map<String, String> getDimKeyCache() {
        String cacheDim = this.getPageCache().get(CACHE_DIM);
        if (StringUtils.isEmpty((String)cacheDim)) {
            List userDefineds = DimensionServiceHelper.getUserDefineDimensionNumListByModel((Object)this.getModelId());
            Map numMapped = DimensionServiceHelper.getDimensionNumMapped((Object)this.getModelId());
            Map userName = DimensionServiceHelper.getUserDefineDimensionNumAndNameByModel((Object)this.getModelId(), (boolean)false);
            for (int i = 1; i <= userDefineds.size(); ++i) {
                String userDefinedNumber = (String)userDefineds.get(i - 1);
                this.dimKeys.put(this.userdefineMap2Nums.get(numMapped.get(userDefinedNumber)), userDefinedNumber);
                this.dimKeys.put(this.userdefineMap2Nums.get(numMapped.get(userDefinedNumber)) + NAME, (String)userName.get(userDefinedNumber));
            }
            this.getPageCache().put(CACHE_DIM, ObjectSerialUtil.toByteSerialized(this.dimKeys));
        } else {
            this.dimKeys.putAll((Map)ObjectSerialUtil.deSerializedBytes((String)cacheDim));
        }
        return this.dimKeys;
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject modelDyn = (DynamicObject)this.getModel().getValue("model");
        this.initComboItems();
        EntryGrid grid = (EntryGrid)this.getControl(CTL_ENTRYENTITY);
        Map<String, String> dimKeyCache = this.getDimKeyCache();
        for (int i = 1; i <= 6; ++i) {
            String userDefinedIndex = "userdefine" + i;
            String userDefinedNumber = dimKeyCache.get(userDefinedIndex);
            if (StringUtils.isNotEmpty((String)userDefinedNumber)) {
                String userDefinedName = dimKeyCache.get(userDefinedIndex + NAME);
                grid.setColumnProperty(userDefinedIndex, "header", (Object)new LocaleString(userDefinedName));
                grid.setMustInput(userDefinedIndex, true);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{userDefinedIndex});
                continue;
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{userDefinedIndex});
        }
        boolean isspptdatasort = modelDyn.getBoolean("isspptdatasort");
        this.getView().setVisible(Boolean.valueOf(isspptdatasort), new String[]{CTL_DATASORT});
        grid.setMustInput(CTL_DATASORT, isspptdatasort);
        boolean isspptmultrule = modelDyn.getBoolean("isspptmultrule");
        this.getView().setVisible(Boolean.valueOf(isspptmultrule), new String[]{CTL_MULTIGAAP});
        grid.setMustInput(CTL_MULTIGAAP, isspptmultrule);
        boolean existsMyCompanyDim = DimensionServiceHelper.existsMyCompanyDim((long)modelDyn.getLong("id"));
        this.getView().setVisible(Boolean.valueOf(existsMyCompanyDim), new String[]{MYCOMPANY});
        grid.setMustInput(MYCOMPANY, existsMyCompanyDim);
        Object bpObj = this.getModel().getValue("process");
        if (bpObj != null) {
            String number = ((DynamicObject)this.getModel().getValue("process")).getString(NUMBER);
            this.getModel().setValue("cb_process", (Object)Character.valueOf(InvProcessEnum.getIndex((String)number)));
        }
        this.initScenarioSet();
        this.initShowEffective();
    }

    private void initScenarioSet() {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(SCENARIOS);
        ArrayList<Map> selecteditems = new ArrayList<Map>(16);
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
            this.setScenarioset(dynamicObjects);
        } else {
            Object scenarioStr = this.getView().getFormShowParameter().getCustomParam("scenario");
            if (Objects.nonNull(scenarioStr)) {
                DynamicObject scenario = (DynamicObject)this.deSerializedBytes(String.valueOf(scenarioStr));
                long id = scenario.getLong("id");
                this.getModel().deleteEntryData(SCENARIOS);
                this.getModel().batchCreateNewEntryRow(SCENARIOS, 1);
                DynamicObject dynamicObject = this.getModel().getEntryRowEntity(SCENARIOS, 0);
                dynamicObject.set("scenariomeb_id", (Object)id);
                dynamicObject.set("scenarioscope", (Object)"10");
                dynamicObject.set("isexcept", (Object)"0");
                selecteditems.add(MapInitHelper.ofMap((Object)"id", (Object)id, (Object)"scope", (Object)"10", (Object)"isexcept", (Object)"0"));
                this.getModel().setValue(SCENARIOSET, (Object)PaperTemplateSceneSettingHelper.formateDisplay((String)scenario.getString(NUMBER), (String)scenario.getString(NAME), (String)"10", (String)"0"));
                this.getPageCache().put(SCENARIOSET, this.toByteSerialized(selecteditems));
                this.getModel().updateCache();
            }
        }
    }

    private void initShowEffective() {
        DynamicObjectCollection effectives = this.getModel().getEntryEntity(ctr_effective);
        if (CollectionUtils.isNotEmpty((Collection)effectives)) {
            Map<String, List<DynamicObject>> eMap = effectives.stream().collect(Collectors.groupingBy(this::groupBySeq));
            TreeMap<String, List<DynamicObject>> treeMap = new TreeMap<String, List<DynamicObject>>(eMap);
            TreeMap effectivedata = new TreeMap();
            StringJoiner effectivedataStr = new StringJoiner(";");
            for (Map.Entry<String, List<DynamicObject>> effectiveEntry : treeMap.entrySet()) {
                StringBuilder str = new StringBuilder();
                List<DynamicObject> es = effectiveEntry.getValue();
                Set periodIds = es.stream().filter(ef -> null != ef.getDynamicObject("effectiveperiod") && 0L != ef.getDynamicObject("effectiveperiod").getLong("id")).map(e -> e.getDynamicObject("effectiveperiod").getLong("id")).collect(Collectors.toSet());
                DynamicObject effective = es.get(0);
                effectivedata.put(effectiveEntry.getKey() + "@" + Optional.ofNullable(effective.getDynamicObject("effectiveyear")).map(year -> year.getString("id")).orElse("null") + "@" + effective.getString("applytype") + "@" + effective.getString("yearscope"), periodIds);
                str.append("1".equals(effective.getString("applytype")) ? ResManager.loadKDString((String)"\u9002\u7528", (String)"TemplateModel_01", (String)"fi-bcm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4f8b\u5916", (String)"TemplateModel_02", (String)"fi-bcm-business", (Object[])new Object[0]));
                str.append(Optional.ofNullable(effective.getDynamicObject("effectiveyear")).map(year -> year.getString(NAME)).orElse(""));
                str.append(YearScopeEnum.getEnumByType((String)effective.getString("yearscope")).getName());
                if (!periodIds.isEmpty()) {
                    for (DynamicObject esp : es) {
                        DynamicObject effectiveperiod = esp.getDynamicObject("effectiveperiod");
                        str.append(effectiveperiod.getString(NAME));
                    }
                } else {
                    str.append(ResManager.loadKDString((String)"\u6240\u6709\u671f\u95f4", (String)"TemplateModel_03", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                effectivedataStr.add(str.toString());
            }
            if (StringUtils.isNotEmpty((String)effectivedataStr.toString())) {
                this.getPageCache().put(ctr_effectivedata, JSON.toJSONString(effectivedata));
                this.getModel().setValue(ctr_effectivetext, (Object)effectivedataStr.toString());
                this.getModel().setDataChanged(false);
            }
        }
    }

    private String groupBySeq(DynamicObject o) {
        return String.join((CharSequence)"#", o.getString("applytype"), o.getString("effectiveyear.number"), o.getString("yearscope"));
    }

    private void setScenarioset(DynamicObjectCollection dynamicObjects) {
        List<Map<String, Object>> selecteditems = this.cvtDyToList(dynamicObjects);
        this.getPageCache().put(SCENARIOSET, this.toByteSerialized(selecteditems));
        String stringJoiner = this.cvtMutiScenarioStr(dynamicObjects);
        this.getModel().setValue(SCENARIOSET, (Object)stringJoiner);
        this.getModel().setDataChanged(false);
    }

    private Object getBillStatus() {
        DynamicObject d;
        long id = this.getModel().getDataEntity().getLong("id");
        if (0L != id && (d = QueryServiceHelper.queryOne((String)"bcm_invelimtemplate", (String)"billstatus", (QFilter[])new QFilter("id", "=", (Object)id).toArray())) != null) {
            return d.get("billstatus");
        }
        return null;
    }

    @Override
    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (CTL_RULEEXPR.equals(key) || CTL_RULEEXPRDEPT.equals(key)) {
            int[] selectRows = ((EntryGrid)this.getView().getControl(CTL_ENTRYENTITY)).getSelectRows();
            if (selectRows.length < 1) {
                return;
            }
            int selectRow = selectRows[0];
            String ruleFormula = (String)this.getModel().getValue(CTL_RULEEXPR, selectRow);
            String ruleFormulasource = (String)this.getModel().getValue("ruleexprsource", selectRow);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bcm_invchangeformula");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            Object billstatus = this.getBillStatus();
            if (billstatus != null) {
                formShowParameter.setCustomParam("enable", billstatus);
            }
            if (StringUtils.isEmpty((String)((String)this.getModel().getValue(key, selectRow)))) {
                formShowParameter.setCustomParam("formula", null);
            } else {
                formShowParameter.setCustomParam("formula", (Object)ruleFormulasource);
            }
            formShowParameter.setCustomParam("sharescaletype", (Object)this.getModel().getDataEntity().getString("invrelatype"));
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
            this.getView().showForm(formShowParameter);
        } else if (CTL_DESCRIPTION.equals(key)) {
            int[] selectRows = ((EntryGrid)this.getView().getControl(CTL_ENTRYENTITY)).getSelectRows();
            if (selectRows.length < 1) {
                return;
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bcm_largertextedit");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            int selectRow = selectRows[0];
            formShowParameter.setCustomParam("textareafield", this.getModel().getValue(CTL_DESCRIPTION, selectRow));
            Object billstatus = this.getBillStatus();
            if (billstatus != null && BillStatus.C.name().equals(billstatus)) {
                formShowParameter.setCustomParam("lock", (Object)Boolean.TRUE);
            }
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
            this.getView().showForm(formShowParameter);
        } else if (SCENARIOSET.equals(key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bcm_templatemutiscenceset");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("model", (Object)this.getModelId());
            formShowParameter.setCustomParam("selecteditems", (Object)this.getPageCache().get(SCENARIOSET));
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
            this.getView().showForm(formShowParameter);
        }
        if (ctr_effectivetext.equals(key)) {
            this.openExpiredDateF7(ctr_effectivetext);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if ((CTL_RULEEXPR.equals(actionId) || CTL_RULEEXPRDEPT.equals(actionId) || CTL_DESCRIPTION.equals(actionId)) && e.getReturnData() != null) {
            int[] selectRows = ((EntryGrid)this.getView().getControl(CTL_ENTRYENTITY)).getSelectRows();
            if (selectRows.length < 1) {
                return;
            }
            int selectRow = selectRows[0];
            HashMap returnData = (HashMap)e.getReturnData();
            if (CTL_DESCRIPTION.equals(actionId)) {
                this.getModel().setValue(CTL_DESCRIPTION, (Object)returnData.getOrDefault("textareafield", ""), selectRow);
                return;
            }
            this.getModel().setValue("ruleexprsource", returnData.get("formula"), selectRow);
            this.getModel().setValue(actionId, returnData.get(NAME), selectRow);
            if (CTL_RULEEXPR.equals(actionId)) {
                this.getModel().setValue(CTL_RULEEXPRDEPT, (Object)"", selectRow);
            } else {
                this.getModel().setValue(CTL_RULEEXPR, (Object)"", selectRow);
            }
        } else if (SCENARIOSET.equals(actionId)) {
            Map returnData = (Map)this.deSerializedBytes((String)e.getReturnData());
            if (Objects.nonNull(returnData)) {
                String name = (String)returnData.get(NAME);
                List items = (List)returnData.get("items");
                this.getModel().deleteEntryData(SCENARIOS);
                if (CollectionUtil.isEmpty((Collection)items)) {
                    this.getModel().setValue(SCENARIOSET, null);
                    this.getPageCache().remove(SCENARIOSET);
                    this.getView().updateView(SCENARIOSET);
                    return;
                }
                this.getModel().batchCreateNewEntryRow(SCENARIOS, items.size());
                AtomicInteger row = new AtomicInteger(0);
                items.forEach(item -> {
                    DynamicObject dynamicObject = this.getModel().getEntryRowEntity(SCENARIOS, row.get());
                    dynamicObject.set("scenariomeb_id", (Object)((Long)item.get("id")));
                    dynamicObject.set("scenarioscope", (Object)((String)item.get("scope")));
                    dynamicObject.set("isexcept", (Object)((String)item.get("isexcept")));
                    row.getAndIncrement();
                });
                this.getModel().setValue(SCENARIOSET, (Object)name);
                this.getPageCache().put(SCENARIOSET, this.toByteSerialized(items));
            }
        } else if (EXPIRED_PERIOD.equals(actionId) && Objects.nonNull(e.getReturnData())) {
            String data = (String)this.deSerializedBytes(String.valueOf(e.getReturnData()));
            JSONObject obj = JSON.parseObject((String)data);
            this.getModel().setValue(ctr_effectivetext, obj.get((Object)"text"));
            this.getModel().deleteEntryData(ctr_effective);
            if (StringUtils.isNotEmpty((String)obj.getString(ctr_effective))) {
                Map effective = (Map)JSON.parseObject((String)obj.getString(ctr_effective), (TypeReference)new TypeReference<Map<String, Set<Long>>>(){}, (Feature[])new Feature[0]);
                if (effective == null || effective.size() == 0) {
                    this.getPageCache().remove(ctr_effectivedata);
                } else {
                    this.getPageCache().put(ctr_effectivedata, JSON.toJSONString((Object)effective));
                    this.dealEffectiveBeforeSave(effective);
                }
            }
        }
    }

    private void dealEffectiveBeforeSave(Map<String, Set<Long>> effective) {
        TreeMap effectiveMap = new TreeMap();
        AtomicInteger lineCount = new AtomicInteger();
        effective.forEach((key, value) -> {
            HashSet set = new HashSet(value);
            effectiveMap.put(key, set);
            lineCount.addAndGet(value.size() == 0 ? 1 : value.size());
        });
        HashSet yearIds = new HashSet();
        effectiveMap.keySet().forEach(k -> yearIds.add(k.split("@")[1]));
        Map years = new HashMap();
        yearIds.remove("null");
        if (yearIds.size() > 0) {
            years = BusinessDataServiceHelper.loadFromCache((String)"bcm_fymembertree", (String)"name, number", (QFilter[])new QFBuilder("id", "in", (Object)LongUtil.toLongList(yearIds)).toArray());
        }
        this.getModel().batchCreateNewEntryRow(ctr_effective, lineCount.get());
        int row = 0;
        for (Map.Entry entry : effectiveMap.entrySet()) {
            String[] split = ((String)entry.getKey()).split("@");
            Set periodIds = (Set)entry.getValue();
            if (periodIds.size() > 0) {
                Collection periodDys = BusinessDataServiceHelper.loadFromCache((String)"bcm_periodmembertree", (String)"id, name, number", (QFilter[])new QFBuilder("id", "in", (Object)periodIds).toArray(), (String)NUMBER).values();
                for (DynamicObject p : periodDys) {
                    DynamicObject rowObj = this.getModel().getEntryRowEntity(ctr_effective, row);
                    rowObj.set("seq", (Object)split[0]);
                    rowObj.set("effectiveyear", split[1].equals("null") ? null : years.get(Long.valueOf(split[1])));
                    rowObj.set("applytype", (Object)split[2]);
                    rowObj.set("yearscope", (Object)split[3]);
                    rowObj.set("effectiveperiod", (Object)p);
                    ++row;
                }
                periodDys.clear();
                continue;
            }
            DynamicObject rowObj = this.getModel().getEntryRowEntity(ctr_effective, row);
            rowObj.set("seq", (Object)split[0]);
            rowObj.set("effectiveyear", split[1].equals("null") ? null : years.get(Long.valueOf(split[1])));
            rowObj.set("applytype", (Object)split[2]);
            rowObj.set("yearscope", (Object)split[3]);
            ++row;
        }
    }

    private String cvtMutiScenarioStr(DynamicObjectCollection returnData) {
        if (CollectionUtil.isEmpty((Collection)returnData)) {
            return "";
        }
        StringJoiner stringJoiner = new StringJoiner(";");
        returnData.forEach(data -> {
            String number = data.getString("scenariomeb.number");
            String name = data.getString("scenariomeb.name");
            String isexcept = data.getString("isexcept");
            String scope = data.getString("scenarioscope");
            stringJoiner.add(PaperTemplateSceneSettingHelper.formateDisplay((String)number, (String)name, (String)scope, (String)isexcept));
        });
        return stringJoiner.toString();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("save".equals(afterDoOperationEventArgs.getOperateKey()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            Object pkid = afterDoOperationEventArgs.getOperationResult().getSuccessPkIds().get(0);
            Map invrelations = BusinessDataServiceHelper.loadFromCache((String)"bcm_invrelation", (String)"invelimtemplate", (QFilter[])new QFilter("invelimtemplate.id", "=", pkid).and("invrelatype", "!=", this.getValue("invrelatype")).toArray());
            invrelations.forEach((id, invrelation) -> invrelation.set("invelimtemplate", (Object)0L));
            SaveServiceHelper.save((DynamicObject[])invrelations.values().toArray(new DynamicObject[0]));
            BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
            if (billShowParameter != null && billShowParameter.getPkId() != null) {
                DynamicObject dataEntityAfter = BusinessDataServiceHelper.loadSingle(pkid, (String)"bcm_invelimtemplate");
                if (billShowParameter.getPkId().equals(pkid)) {
                    if (dataEntityAfter.get("templatecatalog") == null || StringUtils.isEmpty((String)dataEntityAfter.get("templatecatalog").toString())) {
                        QFBuilder qf = new QFBuilder();
                        qf.add(new QFilter(NUMBER, "=", (Object)"root"));
                        qf.add(new QFilter("model", "=", (Object)dataEntityAfter.getLong("model.id")));
                        DynamicObject temp = BusinessDataServiceHelper.loadSingle((String)"bcm_invtemplatecatalog", (String)"id", (QFilter[])qf.toArray());
                        dataEntityAfter.set("templatecatalog", (Object)temp.getLong("id"));
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntityAfter});
                    }
                } else {
                    DynamicObject dataEntitySource = BusinessDataServiceHelper.loadSingle((Object)billShowParameter.getPkId(), (String)"bcm_invelimtemplate");
                    dataEntityAfter.set("templatecatalog", (Object)dataEntitySource.getDynamicObject("templatecatalog"));
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntityAfter});
                }
            }
            this.writeOperationLog(this.getOperationSave(), this.getModel().getValue(BILLNO).toString(), this.getModel().getValue(NAME).toString(), this.getOperationStstusSuccess());
        } else if ("delete".equals(afterDoOperationEventArgs.getOperateKey())) {
            if (afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                this.writeOperationLog(this.getOperationDelete(), this.getModel().getValue(BILLNO).toString(), this.getModel().getValue(NAME).toString(), this.getOperationStstusSuccess());
            } else {
                this.writeOperationLog(this.getOperationDelete(), this.getModel().getValue(BILLNO).toString(), this.getModel().getValue(NAME).toString(), this.getOperationStstusFail());
            }
        } else if ("audit".equals(afterDoOperationEventArgs.getOperateKey())) {
            this.writeLogs(afterDoOperationEventArgs.getOperationResult().isSuccess(), OpItemEnum.ENABLE.getName());
        } else if ("unaudit".equals(afterDoOperationEventArgs.getOperateKey())) {
            this.writeLogs(afterDoOperationEventArgs.getOperationResult().isSuccess(), OpItemEnum.DISABLE.getName());
        }
    }

    private void writeLogs(boolean status, String opName) {
        String billno = (String)this.getModel().getValue(BILLNO);
        String name = ((ILocaleString)this.getModel().getValue(NAME)).getLocaleValue();
        if (status) {
            String logs = String.format("%s %s %s", billno, name, opName + ResultStatusEnum.SUCCESS.getName());
            OperationLogUtil.writeOperationLog((String)opName, (String)logs, (Long)this.getModelId(), (String)"bcm_invelimtemplate");
        } else {
            String logs = String.format("%s %s %s", billno, name, opName + ResultStatusEnum.FAIL.getName());
            OperationLogUtil.writeOperationLog((String)opName, (String)logs, (Long)this.getModelId(), (String)"bcm_invelimtemplate");
        }
    }
}

