/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.helper.InvRelationSetHelper;
import kd.fi.bcm.business.invest.helper.InvRelationTypeHelper;
import kd.fi.bcm.business.invest.helper.InvShareCaseSetHelper;
import kd.fi.bcm.business.invest.model.CtrlHoldingCompanyScheme;
import kd.fi.bcm.business.invest.model.InvShareCaseSet;
import kd.fi.bcm.business.invest.service.InvShareCaseF7Com;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.OrgBizChangeTypeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.invest.InvRelaTypeEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.BlackListUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.util.UserSelectUtil;

public class InvrelationSearchSetPlugin
extends AbstractBaseListPlugin {
    public static List<String> noIntroduceInvType = Arrays.asList(OrgBizChangeTypeEnum.unchangedControlIncre.getValue(), OrgBizChangeTypeEnum.unchangedControlBuy.getValue(), OrgBizChangeTypeEnum.unchangedControlManage.getValue(), OrgBizChangeTypeEnum.unchangedControlDecre.getValue(), OrgBizChangeTypeEnum.unchangedControlChange.getValue(), OrgBizChangeTypeEnum.sameControlParentDisposal.getValue(), OrgBizChangeTypeEnum.sameControlParentNewlyAdded.getValue());
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String MODEL = "model";
    private static final String SHARE_CASE_SET_ENTITY = "sharecaseset";
    private static final String RELATION_DEFINE = "relationdefine";
    private static final List<String> dimKeys = Lists.newArrayList((Object[])new String[]{"scenario"});
    private static final List<String> NO_LEAF_KEYS = Lists.newArrayList((Object[])new String[]{"entity"});
    private static final String SHARE_CASE = "sharecase";
    private static final String SCENARIO = "scenario";
    private static final String ENTIRY = "entity";
    private static final String RANGE = "range";
    private static final String[] BILL_FIELD = new String[]{"entity", "range", "scenario", "sharecase", "creator", "createdate"};
    private InvShareCaseF7Com invShareCaseF7Com;

    @Override
    public void initialize() {
        super.initialize();
        if (BlackListUtils.hasFeatureInCm((String)"CMOther")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap2"});
        }
        HashMap map = new HashMap(16);
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.asMapF7toType(NO_LEAF_KEYS, SingleF7TypeEnum.COMMON, map);
        this.initSingleMemberF7(map);
        this.invShareCaseF7Com = new InvShareCaseF7Com(this.getView());
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), MODEL);
        if (StringUtils.isNotEmpty((CharSequence)modelId)) {
            this.getModel().setValue(MODEL, (Object)modelId);
            this.fillRelationSearchParam(Long.parseLong(modelId));
            this.initCslschemeValue(this.getModelId() + "", false);
            this.loadCtrlOrgSetting();
            this.loadChangeTypeSortSetting();
            this.loadInvShareCaseSetting();
        }
        this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u67e5\u770b", "InvrelationSearchSetPlugin_0", FI_BCM_FORMPLUGIN, "view"), new OPDescMultiLangEnumBridge("\u67e5\u770b\u6210\u529f\u3002", "InvrelationSearchSetPlugin_1", FI_BCM_FORMPLUGIN));
    }

    private void loadChangeTypeSortSetting() {
        this.getModel().deleteEntryData("changetypesortset");
        Map changeTypeModelMap = InvestServiceHelper.getInvChangetypeModel((Long)this.getModelId());
        AtomicInteger row = new AtomicInteger(0);
        changeTypeModelMap.forEach((number, changeModel) -> {
            if (!noIntroduceInvType.contains(changeModel.number())) {
                this.getModel().insertEntryRow("changetypesortset", row.get());
                this.getModel().setValue("number", number, row.get());
                this.getModel().setValue("name", (Object)changeModel.name(), row.get());
                this.getModel().setValue("isdefault", (Object)changeModel.isdefault(), row.get());
                row.incrementAndGet();
            }
        });
    }

    private void loadInvShareCaseSetting() {
        this.getModel().deleteEntryData(SHARE_CASE_SET_ENTITY);
        long modelId = this.getModelId();
        List invShareCaseSets = InvShareCaseSetHelper.queryBy((long)modelId);
        for (int i = 0; i < invShareCaseSets.size(); ++i) {
            InvShareCaseSet dys = (InvShareCaseSet)invShareCaseSets.get(i);
            this.getModel().insertEntryRow(SHARE_CASE_SET_ENTITY, i);
            for (String field : BILL_FIELD) {
                this.getModel().setValue(field, dys.get(field), i);
            }
        }
    }

    private void loadCtrlOrgSetting() {
        this.getModel().deleteEntryData("ctrlpeeksetting");
        Long cslId = (Long)this.getModel().getValue("cslscheme_id");
        if (cslId == null) {
            return;
        }
        CtrlHoldingCompanyScheme ctrlHoldingCompanyScheme = new CtrlHoldingCompanyScheme(Long.valueOf(this.getModelId()), cslId);
        Map ctrl2MergePoolMap = ctrlHoldingCompanyScheme.getCtrlPeekConfigSetting();
        AtomicInteger row = new AtomicInteger(0);
        ctrl2MergePoolMap.forEach((ctrlorg, peekPool) -> peekPool.getNum2peekMap().forEach((mergeNum, isPeek) -> {
            this.getModel().insertEntryRow("ctrlpeeksetting", row.get());
            this.getModel().setValue("ctrlorg", ctrlorg, row.get());
            this.getModel().setValue("mergeorg", mergeNum, row.get());
            this.getModel().setValue("ispeek", isPeek, row.get());
            row.incrementAndGet();
        }));
    }

    private void fillRelationSearchParam(Long modelId) {
        InvRelationSetHelper.consumeBy((long)modelId, invParams -> {
            boolean isEmpty = invParams == null;
            IDataModel iDataModel = this.getModel();
            iDataModel.setValue("directeown", (Object)(!isEmpty && invParams.getBoolean("directeown") ? 1 : 0));
            iDataModel.setValue("indireownsum", (Object)(!isEmpty && invParams.getBoolean("indireownsum") ? 1 : 0));
            iDataModel.setValue("indireownmul", (Object)(!isEmpty && invParams.getBoolean("indireownmul") ? 1 : 0));
            iDataModel.setValue("inshareeown", (Object)(!isEmpty && invParams.getBoolean("inshareeown") ? 1 : 0));
            iDataModel.setValue("intrashareeown", (Object)(!isEmpty && invParams.getBoolean("intrashareeown") ? 1 : 0));
            iDataModel.setValue("showinvalidentity", (Object)(!isEmpty && invParams.getBoolean("showinvalidentity") ? 1 : 0));
            iDataModel.setValue("supportruleexc", (Object)(!isEmpty && invParams.getBoolean("supportruleexc") ? 1 : 0));
            iDataModel.setValue("includesameparent", (Object)(!isEmpty && invParams.getBoolean("includesameparent") ? 1 : 0));
            iDataModel.setValue("totalscore", (Object)(!isEmpty && invParams.getBoolean("totalscore") ? 1 : 0));
            iDataModel.setValue("accuracy", (Object)(!isEmpty ? invParams.getString("accuracy").trim() : "2"));
        });
        this.loadRelationDefine();
    }

    private void loadRelationDefine() {
        this.getModel().deleteEntryData(RELATION_DEFINE);
        InvRelationTypeHelper.consumeStaticRelationsType((long)this.getModelId(), (number, name, isUse, i) -> {
            this.getModel().insertEntryRow(RELATION_DEFINE, i.intValue());
            this.getModel().setValue("typenumber", number, i.intValue());
            this.getModel().setValue("typename", name, i.intValue());
            this.getModel().setValue("status", isUse, i.intValue());
        });
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
        BasedataEdit cslscheme = (BasedataEdit)this.getControl("cslscheme");
        if (cslscheme != null) {
            cslscheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit entity = (BasedataEdit)this.getControl(ENTIRY);
        entity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.invShareCaseF7Com.registerF7Filter(this.getModelId());
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String f7Key = beforeF7SelectEvent.getProperty().getName();
        if (ENTIRY.equals(f7Key)) {
            QFilter qFilters = new QFilter(MODEL, "=", (Object)this.getModelId());
            qFilters.and("isleaf", "=", (Object)Character.valueOf('0'));
            qFilters.and("number", "!=", (Object)"Entity");
            BasedataEditSingleMemberF7 entityEdit = (BasedataEditSingleMemberF7)this.getControl(ENTIRY);
            entityEdit.setCustomFilter(qFilters);
            beforeF7SelectEvent.getCustomQFilters().add(qFilters);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_save": {
                this.actionSave();
                break;
            }
        }
    }

    private void actionSave() {
        long model = this.getModelId();
        if (model == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvrelationSearchSetPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        IDataModel iDataModel = this.getModel();
        Boolean directeown = (Boolean)iDataModel.getValue("directeown");
        Boolean indireownsum = (Boolean)iDataModel.getValue("indireownsum");
        Boolean indireownmul = (Boolean)iDataModel.getValue("indireownmul");
        Boolean inshareeown = (Boolean)iDataModel.getValue("inshareeown");
        Boolean intrashareeown = (Boolean)iDataModel.getValue("intrashareeown");
        Boolean showinvalidentity = (Boolean)iDataModel.getValue("showinvalidentity");
        Boolean supportruleexc = (Boolean)iDataModel.getValue("supportruleexc");
        Boolean includesameparent = (Boolean)iDataModel.getValue("includesameparent");
        String accuracy = StringUtils.isNotEmpty((CharSequence)((String)iDataModel.getValue("accuracy"))) ? (String)iDataModel.getValue("accuracy") : "2";
        Boolean totalscore = (Boolean)iDataModel.getValue("totalscore");
        DynamicObjectCollection relationDefine = this.getModel().getDataEntity(true).getDynamicObjectCollection(RELATION_DEFINE);
        HashMap<String, Pair> relationDefineMap = new HashMap<String, Pair>(32);
        boolean haveCheck = false;
        for (DynamicObject dynamicObject : relationDefine) {
            String number = dynamicObject.getString("typenumber");
            OrmLocaleValue typename = (OrmLocaleValue)dynamicObject.get("typename");
            boolean check = dynamicObject.getBoolean("status");
            if (check && StringUtils.isBlank((CharSequence)typename.getLocaleValue())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u542f\u7528\u81ea\u5b9a\u4e49\u6301\u80a1\u7c7b\u578b\u8bf7\u586b\u5199\u540d\u79f0\u3002", (String)"InvrelationSearchSetPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            relationDefineMap.put(number, Pair.onePair((Object)typename, (Object)check));
            haveCheck = haveCheck || check;
        }
        if (directeown.booleanValue() || indireownsum.booleanValue() || indireownmul.booleanValue() || inshareeown.booleanValue() || intrashareeown.booleanValue() || haveCheck) {
            PlatUtil.executeWithTX(tx -> {
                InvRelationTypeHelper.updateStaticRelationsType((long)model, number2Dy -> {
                    Optional.ofNullable(number2Dy.get(InvRelaTypeEnum.DirectRelaType.getType())).ifPresent(p -> p.set("status", (Object)directeown));
                    Optional.ofNullable(number2Dy.get(InvRelaTypeEnum.INDirectRelaType.getType())).ifPresent(p -> p.set("status", (Object)indireownsum));
                    Optional.ofNullable(number2Dy.get(InvRelaTypeEnum.MultiRelaType.getType())).ifPresent(p -> p.set("status", (Object)indireownmul));
                    Optional.ofNullable(number2Dy.get(InvRelaTypeEnum.SameLevelRelaType.getType())).ifPresent(p -> p.set("status", (Object)inshareeown));
                    Optional.ofNullable(number2Dy.get(InvRelaTypeEnum.MinRelaType.getType())).ifPresent(p -> p.set("status", (Object)intrashareeown));
                    relationDefineMap.forEach((k, v) -> {
                        Optional dynamicObject = Optional.ofNullable(number2Dy.get(k));
                        dynamicObject.ifPresent(p -> p.set("name", v.p1));
                        dynamicObject.ifPresent(p -> p.set("status", v.p2));
                    });
                });
                InvRelationSetHelper.doSave((long)model, () -> {
                    DynamicObject invParam = InvRelationSetHelper.saveParamData((long)this.getModelId(), (Boolean)directeown, (Boolean)indireownsum, (Boolean)indireownmul, (Boolean)inshareeown, (Boolean)intrashareeown, (Boolean)showinvalidentity, (Boolean)supportruleexc, (Boolean)includesameparent);
                    invParam.set("totalscore", (Object)totalscore);
                    invParam.set("accuracy", (Object)accuracy);
                    return invParam;
                });
                this.saveRelationPeekParam();
                this.saveInvShareCaseSetting();
                this.saveChangeTypeSortParam();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"InvrelationSearchSetPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                this.getModel().setDataChanged(false);
            });
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u4fdd\u5b58", "InvrelationSearchSetPlugin_6", FI_BCM_FORMPLUGIN, "save"), new OPDescMultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f\u3002", "InvrelationSearchSetPlugin_5", FI_BCM_FORMPLUGIN));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5168\u7a7a\uff0c\u81f3\u5c11\u9700\u52fe\u90091\u9879", (String)"InvrelationSearchSetPlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u4fdd\u5b58", "InvrelationSearchSetPlugin_6", FI_BCM_FORMPLUGIN, "save"), new OPDescMultiLangEnumBridge("\u4fdd\u5b58\u5931\u8d25", "InvrelationSearchSetPlugin_8", FI_BCM_FORMPLUGIN));
        }
    }

    private void saveChangeTypeSortParam() {
        DynamicObject[] invChangeTypes;
        HashMap<String, DynamicObject> resultMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject invChangeType : invChangeTypes = BusinessDataServiceHelper.load((String)"bcm_invchangetype", (String)"id,number,dseq", (QFilter[])new QFBuilder(MODEL, "=", (Object)this.getModelId()).and("enable", "=", (Object)"1").toArray(), (String)"model desc")) {
            resultMap.computeIfAbsent(invChangeType.getString("number"), a -> invChangeType);
        }
        DynamicObjectCollection setting = this.getModel().getDataEntity(true).getDynamicObjectCollection("changetypesortset");
        for (int i = 0; i < setting.size(); ++i) {
            DynamicObject invChangeType = (DynamicObject)resultMap.get(((DynamicObject)setting.get(i)).getString("number"));
            if (invChangeType == null) continue;
            invChangeType.set("dseq", (Object)(i + 1));
        }
        SaveServiceHelper.save((DynamicObject[])resultMap.values().toArray(new DynamicObject[0]));
        InvestServiceHelper.clearInvChangetypeSettingCache((Long)this.getModelId());
    }

    private void saveInvShareCaseSetting() {
        DynamicObjectCollection setting = this.getModel().getDataEntity(true).getDynamicObjectCollection(SHARE_CASE_SET_ENTITY);
        if (!setting.isEmpty()) {
            this.checkShareCase(setting);
        }
        InvShareCaseSetHelper.saveBatch((Collection)setting, (long)this.getModelId());
    }

    private void checkShareCase(DynamicObjectCollection dynamicObjects) {
        Iterator iterator = dynamicObjects.iterator();
        HashMap<String, DynamicObject> caseMap = new HashMap<String, DynamicObject>(16);
        while (iterator.hasNext()) {
            DynamicObject next = (DynamicObject)iterator.next();
            Object scenario = next.get(SCENARIO);
            Object shareCase = next.get(SHARE_CASE);
            Object entity = next.get(ENTIRY);
            Object range = next.get(RANGE);
            if (Objects.isNull(scenario) || Objects.isNull(shareCase) || Objects.isNull(entity) || Objects.isNull(range)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u80a1\u6743\u65b9\u6848\u6620\u5c04\u5fc5\u5f55\u6821\u9a8c\u4e0d\u901a\u8fc7\u3002", (String)"InvrelationSearchSetPlugin_15", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            StringJoiner casesetStr = new StringJoiner("#");
            casesetStr.add(((DynamicObject)entity).getString("number"));
            casesetStr.add(((DynamicObject)scenario).getString("number"));
            casesetStr.add(((DynamicObject)shareCase).getString("number"));
            casesetStr.add(String.valueOf(range));
            if (caseMap.containsKey(casesetStr.toString())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u80a1\u6743\u65b9\u6848\u6620\u5c04\u914d\u7f6e\u91cd\u590d\u3002", (String)"InvrelationSearchSetPlugin_16", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            caseMap.put(casesetStr.toString(), next);
        }
    }

    private void saveRelationPeekParam() {
        Long cslId = (Long)this.getModel().getValue("cslscheme_id");
        if (cslId == null || cslId == 0L) {
            return;
        }
        DynamicObjectCollection configsettings = this.getModel().getDataEntity(true).getDynamicObjectCollection("ctrlpeeksetting");
        if (configsettings.isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> toAddNewList = new ArrayList<DynamicObject>(configsettings.size());
        for (DynamicObject config : configsettings) {
            DynamicObject ctrlConfig = BusinessDataServiceHelper.newDynamicObject((String)"bcm_ctrlorgsetting");
            ctrlConfig.set(MODEL, (Object)this.getModelId());
            ctrlConfig.set("cslscheme", (Object)cslId);
            ctrlConfig.set("ctrlorg", config.get("ctrlorg"));
            ctrlConfig.set("mergeorg", config.get("mergeorg"));
            ctrlConfig.set("ispeek", config.get("ispeek"));
            toAddNewList.add(ctrlConfig);
        }
        PlatUtil.executeWithTX(tx -> {
            QFBuilder ctrlOrgQb = new QFBuilder(MODEL, "=", (Object)this.getModelId());
            ctrlOrgQb.add("cslscheme", "=", (Object)cslId);
            DeleteServiceHelper.delete((String)"bcm_ctrlorgsetting", (QFilter[])ctrlOrgQb.toArray());
            if (toAddNewList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])toAddNewList.toArray(new DynamicObject[0]));
            }
        });
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult resultObj = messageBoxClosedEvent.getResult();
        if ("beforeClosed".equals(callBackId) && MessageBoxResult.Yes == resultObj) {
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        if (MODEL.equals(fieldKey)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newValue != null) {
                String modelId = newValue.getString("id");
                UserConfigServiceHelper.clearSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)"bcm_invrelation_set");
                UserConfigServiceHelper.setSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)"bcm_invrelation_set", (String)newValue.getString("id"));
                this.initCslschemeValue(this.getModelId() + "", false);
                this.fillRelationSearchParam(Long.valueOf(modelId));
                this.loadCtrlOrgSetting();
                this.loadInvShareCaseSetting();
                this.loadChangeTypeSortSetting();
                this.getModel().setDataChanged(false);
            } else {
                this.getModel().setValue(MODEL, oldValue);
            }
        } else if ("cslscheme".equals(fieldKey)) {
            this.loadCtrlOrgSetting();
        }
    }

    @Override
    public long getModelId() {
        return (Long)this.getModel().getValue("model_id");
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        boolean ischanged = this.getModel().getDataChanged();
        if (ischanged) {
            e.setCancel(true);
            String msg = ResManager.loadKDString((String)"\u6709\u672a\u4fdd\u5b58\u7684\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\u9000\u51fa\u64cd\u4f5c\uff1f", (String)"InvrelationSearchSetPlugin_13", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("beforeClosed", (IFormPlugin)this));
        }
    }
}

