/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ScenePeriodServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.IOperationLog;

public class MergeNodeImportPlugin
implements IImportPlugin,
IOperationLog {
    private static final String NUMBER = "number";
    private static final String SHOWNUMBER = "shownumber";
    private static final String MODEL = "model";
    private static final String SCENA = "scenario";
    private static final String PERIOD = "period";
    private static final String YEAR = "year";
    private static final String ORG = "org";
    public static final String BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private Long model;
    private Long scenario;
    private Long year;
    private Long period;
    private DynamicObject creator;
    private String orgNumb;
    private Long orgId;
    private Long orgbaseId;
    private String modelnumber;
    private List<Object> emptyList = new ArrayList<Object>();
    private StringBuffer errorMessage = new StringBuffer();

    private String getOperationStstusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"MergeStructImportPlugin_2", (String)BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"MergeStructImportPlugin_1", (String)BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private String getOperationImport() {
        return ResManager.loadKDString((String)"\u5bfc\u5165", (String)"MergeStructImportPlugin_0", (String)BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    public void init(Map<String, Object> importParams) {
        super.init(importParams);
    }

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        if (!(this.checkRequiredParams(data) && this.checkMergeNoSubmit(data) && this.checkEntityPerm(data) && this.checkScenePeriod())) {
            importlogs.add(new ImportLogger.ImportLog(this.errorMessage.toString()));
            this.errorMessage.delete(0, this.errorMessage.length());
            this.writeMultiLangLog(OpItemEnum.IMPORT.getOpMultiLangEnumBridge(), new OPDescMultiLangEnumBridge("\u5bfc\u5165\u6210\u529f\u3002", "MergeNodeImportPlugin_7", BCM_FORMPLUGIN));
            return false;
        }
        return true;
    }

    public List<Object> importData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        List<Object> list = this.overrideNew(data, option, importlogs);
        if (importlogs.size() > 0) {
            this.writeMultiLangLog(OpItemEnum.IMPORT.getOpMultiLangEnumBridge(), new OPDescMultiLangEnumBridge("\u5bfc\u5165\u5931\u8d25\u3002", "MergeNodeImportPlugin_8", BCM_FORMPLUGIN));
        } else {
            this.writeMultiLangLog(OpItemEnum.IMPORT.getOpMultiLangEnumBridge(), new OPDescMultiLangEnumBridge("\u5bfc\u5165\u6210\u529f\u3002", "MergeNodeImportPlugin_7", BCM_FORMPLUGIN));
        }
        return list;
    }

    private boolean isExist(Map<String, Object> data) {
        String selectField = "id,org,model,scenario,year,period,modifier,modifytime,mergedatasource";
        this.creator = BusinessDataServiceHelper.loadSingle((String)"bcm_mergesetentity", (String)selectField, (QFilter[])this.getUniqueFilters(data));
        return this.creator != null;
    }

    private List<Object> addNew(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        if (this.isExist(data)) {
            importlogs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"\u672c\u6761\u7ec4\u7ec7\u4e3a\u201c%s\u201d\u7684\u6570\u636e\u5df2\u5b58\u5728,\u65e0\u6cd5\u65b0\u589e\u3002", (String)"MergeNodeImportPlugin_3", (String)BCM_FORMPLUGIN, (Object[])new Object[0]), this.orgNumb)));
            return this.emptyList;
        }
        return this.saveData(data, importlogs);
    }

    private List<Object> override(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        if (!this.isExist(data)) {
            importlogs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"\u672c\u6761\u7ec4\u7ec7\u4e3a\u201c%s\u201d\u7684\u6570\u636e\u4e0d\u5b58\u5728,\u4e0d\u652f\u6301\u8986\u76d6\u3002", (String)"MergeNodeImportPlugin_4", (String)BCM_FORMPLUGIN, (Object[])new Object[0]), this.orgNumb)));
            return this.emptyList;
        }
        return this.saveData(data, importlogs);
    }

    private List<Object> overrideNew(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        this.isExist(data);
        return this.saveData(data, importlogs);
    }

    private List<Object> saveData(Map<String, Object> data, List<ImportLogger.ImportLog> importlogs) {
        ArrayList<Object> success = new ArrayList<Object>();
        if (this.creator == null) {
            this.creator = BusinessDataServiceHelper.newDynamicObject((String)"bcm_mergesetentity");
            this.creator.set(MODEL, (Object)this.model);
            this.creator.set(SCENA, (Object)this.scenario);
            this.creator.set(YEAR, (Object)this.year);
            this.creator.set(PERIOD, (Object)this.period);
            this.creator.set(ORG, (Object)this.orgbaseId);
        }
        this.creator.set("mergedatasource", data.get("mergedatasource"));
        this.creator.set("modifier", (Object)RequestContext.get().getUserId());
        this.creator.set("modifytime", (Object)TimeServiceHelper.now());
        HashMap<Long, String> dataMap = new HashMap<Long, String>();
        dataMap.put(this.orgId, (String)data.get("mergedatasource"));
        try (TXHandle tx = TX.required();){
            try {
                Object[] successIds = null;
                successIds = MergeControlHelper.saveMergeDataSet((long)this.model, (long)this.scenario, (long)this.year, (long)this.period, dataMap);
                if (successIds.length > 0) {
                    success.add(((DynamicObject)successIds[0]).get("id"));
                } else {
                    success.add(this.creator.get("org.id"));
                }
            }
            catch (Exception e) {
                importlogs.add(new ImportLogger.ImportLog(e.getMessage()));
                tx.markRollback();
                List<Object> list = null;
                if (tx != null) {
                    if (var6_6 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return list;
            }
        }
        return success;
    }

    private QFilter[] getUniqueFilters(Map<String, Object> data) {
        QFilter qf = new QFilter(MODEL, "=", (Object)this.model);
        qf.and(SCENA, "=", (Object)this.scenario);
        qf.and(YEAR, "=", (Object)this.year);
        qf.and(PERIOD, "=", (Object)this.period);
        qf.and(ORG, "=", (Object)this.orgbaseId);
        return new QFilter[]{qf};
    }

    private boolean checkRequiredParams(Map<String, Object> data) {
        return this.validateModel(data) && this.volidateScenario(data) && this.volidateYear(data) && this.volidatePeriod(data) && this.volidateEntity(data) && this.volidateMergeSet(data);
    }

    private boolean checkEntityPerm(Map<String, Object> data) {
        if (!this.checkOrgMemberIsReadWrite(String.valueOf(this.orgId))) {
            this.errorMessage.append(ResManager.loadKDString((String)"\u7ec4\u7ec7\u65e0\u6743\u64cd\u4f5c\u3002", (String)"MergeNodeImportPlugin_0", (String)BCM_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (!this.checkOrgPeriodOpen(this.model, this.orgId, this.scenario, this.year, this.period)) {
            IDNumberTreeNode node = MemberReader.findEntityMemberById((Long)this.model, (Long)this.orgId);
            this.errorMessage.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%s\u6570\u636e\u671f\u95f4\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"MergeNodeImportPlugin_6", (String)BCM_FORMPLUGIN, (Object[])new Object[0]), node.getNumber()));
            return false;
        }
        return true;
    }

    private boolean checkOrgMemberIsReadWrite(String orgId) {
        long dimensionId = MemberReader.getDimensionIdByNum((long)this.model, (String)PresetConstant.ENTITY_DIM);
        return PermissionServiceImpl.getInstance((Long)this.model).isAllWritePerm(Long.valueOf(dimensionId), "bcm_entitymembertree", (Collection)Sets.newHashSet((Object[])new Long[]{LongUtil.toLong((Object)orgId)}));
    }

    private boolean checkOrgPeriodOpen(Long modelId, Long orgId, Long scenarioId, Long fyId, Long periodId) {
        IDNumberTreeNode node = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        if (IDNumberTreeNode.NotFoundTreeNode != node && !PeriodSettingHelper.checkPeriodStatus((long)modelId, (String)node.getNumber(), (long)scenarioId, (long)fyId, (long)periodId, (String)"datastatus")) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private boolean checkMergeNoSubmit(Map<String, Object> data) {
        Map mcStatusMap = InvestServiceHelper.filterSubmitNode((Long)this.model, (Long)this.scenario, (Long)this.year, (Long)this.period, (Set)Sets.newHashSet((Object[])new Long[]{this.orgId}));
        if (mcStatusMap != null && mcStatusMap.size() > 0) {
            this.errorMessage.append(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\u8282\u70b9\u72b6\u6001\u5df2\u63d0\u4ea4\u6216\u5df2\u5f52\u6863\u3002", (String)"MergeNodeImportPlugin_1", (String)BCM_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean volidateMergeSet(Map<String, Object> data) {
        boolean result = true;
        String mergedatasource = (String)data.get("mergedatasource");
        if (StringUtils.isBlank((CharSequence)mergedatasource)) {
            this.errorMessage.append(ResManager.loadKDString((String)"\u5408\u5e76\u6570\u636e\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"MergeNodeImportPlugin_2", (String)BCM_FORMPLUGIN, (Object[])new Object[0]));
            result = false;
        }
        return result;
    }

    private boolean volidateEntity(Map<String, Object> data) {
        boolean result = true;
        if (data.get(ORG) == null) {
            this.errorMessage.append(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MergeStructImportPlugin_7", (String)BCM_FORMPLUGIN, (Object[])new Object[0]));
            result = false;
        } else {
            String orgnumb = (String)((JSONObject)data.get(ORG)).get((Object)NUMBER);
            this.orgNumb = orgnumb.trim();
            IDNumberTreeNode entityMember = MemberReader.findEntityMemberByNum((String)this.modelnumber, (String)orgnumb);
            if (IDNumberTreeNode.NotFoundTreeNode.equals(entityMember)) {
                this.errorMessage.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u7ec4\u7ec7\u7f16\u7801[%s]\u4e0d\u5b58\u5728\uff01", (String)"MergeStructImportPlugin_19", (String)BCM_FORMPLUGIN, (Object[])new Object[0]), this.orgNumb));
                result = false;
            } else {
                this.orgbaseId = entityMember.getCopyfromId() != null && entityMember.getCopyfromId() != 0L ? entityMember.getCopyfromId() : entityMember.getId();
                this.orgId = entityMember.getId();
            }
        }
        return result;
    }

    private boolean volidatePeriod(Map<String, Object> data) {
        boolean result = true;
        if (data.get(PERIOD) == null) {
            this.errorMessage.append(ResManager.loadKDString((String)"\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MergeStructImportPlugin_26", (String)BCM_FORMPLUGIN, (Object[])new Object[0]));
            result = false;
        } else {
            JSONObject periodJson = (JSONObject)data.get(PERIOD);
            String periodnum = (String)periodJson.get((Object)NUMBER);
            IDNumberTreeNode periodMember = MemberReader.findPeriodMemberByNum((String)this.modelnumber, (String)periodnum);
            if (IDNumberTreeNode.NotFoundTreeNode.equals(periodMember)) {
                this.errorMessage.append(String.format(ResManager.loadKDString((String)"\u671f\u95f4[%s]\u4e0d\u5b58\u5728\uff01", (String)"MergeStructImportPlugin_18", (String)BCM_FORMPLUGIN, (Object[])new Object[0]), periodnum));
                result = false;
            } else {
                this.period = periodMember.getId();
            }
        }
        return result;
    }

    private boolean volidateYear(Map<String, Object> data) {
        boolean result = true;
        if (data.get(YEAR) == null) {
            this.errorMessage.append(ResManager.loadKDString((String)"\u8d22\u5e74\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"MergeStructImportPlugin_23", (String)BCM_FORMPLUGIN, (Object[])new Object[0]));
            result = false;
        } else {
            JSONObject yearJson = (JSONObject)data.get(YEAR);
            String yearnum = (String)yearJson.get((Object)NUMBER);
            IDNumberTreeNode fyMember = MemberReader.findFyMemberByNum((String)this.modelnumber, (String)yearnum);
            if (IDNumberTreeNode.NotFoundTreeNode.equals(fyMember)) {
                this.errorMessage.append(String.format(ResManager.loadKDString((String)"\u8d22\u5e74[%s]\u4e0d\u5b58\u5728\uff01", (String)"MergeStructImportPlugin_17", (String)BCM_FORMPLUGIN, (Object[])new Object[0]), yearnum));
                result = false;
            } else {
                this.year = fyMember.getId();
            }
        }
        return result;
    }

    private boolean volidateScenario(Map<String, Object> data) {
        boolean result = true;
        if (data.get(SCENA) == null) {
            this.errorMessage.append(ResManager.loadKDString((String)"\u60c5\u666f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"MergeStructImportPlugin_22", (String)BCM_FORMPLUGIN, (Object[])new Object[0]));
            result = false;
        } else {
            JSONObject scenarioJson = (JSONObject)data.get(SCENA);
            String scenarionum = (String)scenarioJson.get((Object)NUMBER);
            IDNumberTreeNode scenaMember = MemberReader.findScenaMemberByNum((String)this.modelnumber, (String)scenarionum);
            if (IDNumberTreeNode.NotFoundTreeNode.equals(scenaMember)) {
                this.errorMessage.append(String.format(ResManager.loadKDString((String)"\u60c5\u666f[%s]\u4e0d\u5b58\u5728\uff01", (String)"MergeStructImportPlugin_16", (String)BCM_FORMPLUGIN, (Object[])new Object[0]), scenarionum));
                result = false;
            } else {
                this.scenario = scenaMember.getId();
            }
        }
        return result;
    }

    private boolean validateModel(Map<String, Object> data) {
        boolean result = true;
        if (data.get(MODEL) == null) {
            this.errorMessage.append(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"MergeStructImportPlugin_25", (String)BCM_FORMPLUGIN, (Object[])new Object[0]));
            result = false;
        } else {
            JSONObject modelJson = (JSONObject)data.get(MODEL);
            String shownumber = (String)modelJson.get((Object)SHOWNUMBER);
            try {
                this.modelnumber = MemberReader.findModelNumberByShowNum((String)shownumber);
                this.model = MemberReader.findModelIdByNum((String)this.modelnumber);
            }
            catch (Exception e) {
                this.errorMessage.append(String.format(ResManager.loadKDString((String)"\u4f53\u7cfb[%s]\u4e0d\u5b58\u5728\uff01", (String)"MergeStructImportPlugin_14", (String)BCM_FORMPLUGIN, (Object[])new Object[0]), shownumber));
                result = false;
            }
        }
        return result;
    }

    @Override
    public String getBizEntityNumber() {
        return null;
    }

    @Override
    public String getBizAppId() {
        return null;
    }

    @Override
    public void writeLog(String opName, String opDescriotion) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((String)opName, (String)opDescriotion, (Long)(this.model == null ? null : this.model), (String)"bcm_invrelation_search");
        logService.addLog(logInfo);
    }

    private boolean checkScenePeriod() {
        if (Objects.isNull(this.model) || this.model == 0L || Objects.isNull(this.scenario) || this.scenario == 0L || Objects.isNull(this.period) || this.period == 0L) {
            return true;
        }
        IDNumberTreeNode sceneMember = MemberReader.findScenaMemberById((Long)this.model, (Long)this.scenario);
        String sceneNumber = sceneMember.getNumber();
        List periodIds = ScenePeriodServiceHelper.getScenePeriodByModel((Long)this.model, Collections.singletonList(sceneNumber)).getOrDefault(sceneNumber, Collections.emptyList());
        if (!periodIds.contains(this.period)) {
            this.errorMessage.append(String.format(ResManager.loadKDString((String)"\u6e90\u671f\u95f4%1$s\u4e0d\u5b58\u5728\u4e8e\u201c\u6e90\u60c5\u666f%2$s\u201d\u7684\u9002\u7528\u671f\u95f4\u3002", (String)"MergeNodeImportPlugin_5", (String)BCM_FORMPLUGIN, (Object[])new Object[0]), MemberReader.findPeriodMemberById((Long)this.model, (Long)this.period).getNumber(), sceneNumber));
            return false;
        }
        return true;
    }
}

