/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.invratio.InvRelationSearchService;
import kd.fi.bcm.business.invest.service.InvMergeStructValidator;
import kd.fi.bcm.business.invest.service.InvValidateHelper;
import kd.fi.bcm.business.invest.service.InvValidator;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.mergecontrol.MergeStatusHelper;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.UserUtils;
import kd.fi.bcm.formplugin.impexport.BillResult;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class MergeStructImportNewPlugin
extends BatchImportPlugin {
    private static Log log = LogFactory.getLog(MergeStructImportNewPlugin.class);
    private static final String FI_BCM_FORM_PLUGIN = "fi-bcm-formplugin";
    private DynamicObject model;
    private DynamicObject scenario;
    private DynamicObject year;
    private DynamicObject period;
    private long selectedNodeId;

    protected boolean isForceBatch() {
        return true;
    }

    protected int getBatchImportSize() {
        return 50000;
    }

    public void beforeSave(List<ImportBillData> billDatas, ImportLogger logger) {
        this.intModelAndPermMap();
        if (Objects.isNull(this.model) || Objects.isNull(this.year) || Objects.isNull(this.scenario) || Objects.isNull(this.period) || this.selectedNodeId == 0L) {
            billDatas.clear();
            this.writeOperationLog(ResManager.loadKDString((String)"F7\u7ef4\u5ea6\u4fe1\u606f\u4e0d\u8db3 \u3002", (String)"InvDynamicStockRadioImportPlugin_2", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), billDatas.size(), 0);
        }
        super.beforeSave(billDatas, logger);
    }

    private void intModelAndPermMap() {
        try {
            Class<?> aClass = this.ctx.getClass();
            Field view = aClass.getDeclaredField("view");
            ReflectionUtils.makeAccessible((Field)view);
            IFormView formView = (IFormView)view.get(this.ctx);
            IFormView parentView = formView.getParentView();
            this.model = (DynamicObject)parentView.getModel().getValue("model");
            this.scenario = (DynamicObject)parentView.getModel().getValue("scenario");
            this.year = (DynamicObject)parentView.getModel().getValue("year");
            this.period = (DynamicObject)parentView.getModel().getValue("period");
            String selectedNodeId = parentView.getPageCache().get("nodeSelected");
            this.selectedNodeId = LongUtil.toLong((Object)selectedNodeId);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    public ApiResult save(List<ImportBillData> importBillDataList, ImportLogger logger) {
        ApiResult result = new ApiResult();
        result.setSuccess(true);
        long modelId = this.model.getLong("id");
        long yearId = this.year.getLong("id");
        long scenarioId = this.scenario.getLong("id");
        long periodId = this.period.getLong("id");
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        ArrayList<Map<String, Object>> rowRs = new ArrayList<Map<String, Object>>(16);
        HashMap<String, List> orgUnitMap = new HashMap<String, List>(16);
        HashSet<String> mergeMethodSet = new HashSet<String>(16);
        HashMap<String, Integer> dataIndex = new HashMap<String, Integer>(16);
        InvValidateHelper<JSONObject> jsonValidateHelper = this.jsonObjectValidateHelper();
        for (int i = 0; i < importBillDataList.size(); ++i) {
            String mergeMethod;
            String orgNum;
            List<String> validateRs = new ArrayList(16);
            ImportBillData importBillData = importBillDataList.get(i);
            JSONObject data = importBillData.getData();
            validateRs = jsonValidateHelper.doValidate((Object)data);
            validateRs.addAll(this.validationF7Data(data));
            BillResult rs = new BillResult();
            rs.setIndex(i);
            if (CollectionUtils.isNotEmpty(validateRs)) {
                rs.setMessage(String.join((CharSequence)" ", validateRs));
                rs.setSucess(false);
                rowRs.add(rs.toMap());
                continue;
            }
            String orgParentNum = data.getString("orgpnumber");
            if (dataIndex.containsKey(this.getUniKey(orgParentNum, orgNum = data.getString("orgnumber")))) {
                rs.setMessage(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u6570\u636e\u91cd\u590d\u3002", (String)"MergeStructImportNewPlugin_14", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), this.getUniKey(orgParentNum, orgNum)));
                rs.setSucess(false);
                rowRs.add(rs.toMap());
                continue;
            }
            orgUnitMap.computeIfAbsent(orgParentNum, e -> new ArrayList(16)).add(data);
            Optional<String> method = Optional.ofNullable(data.getJSONObject("mergemethod")).map(e -> e.getString("number"));
            String string = mergeMethod = method.isPresent() ? method.get() : "";
            if (!StringUtils.isBlank((String)mergeMethod)) {
                mergeMethodSet.add(mergeMethod);
            }
            dataIndex.put(this.getUniKey(orgParentNum, orgNum), i);
        }
        DynamicObjectCollection mergemethodCollection = this.getMegerMethodCollection(modelId, mergeMethodSet);
        Map<String, DynamicObject> mergeMethods = mergemethodCollection.stream().collect(Collectors.toMap(k -> k.getString("number"), v -> v, (v1, v2) -> v1));
        HashSet parentIdsTotal = new HashSet(16);
        ArrayList megerStructTotal = new ArrayList(16);
        ArrayList megerStructOrgUnitTotal = new ArrayList(16);
        orgUnitMap.remove("Entity");
        Set orgUnitIds = orgUnitMap.keySet().stream().map(orgUnit -> MemberReader.findEntityMemberByNum((String)modelNum, (String)orgUnit).getId()).collect(Collectors.toSet());
        Set havePermMerge = InvRelationSearchService.dealNoPermOrg(orgUnitIds, (long)modelId);
        Set periodOpenNumber = InvRelationSearchService.batchSelectPeriodStatusOpen((Long)modelId, (Set)Sets.newHashSet(orgUnitMap.keySet()), (Long)scenarioId, (Long)yearId, (Long)periodId, (String)"datastatus");
        boolean structNotCheckSubmitStatus = ConfigServiceHelper.getBoolParam((Long)modelId, (String)"isStructNotCheckSubmitStatus");
        Map mcStatusMap = McStatus.batchGetMcStatus((Object)modelId, orgUnitIds, (Object)scenarioId, (Object)yearId, (Object)periodId);
        HashSet allChildren = new HashSet(16);
        orgUnitMap.keySet().stream().forEach(orgUnit -> allChildren.addAll(MemberReader.findEntityMemberByNum((String)modelNum, (String)orgUnit).getAllChildrenIds()));
        Set effectiveOrg = EntityVersioningUtil.filterEffectiveOrgByMergeStruct((FilterOrgStructParam)new FilterOrgStructParam(modelId, scenarioId, yearId, periodId, false, false), allChildren).keySet();
        orgUnitMap.entrySet().stream().forEach(orgUnitEntry -> {
            String orgUnitNumber = (String)orgUnitEntry.getKey();
            List jsons = (List)orgUnitEntry.getValue();
            IDNumberTreeNode orgUnitNum = MemberReader.findEntityMemberByNum((String)modelNum, (String)orgUnitNumber);
            String msg = "";
            msg = this.validationOrgNode(orgUnitNum);
            if (!(StringUtils.isBlank((String)msg) && StringUtils.isBlank((String)(msg = this.valiationOrgUnitPeriodStatus(orgUnitNumber, periodOpenNumber))) && StringUtils.isBlank((String)(msg = this.valiationOrgUnitPerm(orgUnitNum, havePermMerge))) && (structNotCheckSubmitStatus || StringUtils.isBlank((String)(msg = this.valiationOrgUnitMcStatus(orgUnitNum, mcStatusMap)))))) {
                result.setSuccess(false);
            }
            ArrayList list = new ArrayList(10);
            String finalMsg = msg;
            AtomicBoolean unitOrgIsFull = new AtomicBoolean(true);
            jsons.stream().forEach(json -> {
                IDNumberTreeNode orgNode;
                String mergeMethod;
                String orgnumber = json.getString("orgnumber");
                BillResult rs = new BillResult();
                rs.setIndex((Integer)dataIndex.get(this.getUniKey(orgUnitNumber, orgnumber)));
                if (!StringUtils.isBlank((String)finalMsg)) {
                    unitOrgIsFull.set(false);
                    rs.setMessage(finalMsg);
                    rs.setSucess(false);
                    rowRs.add(rs.toMap());
                    return;
                }
                ArrayList<String> infoRs = new ArrayList<String>(16);
                Optional<String> method = Optional.ofNullable(json.getJSONObject("mergemethod")).map(e -> e.getString("number"));
                String string = mergeMethod = method.isPresent() ? method.get() : "";
                if (!StringUtils.isBlank((String)mergeMethod) && !mergeMethods.containsKey(mergeMethod)) {
                    infoRs.add(String.format(ResManager.loadKDString((String)"\u5408\u5e76\u65b9\u6cd5\u3010%1$s\u3011\u4e0d\u5b58\u5728\uff01", (String)"MergeStructImportNewPlugin_18", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), mergeMethod));
                }
                if ((orgNode = MemberReader.findEntityMemberByNum((String)modelNum, (String)orgnumber)) == IDNumberTreeNode.NotFoundTreeNode) {
                    infoRs.add(String.format(ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9\u3010%1$s\u3011\u4e0b\u7ec4\u7ec7\u7f16\u7801\u3010%2$s\u3011\u4e0d\u5b58\u5728\uff01", (String)"MergeStructImportNewPlugin_11", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), orgUnitNumber, orgnumber));
                } else if (!orgNode.getParent().getNumber().equals(orgUnitNumber) && !orgNode.getShareNodes().stream().anyMatch(org -> org.getParent().getNumber().equals(orgUnitNumber))) {
                    infoRs.add(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u3010%1$s\u3011\u4e0e\u4e0a\u7ea7\u7ec4\u7ec7\u7f16\u7801\u3010%2$s\u3011\u7684\u4e0a\u4e0b\u7ea7\u5173\u7cfb\u4e0d\u6210\u7acb\uff01", (String)"MergeStructImportNewPlugin_12", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), orgnumber, orgUnitNumber));
                } else if (!effectiveOrg.contains(orgNode.getId()) && orgNode.getShareNodes().stream().noneMatch(org -> effectiveOrg.contains(org.getId())) && !ConfigServiceHelper.getBoolParam((Long)modelId, (String)"isMergeInfoStruct")) {
                    String orgNotEffectMsg = ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9\u3010%1$s\u3011\u4e0b\u7ec4\u7ec7\u7f16\u7801\u3010%2$s\u3011\u5728\u5f53\u524d\u671f\u95f4\u65e0\u6548\uff01", (String)"MergeStructImportNewPlugin_13", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
                    infoRs.add(String.format(orgNotEffectMsg, orgUnitNumber, orgnumber));
                }
                if (CollectionUtils.isNotEmpty(infoRs)) {
                    unitOrgIsFull.set(false);
                    rs.setMessage(String.join((CharSequence)",", infoRs));
                    rs.setSucess(false);
                    rowRs.add(rs.toMap());
                    return;
                }
                DynamicObject megerStructInfo = this.buildMegerStructInfo(mergeMethods, orgUnitNumber, (JSONObject)json, mergeMethod, orgnumber);
                list.add(megerStructInfo);
            });
            if (unitOrgIsFull.get() && CollectionUtils.isNotEmpty(list)) {
                megerStructOrgUnitTotal.add(orgUnitNumber);
                megerStructTotal.addAll(list);
                boolean changed = InvestServiceHelper.checkMergeStructChanged((long)modelId, (long)scenarioId, (long)yearId, (long)periodId, (Long)orgUnitNum.getId(), list);
                if (changed) {
                    DynamicObjectCollection orgParents = MergeControlHelper.getOrgParents((long)modelId, (String)orgUnitNum.getLongNumber(), (boolean)false);
                    Set parentIds = orgParents.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
                    parentIds.add(orgUnitNum.getId());
                    parentIdsTotal.addAll(parentIds);
                }
            }
        });
        PlatUtil.executeWithTX(tx -> {
            QFBuilder baseQf = new QFBuilder("model", "=", (Object)modelId);
            baseQf.add("scenario", "=", (Object)scenarioId);
            baseQf.add("year", "=", (Object)yearId);
            baseQf.add("period", "=", (Object)periodId);
            baseQf.add("orgpnumber", "in", (Object)megerStructOrgUnitTotal);
            DeleteServiceHelper.delete((String)"bcm_mergestructinfo", (QFilter[])baseQf.toArray());
            if (!megerStructTotal.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])megerStructTotal.toArray(new DynamicObject[0]));
                InvestServiceHelper.clearMergeStructInfoSettingCache((Long)modelId, (Long)scenarioId, (Long)yearId, (Long)periodId);
            }
            if (CollectionUtils.isNotEmpty((Collection)parentIdsTotal)) {
                MergeStatusHelper.batchUpdateCalcStatus((Long)modelId, (Long)scenarioId, (Long)yearId, (Long)periodId, (Collection)parentIdsTotal);
            }
        });
        if (CollectionUtils.isNotEmpty(rowRs)) {
            result.setSuccess(false);
        } else {
            BillResult rs = new BillResult();
            rs.setSucess(true);
            rowRs.add(rs.toMap());
        }
        result.setData(rowRs);
        return result;
    }

    @NotNull
    private String getUniKey(String orgParentNum, String orgNum) {
        return orgNum + "_" + orgParentNum;
    }

    private List<String> validationF7Data(JSONObject data) {
        ArrayList<String> rs = new ArrayList<String>(16);
        Object model = this.getF7Id(data, this.model, "model", "shownumber");
        Object scenario = this.getF7Id(data, this.scenario, "scenario", "number");
        Object year = this.getF7Id(data, this.year, "year", "number");
        Object period = this.getF7Id(data, this.period, "period", "number");
        this.validationF7Null(model, rs, ResManager.loadKDString((String)"\u4f53\u7cfb", (String)"MergeStructImportNewPlugin_5", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]));
        this.validationF7Null(scenario, rs, ResManager.loadKDString((String)"\u60c5\u666f", (String)"MergeStructImportNewPlugin_6", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]));
        this.validationF7Null(year, rs, ResManager.loadKDString((String)"\u8d22\u5e74", (String)"MergeStructImportNewPlugin_7", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]));
        this.validationF7Null(period, rs, ResManager.loadKDString((String)"\u671f\u95f4", (String)"MergeStructImportNewPlugin_8", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]));
        return rs;
    }

    private void validationF7Null(Object f7, List<String> rs, String dimName) {
        if (!LongUtil.isvalidLong((Object)f7)) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u6838\u5bf9%1$s\u662f\u5426\u6b63\u786e\u3002", (String)"MergeStructImportNewPlugin_20", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
            rs.add(String.format(msg, dimName));
        }
    }

    private DynamicObjectCollection getMegerMethodCollection(long modelId, Set<String> mergeMethodSet) {
        QFilter qModelId = new QFilter("model", "=", (Object)modelId);
        qModelId.and("number", "in", mergeMethodSet);
        DynamicObjectCollection mergemethodCollection = QueryServiceHelper.query((String)"bcm_mergemethod", (String)"id ,number,name,remark", (QFilter[])qModelId.toArray());
        return mergemethodCollection;
    }

    private String valiationOrgUnitPerm(IDNumberTreeNode orgUnitNum, Set<Long> havePermMerge) {
        if (!havePermMerge.contains(orgUnitNum.getId())) {
            String msg = String.format(ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9[%1$s]\u65e0\u5199\u5165\u6743\u9650!", (String)"MergeStructImportNewPlugin_17", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), orgUnitNum.getNumber());
            return msg;
        }
        return null;
    }

    private String valiationOrgUnitPeriodStatus(String orgUnitNumber, Set<String> periodOpenNumber) {
        if (StringUtils.isNotEmpty((String)orgUnitNumber) && !periodOpenNumber.contains(orgUnitNumber)) {
            return String.format(ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9\u3010%1$s\u3011\u5728\u5f53\u524d\u671f\u95f4\u672a\u5f00\u542f\u3002", (String)"MergeStructImportNewPlugin_15", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), orgUnitNumber);
        }
        return null;
    }

    private String valiationOrgUnitMcStatus(IDNumberTreeNode orgUnitNum, Map<Long, McStatus> mcStatusMap) {
        if (mcStatusMap.get(orgUnitNum.getId()).getFlow().isSubmit()) {
            return String.format(ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9\u3010%1$s\u3011\u5728\u5f53\u524d\u671f\u95f4\u5408\u5e76\u6d41\u7a0b\u5df2\u63d0\u4ea4\u6216\u5df2\u5f52\u6863\u3002", (String)"MergeStructImportNewPlugin_16", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), orgUnitNum.getNumber());
        }
        return null;
    }

    private String validationOrgNode(IDNumberTreeNode orgNode) {
        if (orgNode == IDNumberTreeNode.NotFoundTreeNode) {
            return String.format(ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9\u3010%1$s\u3011\u4e0d\u5b58\u5728\uff01", (String)"MergeStructImportNewPlugin_9", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), orgNode.getNumber());
        }
        return null;
    }

    private DynamicObject buildMegerStructInfo(Map<String, DynamicObject> mergeMethods, String orgUnitNumber, JSONObject json, String mergeMethod, String orgnumber) {
        Date now = new Date();
        Long modifier = UserUtils.getUserId();
        DynamicObject msi = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_mergestructinfo"));
        msi.set("orgnumber", (Object)orgnumber);
        msi.set("orgpnumber", (Object)orgUnitNumber);
        msi.set("ismerge", json.get((Object)"ismerge"));
        if (Objects.nonNull(mergeMethods.get(mergeMethod))) {
            msi.set("mergemethod_id", (Object)mergeMethods.get(mergeMethod).getLong("id"));
        }
        msi.set("userdefined1", json.get((Object)"userdefined1"));
        msi.set("userdefined2", json.get((Object)"userdefined2"));
        msi.set("userdefined3", json.get((Object)"userdefined3"));
        msi.set("modifier", (Object)modifier);
        msi.set("modifytime", (Object)now);
        msi.set("model", (Object)this.model);
        msi.set("scenario", (Object)this.scenario);
        msi.set("year", (Object)this.year);
        msi.set("period", (Object)this.period);
        return msi;
    }

    private BillResult validationData(JSONObject data, InvValidateHelper<JSONObject> validate) {
        BillResult rs = new BillResult();
        rs.setSucess(true);
        rs.setData((Map<String, Object>)data);
        List validateRs = validate.doValidate((Object)data);
        if (!validateRs.isEmpty()) {
            rs.setMessage(String.join((CharSequence)" ", validateRs));
            rs.setSucess(false);
        }
        return rs;
    }

    private InvValidateHelper<JSONObject> jsonObjectValidateHelper() {
        InvMergeStructValidator validator = new InvMergeStructValidator();
        return new InvValidateHelper((InvValidator)validator).add(() -> validator.notNull("ismerge", ResManager.loadKDString((String)"\u662f\u5426\u53c2\u4e0e\u5408\u5e76", (String)"MergeStructImportNewPlugin_1", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]))).add(() -> validator.notNull("orgnumber", ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801", (String)"MergeStructImportNewPlugin_2", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]))).add(() -> validator.notNull("orgpnumber", ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u7f16\u7801", (String)"MergeStructImportNewPlugin_3", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]))).add(() -> validator.notNull("model.shownumber", ResManager.loadKDString((String)"\u4f53\u7cfb", (String)"MergeStructImportNewPlugin_5", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]))).add(() -> validator.notNull("scenario.number", ResManager.loadKDString((String)"\u60c5\u666f", (String)"MergeStructImportNewPlugin_6", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]))).add(() -> validator.notNull("year.number", ResManager.loadKDString((String)"\u8d22\u5e74", (String)"MergeStructImportNewPlugin_7", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]))).add(() -> validator.notNull("period.number", ResManager.loadKDString((String)"\u671f\u95f4", (String)"MergeStructImportNewPlugin_8", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0])));
    }

    private Object getF7Id(JSONObject data, DynamicObject f7Dy, String member, String number) {
        if (data.getJSONObject(member).get((Object)number).equals(f7Dy.getString(number))) {
            return f7Dy.get("id");
        }
        return null;
    }

    public void writeOperationLog(String f7Msg, int total, int success) {
        String opName = ResManager.loadKDString((String)"\u5bfc\u5165", (String)"MergeStructImportPlugin_0", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
        String desc = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u80a1\u6743\u67b6\u6784 \u6210\u529f%1$s \u5931\u8d25%2$s", (String)"MergeStructImportNewPlugin_19", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), success, total - success);
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((String)opName, (String)(f7Msg + desc), this.model == null ? null : (Long)this.model.getPkValue(), (String)"bcm_invrelation_search");
        logService.addLog(logInfo);
    }
}

