/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.spread.LookUpDataArgs;
import kd.fi.bcm.business.invest.sheet.formula.InvestSpreadFormulaHandler;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;
import kd.fi.bcm.formplugin.template.model.ISpreadModelSupplier;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;

public class SheetFormulaViewPlugin
extends AbstractTemplateBasePlugin
implements ISpreadModelSupplier {
    private static final String SPREADKEY = "template_spread";
    private SpreadManager spreadManager;

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.handelTemplate();
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), SPREADKEY);
        invoker.setWorksheetOptions(SpreadProperties.SetWorkSheetOptions.CLIPBOARDOPTIONS.k(), 0);
        Sheet sheet = this.getEffectiveSheet();
        SpreadClientInvoker.invokeLockSheetMethod(this.getClientViewProxy(), SPREADKEY, Collections.singletonList(sheet.getSheetName()));
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getFormCustomParam("orgid") == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"toolbarap"});
        }
        SpreadClientInvoker.invokeHideContextMenuItems(this.getClientViewProxy(), SPREADKEY, MapInitHelper.ofMap((Object)"isHide", (Object)true));
    }

    private void handelTemplate() {
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), SPREADKEY);
        invoker.setBatch(true);
        SpreadManager sm = this.getSpreadModel();
        ArrayList contents = new ArrayList(10);
        sm.getBook().getSheet(0).iteratorCells(cell -> {
            if (cell.hasFormula() && !this.isChanged((Cell)cell)) {
                StringBuilder sb = new StringBuilder();
                sb.append("=").append(InvestSpreadFormulaHandler.getCellFormula((Cell)cell)).append("\n");
                if (cell.hasFormula()) {
                    sb.append("=").append(cell.getFormula()).append("\n");
                }
                sb.append("=").append(cell.getUserObject("fp"));
                sb.append("=").append(cell.getValue()).append("\n");
                if (cell.getUserObject().containsKey((Object)"fs")) {
                    sb.append("=").append(cell.getUserObject("fs")).append("\n");
                }
                contents.add(SpreadEasyInvoker.packedUpdateCellMap(cell.getRow(), cell.getCol(), sb.toString()));
            }
        });
        SpreadClientInvoker.invokeSetSpreadJsonMethod(this.getClientViewProxy(), SPREADKEY, this.getJson());
        SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), SPREADKEY, contents);
        invoker.lockAllToolbarItems(true, SpreadProperties.ToolbarItemNamesEnum.DeleteRowAndCol, SpreadProperties.ToolbarItemNamesEnum.InsertRowAndCol);
        invoker.startToInvoke();
    }

    private String getJson() {
        return (String)this.getView().getFormShowParameter().getCustomParam("json");
    }

    private boolean isChanged(Cell cell) {
        return cell.getUserObject().get((Object)"isChanged") != null;
    }

    @Override
    public void spreadF7Click(int r, int c) {
    }

    @Override
    public void spreadF7LookUpData(LookUpDataArgs args) {
    }

    @Override
    public SpreadManager getSpreadModel() {
        if (this.spreadManager == null) {
            String cacheModel = this.getPageCache().get(this.KEY_SPREAD_MODEL);
            this.spreadManager = cacheModel == null ? JsonSerializerUtil.toSpreadManager((String)((String)this.getView().getFormShowParameter().getCustomParam("sm"))) : JsonSerializerUtil.toSpreadManager((String)cacheModel);
        }
        return this.spreadManager;
    }

    @Override
    public String toSerialSpreadModel(SpreadManager sm) {
        return this.toByteSerialized(sm);
    }

    @Override
    public void cacheSpreadModel(SpreadManager sm) {
        if (sm != null) {
            this.getPageCache().put(this.KEY_SPREAD_MODEL, JsonSerializerUtil.toJson((SpreadManager)sm));
        }
        this.spreadManager = sm;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (evt.getReturnData() != null) {
            this.handleCallBackFormula(evt.getReturnData().toString());
        }
    }

    private void handleCallBackFormula(String returndata) {
        Cell cell = this.getEffectiveSheet().getCell(this.getSelectorStartRow(), this.getSelectorStartCol());
        cell.setFormula(returndata);
        cell.setValue((Object)"");
        HashMap<String, Object> formula = new HashMap<String, Object>(16);
        formula.put(SpreadProperties.SetFormulaMethod.R.k(), cell.getRow());
        formula.put(SpreadProperties.SetFormulaMethod.C.k(), cell.getCol());
        formula.put(SpreadProperties.SetFormulaMethod.F.k(), returndata);
        SpreadClientInvoker.invokeSetFormulaMethod(this.getClientViewProxy(), SPREADKEY, Lists.newArrayList((Object[])new Map[]{formula}));
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), SPREADKEY);
        invoker.setBatch(true);
        invoker.updataValue(cell.getRow(), cell.getCol(), "=" + returndata);
        invoker.setFormula(cell.getRow(), cell.getCol(), "");
        invoker.startToInvoke();
        this.cacheSpreadModel();
    }
}

