/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest.changecase;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.check.CheckUtil;
import kd.fi.bcm.business.dimension.helper.CslSchemeServiceHelper;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.invest.InvCaseHandleRunStatusEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.invest.util.TreeBillPermUtil;
import org.apache.commons.collections4.CollectionUtils;

public class InvCaseDistributePlugin
extends AbstractBaseFormPlugin {
    private static final String BTN_SELECTELEMENT = "selectelement";
    private static final String BTN_DELETEELEMENT = "deleteelement";
    private static final String CTL_TEMCATALOGTREE = "temcatalogtree";
    private static final String CTL_DENTITY = "dentity";
    private static final String CACHE_ROOT = "cache_root";
    private static final String NUMBER = "number";
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance((boolean)true, InvCaseDistributePlugin.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_SELECTELEMENT, BTN_DELETEELEMENT);
        TreeView treeView = (TreeView)this.getControl(CTL_TEMCATALOGTREE);
        treeView.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent event) {
                Object nodeId = event.getNodeId();
                Long nodeIdLongValue = Long.valueOf(nodeId + "");
                if (QueryServiceHelper.exists((String)"bcm_cslscheme", (QFilter[])QFilter.of((String)"id = ? and nodetype = ?", (Object[])new Object[]{nodeIdLongValue, "0"}).toArray())) {
                    InvCaseDistributePlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u9009\u62e9\u7ec4\u7ec7\u89c6\u56fe\u5206\u7c7b\u3002", (String)"InvCaseDistributePlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    InvCaseDistributePlugin.this.getView().setEnable(Boolean.valueOf(false), new String[]{InvCaseDistributePlugin.BTN_SELECTELEMENT, InvCaseDistributePlugin.BTN_DELETEELEMENT});
                } else {
                    InvCaseDistributePlugin.this.getView().setEnable(Boolean.valueOf(true), new String[]{InvCaseDistributePlugin.BTN_SELECTELEMENT, InvCaseDistributePlugin.BTN_DELETEELEMENT});
                }
                InvCaseDistributePlugin.this.refreshEntry();
            }
        });
    }

    private void refreshEntry() {
        TreeView treeView = (TreeView)this.getControl(CTL_TEMCATALOGTREE);
        IDataModel model = this.getModel();
        model.deleteEntryData(CTL_DENTITY);
        List selectedNodeId = treeView.getTreeState().getSelectedNodeId();
        if (CollectionUtils.isEmpty((Collection)selectedNodeId)) {
            return;
        }
        String nodeId = (String)selectedNodeId.get(0);
        List<Long> noPermEntryCase = new TreeBillPermUtil(this.getView()).setModelId(String.valueOf(this.getModelId())).setEntityNameLTree("bcm_templatecatalog").setEntityNameRBill("bcm_invchangecaseentity").noPermEntryIds();
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_invchangecaseentity", (String)"id", (QFilter[])QFilter.of((String)"distributeentry.cslscheme = ?", (Object[])new Object[]{LongUtil.toLong((Object)nodeId)}).and("id", "not in", noPermEntryCase).toArray());
        if (query.isEmpty()) {
            return;
        }
        int si = query.size();
        model.batchCreateNewEntryRow(CTL_DENTITY, query.size());
        for (int i = 0; i < si; ++i) {
            model.setValue(NUMBER, (Object)((DynamicObject)query.get(i)).getLong("id"), i);
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTN_SELECTELEMENT.equals(key)) {
            this.openElimSelectPage();
        } else if (BTN_DELETEELEMENT.equals(key)) {
            this.removeDistributeNode();
            OpNameMultiLangEnumBridge opName = OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.BACKSEND.getMultiLangEnumBridge(), (String)"backSend");
            this.writeOperationLog(opName, ResultStatusEnum.SUCCESS.getName());
        }
    }

    private void removeDistributeNode() {
        DynamicObject[] pageDim;
        IDataModel model = this.getModel();
        DynamicObjectCollection deEntry = model.getDataEntity(true).getDynamicObjectCollection(CTL_DENTITY);
        if (deEntry == null || deEntry.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u79fb\u9664\u7684\u7ec4\u7ec7\u53d8\u52a8\u65b9\u6848\u3002", (String)"InvCaseDistributePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        EntryGrid control = (EntryGrid)this.getControl(CTL_DENTITY);
        int[] selectRows = control.getSelectRows();
        if (selectRows.length < 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u79fb\u9664\u7684\u7ec4\u7ec7\u53d8\u52a8\u65b9\u6848\u3002", (String)"InvCaseDistributePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        HashSet selectElims = Sets.newHashSetWithExpectedSize((int)selectRows.length);
        for (int index : selectRows) {
            selectElims.add(((DynamicObject)deEntry.get(index)).getDynamicObject(NUMBER).getLong("id"));
        }
        QFilter extisFilter = new QFilter("case", "in", (Object)selectElims);
        extisFilter.and("status", "=", (Object)InvCaseHandleRunStatusEnum.SUCCESS.getIndex());
        DynamicObject[] org = BusinessDataServiceHelper.load((String)"bcm_entitymembertree", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()), new QFilter("cslscheme", "=", (Object)this.getTreeNodeSelectedId())});
        if (org != null && org.length > 0) {
            Set orgNumber = Arrays.stream(org).map(o -> o.getString(NUMBER)).collect(Collectors.toSet());
            extisFilter.and("org.number", "in", orgNumber);
        }
        if ((pageDim = BusinessDataServiceHelper.load((String)"bcm_invcasepagedim", (String)"id,case", (QFilter[])extisFilter.toArray())) != null && pageDim.length > 0) {
            Set removeCase = Arrays.stream(pageDim).map(p -> p.getLong("case.id")).collect(Collectors.toSet());
            selectElims.removeAll(removeCase);
        }
        if (selectElims.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u6210\u529f\u6267\u884c\u8bb0\u5f55\uff0c\u65e0\u6cd5\u79fb\u9664\u3002", (String)"InvCaseDistributePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bcm_invchangecaseentity", (String)"id, distributeentry.cslscheme", (QFilter[])new QFilter("id", "in", (Object)selectElims).toArray());
        if (load.length <= 0) {
            return;
        }
        for (DynamicObject l : load) {
            DynamicObjectCollection distributeentry = l.getDynamicObjectCollection("distributeentry");
            List toDelete = distributeentry.stream().filter(p -> p.get("cslscheme") != null && p.getDynamicObject("cslscheme").getLong("id") == this.getTreeNodeSelectedId()).collect(Collectors.toList());
            distributeentry.removeAll(toDelete);
        }
        SaveServiceHelper.save((DynamicObject[])load);
        this.refreshEntry();
        control.clearEntryState();
    }

    private void openElimSelectPage() {
        this.getTreeNodeSelectedId();
        long modelId = this.getModelId();
        long scenarioid = this.getScenarioId();
        ListShowParameter invLimF7Paramter = new ListShowParameter();
        OpenStyle openStyle = invLimF7Paramter.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        openStyle.setInlineStyleCss(css);
        invLimF7Paramter.setShowTitle(false);
        invLimF7Paramter.setMultiSelect(true);
        invLimF7Paramter.setLookUp(true);
        invLimF7Paramter.setFormId("bos_listf7");
        invLimF7Paramter.setBillFormId("bcm_invchangecaseentity");
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("id", "in", (Object)CheckUtil.getApplySceneTmpls((Long)modelId, (Long)scenarioid, (String)"bcm_invchangecaseentity"));
        List<Long> noPermEntryCase = new TreeBillPermUtil(this.getView()).setModelId(String.valueOf(modelId)).setEntityNameLTree("bcm_templatecatalog").setEntityNameRBill("bcm_invchangecaseentity").noPermEntryIds();
        filter.and("id", "not in", noPermEntryCase);
        invLimF7Paramter.getListFilterParameter().setFilter(filter);
        invLimF7Paramter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_SELECTELEMENT));
        invLimF7Paramter.getCustomParams().put("modelId", modelId);
        invLimF7Paramter.setCaption(ResManager.loadKDString((String)"\u7ec4\u7ec7\u53d8\u52a8\u65b9\u6848\u5217\u8868", (String)"InvCaseDistributePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)invLimF7Paramter);
    }

    private long getTreeNodeSelectedId() {
        TreeView treeView = (TreeView)this.getControl(CTL_TEMCATALOGTREE);
        List checkedNodeIds = treeView.getTreeState().getSelectedNodeId();
        if (checkedNodeIds == null || checkedNodeIds.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"InvCaseDistributePlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return Long.parseLong((String)checkedNodeIds.get(0));
    }

    @Override
    public long getModelId() {
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
        if (modelId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"InvCaseDistributePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return modelId;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildLeftTree();
    }

    private void buildLeftTree() {
        TreeView treeView = (TreeView)this.getControl(CTL_TEMCATALOGTREE);
        TreeNode root = CslSchemeServiceHelper.addTreeNode2TreeView((long)this.getModelId(), (boolean)true, (TreeView)treeView);
        this.getPageCache().put(CACHE_ROOT, ObjectSerialUtil.toByteSerialized((Object)root));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (BTN_SELECTELEMENT.equals(closedCallBackEvent.getActionId())) {
            Set<Long> needAddElims = this.getNeedAddElims(closedCallBackEvent);
            int size = needAddElims.size();
            TreeView treeView = (TreeView)this.getControl(CTL_TEMCATALOGTREE);
            List selectedNodeId = treeView.getTreeState().getSelectedNodeId();
            if (CollectionUtils.isEmpty((Collection)selectedNodeId)) {
                return;
            }
            if (size > 0) {
                IDataModel model = this.getModel();
                int entryRowCount = model.getEntryRowCount(CTL_DENTITY);
                model.batchCreateNewEntryRow(CTL_DENTITY, size);
                int index = 0;
                for (Long elimId : needAddElims) {
                    model.setValue(NUMBER, (Object)elimId, entryRowCount + index);
                    ++index;
                }
            }
        }
    }

    private Set<Long> getNeedAddElims(ClosedCallBackEvent closedCallBackEvent) {
        DynamicObject[] load;
        ListSelectedRowCollection selectRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        HashSet result = Sets.newHashSet();
        if (selectRows != null) {
            selectRows.forEach(r -> result.add((Long)r.getPrimaryKeyValue()));
        }
        DynamicObjectCollection dentity = this.getModel().getDataEntity(true).getDynamicObjectCollection(CTL_DENTITY);
        dentity.forEach(r -> {
            DynamicObject elim = r.getDynamicObject(NUMBER);
            if (elim == null) {
                return;
            }
            result.remove(elim.getLong("id"));
        });
        for (DynamicObject l : load = BusinessDataServiceHelper.load((String)"bcm_invchangecaseentity", (String)"id,number,name,distributeentry.cslscheme", (QFilter[])new QFilter("id", "in", (Object)result).toArray())) {
            DynamicObjectCollection distributeentry = l.getDynamicObjectCollection("distributeentry");
            DynamicObject addNew = distributeentry.addNew();
            addNew.set("cslscheme", (Object)this.getTreeNodeSelectedId());
        }
        SaveServiceHelper.save((DynamicObject[])load);
        OpNameMultiLangEnumBridge opName = OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.SEND.getMultiLangEnumBridge(), (String)"send");
        this.writeOperationLog(opName, ResultStatusEnum.SUCCESS.getName());
        return result;
    }
}

