/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest.changecase;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.allinone.model.ExecuteContext;
import kd.fi.bcm.business.check.CheckUtil;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.invest.changecase.InvCasePageDimLoadOrgService;
import kd.fi.bcm.business.invest.changecase.InvCasePageDimRunService;
import kd.fi.bcm.business.invest.changecase.InvChangeHandleServiceHelper;
import kd.fi.bcm.business.invest.helper.InvLockHelper;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.model.UserSelectModel;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.entity.EntityNameRecord;
import kd.fi.bcm.common.enums.PermEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.invest.InvCaseHandleRunStatusEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.invest.util.TreeBillPermUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import org.apache.commons.lang.StringUtils;

public class InvCaseHandleListPlugin
extends AbstractBaseListPlugin
implements TreeNodeClickListener {
    private static final String CTL_TEMCATALOGTREE = "temcatalogtree";
    public static final String LOADORG = "loadorg";
    public static final String BILLLISTAP = "billlistap";
    public static final String TARPERIOD = "period";
    public static final String TARENTITY = "entity";
    private static final List<String> dimKeys = Arrays.asList("scenario", "year", "period");
    private static final List<String> NO_LEAF_KEYS = Lists.newArrayList((Object[])new String[]{"entity"});
    private static final List<String> ALL_KEYS = Arrays.asList("scenario", "year", "period", "entity");
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance((boolean)true, InvCaseHandleListPlugin.class);

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.asMapF7toType(NO_LEAF_KEYS, SingleF7TypeEnum.COMMON, map);
        this.initSingleMemberF7(map);
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.addPackageDataListener(this::packageData);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getControl(CTL_TEMCATALOGTREE);
        treeView.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent event) {
                String nodeId = (String)event.getNodeId();
                if (kd.fi.bcm.fel.common.StringUtils.isNotEmpty((CharSequence)nodeId)) {
                    InvCaseHandleListPlugin.this.getPageCache().put("focusCase", nodeId);
                }
                InvCaseHandleListPlugin.this.refrushBillList();
            }
        });
        BasedataEdit entityEdit = (BasedataEdit)this.getControl(TARENTITY);
        entityEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit cslEdit = (BasedataEdit)this.getControl("cslscheme");
        cslEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private long getTreeNodeSelectedId() {
        TreeView treeView = (TreeView)this.getControl(CTL_TEMCATALOGTREE);
        List checkedNodeIds = treeView.getTreeState().getSelectedNodeId();
        if (checkedNodeIds.isEmpty() || "0".equals(checkedNodeIds.get(0))) {
            return 0L;
        }
        return Long.parseLong((String)checkedNodeIds.get(0));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshBillByUserSelect(dimKeys, false);
        String modelId = String.valueOf(this.getModelId());
        if (!StringUtils.isEmpty((String)modelId)) {
            this.initCslschemeValue(modelId, false);
        }
        this.buildLeftTree();
        this.refrushBillList();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject newValue;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("model".equals(key)) {
            this.propertyChangedModelUse(ALL_KEYS);
            String modelid = this.getPageCache().get("KEY_MODEL_ID");
            this.initCslschemeValue(modelid, false);
        }
        if ((ALL_KEYS.contains(key) || "cslscheme".equals(key)) && (newValue = (DynamicObject)e.getChangeSet()[0].getNewValue()) != null) {
            this.savetUserSelectWhenOtherChange(key, new UserSelectModel());
        }
        this.buildLeftTree();
        this.refrushBillList();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String f7Key = beforeF7SelectEvent.getProperty().getName();
        if (TARENTITY.equals(f7Key)) {
            String modelId = UserSelectUtil.getF7SelectId(this.getView(), "model");
            String cslschemeId = UserSelectUtil.getF7SelectId(this.getView(), "cslscheme");
            QFilter qFilters = new QFilter("model", "=", (Object)Long.valueOf(modelId));
            qFilters.and(new QFilter("cslscheme", "=", (Object)Long.valueOf(cslschemeId)));
            this.permFilter(PermEnum.READWRITE, qFilters, "id", ConvertUtil.convertStrToLong((String)modelId));
            BasedataEdit entityEdit = (BasedataEdit)this.getControl(TARENTITY);
            entityEdit.setQFilter(qFilters);
        }
    }

    @Override
    protected Map<String, Object> getF7CustomData(String f7Key) {
        if (TARENTITY.equals(f7Key)) {
            HashMap<String, Object> customData = new HashMap<String, Object>(16);
            DynamicObject yearDy = this.getCtrl("year");
            String periodId = UserSelectUtil.getF7SelectId(this.getView(), TARPERIOD);
            DynamicObject scenarioDy = this.getCtrl("scenario");
            if (yearDy != null) {
                customData.put("yearNum", yearDy.getString("number"));
                customData.put("yearId", yearDy.getLong("id"));
            }
            if (periodId != null) {
                customData.put("periodId", periodId);
            }
            if (scenarioDy != null) {
                customData.put("scenarioId", scenarioDy.getLong("id"));
            }
            customData.put("isContainShare", true);
            customData.put("disableRateCls", true);
            customData.put("org_fuzzySearch_flag", 1);
            return customData;
        }
        return null;
    }

    private DynamicObject getCtrl(String ctl) {
        return (DynamicObject)this.getModel().getValue(ctl);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (this.getModel().getValue("model") == null || this.getModel().getValue("scenario") == null || this.getModel().getValue("year") == null || this.getModel().getValue("cslscheme") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b8c\u6574\u4f53\u7cfb\u3001\u60c5\u666f\u3001\u8d22\u5e74\u3001\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"InvCaseHandleListPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        super.itemClick(evt);
        switch (key) {
            case "btn_loadorg": {
                this.openLoadOrg();
                this.writeOperationLog(OpItemEnum.LOADORG.getName(), ResultStatusEnum.SUCCESS.getName());
                break;
            }
            case "btn_delete": {
                DynamicObject[] pages;
                BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
                if (billList.getSelectedRows().isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"InvCaseHandleListPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                Object[] ids = billList.getSelectedRows().getPrimaryKeyValues();
                if (ids.length == (pages = BusinessDataServiceHelper.load((String)"bcm_invcasepagedim", (String)"id", (QFilter[])new QFilter("id", "in", (Object)ids).and("status", "=", (Object)InvCaseHandleRunStatusEnum.SUCCESS.getIndex()).toArray())).length) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u529f\u6267\u884c\u8bb0\u5f55\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"InvCaseHandleListPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u8981\u5220\u9664\u7ec4\u7ec7\u53d8\u52a8\u6570\u636e\u5904\u7406\u8bb0\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\u5220\u9664\uff1f", (String)"InvCaseHandleListPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("delete_confirm", (IFormPlugin)this));
                break;
            }
            case "btn_refresh": {
                TreeView treeView = (TreeView)this.getControl(CTL_TEMCATALOGTREE);
                Map focusNode = treeView.getTreeState().getFocusNode();
                if (focusNode != null && focusNode.get("id") != null && !"0".equals(focusNode.get("id"))) {
                    this.getPageCache().put("focusCase", focusNode.get("id").toString());
                }
                this.buildLeftTree();
                this.refrushBillList();
                this.writeOperationLog(OpItemEnum.REFRESH.getName(), ResultStatusEnum.SUCCESS.getName());
                break;
            }
            case "btn_handle": {
                this.execute();
                this.refrushBillList();
                this.writeOperationLog(OpItemEnum.EXCUTE.getName(), ResultStatusEnum.SUCCESS.getName());
                break;
            }
            case "btn_back": {
                this.recall();
                this.refrushBillList();
                this.writeOperationLog(OpItemEnum.CALLBACK.getName(), ResultStatusEnum.SUCCESS.getName());
                break;
            }
            case "btn_log": {
                this.openLogPage();
                this.writeOperationLog(OpItemEnum.OPENLOG.getName(), ResultStatusEnum.SUCCESS.getName());
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("delete_confirm".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            Object[] ids = billList.getSelectedRows().getPrimaryKeyValues();
            String yearId = UserSelectUtil.getF7SelectId(this.getView(), "year");
            Optional rs = InvLockHelper.newAddOrRemoveCasePageDimTryLock((long)LongUtil.toLong((Object)yearId), (long)1L, () -> DeleteServiceHelper.delete((String)"bcm_invcasepagedim", (QFilter[])new QFilter("id", "in", (Object)ids).and("status", "!=", (Object)InvCaseHandleRunStatusEnum.SUCCESS.getIndex()).toArray()));
            rs.ifPresent(msg -> this.getView().showTipNotification(msg));
            this.refrushBillList();
            String result = rs.isPresent() ? ResultStatusEnum.FAIL.getName() : ResultStatusEnum.SUCCESS.getName();
            this.writeOperationLog(OpItemEnum.DELETE.getName(), result);
        }
    }

    private void openLogPage() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_invcasehandleloglist");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String modelId = UserSelectUtil.getF7SelectId(this.getView(), "model");
        String scenarioId = UserSelectUtil.getF7SelectId(this.getView(), "scenario");
        String yearId = UserSelectUtil.getF7SelectId(this.getView(), "year");
        Long cslSchemeId = Long.valueOf(UserSelectUtil.getF7SelectId(this.getView(), "cslscheme"));
        formShowParameter.setCustomParam("modelId", (Object)modelId);
        formShowParameter.setCustomParam("scenarioId", (Object)scenarioId);
        formShowParameter.setCustomParam("yearId", (Object)yearId);
        formShowParameter.setCustomParam("cslSchemeId", (Object)cslSchemeId);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6267\u884c\u65e5\u5fd7\u5217\u8868", (String)"InvCaseHandleLogListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.getView().showForm(formShowParameter);
    }

    private void execute() {
        String operationName = ResManager.loadKDString((String)"\u6267\u884c", (String)"InvCaseHandleListPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        ExecuteContext context = this.getCovertContext();
        this.viewAction(context, operationName, (dimAndCase, dealInfo) -> {
            InvCasePageDimRunService invCasePageDimRunService = new InvCasePageDimRunService(context);
            List logList = invCasePageDimRunService.verifyChangeCase(dimAndCase, dealInfo, (dimPageObject, caseObject) -> invCasePageDimRunService.executeCheck(dealInfo, dimPageObject, caseObject));
            if (((Map)dimAndCase.p1).isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])logList.toArray(new DynamicObject[0]));
                return dealInfo.size();
            }
            List allPageDimRun = invCasePageDimRunService.getPageDimRunLogDys(dimAndCase, logList);
            invCasePageDimRunService.doExecute(dimAndCase, logList, allPageDimRun);
            logList.stream().filter(dy -> InvCaseHandleRunStatusEnum.FAIL.getIndex().equals(dy.getString("status"))).forEach(dy -> dealInfo.add(dy.getString("reason")));
            return dealInfo.size();
        });
    }

    private void recall() {
        String operationName = ResManager.loadKDString((String)"\u64a4\u56de", (String)"InvCaseHandleListPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        ExecuteContext context = this.getCovertContext();
        this.viewAction(context, operationName, (dimAndCase, dealInfo) -> {
            InvCasePageDimRunService invCasePageDimRunService = new InvCasePageDimRunService(context);
            List logList = invCasePageDimRunService.verifyChangeCase(dimAndCase, dealInfo, (dimPageObject, caseObject) -> invCasePageDimRunService.recallCheck(dealInfo, dimPageObject, caseObject));
            if (((Map)dimAndCase.p1).isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])logList.toArray(new DynamicObject[0]));
                return dealInfo.size();
            }
            List pageIds = invCasePageDimRunService.getRecallPageDimIds(dimAndCase, logList);
            if (!pageIds.isEmpty()) {
                invCasePageDimRunService.doRecall(dimAndCase, logList, pageIds);
            }
            logList.stream().filter(dy -> InvCaseHandleRunStatusEnum.FAIL.getIndex().equals(dy.getString("status"))).forEach(dy -> dealInfo.add(dy.getString("reason")));
            return dealInfo.size();
        });
    }

    private ExecuteContext getCovertContext() {
        DynamicObject modelDo = (DynamicObject)this.getModel().getValue("model");
        DynamicObject scenarioDo = (DynamicObject)this.getModel().getValue("scenario");
        DynamicObject yearDo = (DynamicObject)this.getModel().getValue("year");
        return new ExecuteContext(SimpleItem.newOne((Object)modelDo.get("id"), (String)modelDo.getString("shownumber")), null, SimpleItem.newOne((Object)yearDo.get("id"), (String)yearDo.getString("number")), null, SimpleItem.newOne((Object)scenarioDo.get("id"), (String)scenarioDo.getString("number")), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void viewAction(ExecuteContext context, String operationName, BiFunction<Pair<Map<Long, DynamicObject>, Map<Long, DynamicObject>>, Set<String>, Integer> action) {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        int selectedRowsNum = selectedRows.size();
        if (selectedRowsNum == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"InvCaseHandleListPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet dealInfo = new HashSet(16);
        Object[] selectedKey = selectedRows.getPrimaryKeyValues();
        try (DLock lock = DLock.create((String)InvChangeHandleServiceHelper.getLockKey((ExecuteContext)context));){
            try {
                lock.lock();
                Pair dimAndCase = InvChangeHandleServiceHelper.getDim2CaseMap((Object[])selectedKey);
                int fail = action.apply((Pair<Map<Long, DynamicObject>, Map<Long, DynamicObject>>)dimAndCase, dealInfo);
                int success = selectedRowsNum - fail;
                if (!dealInfo.isEmpty()) {
                    StringBuilder message = new StringBuilder();
                    dealInfo.forEach(s -> message.append((String)s).append("\r\n"));
                    this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6210\u529f%1$s %2$s \u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"InvCaseHandleListPlugin_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]), operationName, success, fail), message.toString(), MessageTypes.Default);
                } else {
                    this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6210\u529f%1$s %2$s \u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"InvCaseHandleListPlugin_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]), operationName, success, fail));
                }
                lock.unlock();
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void openLoadOrg() {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_invcaseloadorg");
        param.getOpenStyle().setShowType(ShowType.Modal);
        String modelId = UserSelectUtil.getF7SelectId(this.getView(), "model");
        String scenarioId = UserSelectUtil.getF7SelectId(this.getView(), "scenario");
        String yearId = UserSelectUtil.getF7SelectId(this.getView(), "year");
        String cslschemeId = UserSelectUtil.getF7SelectId(this.getView(), "cslscheme");
        param.setCustomParam("modelId", (Object)modelId);
        param.setCustomParam("scenarioId", (Object)scenarioId);
        param.setCustomParam("yearId", (Object)yearId);
        param.setCustomParam("cslschemeId", (Object)cslschemeId);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, LOADORG));
        this.getView().showForm(param);
    }

    private void buildLeftTree() {
        TreeView treeView = (TreeView)this.getControl(CTL_TEMCATALOGTREE);
        treeView.deleteAllNodes();
        TreeNode focusNode = null;
        String focusCase = this.getPageCache().get("focusCase");
        Long modelId = LongUtil.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"));
        if (StringUtils.isEmpty((String)UserSelectUtil.getF7SelectId(this.getView(), "cslscheme")) || StringUtils.isEmpty((String)UserSelectUtil.getF7SelectId(this.getView(), "scenario"))) {
            return;
        }
        Long cslSchemeId = Long.valueOf(UserSelectUtil.getF7SelectId(this.getView(), "cslscheme"));
        Long scenarioId = Long.valueOf(UserSelectUtil.getF7SelectId(this.getView(), "scenario"));
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("id", "in", (Object)CheckUtil.getApplySceneTmpls((Long)modelId, (Long)scenarioId, (String)"bcm_invchangecaseentity"));
        filter.and("distributeentry.cslscheme", "=", (Object)cslSchemeId);
        List<Long> noPermCase = this.getNoPermCase(modelId);
        if (!noPermCase.isEmpty()) {
            filter.and("id", "not in", noPermCase);
        }
        DynamicObjectCollection cases = QueryServiceHelper.query((String)"bcm_invchangecaseentity", (String)"id,number,name", (QFilter[])filter.toArray(), (String)"number");
        TreeNode tempNode = new TreeNode();
        tempNode.setId("0");
        tempNode.setParentid("");
        tempNode.setText(ResManager.loadKDString((String)"\u65b9\u6848\u5206\u7c7b", (String)"InvCaseHandleListPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        tempNode.setExpend(true);
        tempNode.setIsOpened(true);
        for (DynamicObject aCase : cases) {
            TreeNode childNode = new TreeNode();
            childNode.setId(aCase.getString("id"));
            childNode.setParentid(tempNode.getId());
            childNode.setText(this.buildShowName(aCase));
            tempNode.addChild(childNode);
            if (!StringUtils.isNotEmpty((String)focusCase) || !aCase.getString("id").equals(focusCase)) continue;
            focusNode = childNode;
        }
        treeView.addNode(tempNode);
        if (focusNode != null) {
            treeView.focusNode(focusNode);
        }
    }

    private String buildShowName(DynamicObject aCase) {
        String showType = (String)this.getModel().getValue("showorgtype");
        String showName = "1".equals(showType) ? aCase.getString("number") : ("2".equals(showType) ? aCase.getString("name") : aCase.getString("number") + "    " + aCase.getString("name"));
        return showName;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (LOADORG.equals(closedCallBackEvent.getActionId())) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            try {
                this.handleLoadOrg(returnData);
            }
            catch (KDBizException ex) {
                this.getView().showConfirm(ex.getMessage(), MessageBoxOptions.OK);
            }
        }
        this.refrushBillList();
    }

    private void handleLoadOrg(Map<?, ?> returnData) {
        Long modelId = Optional.ofNullable(UserSelectUtil.getF7SelectId(this.getView(), "model")).map(LongUtil::toLong).orElseGet(() -> 0L);
        Long cslSchemeId = Optional.ofNullable(UserSelectUtil.getF7SelectId(this.getView(), "cslscheme")).map(LongUtil::toLong).orElseGet(() -> 0L);
        Long scenarioId = Optional.ofNullable(UserSelectUtil.getF7SelectId(this.getView(), "scenario")).map(LongUtil::toLong).orElseGet(() -> 0L);
        Long yearId = Optional.ofNullable(UserSelectUtil.getF7SelectId(this.getView(), "year")).map(LongUtil::toLong).orElseGet(() -> 0L);
        long selectedId = this.getTreeNodeSelectedId();
        String isAllCase = (String)returnData.get("isAllCase");
        String entityNumber = (String)returnData.get("entityNumber");
        String periodStr = (String)returnData.get(TARPERIOD);
        InvCasePageDimLoadOrgService loadOrgService = new InvCasePageDimLoadOrgService(modelId.longValue(), cslSchemeId.longValue(), scenarioId.longValue(), yearId.longValue());
        ResultBox resultBox = loadOrgService.doHandleLoadOrg(periodStr, entityNumber, selectedId, isAllCase, this.getNoPermCase(modelId));
        String messageText = resultBox.getMessageText();
        if (StringUtils.isBlank((String)messageText)) {
            messageText = ResManager.loadKDString((String)"\u65e0\u53d8\u52a8\u8bb0\u5f55", (String)"InvCaseHandleListPlugin_43", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        this.getView().showConfirm(messageText, MessageBoxOptions.OK);
    }

    protected void refrushBillList() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        String modelId = UserSelectUtil.getF7SelectId(this.getView(), "model");
        String scenarioId = UserSelectUtil.getF7SelectId(this.getView(), "scenario");
        String yearId = UserSelectUtil.getF7SelectId(this.getView(), "year");
        String cslschemeId = UserSelectUtil.getF7SelectId(this.getView(), "cslscheme");
        String tarperiodId = UserSelectUtil.getF7SelectId(this.getView(), TARPERIOD);
        String tarentityId = UserSelectUtil.getF7SelectId(this.getView(), TARENTITY);
        if (StringUtils.isEmpty((String)modelId) || StringUtils.isEmpty((String)scenarioId) || StringUtils.isEmpty((String)yearId) || StringUtils.isEmpty((String)cslschemeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b8c\u6574\u4f53\u7cfb\u3001\u60c5\u666f\u3001\u8d22\u5e74\u3001\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"InvCaseHandleListPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] org = BusinessDataServiceHelper.load((String)"bcm_entitymembertree", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)Long.valueOf(modelId)), new QFilter("cslscheme", "=", (Object)Long.valueOf(cslschemeId))});
        if (org == null || org.length == 0) {
            return;
        }
        Set orgIds = Arrays.stream(org).map(o -> o.getLong("id")).collect(Collectors.toSet());
        TreeView treeView = (TreeView)this.getControl(CTL_TEMCATALOGTREE);
        Map focusNode = treeView.getTreeState().getFocusNode();
        QFilter filter = new QFilter("model", "=", (Object)Long.valueOf(modelId));
        if (StringUtils.isNotEmpty((String)scenarioId)) {
            filter.and("scenario", "=", (Object)Long.valueOf(scenarioId));
        }
        if (StringUtils.isNotEmpty((String)yearId)) {
            filter.and("year", "=", (Object)Long.valueOf(yearId));
        }
        if (StringUtils.isNotEmpty((String)cslschemeId)) {
            filter.and("org", "in", orgIds);
        }
        if (StringUtils.isNotEmpty((String)tarentityId)) {
            filter.and("tarparentorg", "=", (Object)Long.valueOf(tarentityId));
        }
        if (StringUtils.isNotEmpty((String)tarperiodId)) {
            filter.and("tarperiod", "=", (Object)Long.valueOf(tarperiodId));
        }
        if (focusNode != null && focusNode.get("id") != null && !"0".equals(focusNode.get("id"))) {
            filter.and("case", "=", (Object)Long.valueOf(focusNode.get("id").toString()));
        } else {
            Long cslSchemeId = Long.valueOf(cslschemeId);
            QFilter caseFilter = new QFilter("model", "=", (Object)Long.valueOf(modelId));
            caseFilter.and("id", "in", (Object)CheckUtil.getApplySceneTmpls((Long)Long.valueOf(modelId), (Long)Long.valueOf(scenarioId), (String)"bcm_invchangecaseentity"));
            caseFilter.and("distributeentry.cslscheme", "=", (Object)cslSchemeId);
            DynamicObjectCollection cases = QueryServiceHelper.query((String)"bcm_invchangecaseentity", (String)"id,number,name", (QFilter[])caseFilter.toArray(), (String)"number");
            Set casesIds = cases.stream().map(c -> c.getLong("id")).collect(Collectors.toSet());
            filter.and("case", "in", casesIds);
        }
        List<Long> noPermCase = this.getNoPermCase(Long.valueOf(modelId));
        if (!noPermCase.isEmpty()) {
            filter.and("case", "not in", noPermCase);
        }
        this.permFilter(PermEnum.READWRITE, filter, "tarparentorg", ConvertUtil.convertStrToLong((String)modelId));
        billList.setFilterParameter(new FilterParameter(filter, "case.number,org.number,tarorgnumber,tarperiod.number"));
        billList.refresh();
    }

    private void permFilter(PermEnum permenum, QFilter filter, String filterKey, Long modelId) {
        Long dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)SysDimensionEnum.Entity.getNumber());
        QFilter permFilter = PermissionServiceImpl.getInstance((Long)modelId).getWritePermFilter(dimId, "bcm_entitymembertree", filterKey);
        filter.and(permFilter);
    }

    private List<Long> getNoPermCase(Long modelId) {
        return new TreeBillPermUtil(this.getView()).setModelId(String.valueOf(modelId)).setEntityNameLTree("bcm_templatecatalog").setEntityNameRBill("bcm_invchangecaseentity").noPermEntryIds();
    }

    public void packageData(PackageDataEvent e) {
        if (ColumnDesc.class.isAssignableFrom(e.getSource().getClass())) {
            String key;
            switch (key = ((ColumnDesc)e.getSource()).getKey()) {
                case "org.number": 
                case "tarorgnumber": {
                    this.addEntityName(e, key);
                }
            }
        }
    }

    private void addEntityName(PackageDataEvent e, String key) {
        String periodNum = key.equals("org.number") ? e.getRowData().getString("period.number") : e.getRowData().getString("tarperiod.number");
        if (this.getModel().getValue("year") != null && e.getFormatValue() != null) {
            EntityNameRecord entNameRecs;
            DynamicObject yearDy = this.getCtrl("year");
            String entityNum = e.getFormatValue().toString();
            String modelNum = this.getCurModelNumber();
            IDNumberTreeNode entityTreeNode = MemberReader.findEntityMemberByNum((String)modelNum, (String)entityNum);
            IDNumberTreeNode periodTreeNode = MemberReader.findPeriodMemberByNum((String)modelNum, (String)periodNum);
            if (IDNumberTreeNode.NotFoundTreeNode != entityTreeNode && IDNumberTreeNode.NotFoundTreeNode != periodTreeNode && (entNameRecs = MemberReader.getEntNameRecs((String)modelNum, (Long)entityTreeNode.getId(), (Long)yearDy.getLong("id"), (Long)periodTreeNode.getId())) != null) {
                e.setFormatValue((Object)(entityNum + " " + entNameRecs.getName()));
            }
        }
    }
}

