/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest.changecase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.util.UserSelectUtil;

public class InvCaseHandleLogListPlugin
extends AbstractBaseListPlugin
implements TreeNodeClickListener {
    private static final List<String> dimKeys = Arrays.asList("scenario", "year");
    public static final String BILLLISTAP = "billlistap";
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance((boolean)true, InvCaseHandleLogListPlugin.class);
    private static final List<String> ALL_KEYS = Arrays.asList("scenario", "year", "cslscheme");

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        QFilter superid = new QFilter("id", "in", (Object)MemberPermHelper.getLimitedModelListByUser());
        QFilter haspermid = new QFilter("id", "in", (Object)BcmFunPermissionHelper.getEffectiveByPermModel((String)"bcm_invchangehandle", (ApplicationTypeEnum)ApplicationTypeEnum.CM));
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(2);
        qFilterList.add(superid.or(haspermid));
        showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long cslSchemeId = (Long)this.getView().getFormShowParameter().getCustomParam("cslSchemeId");
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("modelId");
        String scenarioId = (String)this.getView().getFormShowParameter().getCustomParam("scenarioId");
        String yearId = (String)this.getView().getFormShowParameter().getCustomParam("yearId");
        this.getModel().setValue("model", (Object)modelId);
        this.getModel().setValue("scenario", (Object)scenarioId);
        this.getModel().setValue("year", (Object)yearId);
        this.getModel().setValue("cslscheme", (Object)cslSchemeId);
        this.refrushBillList();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (e.getChangeSet()[0].getNewValue() == null || e.getChangeSet()[0].getNewValue() instanceof DynamicObject) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if ("model".equals(propName)) {
                if (this.getPageCache().get("chooseBackModel") != null) {
                    return;
                }
                if (newValue == null) {
                    this.getModel().setValue("model", ((DynamicObject)e.getChangeSet()[0].getOldValue()).get("id"));
                    return;
                }
                this.propertyChangedModelUse(ALL_KEYS);
                String modelId = this.getPageCache().get("KEY_MODEL_ID");
                this.initCslschemeValue(modelId, false);
            }
        }
        this.refrushBillList();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_delete": {
                BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
                if (billList.getSelectedRows() == null || billList.getSelectedRows().isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"InvCaseHandleLogListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                Object[] ids = billList.getSelectedRows().getPrimaryKeyValues();
                DeleteServiceHelper.delete((String)"bcm_invchangehandlelog", (QFilter[])new QFilter("id", "in", (Object)ids).toArray());
                this.writeOperationLog(OpItemEnum.DELETE.getName(), ResultStatusEnum.SUCCESS.getName());
                break;
            }
            case "btn_clear": {
                if (StringUtils.isEmpty((CharSequence)UserSelectUtil.getF7SelectId(this.getView(), "model")) || StringUtils.isEmpty((CharSequence)UserSelectUtil.getF7SelectId(this.getView(), "scenario")) || StringUtils.isEmpty((CharSequence)UserSelectUtil.getF7SelectId(this.getView(), "year")) || StringUtils.isEmpty((CharSequence)UserSelectUtil.getF7SelectId(this.getView(), "cslscheme"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b8c\u6574\u4f53\u7cfb\u3001\u60c5\u666f\u3001\u8d22\u5e74\u3001\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"InvCaseHandleLogListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                Long modelId = Long.valueOf(UserSelectUtil.getF7SelectId(this.getView(), "model"));
                Long scenarioId = Long.valueOf(UserSelectUtil.getF7SelectId(this.getView(), "scenario"));
                Long yearId = ((DynamicObject)this.getModel().getValue("year")).getLong("id");
                QFilter filter = new QFilter("casepagedim.model", "=", (Object)modelId);
                filter.and("casepagedim.scenario", "=", (Object)scenarioId);
                filter.and("casepagedim.year", "=", (Object)yearId);
                DeleteServiceHelper.delete((String)"bcm_invchangehandlelog", (QFilter[])filter.toArray());
                this.writeOperationLog(OpItemEnum.DELETEALL.getName(), ResultStatusEnum.SUCCESS.getName());
                break;
            }
            case "btn_refresh": {
                this.writeOperationLog(OpItemEnum.REFRESH.getName(), ResultStatusEnum.SUCCESS.getName());
                break;
            }
        }
        if (!"btn_refresh".equals(key)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"InvCaseHandleLogListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.refrushBillList();
    }

    protected void refrushBillList() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        String modelIdString = UserSelectUtil.getF7SelectId(this.getView(), "model");
        String scenarioIdString = UserSelectUtil.getF7SelectId(this.getView(), "scenario");
        String yearIdString = UserSelectUtil.getF7SelectId(this.getView(), "year");
        String cslschemeId = UserSelectUtil.getF7SelectId(this.getView(), "cslscheme");
        if (StringUtils.isEmpty((CharSequence)modelIdString) || StringUtils.isEmpty((CharSequence)scenarioIdString) || StringUtils.isEmpty((CharSequence)yearIdString) || StringUtils.isEmpty((CharSequence)cslschemeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b8c\u6574\u4f53\u7cfb\u3001\u60c5\u666f\u3001\u8d22\u5e74\u3001\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"InvCaseHandleLogListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            billList.clearData();
            return;
        }
        Long modelId = Long.valueOf(UserSelectUtil.getF7SelectId(this.getView(), "model"));
        Long scenarioId = Long.valueOf(UserSelectUtil.getF7SelectId(this.getView(), "scenario"));
        Long yearId = ((DynamicObject)this.getModel().getValue("year")).getLong("id");
        QFilter filter = new QFilter("casepagedim.model", "=", (Object)modelId);
        filter.and("casepagedim.scenario", "=", (Object)scenarioId);
        filter.and("casepagedim.year", "=", (Object)yearId);
        billList.clearSelection();
        billList.setFilterParameter(new FilterParameter(filter, null));
        billList.refresh();
    }
}

