/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest.changecase;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.business.permission.perm.PermPackageList;
import kd.fi.bcm.business.scheme.DimensionScope;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.MenuShowTypeEnum;
import kd.fi.bcm.common.enums.PermEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MulTiF7FilterTempleUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import org.apache.commons.lang.StringUtils;

public class InvChangeCaseLoadOrgFormPlugin
extends AbstractBaseFormPlugin {
    private static final List<String> dimKeys = Arrays.asList("scenario", "year", "period");
    private static final List<String> NO_LEAF_KEYS = Lists.newArrayList((Object[])new String[]{"entity"});
    public static final String PERIOD = "period1";
    public static final String BTN_OK = "btn_ok";

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.asMapF7toType(NO_LEAF_KEYS, SingleF7TypeEnum.COMMON, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_OK, PERIOD);
        BasedataEdit entityEdit = (BasedataEdit)this.getControl("entity");
        entityEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("modelId");
        String scenarioId = (String)this.getView().getFormShowParameter().getCustomParam("scenarioId");
        String yearId = (String)this.getView().getFormShowParameter().getCustomParam("yearId");
        this.getModel().setValue("model", (Object)modelId);
        this.getModel().setValue("scenario", (Object)scenarioId);
        this.getModel().setValue("year", (Object)yearId);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String f7Key = beforeF7SelectEvent.getProperty().getName();
        if ("entity".equals(f7Key)) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            String modelId = (String)this.getView().getFormShowParameter().getCustomParam("modelId");
            String cslschemeId = (String)this.getView().getFormShowParameter().getCustomParam("cslschemeId");
            qFilters.add(new QFilter("model", "=", (Object)Long.valueOf(modelId)));
            qFilters.add(new QFilter("cslscheme", "=", (Object)Long.valueOf(cslschemeId)));
            this.permFilter(LongUtil.toLong((Object)modelId), PermEnum.READWRITE, permOrgIds -> qFilters.add(new QFilter("id", "in", permOrgIds)));
            BasedataEdit entityEdit = (BasedataEdit)this.getControl("entity");
            entityEdit.setQFilters(qFilters);
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_OK.equals(key)) {
            HashMap<String, String> resultMap = new HashMap<String, String>(10);
            DynamicObject entityDy = (DynamicObject)this.getModel().getValue("entity");
            String entityNumber = entityDy != null ? entityDy.getString("number") : null;
            String isAllCase = (String)this.getModel().getValue("isallcase");
            resultMap.put("period", this.getPageCache().get(PERIOD));
            resultMap.put("entityNumber", entityNumber);
            resultMap.put("isAllCase", isAllCase);
            this.getView().returnDataToParent(resultMap);
            this.getView().close();
        } else if (PERIOD.equals(key)) {
            String number = DimTypesEnum.PERIOD.getNumber();
            Long modelId = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
            FormShowParameter para = MulTiF7FilterTempleUtils.createMulTiF7ShowParameter((IPageCache)this.getPageCache(), (long)modelId, (String)number, null);
            DimensionScope dimensionScope = this.getPeriodDimensionScope();
            if (para != null) {
                para.setCustomParam("sign", (Object)number);
                para.setCustomParam("showScopes", (Object)ObjectSerialUtil.toByteSerialized((Object)new int[]{10, 90}));
                para.setCustomParam(number, (Object)(dimensionScope != null ? SerializationUtils.toJsonString((Object)dimensionScope.getdimMembers()) : "[]"));
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, PERIOD);
                para.setCloseCallBack(closeCallBack);
                this.getView().showForm(para);
            }
        }
    }

    private DimensionScope getPeriodDimensionScope() {
        String accountScopeCache = this.getPageCache().get(PERIOD);
        if (StringUtils.isEmpty((String)accountScopeCache)) {
            return null;
        }
        return (DimensionScope)SerializationUtils.deSerializeFromBase64((String)accountScopeCache);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if (PERIOD.equals(key) && closedCallBackEvent.getReturnData() != null) {
            DynamicObjectCollection selectOrg = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
            if (selectOrg.isEmpty()) {
                this.getModel().setValue(PERIOD, null);
                this.getPageCache().remove(PERIOD);
            } else {
                SchemeContext schemeContext = new SchemeContext(this.getModelId());
                DimensionScope ds = new DimensionScope(Long.toString(this.getModelId()), schemeContext.getDimensionByNumber(DimTypesEnum.PERIOD.getNumber()), selectOrg);
                this.getModel().setValue(PERIOD, (Object)ds.toMultiPersonalString(MenuShowTypeEnum.NUMBERNDNAME));
                this.getPageCache().put(PERIOD, SerializationUtils.serializeToBase64((Object)ds));
            }
        }
    }

    private void permFilter(long modelId, PermEnum permenum, Consumer<Set<Long>> addFilter) {
        if (!Boolean.parseBoolean(this.getPlugin().getPageCache().get("isroot"))) {
            Collection orgNodes = MemberReader.getAllNodeByDimNum((String)DimTypesEnum.ENTITY.getNumber(), (String)MemberReader.findModelNumberById((Object)modelId));
            PermPackageList permMapFromCache = this.getPermMapFromCache();
            Set permOrgIds = orgNodes.stream().map(IDNumberTreeNode::getId).filter(id -> permMapFromCache.getPermEnum(id.longValue()) == permenum).collect(Collectors.toSet());
            addFilter.accept(permOrgIds);
        }
    }
}

