/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest.changecase;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.check.CheckUtil;
import kd.fi.bcm.business.invest.changecase.InvChangeCaseService;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;
import kd.fi.bcm.common.enums.chkcheck.CHKFormulaStatusEnum;
import kd.fi.bcm.common.enums.invest.InvCaseHandleRunStatusEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.BcmBasePluginUtil;
import kd.fi.bcm.formplugin.invest.InvLimListPlugin;
import kd.fi.bcm.formplugin.invest.util.TreeBillPermUtil;
import kd.fi.bcm.formplugin.template.AbstractTemplateListPlugin;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;

public class InvChangeDataCaseSettingListPlugin
extends AbstractTemplateListPlugin
implements TreeNodeClickListener {
    private static final String MODEL = "model";
    private static final String BILL_LIST = "billlistap";
    private static final String BTN_DELETE_CASE = "btn_deletecase";
    private static final String BTN_ENABLE = "btn_enable";
    private static final String BTN_DISABLE = "btn_disable";
    private static final String BTN_MOVE_TEMPLATE = "btn_movetemplate";
    private static Set<String> dimKeys = Sets.newHashSet((Object[])new String[]{"scenario"});
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance((boolean)true, InvLimListPlugin.class);

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap(10);
        this.asMapF7toType(new ArrayList<String>(dimKeys), SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
        BillList billList = (BillList)this.getView().getControl(BILL_LIST);
        billList.setBillFormId("bcm_invchangecaseentry");
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getView().getControl(BILL_LIST);
        billList.addHyperClickListener(hyperClickEvent -> {
            Long rowPK = (Long)((BillListHyperLinkClickEvent)hyperClickEvent).getCurrentRow().getPrimaryKeyValue();
            OperationStatus status = OperationStatus.ADDNEW;
            if (TreeBillPermUtil.isReadOnlyEntry(this.getView(), rowPK, String.valueOf(this.getModelId()))) {
                status = OperationStatus.EDIT;
            }
            this.openEditCasePage(rowPK, status);
        });
        billList.addListRowClickListener((ListRowClickListener)this);
        TreeView tree = (TreeView)this.getControl("templatecatalog");
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        String nodeId = this.getPageCache().get("focusnodeid");
        if (StringUtils.isEmpty((CharSequence)nodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u65b9\u6848\u5206\u7c7b\u6811\u8282\u70b9\u540e\u518d\u64cd\u4f5c\u3002", (String)"InvChangeDataCaseSettingListPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject catalog = QueryServiceHelper.queryOne((String)"bcm_templatecatalog", (String)"number", (QFilter[])new QFBuilder("id", "=", (Object)LongUtil.toLong((Object)nodeId)).toArray());
        switch (key) {
            case "btn_delete": {
                if (!Objects.equals("root", catalog.getString("number"))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u56fa\u5b9a\u5206\u7c7b\u4e0d\u53ef\u5220\u9664\u3002", (String)"InvChangeDataCaseSettingListPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            case "btn_modify": {
                if (!Objects.equals("root", catalog.getString("number"))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u56fa\u5b9a\u5206\u7c7b\u4e0d\u53ef\u4fee\u6539\u3002", (String)"InvChangeDataCaseSettingListPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        super.click(evt);
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        BillList billList = (BillList)this.getView().getControl(BILL_LIST);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        boolean isEnable = true;
        for (ListSelectedRow selectedRow : selectedRows) {
            if (!TreeBillPermUtil.isReadOnlyEntry(this.getView(), (Long)selectedRow.getPrimaryKeyValue(), String.valueOf(this.getModelId()))) continue;
            isEnable = false;
            break;
        }
        this.setOnlyReadButton(isEnable);
    }

    private void setOnlyReadButton(boolean isEnable) {
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{BTN_DELETE_CASE, BTN_ENABLE, BTN_DISABLE, BTN_MOVE_TEMPLATE});
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        Long nodeId = Long.parseLong((String)evt.getNodeId());
        this.getView().setEnable(Boolean.valueOf(!TreeBillPermUtil.isReadOnlyCatalog(this.getView(), nodeId, String.valueOf(this.getModelId()))), new String[]{"btn_add"});
    }

    @Override
    public void checkPerm(String opKey) {
        String nodeId = this.getPageCache().get(FOCUS_NODE_ID);
        ArrayList writePermButton = Lists.newArrayList((Object[])new String[]{"btn_addnew", "btn_delete"});
        if (writePermButton.contains(opKey) && TreeBillPermUtil.isReadOnlyCatalog(this.getView(), LongUtil.toLong((Object)nodeId), String.valueOf(this.getModelId()))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u5206\u7c7b\u60a8\u4ec5\u6709\u201c\u53ea\u8bfb\u201d\u6743\u9650\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"InvChangeDataCaseSettingListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        super.checkPerm(opKey);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshBillByUserSelect(new ArrayList<String>(dimKeys), true);
        this.refresh();
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        long modelId = this.getModelId();
        e.getQFilters().add(new QFilter(MODEL, "=", (Object)modelId));
    }

    private void refresh() {
        this.refrushTree();
        this.cacheReadOnlyTreeAndCases();
        this.refreshList();
    }

    @Override
    protected QFilter getCatalogtypeQFilter() {
        return new QFilter("catalogtype", "=", (Object)Character.valueOf(TemplateCatalogTypeEnum.CHANGECASELOG.getType())).or("parent.id", "=", (Object)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (e.getChangeSet()[0].getNewValue() == null || e.getChangeSet()[0].getNewValue() instanceof DynamicObject) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (MODEL.equals(propName)) {
                if (this.getPageCache().get("chooseBackModel") != null) {
                    return;
                }
                if (newValue == null) {
                    this.getModel().setValue(MODEL, ((DynamicObject)e.getChangeSet()[0].getOldValue()).get("id"));
                }
                try {
                    this.propertyChangedModelUse(new ArrayList<String>(dimKeys));
                }
                finally {
                    this.getPageCache().remove("chooseBackModel");
                }
                this.refresh();
            } else if (dimKeys.contains(propName)) {
                Boolean isSureReturn = this.propertyChangedDimUse(propName, newValue, false, false);
                if (Boolean.FALSE.equals(isSureReturn)) {
                    return;
                }
                this.refresh();
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (this.getModel().getValue(MODEL) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"InvChangeDataCaseSettingListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        BillList billList = (BillList)this.getView().getControl(BILL_LIST);
        if ((BTN_DELETE_CASE.equals(key) || BTN_ENABLE.equals(key) || BTN_DISABLE.equals(key)) && billList.getSelectedRows().isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"InvChangeDataCaseSettingListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (key) {
            case "btn_add": {
                this.openEditCasePage(null, OperationStatus.ADDNEW);
                break;
            }
            case "btn_distribute": {
                this.openInvDistributePage();
                break;
            }
            case "btn_refresh": {
                this.writeOperationLog(OpItemEnum.REFRESH.getName(), ResultStatusEnum.SUCCESS.getName());
                this.cacheReadOnlyTreeAndCases();
                this.refrushBillList();
                break;
            }
            case "btn_deletecase": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u8981\u5220\u9664\u7ec4\u7ec7\u53d8\u52a8\u6570\u636e\u5904\u7406\u8bbe\u7f6e\u8bb0\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\u5220\u9664\uff1f", (String)"InvChangeDataCaseSettingListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("delete_confirm", (IFormPlugin)this));
                break;
            }
            case "btn_enable": {
                this.statusChange(true);
                this.refrushBillList();
                break;
            }
            case "btn_disable": {
                this.statusChange(false);
                this.refrushBillList();
                break;
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("delete_confirm".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.deleteCase();
        }
    }

    private void deleteCase() {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST);
        Object[] ids = billList.getSelectedRows().getPrimaryKeyValues();
        QFilter exitFilter = new QFilter("case", "in", (Object)ids);
        exitFilter.and("status", "=", (Object)InvCaseHandleRunStatusEnum.SUCCESS.getIndex());
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bcm_invcasepagedim", (String)"id,case", (QFilter[])exitFilter.toArray());
        Set deleteIdSet = coll.stream().map(r -> r.getLong("case")).collect(Collectors.toSet());
        Set deleteId = Arrays.stream(ids).map(Long.class::cast).collect(Collectors.toSet());
        deleteId.removeAll(deleteIdSet);
        if (deleteId.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u6267\u884c\u6210\u529f\u7684\u64cd\u4f5c\u8bb0\u5f55\u3002", (String)"InvChangeDataCaseSettingListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection cases = QueryServiceHelper.query((String)"bcm_invchangecaseentity", (String)"id,name,number,status", (QFilter[])new QFilter("id", "in", deleteId).toArray());
        List collect = cases.stream().filter(c -> CHKFormulaStatusEnum.enable.getIndex().equals(c.getString("status"))).map(ccase -> ccase.getString("number")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u65b9\u6848\u5df2\u542f\u7528\uff0c\u4e0d\u80fd\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"InvChangeDataCaseSettingListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), collect.toString()));
            return;
        }
        for (DynamicObject aCase : cases) {
            this.writeOperationLog(OpItemEnum.DELETE.getName(), aCase.getString("number"), aCase.getString("name"), ResultStatusEnum.SUCCESS.getName());
        }
        DeleteServiceHelper.delete((String)"bcm_invchangecaseentity", (QFilter[])new QFilter("id", "in", deleteId).toArray());
        DeleteServiceHelper.delete((String)"bcm_invchangecaseentry", (QFilter[])new QFilter("invchangecase", "in", deleteId).toArray());
        DeleteServiceHelper.delete((String)"bcm_invcasepagedim", (QFilter[])new QFilter("case", "in", deleteId).toArray());
        this.refrushBillList();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"InvChangeDataCaseSettingListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private void statusChange(boolean enable) {
        InvChangeCaseService caseService;
        StringJoiner checkResult;
        BillList billList = (BillList)this.getView().getControl(BILL_LIST);
        Object[] ids = billList.getSelectedRows().getPrimaryKeyValues();
        Object[] cases = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_invchangecaseentity"));
        long enableSize = Arrays.stream(cases).filter(c -> c.getString("status").equals(CHKFormulaStatusEnum.enable.getIndex())).count();
        long disableSize = Arrays.stream(cases).filter(c -> c.getString("status").equals(CHKFormulaStatusEnum.disable.getIndex())).count();
        if (enable && (long)ids.length == enableSize || !enable && (long)ids.length == disableSize) {
            this.getView().showTipNotification(enable ? ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u542f\u7528\u3002", (String)"InvChangeDataCaseSettingListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u7981\u7528\u3002", (String)"InvChangeDataCaseSettingListPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (enable && (checkResult = (caseService = new InvChangeCaseService(this.getModelId())).enableCheck((Collection)Sets.newHashSet((Object[])cases))).length() > 0) {
            this.getView().showTipNotification(checkResult.toString());
            return;
        }
        for (Object aCase : cases) {
            aCase.set("status", (Object)(enable ? CHKFormulaStatusEnum.enable.getIndex() : CHKFormulaStatusEnum.disable.getIndex()));
            String opName = enable ? OpItemEnum.ENABLE.getName() : OpItemEnum.DISABLE.getName();
            this.writeOperationLog(opName, aCase.getString("number"), aCase.getString("name"), ResultStatusEnum.SUCCESS.getName());
        }
        SaveServiceHelper.save((DynamicObject[])cases);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"InvChangeDataCaseSettingListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private void openInvDistributePage() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_invcasedistribute");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam(MODEL, (Object)this.getModelId());
        formShowParameter.setCustomParam("KEY_SCENARIO_ID", this.getScenarioId());
        this.getView().showForm(formShowParameter);
    }

    private void openEditCasePage(Long caseID, OperationStatus status) {
        int is;
        if (caseID != null && !MemberPermHelper.ifUserHasRootPermByModel((long)this.getUserId(), (String)String.valueOf(this.getModelId())) && (is = BcmBasePluginUtil.checkPermission(this.getUserId(), this.getModelId(), AppMetadataCache.getAppInfo((String)this.getBizAppId()).getId(), this.getView().getEntityId(), "0AQ3YJ2LET+U")) == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\u3002", (String)"PermissionClassFormPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_invchangecase");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam(MODEL, (Object)this.getModelId());
        formShowParameter.setCustomParam("scenario", this.getScenarioId());
        formShowParameter.setCustomParam("templatecatalog", (Object)this.getPageCache().get("focusnodeid"));
        formShowParameter.setCustomParam("caseID", (Object)caseID);
        formShowParameter.setStatus(status);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "case_closeback"));
        if (caseID != null) {
            formShowParameter.setPageId(this.getView().getPageId() + caseID);
        }
        this.getView().showForm(formShowParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        boolean catalogOrCasesMaybeChange;
        super.closedCallBack(closedCallBackEvent);
        this.refrushBillList();
        String actionId = closedCallBackEvent.getActionId();
        boolean bl = catalogOrCasesMaybeChange = "bcm_templatecatalog".equals(actionId) || "case_closeback".equals(actionId) || "bcm_templatemove".equals(actionId);
        if (catalogOrCasesMaybeChange) {
            this.cacheReadOnlyTreeAndCases();
        }
    }

    private void cacheReadOnlyTreeAndCases() {
        new TreeBillPermUtil(this.getView()).setModelId(String.valueOf(this.getModelId())).setEntityNameLTree(this.getTemplateCataLogEntryEntity()).setEntityNameRBill("bcm_invchangecaseentity").cacheReadOnly();
    }

    private Object getScenarioId() {
        Object scenarioId = null;
        Object scenarioObject = this.getModel().getValue("scenario");
        if (null != scenarioObject) {
            scenarioId = ((DynamicObject)scenarioObject).get("id");
        }
        return scenarioId;
    }

    @Override
    protected String getEntryEntity() {
        return "bcm_invchangecaseentity";
    }

    @Override
    protected QFilter getCatalogqFilter(boolean isContainNull) {
        TreeView tview = (TreeView)this.getControl("templatecatalog");
        String parentid = tview.getTreeState().getFocusNode() == null ? "" : tview.getTreeState().getFocusNode().get("parentid").toString();
        return super.getCatalogqFilter(StringUtil.isEmptyString((String)parentid));
    }

    @Override
    protected QFilter getTemplateIdsQFilter(QFilter qFilter1) {
        return qFilter1;
    }

    @Override
    protected String getCatalogType() {
        return TemplateCatalogTypeEnum.CHANGECASELOG.getType() + "";
    }

    @Override
    protected String getRootName() {
        return TemplateCatalogTypeEnum.CHANGECASELOG.getName();
    }

    @Override
    protected void refrushBillList() {
        QFilter filter = new QFilter(MODEL, "=", (Object)this.getModelId());
        BillList billList = (BillList)this.getView().getControl(BILL_LIST);
        if (this.getModel().getValue(MODEL) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"InvChangeDataCaseSettingListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            billList.getFilterParameter().setFilter(new QFilter("1", "=", (Object)0));
            billList.refresh();
            return;
        }
        filter.and("id", "in", (Object)CheckUtil.getApplySceneTmpls((Long)this.getModelId(), (Long)((Long)this.getScenarioId()), (String)this.getEntryEntity()));
        filter.and(this.getCatalogqFilter(false));
        String modelId = ((DynamicObject)this.getModel().getValue(MODEL)).getString("id");
        List<Long> noPermEntryIds = new TreeBillPermUtil(this.getView()).setModelId(String.valueOf(modelId)).setEntityNameLTree("bcm_templatecatalog").setEntityNameRBill("bcm_invchangecaseentity").noPermEntryIds();
        filter.and("id", "not in", noPermEntryIds);
        billList.clearSelection();
        billList.setFilterParameter(new FilterParameter(filter, null));
        billList.refresh();
        this.setOnlyReadButton(true);
    }

    @Override
    public String getModelSign() {
        return MODEL;
    }
}

