/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest.changecase;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.F7ItemFillBackArgs;
import kd.bos.form.spread.LookUpDataArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.integration.mapping.MemAndComVO;
import kd.fi.bcm.business.invest.changecase.InvChangeCaseService;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.scheme.DimensionScope;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.scheme.model.AbstractDimensionMember;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.BCMNumberRule;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.InvestConstant;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.MenuShowTypeEnum;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.RowColExcuteEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.chkcheck.CHKFormulaStatusEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.integration.ComputeOprtEnum;
import kd.fi.bcm.common.enums.invest.InvCaseChangeTypeEnum;
import kd.fi.bcm.common.enums.invest.InvCaseProcessEnum;
import kd.fi.bcm.common.enums.log.DataPermLogMultiLangEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.papertemplate.PaperTemplateSceneSettingHelper;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.MulTiF7FilterTempleUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.BcmBasePluginUtil;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.intergration.membermap.handel.MapSheetUtil;
import kd.fi.bcm.formplugin.spread.SpreadBasePlugin;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.spread.SpreadUtils;
import kd.fi.bcm.formplugin.template.model.AskExcuteInfo;
import kd.fi.bcm.formplugin.template.model.ISpreadModelSupplier;
import kd.fi.bcm.formplugin.template.model.SpreadDataModel;
import kd.fi.bcm.formplugin.util.AdjustModelUtil;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Book;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.event.EventConstant;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.Dimension;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class InvChangeDataCaseSettingPlugin
extends SpreadBasePlugin
implements ISpreadModelSupplier {
    private static final String SPREAD_KEY = "spreadap";
    public static final String DESIGNDIM_DEFAULT = "111000000000";
    public static final String ACCOUNTSCOOPE = "accountscoope";
    private static final String ACCOUNT_DIMENSION_SCOPE = "accountDimensionScope";
    private SpreadManager spreadManager;
    private static final String COMMEM_SPREAD = "commemspread";
    private static final int MAX_ROW = 2000;
    private static final String IS_MODIFY = "data_modify";
    protected Map<Integer, String> colSignIndex;
    private static final String CACHE_DIM = "cache_dim";
    private final Map<String, String> dimKeys = new HashMap<String, String>(15);
    private final Map<String, String> userdefineMap2Nums = new HashMap<String, String>(6);
    public static final String SCENARIOSET = "scenarioset";
    public static final String SCENARIOS = "scenarios";
    private static final List<String> AUDIT_TRAIL = Arrays.asList("Sca", "Scd", "Nsca", "Nscd", "CprP", "CprB");
    private final String[] defaultDim = new String[]{"Currency", "Process", "AuditTrail", "Account", "ChangeType", "MyCompany", "InternalCompany", "MultiGAAP", "DataSort", "userdefine1", "userdefine2", "userdefine3", "userdefine4", "userdefine5", "userdefine6"};

    public InvChangeDataCaseSettingPlugin() {
        this.userdefineMap2Nums.put("dim1", "userdefine1");
        this.userdefineMap2Nums.put("dim2", "userdefine2");
        this.userdefineMap2Nums.put("dim3", "userdefine3");
        this.userdefineMap2Nums.put("dim4", "userdefine4");
        this.userdefineMap2Nums.put("dim5", "userdefine5");
        this.userdefineMap2Nums.put("dim6", "userdefine6");
        for (String dim : this.defaultDim) {
            this.dimKeys.put(dim.toLowerCase(Locale.ENGLISH), "");
        }
    }

    @Override
    public void registerListener(EventObject e) {
        this.addItemClickListeners("toolbarap");
        this.addClickListeners(ACCOUNTSCOOPE, SCENARIOSET);
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getControl("permclass")), (Object)this.getModelId());
    }

    public SpreadManager getSpreadManager() {
        if (this.spreadManager == null) {
            String serial = this.getPageCache().get("KEY_SPREAD_MODEL");
            if (kd.bos.util.StringUtils.isNotEmpty((String)serial)) {
                this.spreadManager = JsonSerializerUtil.toSpreadManager((String)serial);
            } else {
                this.spreadManager = new SpreadManager(ResManager.loadKDString((String)"\u80a1\u6743\u53d8\u52a8\u65b9\u6848\u6620\u5c04", (String)"InvChangeDataCaseSettingPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
                this.getPageCache().put("KEY_SPREAD_MODEL", this.getSpreadModelSeria(this.spreadManager));
            }
        }
        return this.spreadManager;
    }

    @Override
    public void click(EventObject e) {
        String f7Key = ((Control)e.getSource()).getKey();
        if (ACCOUNTSCOOPE.equals(f7Key)) {
            String number = DimTypesEnum.ACCOUNT.getNumber();
            Long modelId = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
            FormShowParameter para = MulTiF7FilterTempleUtils.createMulTiF7ShowParameter((IPageCache)this.getPageCache(), (long)modelId, (String)number, null);
            DimensionScope dimensionScope = this.getAccountDimensionScope();
            if (para != null) {
                para.setCustomParam("sign", (Object)number);
                para.setCustomParam("showScopes", (Object)ObjectSerialUtil.toByteSerialized((Object)new int[]{10, 90}));
                para.setCustomParam(number, (Object)(dimensionScope != null ? SerializationUtils.toJsonString((Object)dimensionScope.getdimMembers()) : "[]"));
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ACCOUNTSCOOPE);
                para.setCloseCallBack(closeCallBack);
                this.getView().showForm(para);
            }
        } else if (SCENARIOSET.equals(f7Key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bcm_templatemutiscenceset");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("model", (Object)this.getModelId());
            formShowParameter.setCustomParam("selecteditems", (Object)this.getPageCache().get(SCENARIOSET));
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, f7Key));
            this.getView().showForm(formShowParameter);
        }
    }

    private DimensionScope getAccountDimensionScope() {
        String accountScopeCache = this.getPageCache().get(ACCOUNT_DIMENSION_SCOPE);
        if (StringUtils.isEmpty((CharSequence)accountScopeCache)) {
            return null;
        }
        return (DimensionScope)SerializationUtils.deSerializeFromBase64((String)accountScopeCache);
    }

    @Override
    public String getSpreadKey() {
        return COMMEM_SPREAD;
    }

    @Override
    public SpreadManager getSpreadModel() {
        return this.getSpreadManager();
    }

    @Override
    public void cacheSpreadModel(SpreadManager spread) {
        this.spreadManager = spread;
        this.getPageCache().put("KEY_SPREAD_MODEL", this.getSpreadModelSeria(spread));
    }

    public String getSpreadModelSeria(SpreadManager spread) {
        return JsonSerializerUtil.toJson((SpreadManager)spread);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initUserDefineNumber();
        Long caseId = (Long)this.getFormCustomParam("caseID");
        Long model = (Long)this.getFormCustomParam("model");
        this.getModel().setValue("model", (Object)model);
        this.initProcessCommon();
        this.cacheSpreadModel(this.getSpreadModel());
        if (caseId == null || caseId == 0L) {
            this.getModel().setValue("id", this.getFormCustomParam("caseID"));
            this.getModel().setValue("status", (Object)CHKFormulaStatusEnum.disable.getIndex());
            this.getModel().setValue("model", this.getFormCustomParam("model"));
            Object scenarioId = this.getFormCustomParam("scenario");
            if (Objects.nonNull(scenarioId)) {
                ArrayList<Map> selecteditems = new ArrayList<Map>(16);
                IDNumberTreeNode scenario = MemberReader.findScenaMemberById((Long)this.getModelId(), (Long)((Long)scenarioId));
                selecteditems.add(MapInitHelper.ofMap((Object)"id", (Object)scenario.getId(), (Object)"scope", (Object)"10", (Object)"isexcept", (Object)"0"));
                this.getModel().setValue(SCENARIOSET, (Object)PaperTemplateSceneSettingHelper.formateDisplay((String)scenario.getNumber(), (String)scenario.getName(), (String)"10", (String)"0"));
                this.getPageCache().put(SCENARIOSET, this.toByteSerialized(selecteditems));
            }
            this.getModel().setValue("templatecatalog", this.getFormCustomParam("templatecatalog"));
            this.setEnableInfoByDesginDim(DESIGNDIM_DEFAULT);
            this.buildSpread(this.getDesignDimStr());
        } else {
            this.initEditPage(caseId);
        }
        String status = (String)this.getModel().getValue("status");
        int dimsize = Integer.parseInt(this.getPageCache().get(this.getFormCustomParam("model") + "dimsize"));
        if (status.equals(CHKFormulaStatusEnum.enable.getIndex())) {
            SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
            invoker.lockCell(2, 0, 2000, dimsize + dimsize + 1);
        }
        this.setEnableInfoByStatus(status);
        this.setModified(false);
        SpreadClientInvoker.invokeSetWorkbookOptions(this.getClientViewProxy(), this.getSpreadKey(), MapInitHelper.ofMap((Object)SpreadProperties.SetWorkbookOptions.AllowCopyPasteExcelStyle.k(), (Object)false));
    }

    private void initProcessCommon() {
        ComboEdit ce = (ComboEdit)this.getControl("processcb");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        List ls = InvCaseProcessEnum.getInvChangeCaseNumber();
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)this.getModelId());
        qfBuilder.add("number", "in", (Object)ls);
        qfBuilder.or("parent.number", "in", (Object)ls);
        qfBuilder.add("isleaf", "=", (Object)true);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_processmembertree", (String)"id,number,name,isleaf", (QFilter[])qfBuilder.toArray(), (String)"level");
        if (!CollectionUtils.isEmpty((Collection)doc)) {
            DynamicObject ejeProcess = (DynamicObject)doc.get(0);
            for (DynamicObject dy : doc) {
                String number = dy.getString("number");
                String name = dy.getString("name");
                if (number.equals("EJE")) {
                    ejeProcess = dy;
                }
                items.add(new ComboItem(new LocaleString(number + " " + name), InvCaseProcessEnum.getIndex((String)number) + ""));
            }
            if (CollectionUtils.isNotEmpty(items)) {
                ce.setComboItems(items);
                String index = InvCaseProcessEnum.getIndex((String)ejeProcess.getString("number"));
                this.getModel().setValue("processcb", (Object)index);
                this.getModel().setValue("processbase", (Object)ejeProcess.getLong("id"));
            }
        }
    }

    private void setEnableInfoByStatus(String status) {
        if (status.equals(CHKFormulaStatusEnum.enable.getIndex())) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"name", "description", "changetypeset", "permclass", "chargeagainst"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_save"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_enable"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"btn_disable"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"name", "description", "permclass", "chargeagainst"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_save"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"btn_enable"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_disable"});
        }
    }

    private void setEnableInfoByDesginDim(String desginDim) {
        Map<String, String> dimensionNumMap = this.initUserDefineNumber();
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"Currency".toLowerCase(Locale.ENGLISH), "Process".toLowerCase(Locale.ENGLISH), "AuditTrail".toLowerCase(Locale.ENGLISH)});
        Set dimKeyFromDB = dimensionNumMap.entrySet().stream().map(m -> (String)m.getValue()).collect(Collectors.toSet());
        Set values = this.userdefineMap2Nums.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toSet());
        Set<String> dimKeyAll = this.dimMapFromCache().entrySet().stream().filter(entry -> !values.contains(entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toSet());
        dimKeyAll.addAll(this.userdefineMap2Nums.keySet());
        dimKeyAll.forEach(dim -> {
            if (dimKeyFromDB.contains(dim)) {
                return;
            }
            String checkBoxName = this.userdefineMap2Nums.getOrDefault(dim, (String)dim);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{checkBoxName});
        });
        if (!kd.bos.util.StringUtils.isEmpty((String)desginDim)) {
            char[] chars = desginDim.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                this.getModel().beginInit();
                this.getModel().setValue(this.defaultDim[i].toLowerCase(Locale.ENGLISH), (Object)('1' == chars[i] ? 1 : 0));
                this.getModel().endInit();
            }
        }
        this.getView().updateView();
    }

    private void setUserDefineVisible() {
        this.dimKeys.forEach((k, v) -> this.getView().setVisible(Boolean.valueOf(!"".equals(v)), new String[]{k}));
    }

    private Map<String, String> initUserDefineNumber() {
        Map dimensionNumMap = DimensionServiceHelper.getDimensionNumMapped((Object)this.getFormCustomParam("model"));
        dimensionNumMap.forEach((k, v) -> {
            if (this.userdefineMap2Nums.containsKey(v)) {
                this.dimKeys.put(this.userdefineMap2Nums.get(v), (String)k);
            } else {
                this.dimKeys.put((String)v, (String)k);
            }
        });
        this.setUserDefineVisible();
        this.getPageCache().put(CACHE_DIM, ObjectSerialUtil.toByteSerialized(this.dimKeys));
        return dimensionNumMap;
    }

    private Map<String, String> dimMapFromCache() {
        String cacheDim = this.getPageCache().get(CACHE_DIM);
        return (Map)ObjectSerialUtil.deSerializedBytes((String)cacheDim);
    }

    private void initEditPage(Long caseId) {
        DynamicObject permClass;
        DynamicObject bpObj;
        DynamicObject caseObject = BusinessDataServiceHelper.loadSingle((Object)caseId, (String)"bcm_invchangecaseentity");
        this.getModel().setValue("id", (Object)caseId);
        this.getModel().setValue("number", caseObject.get("number"));
        this.getModel().setValue("name", caseObject.get("name"));
        this.getModel().setValue("description", caseObject.get("description"));
        this.getModel().setValue("changetypeset", caseObject.get("changetype"));
        this.getModel().setValue("chargeagainst", caseObject.get("chargeagainst"));
        this.getModel().setValue("status", caseObject.get("status"));
        this.getModel().setValue("templatecatalog", caseObject.get("templatecatalog"));
        this.getModel().setValue("model", caseObject.get("model"));
        DynamicObjectCollection dynamicObjects = caseObject.getDynamicObjectCollection(SCENARIOS);
        if (Objects.nonNull(dynamicObjects)) {
            this.setScenarioset(dynamicObjects);
        }
        if ((bpObj = (DynamicObject)caseObject.get("process")) != null) {
            this.getModel().setValue("processbase", (Object)bpObj.getLong("id"));
            this.getModel().setValue("processcb", (Object)InvCaseProcessEnum.getIndex((String)bpObj.getString("number")));
        }
        DynamicObjectCollection dimscopes = caseObject.getDynamicObjectCollection("dimscope");
        HashMap dimemMap = new HashMap(16);
        if (dimscopes != null && dimscopes.size() > 0) {
            dimscopes.stream().forEach(scope -> dimemMap.put(scope.getLong("memberid"), scope.getInt("scope")));
            SchemeContext schemeContext = new SchemeContext(this.getModelId());
            DimensionScope ds = new DimensionScope(Long.toString(this.getModelId()), schemeContext.getDimensionByNumber(DimTypesEnum.ACCOUNT.getNumber()), dimemMap);
            this.getModel().setValue(ACCOUNTSCOOPE, (Object)ds.toMultiPersonalString(MenuShowTypeEnum.NUMBERNDNAME));
            this.getPageCache().put(ACCOUNT_DIMENSION_SCOPE, SerializationUtils.serializeToBase64((Object)ds));
        }
        if (Objects.nonNull(permClass = PermClassEntityHelper.getPermissionClassEntity((DynamicObject)caseObject))) {
            this.getModel().setValue("permclass", permClass.get("permclass"));
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"changetypeset"});
        String spreadjson = caseObject.getString("spreadjson");
        String data = caseObject.getString("data");
        SpreadClientInvoker.invokeSetSpreadJsonMethod(this.getClientViewProxy(), this.getSpreadKey(), spreadjson);
        SpreadClientInvoker.invokeCloseToolBar(this.getClientViewProxy(), this.getSpreadKey());
        SpreadClientInvoker.invokeLockOrHideSpreadMenuItems(this.getClientViewProxy(), this.getSpreadKey());
        SpreadClientInvoker.invokeLockSwitchViewAndUploadFile(this.getClientViewProxy(), this.getSpreadKey());
        this.spreadManager = JsonSerializerUtil.toSpreadManager((String)data);
        this.fillMemberId(this.spreadManager);
        this.cacheSpreadModel(this.spreadManager);
        String designDimStr = caseObject.getString("designdim");
        designDimStr = kd.bos.util.StringUtils.isBlank((String)designDimStr) ? DESIGNDIM_DEFAULT : designDimStr;
        this.setEnableInfoByDesginDim(designDimStr);
        this.cacheDimSize(designDimStr);
    }

    private void setScenarioset(DynamicObjectCollection dynamicObjects) {
        List<Map<String, Object>> selecteditems = this.cvtDyToList(dynamicObjects);
        this.getPageCache().put(SCENARIOSET, this.toByteSerialized(selecteditems));
        String stringJoiner = this.cvtMutiScenarioStr(dynamicObjects);
        this.getModel().setValue(SCENARIOSET, (Object)stringJoiner);
        this.getModel().setDataChanged(false);
    }

    private List<Map<String, Object>> cvtDyToList(DynamicObjectCollection dynamicObjects) {
        ArrayList<Map<String, Object>> selecteditems = new ArrayList<Map<String, Object>>(16);
        dynamicObjects.forEach(dy -> selecteditems.add(MapInitHelper.ofMap((Object)"id", (Object)dy.getLong("scenariomeb.id"), (Object)"scope", (Object)dy.getString("scenarioscope"), (Object)"isexcept", (Object)dy.getString("isexcept"))));
        return selecteditems;
    }

    private String cvtMutiScenarioStr(DynamicObjectCollection returnData) {
        if (CollectionUtil.isEmpty((Collection)returnData)) {
            return "";
        }
        StringJoiner stringJoiner = new StringJoiner(";");
        returnData.forEach(data -> {
            String number = data.getString("scenariomeb.number");
            String name = data.getString("scenariomeb.name");
            String isexcept = data.getString("isexcept");
            String scope = data.getString("scenarioscope");
            stringJoiner.add(PaperTemplateSceneSettingHelper.formateDisplay((String)number, (String)name, (String)scope, (String)isexcept));
        });
        return stringJoiner.toString();
    }

    private void fillMemberId(SpreadManager spreadManager) {
        Long model = (Long)this.getFormCustomParam("model");
        String modelNum = MemberReader.findModelNumberById((Object)model);
        Iterator sheetIterator = Optional.ofNullable(spreadManager).map(SpreadManager::getBook).map(Book::iterator).orElseGet(() -> new Iterator<Sheet>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Sheet next() {
                return null;
            }
        });
        while (sheetIterator.hasNext()) {
            Sheet sheet = (Sheet)sheetIterator.next();
            int maxRowCount = sheet.getMaxRowCount();
            sheet.iteratorCells(cell -> {
                String entitySign = (String)cell.getUserObject("entitysign");
                if (kd.bos.util.StringUtils.isEmpty((String)entitySign)) {
                    return;
                }
                CharSequence[] split = entitySign.split("!");
                if (split.length != 3) {
                    return;
                }
                Long dimensionId = MemberReader.getDimensionIdByNum((long)model, (String)split[1]);
                split[2] = String.valueOf(dimensionId);
                cell.setUserObject("entitysign", (Object)String.join((CharSequence)"!", split));
                for (int i = cell.getRow() + 1; i < maxRowCount; ++i) {
                    Cell DimCell = sheet.getCell(i, cell.getCol());
                    List dimMembers = (List)DimCell.getUserObject("KEY_DIM_FLAG");
                    if (dimMembers == null) continue;
                    dimMembers.stream().map(DimMember.class::cast).forEach(arg_0 -> InvChangeDataCaseSettingPlugin.lambda$null$9(modelNum, (String[])split, arg_0));
                }
            });
        }
    }

    private void cacheDimSize(String designDim) {
        long binary = Long.parseLong(designDim, 2);
        this.getPageCache().put(this.getFormCustomParam("model") + "dimsize", String.valueOf(Long.bitCount(binary)));
        this.getPageCache().put(this.getFormCustomParam("model") + "designdim", designDim);
    }

    private void buildSpreadRow(List<DynamicObject> entrys) {
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
        int dimsize = Integer.parseInt(this.getPageCache().get(this.getFormCustomParam("model") + "dimsize"));
        for (int i = 2; i < entrys.size() + 2; ++i) {
            DimMember mem;
            String dimNumber;
            String[] dimInfo;
            Cell dimcell;
            Cell cell;
            int j;
            DynamicObject entry = entrys.get(i - 2);
            int sort = entry.getInt("sort");
            DynamicObjectCollection dimEntry = entry.getDynamicObjectCollection("issinglemapentry");
            List<DynamicObject> srcEntry = dimEntry.stream().filter(e -> e.getBoolean("issrc")).collect(Collectors.toList());
            List<DynamicObject> trgEntry = dimEntry.stream().filter(e -> !e.getBoolean("issrc")).collect(Collectors.toList());
            Map<String, IDNumberTreeNode> srcNode = this.tranEntryToNode(srcEntry);
            Map<String, IDNumberTreeNode> trgNode = this.tranEntryToNode(trgEntry);
            for (j = 0; j < dimsize; ++j) {
                cell = this.getSheet().getCell(sort, j);
                dimcell = this.getSheet().getCell(1, j);
                dimInfo = dimcell.getUserObject("entitysign").toString().split("!");
                dimNumber = dimInfo[1];
                IDNumberTreeNode trgdim = trgNode.get(dimNumber);
                if (trgdim == null || trgdim.getNumber().contains("not found")) {
                    invoker.updataValue(cell.getRow(), cell.getCol(), null);
                    cell.clearMembersOfUserObject();
                    cell.setValue(null);
                    continue;
                }
                mem = this.setMembackToCell(cell, trgdim.getName(), trgdim.getNumber(), trgdim.getId());
                this.showF7Value(cell.getRow(), cell.getCol(), mem, invoker);
            }
            for (j = dimsize + 1; j < dimsize + dimsize + 1; ++j) {
                cell = this.getSheet().getCell(sort, j);
                dimcell = this.getSheet().getCell(1, j);
                dimInfo = dimcell.getUserObject("entitysign").toString().split("!");
                dimNumber = dimInfo[1];
                IDNumberTreeNode srcdim = srcNode.get(dimNumber);
                if (srcdim == null || srcdim.getNumber().contains("not found")) {
                    invoker.updataValue(cell.getRow(), cell.getCol(), null);
                    cell.clearMembersOfUserObject();
                    cell.setValue(null);
                    continue;
                }
                mem = this.setMembackToCell(cell, srcdim.getName(), srcdim.getNumber(), srcdim.getId());
                this.showF7Value(cell.getRow(), cell.getCol(), mem, invoker);
            }
            Cell cell2 = this.getSheet().getCell(sort, dimsize);
            ComputeOprtEnum type = ComputeOprtEnum.getEnumByid((String)entry.getString("computetype"));
            if (type != null) {
                invoker.updataValue(cell2.getRow(), cell2.getCol(), type.getName());
                cell2.clearMembersOfUserObject();
                cell2.setValue((Object)type.getIndex());
                continue;
            }
            cell2.clearMembersOfUserObject();
            cell2.setValue(null);
        }
        this.cacheSpreadModel(this.spreadManager);
    }

    private Map<String, IDNumberTreeNode> tranEntryToNode(List<DynamicObject> entry) {
        HashMap<String, IDNumberTreeNode> result = new HashMap<String, IDNumberTreeNode>(10);
        for (DynamicObject object : entry) {
            String dimNumber = object.getString("dimnumber");
            String memNumber = object.getString("memnumber");
            IDNumberTreeNode tempNode = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)this.getFormCustomParam("model")), (String)dimNumber, (String)memNumber);
            result.put(dimNumber, tempNode);
        }
        return result;
    }

    private DynamicObjectCollection getDimInfo(List<String> dimNumList) {
        QFilter qFilter = new QFilter("model", "=", this.getFormCustomParam("model"));
        qFilter.and("number", "in", dimNumList);
        String selectFields = "id,name,number,shortnumber,membermodel,issysdimension,fieldmapped,dseq";
        return QueryServiceHelper.query((String)"bcm_dimension", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"dseq");
    }

    protected String getEmptyJson(int maxrow, int maxcol) {
        return "{\"version\":\"10.0.1\",\"sheets\":{\"sheet1\":{\"name\":\"sheet1\",\"rowCount\":\"" + maxrow + "\",\"columnCount\":\"" + maxcol + "\"}}}";
    }

    private void buildSpread(String designDim) {
        SpreadClientInvoker.invokeSetSpreadJsonMethod(this.getClientViewProxy(), this.getSpreadKey(), this.getEmptyJson(2000, 40));
        SpreadClientInvoker.invokeCloseToolBar(this.getClientViewProxy(), this.getSpreadKey());
        SpreadClientInvoker.invokeLockOrHideSpreadMenuItems(this.getClientViewProxy(), this.getSpreadKey());
        SpreadClientInvoker.invokeLockSwitchViewAndUploadFile(this.getClientViewProxy(), this.getSpreadKey());
        ArrayList<String> dimNums = new ArrayList<String>();
        char[] chars = designDim.toCharArray();
        Map<String, String> dimKeys = this.dimMapFromCache();
        for (int i = 0; i < chars.length; ++i) {
            if ('1' != chars[i]) continue;
            dimNums.add(dimKeys.get(this.defaultDim[i].toLowerCase(Locale.ENGLISH)));
        }
        MemAndComVO vo = this.getMemAndComVO(dimNums);
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
        invoker.setBatch(true);
        int sourceCol = vo.getSourcePro().size();
        invoker.setSpan(0, 0, 1, sourceCol);
        invoker.setSpan(0, sourceCol, 1, sourceCol + 1);
        invoker.updataValue(0, 0, ResManager.loadKDString((String)"\u76ee\u6807", (String)"InvChangeDataCaseSettingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        invoker.updataValue(0, sourceCol, ResManager.loadKDString((String)"\u6e90", (String)"InvChangeDataCaseSettingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        invoker.setStyle(0, 0, 2, sourceCol + sourceCol + 1, this.getStyleMap());
        invoker.lockCell(0, 0, 2, sourceCol + sourceCol + 1);
        invoker.setFrozenSheet(2, 0, 0, 0, "#A2CD5A", 0);
        int index = 0;
        Map<String, MemAndComVO.Node> targenodes = vo.getTargetPro().stream().collect(Collectors.toMap(k -> k.getNumber(), v -> v));
        for (int i = 0; i < this.defaultDim.length; ++i) {
            MemAndComVO.Node n = targenodes.get(dimKeys.get(this.defaultDim[i].toLowerCase(Locale.ENGLISH)));
            if (n == null) continue;
            invoker.updataValue(1, index, n.getName());
            invoker.setColumnsWidth(index, 100);
            invoker.setF7TypeCell(2, index, 2000, 1, 0, 0);
            this.getSheet().getCell(1, index).setUserObject("entitysign", (Object)n.getEntityName());
            ++index;
        }
        invoker.updataValue(1, index, ResManager.loadKDString((String)"\u8ba1\u7b97\u5173\u7cfb", (String)"GroupMemMapSheetHandel_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.getSheet().getCell(1, index).setUserObject("entitysign", (Object)"_enum_computeoprt");
        invoker.setF7TypeCell(2, index, 2000, 1, 0, 1);
        ++index;
        Map<String, MemAndComVO.Node> srcnodes = vo.getSourcePro().stream().collect(Collectors.toMap(k -> k.getNumber(), v -> v));
        for (int i = 0; i < this.defaultDim.length; ++i) {
            MemAndComVO.Node n = srcnodes.get(dimKeys.get(this.defaultDim[i].toLowerCase(Locale.ENGLISH)));
            if (n == null) continue;
            invoker.updataValue(1, index, n.getName());
            invoker.setColumnsWidth(index, 100);
            invoker.setF7TypeCell(2, index, 2000, 1, 0, 0);
            this.getSheet().getCell(1, index).setUserObject("entitysign", (Object)n.getEntityName());
            ++index;
        }
        invoker.startToInvoke();
        this.cacheSpreadModel(this.spreadManager);
    }

    protected Map<String, Object> getStyleMap() {
        HashMap<String, Object> styleMap = new HashMap<String, Object>();
        styleMap.put(SpreadProperties.SetCellStyleMethod.BACKCOLOR.k(), "#b2b2b2");
        HashMap<String, String[]> styleMap0 = new HashMap<String, String[]>();
        styleMap0.put("bls", new String[]{"thin"});
        styleMap0.put("blc", new String[]{"#000000"});
        styleMap.put("bl", styleMap0);
        styleMap.put(SpreadProperties.SetCellStyleMethod.HORIZONTALALIGN.k(), 1);
        styleMap.put(SpreadProperties.SetCellStyleMethod.DIRECTIONALIGN.k(), 1);
        return styleMap;
    }

    private MemAndComVO getMemAndComVO(List<String> dimNumList) {
        DynamicObjectCollection dims = this.getDimInfo(dimNumList);
        this.getPageCache().put(this.getFormCustomParam("model") + "dimsize", String.valueOf(dims.size()));
        MemAndComVO result = new MemAndComVO(dims.size(), dims.size(), MemAndComVO.VOEnum.M);
        for (DynamicObject dim : dims) {
            result.addSource(dim.getString("number"), dim.getString("name"), dim.getString("membermodel") + "!" + dim.getString("number") + "!" + dim.getLong("id"), dim.getLong("id"));
            result.addTarget(dim.getString("number"), dim.getString("name"), dim.getString("membermodel") + "!" + dim.getString("number") + "!" + dim.getLong("id"), dim.getLong("id"));
        }
        return result;
    }

    protected Sheet getSheet() {
        return this.getSpreadManager().getBook().getSheet(0);
    }

    @Override
    public void doubleClickLockedCell(int row, int col) {
        DynamicObject thisCase;
        Long caseId = (Long)this.getModel().getValue("id");
        if (caseId != 0L && (thisCase = QueryServiceHelper.queryOne((String)"bcm_invchangecaseentity", (String)"status", (QFilter[])new QFBuilder("id", "=", (Object)caseId).toArray())).getBoolean("status")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u542f\u7528\uff0c\u4e0d\u80fd\u4fee\u6539\u3002", (String)"InvChangeDataCaseSettingPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void spreadF7Click(int row, int col) {
        super.spreadF7Click(row, col);
        int dimsize = Integer.parseInt(this.getPageCache().get(this.getFormCustomParam("model") + "dimsize"));
        Cell header = this.getHeader(col);
        if (header != null) {
            String entity = header.getUserObject("entitysign").toString().split("!")[0];
            QFilter numberFilter = new QFilter("number", "=", (Object)header.getUserObject("entitysign").toString().split("!")[1]);
            DynamicObject dimObj = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()), numberFilter});
            HashMap<String, Object> customParam = new HashMap<String, Object>();
            customParam.put("dimsize", dimsize);
            customParam.put("col", col);
            BasedataEditSingleMemberF7 f7 = SingleMemberF7Util.createBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), dimObj.getLong("id"), "cellF7", null, true, SingleF7TypeEnum.LEAF, customParam);
            f7.setF7title(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9", (String)"InvChangeDataCaseSettingPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            f7.setCallBackClassName(this.getClass().getName());
            QFilter filter = this.getMemberFilter(col, dimsize, entity);
            if (Objects.isNull(filter)) {
                return;
            }
            f7.setCustomFilter(filter);
            f7.click();
        }
    }

    private boolean checkIsDeleteRow(AskExcuteInfo excuteinfo) {
        Integer[] preRow = new Integer[]{0, 1};
        if (excuteinfo.getOperationdata().contains(preRow[0]) || excuteinfo.getOperationdata().contains(preRow[1])) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5305\u542b\u9884\u7f6e\u7684\u884c\u4e0d\u80fd\u5220\u9664\u3002", (String)"InvChangeDataCaseSettingPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean checkIsAddRow(AskExcuteInfo excuteinfo) {
        Integer[] preRow = new Integer[]{0, 1};
        if (excuteinfo.getOperationdata().contains(preRow[0]) || excuteinfo.getOperationdata().contains(preRow[1])) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5305\u542b\u9884\u7f6e\u7684\u884c\u4e0d\u80fd\u63d2\u5165\u65b0\u884c\u3002", (String)"InvChangeDataCaseSettingPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.setCombo();
        this.registerAfterEvent(EventConstant.ActionName.ADD_COL, e -> this.getView().showTipNotification(ResManager.loadKDString((String)"\u5305\u542b\u9884\u7f6e\u7684\u5217\u4e0d\u80fd\u63d2\u5165\u65b0\u5217\u3002", (String)"InvChangeDataCaseSettingPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        this.registerAfterEvent(EventConstant.ActionName.REMOVE_COL, e -> this.getView().showTipNotification(ResManager.loadKDString((String)"\u5305\u542b\u9884\u7f6e\u7684\u5217\u4e0d\u80fd\u5220\u9664\u5217\u3002", (String)"InvChangeDataCaseSettingPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        this.registerAfterEvent(EventConstant.ActionName.ADD_ROW, e -> {
            AskExcuteInfo excuteinfo = (AskExcuteInfo)e.getSource();
            if (this.checkIsAddRow(excuteinfo)) {
                return;
            }
            this.updateRowAndCol(excuteinfo);
            this.getSpreadManager().getBook().getSheet(0).putUserObject("change", (Object)true);
        });
        this.registerAfterEvent(EventConstant.ActionName.REMOVE_ROW, e -> {
            AskExcuteInfo excuteinfo = (AskExcuteInfo)e.getSource();
            if (this.checkIsDeleteRow(excuteinfo)) {
                return;
            }
            this.updateRowAndCol(excuteinfo);
            this.getSpreadManager().getBook().getSheet(0).putUserObject("change", (Object)true);
        });
        this.registerAfterEvent(EventConstant.ActionName.UPDATE_VALUE, e -> {
            int dimsize = Integer.parseInt(this.getPageCache().get(this.getFormCustomParam("model") + "dimsize"));
            SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
            invoker.setBatch(true);
            Cell cell = this.getSheet().getCell(((Cell)e.getSource()).getRow(), ((Cell)e.getSource()).getCol());
            cell.setValue(((Cell)e.getSource()).getValue());
            cell.getDimensions().clear();
            cell.getUserObject().clear();
            Cell head = this.getHeader(((Cell)e.getSource()).getCol());
            Object input = cell.getValue();
            if (cell.getCol() >= dimsize + dimsize + 1) {
                input = "";
            }
            String inputString = String.valueOf(input);
            if (input == null || kd.bos.util.StringUtils.isBlank((String)inputString)) {
                cell.setValue(null);
                this.mergeInvokeUpdateValueCommands(Lists.newArrayList((Object[])new Map[]{AdjustModelUtil.packedUpdateCellMap(cell.getRow(), cell.getCol(), null)}));
                cell.removeUserObject("entitysign");
            } else {
                String sign = this.getSignByCol(cell.getCol());
                if (sign.startsWith("bcm")) {
                    String[] entitySigns = head.getUserObject("entitysign").toString().split("!");
                    String entity = entitySigns[1];
                    String memberNumber = inputString.split("\\|")[0];
                    IDNumberTreeNode dim = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)entity, (String)memberNumber);
                    boolean numberAndLeafMeetTheConditions = this.numberAndLeafCondition(entitySigns[0], cell.getCol() <= dimsize, dimNumber -> dimNumber.contains(dim.getNumber()), () -> dim.isLeaf(), () -> Boolean.TRUE);
                    if (this.dimCanBeFind(dim) && this.dimHavePerm(dim, entitySigns) && numberAndLeafMeetTheConditions) {
                        DimMember mem = this.setMembackToCell(cell, dim.getName(), dim.getNumber(), dim.getId());
                        this.showF7Value(cell.getRow(), cell.getCol(), mem, invoker);
                    } else {
                        cell.clearMembersOfUserObject();
                        cell.setValue(null);
                        this.setCellChange(cell);
                        DimMember mem = this.packMem("", "", "", "");
                        this.showF7Value(cell.getRow(), cell.getCol(), mem, invoker);
                        invoker.updataValue(cell.getRow(), cell.getCol(), null);
                    }
                } else if (sign.startsWith("_enum_")) {
                    ComputeOprtEnum c = ComputeOprtEnum.getEnumByName((String)inputString);
                    if (c != null) {
                        invoker.updataValue(cell.getRow(), cell.getCol(), c.getName());
                        cell.setValue((Object)c.getIndex());
                        this.setCellChange(cell);
                    } else {
                        cell.clearMembersOfUserObject();
                        cell.setValue(null);
                        this.setCellChange(cell);
                        invoker.updataValue(cell.getRow(), cell.getCol(), null);
                    }
                }
            }
            invoker.startToInvoke();
            this.cacheSpreadModel(this.getSpreadModel());
            this.setModified(true);
        });
    }

    private boolean dimHavePerm(IDNumberTreeNode dim, String[] entitySigns) {
        Long modelId = (Long)this.getFormCustomParam("model");
        PermissionService permissionService = PermissionServiceImpl.getInstance((Long)modelId);
        Long memberId = dim.getId();
        long dimensionId = Long.parseLong(entitySigns[2]);
        return !permissionService.hasNoPerm(Long.valueOf(dimensionId), memberId);
    }

    private boolean dimCanBeFind(IDNumberTreeNode dim) {
        return dim != null && kd.bos.util.StringUtils.isNotEmpty((String)dim.getNumber()) && dim.getId() != -1L;
    }

    private <T> T numberAndLeafCondition(String entity, boolean isTarget, Function<List<String>, T> numberResult, Supplier<T> leafResult, Supplier<T> defaultResult) {
        if (SysDimensionEnum.Currency.getMemberTreemodel().equals(entity)) {
            return numberResult.apply(Collections.singletonList("DC"));
        }
        if (isTarget) {
            if (SysDimensionEnum.Process.getMemberTreemodel().equals(entity)) {
                String number = this.targetProcessCheckable();
                return numberResult.apply(Collections.singletonList(number));
            }
            if (SysDimensionEnum.AuditTrail.getMemberTreemodel().equals(entity)) {
                return numberResult.apply(AUDIT_TRAIL);
            }
            return leafResult.get();
        }
        if (this.getModel().getValue("chargeagainst").equals("1") && SysDimensionEnum.Process.getMemberTreemodel().equals(entity)) {
            return numberResult.apply(InvestConstant.INV_CHANGE_CASE_SRCDIM_CHARGEAGAINST_PROCESS);
        }
        return defaultResult.get();
    }

    private void setCombo() {
        ComboEdit comboEdit = (ComboEdit)this.getControl("changetypeset");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(InvCaseChangeTypeEnum.values().length);
        for (InvCaseChangeTypeEnum invCaseChangeTypeEnum : InvCaseChangeTypeEnum.values()) {
            comboItems.add(new ComboItem(new LocaleString(invCaseChangeTypeEnum.getText()), invCaseChangeTypeEnum.getIndex()));
        }
        comboEdit.setComboItems(comboItems);
    }

    private void setModified(boolean isModified) {
        this.cacheTrueOrFalseFlag(IS_MODIFY, isModified);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (Arrays.asList("number", "name", "changetypeset", "description").contains(key)) {
            this.setModified(true);
        }
        ChangeData changeData = e.getChangeSet()[0];
        String status = (String)this.getModel().getValue("status");
        List defaultDims = Arrays.asList(this.defaultDim).stream().map(dim -> dim.toLowerCase(Locale.ENGLISH)).collect(Collectors.toList());
        if (defaultDims.contains(key)) {
            List<DynamicObject> entryObject = this.getPageEntryObject((Long)this.getModel().getValue("id"));
            String designDimStr = this.getDesignDimStr();
            this.cacheDimSize(designDimStr);
            this.buildSpread(designDimStr);
            this.buildSpreadRow(entryObject);
            this.setModified(true);
            int dimSize = Integer.parseInt(this.getPageCache().get(this.getFormCustomParam("model") + "dimsize"));
            if (kd.bos.util.StringUtils.isNotEmpty((String)status) && status.equals(CHKFormulaStatusEnum.enable.getIndex())) {
                SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
                invoker.lockCell(2, 0, 2000, dimSize + dimSize + 1);
            }
        } else if ("processcb".equals(key)) {
            String newvalue = changeData.getNewValue().toString();
            this.getModel().beginInit();
            if (newvalue == null || newvalue.length() <= 0) {
                this.getModel().setValue("processcb", changeData.getOldValue());
                return;
            }
            DynamicObject process = this.getProcess(this.getModelId(), InvCaseProcessEnum.getNumber((String)changeData.getNewValue().toString()));
            if (process != null) {
                this.getModel().setValue("processbase", (Object)process.getLong("id"));
                SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
                for (int row = 2; row < this.getSheet().getMaxRowCount(); ++row) {
                    Cell cell = this.getSheet().getCell(row, 1);
                    List memberFromUserObject = cell.getMemberFromUserObject();
                    if (!CollectionUtils.isNotEmpty((Collection)memberFromUserObject)) continue;
                    DimMember mem = this.setMembackToCell(cell, process.getString("name"), process.getString("number"), process.getLong("id"));
                    this.showF7Value(row, 1, mem, invoker);
                }
                invoker.startToInvoke();
            }
            this.getModel().endInit();
            this.cacheSpreadModel(this.spreadManager);
            this.setModified(true);
        } else if (SCENARIOSET.equals(key) && kd.bos.util.StringUtils.isBlank((String)((String)this.getModel().getValue(SCENARIOSET)))) {
            this.getPageCache().remove(SCENARIOSET);
        }
    }

    public DynamicObject getProcess(Long modelId, String ... processNumber) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        qfBuilder.add("number", "in", (Object)processNumber);
        return QueryServiceHelper.queryOne((String)"bcm_processmembertree", (String)"id,name,number", (QFilter[])qfBuilder.toArray());
    }

    protected boolean isModified() {
        return this.isTrueFlagInCache(IS_MODIFY);
    }

    @Override
    public void spreadF7LookUpData(LookUpDataArgs args) {
        int col = args.getC();
        String sign = this.getSignByCol(col);
        int dimsize = Integer.parseInt(this.getPageCache().get(this.getFormCustomParam("model") + "dimsize"));
        if (kd.bos.util.StringUtils.isNotEmpty((String)sign)) {
            if (sign.startsWith("_enum_")) {
                this.setEnumValues(args, sign);
            } else if (sign.startsWith("bcm")) {
                Long modelid = (Long)this.getFormCustomParam("model");
                String entity = sign.split("!")[0];
                String dimnum = sign.split("!")[1];
                QFilter qFilter = this.getMemberFilter(col, dimsize, entity);
                if (Objects.isNull(qFilter)) {
                    qFilter = new QFilter("1", "=", (Object)2);
                }
                qFilter.and("dimension.number", "=", (Object)dimnum);
                SpreadUtils.spreadF7lookUpData(this.getClientViewProxy(), this.getSpreadKey(), entity, dimnum, args, modelid, qFilter, null, null, null);
            }
        }
    }

    private QFilter getMemberFilter(int col, int dimsize, String entity) {
        boolean isExistsAT;
        QFilter qFilter = new QFilter("model", "=", this.getFormCustomParam("model"));
        qFilter.and("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
        if (SysDimensionEnum.Entity.getMemberTreemodel().equals(entity)) {
            qFilter.and("isexchangerate", "=", (Object)"0");
        }
        if (SysDimensionEnum.AuditTrail.getMemberTreemodel().equals(entity) && col <= dimsize && !(isExistsAT = QueryServiceHelper.exists((String)"bcm_audittrialmembertree", (QFilter[])new QFBuilder("number", "in", AUDIT_TRAIL).add(qFilter).toArray()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9700\u5728\u7ef4\u5ea6-\u5ba1\u8ba1\u7ebf\u7d22-\u8c03\u6574\u62b5\u9500\u4e0b\u8865\u5145\u5ba1\u8ba1\u7ebf\u7d22\u6210\u5458\uff0c\u7f16\u7801\u548c\u540d\u79f0\u5982\u4e0b\uff1aSca \u540c\u63a7\u65b0\u589e\u3001Scd \u540c\u63a7\u5904\u7f6e\u3001Nsca \u975e\u540c\u63a7\u65b0\u589e\u3001Nscd \u975e\u540c\u63a7\u5904\u7f6e\u3001CprP \u540c\u63a7\u5171\u540c\u7236\u7ea7\u53cd\u51b2\u5229\u6da6\u3001CprB \u540c\u63a7\u5171\u540c\u7236\u7ea7\u53cd\u51b2\u5e74\u521d\u3002", (String)"InvChangeDataCaseSettingPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return null;
        }
        QFilter numberOrLeafCondition = this.numberAndLeafCondition(entity, col <= dimsize, dimNumber -> new QFilter("number", "in", dimNumber), () -> new QFilter("isleaf", "=", (Object)Boolean.TRUE), () -> new QFilter("1", "=", (Object)1));
        qFilter.and(numberOrLeafCondition);
        return qFilter;
    }

    private String targetProcessCheckable() {
        String processcb = (String)this.getModel().getValue("processcb");
        return InvCaseProcessEnum.getNumber((String)processcb);
    }

    protected void setEnumValues(LookUpDataArgs args, String sign) {
        HashMap<String, Serializable> data = new HashMap<String, Serializable>(10);
        ArrayList arrs = new ArrayList(10);
        if ("_enum_computeoprt".equals(sign)) {
            for (ComputeOprtEnum co : ComputeOprtEnum.values()) {
                ArrayList<String> arr = new ArrayList<String>();
                arr.add(co.getIndex());
                arr.add(co.getNumber());
                arr.add(co.getName());
                arrs.add(arr);
            }
        }
        data.put("data", arrs);
        data.put("r", Integer.valueOf(args.getR()));
        data.put("c", Integer.valueOf(args.getC()));
        this.getClientViewProxy().invokeControlMethod(this.getSpreadKey(), "setLookupData", new Object[]{data});
    }

    public void setSpreadF7Item(F7ItemFillBackArgs arg) {
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
        Cell cell = this.getSheet().getCell(arg.getR(), arg.getC());
        String sign = this.getSignByCol(arg.getC());
        if (sign.startsWith("bcm")) {
            DimMember mem = this.setMembackToCell(cell, arg.getName(), arg.getNumber(), arg.getId());
            this.showF7Value(arg.getR(), arg.getC(), mem, invoker);
        } else if (sign.startsWith("_enum_")) {
            invoker.updataValue(arg.getR(), arg.getC(), arg.getName());
            cell.setValue((Object)arg.getId());
            this.setCellChange(cell);
        }
        this.setModified(true);
        invoker.startToInvoke();
        this.cacheSpreadModel(this.getSpreadManager());
    }

    protected String getSignByCol(int col) {
        if (this.colSignIndex == null) {
            this.colSignIndex = new HashMap<Integer, String>(10);
        }
        if (!this.colSignIndex.containsKey(col)) {
            Cell head = this.getHeader(col);
            if (head != null) {
                this.colSignIndex.put(col, head.getUserObject("entitysign").toString());
            } else {
                this.colSignIndex.put(col, null);
            }
        }
        return this.colSignIndex.get(col);
    }

    protected Cell getHeader(int col) {
        int maxrow = this.getSheet().getMaxRowCount();
        for (int i = 1; i < maxrow; ++i) {
            Cell cell = this.getSheet().getCell(i, col);
            if (cell.getUserObject("entitysign") == null) continue;
            return cell;
        }
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData;
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if ("cellF7".equals(key)) {
            Cell head = this.getHeader(this.getSpreadSelector().getStartCol());
            DynamicObject memberObject = (DynamicObject)closedCallBackEvent.getReturnData();
            if (memberObject == null) {
                this.getPageCache().remove("f7select");
                return;
            }
            int r = this.getF7SelectRow();
            int c = this.getF7SelectCol();
            this.getPageCache().remove("f7select");
            String entity = head.getUserObject("entitysign").toString().split("!")[0];
            IDNumberTreeNode node = MemberReader.findMemberById((long)this.getModelId(), (String)entity, (Long)memberObject.getLong("id"));
            if (node == IDNumberTreeNode.NotFoundTreeNode) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"%s\u4e0d\u5408\u6cd5\uff1b", (String)"AbstractMemMapSheetHandel_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), memberObject.getLong("id")));
                return;
            }
            SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
            invoker.setBatch(true);
            int leafrow = this.getSheet().getMaxRowCount() - r;
            int n = leafrow = leafrow >= 0 ? leafrow : 0;
            if (1 > leafrow) {
                this.insertRowFromInxdex(this.getSheet().getMaxRowCount(), 1 - leafrow);
            }
            Cell cell = this.getSheet().getCell(r, c);
            DimMember mem = this.setMembackToCell(cell, node.getName(), node.getNumber(), node.getId());
            this.showF7Value(r, c, mem, invoker);
            invoker.startToInvoke();
            this.cacheSpreadModel(this.spreadManager);
            this.setModified(true);
        } else if (ACCOUNTSCOOPE.equals(key)) {
            if (closedCallBackEvent.getReturnData() != null) {
                DynamicObjectCollection selectOrg = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
                if (selectOrg.isEmpty()) {
                    this.getModel().setValue(ACCOUNTSCOOPE, null);
                    this.getPageCache().remove(ACCOUNT_DIMENSION_SCOPE);
                } else {
                    SchemeContext schemeContext = new SchemeContext(this.getModelId());
                    DimensionScope ds = new DimensionScope(Long.toString(this.getModelId()), schemeContext.getDimensionByNumber(DimTypesEnum.ACCOUNT.getNumber()), selectOrg);
                    this.getModel().setValue(ACCOUNTSCOOPE, (Object)ds.toMultiPersonalString(MenuShowTypeEnum.NUMBERNDNAME));
                    this.getPageCache().put(ACCOUNT_DIMENSION_SCOPE, SerializationUtils.serializeToBase64((Object)ds));
                }
            }
        } else if (SCENARIOSET.equals(key) && Objects.nonNull(returnData = (Map)this.deSerializedBytes((String)closedCallBackEvent.getReturnData()))) {
            String name = (String)returnData.get("name");
            List items = (List)returnData.get("items");
            if (CollectionUtil.isEmpty((Collection)items)) {
                this.getModel().setValue(SCENARIOSET, null);
                this.getPageCache().remove(SCENARIOSET);
                this.getView().updateView(SCENARIOSET);
                return;
            }
            this.getModel().setValue(SCENARIOSET, (Object)name);
            this.getPageCache().put(SCENARIOSET, this.toByteSerialized(items));
        }
    }

    public void insertRowFromInxdex(int row, int num) {
        ArrayList<Integer> insertdata = new ArrayList<Integer>(num);
        for (int i = 0; i < num; ++i) {
            insertdata.add(row);
        }
        AskExcuteInfo excuteinfo = new AskExcuteInfo(0, RowColExcuteEnum.INSERTROW, insertdata);
        excuteinfo.setCon(true);
        SpreadDataModel.adjustSheet(excuteinfo, this.spreadManager);
        this.updateRowAndCol(excuteinfo);
    }

    protected DimMember setMembackToCell(Cell cell, String memname, String memnumber, long id) {
        cell.clearMembersOfUserObject();
        cell.setValue((Object)memnumber);
        DimMember mem = this.packMem(memname, memnumber, "", "");
        mem.setId(id);
        cell.addDim2UserObject((IDimMember)mem);
        this.setCellChange(cell);
        return mem;
    }

    protected void setCellChange(Cell cell) {
        cell.setChangeVal(true);
        int seqIndex = this.getSeqIndex();
        Cell seqCell = this.getSheet().getCell(cell.getRow(), seqIndex);
        seqCell.setUserObject("ischange", (Object)true);
        this.getSheet().putUserObject("change", (Object)true);
    }

    protected int getSeqIndex() {
        Object obj = this.getSheet().getUserObject("seqindex");
        if (obj != null) {
            return Integer.parseInt(obj.toString());
        }
        return 0;
    }

    protected DimMember packMem(String memname, String memnumber, String dimnum, String dimname) {
        Dimension dimension = new Dimension(dimname, dimnum, null);
        return new DimMember(memname, memnumber, null, (IDimension)dimension);
    }

    protected void showF7Value(int r, int c, DimMember mem, SpreadEasyInvoker invoker) {
        invoker.updataValue(r, c, this.getShowName(mem));
    }

    protected String getShowName(DimMember mem) {
        return this.getShowName(mem.getNumber(), mem.getName());
    }

    protected String getShowName(String number, String name) {
        return MapSheetUtil.getShowName(number, name);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        Long caseId = (Long)this.getModel().getValue("id");
        switch (key) {
            case "btn_save": {
                if (this.checkBeforeSave()) {
                    return;
                }
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("callback", "invokeAction");
                params.put("invokemethod", "actionSave");
                SpreadClientInvoker.invokeGetSpreadJsonMethod(this.getClientViewProxy(), this.getSpreadKey(), params);
                this.setModified(false);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"number", "changetypeset"});
                break;
            }
            case "btn_enable": {
                int is;
                if (!MemberPermHelper.ifUserHasRootPermByModel((long)this.getUserId(), (String)String.valueOf(this.getModelId())) && (is = BcmBasePluginUtil.checkPermission(this.getUserId(), this.getModelId(), AppMetadataCache.getAppInfo((String)this.getBizAppId()).getId(), "bcm_invchangesetting", "4730fc5d000000ac")) == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\u3002", (String)"PermissionClassFormPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                if (caseId == null || caseId == 0L || this.isModified()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5f53\u524d\u65b9\u6848\u3002", (String)"InvChangeDataCaseSettingPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.statusChange(CHKFormulaStatusEnum.enable.getIndex());
                break;
            }
            case "btn_disable": {
                int is;
                if (!MemberPermHelper.ifUserHasRootPermByModel((long)this.getUserId(), (String)String.valueOf(this.getModelId())) && (is = BcmBasePluginUtil.checkPermission(this.getUserId(), this.getModelId(), AppMetadataCache.getAppInfo((String)this.getBizAppId()).getId(), "bcm_invchangesetting", "47160c2b000000ac")) == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\u3002", (String)"PermissionClassFormPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                if (caseId == null || caseId == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5f53\u524d\u65b9\u6848\u3002", (String)"InvChangeDataCaseSettingPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.statusChange(CHKFormulaStatusEnum.disable.getIndex());
                break;
            }
            case "btn_refresh": {
                if (caseId == null || caseId == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5f53\u524d\u65b9\u6848\u3002", (String)"InvChangeDataCaseSettingPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                OpNameMultiLangEnumBridge opName = OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.REFRESH.getMultiLangEnumBridge(), (String)"refresh");
                this.writeOperationLog(opName, ResultStatusEnum.SUCCESS.getName());
                if (this.isModified()) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u53d1\u751f\u4e86\u6539\u53d8\uff0c\u672a\u4fdd\u5b58\u7684\u6570\u636e\u5c06\u4f1a\u4e22\u5931\uff0c\u786e\u5b9a\u5237\u65b0\u5417\uff1f", (String)"InvChangeDataCaseSettingPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("refresh_confirm", (IFormPlugin)this));
                    break;
                }
                this.initUserDefineNumber();
                this.initEditPage(caseId);
                String status = (String)this.getModel().getValue("status");
                int dimsize = Integer.parseInt(this.getPageCache().get(this.getFormCustomParam("model") + "dimsize"));
                if (status.equals(CHKFormulaStatusEnum.enable.getIndex())) {
                    SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
                    invoker.lockCell(2, 0, 2000, dimsize + dimsize + 1);
                }
                this.setModified(false);
                break;
            }
            case "btn_close": {
                if (this.isAddNewStatus()) {
                    if (this.isModified()) {
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u53d1\u751f\u4e86\u6539\u53d8\uff0c\u672a\u4fdd\u5b58\u7684\u6570\u636e\u5c06\u4f1a\u4e22\u5931\uff0c\u786e\u5b9a\u9000\u51fa\u5417\uff1f", (String)"InvChangeDataCaseSettingPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("close_confirm", (IFormPlugin)this));
                        break;
                    }
                    this.setModified(false);
                    this.getView().close();
                    break;
                }
                this.setModified(false);
                this.getView().close();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("refresh_confirm".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            Long caseId = (Long)this.getModel().getValue("id");
            this.initEditPage(caseId);
            String status = (String)this.getModel().getValue("status");
            int dimsize = Integer.parseInt(this.getPageCache().get(this.getFormCustomParam("model") + "dimsize"));
            if (status.equals(CHKFormulaStatusEnum.enable.getIndex())) {
                SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
                invoker.lockCell(2, 0, 2000, dimsize + dimsize + 1);
            }
            String designDimStr = this.getPageCache().get(this.getFormCustomParam("model") + "designdim");
            this.setEnableInfoByDesginDim(designDimStr);
            this.setModified(false);
        } else if ("close_confirm".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.setModified(false);
            this.getView().close();
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.isModified()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u53d1\u751f\u4e86\u6539\u53d8\uff0c\u672a\u4fdd\u5b58\u7684\u6570\u636e\u5c06\u4f1a\u4e22\u5931\uff0c\u786e\u5b9a\u9000\u51fa\u5417\uff1f", (String)"InvChangeDataCaseSettingPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("close_confirm", (IFormPlugin)this));
            e.setCancel(true);
        }
    }

    private boolean checkBeforeSave() {
        if (this.getSheet().getMaxRowCount() == 2) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u586b\u5199\u4e00\u6761\u7ef4\u5ea6\u6620\u5c04\u8bb0\u5f55\u3002", (String)"InvChangeDataCaseSettingPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return true;
        }
        String number = (String)this.getModel().getValue("number");
        if (kd.bos.util.StringUtils.isNotEmpty((String)number) && !BCMNumberRule.checkNumber((String)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"InvChangeDataCaseSettingPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return true;
        }
        Long thisId = (Long)this.getModel().getValue("id");
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        filter.and("number", "=", (Object)number);
        filter.and("id", "!=", (Object)thisId);
        boolean isSameCase = QueryServiceHelper.exists((String)"bcm_invchangecaseentity", (QFilter[])filter.toArray());
        if (isSameCase) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ISSchemeEditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return true;
        }
        String value = (String)this.getModel().getValue(ACCOUNTSCOOPE);
        if (kd.bos.util.StringUtils.isNotEmpty((String)value) && ((Boolean)this.getModel().getValue("account")).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u79d1\u76ee\u6761\u4ef6\u7ef4\u5ea6\u4e0e\u79d1\u76ee\u6307\u5b9a\u7ef4\u5ea6\u8bf7\u9009\u62e9\u4e00\u79cd\u65b9\u5f0f\u914d\u7f6e\u3002", (String)"InvChangeDataCaseSettingPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return true;
        }
        int dimsize = Integer.parseInt(this.getPageCache().get(this.getFormCustomParam("model") + "dimsize"));
        boolean allEmpty = true;
        for (int row = 2; row < this.getSheet().getMaxRowCount(); ++row) {
            boolean isAllEmpty = this.isAllEmpty(dimsize, row);
            if (isAllEmpty) continue;
            allEmpty = false;
            for (int i = 0; i < dimsize; ++i) {
                Cell tempCell = this.getSheet().getCell(row, i);
                if (tempCell.getValue() != null) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7b2c%2$s\u5217\uff0c\u8bf7\u586b\u5199\u5b8c\u6574\u3002", (String)"InvChangeDataCaseSettingPlugin_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]), row + 1, i + 1));
                return true;
            }
            Cell calculateCell = this.getSheet().getCell(row, dimsize);
            if (calculateCell.getValue() != null && !BigDecimal.ZERO.equals(calculateCell.getValue())) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7b2c%s\u884c\u8ba1\u7b97\u5173\u7cfb\u3002", (String)"InvChangeDataCaseSettingPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), row + 1));
            return true;
        }
        if (allEmpty) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u586b\u5199\u4e00\u6761\u7ef4\u5ea6\u6620\u5c04\u8bb0\u5f55\u3002", (String)"InvChangeDataCaseSettingPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean isAllEmpty(int dimsize, int row) {
        boolean isAllEmpty = true;
        for (int i = 0; i < dimsize << 1; ++i) {
            Cell tempCell = this.getSheet().getCell(row, i);
            if (ObjectUtils.isEmpty((Object)tempCell.getValue())) continue;
            isAllEmpty = false;
            break;
        }
        return isAllEmpty;
    }

    private void statusChange(String status) {
        OpItemEnum statusName;
        int dimsize = Integer.parseInt(this.getPageCache().get(this.getFormCustomParam("model") + "dimsize"));
        Long caseId = (Long)this.getModel().getValue("id");
        DynamicObject thisCase = BusinessDataServiceHelper.loadSingle((Object)caseId, (String)"bcm_invchangecaseentity");
        if (status.equals(CHKFormulaStatusEnum.enable.getIndex())) {
            InvChangeCaseService caseService = new InvChangeCaseService(thisCase.getDynamicObject("model").getLong("id"));
            StringJoiner checkResult = caseService.enableCheck((Collection)Sets.newHashSet((Object[])new DynamicObject[]{thisCase}));
            if (checkResult.length() > 0) {
                this.getView().showTipNotification(checkResult.toString());
                return;
            }
            statusName = OpItemEnum.ENABLE;
            this.writeOperationLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)statusName.getMultiLangEnumBridge(), (String)"Enable"), (String)this.getModel().getValue("number"), this.getModel().getValue("name").toString(), ResultStatusEnum.SUCCESS.getName());
            SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
            invoker.lockCell(2, 0, 2000, dimsize + dimsize + 1);
        } else {
            statusName = OpItemEnum.DISABLE;
            this.writeOperationLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)statusName.getMultiLangEnumBridge(), (String)"Disable"), (String)this.getModel().getValue("number"), this.getModel().getValue("name").toString(), ResultStatusEnum.SUCCESS.getName());
            SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
            invoker.unlockCell(2, 0, 2000, dimsize + dimsize + 1);
        }
        this.setEnableInfoByStatus(status);
        thisCase.set("status", (Object)status);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{thisCase});
        this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"InvChangeDataCaseSettingPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]), statusName.getMultiLangEnumBridge().loadKDString()));
        this.getModel().setValue("status", (Object)status);
    }

    public void actionSave(String spreadJson) {
        SpreadManager spreadModel = this.getSpreadModel();
        spreadModel.setFilter(null);
        String serial = this.toByteSerialized(spreadModel);
        Long exitsid = (Long)this.getModel().getValue("id");
        Long caseId = exitsid == null || exitsid == 0L ? Long.valueOf(GlobalIdUtil.genGlobalLongId()) : exitsid;
        Boolean isUpdate = exitsid == null || exitsid == 0L ? Boolean.FALSE : Boolean.TRUE;
        DynamicObject caseObject = this.getCaseObject(caseId, isUpdate, spreadJson, serial);
        DeleteServiceHelper.delete((String)"bcm_invchangecaseentry", (QFilter[])new QFilter[]{new QFilter("invchangecase", "=", (Object)caseId)});
        int dimsize = Integer.parseInt(this.getPageCache().get(this.getFormCustomParam("model") + "dimsize"));
        ResultBox resultBox = this.getEntryObject(caseObject, dimsize);
        if (!resultBox.isSuccess()) {
            this.getView().showTipNotification(resultBox.getMessageText());
            return;
        }
        List entryObject = (List)resultBox.getData();
        if (isUpdate.booleanValue()) {
            this.writeOperationLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.SAVE.getMultiLangEnumBridge(), (String)"Save"), caseObject.getString("number"), caseObject.getString("name"), ResultStatusEnum.SUCCESS.getName());
        } else {
            this.writeOperationLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.ADD.getMultiLangEnumBridge(), (String)"Add"), caseObject.getString("number"), caseObject.getString("name"), ResultStatusEnum.SUCCESS.getName());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{caseObject});
        SaveServiceHelper.save((DynamicObject[])entryObject.toArray(new DynamicObject[0]));
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        PermClassEntityHelper.savePermClassAndLog((DynamicObject)caseObject, (Long)model.getLong("id"), (String)this.getBizAppId(), (DataPermLogMultiLangEnum)DataPermLogMultiLangEnum.INV_CHANGE_DATA_CASE_SETTING);
        this.getModel().setValue("id", (Object)caseId);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"InvChangeDataCaseSettingPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private ResultBox getEntryObject(DynamicObject caseObject, int dimsize) {
        ResultBox resultBox = ResultBox.of();
        ArrayList<DynamicObject> entry = new ArrayList<DynamicObject>(10);
        for (int row = 2; row < this.getSheet().getMaxRowCount(); ++row) {
            boolean isAllEmpty = this.isAllEmpty(dimsize, row);
            if (isAllEmpty) continue;
            Long caseId = caseObject.getLong("id");
            boolean isChargeagainst = caseObject.getString("chargeagainst").equals("1");
            long processId = caseObject.getLong("process.id");
            DynamicObject tempObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_invchangecaseentry");
            DynamicObjectCollection tempObjectEntry = tempObject.getDynamicObjectCollection("issinglemapentry");
            tempObject.set("model", this.getModel().getValue("model"));
            tempObject.set("invchangecase", (Object)caseId);
            tempObject.set("sort", (Object)row);
            Cell computetype = this.getSheet().getCell(row, dimsize);
            tempObject.set("computetype", computetype.getValue());
            for (int i = 0; i < dimsize; ++i) {
                DynamicObject tempEntry = tempObjectEntry.addNew();
                Cell cell = this.getSheet().getCell(row, i);
                Cell dimcell = this.getSheet().getCell(1, i);
                List memberFromUserObject = cell.getMemberFromUserObject();
                if (CollectionUtils.isEmpty((Collection)memberFromUserObject)) continue;
                Long memberId = ((IDimMember)memberFromUserObject.get(0)).getId();
                String memberNumber = ((IDimMember)memberFromUserObject.get(0)).getNumber();
                String[] dimInfo = dimcell.getUserObject("entitysign").toString().split("!");
                Long dimId = Long.valueOf(dimInfo[2]);
                String dimNumber = dimInfo[1];
                if (dimNumber.equals(DimTypesEnum.PROCESS.getNumber()) && memberId != processId) {
                    resultBox.add(ResManager.loadKDString((String)"\u5206\u5f55\u884c\u76ee\u6807\u8fc7\u7a0b\u4e0e\u65b9\u6848\u8fc7\u7a0b\u914d\u7f6e\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"InvChangeDataCaseSettingPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return resultBox;
                }
                tempEntry.set("membid", (Object)memberId);
                tempEntry.set("dimid", (Object)dimId);
                tempEntry.set("dimnumber", (Object)dimNumber);
                tempEntry.set("memnumber", (Object)memberNumber);
                tempEntry.set("issrc", (Object)Boolean.FALSE);
                Cell sourceCell = this.getSheet().getCell(row, i + dimsize + 1);
                if (sourceCell == null || sourceCell.getValue() == null) continue;
                DynamicObject sourceTempEntry = tempObjectEntry.addNew();
                Cell sourceDimCell = this.getSheet().getCell(1, i + dimsize + 1);
                Long sourceMemberId = ((IDimMember)sourceCell.getMemberFromUserObject().get(0)).getId();
                String sourceMemberNumber = ((IDimMember)sourceCell.getMemberFromUserObject().get(0)).getNumber();
                String[] sourceDimInfo = sourceDimCell.getUserObject("entitysign").toString().split("!");
                Long sourceDimId = Long.valueOf(sourceDimInfo[2]);
                String sourceDimNumber = sourceDimInfo[1];
                if (sourceDimNumber.equals(DimTypesEnum.PROCESS.getNumber()) && isChargeagainst && !InvestConstant.INV_CHANGE_CASE_SRCDIM_CHARGEAGAINST_PROCESS.contains(sourceMemberNumber)) {
                    resultBox.add(ResManager.loadKDString((String)"\u62b5\u6d88\u7c7b\u578b\u65b9\u6848\uff0c\u5206\u5f55\u884c\u6e90\u8fc7\u7a0b\u53ea\u80fd\u9009\u62e9Rpt\u4ee5\u4e0b\u8fc7\u7a0b,\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"InvChangeDataCaseSettingPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return resultBox;
                }
                sourceTempEntry.set("membid", (Object)sourceMemberId);
                sourceTempEntry.set("dimid", (Object)sourceDimId);
                sourceTempEntry.set("dimnumber", (Object)sourceDimNumber);
                sourceTempEntry.set("memnumber", (Object)sourceMemberNumber);
                sourceTempEntry.set("issrc", (Object)Boolean.TRUE);
            }
            entry.add(tempObject);
        }
        resultBox.setData(entry);
        return resultBox;
    }

    private List<DynamicObject> getPageEntryObject(Long caseId) {
        ArrayList<DynamicObject> entry = new ArrayList<DynamicObject>(10);
        int dimsize = Integer.parseInt(this.getPageCache().get(this.getFormCustomParam("model") + "dimsize"));
        for (int row = 2; row < this.getSheet().getMaxRowCount(); ++row) {
            boolean isAllEmpty = this.isAllEmpty(dimsize, row);
            if (isAllEmpty) continue;
            DynamicObject tempObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_invchangecaseentry");
            DynamicObjectCollection tempObjectEntry = tempObject.getDynamicObjectCollection("issinglemapentry");
            tempObject.set("invchangecase", (Object)caseId);
            tempObject.set("sort", (Object)row);
            Cell computetype = this.getSheet().getCell(row, dimsize);
            tempObject.set("computetype", computetype.getValue());
            for (int i = 0; i < dimsize; ++i) {
                Cell cell = this.getSheet().getCell(row, i);
                Cell dimcell = this.getSheet().getCell(1, i);
                List memberFromUserObject = cell.getMemberFromUserObject();
                if (CollectionUtils.isEmpty((Collection)memberFromUserObject)) continue;
                Long memberId = ((IDimMember)memberFromUserObject.get(0)).getId();
                String memberNumber = ((IDimMember)memberFromUserObject.get(0)).getNumber();
                String[] dimInfo = dimcell.getUserObject("entitysign").toString().split("!");
                Long dimId = Long.valueOf(dimInfo[2]);
                String dimNumber = dimInfo[1];
                DynamicObject tempEntry = tempObjectEntry.addNew();
                tempEntry.set("membid", (Object)memberId);
                tempEntry.set("dimid", (Object)dimId);
                tempEntry.set("dimnumber", (Object)dimNumber);
                tempEntry.set("memnumber", (Object)memberNumber);
                tempEntry.set("issrc", (Object)Boolean.FALSE);
                Cell sourceCell = this.getSheet().getCell(row, i + dimsize + 1);
                List sourcememberFromUserObject = sourceCell.getMemberFromUserObject();
                if (CollectionUtils.isEmpty((Collection)sourcememberFromUserObject)) continue;
                Cell sourceDimCell = this.getSheet().getCell(1, i + dimsize + 1);
                Long sourceMemberId = ((IDimMember)sourcememberFromUserObject.get(0)).getId();
                String sourceMemberNumber = ((IDimMember)sourcememberFromUserObject.get(0)).getNumber();
                String[] sourceDimInfo = sourceDimCell.getUserObject("entitysign").toString().split("!");
                Long sourceDimId = Long.valueOf(sourceDimInfo[2]);
                String sourceDimNumber = sourceDimInfo[1];
                DynamicObject sourceTempEntry = tempObjectEntry.addNew();
                sourceTempEntry.set("membid", (Object)sourceMemberId);
                sourceTempEntry.set("dimid", (Object)sourceDimId);
                sourceTempEntry.set("dimnumber", (Object)sourceDimNumber);
                sourceTempEntry.set("memnumber", (Object)sourceMemberNumber);
                sourceTempEntry.set("issrc", (Object)Boolean.TRUE);
            }
            entry.add(tempObject);
        }
        return entry;
    }

    private DynamicObject getCaseObject(Long caseId, boolean isUpdate, String spreadJson, String serial) {
        DynamicObject caseObject;
        if (isUpdate) {
            caseObject = BusinessDataServiceHelper.loadSingle((Object)caseId, (String)"bcm_invchangecaseentity");
        } else {
            caseObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_invchangecaseentity");
            caseObject.set("id", (Object)caseId);
            caseObject.set("creater", (Object)RequestContext.get().getCurrUserId());
            caseObject.set("createdate", (Object)TimeServiceHelper.now());
        }
        caseObject.set("number", this.getModel().getValue("number"));
        caseObject.set("name", this.getModel().getValue("name"));
        caseObject.set("description", this.getModel().getValue("description"));
        caseObject.set("changetype", this.getModel().getValue("changetypeset"));
        caseObject.set("chargeagainst", this.getModel().getValue("chargeagainst"));
        caseObject.set("spreadjson", (Object)spreadJson);
        caseObject.set("data", (Object)serial);
        caseObject.set("status", this.getModel().getValue("status"));
        caseObject.set("templatecatalog", this.getModel().getValue("templatecatalog"));
        caseObject.set("designdim", (Object)this.getDesignDimStr());
        caseObject.set("model", this.getModel().getValue("model"));
        String scenarioset = (String)this.getModel().getValue(SCENARIOSET);
        if (kd.bos.util.StringUtils.isNotEmpty((String)scenarioset)) {
            DynamicObjectCollection scenarios = this.scenariosToDyCollection();
            caseObject.set(SCENARIOS, (Object)scenarios);
        }
        caseObject.set("process", this.getModel().getValue("processbase"));
        caseObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
        caseObject.set("modifydate", (Object)TimeServiceHelper.now());
        String value = (String)this.getModel().getValue(ACCOUNTSCOOPE);
        if (kd.fi.bcm.fel.common.StringUtils.isNotEmpty((CharSequence)value)) {
            DynamicObjectCollection dimscopes = this.dimScopeToDyCollection();
            caseObject.set("dimscope", (Object)dimscopes);
        } else {
            caseObject.getDynamicObjectCollection("dimscope").clear();
            this.getPageCache().remove(ACCOUNT_DIMENSION_SCOPE);
        }
        caseObject.set("permclass", this.getModel().getValue("permclass"));
        return caseObject;
    }

    private DynamicObjectCollection dimScopeToDyCollection() {
        DimensionScope dimensionScope = this.getAccountDimensionScope();
        DynamicObjectCollection dimscopes = BusinessDataServiceHelper.newDynamicObject((String)"bcm_invchangecaseentity").getDynamicObjectCollection("dimscope");
        if (dimensionScope != null) {
            List dimensionMembers = dimensionScope.getDimensionMembers();
            for (int i = 0; i < dimensionMembers.size(); ++i) {
                AbstractDimensionMember dimensionMember = (AbstractDimensionMember)dimensionMembers.get(i);
                DynamicObject dimscope = new DynamicObject(dimscopes.getDynamicObjectType());
                dimscope.set("dimension", (Object)dimensionMember.getDimension().getId());
                dimscope.set("memberid", (Object)dimensionMember.getId());
                dimscope.set("scope", (Object)dimensionMember.getScope());
                dimscopes.add((Object)dimscope);
            }
        }
        return dimscopes;
    }

    private DynamicObjectCollection scenariosToDyCollection() {
        String scenarioset = this.getPageCache().get(SCENARIOSET);
        List selecteditems = (List)this.deSerializedBytes(scenarioset);
        DynamicObjectCollection scenarios = BusinessDataServiceHelper.newDynamicObject((String)"bcm_invchangecaseentity").getDynamicObjectCollection(SCENARIOS);
        if (CollectionUtils.isNotEmpty((Collection)selecteditems)) {
            for (int i = 0; i < selecteditems.size(); ++i) {
                Map item = (Map)selecteditems.get(i);
                DynamicObject scenario = new DynamicObject(scenarios.getDynamicObjectType());
                scenario.set("scenariomeb_id", (Object)((Long)item.get("id")));
                scenario.set("scenarioscope", (Object)((String)item.get("scope")));
                scenario.set("isexcept", (Object)((String)item.get("isexcept")));
                scenarios.add((Object)scenario);
            }
        }
        return scenarios;
    }

    private String getDesignDimStr() {
        StringBuilder designDim = new StringBuilder();
        designDim.append((Boolean)this.getModel().getValue("currency") != false ? 1 : 0);
        designDim.append((Boolean)this.getModel().getValue("process") != false ? 1 : 0);
        designDim.append((Boolean)this.getModel().getValue("audittrail") != false ? 1 : 0);
        designDim.append((Boolean)this.getModel().getValue("account") != false ? 1 : 0);
        designDim.append((Boolean)this.getModel().getValue("changetype") != false ? 1 : 0);
        designDim.append((Boolean)this.getModel().getValue("mycompany") != false ? 1 : 0);
        designDim.append((Boolean)this.getModel().getValue("internalcompany") != false ? 1 : 0);
        designDim.append((Boolean)this.getModel().getValue("multigaap") != false ? 1 : 0);
        designDim.append((Boolean)this.getModel().getValue("datasort") != false ? 1 : 0);
        designDim.append((Boolean)this.getModel().getValue("userdefine1") != false ? 1 : 0);
        designDim.append((Boolean)this.getModel().getValue("userdefine2") != false ? 1 : 0);
        designDim.append((Boolean)this.getModel().getValue("userdefine3") != false ? 1 : 0);
        designDim.append((Boolean)this.getModel().getValue("userdefine4") != false ? 1 : 0);
        designDim.append((Boolean)this.getModel().getValue("userdefine5") != false ? 1 : 0);
        designDim.append((Boolean)this.getModel().getValue("userdefine6") != false ? 1 : 0);
        return designDim.toString();
    }

    private static /* synthetic */ void lambda$null$9(String modelNum, String[] split, DimMember dimMember) {
        String number = dimMember.getNumber();
        IDNumberTreeNode member = MemberReader.findMemberByNumber((String)modelNum, (String)split[1], (String)number);
        dimMember.setId(member.getId().longValue());
    }
}

