/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest.multi;

import kd.bos.form.IPageCache;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.invest.multi.SheetDataProvider;
import kd.fi.bcm.formplugin.invest.multi.SheetTabInfo;
import kd.fi.bcm.formplugin.invest.multi.SheetTabManager;
import kd.fi.bcm.formplugin.invest.multi.SheetTabModel;

public class SheetCacheService {
    private IPageCache cache;
    private static final String KEY_TAB_MANAGER = "KEY_TAB_MANAGER";

    public SheetCacheService(IPageCache cache) {
        this.cache = cache;
    }

    public SheetTabModel getReportTabModel(SheetTabInfo tab) {
        SheetTabModel ci;
        String serial = this.cache.get(tab.getTabKey());
        if (StringUtils.isNotEmpty((String)serial)) {
            ci = (SheetTabModel)ObjectSerialUtil.deSerializedBytes((String)serial);
            ci.setPageCache(this.cache);
        } else {
            ci = this.queryAndCache(tab);
        }
        return ci;
    }

    public SheetTabModel getReportModelByForce(SheetTabInfo tab) {
        return this.queryAndCache(tab);
    }

    public SheetTabModel queryAndCache(SheetTabInfo tab) {
        SheetTabModel ci = new SheetDataProvider().query4Cache(tab, this.cache);
        this.cacheReportTabModel(ci);
        return ci;
    }

    public void cacheReportTabModel(SheetTabModel item) {
        item.cache();
    }

    public void cacheReportTabInfoManager(SheetTabManager manager) {
        this.cache.put(KEY_TAB_MANAGER, ObjectSerialUtil.toByteSerialized((Object)manager));
    }

    public SheetTabManager getReportTabInfoManager() {
        String serial = this.cache.get(KEY_TAB_MANAGER);
        if (StringUtils.isNotEmpty((String)serial)) {
            return (SheetTabManager)ObjectSerialUtil.deSerializedBytes((String)serial);
        }
        return null;
    }

    public void release(String ... cacheKeys) {
        for (String k : cacheKeys) {
            this.cache.remove(k);
        }
    }
}

