/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest.multi;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.fi.bcm.common.util.ToStringHelper;
import kd.fi.bcm.formplugin.invest.multi.SheetModelTypeEnum;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class SheetTabInfo
implements Serializable {
    private static final long serialVersionUID = -8065859910169822267L;
    private String tabKey;
    private String tabName;
    private Object reportId;
    private Object templateId;
    private SheetModelTypeEnum modelType = SheetModelTypeEnum.TEMPLATE;
    private boolean isSelected = false;
    private Map<String, Map<String, Object>> pageViewFilterCache = new HashMap<String, Map<String, Object>>();
    private Map<String, Map<String, Object>> commonParams = new HashMap<String, Map<String, Object>>();
    private Map<String, Object> reportListRecordInfo = null;
    private boolean isReportListRecordModified = false;

    public SheetTabInfo(String tabKey, String tabName, Object reportId, Object templateId) {
        this.tabKey = tabKey;
        this.tabName = tabName;
        this.reportId = reportId;
        this.templateId = templateId;
    }

    public SheetTabInfo(String tabKey, String tabName, Object reportId, Object templateId, SheetModelTypeEnum modelType) {
        this(tabKey, tabName, reportId, templateId);
        this.modelType = modelType;
    }

    public void putFilter(String key, Map<String, Object> value) {
        this.pageViewFilterCache.put(key, value);
    }

    public void removeFilter(String key) {
        this.pageViewFilterCache.remove(key);
    }

    public void putCommonParam(String key, Map<String, Object> value) {
        this.commonParams.put(key, value);
    }

    public Map<String, Object> getCommonParamByKey(String key) {
        return this.commonParams.get(key);
    }

    public Iterator<Map.Entry<String, Map<String, Object>>> filterIterator() {
        return this.pageViewFilterCache.entrySet().iterator();
    }

    public boolean containsFilterKey(String key) {
        return this.pageViewFilterCache.containsKey(key);
    }

    public Map<String, Object> getFilterVal(String key) {
        return this.pageViewFilterCache.get(key);
    }

    public String getTabName() {
        return this.tabName;
    }

    public void setTabName(String tabName) {
        this.tabName = tabName;
    }

    public String getTabKey() {
        return this.tabKey;
    }

    public Object getReportId() {
        return this.reportId;
    }

    public void setReportId(Object reportId) {
        this.reportId = reportId;
    }

    public SheetModelTypeEnum getModelType() {
        return this.modelType;
    }

    public Object getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(Object templateId) {
        this.templateId = templateId;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public String toString() {
        return ToStringHelper.reflectionToString((Object)this);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.tabKey).toHashCode();
    }

    public boolean equals(Object obj) {
        boolean isEquals = false;
        if (obj instanceof SheetTabInfo) {
            SheetTabInfo o = (SheetTabInfo)obj;
            isEquals = new EqualsBuilder().append((Object)this.tabKey, (Object)o.getTabKey()).isEquals();
        }
        return isEquals;
    }

    public void setReportListStatus(String status) {
        this.setReportListInfo("reportstatus", status);
    }

    public void setReportListModifier(Long userId) {
        this.setReportListInfo("modifier", userId);
    }

    public void setReportListId(Long rptListId) {
        this.getListRecordInfo().put("id", rptListId);
    }

    public void setReportListModifytime(Date modifytime) {
        this.setReportListInfo("modifytime", modifytime);
    }

    public void setReportListInfo(String key, Object v) {
        if (this.reportListRecordInfo == null || !this.reportListRecordInfo.containsKey("id")) {
            return;
        }
        this.getListRecordInfo().put(key, v);
        this.isReportListRecordModified = true;
    }

    public void setReportListRptId(Object v) {
        this.setReportListInfo("report", v);
    }

    public Map<String, Object> getListRecordInfo() {
        if (this.reportListRecordInfo == null) {
            this.reportListRecordInfo = new HashMap<String, Object>();
        }
        return this.reportListRecordInfo;
    }

    public boolean isModifiedReportListRecord() {
        return this.isReportListRecordModified;
    }

    public boolean hasPageFilterCache() {
        if (this.pageViewFilterCache.isEmpty()) {
            return false;
        }
        return this.pageViewFilterCache.size() != 1 || !this.pageViewFilterCache.containsKey("bcm_entitymembertree");
    }
}

