/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest.multi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.fi.bcm.formplugin.invest.multi.SheetTabInfo;

public class SheetTabManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<SheetTabInfo> tabs = new ArrayList<SheetTabInfo>();

    public boolean addReportTabInfo(SheetTabInfo tab) {
        if (this.tabs.contains(tab)) {
            return false;
        }
        return this.tabs.add(tab);
    }

    public boolean addReportTabInfo4List(SheetTabInfo tab) {
        String[] splitArr = tab.getTabKey().split("\\|");
        if (splitArr.length >= 2) {
            boolean hasExists = this.tabs.stream().anyMatch(e -> {
                String[] splitArr1 = e.getTabKey().split("\\|");
                return splitArr1[0].equals(splitArr[0]) && splitArr1[1].equals(splitArr[1]);
            });
            if (!hasExists) {
                this.tabs.add(tab);
            }
            return !hasExists;
        }
        return this.addReportTabInfo(tab);
    }

    public SheetTabInfo searchTab(String tabKey) {
        for (SheetTabInfo t : this.tabs) {
            if (!tabKey.equals(t.getTabKey())) continue;
            return t;
        }
        return null;
    }

    public void releaseAll() {
        this.tabs.clear();
    }

    public void releaseByKey(String key) {
        int index = -1;
        for (int i = 0; i < this.tabs.size(); ++i) {
            SheetTabInfo tab = this.tabs.get(i);
            if (!tab.getTabKey().equals(key)) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            this.tabs.remove(index);
        }
    }

    public String getLastTabKey(String key) {
        for (int i = this.tabs.size() - 1; i >= 0; --i) {
            SheetTabInfo tab = this.tabs.get(i);
            String currentKey = tab.getTabKey();
            if (tab.getTabKey().equals(key)) continue;
            return currentKey;
        }
        return null;
    }

    public Iterator<SheetTabInfo> iterator() {
        return this.tabs.iterator();
    }

    public int getTabCount() {
        return this.tabs.size();
    }

    public void setSelectReportTabInfo(String tabKey) {
        this.tabs.forEach(e -> e.setSelected(e.getTabKey().equals(tabKey)));
    }

    public SheetTabInfo getCurrSelectReportTabInfo() {
        for (SheetTabInfo tab : this.tabs) {
            if (!tab.isSelected()) continue;
            return tab;
        }
        return null;
    }

    public SheetTabInfo getFirstReportTabInfo() {
        return this.tabs.size() > 0 ? this.tabs.get(0) : null;
    }

    public SheetTabInfo searchTabByTemplateId(Object templateId) {
        if (templateId != null) {
            for (SheetTabInfo tab : this.tabs) {
                if (!templateId.equals(tab.getTemplateId())) continue;
                return tab;
            }
        }
        return this.getFirstReportTabInfo();
    }

    public List<SheetTabInfo> getTabs() {
        return this.tabs;
    }
}

