/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest.multi;

import java.io.Serializable;
import kd.bos.cache.ThreadCache;
import kd.bos.form.IPageCache;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;

public class SheetTabModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SPREAD_SERIAL = "_spreadserial";
    public static final String SPREAD_JSON = "_spreadjson";
    public static final String ORI_SPREAD_SERIAL = "_ori_spreadserial";
    public static final String REPORT_TAB_MODEL = "report_tab_model";
    private transient SpreadManager sm;
    private transient TemplateModel templateModel;
    private String cacheKey;
    private String modelid;
    private String status;
    private String name;
    private transient String spreadJson;
    private transient String initSpreadModelSerial;
    private transient IPageCache cache;
    private transient boolean isOverWriteOriginalData = false;

    public SheetTabModel(String cacheKey, IPageCache cache) {
        this.cacheKey = cacheKey;
        this.cache = cache;
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public void setPageCache(IPageCache cache) {
        this.cache = cache;
    }

    public void setSpreadModel(SpreadManager sm) {
        this.sm = sm;
    }

    public String getModelid() {
        return this.modelid;
    }

    public void setModelid(String modelid) {
        this.modelid = modelid;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TemplateModel getTemplateModel() {
        return this.templateModel;
    }

    public void setTemplateModel(TemplateModel templateModel) {
        this.templateModel = templateModel;
    }

    public void setSpreadJson(String spreadJson) {
        this.spreadJson = spreadJson;
    }

    public void setSpreadJson(String spreadJson, SpreadManager spread) {
        this.spreadJson = spreadJson;
        this.setInitSpreadModelSerial(JsonSerializerUtil.toJson((SpreadManager)spread));
        this.isOverWriteOriginalData = true;
    }

    public void setSpreadJson(String spreadJson, String spread) {
        this.spreadJson = spreadJson;
        this.setInitSpreadModelSerial(spread);
        this.isOverWriteOriginalData = true;
    }

    public void initReportTabModel(String spreadJson, String spread, boolean isOverWriteOriginalData) {
        this.spreadJson = spreadJson;
        this.setInitSpreadModelSerial(spread);
        this.isOverWriteOriginalData = isOverWriteOriginalData;
        this.sm = JsonSerializerUtil.toSpreadManager((String)spread);
    }

    public void setInitSpreadModelSerial(String initSpreadModelSerial) {
        this.initSpreadModelSerial = initSpreadModelSerial;
    }

    public SpreadManager getSpreadModel() {
        if (this.sm == null) {
            String spreadSerial = this.cache.get(this.getCacheKey() + SPREAD_SERIAL);
            this.sm = spreadSerial != null ? JsonSerializerUtil.toSpreadManager((String)spreadSerial) : JsonSerializerUtil.toSpreadManager((String)this.getOriginalSpreadModelSerial());
        }
        return this.sm;
    }

    private String getOriginalSpreadModelSerial() {
        if (this.initSpreadModelSerial == null) {
            this.initSpreadModelSerial = this.cache.get(this.getCacheKey() + ORI_SPREAD_SERIAL);
        }
        return this.initSpreadModelSerial;
    }

    public String getSpreadJson() {
        if (this.spreadJson == null) {
            this.spreadJson = this.cache.get(this.getCacheKey() + SPREAD_JSON);
        }
        return this.spreadJson;
    }

    public void reInitSpreadModel() {
        SpreadManager initSm = JsonSerializerUtil.toSpreadManager((String)this.getOriginalSpreadModelSerial());
        initSm.setFilter(this.getSpreadModel().getFilter());
        this.sm = initSm;
    }

    public void cache() {
        ThreadCache.put((Object)(REPORT_TAB_MODEL + this.cacheKey), (Object)this);
        this.cache.put(this.getCacheKey(), ObjectSerialUtil.toByteSerialized((Object)this));
        if (this.isOverWriteOriginalData) {
            if (this.initSpreadModelSerial != null) {
                this.cache.put(this.getCacheKey() + ORI_SPREAD_SERIAL, this.initSpreadModelSerial);
            }
            if (this.spreadJson != null) {
                this.cache.put(this.getCacheKey() + SPREAD_JSON, this.spreadJson);
            }
        }
        if (this.sm != null) {
            this.cache.put(this.getCacheKey() + SPREAD_SERIAL, JsonSerializerUtil.toJson((SpreadManager)this.sm));
        }
    }

    public void lightCache() {
        this.cache.put(this.getCacheKey(), ObjectSerialUtil.toByteSerialized((Object)this));
    }
}

