/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest.sheet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.business.invest.InvElimTemplateService;
import kd.fi.bcm.common.constant.invest.invsheet.InvSheetConstant;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class InvGenerateSheetSetPlugin
extends AbstractBaseFormPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_ok");
        BasedataEdit invsheettemplate = (BasedataEdit)this.getControl("invsheettemplate");
        invsheettemplate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((String)"generateradio", (String)fieldKey)) {
            String key = (String)this.getModel().getValue("generateradio");
            if (InvSheetConstant.GenerateTypeEnum.INVEST_WAY.getCode().equals(key)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"invsheettemplate"});
            } else if (InvSheetConstant.GenerateTypeEnum.TEMPLATION_WAY.getCode().equals(key)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"invsheettemplate"});
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter params = this.getView().getFormShowParameter();
        IDataModel dataModel = this.getModel();
        dataModel.setValue("model", params.getCustomParam("model"));
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"invsheettemplate"});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_ok".equals(key)) {
            HashMap<String, Object> radios = new HashMap<String, Object>();
            if (this.getModel().getDataEntity().getDynamicObjectType().getProperties().containsKey((Object)"orgrangeradio")) {
                radios.put("orgrangeradio", this.getModel().getValue("orgrangeradio").toString());
            }
            if (this.getModel().getDataEntity().getDynamicObjectType().getProperties().containsKey((Object)"generateradio")) {
                radios.put("generateradio", this.getModel().getValue("generateradio").toString());
                if (InvSheetConstant.GenerateTypeEnum.TEMPLATION_WAY.getCode().equals(this.getModel().getValue("generateradio")) && CollectionUtils.isEmpty((Collection)((Collection)this.getModel().getValue("invsheettemplate")))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\uff01", (String)"ReCalculateFormPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                radios.put("invsheettemplate", this.getModel().getValue("invsheettemplate"));
            }
            this.getView().returnDataToParent(radios);
            this.getView().close();
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String key = beforeF7SelectEvent.getProperty().getName();
        if ("invsheettemplate".equals(key)) {
            DynamicObjectCollection templateColls = InvElimTemplateService.getTemplateColls((Long)this.getModelId());
            Set templateIds = templateColls.stream().map(tpl -> tpl.getLong("id")).collect(Collectors.toSet());
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
            qFilterList.add(new QFilter("model", "=", (Object)this.getModelId()));
            qFilterList.add(new QFilter("id", "in", templateIds));
            beforeF7SelectEvent.setCustomQFilters(qFilterList);
        }
    }
}

