/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest.sheet;

import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.fi.bcm.business.invest.sheet.InvLimSheetCopyFromService;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.invest.sheet.InvelimSheetListPlugin;

public class InvLimSheetCopyFromPlugin
extends AbstractBaseFormPlugin {
    private static final String COPY_CONFIRM = "copy_confirm";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setPageId(this.getInnerPageId());
        parameter.setFormId(this.getView().getFormShowParameter().getParentFormId());
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey("flexpanelap");
        parameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
        this.getView().showForm(parameter);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_copy");
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)"btn_copy", (CharSequence)key)) {
            if (this.validataPageDim()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u586b\u9879\u3002", (String)"InvLimSheetCopyFromPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            InvLimSheetCopyFromService invLimSheetCopyFromService = this.buildInvLimSheetCopyFromService();
            List msg = invLimSheetCopyFromService.copyValidate();
            if (!msg.isEmpty()) {
                this.getView().showTipNotification(String.join((CharSequence)"\n ", msg));
                return;
            }
            Pair pair = invLimSheetCopyFromService.getSrcAndTargetTipNumber();
            if (((StringJoiner)pair.p2).length() == 0) {
                Pair result = invLimSheetCopyFromService.doCopyAndReturn();
                this.getView().returnDataToParent((Object)result);
                this.getView().close();
            } else {
                String tip = ResManager.loadKDString((String)"\u590d\u5236\u5e95\u7a3f\u3010%1$s\u3011\uff0c\u5c06\u5220\u9664\u76ee\u6807\u671f\u95f4\u5e95\u7a3f\u3010%2$s\u3011\u53ca\u5bf9\u5e94\u7684\u5206\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"InvLimSheetCopyFromPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(String.format(tip, pair.p1, pair.p2), MessageBoxOptions.YesNo, new ConfirmCallBackListener(COPY_CONFIRM, (IFormPlugin)this));
            }
        }
    }

    private boolean validataPageDim() {
        IFormView parent = this.getView().getView(this.getInnerPageId());
        IDataModel dataModel = parent.getModel();
        DynamicObject yearDyn = (DynamicObject)dataModel.getValue("year");
        DynamicObject modelDyn = (DynamicObject)dataModel.getValue("model");
        DynamicObject periodDyn = (DynamicObject)dataModel.getValue("period");
        DynamicObject cslSchemeDyn = (DynamicObject)dataModel.getValue("cslscheme");
        DynamicObject sceneDyn = (DynamicObject)dataModel.getValue("scenario");
        return Objects.isNull(modelDyn) || Objects.isNull(yearDyn) || Objects.isNull(periodDyn) || Objects.isNull(cslSchemeDyn) || Objects.isNull(sceneDyn);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (COPY_CONFIRM.equals(callBackId) && MessageBoxResult.Yes.equals((Object)event.getResult())) {
            InvLimSheetCopyFromService invLimSheetCopyFromService = this.buildInvLimSheetCopyFromService();
            Pair result = invLimSheetCopyFromService.doCopyAndReturn();
            this.getView().returnDataToParent((Object)result);
            this.getView().close();
        }
    }

    private String getInnerPageId() {
        return String.format("%s_%s_%s", "copyFrom", this.getView().getPageId(), RequestContext.get().getCurrUserId());
    }

    private InvLimSheetCopyFromService buildInvLimSheetCopyFromService() {
        IFormView view = this.getView();
        IFormView parent = this.getView().getView(this.getInnerPageId());
        BillList billList = (BillList)parent.getControl("billlistap");
        ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
        Object[] selectIds = listSelectedRows.getPrimaryKeyValues();
        IDNumberTreeNode selectNode = InvelimSheetListPlugin.getSelectedEntity(parent, this.getModelId());
        FixedItem tarF7 = this.getTarFixedItem(view);
        FixedItem srcF7 = this.getSrcFixedItem(parent);
        return new InvLimSheetCopyFromService(selectIds, selectNode, tarF7, srcF7);
    }

    private FixedItem getTarFixedItem(IFormView view) {
        Long modelId = LongUtil.toLong((Object)view.getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        Object sceneId = view.getFormShowParameter().getCustomParam("bcm_scenemember");
        Object yearId = view.getFormShowParameter().getCustomParam("bcm_fymembertree");
        Object periodId = view.getFormShowParameter().getCustomParam("bcm_periodmembertree");
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        String modelShowNumber = MemberReader.findModelSNumberById((Object)modelId);
        IDNumberTreeNode sceneMember = MemberReader.findScenaMemberById((String)modelNumber, (Long)LongUtil.toLong((Object)sceneId));
        IDNumberTreeNode fyMember = MemberReader.findFyMemberById((String)modelNumber, (Long)LongUtil.toLong((Object)yearId));
        IDNumberTreeNode periodMember = MemberReader.findPeriodMemberById((String)modelNumber, (Long)LongUtil.toLong((Object)periodId));
        FixedItem tarF7 = FixedItem.newOne((SimpleItem)SimpleItem.newOne((Object)modelId, (String)modelShowNumber), (SimpleItem)SimpleItem.newOne((Object)sceneMember.getId(), (String)sceneMember.getNumber()), (SimpleItem)SimpleItem.newOne((Object)fyMember.getId(), (String)fyMember.getNumber()), (SimpleItem)SimpleItem.newOne((Object)periodMember.getId(), (String)periodMember.getNumber()));
        tarF7.setScheme(SimpleItem.newOne((Object)view.getFormShowParameter().getCustomParam("cslscheme"), null));
        return tarF7;
    }

    private FixedItem getSrcFixedItem(IFormView parent) {
        IDataModel dataModel = parent.getModel();
        DynamicObject yearDyn = (DynamicObject)dataModel.getValue("year");
        DynamicObject modelDyn = (DynamicObject)dataModel.getValue("model");
        DynamicObject periodDyn = (DynamicObject)dataModel.getValue("period");
        DynamicObject cslSchemeDyn = (DynamicObject)dataModel.getValue("cslscheme");
        DynamicObject sceneDyn = (DynamicObject)dataModel.getValue("scenario");
        if (Objects.isNull(modelDyn) || Objects.isNull(yearDyn) || Objects.isNull(periodDyn) || Objects.isNull(cslSchemeDyn) || Objects.isNull(sceneDyn)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u586b\u9879\u3002", (String)"InvLimSheetCopyFromPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        FixedItem srcF7 = FixedItem.newOne((SimpleItem)SimpleItem.newOne((Object)modelDyn.getLong("id"), (String)modelDyn.getString("shownumber")), (SimpleItem)SimpleItem.newOne((Object)sceneDyn.getLong("id"), (String)sceneDyn.getString("number")), (SimpleItem)SimpleItem.newOne((Object)yearDyn.getLong("id"), (String)yearDyn.getString("number")), (SimpleItem)SimpleItem.newOne((Object)periodDyn.getLong("id"), (String)periodDyn.getString("number")));
        srcF7.setScheme(SimpleItem.newOne((Object)cslSchemeDyn.getLong("id"), (String)cslSchemeDyn.getString("number")));
        return srcF7;
    }
}

