/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest.sheet;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.business.invest.componet.OrgF7Com;
import kd.fi.bcm.common.constant.invest.invsheet.InvLimSheetLogConstant;
import kd.fi.bcm.common.constant.invest.sharerela.InvRelationTypeConstant;
import kd.fi.bcm.common.enums.ExtendDimGroupType;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.dataquery.MainQueryPlugin;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;

public class InvLimSheetLogSearchPlugin
extends MainQueryPlugin
implements SingleMemberF7Util.ISingleMemberF7Handle {
    public static final String MODEL = "model";
    protected static final List<String> dimKeys = Arrays.asList("scenario", "year", "period");
    private static final Map<String, String> newOperationLogMap = new LinkedHashMap<String, String>(16);
    private static final String TRACE_ID = "traceid";
    private static final String INVESTED_COMPANY = "investeecompany";
    private static final String ENTITY = "entity";
    private static final String SHAREHOLDER = "shareholder";
    private static final String TOOL_BAR = "toolbarap";
    private static final String DATA_MODEL = "datamodel";
    private static final String RELATION_TYPE = "relationtype";
    private static final String GET_LOOK_UP_LIST = "getLookUpList";
    private static final String SET_ITEM_BY_ID_FROM_CLIENT = "setItemByIdFromClient";
    private static final String ACCOUNT = "account";
    private static final String BTN_RESET = "btn_reset";
    private static final String BTN_QUERY = "btn_query";
    private static final String OPEREATION_TYPE = "opertype";
    private static final String START_TIME = "startoptime";
    private static final String END_TIME = "endoptime";
    private static final String USER = "user";
    private static final String TYPE = "type";
    private static final String FILTER = "filter";
    private static final String COL_NAMES = "colNames";
    private static final String ENTITY_TYPE = "entityType";
    private static final String LIMIT = "limit";
    private OrgF7Com investedCompanyF7;
    private OrgF7Com orgUnitF7;

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap(16);
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
        this.investedCompanyF7 = new OrgF7Com(this.getView(), (Collection)Lists.newArrayList((Object[])new String[]{INVESTED_COMPANY}));
        this.orgUnitF7 = new OrgF7Com(this.getView(), (Collection)Lists.newArrayList((Object[])new String[]{ENTITY, "merge"}));
        this.getView().addCustomControls(new String[]{SHAREHOLDER});
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(TOOL_BAR);
        this.investedCompanyF7.addModelFilter(MODEL).addPermFilter(MODEL).addExchangeRateFilter().addIndependentFilter().registerFilters();
        this.orgUnitF7.addModelFilter(MODEL).addPermFilter(MODEL).addExchangeRateFilter().registerFilters();
        BasedataEdit entityControl = (BasedataEdit)this.getView().getControl("merge");
        entityControl.addBeforeF7SelectListener(beforeF7SelectEvent -> beforeF7SelectEvent.addCustomQFilter(new QFilter("isleaf", "=", (Object)false)));
        BasedataEdit dataModelControl = (BasedataEdit)this.getView().getControl(DATA_MODEL);
        dataModelControl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFBuilder filter = new QFBuilder(MODEL, "=", (Object)this.getModelId());
            filter.add("enable", "=", (Object)true);
            filter.add("extendsgroup.grouptype", "=", (Object)ExtendDimGroupType.EQUITY.getIndex());
            beforeF7SelectEvent.setCustomQFilters(filter.toList());
        });
        BasedataEdit relationTypeControl = (BasedataEdit)this.getView().getControl(RELATION_TYPE);
        relationTypeControl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (!GET_LOOK_UP_LIST.equals(beforeF7SelectEvent.getSourceMethod()) && !SET_ITEM_BY_ID_FROM_CLIENT.equals(beforeF7SelectEvent.getSourceMethod())) {
                beforeF7SelectEvent.addCustomQFilter(new QFilter("categorized", "=", (Object)InvRelationTypeConstant.CatalogEnum.relation.getCode()));
            }
            FormShowParameter formShowParameter = beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setCustomParam(MODEL, (Object)this.getModelId());
        });
        relationTypeControl.setQFilter(new QFilter(MODEL, "=", (Object)this.getModelId()));
        BasedataEdit accountControl = (BasedataEdit)this.getView().getControl(ACCOUNT);
        accountControl.addBeforeF7SelectListener(beforeF7SelectEvent -> beforeF7SelectEvent.addCustomQFilter(new QFilter(MODEL, "=", (Object)this.getModelId())));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initAdjustOperTypeList();
        this.setDefaultValue();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (BTN_RESET.equals(itemKey)) {
            this.doReset();
        } else if (BTN_QUERY.equals(itemKey)) {
            this.doQuery();
        }
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (SHAREHOLDER.equals(key)) {
            BasedataEditSingleMemberF7 f7 = SingleMemberF7Util.getBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), "InternalCompany", SHAREHOLDER, ev -> this.getSingleMemberF7Handle(Lists.newArrayList(this.getDimKeysFromCache().keySet())).beforeSingleMemberF7Select(ev), false, SingleF7TypeEnum.LEAF);
            f7.setDisplayProp("name");
            f7.setCustomFilter(new QFilter(MODEL, "=", (Object)this.getModelId()).and(new QFilter("isleaf", "=", (Object)"1")));
            e.setControl((Control)f7);
        }
    }

    @Override
    protected void setMsg(String msg) {
    }

    @Override
    public void beforeSingleMemberF7Select(BeforeF7SelectEvent arg0) {
    }

    @Override
    protected void initBasedataEditSingleMemberF7(String f7Key, BasedataEditSingleMemberF7 f7) {
        super.initBasedataEditSingleMemberF7(f7Key, f7);
        if (f7Key.equals("scenario") || f7Key.equals("year") || f7Key.equals("period")) {
            f7.setCustomData(MapInitHelper.ofMap((Object)"isNotPermFilterF7", (Object)"1"));
        }
    }

    private void initAdjustOperTypeList() {
        ((ComboEdit)this.getControl(OPEREATION_TYPE)).setComboItems(Arrays.stream(InvLimSheetLogConstant.Operation.values()).map(logEnum -> new ComboItem(new LocaleString(logEnum.getName()), String.valueOf(logEnum.getCode()))).collect(Collectors.toList()));
    }

    private void doReset() {
        this.setDefaultValue();
        this.setValue(OPEREATION_TYPE, null);
        this.setValue(USER, null);
        this.setValue(DATA_MODEL, null);
        this.setValue(RELATION_TYPE, null);
        this.setValue("merge", null);
        this.setValue(SHAREHOLDER, null);
        this.setValue(INVESTED_COMPANY, null);
        this.setValue(ACCOUNT, null);
        this.setValue(START_TIME, null);
        this.setValue(END_TIME, null);
        this.setValue(TRACE_ID, null);
        this.resetSqlPage();
    }

    private void doQuery() {
        this.resetSqlPage();
        List<Triple<String, String, Object>> filter = this.buildFilter();
        String tabKey = String.valueOf(UUID.randomUUID().hashCode());
        String tabName = ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u7ed3\u679c", (String)"InvLimSheetLogSearchPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(5);
        paramMap.put(TYPE, 3);
        paramMap.put(FILTER, filter);
        paramMap.put(COL_NAMES, SerializationUtils.serializeToBase64(newOperationLogMap));
        paramMap.put(ENTITY_TYPE, "bcm_invlimsheetlog");
        paramMap.put(LIMIT, this.getValue(LIMIT));
        this.getQueryDataTabManger().addSqlQueryDataTabInfo(tabKey, tabName, paramMap).showTabView(this.getView(), "bcm_invlimsheetlogresult");
        this.cacheQueryDataTabManger();
    }

    private void setDefaultValue() {
        this.setValue(MODEL, this.getFormCustomParam(MODEL));
        this.setValue("scenario", this.getFormCustomParam("scenario"));
        this.setValue("year", this.getFormCustomParam("year"));
        this.setValue("period", this.getFormCustomParam("period"));
        this.setValue(ENTITY, this.getFormCustomParam(ENTITY));
    }

    private List<Triple<String, String, Object>> buildFilter() {
        LinkedList<Triple<String, String, Object>> filter = new LinkedList<Triple<String, String, Object>>();
        Optional.ofNullable(this.getValue(MODEL)).map(DynamicObject.class::cast).map(dy -> dy.getString("shownumber")).map(number -> filter.add(Triple.of((Object)MODEL, (Object)"=", (Object)number))).orElseThrow(() -> new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvLimSheetLogSearchPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        Optional.ofNullable(this.getValue("scenario")).map(DynamicObject.class::cast).map(dy -> dy.getString("number")).map(number -> filter.add(Triple.of((Object)"scenario", (Object)"=", (Object)number))).orElseThrow(() -> new KDBizException(ResManager.loadKDString((String)"\u60c5\u666f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvLimSheetLogSearchPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        Optional.ofNullable(this.getValue("year")).map(DynamicObject.class::cast).map(dy -> dy.getString("number")).map(number -> filter.add(Triple.of((Object)"year", (Object)"=", (Object)number))).orElseThrow(() -> new KDBizException(ResManager.loadKDString((String)"\u8d22\u5e74\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvLimSheetLogSearchPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        Optional.ofNullable(this.getValue("period")).map(DynamicObject.class::cast).map(dy -> dy.getString("number")).map(number -> filter.add(Triple.of((Object)"period", (Object)"=", (Object)number))).orElseThrow(() -> new KDBizException(ResManager.loadKDString((String)"\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvLimSheetLogSearchPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        Optional.ofNullable(this.getValue(ENTITY)).map(DynamicObject.class::cast).map(dy -> dy.getString("number")).map(number -> filter.add(Triple.of((Object)"orgunit", (Object)"=", (Object)number))).orElseThrow(() -> new KDBizException(ResManager.loadKDString((String)"\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvLimSheetLogSearchPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        Optional.ofNullable(this.getValue("merge")).map(DynamicObject.class::cast).ifPresent(dy -> filter.add(Triple.of((Object)"merge", (Object)"=", (Object)dy.getString("number"))));
        Optional.ofNullable(this.getValue(USER)).map(DynamicObject.class::cast).map(dy -> dy.getString("name")).ifPresent(name -> filter.add(Triple.of((Object)"username", (Object)"=", (Object)name)));
        Optional.ofNullable(this.getValue(DATA_MODEL)).map(DynamicObject.class::cast).map(dy -> dy.getString("number")).ifPresent(number -> filter.add(Triple.of((Object)DATA_MODEL, (Object)"=", (Object)number)));
        Optional.ofNullable(this.getValue(SHAREHOLDER)).map(DynamicObject.class::cast).map(dy -> dy.getString("number")).ifPresent(number -> filter.add(Triple.of((Object)SHAREHOLDER, (Object)"=", (Object)number)));
        Optional.ofNullable(this.getValue(INVESTED_COMPANY)).map(DynamicObject.class::cast).map(dy -> dy.getString("number")).ifPresent(number -> filter.add(Triple.of((Object)INVESTED_COMPANY, (Object)"=", (Object)number)));
        Optional.ofNullable(this.getValue(ACCOUNT)).map(DynamicObject.class::cast).map(dy -> dy.getString("number")).ifPresent(number -> filter.add(Triple.of((Object)ACCOUNT, (Object)"=", (Object)number)));
        Optional.ofNullable(this.getValue(RELATION_TYPE)).map(DynamicObject.class::cast).ifPresent(dy -> {
            String number = dy.getString("number");
            String categorized = dy.getString("categorized");
            filter.add(Triple.of((Object)RELATION_TYPE, (Object)"=", (Object)number));
            filter.add(Triple.of((Object)"categorized", (Object)"=", (Object)categorized));
        });
        String operType = (String)this.getValue(OPEREATION_TYPE);
        if (StringUtils.isNotBlank((CharSequence)operType)) {
            filter.add(Triple.of((Object)"operation", (Object)"=", (Object)operType));
        }
        Optional.ofNullable(this.getValue(START_TIME)).ifPresent(obj -> filter.add(Triple.of((Object)"opdate", (Object)">=", (Object)obj)));
        Optional.ofNullable(this.getValue(END_TIME)).ifPresent(obj -> filter.add(Triple.of((Object)"opdate", (Object)"<=", (Object)obj)));
        Optional.ofNullable(this.getValue(TRACE_ID)).map(String.class::cast).filter(StringUtils::isNotBlank).ifPresent(obj -> filter.add(Triple.of((Object)TRACE_ID, (Object)"ftlike", (Object)obj)));
        return filter;
    }

    static {
        newOperationLogMap.put("operation", ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u578b", (String)"InvLimSheetLogSearchPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        newOperationLogMap.put("username", ResManager.loadKDString((String)"\u64cd\u4f5c\u7528\u6237", (String)"InvLimSheetLogSearchPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        newOperationLogMap.put("opdate", ResManager.loadKDString((String)"\u64cd\u4f5c\u65f6\u95f4", (String)"InvLimSheetLogSearchPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        newOperationLogMap.put(TRACE_ID, TRACE_ID);
        newOperationLogMap.put("templatenumber", ResManager.loadKDString((String)"\u6a21\u677f", (String)"InvLimSheetLogSearchPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        newOperationLogMap.put(DATA_MODEL, ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u6a21\u578b", (String)"InvLimSheetLogSearchPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        newOperationLogMap.put("categorized", ResManager.loadKDString((String)"\u80a1\u6bd4\u7c7b\u578b\u5206\u7c7b", (String)"InvLimSheetLogSearchPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        newOperationLogMap.put(RELATION_TYPE, ResManager.loadKDString((String)"\u80a1\u6bd4\u7c7b\u578b", (String)"InvLimSheetLogSearchPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        newOperationLogMap.put("merge", ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9", (String)"InvLimSheetLogSearchPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        newOperationLogMap.put(SHAREHOLDER, ResManager.loadKDString((String)"\u6295\u8d44\u5355\u4f4d", (String)"InvLimSheetLogSearchPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        newOperationLogMap.put(INVESTED_COMPANY, ResManager.loadKDString((String)"\u88ab\u6295\u8d44\u5355\u4f4d", (String)"InvLimSheetLogSearchPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        newOperationLogMap.put(ACCOUNT, ResManager.loadKDString((String)"\u62d3\u5c55\u5b57\u6bb5", (String)"InvLimSheetLogSearchPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        newOperationLogMap.put("changetype", ResManager.loadKDString((String)"\u6570\u636e\u53d8\u52a8\u7c7b\u578b", (String)"InvLimSheetLogSearchPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        newOperationLogMap.put("value", ResManager.loadKDString((String)"\u503c", (String)"InvLimSheetLogSearchPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }
}

