/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest.sheet;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxLink;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.F7ItemFillBackArgs;
import kd.bos.form.spread.LookUpDataArgs;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.ExtDimensionHelper;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.extdata.sql.EdQueryComInfo;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.extdim.InvExtDataSaveService;
import kd.fi.bcm.business.invest.extdim.InvExtDataServiceHelper;
import kd.fi.bcm.business.invest.extdim.InvExtDataSpreadServiceHelper;
import kd.fi.bcm.business.invest.extdim.model.ExtendExtUniqueKey;
import kd.fi.bcm.business.invest.extdim.model.InvEDResultCellTable;
import kd.fi.bcm.business.invest.extdim.model.InvEDSaveComInfo;
import kd.fi.bcm.business.invest.function.QuadraConsumer;
import kd.fi.bcm.business.invest.model.InvestFormulaLog;
import kd.fi.bcm.business.invest.sheet.InvElimPaperGenerateService;
import kd.fi.bcm.business.invest.sheet.InvElimSpreadGenerateService;
import kd.fi.bcm.business.invest.sheet.InvLimSheetHeadInfo;
import kd.fi.bcm.business.invest.sheet.InvPaperSheetIteratorService;
import kd.fi.bcm.business.invest.sheet.InvSheetDeleteInfo;
import kd.fi.bcm.business.invest.sheet.PositionInfo;
import kd.fi.bcm.business.invest.sheet.formula.InvFormulaParam;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaContext;
import kd.fi.bcm.business.invest.sheet.formula.InvestSpreadFormulaHandler;
import kd.fi.bcm.business.invest.sheet.log.IInvLimSheetLogServer;
import kd.fi.bcm.business.invest.sheet.log.InvLimSheetLogServer;
import kd.fi.bcm.business.papertemplate.PaperTemplateService;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.InvestConstant;
import kd.fi.bcm.common.constant.invest.invlimsheet.InvExtDataConstant;
import kd.fi.bcm.common.constant.invest.invsheet.InvLimSheetLogConstant;
import kd.fi.bcm.common.constant.invest.invsheet.InvSheetTemplateConstant;
import kd.fi.bcm.common.constant.invest.sharerela.InvRelationTypeConstant;
import kd.fi.bcm.common.enums.BRExecStatusEnum;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.invest.InvFormulaLogTypeEnum;
import kd.fi.bcm.common.enums.invest.InvRelaTypeEnum;
import kd.fi.bcm.common.enums.invest.SheetStatusEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.NumberUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.invest.AbstractMultiSheetPlugin;
import kd.fi.bcm.formplugin.invest.multi.SheetTabInfo;
import kd.fi.bcm.formplugin.invest.multi.SheetTabModel;
import kd.fi.bcm.formplugin.report.postman.AbstractReportPostman;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.spread.SpreadUtils;
import kd.fi.bcm.formplugin.template.multiview.TempFormulaUtil;
import kd.fi.bcm.formplugin.util.AdjustModelUtil;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.spread.common.variant.Variant;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.event.EventConstant;
import kd.fi.bcm.spread.domain.view.event.NotifyEvent;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.model.UserObject;
import kd.fi.bcm.spread.util.GZIPUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class InvLimSheetPlugin
extends AbstractMultiSheetPlugin {
    public static final String SPREADTYPE = "spreadtype";
    public static final String BCM_INVSHEETRELATIONADD = "bcm_invsheetrelationadd";
    public static final String UNITORG = "unitorg";
    public static final String BCM_INVSHEETRELATIONADD_CLOSECALLBACK = "bcm_invsheetrelationadd_closecallback";
    public static final String START_COL = "startCol";
    public static final String START_ROW = "startRow";
    public static final String NAME = "name";
    public static final String CELL_F7 = "cellF7";
    private static final String DELETE_CONFIRM\uff3fCALLBACK = "delete_confirm\uff3fcallback";
    public static final String CLEAR_EXT_DATA = "clearExtData";
    public static final String DELETECELLS = "_deletecells";
    public static final String DELETEEXTS = "_deleteexts";
    public static final String DELETERELAS = "_deleterelas";
    public static final String DELETE_SPREAD_DATA_CALLBACK = "delete_spread_data_callback";
    private static final String NOT_EXIST_EXT_SETVALUE_NUMBER = "not_exist_ext_setvalue_number";
    public static final String NOT_EXIST_EXT_SETVALUE = "not_exist_ext_setvalue";
    public static final String UPDATEEXTMAP = "_updateextmap";
    public static final String DATATYPE_MAP_CACHE = "datatypeMapCache";
    public static final String ZERO_COLUMNS = "zeroColumns";
    private static final String SHOWTYPE = "showtype";
    public static final String LOCK_CELLS = "lockCells";
    private Boolean isCalculate = false;
    private static final String YEAR_ID = "yearId";
    private static final String PERIOD_ID = "periodId";
    private static final String NUMBER = "number";
    private static final String HAS_PROCESSED = "hasProcessed";
    private static final String PROPERTY_CHANGE = "propertychange";
    private static final String CACHE_SHOWTYPE = "cache_showtype";
    public static final String SHARECOMPANY = "sharecompany";
    public static final String INVESTCOMPANY = "investcompany";
    private int anyNumber = 0;

    @Override
    protected void reportTabSelected(TabSelectEvent evt) {
        super.reportTabSelected(evt);
        this.buildRowData(this.getCurrentTabModel(), this.getSpreadModel());
        this.restoreNoDataRowCol();
        this.checkPeriod();
    }

    @Override
    protected boolean isExistSheet() {
        return QueryServiceHelper.exists((String)"bcm_invlimsheetentity", (Object)this.getCurrentReportTabInfo().getReportId());
    }

    @Override
    protected void afterLoadReport4WorkPaper() {
        super.afterLoadReport4WorkPaper();
        this.execRule(InvSheetTemplateConstant.EexcRuleTypeEnum.EXECWHENOPEN, InvLimSheetLogConstant.Operation.RULE);
        this.afterRefreshReport();
    }

    @Override
    protected String updateWorkPaperSheetName(String spreadStr) {
        if (!"0".equals(this.getCurrentReportStatus())) {
            return InvExtDataSpreadServiceHelper.clearSpreadJsonFontFormula((String)spreadStr);
        }
        ArrayList lockCells = new ArrayList(16);
        Long templateId = LongUtil.toLong((Object)this.getCurrentReportTabInfo().getTemplateId());
        String spreadType = InvElimPaperGenerateService.getSpreadType((Sheet)this.getEffectiveSheet(), (long)templateId);
        InvPaperSheetIteratorService iteratorService = new InvPaperSheetIteratorService(this.getEffectiveSheet(), spreadType);
        String ssjson = new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(TempFormulaUtil.dealBase64Str(spreadStr))));
        JSONObject ssjsonObject = JSON.parseObject((String)ssjson, (Feature[])new Feature[]{Feature.OrderedField});
        JSONObject sheetsNew = new JSONObject();
        AtomicInteger index = new AtomicInteger(0);
        Set zeroColumns = Collections.synchronizedSet(new HashSet(16));
        Optional.ofNullable(ssjsonObject.getJSONObject("sheets")).ifPresent(sheetsOld -> sheetsOld.forEach((name, sheetObj) -> {
            JSONObject sheet = (JSONObject)sheetObj;
            sheet.put(NAME, (Object)(StringUtils.isNotEmpty((String)name) && name.length() > 30 ? name.substring(0, 30) : name));
            sheetsNew.put(name, (Object)sheet);
            Optional.ofNullable(sheet.get((Object)"columns")).map(JSONArray.class::cast).ifPresent(columns -> columns.forEach(column -> {
                if (column == null) {
                    return;
                }
                Object sizeStr = ((JSONObject)column).get((Object)"size");
                if (InvLimSheetPlugin.isZero(sizeStr)) {
                    zeroColumns.add(index.get());
                }
                index.getAndIncrement();
            }));
            Optional.ofNullable(sheet.getJSONObject("data")).map(data -> data.getJSONObject("dataTable")).ifPresent(table -> {
                int maxRow = table.size();
                int maxCol = table.values().stream().map(colObj -> {
                    JSONObject col = (JSONObject)colObj;
                    col.forEach((colNum, cellObj) -> {
                        JSONObject cell = (JSONObject)cellObj;
                        if (Objects.nonNull(cell.getString("formula"))) {
                            cell.remove((Object)"value");
                        }
                        cell.remove((Object)"formula");
                    });
                    return col.size();
                }).max(Integer::compareTo).get();
                sheet.put("rowCount", (Object)(maxRow > 41 ? maxRow + 5 : 46));
                sheet.put("columnCount", (Object)(maxCol > 41 ? maxCol + 5 : 46));
                iteratorService.newCellsFromCell((rowStart, colStart, rowSp, colSp) -> {
                    String colStartNum = String.valueOf(colStart);
                    String rowStartNum = String.valueOf(rowStart);
                    Boolean isLocked = Optional.ofNullable(table.getJSONObject(rowStartNum)).map(col -> col.getJSONObject(colStartNum)).map(cell -> cell.getJSONObject("style")).map(style -> style.getBoolean("locked")).orElseGet(() -> null);
                    if (Boolean.TRUE.equals(isLocked)) {
                        HashMap<String, Integer> cel = new HashMap<String, Integer>(4);
                        cel.put(SpreadProperties.LockCellMethod.R.k(), (Integer)rowStart);
                        cel.put(SpreadProperties.LockCellMethod.RC.k(), (Integer)rowSp);
                        cel.put(SpreadProperties.LockCellMethod.C.k(), (Integer)colStart);
                        cel.put(SpreadProperties.LockCellMethod.CC.k(), (Integer)colSp);
                        lockCells.add(cel);
                    }
                });
            });
        }));
        this.getEffectiveSheet().putUserObject(LOCK_CELLS, lockCells);
        this.getEffectiveSheet().putUserObject(ZERO_COLUMNS, zeroColumns);
        ssjsonObject.put("sheets", (Object)sheetsNew);
        String spreadjson = new String(Base64.getEncoder().encode(GZIPUtils.compress((String)JSON.toJSONString((Object)ssjsonObject))));
        return "base64" + spreadjson;
    }

    private static boolean isZero(Object v) {
        if (v instanceof BigDecimal) {
            return ((BigDecimal)v).compareTo(BigDecimal.ZERO) == 0;
        }
        if (v instanceof Integer) {
            return (Integer)v == 0;
        }
        if (v instanceof String && NumberUtils.isNumber((String)((String)v))) {
            return new BigDecimal((String)v).compareTo(BigDecimal.ZERO) == 0;
        }
        return false;
    }

    private void afterRefreshReport() {
        Long templateId = LongUtil.toLong((Object)this.getCurrentReportTabInfo().getTemplateId());
        InvExtDataSpreadServiceHelper.updateSheetExtMember((SpreadManager)this.getSpreadModel(), (long)this.getModelId(), (long)templateId);
        DynamicObject template = QueryServiceHelper.queryOne((String)"bcm_papertemplate", (String)"id,spreadtype,showtype", (QFilter[])new QFBuilder("id", "=", (Object)templateId).toArray());
        this.getView().setEnable(Boolean.valueOf(template != null), new String[]{"btn_save", "btn_generate", "btn_access", "query_export", "btn_row_display", "bar_formulaview", "btn_addinvrel", "btn_linkadjust", "btn_upgrade", "btn_refresh"});
        if (template == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e95\u7a3f\u5bf9\u5e94\u6a21\u677f\u5df2\u5220\u9664\u3002", (String)"InvLimSheetPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String spreadType = InvElimPaperGenerateService.getSpreadType((Sheet)this.getEffectiveSheet(), (long)templateId);
        String showType = Optional.ofNullable(template).map(t -> t.getString(SHOWTYPE)).map(type -> StringUtils.isEmpty((String)type) ? null : type).orElseGet(() -> ((InvSheetTemplateConstant.ShowTypeEnum)InvSheetTemplateConstant.ShowTypeEnum.NUM_AND_NAME).getCode());
        this.getPageCache().put(this.getCurrentTabModel().getCacheKey() + "_" + SPREADTYPE, spreadType);
        this.cacheShowtype(InvSheetTemplateConstant.ShowTypeEnum.getShowTypeEnum((String)showType).getNumber());
        int startCol = (Integer)this.getEffectiveSheet().getUserObject(START_COL);
        int startRow = (Integer)this.getEffectiveSheet().getUserObject(START_ROW);
        Integer maxFloatIdx = (Integer)this.getEffectiveSheet().getUserObject("inv_relation_count");
        this.modifySytle(spreadType, startCol, startRow, maxFloatIdx);
        HashMap<String, Integer> rangeMap = new HashMap<String, Integer>(16);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.C.k(), 0);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.RC.k(), 1);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.CC.k(), this.getEffectiveSheet().getMaxColumnCount());
        ArrayList<HashMap<String, Integer>> rangeList = new ArrayList<HashMap<String, Integer>>(10);
        rangeList.add(rangeMap);
        HashMap<String, Boolean> styleMap = new HashMap<String, Boolean>(16);
        styleMap.put(SpreadProperties.SetCellStyleMethod.WW.k(), true);
        HashMap<String, Cloneable> features = new HashMap<String, Cloneable>(16);
        features.put(SpreadProperties.SetCellStyleMethod.RANGE.k(), rangeList);
        features.put(SpreadProperties.SetCellStyleMethod.STYLE.k(), styleMap);
        SpreadClientInvoker.invokeSetCellStyleMethod(this.getClientViewProxy(), "report", Lists.newArrayList((Object[])new Map[]{features}));
        this.cacheSpreadModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifySytle(String spreadType, int startCol, int startRow, Integer maxFloatIdx) {
        try {
            String reportStatus = this.getCurrentReportStatus();
            SheetStatusEnum status = SheetStatusEnum.getStatusEnumBy((String)reportStatus);
            boolean fromCopy = this.getEffectiveSheet().getUserObject().containsKey("fromCopy");
            if (Boolean.TRUE.equals(this.isCalculate) || !fromCopy && status != SheetStatusEnum.AUTO || this.getEffectiveSheet().getTable().isEmpty()) {
                return;
            }
            int orgNumber = 1;
            if (!this.isFloatRow(spreadType)) {
                if (Objects.isNull(maxFloatIdx)) {
                    maxFloatIdx = this.getEffectiveSheet().getMaxColumnCount() - startCol;
                }
                if (maxFloatIdx > orgNumber) {
                    this.frontInsertCols(startCol + 1, maxFloatIdx - orgNumber);
                }
            } else {
                if (Objects.isNull(maxFloatIdx)) {
                    maxFloatIdx = this.getEffectiveSheet().getMaxRowCount() - startRow;
                }
                if (maxFloatIdx > orgNumber) {
                    this.frontInsertRows(startRow + 1, maxFloatIdx - orgNumber);
                }
            }
        }
        finally {
            this.setCalculate(true);
        }
    }

    @Override
    public int getInvRelasCount(String invRelaType) {
        Map<String, Long> filterMap = this.commonFilterMap();
        Long orgId = filterMap.get("bcm_entitymembertree");
        Long yearId = filterMap.get("bcm_fymembertree");
        Long periodId = filterMap.get("bcm_periodmembertree");
        Long sceneId = filterMap.get("bcm_scenemembertree");
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)this.getModelId());
        qf.add("scenario", "=", (Object)sceneId);
        qf.add("year", "=", (Object)yearId);
        qf.add("period", "=", (Object)periodId);
        qf.add("isdelete", "=", (Object)"0");
        qf.add("invrelatype", "=", (Object)invRelaType);
        qf.add("orgunit", "=", (Object)TreeStructureServiceHelper.getEntityBaseMemberId((long)orgId));
        DynamicObjectCollection relas = QueryServiceHelper.query((String)"bcm_invrelation", (String)"invrelatype,shareholder.id,investeecompany.id,shareholder.number,investeecompany.number,investeecompany.longnumber,shareholder.name,investeecompany.name", (QFilter[])qf.toArray());
        return relas.isEmpty() ? 0 : relas.size();
    }

    private void frontInsertCols(List<Integer> list) {
        LinkedHashMap<String, ArrayList<Integer>> map = new LinkedHashMap<String, ArrayList<Integer>>();
        ArrayList<Integer> insertRowList = new ArrayList<Integer>(list);
        map.put("data", insertRowList);
        SpreadClientInvoker.invokeInsertCol(this.getClientViewProxy(), "report", map);
    }

    private void frontInsertCols(int index, int count) {
        LinkedHashMap map = new LinkedHashMap();
        ArrayList insertRowList = new ArrayList(16);
        HashMap<String, Integer> param = new HashMap<String, Integer>(16);
        param.put("index", index);
        param.put("count", count);
        insertRowList.add(param);
        map.put("data", insertRowList);
        SpreadClientInvoker.invokeInsertCol(this.getClientViewProxy(), "report", map);
    }

    private void frontInsertRows(int index, int count) {
        LinkedHashMap map = new LinkedHashMap();
        ArrayList insertRowList = new ArrayList(16);
        HashMap<String, Integer> param = new HashMap<String, Integer>(16);
        param.put("index", index);
        param.put("count", count);
        insertRowList.add(param);
        map.put("data", insertRowList);
        SpreadClientInvoker.invokeInsertRow(this.getClientViewProxy(), "report", map);
    }

    private void frontInsertRowsBottom(List<Integer> list) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        ArrayList<Integer> insertRowList = new ArrayList<Integer>(list);
        map.put("data", insertRowList);
        map.put("dir", "bottom");
        SpreadClientInvoker.invokeInsertRow(this.getClientViewProxy(), "report", map);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.isExistSheet()) {
            IFormView list = this.getView().getMainView().getView((String)this.getFormCustomParam("pageId"));
            if (list != null) {
                list.activate();
                list.showErrorNotification(ResManager.loadKDString((String)"\u5e95\u7a3f\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\uff01", (String)"InvLimSheetPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(list);
            }
            this.getView().close();
            return;
        }
        ThreadCache.put((Object)"needCheckPerm", (Object)true);
        if (e.getChangeSet()[0].getOldValue() == null) {
            return;
        }
        if (e.getChangeSet()[0].getNewValue() == null) {
            DynamicObject member = (DynamicObject)e.getChangeSet()[0].getOldValue();
            this.getModel().getDataEntity().set(e.getProperty().getName(), (Object)member);
            return;
        }
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        this.getPageCache().put(PROPERTY_CHANGE, "true");
        switch (propertyName) {
            case "bcm_scenemembertree": {
                break;
            }
            case "bcm_fymembertree": {
                this.getPlugin().getView().getFormShowParameter().setCustomParam(YEAR_ID, (Object)((DynamicObject)this.getModel().getValue(propertyName)).getLong("id"));
                this.getPageCache().remove(PROPERTY_CHANGE);
                break;
            }
            case "bcm_periodmembertree": {
                this.getPlugin().getView().getFormShowParameter().setCustomParam(PERIOD_ID, (Object)((DynamicObject)this.getModel().getValue(propertyName)).getLong("id"));
                this.getPageCache().remove(PROPERTY_CHANGE);
            }
        }
        this.getEffectiveSheet().putUserObject(HAS_PROCESSED, null);
        this.buildRowData(this.getCurrentTabModel(), this.getSpreadModel());
        this.refreshReport();
        this.updateClientSpreadValues();
        this.afterRefreshReport();
        this.forcePushCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (!"btn_close".equals(itemKey) && this.checkRelation()) {
            return;
        }
        if (!this.isExistSheet()) {
            IFormView list = this.getView().getMainView().getView((String)this.getFormCustomParam("pageId"));
            if (list != null) {
                list.activate();
                list.showErrorNotification(ResManager.loadKDString((String)"\u5e95\u7a3f\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\uff01", (String)"InvLimSheetPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(list);
            }
            this.getView().close();
            return;
        }
        this.setNotifyFlag(true);
        super.itemClick(evt);
        switch (itemKey) {
            case "btn_save": {
                this.doSave();
                break;
            }
            case "bar_formulaview": {
                this.beforeShowFormulaView();
                OpNameMultiLangEnumBridge operation = new OpNameMultiLangEnumBridge("\u6253\u5f00\u516c\u5f0f\u89c6\u56fe", "InvLimSheetPlugin_3", "fi-bcm-formplugin", "openFormulaView");
                this.writeOperationLog(operation, ResultStatusEnum.SUCCESS.getName());
                break;
            }
            case "btn_refresh": {
                ThreadCache.put((Object)"needCheckPerm", (Object)true);
                this.execRule(InvSheetTemplateConstant.EexcRuleTypeEnum.EXECWHENOPEN, InvLimSheetLogConstant.Operation.RULE);
                this.refresh();
                break;
            }
            case "btn_row_name": 
            case "btn_row_number": 
            case "btn_row_numname": {
                this.cacheShowtype(itemKey);
                this.changeDisplay();
                this.cacheSpreadModel();
                break;
            }
            case "btn_access": {
                if (this.checkPeriod()) {
                    return;
                }
                this.checkOrgAccessible();
                this.setCalculate(true);
                if (this.isModified()) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u6709\u672a\u4fdd\u5b58\u7684\u6570\u636e\uff0c\u8bf7\u5148\u4fdd\u5b58\uff01", (String)"InvLimSheetPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.calculate();
                break;
            }
            case "btn_generate": {
                if (this.checkPeriod()) {
                    return;
                }
                try {
                    this.checkOrgAccessible();
                    this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u751f\u6210\u4e2d...", (String)"InvLimSheetPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                    this.generate();
                    break;
                }
                finally {
                    this.getView().hideLoading();
                }
            }
            case "btn_addinvrel": {
                this.addinvrel();
                break;
            }
            case "btn_linkadjust": {
                this.linkAdjust();
                break;
            }
            case "btn_upgrade": {
                this.upgrade();
                break;
            }
            case "btn_execrule": {
                if (this.isModified()) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u6709\u672a\u4fdd\u5b58\u7684\u6570\u636e\uff0c\u8bf7\u5148\u4fdd\u5b58\uff01", (String)"InvLimSheetPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.execRule();
            }
        }
    }

    private boolean checkRelation() {
        Sheet sheet = this.getEffectiveSheet();
        String spreadType = InvElimPaperGenerateService.getSpreadType((Sheet)sheet, (long)LongUtil.toLong((Object)this.getCurrentReportTabInfo().getTemplateId()));
        InvPaperSheetIteratorService invPaperSheetIteratorService = new InvPaperSheetIteratorService(sheet, spreadType);
        invPaperSheetIteratorService.iterationRelationCell((rltCell, orgCell, shareholderCell, investedCell) -> {
            if (rltCell.getUserObject().isEmpty() || orgCell.getUserObject().isEmpty() || shareholderCell.getUserObject().isEmpty() || investedCell.getUserObject().isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u9519\u8bef\u6295\u8d44\u5173\u7cfb\uff0c\u8bf7\u5148\u5904\u7406\u540e\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"InvLimSheetPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        });
        return false;
    }

    private void execRule() {
        this.checkOrgAccessible();
        ResultBox resultBox = this.execRule(InvSheetTemplateConstant.EexcRuleTypeEnum.MANUAL, InvLimSheetLogConstant.Operation.RULE);
        List messageList = resultBox.getMessageList();
        StringJoiner message = new StringJoiner("\n");
        if (CollectionUtils.isNotEmpty((Collection)messageList)) {
            messageList.forEach(ms -> message.add(ms.getMessage()));
            this.getView().showTipNotification(message.toString());
            return;
        }
        Object[] results = (Object[])resultBox.getData();
        StringJoiner msg = new StringJoiner(",");
        if (results.length > 0) {
            List failedIds = Arrays.stream(results).map(DynamicObject.class::cast).filter(record -> BRExecStatusEnum.FAILED.getIndex().equals(record.get("execstatus"))).map(record -> record.getLong("bizrule")).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(failedIds)) {
                DynamicObjectCollection bizrules = QueryServiceHelper.query((String)"bcm_bizruleentity", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", failedIds)});
                bizrules.forEach(rule -> msg.add(rule.getString(NUMBER)));
                String msgStr = msg.toString();
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u89c4\u5219\u201c%s\u201d\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u524d\u5f80\u4e1a\u52a1\u89c4\u5219\u5217\u8868\u67e5\u770b\u6267\u884c\u60c5\u51b5\u3002", (String)"InvLimSheetPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), msgStr));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u89c4\u5219\u6210\u529f\u3002", (String)"InvLimSheetPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            this.refresh();
        }
    }

    public void checkOrgAccessible() {
        Map<DimTypesEnum, Object> idMap = this.getCurrentReportCommonParam("id");
        long orgId = (Long)this.getCurrentReportCommonParam4Pair().get((Object)SysDimensionEnum.Entity.getNumber()).p1;
        long yearid = (Long)idMap.get(DimTypesEnum.YEAR);
        long periodid = (Long)idMap.get(DimTypesEnum.PERIOD);
        long scenarioid = (Long)idMap.get(DimTypesEnum.SCENARIO);
        InvestServiceHelper.checkOrgAccessible((long)this.getModelId(), (long)scenarioid, (long)yearid, (long)periodid, (long)orgId);
    }

    @Override
    protected void doSave() {
        if (this.checkPeriod() || this.saveCheck()) {
            return;
        }
        this.checkOrgAccessible();
        this.saveClick();
    }

    private ResultBox execRule(InvSheetTemplateConstant.EexcRuleTypeEnum execType, InvLimSheetLogConstant.Operation operationType) {
        ResultBox resultBox = ResultBox.of();
        QFBuilder qfBuilder = new QFBuilder("id", "=", (Object)LongUtil.toLong((Object)this.getCurrentReportTabInfo().getTemplateId()));
        DynamicObject template = QueryServiceHelper.queryOne((String)"bcm_papertemplate", (String)InvSheetTemplateConstant.getExcRuleFields(), (QFilter[])qfBuilder.toArray());
        if (template == null) {
            resultBox.add(ResManager.loadKDString((String)"\u6a21\u677f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"InvLimSheetPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return resultBox;
        }
        Map<String, Long> filterMap = this.commonFilterMap();
        Long orgId = LongUtil.toLong((Object)this.getFormCustomParam("selectOrgId"));
        if (!LongUtil.isvalidLong((Object)orgId)) {
            orgId = filterMap.get("bcm_entitymembertree");
        }
        Long yearId = filterMap.get("bcm_fymembertree");
        Long periodId = filterMap.get("bcm_periodmembertree");
        Long sceneId = filterMap.get("bcm_scenemembertree");
        InvElimPaperGenerateService paperGenService = new InvElimPaperGenerateService(Long.valueOf(this.getModelId()), sceneId, yearId, periodId, orgId, operationType);
        DynamicObjectCollection templateRule = paperGenService.getTemplateAssignRule(Collections.singletonList(template.getLong("group")), execType.getCode());
        if (CollectionUtils.isNotEmpty((Collection)templateRule)) {
            String processNumber = template.getString("process.number");
            Object[] result = paperGenService.excBizRule(template, processNumber, (List)templateRule);
            if (result.length == 0) {
                resultBox.add(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u6ca1\u6709\u53ef\u8c03\u7528\u7684%s\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u3002", (String)"InvLimSheetPlugin_45", (String)"fi-bcm-formplugin", (Object[])new Object[0]), execType.getDesc()));
            } else {
                resultBox.setData((Object)result);
            }
            return resultBox;
        }
        resultBox.add(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u6ca1\u6709\u53ef\u8c03\u7528\u7684%s\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u3002", (String)"InvLimSheetPlugin_45", (String)"fi-bcm-formplugin", (Object[])new Object[0]), execType.getDesc()));
        return resultBox;
    }

    @Override
    public void saveClick() {
        if (this.checkNullExtSetCell()) {
            return;
        }
        if (this.checkDeleteData()) {
            return;
        }
        this.saveOp();
    }

    private boolean checkNullExtSetCell() {
        String extCellNumbers = this.getPageCache().get(this.getCurrentTabModel().getCacheKey() + NOT_EXIST_EXT_SETVALUE_NUMBER);
        if (StringUtils.isNotEmpty((String)extCellNumbers)) {
            this.showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u5f15\u7528\u6a21\u578b\u5df2\u4e0d\u5305\u542b%s\u6210\u5458\uff0c\u662f\u5426\u6e05\u9664\u8be5\u6570\u636e\uff1f", (String)"InvLimSheetPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), extCellNumbers), DELETE_SPREAD_DATA_CALLBACK);
            return true;
        }
        return false;
    }

    private boolean checkDeleteData() {
        StringBuilder msg = new StringBuilder();
        CharSequence[] selectFields = InvSheetTemplateConstant.getSelectFields();
        QFBuilder qfBuilder = new QFBuilder("id", "=", (Object)LongUtil.toLong((Object)this.getCurrentReportTabInfo().getTemplateId()));
        DynamicObject template = QueryServiceHelper.queryOne((String)"bcm_papertemplate", (String)String.join((CharSequence)",", selectFields), (QFilter[])qfBuilder.toArray());
        List<InvEDSaveComInfo> deleteRelasList = this.getDeleteRelas();
        List<Long> deleteExtsList = this.getDeleteExts();
        List<ExtendExtUniqueKey> deleteCellsList = this.getDeleteCells();
        if (Objects.nonNull(template) && (CollectionUtils.isNotEmpty(deleteRelasList) || CollectionUtils.isNotEmpty(deleteExtsList) || CollectionUtils.isNotEmpty(deleteCellsList))) {
            Long extModelId = template.getLong("extdimid");
            qfBuilder.clear();
            qfBuilder = new QFBuilder("extdimid", "=", (Object)extModelId);
            DynamicObjectCollection refTemplates = QueryServiceHelper.query((String)"bcm_papertemplate", (String)String.join((CharSequence)",", selectFields), (QFilter[])qfBuilder.toArray());
            if (CollectionUtils.isNotEmpty((Collection)refTemplates) && refTemplates.size() > 1) {
                msg.append(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u5bf9\u5e94\u62d3\u5c55\u7ef4\u6a21\u578b\u88ab\u5176\u4ed6\u6a21\u677f\u5f15\u7528\uff0c\u662f\u5426\u6e05\u9664\u5e95\u7a3f\u76f8\u5173\u62d3\u5c55\u6570\u636e\uff1f", (String)"InvLimSheetPlugin_44", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getView().showConfirm(msg.toString(), MessageBoxOptions.YesNoCancel, new ConfirmCallBackListener(DELETE_CONFIRM\uff3fCALLBACK, (IFormPlugin)this));
                return true;
            }
        }
        return false;
    }

    private void upgrade() {
        Sheet sheet = this.getSpreadModel().getBook().getSheet(0);
        if (sheet.getUserObject().containsKey("NEWDATA_2.0")) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5e95\u7a3f\u4fdd\u5b58\u62d3\u5c55\u7ef4\u6a21\u578b\u6570\u636e\u5df2\u5347\u7ea7\uff0c\u65e0\u9700\u518d\u5347\u7ea7\u3002", (String)"InvLimSheetPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        try {
            this.checkOrgAccessible();
            PlatUtil.executeWithTX(tx -> {
                this.saveExtData();
                DynamicObject daft = BusinessDataServiceHelper.loadSingle((Object)this.getCurrentReportTabInfo().getReportId(), (String)"bcm_invlimsheetentity");
                daft.set("data", (Object)JsonSerializerUtil.toJson((SpreadManager)this.getSpreadModel()));
                SaveServiceHelper.save((IDataEntityType)daft.getDynamicObjectType(), (Object[])new Object[]{daft});
            });
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
            return;
        }
        this.refresh();
        this.changeDisplay();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5e95\u7a3f\u4fdd\u5b58\u62d3\u5c55\u7ef4\u6a21\u578b\u6570\u636e\u5347\u7ea7\u5b8c\u6210\u3002", (String)"InvLimSheetPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    @Override
    protected boolean saveCheck() {
        Set<String> checkRs = this.checkRelationRepeat();
        if (!checkRs.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6295\u8d44\u5173\u7cfb\u6709\u91cd\u590d\uff0c\u65e0\u6cd5\u8fdb\u884c\u4fdd\u5b58\u64cd\u4f5c\u3002", (String)"InvLimSheetPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return !checkRs.isEmpty();
    }

    private Set<String> checkRelationRepeat() {
        Sheet sheet = this.getEffectiveSheet();
        String spreadType = InvElimPaperGenerateService.getSpreadType((Sheet)sheet, (long)LongUtil.toLong((Object)this.getCurrentReportTabInfo().getTemplateId()));
        HashSet relationSet = new HashSet(16);
        HashSet<String> rs = new HashSet<String>(16);
        InvPaperSheetIteratorService invPaperSheetIteratorService = new InvPaperSheetIteratorService(sheet, spreadType);
        invPaperSheetIteratorService.iterationRelationCell((rltCell, orgCell, shareholderCell, investedCell) -> {
            String categorized;
            String unitOrg = (String)orgCell.getUserObject(NUMBER);
            String shareholder = (String)shareholderCell.getUserObject(NUMBER);
            String investOrg = (String)investedCell.getUserObject(NUMBER);
            if (Objects.isNull(unitOrg) || Objects.isNull(shareholder) || Objects.isNull(investOrg)) {
                return;
            }
            String relationType = (String)rltCell.getUserObject(InvRelaTypeEnum.class.getSimpleName());
            String unitKey = InvElimSpreadGenerateService.packRelaKey((String)((String)this.getRealOrgInfo().p2), (String)unitOrg, (String)shareholder, (String)relationType, (String)(categorized = InvElimSpreadGenerateService.getCategorized((Cell)rltCell)), (String)investOrg);
            if (!relationSet.add(unitKey)) {
                if (rltCell == orgCell) {
                    rs.add(String.join((CharSequence)"->", shareholder, investOrg));
                } else {
                    String rltName = (String)rltCell.getUserObject(NAME);
                    rs.add(String.join((CharSequence)"->", rltName, shareholder, investOrg));
                }
            }
        });
        return rs;
    }

    private void addinvrel() {
        this.checkOrgAccessible();
        Map<String, Long> filterMap = this.commonFilterMap();
        Long orgId = filterMap.get("bcm_entitymembertree");
        Long yearId = filterMap.get("bcm_fymembertree");
        Long periodId = filterMap.get("bcm_periodmembertree");
        Long sceneId = filterMap.get("bcm_scenemembertree");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(BCM_INVSHEETRELATIONADD);
        formShowParameter.setCustomParam("model", (Object)this.getModelId());
        formShowParameter.setCustomParam("period", (Object)periodId);
        formShowParameter.setCustomParam("scenario", (Object)sceneId);
        formShowParameter.setCustomParam("year", (Object)yearId);
        Long templateId = LongUtil.toLong((Object)this.getCurrentReportTabInfo().getTemplateId());
        DynamicObject template = QueryServiceHelper.queryOne((String)"bcm_papertemplate", (String)"process.number", (QFilter[])new QFBuilder("id", "=", (Object)templateId).toArray());
        if (OrgRelaProcessMembPool.isRelaProcess((String)template.getString("process.number"))) {
            formShowParameter.setCustomParam(UNITORG, (Object)orgId);
        } else {
            formShowParameter.setCustomParam(UNITORG, (Object)LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("selectOrgId")));
        }
        formShowParameter.setCustomParam("templateId", (Object)templateId);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BCM_INVSHEETRELATIONADD_CLOSECALLBACK));
        this.getView().showForm(formShowParameter);
    }

    private void generate() {
        if (this.isModified()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6709\u672a\u4fdd\u5b58\u7684\u6570\u636e\uff0c\u8bf7\u5148\u4fdd\u5b58\uff01", (String)"InvLimSheetPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.setRefreshListFlag();
        this.setReportStausBar(null);
        this.generateEntry();
    }

    private Tuple<Integer, Set<Long>, String> generateEntry() {
        long modelId = this.getModelId();
        Map<String, Long> filterMap = this.commonFilterMap();
        Long orgId = filterMap.get("bcm_entitymembertree");
        Long yearId = filterMap.get("bcm_fymembertree");
        Long periodId = filterMap.get("bcm_periodmembertree");
        Long sceneId = filterMap.get("bcm_scenemembertree");
        List<DynamicObject> sheetList = Collections.singletonList(BusinessDataServiceHelper.loadSingle((Object)this.getCurrentReportTabInfo().getReportId(), (String)"bcm_invlimsheetentity"));
        String msg = this.validTemplates(sheetList);
        if (StringUtils.isNotEmpty((String)msg)) {
            this.getView().showErrorNotification(msg);
            return null;
        }
        InvElimSpreadGenerateService elimCreateService = new InvElimSpreadGenerateService(modelId, sceneId.longValue(), yearId.longValue(), periodId.longValue(), orgId.longValue(), sheetList);
        Tuple result1 = elimCreateService.generate();
        String errMsg = (String)result1.p3;
        if (StringUtils.isNotEmpty((String)errMsg)) {
            this.getView().showErrorNotification(errMsg);
        }
        int resultP1 = (Integer)result1.p1 < 0 ? 0 : (Integer)result1.p1;
        Set successIds = (Set)result1.p2;
        if (!successIds.isEmpty()) {
            sheetList.stream().filter(sheet -> successIds.contains(sheet.getLong("template.id")) && SheetStatusEnum.STORAGE.status().equals(sheet.getString("from"))).forEach(e -> e.set("from", (Object)SheetStatusEnum.HAND.status()));
            SaveServiceHelper.save((DynamicObject[])sheetList.toArray(new DynamicObject[0]));
        }
        if (resultP1 > 0) {
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u751f\u6210%s\u4e2a\u62b5\u9500\u5206\u5f55,\u8bf7\u8fdb\u5165\u8c03\u6574\u62b5\u9500\u5206\u5f55\u754c\u9762\u67e5\u770b\u3002", (String)"InvLimSheetPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]), resultP1), Integer.valueOf(3000));
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u751f\u6210\u5206\u5f55", "InvLimSheetPlugin_46", "fi-bcm-formplugin", "generateEntry"), new OPDescMultiLangEnumBridge("\u751f\u6210%s\u4e2a\u62b5\u9500\u5206\u5f55", "InvLimSheetPlugin_18", "fi-bcm-formplugin", new String[]{resultP1 + ""}));
        }
        return result1;
    }

    private String validTemplates(List<DynamicObject> sheetList) {
        StringBuilder logMsg = new StringBuilder();
        sheetList.forEach(e -> {
            if (e.get("template") == null) {
                logMsg.append(String.format(ResManager.loadKDString((String)"\u5e95\u7a3f\u3010%s\u3011\u6a21\u677f\u5df2\u5220\u9664\uff0c\u65e0\u6cd5\u751f\u6210\u5206\u5f55\u3002", (String)"InvLimSheetPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e.getString(NUMBER))).append("\n");
            }
        });
        return logMsg.toString();
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData = evt.getReturnData();
        String actionId = evt.getActionId();
        if (BCM_INVSHEETRELATIONADD_CLOSECALLBACK.equals(actionId) && returnData != null) {
            String investNumber;
            DynamicObject investeeCompanyDy;
            this.checkOrgAccessible();
            Map returnDataMap = (Map)returnData;
            Long shareCompanyId = (Long)returnDataMap.get(SHARECOMPANY);
            Long investCompanyId = (Long)returnDataMap.get(INVESTCOMPANY);
            Long unitOrgId = (Long)returnDataMap.get(UNITORG);
            if (shareCompanyId == null || investCompanyId == null || unitOrgId == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6295\u8d44\u5355\u4f4d\u6216\u88ab\u6295\u8d44\u5355\u4f4d\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01", (String)"InvLimSheetPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject relationTypeDy = (DynamicObject)returnDataMap.get("relationtype");
            DynamicObject shareholderDy = BusinessDataServiceHelper.loadSingle((Object)shareCompanyId, (String)"bcm_icmembertree");
            if (this.checkIndependent(shareholderDy, investeeCompanyDy = BusinessDataServiceHelper.loadSingle((Object)investCompanyId, (String)"bcm_entitymembertree"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6295\u8d44\u5355\u4f4d\u548c\u88ab\u6295\u8d44\u5355\u4f4d\u4e0d\u80fd\u4e3a\u540c\u4e00\u5355\u4f4d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"InvLimSheetPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            String number = shareholderDy.getString(NUMBER);
            if (number.equals(investNumber = investeeCompanyDy.getString(NUMBER))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"InvLimSheetPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            String spreadType = InvElimPaperGenerateService.getSpreadType((Sheet)this.getEffectiveSheet(), (long)LongUtil.toLong((Object)this.getCurrentReportTabInfo().getTemplateId()));
            int floatCount = (Integer)this.getEffectiveSheet().getUserObject("inv_relation_count");
            int startCol = (Integer)this.getEffectiveSheet().getUserObject(START_COL);
            int startRow = (Integer)this.getEffectiveSheet().getUserObject(START_ROW);
            this.setModified(true);
            Map<String, Long> filterMap = this.commonFilterMap();
            Long orgId = filterMap.get("bcm_entitymembertree");
            Long yearId = filterMap.get("bcm_fymembertree");
            Long periodId = filterMap.get("bcm_periodmembertree");
            Long sceneId = filterMap.get("bcm_scenemembertree");
            InvestFormulaContext context = new InvestFormulaContext(this.getModelId(), sceneId.longValue(), yearId.longValue(), periodId.longValue());
            context.setSheet(this.getSpreadModel());
            context.setMergeOrgId(unitOrgId);
            context.setFlowRow(this.isFloatRow(spreadType));
            context.setExecuteOrgId(orgId);
            InvestSpreadFormulaHandler formulaHandler = new InvestSpreadFormulaHandler(context);
            String relationType = relationTypeDy.getString(NUMBER);
            String categorized = relationTypeDy.getString("categorized");
            InvLimSheetHeadInfo headInfo = new InvLimSheetHeadInfo(relationType, categorized);
            headInfo.setUnitOrg(context.queryMergeOrg().getId().longValue(), context.queryMergeOrg().getNumber(), context.queryMergeOrg().getName());
            headInfo.setShareholder(shareholderDy.getLong("id"), shareholderDy.getString(NUMBER), shareholderDy.getString(NAME));
            headInfo.setInvestedCompany(investeeCompanyDy.getLong("id"), investeeCompanyDy.getString(NUMBER), investeeCompanyDy.getString(NAME));
            headInfo.setRelationTypeName(relationTypeDy.getString(NAME));
            this.getEffectiveSheet().putUserObject("inv_relation_count", (Object)(floatCount + 1));
            if (floatCount != 0) {
                formulaHandler.addEndRowOrCol(floatCount + 1, startRow, startCol);
            }
            this.cacheSpreadModel();
            this.setFloatStaus(true);
            formulaHandler.updateInvestRelaHead(startRow, startCol, floatCount + 1, headInfo);
            this.addSpreadStyle(spreadType, floatCount, startCol, startRow);
        } else if (CELL_F7.equals(actionId) && returnData != null) {
            int r = this.getSpreadSelector().getStartRow();
            int c = this.getSpreadSelector().getStartCol();
            DynamicObject memberObject = (DynamicObject)returnData;
            String hdname = memberObject.getString(NAME);
            String hdnumber = memberObject.getString(NUMBER);
            Long hdid = memberObject.getLong("id");
            Cell cell = this.getEffectiveSheet().getCell(r, c);
            cell.setUserObject(NUMBER, (Object)hdnumber);
            cell.setUserObject("id", (Object)hdid);
            cell.setUserObject(NAME, (Object)hdname);
            ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>(16);
            this.buildSingleCellData(cellValues, cell, hdname, hdnumber);
            if (!cellValues.isEmpty()) {
                SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), "report", cellValues);
            }
            this.cacheSpreadModel();
        }
    }

    private boolean checkIndependent(DynamicObject shareholdCompanyDy, DynamicObject investeeCompanyDy) {
        boolean investeeIsDep = investeeCompanyDy.getBoolean("isindependentorg");
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)this.getModelId());
        qfBuilder.add(NUMBER, "in", (Object)shareholdCompanyDy.getString(NUMBER));
        qfBuilder.add("storagetype", "=", (Object)StorageTypeEnum.STORAGE.index);
        DynamicObject sharehold = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"number,name,isindependentorg", (QFilter[])qfBuilder.toArray());
        boolean shareholdIsDep = Objects.nonNull(sharehold) ? sharehold.getBoolean("isindependentorg") : true;
        return !investeeIsDep || !shareholdIsDep;
    }

    @Override
    protected boolean checkDeleteRow(List<Integer> rows) {
        if (CollectionUtils.isNotEmpty(rows) && rows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6295\u8d44\u5355\u4f4d\u6216\u88ab\u6295\u8d44\u5355\u4f4d\u4e3a\u975e\u72ec\u7acb\u6cd5\u4eba\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"InvLimSheetPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        int startRow = (Integer)this.getEffectiveSheet().getUserObject(START_ROW);
        String spreadType = InvElimPaperGenerateService.getSpreadType((Sheet)this.getEffectiveSheet(), (long)LongUtil.toLong((Object)this.getCurrentReportTabInfo().getTemplateId()));
        if (this.isFloatRow(spreadType) && (rows.contains(startRow) || rows.contains(startRow + 1))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u6a21\u677f\u884c\uff0c\u4e0d\u53ef\u5220\u9664!", (String)"InvLimSheetPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!this.isFloatRow(spreadType) && this.isSheetHead(startRow, rows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u8868\u5934\uff0c\u4e0d\u53ef\u5220\u9664!", (String)"InvLimSheetPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    protected void beforeUpdateValues(NotifyEvent e) {
        SpreadPostDataInfo data = (SpreadPostDataInfo)e.getParam();
        ArrayList<Long> deleteExtsList = new ArrayList<Long>(10);
        ArrayList<ExtendExtUniqueKey> deleteCellsList = new ArrayList<ExtendExtUniqueKey>(10);
        HashMap<Long, Pair<Integer, String>> extMap = new HashMap<Long, Pair<Integer, String>>(16);
        ArrayList contextList = new ArrayList(10);
        data.getValues().forEach(v -> {
            Cell cell = this.getEffectiveSheet().getCell(((Integer)v.get("r")).intValue(), ((Integer)v.get("c")).intValue());
            this.dealAccAreaUpdateValue(e, cell, v.get("v"), contextList);
            this.collectDeleteData(cell, v.get("v"), deleteExtsList, deleteCellsList, extMap);
            this.checkCellDataType(cell, (Map<String, Object>)v, contextList);
        });
        if (CollectionUtils.isNotEmpty(contextList)) {
            ArrayList formulaCells = new ArrayList(16);
            for (Map map : contextList) {
                HashMap formulaCell = new HashMap();
                formulaCell.put(SpreadProperties.SetFormulaMethod.R.k(), map.get(SpreadProperties.UpdataValueMethod.R.k()));
                formulaCell.put(SpreadProperties.SetFormulaMethod.C.k(), map.get(SpreadProperties.UpdataValueMethod.C.k()));
                formulaCell.put(SpreadProperties.SetFormulaMethod.F.k(), null);
                formulaCells.add(formulaCell);
            }
            SpreadClientInvoker.invokeSetFormulaMethod(this.getClientViewProxy(), "report", formulaCells);
            SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), "report", contextList);
        }
        this.cacheSpreadModel();
        this.cacheDeleteExts(deleteExtsList);
        this.cacheDeleteCells(deleteCellsList);
        this.cacheExtMap(extMap);
    }

    private void dealAccAreaUpdateValue(NotifyEvent e, Cell cell, Object newValue, List<Map<String, Object>> contextList) {
        String spreadType = InvElimPaperGenerateService.getSpreadType((Sheet)this.getEffectiveSheet(), (long)LongUtil.toLong((Object)this.getCurrentReportTabInfo().getTemplateId()));
        boolean floatRow = this.isFloatRow(spreadType);
        Variant data = cell.getCellData().getData();
        if (this.isAccCellArea(cell, floatRow)) {
            if (data.equals(new Variant(newValue))) {
                e.setCancel(true);
            } else {
                Long extId = (Long)cell.getUserObject("id");
                this.cacheDeleteExts(extId);
                cell.setValue(null);
                cell.setFormula(null);
                cell.clearAllUserObject();
                contextList.add(this.packedUpdateCellMap(cell.getRow(), cell.getCol(), null));
            }
        }
    }

    private boolean isAccCellArea(Cell cell, boolean floatRow) {
        int startRow = (Integer)this.getEffectiveSheet().getUserObject(START_ROW);
        int startCol = (Integer)this.getEffectiveSheet().getUserObject(START_COL);
        if (!floatRow) {
            int startAccCellArea = startRow + this.getInvSheetHeadLength();
            return cell.getRow() >= startAccCellArea && cell.getCol() == startCol;
        }
        int startAccCellArea = startCol + this.getInvSheetHeadLength();
        return cell.getCol() >= startAccCellArea && cell.getRow() == startRow;
    }

    private void collectDeleteData(Cell cell, Object newValue, List<Long> deleteExtsList, List<ExtendExtUniqueKey> deleteCellsList, HashMap<Long, Pair<Integer, String>> extMap) {
        Sheet sheet = this.getEffectiveSheet();
        int startRow = (Integer)sheet.getUserObject(START_ROW);
        int startCol = (Integer)sheet.getUserObject(START_COL);
        String spreadType = InvElimPaperGenerateService.getSpreadType((Sheet)sheet, (long)LongUtil.toLong((Object)this.getCurrentReportTabInfo().getTemplateId()));
        Long extId = (Long)cell.getUserObject("id");
        if (!Objects.nonNull(newValue) && LongUtil.isvalidLong((Object)extId)) {
            if (!this.isFloatRow(spreadType) && cell.getCol() == startCol || this.isFloatRow(spreadType) && cell.getRow() == startRow) {
                deleteExtsList.add(extId);
                cell.setFormula(null);
                cell.clearAllUserObject();
            }
        } else {
            InvPaperSheetIteratorService iteratorService = new InvPaperSheetIteratorService(sheet, spreadType);
            iteratorService.findHeadCells(cell.getRow(), cell.getCol(), (rltCell, orgCell, shareholderCell, investedCell, accCell) -> {
                Object accId = accCell.getUserObject("id");
                if (Objects.nonNull(shareholderCell.getUserObject("id")) && Objects.nonNull(accId)) {
                    if (!Objects.nonNull(newValue)) {
                        String accNum = (String)accCell.getUserObject(NUMBER);
                        String relationType = (String)rltCell.getUserObject(InvRelaTypeEnum.class.getSimpleName());
                        String categorized = InvElimSpreadGenerateService.getCategorized((Cell)rltCell);
                        String mergeNum = (String)orgCell.getUserObject(NUMBER);
                        String shareholder = (String)shareholderCell.getUserObject(NUMBER);
                        String investOrg = (String)investedCell.getUserObject(NUMBER);
                        deleteCellsList.add(new ExtendExtUniqueKey(accNum, (String)this.getCurrentOrgInfo().p2, mergeNum, shareholder, investOrg, relationType, categorized));
                    } else {
                        String headExtNumber = (String)accCell.getUserObject(NUMBER);
                        extMap.put((Long)accId, Pair.onePair((Object)(this.isFloatRow(spreadType) ? cell.getCol() : cell.getRow()), (Object)headExtNumber));
                    }
                }
            });
        }
    }

    @Override
    public void afterSpreadEventHandle(EventConstant.ActionName actionName) {
        String extModeId = this.getPageCache().get(this.getCurrentTabModel().getCacheKey() + "extdimid");
        Map extMapCache = this.getExtMap();
        if (LongUtil.isvalidLong((Object)extModeId) && MapUtils.isNotEmpty((Map)extMapCache)) {
            HashSet<String> nosSet = new HashSet<String>();
            HashSet<String> numbersSet = new HashSet<String>();
            HashSet headExtIds = new HashSet(10);
            extMapCache.entrySet().stream().forEach(entry -> {
                Long extId = Long.parseLong((String)((Map.Entry)entry).getKey());
                headExtIds.add(extId);
            });
            DynamicObjectCollection extModeFields = QueryServiceHelper.query((String)"bcm_extmodelfield", (String)"id,extmodelid,extfield", (QFilter[])new QFilter[]{new QFilter("extmodelid", "=", (Object)LongUtil.toLong((Object)extModeId)).and("extfield", "in", headExtIds)});
            Set extfields = extModeFields.stream().map(field -> field.getLong("extfield")).collect(Collectors.toSet());
            headExtIds.removeAll(extfields);
            headExtIds.stream().forEach(id -> {
                LinkedHashMap extPair = (LinkedHashMap)extMapCache.get(String.valueOf(id));
                nosSet.add(String.valueOf(extPair.get("p1")));
                numbersSet.add((String)extPair.get("p2"));
            });
            this.cacheNullExtSetDataNo(nosSet);
            this.cacheNullExtSetDataNumber(numbersSet);
        }
        super.afterSpreadEventHandle(actionName);
    }

    private void cacheNullExtSetDataNumber(Set<String> numbersSet) {
        if (CollectionUtils.isNotEmpty(numbersSet)) {
            String numbers = this.getPageCache().get(this.getCurrentTabModel().getCacheKey() + NOT_EXIST_EXT_SETVALUE_NUMBER);
            if (StringUtils.isNotEmpty((String)numbers)) {
                String[] numsArry = numbers.split(",");
                numbersSet.addAll(Arrays.stream(numsArry).collect(Collectors.toList()));
            }
            String extCellNumbers = String.join((CharSequence)",", numbersSet);
            this.getPageCache().put(this.getCurrentTabModel().getCacheKey() + NOT_EXIST_EXT_SETVALUE_NUMBER, extCellNumbers);
        }
    }

    private void cacheNullExtSetDataNo(Set<String> nosSet) {
        if (CollectionUtils.isNotEmpty(nosSet)) {
            String nos = this.getPageCache().get(this.getCurrentTabModel().getCacheKey() + NOT_EXIST_EXT_SETVALUE);
            if (StringUtils.isNotEmpty((String)nos)) {
                String[] nosArr = nos.split(",");
                nosSet.addAll(Arrays.stream(nosArr).collect(Collectors.toSet()));
            }
            String extCellNos = String.join((CharSequence)",", nosSet);
            this.getPageCache().put(this.getCurrentTabModel().getCacheKey() + NOT_EXIST_EXT_SETVALUE, extCellNos);
        }
    }

    @Override
    protected boolean checkDeleteCol(List<Integer> cols) {
        if (CollectionUtils.isNotEmpty(cols) && cols.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u5217\u5220\u9664\uff01", (String)"InvLimSheetPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        int startCol = (Integer)this.getEffectiveSheet().getUserObject(START_COL);
        String spreadType = InvElimPaperGenerateService.getSpreadType((Sheet)this.getEffectiveSheet(), (long)LongUtil.toLong((Object)this.getCurrentReportTabInfo().getTemplateId()));
        if (!this.isFloatRow(spreadType) && (cols.contains(startCol) || cols.contains(startCol + 1))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u6a21\u677f\u5217\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"InvLimSheetPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.isFloatRow(spreadType) && this.isSheetHead(startCol, cols)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u8868\u5934\uff0c\u4e0d\u53ef\u5220\u9664!", (String)"InvLimSheetPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isSheetHead(int start, List<Integer> selectedIndex) {
        AtomicBoolean flag = new AtomicBoolean(false);
        selectedIndex.forEach(index -> {
            if (start <= index && index < start + InvestConstant.getSheetHeadLength((String)((String)this.getEffectiveSheet().getUserObject("dimSetting_V2.0")))) {
                flag.set(true);
            }
        });
        return flag.get();
    }

    @Override
    protected void afterDeleteCol(int deleteCol) {
        Sheet sheet = this.getEffectiveSheet();
        Long templateId = LongUtil.toLong((Object)this.getCurrentReportTabInfo().getTemplateId());
        String spreadType = InvElimPaperGenerateService.getSpreadType((Sheet)sheet, (long)templateId);
        InvPaperSheetIteratorService iteratorService = new InvPaperSheetIteratorService(sheet, spreadType);
        iteratorService.findHeadCells(this.anyNumber, deleteCol, (rltCell, orgCell, shareholderCell, investedCell, accCell) -> this.doCache(false, (Cell)rltCell, (Cell)orgCell, (Cell)shareholderCell, (Cell)investedCell, (Cell)accCell));
    }

    @Override
    protected void afterDeleteRow(int deleteRow) {
        Sheet sheet = this.getEffectiveSheet();
        Long templateId = LongUtil.toLong((Object)this.getCurrentReportTabInfo().getTemplateId());
        String spreadType = InvElimPaperGenerateService.getSpreadType((Sheet)sheet, (long)templateId);
        InvPaperSheetIteratorService iteratorService = new InvPaperSheetIteratorService(sheet, spreadType);
        iteratorService.findHeadCells(deleteRow, this.anyNumber, (rltCell, orgCell, shareholderCell, investedCell, accCell) -> this.doCache(true, (Cell)rltCell, (Cell)orgCell, (Cell)shareholderCell, (Cell)investedCell, (Cell)accCell));
    }

    private void doCache(boolean isDeleteRow, Cell rltCell, Cell unitorgCell, Cell shareholderCell, Cell investedCell, Cell accCell) {
        Sheet sheet = this.getEffectiveSheet();
        Long templateId = LongUtil.toLong((Object)this.getCurrentReportTabInfo().getTemplateId());
        String spreadType = InvElimPaperGenerateService.getSpreadType((Sheet)sheet, (long)templateId);
        int floatCount = (Integer)sheet.getUserObject("inv_relation_count");
        if (this.isFloatRow(spreadType) == isDeleteRow) {
            DynamicObject template = (DynamicObject)ThreadCache.get((Object)"bcm_papertemplate", () -> QueryServiceHelper.queryOne((String)"bcm_papertemplate", (String)String.join((CharSequence)",", InvSheetTemplateConstant.getSelectFields()), (QFilter[])new QFBuilder("id", "=", (Object)templateId).toArray()));
            if (Objects.isNull(template)) {
                return;
            }
            String relationTypeFromPaper = template.getString("invrelationtype.fbasedataid.number");
            String unitOrg = (String)unitorgCell.getUserObject(NUMBER);
            String shareholder = (String)shareholderCell.getUserObject(NUMBER);
            String investOrg = (String)investedCell.getUserObject(NUMBER);
            String relationType = this.getRelationType(relationTypeFromPaper, rltCell, shareholder, investOrg);
            String categorized = InvElimSpreadGenerateService.getCategorized((Cell)rltCell);
            if (Objects.nonNull(shareholder) && Objects.nonNull(investOrg) && Objects.nonNull(relationType)) {
                sheet.putUserObject("inv_relation_count", (Object)(floatCount - 1));
                DynamicObject extModel = (DynamicObject)ThreadCache.get((Object)"bcm_extendsmodel", () -> QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"id,number,extendsgroup.id,extendsgroup.number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)template.getLong("extdimid"))}));
                if (extModel == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5e95\u7a3f\u5bf9\u5e94\u7684\u6a21\u677f\u6ca1\u6709\u5173\u8054\u6570\u636e\u6a21\u578b\u3002", (String)"InvLimSheetPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                InvEDSaveComInfo tempEDSaveComInfo = new InvEDSaveComInfo(MemberReader.findModelSNumberById((Object)this.getModelId()), extModel.getString("extendsgroup.number"), extModel.getString(NUMBER));
                tempEDSaveComInfo.setRelationType(relationType);
                tempEDSaveComInfo.setCategorized(categorized);
                tempEDSaveComInfo.setBelongOrg((String)this.getRealOrgInfo().p2);
                tempEDSaveComInfo.setMerge(unitOrg);
                tempEDSaveComInfo.setSharehold(shareholder);
                tempEDSaveComInfo.setInvestOrg(investOrg);
                tempEDSaveComInfo.setTemplateNumber(this.getTemplateModel().getNumber());
                this.cachDeleteRelas(tempEDSaveComInfo);
            }
        } else {
            Long extId = (Long)accCell.getUserObject("id");
            this.cacheDeleteExts(extId);
        }
        this.setFloatStaus(true);
        this.cacheSpreadModel();
    }

    private List<Long> getDeleteExts() {
        String extsStr = this.getPageCache().get(this.getCurrentTabModel().getCacheKey() + DELETEEXTS);
        List<Long> deleteExts = new ArrayList<Long>(10);
        if (StringUtils.isNotEmpty((String)extsStr)) {
            deleteExts = (List)ObjectSerialUtil.deSerializedBytes((String)extsStr);
        }
        return deleteExts;
    }

    private void cacheDeleteExts(Long extId) {
        if (LongUtil.isvalidLong((Object)extId)) {
            List<Long> deleteExtsList = this.getDeleteExts();
            deleteExtsList.add(extId);
            this.getPageCache().put(this.getCurrentTabModel().getCacheKey() + DELETEEXTS, ObjectSerialUtil.toByteSerialized(deleteExtsList));
        }
    }

    private void cacheDeleteExts(List<Long> extIds) {
        if (CollectionUtils.isNotEmpty(extIds)) {
            List<Long> deleteExtsList = this.getDeleteExts();
            deleteExtsList.addAll(extIds);
            this.getPageCache().put(this.getCurrentTabModel().getCacheKey() + DELETEEXTS, ObjectSerialUtil.toByteSerialized(deleteExtsList));
        }
    }

    private List<ExtendExtUniqueKey> getDeleteCells() {
        String extsStr = this.getPageCache().get(this.getCurrentTabModel().getCacheKey() + DELETECELLS);
        List<Object> deleteExts = new ArrayList<ExtendExtUniqueKey>(10);
        if (StringUtils.isNotEmpty((String)extsStr)) {
            deleteExts = (List)ObjectSerialUtil.deSerializedBytes((String)extsStr);
        }
        return deleteExts;
    }

    private void cacheDeleteCells(List<ExtendExtUniqueKey> uniqueKeys) {
        if (CollectionUtils.isNotEmpty(uniqueKeys)) {
            List<ExtendExtUniqueKey> deleteExts = this.getDeleteCells();
            deleteExts.addAll(uniqueKeys);
            this.getPageCache().put(this.getCurrentTabModel().getCacheKey() + DELETECELLS, ObjectSerialUtil.toByteSerialized(deleteExts));
        }
    }

    private List<InvEDSaveComInfo> getDeleteRelas() {
        String extsStr = this.getPageCache().get(this.getCurrentTabModel().getCacheKey() + DELETERELAS);
        List<Object> infoList = new ArrayList<InvEDSaveComInfo>(10);
        if (StringUtils.isNotEmpty((String)extsStr)) {
            infoList = (List)ObjectSerialUtil.deSerializedBytes((String)extsStr);
        }
        return infoList;
    }

    private void cachDeleteRelas(InvEDSaveComInfo info) {
        if (info != null) {
            List<InvEDSaveComInfo> deleteRelas = this.getDeleteRelas();
            deleteRelas.add(info);
            this.getPageCache().put(this.getCurrentTabModel().getCacheKey() + DELETERELAS, ObjectSerialUtil.toByteSerialized(deleteRelas));
        }
    }

    private Map getExtMap() {
        String extsStr = this.getPageCache().get(this.getCurrentTabModel().getCacheKey() + UPDATEEXTMAP);
        Map extMap = new HashMap(10);
        if (StringUtils.isNotEmpty((String)extsStr)) {
            extMap = (Map)SerializationUtils.fromJsonString((String)extsStr, Map.class);
        }
        return extMap;
    }

    private void cacheExtMap(HashMap<Long, Pair<Integer, String>> extMap) {
        if (MapUtils.isNotEmpty(extMap)) {
            Map extMapCache = this.getExtMap();
            extMapCache.putAll(extMap);
            this.getPageCache().put(this.getCurrentTabModel().getCacheKey() + UPDATEEXTMAP, SerializationUtils.toJsonString((Object)extMapCache));
        }
    }

    @Override
    protected void reFloatSheetHandle() {
        Sheet sheet = this.getEffectiveSheet();
        String spreadType = InvElimPaperGenerateService.getSpreadType((Sheet)sheet, (long)LongUtil.toLong((Object)this.getCurrentReportTabInfo().getTemplateId()));
        int floatCount = (Integer)sheet.getUserObject("inv_relation_count");
        Map<String, Long> filterMap = this.commonFilterMap();
        Long orgId = filterMap.get("bcm_entitymembertree");
        Long yearId = filterMap.get("bcm_fymembertree");
        Long periodId = filterMap.get("bcm_periodmembertree");
        Long sceneId = filterMap.get("bcm_scenemembertree");
        InvestFormulaContext context = new InvestFormulaContext(this.getModelId(), sceneId.longValue(), yearId.longValue(), periodId.longValue());
        context.setCslschemeId(Long.valueOf(OrgServiceHelper.getCslSchemeId((long)orgId)));
        context.setExecuteOrgId(orgId);
        InvestSpreadFormulaHandler formulaHandler = new InvestSpreadFormulaHandler(context);
        formulaHandler.floatSheetFormula(this.getSpreadModel(), orgId, spreadType, floatCount);
    }

    private void addSpreadStyle(String spreadType, int floatCount, int startCol, int startRow) {
        ArrayList<Map<String, Object>> contents = new ArrayList<Map<String, Object>>(10);
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
        invoker.setBatch(true);
        Map<String, Map<String, List<DynamicObject>>> categorized2RltNumber2Dy = this.categorized2RltNumber2DyMap();
        Collector collector = new Collector(80, new HashSet<Integer>(16));
        this.findCells(spreadType, floatCount, startCol, startRow, (QuadraConsumer<Cell, Cell, Cell, Cell>)((QuadraConsumer)(rltCell, orgCell, shareholderCell, investedCell) -> {
            this.setF7Type(invoker, (Cell)rltCell);
            this.setF7Type(invoker, (Cell)shareholderCell);
            this.lock(invoker, (Cell)shareholderCell);
            this.setF7Type(invoker, (Cell)investedCell);
            this.lock(invoker, (Cell)investedCell);
            this.showName((List<Map<String, Object>>)contents, (Cell)orgCell);
            this.showName((List<Map<String, Object>>)contents, (Cell)shareholderCell);
            this.showName((List<Map<String, Object>>)contents, (Cell)investedCell);
            if (rltCell != orgCell) {
                this.initRelationType(categorized2RltNumber2Dy, (Cell)rltCell);
                this.showRltName((List<Map<String, Object>>)contents, (Cell)rltCell);
                this.setF7Type(invoker, (Cell)rltCell);
                this.lock(invoker, (Cell)rltCell);
            }
            this.collectColNumAndCalColLength(collector, (Cell)rltCell, (Cell)orgCell, (Cell)shareholderCell, (Cell)investedCell);
        }), (Consumer<Cell>)((Consumer)cell -> contents.add(AdjustModelUtil.packedUpdateCellMap(cell.getRow(), cell.getCol(), cell.getValue()))));
        this.refresh2SpreadClient(collector, contents);
        invoker.startToInvoke();
    }

    private void refresh2SpreadClient(Collector collector, List<Map<String, Object>> contents) {
        if (!contents.isEmpty()) {
            Set<Integer> numSet = collector.getNumSet();
            Set zeroColumns = (Set)this.getEffectiveSheet().getUserObject(ZERO_COLUMNS);
            if (CollectionUtils.isNotEmpty((Collection)zeroColumns)) {
                numSet.removeAll(zeroColumns);
            }
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("index", numSet.toArray());
            map.put("num", collector.getLength());
            SpreadClientInvoker.invokeSetColumsWidthMethod(this.getClientViewProxy(), "report", map);
            SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), "report", contents);
            List lockCells = (List)this.getEffectiveSheet().getUserObject(LOCK_CELLS);
            if (CollectionUtils.isNotEmpty((Collection)lockCells)) {
                SpreadClientInvoker.invokeLockCellMethod(this.getClientViewProxy(), "report", lockCells);
                this.getEffectiveSheet().getUserObject().remove(LOCK_CELLS);
            }
        }
    }

    private void findCells(String spreadType, int floatCount, int startCol, int startRow, QuadraConsumer<Cell, Cell, Cell, Cell> headConsumer, Consumer<Cell> otherConsumer) {
        ArrayList<Integer> insertCols = new ArrayList<Integer>();
        Sheet sheet = this.getEffectiveSheet();
        int sheetHeadLength = this.getInvSheetHeadLength();
        if (!this.isFloatRow(spreadType)) {
            InvPaperSheetIteratorService iteratorService = new InvPaperSheetIteratorService(sheet, spreadType);
            int col = floatCount + startCol;
            if (floatCount != 0) {
                insertCols.add(col);
                this.frontInsertCols(insertCols);
                iteratorService.findHeadCells(this.anyNumber, col, (rltCell, orgCell, shareholderCell, investedCell, accCell) -> headConsumer.accept(rltCell, orgCell, shareholderCell, investedCell));
                for (int i = 0; i < sheet.getMaxRowCount(); ++i) {
                    if (i >= startRow && i < startRow + sheetHeadLength) continue;
                    Cell valueCell = sheet.getCell(i, col + 1);
                    otherConsumer.accept((Object)valueCell);
                    Cell oldCell = sheet.getCell(i, col);
                    otherConsumer.accept((Object)oldCell);
                }
            }
            iteratorService.findHeadCells(this.anyNumber, col + 1, (rltCell, orgCell, shareholderCell, investedCell, accCell) -> headConsumer.accept(rltCell, orgCell, shareholderCell, investedCell));
        } else {
            int row = floatCount + startRow;
            if (floatCount != 0) {
                insertCols.add(row);
                this.frontInsertRowsBottom(insertCols);
            }
            InvPaperSheetIteratorService iteratorService = new InvPaperSheetIteratorService(sheet, spreadType);
            iteratorService.findHeadCells(row + 1, this.anyNumber, (rltCell, orgCell, shareholderCell, investedCell, accCell) -> headConsumer.accept(rltCell, orgCell, shareholderCell, investedCell));
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (DELETE_CONFIRM\uff3fCALLBACK.equals(callBackId)) {
            if (!e.getResult().equals((Object)MessageBoxResult.Cancel)) {
                boolean isClearExtData = MessageBoxResult.Yes.equals((Object)e.getResult());
                this.getPageCache().put(CLEAR_EXT_DATA, Boolean.toString(isClearExtData));
                this.saveOp();
            }
        } else if (DELETE_SPREAD_DATA_CALLBACK.equals(callBackId)) {
            boolean isYes = MessageBoxResult.Yes.equals((Object)e.getResult());
            this.dealNullExtSetData(isYes);
            if (this.checkDeleteData()) {
                return;
            }
            this.saveOp();
        } else if ("datacollect_redirect".equals(callBackId) && MessageBoxResult.Yes == e.getResult()) {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setCustomParam("KEY_MODEL_ID", (Object)String.valueOf(this.getModelId()));
            parameter.setCustomParam(DimTypesEnum.SCENARIO.getNumber(), this.getCurrentReportCommonParam("id").get(DimTypesEnum.SCENARIO));
            parameter.setCustomParam(DimTypesEnum.YEAR.getNumber(), this.getCurrentReportCommonParam("id").get(DimTypesEnum.YEAR));
            parameter.setCustomParam(DimTypesEnum.PERIOD.getNumber(), this.getCurrentReportCommonParam("id").get(DimTypesEnum.PERIOD));
            parameter.setCustomParam(DimTypesEnum.ENTITY.getNumber(), this.getCurrentReportCommonParam("id").get(DimTypesEnum.ENTITY));
            parameter.setCustomParam("temIds", (Object)Sets.newHashSet((Object[])new Long[]{LongUtil.toLong((Object)this.getCurrentReportTabInfo().getTemplateId())}));
            parameter.setCustomParam("orgNumbers", (Object)Sets.newHashSet((Object[])new Object[]{this.getCurrentReportCommonParam(NUMBER).get(DimTypesEnum.ENTITY)}));
            parameter.setCustomParam("logtype", (Object)InvFormulaLogTypeEnum.InvSheetFormulaLog.getLogType());
            parameter.setFormId("bcm_datacollectlog_list");
            parameter.setBillFormId(InvFormulaLogTypeEnum.InvSheetFormulaLog.getLogEntity());
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.getOpenStyle().setTargetKey("_submaintab_");
            parameter.setCaption(ResManager.loadKDString((String)"\u6267\u884c\u65e5\u5fd7\u5217\u8868", (String)"InvLimSheetPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            parameter.setStatus(OperationStatus.EDIT);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private void dealNullExtSetData(boolean isYes) {
        String headIndexs = this.getPageCache().get(this.getCurrentTabModel().getCacheKey() + NOT_EXIST_EXT_SETVALUE);
        String[] indexs = headIndexs.split(",");
        String spreadType = InvElimPaperGenerateService.getSpreadType((Sheet)this.getEffectiveSheet(), (long)LongUtil.toLong((Object)this.getCurrentReportTabInfo().getTemplateId()));
        int startRow = (Integer)this.getEffectiveSheet().getUserObject(START_ROW);
        int startCol = (Integer)this.getEffectiveSheet().getUserObject(START_COL);
        int floatCount = (Integer)this.getEffectiveSheet().getUserObject("inv_relation_count");
        ArrayList contents = new ArrayList(10);
        Arrays.stream(indexs).forEach(index -> {
            Cell headCell;
            int extCellNo = Integer.parseInt(index);
            if (isYes) {
                if (!this.isFloatRow(spreadType)) {
                    this.getEffectiveSheet().iteratorRangeCells(extCellNo, extCellNo, startCol + 1, startCol + floatCount, cell -> {
                        cell.setValue(null);
                        contents.add(SpreadEasyInvoker.packedUpdateCellMap(cell.getRow(), cell.getCol(), null));
                    });
                } else {
                    this.getEffectiveSheet().iteratorRangeCells(startRow + 1, startRow + floatCount, extCellNo, extCellNo, cell -> {
                        cell.setValue(null);
                        contents.add(SpreadEasyInvoker.packedUpdateCellMap(cell.getRow(), cell.getCol(), null));
                    });
                }
            }
            Cell cell2 = headCell = !this.isFloatRow(spreadType) ? this.getEffectiveSheet().getCell(extCellNo, startCol) : this.getEffectiveSheet().getCell(startRow, extCellNo);
            if (Objects.nonNull(headCell)) {
                headCell.setValue(null);
                headCell.setFormula(null);
                headCell.clearAllUserObject();
                contents.add(SpreadEasyInvoker.packedUpdateCellMap(headCell.getRow(), headCell.getCol(), null));
            }
        });
        if (!contents.isEmpty()) {
            SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), "report", contents);
        }
        this.getPageCache().remove(this.getCurrentTabModel().getCacheKey() + NOT_EXIST_EXT_SETVALUE);
        this.getPageCache().remove(this.getCurrentTabModel().getCacheKey() + NOT_EXIST_EXT_SETVALUE_NUMBER);
        this.cacheSpreadModel();
    }

    @Override
    protected void clearDeleteListCache() {
        this.getPageCache().remove(this.getCurrentTabModel().getCacheKey() + DELETERELAS);
        this.getPageCache().remove(this.getCurrentTabModel().getCacheKey() + DELETEEXTS);
        this.getPageCache().remove(this.getCurrentTabModel().getCacheKey() + DELETECELLS);
        this.getPageCache().remove(this.getCurrentTabModel().getCacheKey() + UPDATEEXTMAP);
        this.getPageCache().remove(this.getCurrentTabModel().getCacheKey() + DATATYPE_MAP_CACHE);
    }

    private void calculate() {
        this.setNotifyFlag(false);
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u8ba1\u7b97\u4e2d\uff0c\u8bf7\u7a0d\u540e...", (String)"InvLimSheetPlugin_30", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        Multimap<String, Cell> number2Cells = this.getAndClearRltCellNumber();
        DynamicObject draft = BusinessDataServiceHelper.loadSingle((Object)this.getCurrentReportTabInfo().getReportId(), (String)"bcm_invlimsheetentity");
        InvestFormulaContext context = new InvestFormulaContext(this.getModelId(), draft.getLong("scenario.id"), draft.getLong("year.id"), draft.getLong("period.id"));
        DynamicObject scheme = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"cslscheme.id", (QFilter[])new QFilter("id", "=", (Object)draft.getLong("entity.id")).toArray());
        context.setCslschemeId(Long.valueOf(scheme != null ? scheme.getLong("cslscheme.id") : -1L));
        context.setMergeOrgId(Long.valueOf(draft.getLong("entity.id")));
        context.setExecuteOrgId(Long.valueOf(draft.getLong("entity.id")));
        InvestSpreadFormulaHandler formulaHandler = new InvestSpreadFormulaHandler(context);
        InvestFormulaLog.createLogPoint((String)InvFormulaLogTypeEnum.InvSheetFormulaLog.getLogType(), (long)context.getModelId(), (Long)context.getScenarioId(), (long)context.getFyId(), (long)context.getPeriodId(), (long)context.getMergeOrgId(), (long)LongUtil.toLong((Object)this.getCurrentReportTabInfo().getTemplateId()));
        QFBuilder qfBuilder = new QFBuilder("id", "=", (Object)LongUtil.toLong((Object)this.getCurrentReportTabInfo().getTemplateId()));
        DynamicObject template = QueryServiceHelper.queryOne((String)"bcm_papertemplate", (String)String.join((CharSequence)",", InvSheetTemplateConstant.getSelectFields()), (QFilter[])qfBuilder.toArray());
        formulaHandler.calculateSpreadManagerFormulas(Long.valueOf(draft.getLong("entity.id")), this.getSpreadModel(), new InvFormulaParam(template.getString("process.number")));
        int errorLogSize = InvestFormulaLog.getDetailLogMsgList().size();
        InvestFormulaLog.removeLogPoint();
        number2Cells.forEach((number, cell) -> cell.setUserObject(NUMBER, number));
        super.updateClientSpreadValues();
        InvElimPaperGenerateService generateService = new InvElimPaperGenerateService(Long.valueOf(context.getModelId()), Long.valueOf(context.getScenarioId()), Long.valueOf(context.getFyId()), Long.valueOf(context.getPeriodId()), context.getMergeOrgId(), InvLimSheetLogConstant.Operation.ACCESS);
        generateService.saveExtData(template, this.getSpreadModel());
        generateService.saveLog();
        this.setCalculate(true);
        this.getView().hideLoading();
        String operation = ResManager.loadKDString((String)"\u6267\u884c\u53d6\u6570", (String)"InvLimSheetPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u6267\u884c\u53d6\u6570", "InvLimSheetPlugin_31", "fi-bcm-formplugin", "executeDataFetch");
        this.writeOperationLog(opName, ResultStatusEnum.SUCCESS.getName());
        if (errorLogSize > 0) {
            ArrayList<MessageBoxLink> msgLinkList = new ArrayList<MessageBoxLink>();
            MessageBoxLink msgLink = new MessageBoxLink();
            msgLink.setText(ResManager.loadKDString((String)"\u70b9\u51fb\u6b64\u5904\u8df3\u8f6c", (String)"InvLimSheetPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            msgLink.setValue("clickthis");
            msgLinkList.add(msgLink);
            String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5e95\u7a3f\u5b58\u5728%s\u4e2a\u53d6\u6570\u5931\u8d25\u7684\u516c\u5f0f\uff0c\u662f\u5426\u8df3\u8f6c\u53d6\u6570\u65e5\u5fd7\u754c\u9762\u8fdb\u884c\u67e5\u770b\uff1f", (String)"InvLimSheetPlugin_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]), errorLogSize);
            this.getView().showConfirm(msg, msgLinkList, MessageBoxOptions.YesNo, ConfirmTypes.Wait, new ConfirmCallBackListener("datacollect_redirect", (IFormPlugin)this));
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u53d6\u6570\u6210\u529f\u3002", (String)"InvLimSheetPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private Multimap<String, Cell> getAndClearRltCellNumber() {
        ArrayListMultimap number2Cells = ArrayListMultimap.create();
        String spreadType = InvElimPaperGenerateService.getSpreadType((Sheet)this.getEffectiveSheet(), (long)LongUtil.toLong((Object)this.getCurrentReportTabInfo().getTemplateId()));
        int floatCount = (Integer)this.getEffectiveSheet().getUserObject("inv_relation_count");
        int startCol = (Integer)this.getEffectiveSheet().getUserObject(START_COL);
        int startRow = (Integer)this.getEffectiveSheet().getUserObject(START_ROW);
        for (int i = 1; i < floatCount + 1; ++i) {
            InvPaperSheetIteratorService iteratorService = new InvPaperSheetIteratorService(this.getEffectiveSheet(), spreadType);
            if (!this.isFloatRow(spreadType)) {
                iteratorService.findHeadCells(this.anyNumber, startCol + i, (arg_0, arg_1, arg_2, arg_3, arg_4) -> InvLimSheetPlugin.lambda$getAndClearRltCellNumber$46((Multimap)number2Cells, arg_0, arg_1, arg_2, arg_3, arg_4));
                continue;
            }
            iteratorService.findHeadCells(startRow + 1, this.anyNumber, (arg_0, arg_1, arg_2, arg_3, arg_4) -> InvLimSheetPlugin.lambda$getAndClearRltCellNumber$49((Multimap)number2Cells, arg_0, arg_1, arg_2, arg_3, arg_4));
        }
        return number2Cells;
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
    }

    private void beforeShowFormulaView() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("callback", "invokeAction");
        params.put("invokemethod", "showFormulaView");
        SpreadClientInvoker.invokeGetSpreadJsonMethod(this.getClientViewProxy(), "report", params);
    }

    public void showFormulaView(String json) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_sheetformula_view");
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("sm", (Object)JsonSerializerUtil.toJson((SpreadManager)this.getSpreadModel()));
        formShowParameter.setCustomParam("json", (Object)json);
        long orgId = TreeStructureServiceHelper.getEntityBaseMemberId((long)Long.parseLong(this.getCurrentReportCommonParam4StringKey("id").get(DimTypesEnum.ENTITY.getNumber()).toString()));
        formShowParameter.setCustomParam("orgid", (Object)Long.toString(orgId));
        formShowParameter.setCustomParam("draftid", (Object)String.valueOf(this.getCurrentReportTabInfo().getReportId()));
        formShowParameter.setCustomParam("modelNumber", (Object)this.getModelNumber());
        formShowParameter.setCustomParam("period", this.getCurrentReportCommonParam(NUMBER).get(DimTypesEnum.PERIOD));
        formShowParameter.setCustomParam("year", this.getCurrentReportCommonParam(NUMBER).get(DimTypesEnum.YEAR));
        formShowParameter.setCustomParam("reportStatus", (Object)this.getCurrentReportStatus());
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_sheetformula_view"));
        this.getView().showForm(formShowParameter);
    }

    @Override
    protected SheetTabModel getCurrentTabModel() {
        SheetTabModel sheetTabModel = super.getCurrentTabModel();
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(sheetTabModel.getModelid()));
        return sheetTabModel;
    }

    private void restoreNoDataRowCol() {
        String col;
        String row = this.getPageCache().get("hiderow");
        if (row != null) {
            List hideRow = (List)SerializationUtils.fromJsonString((String)row, List.class);
            SpreadEasyInvoker.setRowsVisble(this.getClientViewProxy(), "report", hideRow.stream().mapToInt(Integer::intValue).toArray(), true);
        }
        if ((col = this.getPageCache().get("hidecol")) != null) {
            List hideCol = (List)SerializationUtils.fromJsonString((String)col, List.class);
            SpreadEasyInvoker.setColumnVisble(this.getClientViewProxy(), "report", hideCol.stream().mapToInt(Integer::intValue).toArray(), true);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ThreadCache.put((Object)"needCheckPerm", (Object)true);
        if (this.isMockCreateNewData()) {
            return;
        }
        String postmanSerial = (String)this.getFormCustomParam("reportpostman");
        if (StringUtils.isEmpty((String)postmanSerial)) {
            throw new KDBizException("not found ReportPostman Info!");
        }
        AbstractReportPostman postman = (AbstractReportPostman)this.deSerializedBytes(postmanSerial);
        this.initReportTabEnv(postman);
        ArrayList<Map> menuItems = new ArrayList<Map>(10);
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.copy, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.cut, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.clearContents, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertColumns, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertRows, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertColMany, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertRowMany, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        SpreadClientInvoker.invokeHideContextMenuItems(this.getClientViewProxy(), this.getSpreadKey(), menuItems);
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
        invoker.addContextMenuItem("linkAdjust", ResManager.loadKDString((String)"\u8054\u67e5\u5206\u5f55", (String)"InvLimSheetPlugin_35", (String)"fi-bcm-formplugin", (Object[])new Object[0]), new String[]{"viewport"});
        invoker.startToInvoke();
    }

    private void changeDisplay() {
        SheetTabModel draft = this.getCurrentTabModel();
        this.buildRowData(draft, this.getSpreadModel());
    }

    private void buildSingleCellData(List<Map<String, Object>> cellValues, Cell cell, String name, String number) {
        String showType = this.getShowtype();
        int rowNum = cell.getRow();
        int colNum = cell.getCol();
        String displayContent = name;
        if ("btn_row_number".equalsIgnoreCase(showType)) {
            displayContent = number;
        } else if ("btn_row_numname".equalsIgnoreCase(showType)) {
            displayContent = number + " " + name;
        }
        cell.setValue((Object)displayContent);
        cellValues.add(this.packedUpdateCellMap(rowNum, colNum, displayContent));
    }

    @Override
    public void buildRowData(SheetTabModel draft, SpreadManager spreadManager) {
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>();
        Sheet sheet = spreadManager.getBook().getSheet(0);
        String spreadType = InvElimPaperGenerateService.getSpreadType((Sheet)sheet, (long)LongUtil.toLong((Object)this.getCurrentReportTabInfo().getTemplateId()));
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
        invoker.setBatch(true);
        Map<String, Map<String, List<DynamicObject>>> categorized2RltNumber2Dy = this.categorized2RltNumber2DyMap();
        InvPaperSheetIteratorService invPaperSheetIteratorService = new InvPaperSheetIteratorService(sheet, spreadType);
        invPaperSheetIteratorService.iterationAccCell(cell -> this.showName((List<Map<String, Object>>)cellValues, (Cell)cell));
        Collector collector = new Collector(80, new HashSet<Integer>(16));
        String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
        Map<String, Long> filterMap = this.commonFilterMap();
        Long orgId = filterMap.get("bcm_entitymembertree");
        invPaperSheetIteratorService.iterationRelationCell((rltCell, orgCell, shareholderCell, investedCell) -> {
            this.showName((List<Map<String, Object>>)cellValues, (Cell)orgCell);
            this.showName((List<Map<String, Object>>)cellValues, (Cell)shareholderCell);
            this.showName((List<Map<String, Object>>)cellValues, (Cell)investedCell);
            this.setF7Type(invoker, (Cell)shareholderCell);
            this.setF7Type(invoker, (Cell)investedCell);
            this.lock(invoker, (Cell)orgCell);
            this.lock(invoker, (Cell)shareholderCell);
            this.lock(invoker, (Cell)investedCell);
            this.refreshRelationOrgId(modelNum, (Cell)shareholderCell, (Cell)investedCell);
            if (rltCell != orgCell) {
                this.initRelationType(categorized2RltNumber2Dy, (Cell)rltCell);
                this.showRltName((List<Map<String, Object>>)cellValues, (Cell)rltCell);
                this.setF7Type(invoker, (Cell)rltCell);
                this.lock(invoker, (Cell)rltCell);
            }
            this.collectColNumAndCalColLength(collector, (Cell)rltCell, (Cell)orgCell, (Cell)shareholderCell, (Cell)investedCell);
        });
        this.refresh2SpreadClient(collector, cellValues);
        invoker.startToInvoke();
    }

    private void refreshRelationOrgId(String modelNum, Cell shareholderCell, Cell investedCell) {
        Object investedNumber = investedCell.getUserObject(NUMBER);
        Object shareholderNumber = shareholderCell.getUserObject(NUMBER);
        if (Objects.isNull(investedNumber) || Objects.isNull(shareholderNumber)) {
            String msg = String.format(ResManager.loadKDString((String)"%1$s\u5bf9%2$s\u7684\u6295\u8d44\uff0c\u6295\u8d44\u5173\u7cfb\u5f02\u5e38\u3002", (String)"InvLimSheetPlugin_36", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ExcelUtils.xy2Pos((int)shareholderCell.getRow(), (int)shareholderCell.getCol()), ExcelUtils.xy2Pos((int)investedCell.getRow(), (int)investedCell.getCol()));
            this.getView().showTipNotification(msg);
            return;
        }
        IDNumberTreeNode investedMember = MemberReader.findEntityMemberByNum((String)modelNum, (String)investedNumber.toString());
        IDNumberTreeNode shareholderMember = MemberReader.findMemberByNumber((String)modelNum, (String)DimEntityNumEnum.INTERCOMPANY.getNumber(), (String)shareholderNumber.toString());
        if (investedMember != IDNumberTreeNode.NotFoundTreeNode) {
            investedCell.setUserObject("id", (Object)investedMember.getId());
        }
        if (shareholderMember != IDNumberTreeNode.NotFoundTreeNode) {
            shareholderCell.setUserObject("id", (Object)shareholderMember.getId());
        }
    }

    private void collectColNumAndCalColLength(Collector collector, Cell rltCell, Cell orgCell, Cell shareholderCell, Cell investedCell) {
        Set<Integer> numSet = collector.getNumSet();
        numSet.add(rltCell.getCol());
        numSet.add(orgCell.getCol());
        numSet.add(shareholderCell.getCol());
        numSet.add(investedCell.getCol());
        Integer length = collector.getLength();
        length = Math.max(length, this.calLength(StringUtils.getStringValue((Object)rltCell.getValue())));
        length = Math.max(length, this.calLength(StringUtils.getStringValue((Object)orgCell.getValue())));
        length = Math.max(length, this.calLength(StringUtils.getStringValue((Object)shareholderCell.getValue())));
        length = Math.max(length, this.calLength(StringUtils.getStringValue((Object)investedCell.getValue())));
        collector.setLength(length);
    }

    private int calLength(String source) {
        if (Objects.isNull(source)) {
            return 0;
        }
        int length = 0;
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (Character.UnicodeBlock.of(c) == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS) {
                length += 10;
                continue;
            }
            length += 6;
        }
        return length;
    }

    private Map<String, Map<String, List<DynamicObject>>> categorized2RltNumber2DyMap() {
        Long templateId = LongUtil.toLong((Object)this.getCurrentReportTabInfo().getTemplateId());
        List orDefault = PaperTemplateService.buildTemp2RelationBy((Set)Sets.newHashSet((Object[])new Long[]{templateId})).getOrDefault(templateId, new ArrayList());
        return orDefault.stream().collect(Collectors.groupingBy(e -> e.getString("invrelationtype.fbasedataid.categorized"), Collectors.groupingBy(e -> e.getString("invrelationtype.fbasedataid.number"))));
    }

    private void initRelationType(Map<String, Map<String, List<DynamicObject>>> collect, Cell rltCell) {
        Object categorized = rltCell.getUserObject(InvRelationTypeConstant.CatalogEnum.class.getSimpleName());
        Object rltNumber = rltCell.getUserObject(InvRelaTypeEnum.class.getSimpleName());
        if (Objects.isNull(categorized) || Objects.isNull(rltNumber)) {
            return;
        }
        List dynamicObjects = collect.getOrDefault(categorized, Collections.emptyMap()).getOrDefault(rltNumber, Collections.emptyList());
        if (!dynamicObjects.isEmpty()) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(0);
            rltCell.setUserObject("id", (Object)dynamicObject.getLong("invrelationtype.fbasedataid"));
            rltCell.setUserObject(NAME, (Object)dynamicObject.getString("invrelationtype.fbasedataid.name"));
            rltCell.setUserObject(NUMBER, (Object)dynamicObject.getString("invrelationtype.fbasedataid.number"));
        }
    }

    private void lock(SpreadEasyInvoker invoker, Cell cell) {
        int col = cell.getCol();
        int row = cell.getRow();
        invoker.lockCell(row, col, 1, 1);
    }

    private void setF7Type(SpreadEasyInvoker invoker, Cell cell) {
        int col = cell.getCol();
        int row = cell.getRow();
        invoker.setF7TypeCell(row, col, 1, 1, 0, 0);
    }

    private void showName(List<Map<String, Object>> cellValues, Cell cell) {
        UserObject userObject = cell.getUserObject();
        if (userObject != null && !userObject.isEmpty() && userObject.containsKey((Object)NAME) && userObject.containsKey((Object)NUMBER)) {
            String hdname = userObject.get((Object)NAME).toString();
            String hdnumber = userObject.get((Object)NUMBER).toString();
            this.buildSingleCellData(cellValues, cell, hdname, hdnumber);
        }
    }

    private void showRltName(List<Map<String, Object>> contents, Cell rltCell) {
        UserObject userObject = rltCell.getUserObject();
        if (userObject != null && !userObject.isEmpty() && userObject.containsKey((Object)NAME)) {
            String name = userObject.get((Object)NAME).toString();
            rltCell.setValue((Object)name);
            contents.add(this.packedUpdateCellMap(rltCell.getRow(), rltCell.getCol(), name));
        }
    }

    @Override
    public void spreadF7Click(int row, int col) {
        int startCol = (Integer)this.getEffectiveSheet().getUserObject(START_COL);
        int startRow = (Integer)this.getEffectiveSheet().getUserObject(START_ROW);
        String spreadType = InvElimPaperGenerateService.getSpreadType((Sheet)this.getEffectiveSheet(), (long)LongUtil.toLong((Object)this.getCurrentReportTabInfo().getTemplateId()));
        if (!this.isFloatRow(spreadType) && row == startRow + 1 || this.isFloatRow(spreadType) && col == startCol + 1) {
            this.openF7(DimTypesEnum.INTERCOMPANY.getNumber(), null);
        } else if (!this.isFloatRow(spreadType) && row == startRow + 2 || this.isFloatRow(spreadType) && col == startCol + 2) {
            this.openF7(DimTypesEnum.ENTITY.getNumber(), this.getInvestCompanyFilter());
        }
    }

    private void openF7(String dimNubmer, QFilter filters) {
        DynamicObject dimObj = BusinessDataServiceHelper.loadSingle((String)"bcm_dimension", (String)"id,number,name,dseq,membermodel,fieldmapped", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()).and(NUMBER, "=", (Object)dimNubmer)});
        BasedataEditSingleMemberF7 f7 = SingleMemberF7Util.createBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), dimObj.getLong("id"), CELL_F7, null, true, SingleF7TypeEnum.LEAF);
        f7.setF7title(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9", (String)"InvLimSheetPlugin_37", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        f7.setCallBackClassName(this.getClass().getName());
        if (filters != null) {
            f7.setCustomFilter(filters);
            HashMap<String, Object> customData = new HashMap<String, Object>(16);
            customData.put("isShowCslScheme", "0");
            f7.setCustomData(customData);
        }
        f7.click();
    }

    private QFilter getInvestCompanyFilter() {
        Map<String, Long> filterMap = this.commonFilterMap();
        Long unitorgId = filterMap.get("bcm_entitymembertree");
        DynamicObject unitOrgDy = BusinessDataServiceHelper.loadSingle((Object)unitorgId, (String)"bcm_entitymembertree");
        QFilter qFilters = new QFilter("model", "=", (Object)this.getModelId());
        qFilters.and(new QFilter("cslscheme", "=", (Object)unitOrgDy.getLong("cslscheme.id")));
        qFilters.and(new QFilter("longnumber", "like", (Object)(unitOrgDy.getString("longnumber") + "%")));
        return qFilters;
    }

    @Override
    public void spreadF7LookUpData(LookUpDataArgs args) {
        int col = args.getC();
        int row = args.getR();
        int startCol = (Integer)this.getEffectiveSheet().getUserObject(START_COL);
        int startRow = (Integer)this.getEffectiveSheet().getUserObject(START_ROW);
        String spreadType = InvElimPaperGenerateService.getSpreadType((Sheet)this.getEffectiveSheet(), (long)LongUtil.toLong((Object)this.getCurrentReportTabInfo().getTemplateId()));
        long modelId = this.getModelId();
        String dimnum = "";
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        if (!this.isFloatRow(spreadType) && row == startRow + 1 || this.isFloatRow(spreadType) && col == startCol + 1) {
            dimnum = DimTypesEnum.INTERCOMPANY.getNumber();
        } else if (!this.isFloatRow(spreadType) && row == startRow + 2 || this.isFloatRow(spreadType) && col == startCol + 2) {
            dimnum = DimTypesEnum.ENTITY.getNumber();
            qFilter.and(this.getInvestCompanyFilter());
        }
        DynamicObject dimObj = BusinessDataServiceHelper.loadSingle((String)"bcm_dimension", (String)"id,number,name,dseq,membermodel,fieldmapped", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()).and(NUMBER, "=", (Object)dimnum)});
        String entity = dimObj.getString("membermodel");
        qFilter.and("dimension.number", "=", (Object)dimnum);
        Map<String, Long> filterMap = this.commonFilterMap();
        Long yearId = filterMap.get("bcm_fymembertree");
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode yearMember = MemberReader.findFyMemberById((String)modelNumber, (Long)yearId);
        String yearNum = yearMember == IDNumberTreeNode.NotFoundTreeNode ? null : yearMember.getNumber();
        Long periodId = filterMap.get("bcm_periodmembertree");
        Long sceneId = filterMap.get("bcm_scenemembertree");
        SpreadUtils.spreadF7lookUpData(this.getClientViewProxy(), this.getSpreadKey(), entity, dimnum, args, modelId, qFilter, yearNum, String.valueOf(periodId), false, String.valueOf(sceneId), true);
    }

    public void setSpreadF7Item(F7ItemFillBackArgs arg) {
        Cell cell = this.getEffectiveSheet().getCell(arg.getR(), arg.getC());
        cell.setUserObject(NUMBER, (Object)arg.getNumber());
        cell.setUserObject("id", (Object)arg.getId());
        cell.setUserObject(NAME, (Object)arg.getName());
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>(16);
        this.buildSingleCellData(cellValues, cell, arg.getName(), arg.getNumber());
        if (!cellValues.isEmpty()) {
            SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), "report", cellValues);
        }
        this.setModified(true);
        this.cacheSpreadModel();
    }

    private String getShowtype() {
        String tabid = this.getPageCache().get("tabkey_selected");
        String showtype = this.getPageCache().get(CACHE_SHOWTYPE + tabid);
        if (showtype == null) {
            Object wbShowType = this.getEffectiveSheet().getUserObject("wb_showType");
            showtype = wbShowType != null ? wbShowType.toString() : "btn_row_numname";
            this.cacheShowtype(tabid, showtype);
        }
        return showtype;
    }

    private void cacheShowtype(String showtype) {
        String tabid = this.getPageCache().get("tabkey_selected");
        this.cacheShowtype(tabid, showtype);
    }

    private void cacheShowtype(String tabid, String showtype) {
        this.getPageCache().put(CACHE_SHOWTYPE + tabid, showtype);
    }

    public void setCalculate(Boolean calculate) {
        this.isCalculate = calculate;
    }

    public void linkAdjust() {
        super.checkPerm("btn_linkadjust", this.getView().getEntityId());
        String selectorRect = this.getSelectorRect();
        String[] split = selectorRect.split(":");
        if (!split[0].equals(split[1])) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u533a\u57df\u5185\u5355\u4e2a\u5355\u5143\u683c\u518d\u8054\u67e5\u3002", (String)"InvLimSheetPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        int rowNumber = this.getSelectorStartRow();
        int colNumber = this.getSelectorStartCol();
        int startCol = (Integer)this.getEffectiveSheet().getUserObject(START_COL);
        int startRow = (Integer)this.getEffectiveSheet().getUserObject(START_ROW);
        int floatCount = (Integer)this.getEffectiveSheet().getUserObject("inv_relation_count");
        String spreadtype = InvElimPaperGenerateService.getSpreadType((Sheet)this.getEffectiveSheet(), (long)LongUtil.toLong((Object)this.getCurrentReportTabInfo().getTemplateId()));
        boolean isFloatRow = spreadtype.equals(InvSheetTemplateConstant.SpreadTypeEnum.FLOAT_ROW.getCode());
        PositionInfo p = new PositionInfo(this.getEffectiveSheet(), isFloatRow);
        Cell selectCell = this.getEffectiveSheet().getCell(rowNumber, colNumber);
        if (colNumber < p.formulaStartCol() || rowNumber < p.formulaStartRow() || colNumber >= p.formulaStartCol() + floatCount || rowNumber > p.endRow() || selectCell.getValue() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u533a\u57df\u5185\u6709\u6548\u7684\u5355\u5143\u683c\u518d\u8054\u67e5\u3002", (String)"InvLimSheetPlugin_39", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        SheetTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
        Object linkId = selectCell.getUserObject("eid");
        Set<Long> sheetEntrys = new HashSet<Long>(16);
        boolean isCheckRecord = false;
        if (linkId != null) {
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bcm_linkadjust_mapping", (String)"id,elim,elimentry", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()).and("linkid", "=", linkId).and("biztype", "=", (Object)"1")});
            if (dynamicObjects != null) {
                sheetEntrys = Arrays.stream(dynamicObjects).filter(Objects::nonNull).map(dy -> dy.getLong("elim.id")).collect(Collectors.toSet());
            }
        } else if (!selectCell.isChangeVal()) {
            sheetEntrys = this.getOldElimIDs(tab, rowNumber, colNumber, startCol, startRow);
            isCheckRecord = true;
        }
        if (sheetEntrys.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684\u5206\u5f55\u6570\u636e\uff0c\u8054\u67e5\u5931\u8d25\u3002", (String)"InvLimSheetPlugin_40", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.openAdjustPage(tab, sheetEntrys, isCheckRecord);
    }

    private Set<Long> getOldElimIDs(SheetTabInfo tab, int rowNumber, int colNumber, int startCol, int startRow) {
        DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)LongUtil.toLong((Object)tab.getTemplateId()), (String)"bcm_papertemplate");
        String spreadType = template == null ? "1" : template.getString(SPREADTYPE);
        Cell extDimCell = spreadType.equals(InvSheetTemplateConstant.SpreadTypeEnum.FLOAT_COL.getCode()) ? this.getEffectiveSheet().getCell(rowNumber, startCol) : this.getEffectiveSheet().getCell(startRow, colNumber);
        Long extdimid = LongUtil.toLong((Object)extDimCell.getUserObject("id"));
        HashSet<Long> sheetEntrys = new HashSet<Long>(16);
        if (extdimid != 0L && template != null) {
            Map entrys = BusinessDataServiceHelper.loadFromCache((String)"bcm_invsheetttplentrys", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()).and("sheettemplate.id", "=", (Object)template.getLong("id"))});
            entrys.forEach((key, dy) -> {
                DynamicObjectCollection dynamicObjectCollection = dy.getDynamicObjectCollection("invelimtplentry");
                dynamicObjectCollection.forEach(entry -> {
                    Long exprId;
                    String ruleexpr = (String)entry.get("ruleexpr");
                    String ruleexprdept = (String)entry.get("ruleexprdept");
                    if (!StringUtils.isBlank((String)ruleexpr) && ruleexpr.equals("bn") || !StringUtils.isBlank((String)ruleexprdept) && ruleexprdept.equals("bn")) {
                        return;
                    }
                    Long l = exprId = LongUtil.toLong((Object)ruleexpr) == 0L ? LongUtil.toLong((Object)ruleexprdept) : LongUtil.toLong((Object)ruleexpr);
                    if (extdimid.compareTo(exprId) == 0) {
                        sheetEntrys.add(dy.getLong("id"));
                    }
                });
            });
        }
        return sheetEntrys;
    }

    private void openAdjustPage(SheetTabInfo tab, Set<Long> sheetEntrys, boolean isCheckRecord) {
        Long modelId = this.getModelId();
        Map<String, Long> filterMap = this.commonFilterMap();
        Long orgId = filterMap.get("bcm_entitymembertree");
        Long yearId = filterMap.get("bcm_fymembertree");
        Long periodId = filterMap.get("bcm_periodmembertree");
        Long sceneId = filterMap.get("bcm_scenemembertree");
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode entityMember = MemberReader.findEntityMemberById((String)modelNumber, (Long)orgId);
        QFBuilder tempQF = new QFBuilder("model", "=", (Object)modelId);
        tempQF.add("scenario", "=", (Object)sceneId);
        tempQF.add("year", "=", (Object)yearId);
        tempQF.add("period", "=", (Object)periodId);
        tempQF.add("entity.number", "=", (Object)entityMember.getNumber());
        if (isCheckRecord) {
            tempQF.add("checkrecord", "in", sheetEntrys);
        } else {
            tempQF.add("id", "in", sheetEntrys);
        }
        DynamicObjectCollection adjusts = QueryServiceHelper.query((String)"bcm_rptadjust", (String)"id", (QFilter[])tempQF.toArray());
        if (!adjusts.isEmpty()) {
            IFormView parentView;
            List idList = adjusts.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            IFormView mainPageView = this.getView().getMainView();
            for (parentView = this.getView().getParentView(); parentView != null && !parentView.getEntityId().equals("bcm_apphome"); parentView = parentView.getParentView()) {
            }
            Collections.sort(idList);
            String menuPageID = String.format("invsheet_to_rptadjust_%s", adjusts.stream().map(e -> e.getString("id")).collect(Collectors.joining("_")).hashCode());
            if (mainPageView == null || mainPageView.getView(menuPageID) == null) {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setPageId(menuPageID);
                parameter.setCustomParam("enterType", (Object)"invView");
                parameter.setCustomParam("selectedOrgid", (Object)orgId);
                parameter.setCustomParam("modelId", (Object)modelId);
                parameter.setCustomParam("scenarioId", (Object)sceneId);
                parameter.setCustomParam(YEAR_ID, (Object)yearId);
                parameter.setCustomParam("perioId", (Object)periodId);
                parameter.setCustomParam("adjustIds", idList);
                parameter.setFormId("bcm_rptadjust_list");
                parameter.setCaption(String.format(ResManager.loadKDString((String)"\u8054\u67e5\uff1a%s", (String)"InvLimSheetPlugin_41", (String)"fi-bcm-formplugin", (Object[])new Object[0]), entityMember.getName()));
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(parameter);
                if (parentView == null) {
                    this.getView().showForm(parameter);
                } else {
                    parameter.setParentPageId(parentView.getPageId());
                    parameter.setParentFormId(parentView.getEntityId());
                    parentView.showForm(parameter);
                    this.getView().sendFormAction(parentView);
                }
            } else {
                IFormView childFormView = mainPageView.getView(menuPageID);
                childFormView.activate();
                this.getView().sendFormAction(childFormView);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684\u5206\u5f55\u6570\u636e\uff0c\u8054\u67e5\u5931\u8d25\u3002", (String)"InvLimSheetPlugin_40", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    protected void updateClientSpreadValues() {
        DynamicObject template = QueryServiceHelper.queryOne((String)"bcm_papertemplate", (String)String.join((CharSequence)",", InvSheetTemplateConstant.getSelectFields()), (QFilter[])new QFBuilder("id", "=", (Object)LongUtil.toLong((Object)this.getCurrentReportTabInfo().getTemplateId())).toArray());
        if (Objects.isNull(template)) {
            super.updateClientSpreadValues();
            return;
        }
        if (!this.getEffectiveSheet().getUserObject().containsKey("NEWDATA_2.0")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e95\u7a3f\u672a\u5347\u7ea7\uff0c\u8bf7\u70b9\u51fb\u201c\u5347\u7ea7\u62d3\u5c55\u6a21\u578b\u201d\u5b8c\u6210\u5347\u7ea7\u3002", (String)"InvLimSheetPlugin_43", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(this.getCurrentTabModel().getCacheKey() + "extdimid", String.valueOf(template.getLong("extdimid")));
        InvEDResultCellTable calValueTable = this.getCalValueTable(template);
        Pair<Long, String> belongOrgPair = this.getRealOrgInfo();
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>();
        Sheet effectiveSheet = this.getEffectiveSheet();
        InvPaperSheetIteratorService invPaperSheetIteratorService = new InvPaperSheetIteratorService(effectiveSheet, InvElimPaperGenerateService.getSpreadType((Sheet)effectiveSheet, (long)template.getLong("id")));
        invPaperSheetIteratorService.iterationValueCellAxis((rltCell, orgCell, shareholderCell, investedCell, accCell, valueCell) -> {
            this.formulaCellRemoveValue((Cell)valueCell);
            String shareholder = (String)shareholderCell.getUserObject(NUMBER);
            String investOrg = (String)investedCell.getUserObject(NUMBER);
            String unitOrg = (String)orgCell.getUserObject(NUMBER);
            String relationType = this.getRelationType(PaperTemplateService.getDefaultRelationTypeNumber((Long)template.getLong("id")), (Cell)rltCell, shareholder, investOrg);
            String categorized = InvElimSpreadGenerateService.getCategorized((Cell)rltCell);
            String accNum = (String)accCell.getUserObject(NUMBER);
            if (Objects.nonNull(shareholder) && Objects.nonNull(investOrg) && Objects.nonNull(accNum)) {
                Long pkId;
                Pair valuePair = calValueTable.getValuePair(new ExtendExtUniqueKey(accNum, (String)belongOrgPair.p2, unitOrg, shareholder, investOrg, relationType, categorized));
                Object value = valuePair == null ? null : valuePair.p2;
                Long l = pkId = valuePair == null ? null : (Long)valuePair.p1;
                if (ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)ConfigEnum.CM015.getNumber()) && value instanceof BigDecimal && BigDecimal.ZERO.compareTo((BigDecimal)value) == 0) {
                    value = null;
                }
                HashMap<String, Object> e = new HashMap<String, Object>(3);
                e.put("r", valueCell.getRow());
                e.put("c", valueCell.getCol());
                value = Objects.isNull(value) && Objects.nonNull(valueCell.getUserObject("formula_fail")) ? valueCell.getUserObject("fp") : value;
                e.put("v", value);
                valueCell.setValue(value);
                valueCell.setUserObject("eid", (Object)pkId);
                cellValues.add(e);
                valueCell.setChangeVal(false);
            } else if (valueCell.isChangeVal() || valueCell.hasFormula()) {
                Object value = valueCell.getValue();
                if (ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)ConfigEnum.CM015.getNumber()) && value instanceof BigDecimal && BigDecimal.ZERO.compareTo((BigDecimal)value) == 0) {
                    value = null;
                }
                HashMap<String, Object> e = new HashMap<String, Object>(3);
                e.put("r", valueCell.getRow());
                e.put("c", valueCell.getCol());
                e.put("v", value);
                cellValues.add(e);
                valueCell.setChangeVal(false);
            }
        });
        this.changeCellValueDisplayByUnit(cellValues);
        if (!cellValues.isEmpty()) {
            SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), "report", cellValues);
            this.cacheSpreadModel();
        } else {
            super.updateClientSpreadValues();
        }
    }

    private void formulaCellRemoveValue(Cell valueCell) {
        if (Objects.isNull(valueCell.getUserObject("isChanged")) && valueCell.hasFormula() && Objects.isNull(valueCell.getUserObject("ff"))) {
            valueCell.setValue(null);
        }
    }

    private String getRelationType(String relationTypeFromPaper, Cell rltCell, Object shareholder, Object investOrg) {
        return InvElimPaperGenerateService.getRelationType((String)relationTypeFromPaper, (Cell)rltCell, (Object)shareholder, (Object)investOrg);
    }

    private InvEDResultCellTable getCalValueTable(DynamicObject template) {
        String dataModel = template.getString("extdimid.number");
        if (Objects.isNull(dataModel)) {
            return new InvEDResultCellTable();
        }
        long modelId = this.getModelId();
        long extModelId = template.getLong("extdimid");
        DynamicObject extModel = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"id,number,extendsgroup.id,extendsgroup.number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)extModelId)});
        if (extModel == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e95\u7a3f\u5bf9\u5e94\u7684\u6a21\u677f\u6ca1\u6709\u5173\u8054\u6570\u636e\u6a21\u578b\u3002", (String)"InvLimSheetPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        Map<DimTypesEnum, Object> numbers = this.getCurrentReportCommonParam(NUMBER);
        String extGroup = extModel.getString("extendsgroup.number");
        EdQueryComInfo edQueryComInfo = new EdQueryComInfo(MemberReader.findModelSNumberById((Object)modelId), extGroup, dataModel);
        edQueryComInfo.setExtselects(InvExtDataConstant.getSelectField());
        edQueryComInfo.addDimFilter("Scenario", new String[]{(String)numbers.get(DimTypesEnum.SCENARIO)});
        edQueryComInfo.addDimFilter("Year", new String[]{(String)numbers.get(DimTypesEnum.YEAR)});
        edQueryComInfo.addDimFilter("Period", new String[]{(String)numbers.get(DimTypesEnum.PERIOD)});
        edQueryComInfo.addFilter("org", new Object[]{this.getRealOrgInfo().p2});
        return InvExtDataServiceHelper.getCalValueTable((EdQueryComInfo)edQueryComInfo);
    }

    @Override
    protected Object[] saveReportRecord(String spreadJson, DynamicObject invLimSheetEntity, boolean isSaveRecord) {
        Object[][] result = new Object[1][1];
        PlatUtil.executeWithTX(tx -> {
            this.saveExtData();
            result[0][0] = super.saveReportRecord(spreadJson, invLimSheetEntity, isSaveRecord);
        });
        return result[0];
    }

    @Override
    protected void afterSaveReportData() {
        super.afterSaveReportData();
        this.clearDeleteListCache();
    }

    private void saveExtData() {
        long modelId = this.getModelId();
        Map<String, Long> filterMap = this.commonFilterMap();
        Long sceneId = filterMap.get("bcm_scenemembertree");
        Long yearId = filterMap.get("bcm_fymembertree");
        Long periodId = filterMap.get("bcm_periodmembertree");
        Long orgId = filterMap.get("bcm_entitymembertree");
        CharSequence[] selectFields = InvSheetTemplateConstant.getSelectFields();
        QFBuilder qfBuilder = new QFBuilder("id", "=", (Object)LongUtil.toLong((Object)this.getCurrentReportTabInfo().getTemplateId()));
        DynamicObject template = QueryServiceHelper.queryOne((String)"bcm_papertemplate", (String)String.join((CharSequence)",", selectFields), (QFilter[])qfBuilder.toArray());
        Boolean isClearExtData = Optional.ofNullable(this.getPageCache().get(CLEAR_EXT_DATA)).map(Boolean::parseBoolean).orElse(Boolean.TRUE);
        InvSheetDeleteInfo deleteInfo = new InvSheetDeleteInfo();
        deleteInfo.setClearExtData(isClearExtData.booleanValue());
        deleteInfo.setDeleteRelas(this.getDeleteRelas());
        deleteInfo.setDeleteExts(this.getDeleteExts());
        deleteInfo.setDeleteCells(this.getDeleteCells());
        Map<DimTypesEnum, Object> dim2NumMap = this.getCurrentReportCommonParam(NUMBER);
        IInvLimSheetLogServer logServer = InvLimSheetLogServer.buildInvLimSheetLogServer((long)modelId, (long)sceneId, (long)yearId, (long)periodId, (long)orgId, (InvLimSheetLogConstant.Operation)InvLimSheetLogConstant.Operation.SAVE);
        InvExtDataSpreadServiceHelper.saveSpreadManagerExtData((long)this.getModelId(), (String)((String)dim2NumMap.get(DimTypesEnum.SCENARIO)), (String)((String)dim2NumMap.get(DimTypesEnum.YEAR)), (String)((String)dim2NumMap.get(DimTypesEnum.PERIOD)), (String)((String)dim2NumMap.get(DimTypesEnum.ENTITY)), (DynamicObject)template, (SpreadManager)this.getSpreadModel(), (InvSheetDeleteInfo)deleteInfo, (IInvLimSheetLogServer)logServer);
        this.getEffectiveSheet().putUserObject("NEWDATA_2.0", null);
        this.getPageCache().remove(CLEAR_EXT_DATA);
        this.getPageCache().remove(this.getCurrentTabModel().getCacheKey() + DELETEEXTS);
        this.getPageCache().remove(this.getCurrentTabModel().getCacheKey() + DELETERELAS);
        this.getPageCache().remove(this.getCurrentTabModel().getCacheKey() + DELETECELLS);
        this.cacheSpreadModel();
    }

    protected void checkCellDataType(Cell cell, Map<String, Object> newCell, List<Map<String, Object>> contextList) {
        Map<String, DataTypeEnum> sheetExtDataTypeMap;
        DataTypeEnum dataTypeEnum;
        Object newValue = newCell.get("v");
        int startRow = (Integer)this.getEffectiveSheet().getUserObject(START_ROW);
        int startCol = (Integer)this.getEffectiveSheet().getUserObject(START_COL);
        String spreadType = InvElimPaperGenerateService.getSpreadType((Sheet)this.getEffectiveSheet(), (long)LongUtil.toLong((Object)this.getCurrentReportTabInfo().getTemplateId()));
        Cell extCell = this.isFloatRow(spreadType) ? this.getEffectiveSheet().getCell(startRow, cell.getCol()) : this.getEffectiveSheet().getCell(cell.getRow(), startCol);
        String extNumber = (String)extCell.getUserObject(NUMBER);
        boolean flag = true;
        if (StringUtils.isNotEmpty((String)extNumber) && (dataTypeEnum = (sheetExtDataTypeMap = this.getSheetExtDataTypeMapCache()).get(extNumber)) != null) {
            String index = dataTypeEnum.getOIndex();
            String valueField = InvExtDataSaveService.getValueField((String)index);
            if (new Variant(newValue).isNumber() && !valueField.equals("numext")) {
                flag = false;
            } else if (new Variant(newValue).isString() && valueField.equals("dateext")) {
                String string = newValue.toString();
                try {
                    new SimpleDateFormat("yyyy-MM-dd").parse(string);
                }
                catch (ParseException parseException) {
                    flag = false;
                }
            } else if (new Variant(newValue).isString() && !valueField.equals("textext")) {
                flag = false;
            }
        }
        if (!flag) {
            contextList.add(this.packedUpdateCellMap(cell.getRow(), cell.getCol(), null));
            cell.setValue(null);
            cell.setFormula(null);
            newCell.remove("v");
            Object of = cell.getUserObject("fo");
            Object ov = cell.getUserObject("vo");
            cell.getUserObject().clear();
            if (Objects.nonNull(of)) {
                cell.getUserObject().put((Object)"fo", of);
            }
            if (Objects.nonNull(ov)) {
                cell.getUserObject().put((Object)"vo", ov);
            }
        }
    }

    protected Map<String, DataTypeEnum> getSheetExtDataTypeMapCache() {
        String dataTypeMapStr = this.getPageCache().get(this.getCurrentTabModel().getCacheKey() + DATATYPE_MAP_CACHE);
        HashMap<String, DataTypeEnum> dataTypeMap = new HashMap(16);
        if (StringUtils.isNotEmpty((String)dataTypeMapStr)) {
            dataTypeMap = (Map)ObjectSerialUtil.deSerializedBytes((String)dataTypeMapStr);
            return dataTypeMap;
        }
        DynamicObjectCollection sheetExtMembers = this.getSheetExtMember();
        HashMap<String, DataTypeEnum> finalDataTypeMap = dataTypeMap;
        sheetExtMembers.stream().forEach(extMember -> {
            String dataTypeIndex = (String)extMember.get("dataType");
            String number = (String)extMember.get(NUMBER);
            DataTypeEnum dataTypeEnum = DataTypeEnum.getDataTypeEnumByIndex((String)dataTypeIndex);
            finalDataTypeMap.put(number, dataTypeEnum);
        });
        this.getPageCache().put(this.getCurrentTabModel().getCacheKey() + DATATYPE_MAP_CACHE, ObjectSerialUtil.toByteSerialized(finalDataTypeMap));
        return finalDataTypeMap;
    }

    public DynamicObjectCollection getSheetExtMember() {
        HashSet extNumbers = new HashSet(16);
        Sheet sheet = this.getEffectiveSheet();
        Long templateId = LongUtil.toLong((Object)this.getCurrentReportTabInfo().getTemplateId());
        InvPaperSheetIteratorService invPaperSheetIteratorService = new InvPaperSheetIteratorService(sheet, InvElimPaperGenerateService.getSpreadType((Sheet)sheet, (long)templateId));
        invPaperSheetIteratorService.iterationAccCell(accCell -> {
            String number = (String)accCell.getUserObject(NUMBER);
            if (StringUtils.isNotEmpty((String)number)) {
                extNumbers.add(number);
            }
        });
        return ExtDimensionHelper.getSheetExtMemberByTemplate((long)this.getModelId(), extNumbers, (Long)templateId);
    }

    private int getInvSheetHeadLength() {
        return InvestConstant.getSheetHeadLength((String)((String)this.getEffectiveSheet().getUserObject("dimSetting_V2.0")));
    }

    @Override
    public void removeSpreadClientFormula() {
        Sheet effectiveSheet = this.getEffectiveSheet();
        ArrayList formulaCells = new ArrayList(16);
        ArrayList cellValues = new ArrayList(16);
        effectiveSheet.iteratorCells(cell -> {
            if (Objects.nonNull(cell.getFormula()) || Objects.nonNull(cell.getValue())) {
                HashMap<String, Integer> formulaCell = new HashMap<String, Integer>();
                formulaCell.put(SpreadProperties.SetFormulaMethod.R.k(), cell.getRow());
                formulaCell.put(SpreadProperties.SetFormulaMethod.C.k(), cell.getCol());
                formulaCell.put(SpreadProperties.SetFormulaMethod.F.k(), null);
                formulaCells.add(formulaCell);
                cellValues.add(AdjustModelUtil.packedUpdateCellMap(cell.getRow(), cell.getCol(), cell.getValue()));
            }
        });
        if (formulaCells.isEmpty()) {
            return;
        }
        SpreadClientInvoker.invokeSetFormulaMethod(this.getClientViewProxy(), "report", formulaCells);
        SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), "report", cellValues);
    }

    private static /* synthetic */ void lambda$getAndClearRltCellNumber$49(Multimap number2Cells, Cell rltCell, Cell orgCell, Cell shareholderCell, Cell investedCell, Cell accCell) {
        Optional.ofNullable(rltCell).map(cell -> cell.getUserObject().remove((Object)NUMBER)).map(String.class::cast).ifPresent(number -> number2Cells.put(number, (Object)rltCell));
    }

    private static /* synthetic */ void lambda$getAndClearRltCellNumber$46(Multimap number2Cells, Cell rltCell, Cell orgCell, Cell shareholderCell, Cell investedCell, Cell accCell) {
        Optional.ofNullable(rltCell).map(cell -> cell.getUserObject().remove((Object)NUMBER)).map(String.class::cast).ifPresent(number -> number2Cells.put(number, (Object)rltCell));
    }

    static class Collector {
        private Integer length;
        private Set<Integer> numSet;

        public Collector(Integer length, Set<Integer> numSet) {
            this.length = length;
            this.numSet = numSet;
        }

        public Integer getLength() {
            return this.length;
        }

        public void setLength(Integer length) {
            this.length = length;
        }

        public Set<Integer> getNumSet() {
            return this.numSet;
        }
    }
}

