/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest.sheet;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.common.util.LongUtil;

public class InvSheetEntrySetF7Plugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";
    private static final String SHEET_TREE = "tempsheettree";
    private static final String BILL_LIST = "billlistap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
        TreeView sheetTree = (TreeView)this.getControl(SHEET_TREE);
        final BillList billList = (BillList)this.getControl(BILL_LIST);
        billList.addSetFilterListener(setFilterEvent -> {
            String focusNodeId = sheetTree.getTreeState().getFocusNodeId();
            QFilter qFilter = this.filterBill(focusNodeId);
            setFilterEvent.addCustomQFilter(qFilter);
        });
        sheetTree.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                billList.clearSelection();
                billList.refresh();
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter param = this.getView().getFormShowParameter();
        TreeView sheetTree = (TreeView)this.getControl(SHEET_TREE);
        sheetTree.deleteAllNodes();
        TreeNode treeNode = new TreeNode();
        treeNode.setText(ResManager.loadKDString((String)"\u5e95\u7a3f\u6a21\u677f", (String)"InvSheetEntrySetF7Plugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        JSONArray sheetTemplate = (JSONArray)param.getCustomParam("sheettemplate");
        for (Object obj : sheetTemplate) {
            JSONObject json = (JSONObject)obj;
            String id = json.getString("id");
            String number = json.getString("number");
            String name = json.getString("name");
            TreeNode child = new TreeNode(treeNode.getId(), id, number + " " + name);
            treeNode.addChild(child);
            sheetTree.expand(child.getId());
        }
        sheetTree.addNode(treeNode);
        TreeNode focusNode = sheetTemplate.isEmpty() ? treeNode : (TreeNode)treeNode.getChildren().get(0);
        sheetTree.focusNode(focusNode);
        sheetTree.treeNodeClick(focusNode.getParentid(), focusNode.getId());
        QFilter qFilter = this.filterBill(focusNode.getId());
        BillList billList = (BillList)this.getControl(BILL_LIST);
        billList.setFilter(qFilter);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button source = (Button)evt.getSource();
        if (BTN_OK.equals(source.getKey())) {
            BillList billList = (BillList)this.getControl(BILL_LIST);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            this.getView().returnDataToParent((Object)selectedRows);
            this.getView().close();
        }
    }

    private QFilter filterBill(Object nodeId) {
        if ("".equals(nodeId)) {
            return new QFilter("1", "!=", (Object)1);
        }
        return new QFilter("sheettemplate", "=", (Object)LongUtil.toLong((Object)nodeId));
    }
}

