/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest.sheet;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.invest.helper.InvElimPaperHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.invsheet.InvSheetTemplateConstant;
import kd.fi.bcm.common.constant.invest.sharerela.InvRelationTypeConstant;
import kd.fi.bcm.common.enums.ExtendDimGroupType;
import kd.fi.bcm.common.enums.invest.InvRelaTypeEnum;
import kd.fi.bcm.common.json.JSONObjectUtil;
import kd.fi.bcm.common.util.KDAssert;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;

public class InvSheetRankPlugin
extends AbstractTemplateBasePlugin
implements DynamicPage {
    protected static final String CUR_APP = "fi-bcm-formplugin";
    private static final String EXTENDS_MODEL = "extendsmodel";
    private static final String ORDER_LIST = "orderList";
    private static final String PER_OR_SAVE = "perOrSave";
    private static final String CAN_NOT_CHANGE = "cannotChange";
    public static final String SELECT_ROWS = "selectRows";
    private final List<String> heardListName = Collections.singletonList(ResManager.loadKDString((String)"\u6d6e\u52a8\u9879\u5b57\u6bb5", (String)"InvSheetRankPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ComboEdit spreadType = (ComboEdit)this.getControl("spreadtype");
        InvSheetTemplateConstant.SpreadTypeEnum[] spreadTypeEnums = InvSheetTemplateConstant.SpreadTypeEnum.values();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(spreadTypeEnums.length);
        for (InvSheetTemplateConstant.SpreadTypeEnum spreadTypeEnum : spreadTypeEnums) {
            comboItems.add(new ComboItem(new LocaleString(spreadTypeEnum.getDesc()), String.valueOf(spreadTypeEnum.getCode())));
        }
        spreadType.setComboItems(comboItems);
        TemplateModel templateModel = this.getTemplateModel();
        this.getPageCache().put("KEY_MODEL_ID", templateModel.getModelId() + "");
        this.getTemplateModel().remove("isNeedRebuild");
        if (!StringUtils.isBlank((CharSequence)((CharSequence)templateModel.get("showtype")))) {
            this.getModel().setValue("showtype", templateModel.get("showtype"));
        }
        this.initSpreadType();
        this.initExtendModels(templateModel);
        this.initOrderList(templateModel);
        this.setInvRelationType(null, templateModel);
        this.setRelationCsl(null, templateModel);
        String process = MemberReader.findProcessMemberById((String)this.getCurModelNumber(), (Long)((Long)this.getTemplateModel().get("process"))).getNumber();
        this.getView().setVisible(Boolean.valueOf(!OrgRelaProcessMembPool.isRelaProcess((String)process)), new String[]{"relacslscheme"});
    }

    private void setRelationCsl(DynamicObjectCollection relaCsl, TemplateModel templateModel) {
        DynamicObjectCollection multi = (DynamicObjectCollection)templateModel.get("relacslscheme");
        DynamicObjectCollection dynamicObjectCollection = relaCsl = relaCsl == null ? multi : relaCsl;
        if (relaCsl != null) {
            relaCsl.removeIf(dynamicObject -> Objects.isNull(dynamicObject.get("fbasedataid")));
            this.getModel().setValue("relacslscheme", (Object)relaCsl);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_confirm");
        MulBasedataEdit rlt = (MulBasedataEdit)this.getControl("invrelationtype");
        rlt.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            String process = MemberReader.findProcessMemberById((String)this.getCurModelNumber(), (Long)((Long)this.getTemplateModel().get("process"))).getNumber();
            FormShowParameter formShowParameter = beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setCustomParam("model", (Object)this.getTemplateModel().getModelId());
            formShowParameter.setCustomParam("process", (Object)process);
            QFilter modelFilter = new QFilter("model", "=", (Object)this.getTemplateModel().getModelId());
            if (!OrgRelaProcessMembPool.isRelaProcess((String)process)) {
                QFilter relationFilter = new QFilter("categorized", "=", (Object)InvRelationTypeConstant.CatalogEnum.relation.getCode()).and("number", "=", (Object)InvRelaTypeEnum.DirectRelaType.getType());
                QFilter changeTypeFilter = new QFilter("categorized", "=", (Object)InvRelationTypeConstant.CatalogEnum.change_type.getCode()).and("1", "=", (Object)2);
                beforeF7SelectEvent.addCustomQFilter(modelFilter.and(relationFilter.or(changeTypeFilter)));
                formShowParameter.setCustomParam("relationFilter", (Object)relationFilter.recombine());
                formShowParameter.setCustomParam("changeTypeFilter", (Object)changeTypeFilter.recombine());
            } else {
                beforeF7SelectEvent.addCustomQFilter(modelFilter);
            }
        });
        MulBasedataEdit relaCsl = (MulBasedataEdit)this.getControl("relacslscheme");
        relaCsl.addBeforeF7SelectListener(beforeF7SelectEvent -> beforeF7SelectEvent.addCustomQFilter(new QFilter("number", "!=", (Object)"DefaultRateScheme")));
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("btn_confirm".equals(key)) {
            this.confirm();
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        EntryGrid orderList = (EntryGrid)this.getView().getControl(ORDER_LIST);
        String selectRowsStr = this.getPageCache().get(SELECT_ROWS);
        List selectRows = (List)ObjectSerialUtil.deSerializedBytes((String)selectRowsStr);
        Integer[] rows = selectRows.toArray(new Integer[0]);
        int[] ints = Arrays.stream(rows).mapToInt(Integer::intValue).toArray();
        orderList.selectRows(ints, ints[0]);
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent e) {
        if (e.getCallBackId().equals(PER_OR_SAVE) && e.getResult() == MessageBoxResult.Yes) {
            String spreadType = (String)this.getValueOnModel("spreadtype");
            String showType = (String)this.getValueOnModel("showtype");
            MulBasedataDynamicObjectCollection invRelation = (MulBasedataDynamicObjectCollection)this.getValueOnModel("invrelationtype");
            MulBasedataDynamicObjectCollection relaCslscheme = (MulBasedataDynamicObjectCollection)this.getValueOnModel("relacslscheme");
            String account = (String)this.getValueOnModel(EXTENDS_MODEL);
            EntryGrid control = (EntryGrid)this.getView().getControl(ORDER_LIST);
            this.returnDataCollect(spreadType, showType, invRelation, account, true, control, relaCslscheme);
        } else if (e.getCallBackId().equals(CAN_NOT_CHANGE)) {
            TemplateModel templateModel = this.getTemplateModel();
            Object extendsModel = templateModel.get("extdimid");
            DynamicObjectCollection dfRelationTypes = this.getDfRelationTypes(templateModel);
            this.getModel().setValue("invrelationtype", (Object)dfRelationTypes);
            this.getModel().setValue(EXTENDS_MODEL, extendsModel);
            this.initOrderList(templateModel);
        }
    }

    private void confirm() {
        long extendModelId;
        String spreadType = (String)this.getValueOnModel("spreadtype");
        KDAssert.assertFalse((boolean)StringUtils.isEmpty((CharSequence)spreadType), () -> new KDBizException(this.getInvSheetRankPlugin6()));
        String showType = (String)this.getValueOnModel("showtype");
        KDAssert.assertFalse((boolean)StringUtils.isEmpty((CharSequence)showType), () -> new KDBizException(this.getInvSheetRankPlugin11()));
        MulBasedataDynamicObjectCollection invRelation = (MulBasedataDynamicObjectCollection)this.getValueOnModel("invrelationtype");
        KDAssert.assertFalse((boolean)invRelation.isEmpty(), () -> new KDBizException(this.getInvSheetRankPlugin7()));
        String process = MemberReader.findProcessMemberById((String)this.getCurModelNumber(), (Long)((Long)this.getTemplateModel().get("process"))).getNumber();
        MulBasedataDynamicObjectCollection relaCslscheme = (MulBasedataDynamicObjectCollection)this.getValueOnModel("relacslscheme");
        if (!OrgRelaProcessMembPool.isRelaProcess((String)process)) {
            KDAssert.assertFalse((boolean)relaCslscheme.isEmpty(), () -> new KDBizException(ResManager.loadKDString((String)"\u5173\u8054\u89c6\u56fe\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvSheetRankPlugin_15", (String)CUR_APP, (Object[])new Object[0])));
        }
        String extendModel = (String)this.getValueOnModel(EXTENDS_MODEL);
        try {
            extendModelId = LongUtil.toLong((Object)extendModel);
        }
        catch (Throwable t) {
            extendModelId = 0L;
        }
        KDAssert.assertFalse((extendModelId == 0L || !QueryServiceHelper.exists((String)"bcm_extendsmodel", (Object)extendModelId) ? 1 : 0) != 0, () -> new KDBizException(this.getInvSheetRankPlugin3()));
        EntryGrid control = (EntryGrid)this.getView().getControl(ORDER_LIST);
        int[] selectRows = control.getSelectRows();
        KDAssert.assertFalse((selectRows.length == 0 ? 1 : 0) != 0, () -> new KDBizException(this.getInvSheetRankPlugin4()));
        boolean needRebuild = this.isNeedRebuild(spreadType, extendModel, invRelation);
        if (needRebuild && !this.checkInvLimSheet(extendModel, invRelation)) {
            return;
        }
        if (needRebuild && Objects.nonNull(this.getTemplateModel().get("spreadtype"))) {
            this.getView().showConfirm(this.getInvSheetRankPlugin5(), MessageBoxOptions.YesNo, new ConfirmCallBackListener(PER_OR_SAVE));
            return;
        }
        this.returnDataCollect(spreadType, showType, invRelation, extendModel, needRebuild, control, relaCslscheme);
    }

    private void returnDataCollect(String spreadType, String showType, MulBasedataDynamicObjectCollection invRelation, String account, boolean needRebuild, EntryGrid control, MulBasedataDynamicObjectCollection relaCslscheme) {
        int[] selectRows = control.getSelectRows();
        List selectRowsList = Arrays.stream(selectRows).boxed().collect(Collectors.toList());
        List rows = (List)control.getEntryData().getData().get("rows");
        LinkedHashMap orderListMap = new LinkedHashMap(16);
        rows.stream().forEach(row -> {
            String number = (String)row.get(5);
            Integer index = (Integer)row.get(0);
            orderListMap.put(InvSheetTemplateConstant.FloatFeildEnum.getFloatFeildEnum((String)number).getCode(), selectRowsList.contains(index));
        });
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put("extdimid", account);
        result.put("spreadtype", spreadType);
        result.put("invrelationtype", invRelation);
        result.put("relacslscheme", relaCslscheme);
        result.put("showtype", showType);
        result.put("floatfieldorder", JSONObject.toJSONString(orderListMap));
        result.put("isNeedRebuild", needRebuild);
        this.returnDataToParent(result);
        this.getView().close();
    }

    private boolean isNeedRebuild(String spreadType, String account, MulBasedataDynamicObjectCollection invRelation) {
        TemplateModel templateModel = this.getTemplateModel();
        String srcAccount = String.valueOf((Long)templateModel.get("extdimid"));
        String srcSpreadType = (String)templateModel.get("spreadtype");
        DynamicObjectCollection srcInvRelation = (DynamicObjectCollection)templateModel.get("invrelationtype");
        return !StringUtils.equals((CharSequence)srcAccount, (CharSequence)account) || !StringUtils.equals((CharSequence)srcSpreadType, (CharSequence)spreadType) || !this.notChangedRelation(srcInvRelation, invRelation);
    }

    private boolean notChangedRelation(DynamicObjectCollection srcInvRelation, MulBasedataDynamicObjectCollection invRelation) {
        List srcRelaList = srcInvRelation.stream().map(rela -> rela.getString("fbasedataid.number")).sorted().collect(Collectors.toList());
        String srcRelaStr = String.join((CharSequence)";", srcRelaList);
        List relaList = invRelation.stream().map(rela -> rela.getString("fbasedataid.number")).sorted().collect(Collectors.toList());
        String relaStr = String.join((CharSequence)";", relaList);
        return StringUtils.equals((CharSequence)srcRelaStr, (CharSequence)relaStr);
    }

    private void initSpreadType() {
        TemplateModel templateModel = this.getTemplateModel();
        String spreadTypeValue = (String)templateModel.get("spreadtype");
        spreadTypeValue = spreadTypeValue == null ? InvSheetTemplateConstant.SpreadTypeEnum.FLOAT_COL.getCode() : spreadTypeValue;
        this.getModel().setValue("spreadtype", (Object)spreadTypeValue);
    }

    private void setInvRelationType(DynamicObjectCollection invRelationType, TemplateModel templateModel) {
        DynamicObjectCollection multi = this.getDfRelationTypes(templateModel);
        DynamicObjectCollection dynamicObjectCollection = invRelationType = invRelationType == null ? multi : invRelationType;
        if (invRelationType != null) {
            invRelationType.removeIf(dynamicObject -> Objects.isNull(dynamicObject.get("fbasedataid")));
            this.getModel().setValue("invrelationtype", (Object)invRelationType);
        }
    }

    private void initExtendModels(TemplateModel templateModel) {
        List<ComboItem> accountComboItems = this.getAccountComboItems();
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(EXTENDS_MODEL);
        comboEdit.setComboItems(accountComboItems);
        Object account = templateModel.get("extdimid");
        if (Objects.nonNull(account) && LongUtil.isvalidLong((Object)account)) {
            this.getModel().setValue(EXTENDS_MODEL, account);
        } else {
            this.getModel().setValue(EXTENDS_MODEL, accountComboItems.stream().findFirst().map(ComboItem::getValue).orElse(null));
        }
    }

    private void initOrderList(TemplateModel templateModel) {
        String floatFieldOrder = (String)templateModel.get("floatfieldorder");
        this.getModel().deleteEntryData(ORDER_LIST);
        EntryGrid orderList = (EntryGrid)this.getView().getControl(ORDER_LIST);
        this.heardListName.stream().forEach(heard -> orderList.setColumnProperty("field", "header", (Object)new LocaleString(heard)));
        InvSheetTemplateConstant.FloatFeildEnum[] floatFeildEnums = InvSheetTemplateConstant.FloatFeildEnum.values();
        this.getModel().batchCreateNewEntryRow(ORDER_LIST, floatFeildEnums.length);
        int row = 0;
        ArrayList<Integer> selectRows = new ArrayList<Integer>(16);
        if (!StringUtils.isBlank((CharSequence)floatFieldOrder)) {
            LinkedHashMap floatFieldOrderMap = new LinkedHashMap(16);
            JSONObject jsonObject = JSONObjectUtil.parseObjectOrder((String)floatFieldOrder);
            for (Map.Entry entry : jsonObject.entrySet()) {
                String k = (String)entry.getKey();
                Object v = entry.getValue();
                floatFieldOrderMap.put(k, (Boolean)v);
            }
            AtomicInteger finalRow = new AtomicInteger(row);
            floatFieldOrderMap.entrySet().forEach(fieldOrder -> {
                String key = (String)fieldOrder.getKey();
                Boolean value = (Boolean)fieldOrder.getValue();
                InvSheetTemplateConstant.FloatFeildEnum floatFeildEnum = InvSheetTemplateConstant.FloatFeildEnum.getFloatFeildEnum((String)key);
                this.getModel().setValue("field", (Object)floatFeildEnum.getDesc(), finalRow.get());
                this.getModel().setValue("field1", (Object)floatFeildEnum.getCode(), finalRow.get());
                this.getView().setEnable(Boolean.valueOf(false), finalRow.get(), new String[]{"field", "field1"});
                if (value.booleanValue()) {
                    selectRows.add(finalRow.get());
                }
                finalRow.getAndIncrement();
            });
        } else {
            for (InvSheetTemplateConstant.FloatFeildEnum value : floatFeildEnums) {
                this.getModel().setValue("field", (Object)value.getDesc(), row);
                this.getModel().setValue("field1", (Object)value.getCode(), row);
                this.getView().setEnable(Boolean.valueOf(false), row, new String[]{"field", "field1"});
                if (row == 0) {
                    selectRows.add(row);
                }
                ++row;
            }
        }
        this.getPageCache().put(SELECT_ROWS, ObjectSerialUtil.toByteSerialized(selectRows));
        Integer[] rows = selectRows.toArray(new Integer[0]);
        int[] ints = Arrays.stream(rows).mapToInt(Integer::intValue).toArray();
        if (ints.length > 0) {
            orderList.selectRows(ints, ints[0]);
        }
    }

    private DynamicObjectCollection getDfRelationTypes(TemplateModel templateModel) {
        return (DynamicObjectCollection)templateModel.get("invrelationtype");
    }

    private List<ComboItem> getAccountComboItems() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        QFBuilder filter = new QFBuilder("model", "=", (Object)this.getModelId());
        filter.add("enable", "=", (Object)true);
        filter.add("extendsgroup.grouptype", "=", (Object)ExtendDimGroupType.EQUITY.getIndex());
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)"id, name", (QFilter[])filter.toArray());
        Map<Long, String> id2NameMap = query.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("name")));
        if (id2NameMap.isEmpty()) {
            this.getView().showTipNotification(this.getInvSheetRankPlugin8());
        }
        id2NameMap.entrySet().forEach(entry -> comboItems.add(new ComboItem(new LocaleString((String)entry.getValue()), String.valueOf(entry.getKey()))));
        return comboItems;
    }

    private boolean checkInvLimSheet(String extendsModel, MulBasedataDynamicObjectCollection relationType) {
        TemplateModel templateModel = this.getTemplateModel();
        MulBasedataDynamicObjectCollection oRelationType = (MulBasedataDynamicObjectCollection)templateModel.get("invrelationtype");
        Object oExtendsModel = templateModel.get("extdimid");
        long templateId = templateModel.getId();
        ArrayList templateIds = Lists.newArrayList((Object[])new Object[]{templateId});
        if (templateId != 0L && InvElimPaperHelper.isPaperGenerate((Collection)templateIds) && (this.relationTypeChanging(relationType, oRelationType) || !LongUtil.toLong((Object)extendsModel).equals(oExtendsModel))) {
            StringJoiner msg = new StringJoiner("\n");
            InvElimPaperHelper.getElimSheetLocate((Collection)templateIds, (scenario, year, period, org, number) -> msg.add(String.format(this.getInvSheetRankPlugin10(), scenario, year, period, org, number)));
            this.getView().showConfirm(this.getInvSheetRankPlugin9(), msg.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, new ConfirmCallBackListener(CAN_NOT_CHANGE, (IFormPlugin)this));
            return false;
        }
        return true;
    }

    private boolean relationTypeChanging(MulBasedataDynamicObjectCollection relationType, MulBasedataDynamicObjectCollection oRelationType) {
        boolean sizeEqual;
        boolean bl = sizeEqual = relationType.size() == oRelationType.size();
        if (sizeEqual) {
            for (int i = 0; i < relationType.size(); ++i) {
                long oRelationTypeId;
                long relationTypeId = ((DynamicObject)relationType.get(i)).getDynamicObject(1).getLong("id");
                if (relationTypeId == (oRelationTypeId = ((DynamicObject)oRelationType.get(i)).getDynamicObject(1).getLong("id"))) continue;
                return Boolean.TRUE;
            }
        }
        return !sizeEqual;
    }

    private String getInvSheetRankPlugin0() {
        return ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u6a21\u578b", (String)"InvSheetRankPlugin_0", (String)CUR_APP, (Object[])new Object[0]);
    }

    private String getInvSheetRankPlugin2() {
        return ResManager.loadKDString((String)"\u6301\u80a1\u6bd4\u4f8b\u7c7b\u578b", (String)"InvSheetRankPlugin_2", (String)CUR_APP, (Object[])new Object[0]);
    }

    private String getInvSheetRankPlugin3() {
        return ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u6a21\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvSheetRankPlugin_3", (String)CUR_APP, (Object[])new Object[0]);
    }

    private String getInvSheetRankPlugin4() {
        return ResManager.loadKDString((String)"\u6d6e\u52a8\u9879\u4f18\u5148\u7ea7\u6392\u5e8f\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvSheetRankPlugin_4", (String)CUR_APP, (Object[])new Object[0]);
    }

    private String getInvSheetRankPlugin5() {
        return ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u5220\u9664\u539f\u914d\u7f6e\u5e76\u91cd\u65b0\u5e03\u5c40\uff1f", (String)"InvSheetRankPlugin_5", (String)CUR_APP, (Object[])new Object[0]);
    }

    private String getInvSheetRankPlugin6() {
        return ResManager.loadKDString((String)"\u9884\u8bbe\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvSheetRankPlugin_6", (String)CUR_APP, (Object[])new Object[0]);
    }

    private String getInvSheetRankPlugin11() {
        return ResManager.loadKDString((String)"\u663e\u793a\u6837\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvSheetRankPlugin_12", (String)CUR_APP, (Object[])new Object[0]);
    }

    private String getInvSheetRankPlugin7() {
        return ResManager.loadKDString((String)"\u6301\u80a1\u6bd4\u4f8b\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvSheetRankPlugin_7", (String)CUR_APP, (Object[])new Object[0]);
    }

    private String getInvSheetRankPlugin8() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u62d3\u5c55\u7ef4\u4fe1\u606f\u5931\u8d25,\u8bf7\u5230\u7ef4\u5ea6\u754c\u9762\u65b0\u589e\u62d3\u5c55\u6a21\u578b\u540e\u91cd\u8bd5\u3002", (String)"InvSheetRankPlugin_14", (String)CUR_APP, (Object[])new Object[0]);
    }

    private String getInvSheetRankPlugin9() {
        return String.format(ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u751f\u6210\u5e95\u7a3f\uff0c\u4e0d\u80fd\u4fee\u6539%1$s\u548c%2$s\u3002", (String)"InvSheetRankPlugin_13", (String)CUR_APP, (Object[])new Object[0]), this.getInvSheetRankPlugin0(), this.getInvSheetRankPlugin2());
    }

    private String getInvSheetRankPlugin10() {
        return ResManager.loadKDString((String)"\u60c5\u666f%1$s\u3001\u8d22\u5e74%2$s\u3001\u671f\u95f4%3$s\u3001\u5408\u5e76\u8282\u70b9%4$s\u3001\u5e95\u7a3f%5$s", (String)"InvSheetRankPlugin_10", (String)CUR_APP, (Object[])new Object[0]);
    }
}

