/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest.sheet;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.invest.helper.InvRelationSetHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.sharerela.InvRelationTypeConstant;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class InvSheetRelationAddPlugin
extends AbstractBaseFormPlugin {
    public static final String UNITORG = "unitorg";
    public static final String SHARECOMPANY = "sharecompany";
    public static final String INVESTCOMPANY = "investcompany";
    public static final String RELATION_TYPE = "relationtype";
    public static final String TEMPLATE_ID = "templateId";
    private static final List<String> dimKeys = Collections.singletonList("sharecompany");

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_ok");
        BasedataEdit investcompanyEdit = (BasedataEdit)this.getControl(INVESTCOMPANY);
        investcompanyEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit relationTypeEdit = (BasedataEdit)this.getControl(RELATION_TYPE);
        relationTypeEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"process.number,invrelationtype.fbasedataid", (QFilter[])new QFBuilder("id", "=", this.getFormCustomParam(TEMPLATE_ID)).toArray());
            List pkIdList = query.stream().map(dy -> dy.getLong("invrelationtype.fbasedataid")).collect(Collectors.toList());
            FormShowParameter formShowParameter = beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setCustomParam("model", (Object)this.getModelId());
            formShowParameter.setCustomParam("process", (Object)((DynamicObject)query.get(0)).getString("process.number"));
            formShowParameter.setCustomParam("pks", pkIdList);
            DynamicObject relationtype = (DynamicObject)this.getModel().getValue(RELATION_TYPE);
            if (Objects.nonNull(relationtype)) {
                formShowParameter.setCustomParam("invrelatypebase", (Object)relationtype);
            }
            formShowParameter.setCustomParam("categorized", (Object)InvRelationTypeConstant.CatalogEnum.relation.getCode());
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", pkIdList));
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        HashMap<String, String> f7Key2Dim = new HashMap<String, String>(16);
        f7Key2Dim.put(SHARECOMPANY, DimTypesEnum.INTERCOMPANY.getNumber());
        f7Key2Dim.put(INVESTCOMPANY, DimTypesEnum.ENTITY.getNumber());
        this.getPageCache().put("f7Key2Dim", this.toByteSerialized(f7Key2Dim));
        Object id = this.getFormCustomParam(TEMPLATE_ID);
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
        Long periodId = (Long)this.getView().getFormShowParameter().getCustomParam("period");
        Long fyId = (Long)this.getView().getFormShowParameter().getCustomParam("year");
        Long sceneId = (Long)this.getView().getFormShowParameter().getCustomParam("scenario");
        Long unitorgId = (Long)this.getView().getFormShowParameter().getCustomParam(UNITORG);
        this.getModel().setValue("model", (Object)modelId);
        this.getModel().setValue("scenario", (Object)sceneId);
        this.getModel().setValue("year", (Object)fyId);
        this.getModel().setValue("period", (Object)periodId);
        DynamicObject template = QueryServiceHelper.queryOne((String)"bcm_papertemplate", (String)"process.number,invrelationtype.fbasedataid", (QFilter[])new QFBuilder("id", "=", id).toArray());
        if (OrgRelaProcessMembPool.isRelaProcess((String)template.getString("process.number"))) {
            this.getModel().setValue(UNITORG, (Object)unitorgId);
        } else {
            IDNumberTreeNode belongOrg = MemberReader.findEntityMemberById((Long)modelId, (Long)unitorgId);
            if (belongOrg.getParent() == null) {
                this.getModel().setValue(UNITORG, (Object)belongOrg.getId());
            } else {
                this.getModel().setValue(UNITORG, (Object)belongOrg.getParent().getId());
            }
            this.getModel().setValue(SHARECOMPANY, (Object)BcmThreadCache.findMemberByNum((String)this.getCurModelNumber(), (String)"InternalCompany", (String)belongOrg.getNumber()).getId());
            this.getModel().setValue(RELATION_TYPE, template.get("invrelationtype.fbasedataid"));
            this.getView().setEnable(Boolean.FALSE, new String[]{UNITORG, SHARECOMPANY, RELATION_TYPE});
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String f7Key = beforeF7SelectEvent.getProperty().getName();
        if (INVESTCOMPANY.equals(f7Key)) {
            Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
            QFilter qFilter = new QFilter("model", "=", (Object)modelId).and("isexchangerate", "=", (Object)"0").and(new QFilter("isleaf", "=", (Object)"1").or("isindependentorg", "=", (Object)"1"));
            String dimNumber = DimTypesEnum.ENTITY.getNumber();
            Long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)dimNumber);
            qFilter.and(PermissionServiceImpl.getInstance((Long)modelId).getReadOrWritePermFilter(dimensionId, DimEntityNumEnum.getEntieyNumByNumber((String)dimNumber), "id"));
            ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            parameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        HashMap<String, Long> resultMap = new HashMap<String, Long>(10);
        DynamicObject shareCompanyDy = (DynamicObject)this.getModel().getValue(SHARECOMPANY);
        DynamicObject investCompanyDy = (DynamicObject)this.getModel().getValue(INVESTCOMPANY);
        DynamicObject relationType = (DynamicObject)this.getModel().getValue(RELATION_TYPE);
        DynamicObject unitorg = (DynamicObject)this.getModel().getValue(UNITORG);
        if (Objects.nonNull(shareCompanyDy) && Objects.nonNull(investCompanyDy)) {
            Long shareCompanyId = shareCompanyDy.getLong("id");
            Long investCompanyId = investCompanyDy.getLong("id");
            resultMap.put(UNITORG, unitorg.getLong("id"));
            resultMap.put(SHARECOMPANY, shareCompanyId);
            resultMap.put(INVESTCOMPANY, investCompanyId);
            resultMap.put(RELATION_TYPE, (Long)relationType);
            this.getView().returnDataToParent(resultMap);
            this.getView().close();
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01", (String)"InvSheetRelationAddPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject shareholder;
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (SHARECOMPANY.equals(propertyName) && (shareholder = (DynamicObject)this.getModel().getValue(SHARECOMPANY)) != null) {
            InvRelationSetHelper.checkShareholderHasEntityPerm((Long)this.getModelId(), (String)shareholder.getString("number"));
        }
    }
}

