/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest.sheet;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.ToIntBiFunction;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.helper.ExtDimensionHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.business.formula.register.FormulaConfig;
import kd.fi.bcm.business.integrationnew.provider.formula.FormulaConstant;
import kd.fi.bcm.business.invest.helper.InvRelationTypeHelper;
import kd.fi.bcm.business.model.formula.Formula;
import kd.fi.bcm.business.papertemplate.PaperTemplateHelper;
import kd.fi.bcm.business.papertemplate.PaperTemplateService;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.ResourcesLoaderUtil;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.InvestConstant;
import kd.fi.bcm.common.constant.invest.invsheet.InvSheetTemplateConstant;
import kd.fi.bcm.common.constant.invest.sharerela.InvRelationTypeConstant;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.invest.InvRelaTypeEnum;
import kd.fi.bcm.common.enums.invest.SharescaleTypeEnum;
import kd.fi.bcm.common.enums.papertemplate.PaperTemplateTypeEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.exception.NotificationException;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.KDAssert;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.analytics.SearchHelper;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.intergration.formula.validate.FTicket;
import kd.fi.bcm.formplugin.intergration.formula.validate.FormulaTicketer;
import kd.fi.bcm.formplugin.intergration.formula.validate.IValidate;
import kd.fi.bcm.formplugin.intergration.formula.validate.NotNullValidate;
import kd.fi.bcm.formplugin.intergration.util.ShowFormulaUtil;
import kd.fi.bcm.formplugin.invest.sheet.SpreadCellStyleEntity;
import kd.fi.bcm.formplugin.invest.sheet.formula.InvestFormulaRegisterHelper;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;
import kd.fi.bcm.formplugin.template.model.AskExcuteInfo;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.event.EventConstant;
import kd.fi.bcm.spread.domain.view.event.NotifyEvent;
import kd.fi.bcm.spread.domain.view.event.NotifyListener;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import kd.fi.bcm.spread.formula.expr.StringExpr;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class InvSheetTemplateEditPlugin
extends AbstractTemplateBasePlugin {
    protected static final String CUR_APP = "fi-bcm-formplugin";
    private static final String FORMULA_PICKER_P_BACK = "formulaPickerPBack";
    private static final String CHANGE_FLAG = "changeFlag";
    private static final String OPEN_ENTRY_SET_PAGE = "openEntrySetPage";
    private static final String START_ROW = "startRow";
    private static final String START_COL = "startCol";
    private static final ThreadLocal<Object> CALL_BACK_PARAM = new ThreadLocal();
    private static final String HEAD_FONT = "normal normal bold 14px ";
    private static final String INV_RELATION_RANGE_BACK_COLOR = "#b9b9b9";
    private static final String SEARCH_RANGE_BACK_COLOR = "#9bc2e6";
    private static final String BORDER_COLOR = "#000000";
    private static final String BORDER_STYLE = "thin";
    private static final String AREA_BORDER_STYLE = "medium";
    private static final String DATA_CHANGE = "datachange";
    private static final String DATA_REFRESH = "dataRefresh";
    private static final String ENABLE_FLAG = "enable";
    public static final String ZERO_COLUMNS = "zeroColumns";
    public static final String TMPL_SCENE_CACHE = "tmpl_scene_cache";
    protected static final Map<String, Consumer<? super InvSheetTemplateEditPlugin>> ITEM_CLICK = new HashMap<String, Consumer<? super InvSheetTemplateEditPlugin>>();
    protected static final Map<String, Consumer<? super InvSheetTemplateEditPlugin>> CLOSED_CALL_BACK;

    @Override
    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addItemClickListeners("toolbarap");
        this.registerAllAfterEvent(EventConstant.ActionName.ADD_ROW, EventConstant.ActionName.REMOVE_ROW, EventConstant.ActionName.ADD_COL, EventConstant.ActionName.REMOVE_COL, EventConstant.ActionName.INSERT_COPIED_CELL);
        this.registerAfterEvent(EventConstant.ActionName.UPDATE_VALUE, e -> {
            Cell cell = (Cell)e.getSource();
            if (cell.getValue() == null) {
                cell.setFormula(null);
                cell.clearAllUserObject();
            }
            this.setChange();
        });
        this.registerBeforeEvent(EventConstant.ActionName.UPDATE_VALUE, e -> {
            Cell cell = (Cell)e.getSource();
            TemplateModel templateModel = this.getTemplateModel();
            String spreadType = (String)templateModel.get("spreadtype");
            Object newValue = e.getParam();
            if (StringUtils.isBlank((CharSequence)spreadType) || newValue == null) {
                return;
            }
            boolean floatRow = this.isFloatRow(spreadType);
            if (this.isAccCellArea(cell, floatRow)) {
                String value = String.valueOf(newValue);
                this.initAccCellByValue(cell, value);
                e.setCancel(true);
            }
        });
        this.registerBeforeEvent(EventConstant.ActionName.REMOVE_ROW, e -> {
            try {
                this.freshStartPosition(e, START_ROW, (startPosition, changeRows) -> this.newStartPositionAfterRemove((Integer)startPosition, (List<Integer>)changeRows, !this.isPresentFloatRow()));
            }
            catch (NotificationException ex) {
                this.getView().showTipNotification(this.getInvSheetTemplateEditPlugin14(ex.getMessage()));
                e.setCancel(true);
            }
        });
        this.registerBeforeEvent(EventConstant.ActionName.ADD_ROW, e -> {
            try {
                this.freshStartPosition(e, START_ROW, (startPosition, changeRows) -> this.newStartPositionAfterAdd((Integer)startPosition, (List<Integer>)changeRows, !this.isPresentFloatRow()));
            }
            catch (NotificationException ex) {
                this.getView().showTipNotification(this.getInvSheetTemplateEditPlugin15(ex.getMessage()));
                e.setCancel(true);
            }
        });
        this.registerBeforeEvent(EventConstant.ActionName.REMOVE_COL, e -> {
            try {
                this.freshStartPosition(e, START_COL, (startPosition, changeRows) -> this.newStartPositionAfterRemove((Integer)startPosition, (List<Integer>)changeRows, this.isPresentFloatRow()));
            }
            catch (NotificationException ex) {
                this.getView().showTipNotification(this.getInvSheetTemplateEditPlugin16(ex.getMessage()));
                e.setCancel(true);
            }
        });
        this.registerBeforeEvent(EventConstant.ActionName.ADD_COL, e -> {
            try {
                this.freshStartPosition(e, START_COL, (startPosition, changeRows) -> this.newStartPositionAfterAdd((Integer)startPosition, (List<Integer>)changeRows, this.isPresentFloatRow()));
            }
            catch (NotificationException ex) {
                this.getView().showTipNotification(this.getInvSheetTemplateEditPlugin17(ex.getMessage()));
                e.setCancel(true);
            }
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.registerFormula();
        TemplateModel template = this.getTemplateModel();
        if (template.get(TMPL_SCENE_CACHE) == null) {
            template.put(TMPL_SCENE_CACHE, (Object)PaperTemplateHelper.findTmplScene4Setting((long)this.getModelId(), (PaperTemplateTypeEnum)PaperTemplateTypeEnum.INVELIM, (long)template.getGroup()));
        }
        this.resetExtDimId(template);
        SpreadManager spreadManager = this.getSpreadModel();
        String json = template.getSpreadJson() != null ? template.getSpreadJson() : spreadManager.getBook().toJSon();
        this.reCacheTemplateModel(template);
        this.intViewByStatus();
        SpreadClientInvoker.invokeSetSpreadJsonMethod(this.getClientViewProxy(), "template_spread", json);
        SpreadClientInvoker.invokeSetWorkbookOptions(this.getClientViewProxy(), this.getSpreadKey(), MapInitHelper.ofMap((Object)SpreadProperties.SetWorkbookOptions.AllowCopyPasteExcelStyle.k(), (Object)false));
        this.setViewSpreadJs();
        this.registSpreadShortcutKey();
    }

    @Override
    protected void registSpreadShortcutKey() {
        super.registSpreadShortcutKey();
        SpreadClientInvoker.invokeRegistShortcutKey(this.getClientViewProxy(), "template_spread", "debugAcct", "F12", true, true, true);
    }

    public void debugAcct() {
        ListShowParameter lsp = new ListShowParameter();
        lsp.setBillFormId("bcm_invpaperformregister");
        lsp.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)lsp);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        try {
            super.itemClick(evt);
            Consumer<? super InvSheetTemplateEditPlugin> consumer = ITEM_CLICK.get(evt.getItemKey());
            if (consumer != null) {
                consumer.accept(this);
            }
        }
        catch (NotificationException e) {
            this.getView().showTipNotification(e.getMessage());
        }
        catch (DataDeletedException ex) {
            this.closeAndShowError(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        try {
            CALL_BACK_PARAM.set(evt);
            String actionId = evt.getActionId();
            Consumer<? super InvSheetTemplateEditPlugin> consumer = CLOSED_CALL_BACK.get(actionId);
            if (consumer != null) {
                consumer.accept(this);
            }
        }
        catch (NotificationException e) {
            this.getView().showTipNotification(e.getMessage());
        }
        finally {
            CALL_BACK_PARAM.remove();
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        if (DATA_CHANGE.equals(callBackId) && e.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().remove(CHANGE_FLAG);
            this.getView().close();
        }
        if (DATA_REFRESH.equals(callBackId) && e.getResult() == MessageBoxResult.Yes) {
            try {
                this.doRefresh();
            }
            catch (DataDeletedException ex) {
                this.closeAndShowError(ex);
            }
        }
    }

    @Override
    public void showFormulaPanel(int row, int col) {
        try {
            Cell focusCell = this.getEffectiveSheet().getCell(row, col);
            KDAssert.assertTrue((focusCell.getUserObject("id") == null ? 1 : 0) != 0, () -> new NotificationException(this.getInvSheetTemplateEditPlugin3()));
            TemplateModel templateModel = this.getTemplateModel();
            String spreadType = (String)templateModel.get("spreadtype");
            KDAssert.assertTrue((boolean)StringUtils.isNotEmpty((CharSequence)spreadType), () -> new NotificationException(this.getInvSheetTemplateEditPlugin4()));
            if (this.isFloatRow(spreadType)) {
                --row;
            } else {
                --col;
            }
            String formula = focusCell.getFormula();
            try {
                if (kd.bos.util.StringUtils.isNotEmpty((String)formula)) {
                    formula = formula.replaceAll("\\p{C}", "");
                    Expression e = ExcelFormulaPaserHelper.parse((String)formula);
                    this.showFormulaList(e, formula);
                } else {
                    this.showFormulaList(formula);
                }
            }
            catch (Exception ee) {
                throw new KDBizException(this.getInvSheetTemplateEditPlugin12());
            }
        }
        catch (NotificationException e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    @Override
    public String getSpreadKey() {
        return "template_spread";
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        if (this.changeNotViewStatus()) {
            this.getView().showConfirm(this.getInvSheetTemplateEditPlugin6(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DATA_CHANGE, (IFormPlugin)this));
            e.setCancel(true);
            return;
        }
        QFilter[] aFilters = new QFBuilder("status", "=", (Object)InvSheetTemplateConstant.BillStatusEnum.PRE_SAVE.getCode()).and("model", "=", (Object)this.getModelId()).toArray();
        DeleteServiceHelper.delete((String)"bcm_papertemplate", (QFilter[])aFilters);
    }

    @Override
    public boolean isViewStatus() {
        TemplateModel templateModel = this.getTemplateModel();
        String status = (String)templateModel.get("status");
        return super.isViewStatus() || InvSheetTemplateConstant.BillStatusEnum.ENABLE.getCode().equals(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionSave(String spreadJson) {
        try {
            TemplateModel template = this.fillTemplateModel(spreadJson);
            this.doSave(template);
            template.setIsOldTemplate(true);
            if (this.getPageCache().get(OPEN_ENTRY_SET_PAGE) != null) {
                this.openEntrySetPage();
            } else if (this.getPageCache().get(ENABLE_FLAG) != null) {
                this.removeChange();
                this.getView().showSuccessNotification(this.getInvSheetTemplateEditPlugin26());
                this.writeOperationLog(this.getInvSheetTemplateEditPlugin33(), ResultStatusEnum.SUCCESS.getName());
            } else {
                this.removeChange();
                this.getView().showSuccessNotification(this.getInvSheetTemplateEditPlugin8());
                this.writeOperationLog(this.getInvSheetTemplateEditPlugin29(), ResultStatusEnum.SUCCESS.getName());
            }
            this.intViewByStatus();
            DynamicObject dyna = this.loadById((Long)template.get("id"), true);
            TemplateModel templateModel = TemplateModel.genTemplateModelBy((DynamicObject)dyna);
            this.reCacheTemplateModel(templateModel);
        }
        catch (NotificationException e) {
            this.getPageCache().remove(OPEN_ENTRY_SET_PAGE);
            this.getView().showTipNotification(e.getMessage());
        }
        catch (DataDeletedException e) {
            this.closeAndShowError(e);
        }
        finally {
            this.getPageCache().remove(ENABLE_FLAG);
            this.getPageCache().remove(OPEN_ENTRY_SET_PAGE);
        }
    }

    public void showFormulaList(String formula) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bcm_formulapicker_invest");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        String firstRelationType = this.getFirstRelationType();
        parameter.setCustomParam("invrelationtype", (Object)firstRelationType);
        parameter.setCustomParam("txtadvance", (Object)formula);
        parameter.setCustomParam("isFromInv", (Object)true);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_formulapicker_invest");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    @Override
    public void spreadF7Click(int r, int c) {
        super.spreadF7Click(r, c);
        Cell cell = this.getEffectiveSheet().getCell(r, c);
        TemplateModel templateModel = this.getTemplateModel();
        String spreadType = (String)templateModel.get("spreadtype");
        if (this.isAccCellArea(cell, this.isFloatRow(spreadType))) {
            QFilter numberFilter = new QFilter("number", "=", (Object)"Extends");
            DynamicObject dimObj = QueryServiceHelper.queryOne((String)"bcm_dimension_ext", (String)"id", (QFilter[])new QFilter[]{this.getQFilterByModelID(), numberFilter});
            BasedataEditSingleMemberF7 f7 = SingleMemberF7Util.createBaseDataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), dimObj.getLong("id"), this.extDimensionF7Key(), null, Boolean.TRUE, SingleF7TypeEnum.EXT_DIM, Boolean.TRUE);
            f7.setCallBackClassName(this.getClass().getName());
            HashMap<String, Object> customData = new HashMap<String, Object>();
            customData.put("f7Click", "true");
            customData.put("enableScheme", false);
            f7.setCustomData(customData);
            Long extDimId = (Long)templateModel.get("extdimid");
            QFBuilder filter = new QFBuilder("extmodelid", "=", (Object)extDimId);
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_extmodelfield", (String)"extfield.id extfield", (QFilter[])filter.toArray());
            List extFieldIds = query.stream().map(dy -> dy.getLong("extfield")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "in", extFieldIds);
            f7.setCustomFilter(qFilter);
            f7.click();
            return;
        }
        this.getView().showTipNotification(this.getInvSheetTemplateEditPlugin13());
    }

    private boolean isPresentFloatRow() {
        TemplateModel templateModel = this.getTemplateModel();
        String spreadType = (String)templateModel.get("spreadtype");
        return this.isFloatRow(spreadType);
    }

    private void freshStartPosition(NotifyEvent e, String rowOrColStart, ToIntBiFunction<Integer, List<Integer>> action) {
        Object startPositionObj = this.getEffectiveSheet().getUserObject(rowOrColStart);
        if (startPositionObj == null) {
            return;
        }
        int startPosition = (Integer)startPositionObj;
        AskExcuteInfo sourceInfo = (AskExcuteInfo)e.getSource();
        List<Integer> changeRows = sourceInfo.getOperationdata();
        startPosition = action.applyAsInt(startPosition, changeRows);
        this.getEffectiveSheet().putUserObject(rowOrColStart, (Object)startPosition);
        this.cacheSpreadModel();
    }

    private int newStartPositionAfterRemove(Integer startPosition, List<Integer> changeRows, boolean oneHeadMore) {
        if (oneHeadMore) {
            return this.calculateStartPosition(startPosition, startPosition + InvestConstant.getSheetHeadLength((String)((String)this.getEffectiveSheet().getUserObject("dimSetting_V2.0"))), -1, changeRows);
        }
        return this.calculateStartPosition(startPosition, startPosition, -1, changeRows);
    }

    private int newStartPositionAfterAdd(Integer startPosition, List<Integer> changeRows, boolean oneHeadMore) {
        if (oneHeadMore) {
            return this.calculateStartPosition(startPosition + 1, startPosition + InvestConstant.getSheetHeadLength((String)((String)this.getEffectiveSheet().getUserObject("dimSetting_V2.0"))), 1, changeRows) - 1;
        }
        ArrayList<Integer> addRowList = new ArrayList<Integer>(changeRows.size());
        addRowList.addAll(changeRows);
        addRowList.removeIf(a -> startPosition + 1 == a);
        return this.calculateStartPosition(startPosition + 1, startPosition + 1, 1, addRowList) - 1;
    }

    private int calculateStartPosition(int min, int max, int factor, List<Integer> removeRows) {
        int start = min;
        StringJoiner msg = new StringJoiner(",");
        for (int i = removeRows.size() - 1; i >= 0; --i) {
            Integer removeRow = removeRows.get(i);
            if (removeRow == min || removeRow > min && removeRow < max) {
                msg.add(removeRow + 1 + "");
            }
            if (removeRow >= min) continue;
            start += factor;
        }
        if (msg.length() > 0) {
            throw new NotificationException(msg.toString());
        }
        return start;
    }

    private void initAccCellByValue(Cell cell, String value) {
        String number;
        DynamicObject dynamicObject;
        String newValue = null;
        cell.setValue(null);
        cell.setFormula(null);
        cell.clearAllUserObject();
        String[] split = value.split(" ");
        if (split.length > 0 && Objects.nonNull(dynamicObject = this.queryAccByNumber(number = split[0]))) {
            String numberQuery = dynamicObject.getString("number");
            String name = dynamicObject.getString("name");
            long accId = dynamicObject.getLong("id");
            String cellValue = this.buildAccCellValue(number, name);
            Map<Long, String> hadChangeAccounts = this.hadChangeAccounts();
            String position = hadChangeAccounts.get(accId);
            if (StringUtils.isNotEmpty((CharSequence)position)) {
                this.getView().showTipNotification(this.getInvSheetTemplateEditPlugin11(cellValue, position));
            }
            if (StringUtils.isEmpty((CharSequence)position) && (split.length > 1 && StringUtils.equals((CharSequence)cellValue, (CharSequence)value) || StringUtils.equals((CharSequence)numberQuery, (CharSequence)value))) {
                cell.setUserObject("name", (Object)name);
                cell.setUserObject("number", (Object)number);
                cell.setUserObject("id", (Object)accId);
                newValue = cellValue;
                cell.setValue((Object)newValue);
                this.cellF7Enable(cell.getRow(), cell.getCol());
            }
        }
        SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), "template_spread", Lists.newArrayList((Object[])new Map[]{this.packedUpdateCellMap(cell.getRow(), cell.getCol(), newValue)}));
    }

    private DynamicObject queryAccByNumber(String number) {
        String selectFields = this.buildAccSelectFields();
        Object extDimId = this.getTemplateModel().get("extdimid");
        QFBuilder filter = new QFBuilder("extmodelid", "=", extDimId);
        filter.and("extfield.number", "=", (Object)number);
        return QueryServiceHelper.queryOne((String)"bcm_extmodelfield", (String)selectFields, (QFilter[])filter.toArray());
    }

    private boolean isAccCellArea(Cell cell, boolean floatRow) {
        Sheet sheet = this.getEffectiveSheet();
        int startRow = (Integer)sheet.getUserObject(START_ROW);
        int startCol = (Integer)sheet.getUserObject(START_COL);
        String versionKey = (String)sheet.getUserObject("dimSetting_V2.0");
        if (!floatRow) {
            int startAccCellArea = startRow + InvestConstant.getSheetHeadLength((String)versionKey);
            return cell.getRow() >= startAccCellArea && cell.getCol() == startCol;
        }
        int startAccCellArea = startCol + InvestConstant.getSheetHeadLength((String)versionKey);
        return cell.getCol() >= startAccCellArea && cell.getRow() == startRow;
    }

    private void registerAllAfterEvent(EventConstant.ActionName ... keys) {
        for (EventConstant.ActionName key : keys) {
            NotifyListener notifyListener = this.unregisterAfterEvent(key);
            this.registerAfterEvent(key, event -> {
                if (Objects.nonNull(notifyListener)) {
                    notifyListener.doNotify(event);
                    this.setChange();
                }
            });
        }
    }

    private void setViewSpreadJs() {
        SpreadClientInvoker.invokeHideContextMenuItems(this.getClientViewProxy(), "template_spread", MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)false));
        ArrayList<Map> menuItems = new ArrayList<Map>();
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.pasteAll, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.pasteFormula, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.pasteFormatting, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.pasteFormulaFormatting, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.cut, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.sort, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.filter, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.hideRows, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.unhideRows, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.hideColumns, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.unhideColumns, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertCopiedRow, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertCopiedCol, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.rowHeaderinsertCutCells, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.colHeaderinsertCutCells, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        SpreadClientInvoker.invokeHideContextMenuItems(this.getClientViewProxy(), this.getSpreadKey(), menuItems);
    }

    private void save() {
        TemplateModel templateModel = this.getTemplateModel();
        templateModel.put("status", (Object)InvSheetTemplateConstant.BillStatusEnum.DISABLE.getCode());
        this.reCacheTemplateModel(templateModel);
        this.callSpreadJSToSave();
    }

    private void baseInfo() {
        this.openBaseInfoPage();
    }

    private void dimSetting() {
        this.getSelectorStartRow();
        this.openRank();
    }

    private void entrySet() {
        TemplateModel templateModel = this.getTemplateModel();
        if (templateModel.isOldTemplate() && templateModel.get("spreadtype") != null) {
            this.openEntrySetPage();
        } else {
            this.getPageCache().put(OPEN_ENTRY_SET_PAGE, "true");
            templateModel.put("status", (Object)InvSheetTemplateConstant.BillStatusEnum.PRE_SAVE.getCode());
            this.reCacheTemplateModel(templateModel);
            this.callSpreadJSToSave();
        }
    }

    private void enable() {
        Object effectiveDate = this.getTemplateModel().get("effectivedate");
        if (Objects.isNull(effectiveDate)) {
            this.getView().showErrorNotification(this.effectiveDateIsNullMsg());
            return;
        }
        this.getPageCache().put(ENABLE_FLAG, "true");
        this.callSpreadJSToSave();
    }

    private void disable() {
        this.updateStatus(InvSheetTemplateConstant.BillStatusEnum.DISABLE.getCode());
        TemplateModel templateModel = this.getTemplateModel();
        templateModel.put("status", (Object)InvSheetTemplateConstant.BillStatusEnum.DISABLE.getCode());
        this.reCacheTemplateModel(templateModel);
        this.intViewByStatus();
        this.getView().showSuccessNotification(this.getInvSheetTemplateEditPlugin25());
        this.writeOperationLog(this.getInvSheetTemplateEditPlugin34(), ResultStatusEnum.SUCCESS.getName());
    }

    private void refresh() {
        if (this.changeNotViewStatus()) {
            this.getView().showConfirm(this.getInvSheetTemplateEditPlugin20(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DATA_REFRESH, (IFormPlugin)this));
            return;
        }
        this.doRefresh();
    }

    private void close() {
        this.getView().close();
    }

    private void showFormulaPanelPBack() {
        ClosedCallBackEvent evt = (ClosedCallBackEvent)CALL_BACK_PARAM.get();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        Map data = (Map)returnData;
        String formula = String.format("P(%s)", data.get("formula"));
        this.handleCallBackFormula(formula);
        this.cacheSpreadModel();
        this.setChange();
    }

    private void showFormulaPanelBack() {
        ClosedCallBackEvent evt = (ClosedCallBackEvent)CALL_BACK_PARAM.get();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        String formula = returnData.toString();
        if (returnData instanceof Map) {
            formula = (String)((Map)returnData).get("formula");
        }
        this.handleCallBackFormula(formula);
        this.cacheSpreadModel();
        this.setChange();
    }

    private void spreadF7ClickBack() {
        ClosedCallBackEvent evt = (ClosedCallBackEvent)CALL_BACK_PARAM.get();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            this.getPageCache().remove("f7select");
            return;
        }
        this.handleCallBackCellF7((DynamicObject)returnData);
        this.cacheSpreadModel();
        this.setChange();
    }

    private void dimSettingBack() {
        ClosedCallBackEvent evt = (ClosedCallBackEvent)CALL_BACK_PARAM.get();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        Map result = (Map)ObjectSerialUtil.deSerializedBytes((String)((String)returnData));
        Boolean needRebuild = (Boolean)result.get("isNeedRebuild");
        if (Objects.nonNull(needRebuild) && !needRebuild.booleanValue()) {
            this.updateTemplateModel(result);
            return;
        }
        this.deleteRank();
        this.updateTemplateModel(result);
        this.rebuildStyle();
    }

    @NotNull
    private TemplateModel updateTemplateModel(Map<String, Object> result) {
        TemplateModel templateModel = this.getTemplateModel();
        templateModel.put("showtype", result.get("showtype"));
        templateModel.put("floatfieldorder", result.get("floatfieldorder"));
        templateModel.put("spreadtype", result.get("spreadtype"));
        templateModel.put("invrelationtype", result.get("invrelationtype"));
        templateModel.put("extdimid", (Object)ConvertUtil.convertObjToLong((Object)result.get("extdimid")));
        templateModel.put("relacslscheme", result.get("relacslscheme"));
        this.reCacheTemplateModel(templateModel);
        return templateModel;
    }

    private void rebuildStyle() {
        TemplateModel templateModel = this.getTemplateModel();
        this.initAccount(templateModel);
        Sheet effectiveSheet = this.getEffectiveSheet();
        effectiveSheet.putUserObject("dimSetting_V2.0", (Object)"dimSetting_V2.0");
        this.reCacheTemplateModel(templateModel);
        this.cacheSpreadModel();
        this.setChange();
        this.writeOperationLog(this.getInvSheetTemplateEditPlugin31(), ResultStatusEnum.SUCCESS.getName());
    }

    private void baseInfoBack() {
        ClosedCallBackEvent evt = (ClosedCallBackEvent)CALL_BACK_PARAM.get();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        Map dy = (Map)ObjectSerialUtil.deSerializedBytes((String)((String)returnData));
        this.handleCallBackBaseInfo(dy);
        this.setChange();
        this.writeOperationLog(this.getInvSheetTemplateEditPlugin30(), ResultStatusEnum.SUCCESS.getName());
    }

    private void registerFormula() {
        InvestFormulaRegisterHelper.getRegisterInvestFormulaList(this.getModelId()).forEach(formula -> SpreadClientInvoker.invokeRegisterCustomFormulaMethod(this.getClientViewProxy(), "template_spread", Lists.newArrayList((Object[])new Map[]{formula})));
    }

    private void initAccount(TemplateModel templateModel) {
        SpreadCellStyleEntity searchRange;
        int rowStart;
        SpreadCellStyleEntity invRelationRange;
        SpreadCellStyleEntity headRange;
        SpreadCellStyleEntity allRange;
        String spreadType = (String)templateModel.get("spreadtype");
        int row = this.getSelectorStartRow();
        int col = this.getSelectorStartCol();
        DynamicObject[] accounts = this.getOrderlyAccounts(templateModel);
        Sheet sheet = this.getEffectiveSheet();
        if (accounts.length == 0) {
            this.getView().showTipNotification(this.getInvSheetTemplateEditPlugin23());
            sheet.getUserObject().clear();
            templateModel.remove("spreadtype");
            templateModel.remove("extdimid");
            templateModel.remove("invrelationtype");
            templateModel.remove("relacslscheme");
            return;
        }
        sheet.putUserObject(START_ROW, (Object)row);
        sheet.putUserObject(START_COL, (Object)col);
        if (!this.isFloatRow(spreadType)) {
            this.deleteCellValue(row, col, InvestConstant.getSheetHeadLength((String)((String)sheet.getUserObject("dimSetting_V2.0"))) + accounts.length + 1, 2);
            allRange = new SpreadCellStyleEntity(this.getClientViewProxy(), this.getSpreadKey(), row, col, InvestConstant.getSheetHeadLength((String)"dimSetting_V2.0") + accounts.length, 2);
            headRange = new SpreadCellStyleEntity(this.getClientViewProxy(), this.getSpreadKey(), row, col, InvestConstant.getSheetHeadLength((String)"dimSetting_V2.0"), 1);
            invRelationRange = new SpreadCellStyleEntity(this.getClientViewProxy(), this.getSpreadKey(), row, col + 1, InvestConstant.getSheetHeadLength((String)"dimSetting_V2.0"), 1);
        } else {
            this.deleteCellValue(row, col, 2, InvestConstant.getSheetHeadLength((String)((String)sheet.getUserObject("dimSetting_V2.0"))) + accounts.length + 1);
            allRange = new SpreadCellStyleEntity(this.getClientViewProxy(), this.getSpreadKey(), row, col, 2, InvestConstant.getSheetHeadLength((String)"dimSetting_V2.0") + accounts.length);
            headRange = new SpreadCellStyleEntity(this.getClientViewProxy(), this.getSpreadKey(), row, col, 1, InvestConstant.getSheetHeadLength((String)"dimSetting_V2.0"));
            invRelationRange = new SpreadCellStyleEntity(this.getClientViewProxy(), this.getSpreadKey(), row + 1, col, 1, InvestConstant.getSheetHeadLength((String)"dimSetting_V2.0"));
        }
        allRange.clearCellsStyle();
        ArrayList<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>(InvestConstant.getSheetHeadLength((String)"dimSetting_V2.0"));
        for (String org : InvestConstant.getInvSheetHead()) {
            Cell cell = this.getEffectiveSheet().getCell(row, col);
            cell.setValue((Object)org);
            updateList.add(this.packedUpdateCellMap(row, col, org));
            if (!this.isFloatRow(spreadType)) {
                ++row;
                continue;
            }
            ++col;
        }
        int searchRangeColSpan = accounts.length;
        int maxColumnCount = this.getEffectiveSheet().getMaxColumnCount();
        int maxRowCount = this.getEffectiveSheet().getMaxRowCount();
        if (this.isFloatRow(spreadType) && searchRangeColSpan + col > 52) {
            LinkedHashMap<String, Integer> count = new LinkedHashMap<String, Integer>(16);
            count.put("count", searchRangeColSpan + col - 52 + 10);
            SpreadClientInvoker.invokeAppendCols(this.getClientViewProxy(), "template_spread", count);
        } else if (!this.isFloatRow(spreadType) && searchRangeColSpan > 2000) {
            SpreadClientInvoker.appendRows(this.getClientViewProxy(), "template_spread", maxRowCount - 1, searchRangeColSpan + row - 2000 + 10);
        }
        for (int i = 0; i < accounts.length; ++i) {
            DynamicObject account = accounts[i];
            Cell cell = this.getEffectiveSheet().getCell(row, col);
            this.cellF7Enable(row, col);
            String name = account.getString("name");
            String number = (String)account.get("number");
            Long id = (Long)account.get("id");
            cell.setUserObject("name", (Object)name);
            cell.setUserObject("number", (Object)number);
            cell.setUserObject("id", (Object)id);
            String accCellValue = this.buildAccCellValue(number, name);
            cell.setValue((Object)accCellValue);
            updateList.add(this.packedUpdateCellMap(row, col, accCellValue));
            if (!this.isFloatRow(spreadType)) {
                ++row;
                continue;
            }
            ++col;
        }
        SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), this.getSpreadKey(), updateList);
        if (!this.isFloatRow(spreadType)) {
            rowStart = headRange.getRowStart() + headRange.getRowSpan();
            int colStart = headRange.getColStart();
            int rowSpan = searchRangeColSpan;
            int colSpan = 1;
            searchRange = new SpreadCellStyleEntity(this.getClientViewProxy(), this.getSpreadKey(), rowStart, colStart, rowSpan, colSpan);
            HashMap<String, ArrayList> featureMap = new HashMap<String, ArrayList>();
            featureMap.put(SpreadProperties.AutoFitColumns.C.k(), Lists.newArrayList((Object[])new Integer[]{colStart}));
            SpreadClientInvoker.invokeAutoFitColumns(this.getClientViewProxy(), this.getSpreadKey(), featureMap);
        } else {
            rowStart = headRange.getRowStart();
            int colStart = headRange.getColStart() + headRange.getColSpan();
            int rowSpan = 1;
            int colSpan = searchRangeColSpan;
            searchRange = new SpreadCellStyleEntity(this.getClientViewProxy(), this.getSpreadKey(), rowStart, colStart, rowSpan, colSpan);
            for (int i = colStart - InvestConstant.getSheetHeadLength((String)"dimSetting_V2.0"); i < accounts.length + InvestConstant.getSheetHeadLength((String)"dimSetting_V2.0") + 1; ++i) {
                HashMap<String, ArrayList> featureMap = new HashMap<String, ArrayList>();
                featureMap.put(SpreadProperties.AutoFitColumns.C.k(), Lists.newArrayList((Object[])new Integer[]{i}));
                SpreadClientInvoker.invokeAutoFitColumns(this.getClientViewProxy(), this.getSpreadKey(), featureMap);
            }
        }
        String fontLs = ResManager.loadKDString((String)"\u5b8b\u4f53", (String)"InvSheetTemplateEditPlugin_39", (String)CUR_APP, (Object[])new Object[0]);
        headRange.setFont(HEAD_FONT + fontLs);
        headRange.setCellBackColor(INV_RELATION_RANGE_BACK_COLOR);
        headRange.doBuildCellsStyle();
        invRelationRange.setCellBackColor(INV_RELATION_RANGE_BACK_COLOR);
        invRelationRange.doBuildCellsStyle();
        searchRange.setCellBackColor(SEARCH_RANGE_BACK_COLOR);
        searchRange.doBuildCellsStyle();
        allRange.setBorder(BORDER_COLOR, BORDER_STYLE);
        allRange.doBuildCellsStyle();
        allRange.setAreaBorder(BORDER_COLOR, AREA_BORDER_STYLE);
    }

    private DynamicObject[] getOrderlyAccounts(TemplateModel templateModel) {
        Long extDimId = (Long)templateModel.get("extdimid");
        QFBuilder filter = new QFBuilder("extmodelid", "=", (Object)extDimId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_extmodelfield", (String)this.buildAccSelectFields(), (QFilter[])filter.toArray(), (String)"sequence");
        return (DynamicObject[])query.toArray((Object[])new DynamicObject[0]);
    }

    private String buildAccSelectFields() {
        return "extfield.id id,extfield.number number,extfield.name name";
    }

    private void deleteCellValue(int r, int c, int rc, int cc) {
        ArrayList formulaList = new ArrayList();
        ArrayList<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                HashMap<String, Integer> formula = new HashMap<String, Integer>();
                int rowNum = r + i;
                int colNum = c + j;
                formula.put(SpreadProperties.SetFormulaMethod.R.k(), rowNum);
                formula.put(SpreadProperties.SetFormulaMethod.C.k(), colNum);
                formula.put(SpreadProperties.SetFormulaMethod.F.k(), null);
                formulaList.add(formula);
                updateList.add(this.packedUpdateCellMap(rowNum, colNum, null));
                Cell cell = this.getEffectiveSheet().getCell(rowNum, colNum);
                cell.setValue(null);
                cell.clearAllUserObject();
            }
        }
        SpreadClientInvoker.invokeSetFormulaMethod(this.getClientViewProxy(), this.getSpreadKey(), formulaList);
        SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), this.getSpreadKey(), updateList);
    }

    private boolean isFloatRow(String spreadType) {
        return InvSheetTemplateConstant.SpreadTypeEnum.FLOAT_ROW.getCode().equals(spreadType);
    }

    private void openRank() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setFormId("bcm_invsheet_rank");
        formShowParameter.setCustomParam(this.KEY_TEMPLATE_MODEL, (Object)this.getPageCache().get(this.KEY_TEMPLATE_MODEL));
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_invsheet_rank");
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    private void openBaseInfoPage() {
        TemplateModel templateModel = this.getTemplateModel();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"InvSheetTemplateEditPlugin_1", (String)CUR_APP, (Object[])new Object[0]));
        formShowParameter.setStatus(this.isPreSaveOrNew(templateModel) ? OperationStatus.ADDNEW : OperationStatus.EDIT);
        formShowParameter.setFormId("bcm_papertemplate");
        formShowParameter.setCustomParam("KEY_MODEL_ID", templateModel.get("model"));
        formShowParameter.setCustomParam("KEY_SCENARIO_ID", templateModel.get("scenario"));
        formShowParameter.setCustomParam("id", templateModel.get("id"));
        formShowParameter.setCustomParam("templatecatalog", templateModel.get("templatecatalog"));
        formShowParameter.setCustomParam("permclass", templateModel.get("permclass"));
        formShowParameter.setCustomParam("number", templateModel.get("number"));
        formShowParameter.setCustomParam("name", this.getLocaleValue(templateModel));
        formShowParameter.setCustomParam("group", templateModel.get("group"));
        formShowParameter.setCustomParam("process", templateModel.get("process"));
        formShowParameter.setCustomParam("tmplscene", (Object)this.toByteSerialized(templateModel.get(TMPL_SCENE_CACHE)));
        if (templateModel.getEffectivedata() != null) {
            formShowParameter.setCustomParam("effectivedata", (Object)JSON.toJSONString((Object)templateModel.getEffectivedata()));
            formShowParameter.setCustomParam("effectivetext", (Object)templateModel.getEffectivetext());
        }
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(this.getInvSheetTemplateEditPlugin7());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_papertemplate");
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    private Object getLocaleValue(TemplateModel templateModel) {
        Object name = templateModel.get("name");
        if (name instanceof OrmLocaleValue) {
            return name;
        }
        return templateModel.get("mutiname");
    }

    private void doSave(TemplateModel template) {
        try (TXHandle tx = TX.required();){
            try {
                DynamicObject sheetTemp;
                if (template.isOldTemplate()) {
                    sheetTemp = this.loadById((Long)template.get("id"), this.getPageCache().get(ENABLE_FLAG) == null);
                    this.genDynamicObject(template, sheetTemp);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sheetTemp});
                    PaperTemplateService.moveAllVersion2Catalog((Collection)Lists.newArrayList((Object[])new Object[]{sheetTemp.getLong("id")}), (long)this.getModelId(), (long)sheetTemp.getLong("templatecatalog"), Collections.singleton(sheetTemp.getLong("group")), SaveServiceHelper::save);
                } else {
                    sheetTemp = BusinessDataServiceHelper.newDynamicObject((String)template.getDataEntityNumber());
                    this.genDynamicObject(template, sheetTemp);
                    sheetTemp.set("effectivedate", (Object)EntityVersioningUtil.getModelBeginDate((Object)this.getModelId()));
                    sheetTemp.set("creator", (Object)this.getUserId());
                    sheetTemp.set("createtime", (Object)new Date());
                    sheetTemp.set("executeorder", (Object)new BigDecimal("99999"));
                    BusinessDataWriter.save((IDataEntityType)sheetTemp.getDataEntityType(), (Object[])new Object[]{sheetTemp});
                }
                this.checkRepeatSave(sheetTemp);
                this.checkBaseDataRef(sheetTemp);
                long id = sheetTemp.getLong("id");
                DynamicObjectCollection entries = this.getSheetEntriesByTemplateId(id);
                this.checkRelationType(sheetTemp, entries);
                this.checkRelaCslscheme(sheetTemp);
                Map tmplSceneMap = (Map)template.get(TMPL_SCENE_CACHE);
                PaperTemplateHelper.saveTmplScene((long)template.getModelId(), (PaperTemplateTypeEnum)PaperTemplateTypeEnum.INVELIM, (long)template.getGroup(), (List)((List)tmplSceneMap.get("items")));
                DeleteServiceHelper.delete((String)"bcm_invsheetacclayout", (QFilter[])new QFilter[]{new QFilter("template", "=", (Object)id)});
                List<DynamicObject> list = this.getSheetAccLayouts(entries, id);
                BusinessDataWriter.save((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"bcm_invsheetacclayout"), (Object[])list.toArray());
                PermClassEntityHelper.savePermClass((DynamicObject)sheetTemp);
            }
            catch (Exception e) {
                template.remove("status");
                tx.markRollback();
                throw e;
            }
        }
    }

    private void checkRelaCslscheme(DynamicObject sheetTemp) {
        String process = MemberReader.findProcessMemberById((String)this.getCurModelNumber(), (Long)((Long)this.getTemplateModel().get("process"))).getNumber();
        if (OrgRelaProcessMembPool.isRelaProcess((String)process)) {
            sheetTemp.set("relacslscheme", null);
        } else {
            List relaCslIdList = sheetTemp.getDynamicObjectCollection("relacslscheme").stream().map(template -> template.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
            KDAssert.assertTrue((boolean)QueryServiceHelper.exists((String)"bcm_cslscheme", (QFilter[])new QFilter("model", "=", (Object)this.getTemplateModel().getModelId()).and("id", "in", relaCslIdList).toArray()), () -> new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5173\u8054\u7ec4\u7ec7\u89c6\u56fe", (String)"InvSheetTemplateEditPlugin_38", (String)CUR_APP, (Object[])new Object[0])));
        }
    }

    private void checkBaseDataRef(DynamicObject dynamicObject) {
        long dataModelId = dynamicObject.getLong("extdimid");
        KDAssert.assertTrue((boolean)QueryServiceHelper.exists((String)"bcm_extendsmodel", (Object)dataModelId), () -> new KDBizException(this.dataModelHadDelete()));
    }

    private void checkRelationType(DynamicObject sheetTemp, DynamicObjectCollection entries) {
        List templateRelationTypes = sheetTemp.getDynamicObjectCollection("invrelationtype").stream().map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
        Set names = entries.stream().filter(entry -> !templateRelationTypes.contains(entry.getLong("relationtype"))).map(entry -> entry.getString("relationtype.name")).collect(Collectors.toSet());
        KDAssert.assertTrue((boolean)names.isEmpty(), () -> new KDBizException(String.format(this.getRelationTypeCheckMsg(), String.join((CharSequence)",", names))));
        KDAssert.assertTrue((boolean)InvRelationTypeHelper.allPkExists((Set)Sets.newHashSet(templateRelationTypes)), () -> new KDBizException(this.relationTypeHadDelete()));
    }

    private void checkRepeatSave(DynamicObject dynamicObject) {
        String longNumber = "root.InvElim";
        String[] split = longNumber.split("\\.");
        String number = dynamicObject.getString("number");
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)dynamicObject.getLong("model")).and("templatecatalog.longnumber", "like", (Object)(split[0] + "." + split[1] + "%")).and("group", "!=", (Object)dynamicObject.getLong("group")).and("number", "=", (Object)number);
        boolean exists = QueryServiceHelper.exists((String)"bcm_papertemplate", (QFilter[])qfBuilder.toArray());
        KDAssert.assertFalse((boolean)exists, () -> new NotificationException(this.getInvSheetTemplateEditPlugin27(number)));
    }

    private DynamicObject genDynamicObject(TemplateModel template, DynamicObject dynamicObject) {
        DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            Object value = template.get(name);
            if (name.equals("name") && !(value instanceof OrmLocaleValue)) {
                value = template.get("mutiname");
            }
            if ("effective".equalsIgnoreCase(name)) continue;
            if (value == null || property instanceof BasedataProp && value instanceof Long && (Long)Long.class.cast(value) == 0L) {
                dynamicObject.set(name, null);
                continue;
            }
            if ("invrelationtype".equals(name) && value instanceof DynamicObjectCollection) {
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("invrelationtype");
                for (DynamicObject object : (DynamicObjectCollection)value) {
                    DynamicObject dynamicObject1 = dynamicObjectCollection.addNew();
                    KDAssert.assertTrue((boolean)Objects.nonNull(object.getDynamicObject("fbasedataid")), () -> new KDBizException(this.relationTypeHadDelete()));
                    dynamicObject1.set("fbasedataid", object.getDynamicObject("fbasedataid").getPkValue());
                }
            } else if ("relacslscheme".equals(name) && value instanceof DynamicObjectCollection) {
                DynamicObjectCollection relaCslschemeS = dynamicObject.getDynamicObjectCollection("relacslscheme");
                for (DynamicObject object : (DynamicObjectCollection)value) {
                    DynamicObject relaCslscheme = relaCslschemeS.addNew();
                    KDAssert.assertTrue((boolean)Objects.nonNull(object.getDynamicObject("fbasedataid")), () -> new KDBizException(this.relationTypeHadDelete()));
                    relaCslscheme.set("fbasedataid", object.getDynamicObject("fbasedataid").getPkValue());
                }
            }
            dynamicObject.set(name, value);
        }
        PaperTemplateHelper.buildTemplateEffectDate((Map)template.getEffectivedata(), (DynamicObject)dynamicObject);
        return dynamicObject;
    }

    private TemplateModel fillTemplateModel(String spreadJson) {
        TemplateModel template = this.getTemplateModel();
        Map tmplSceneMap = (Map)template.get(TMPL_SCENE_CACHE);
        if (tmplSceneMap == null || tmplSceneMap.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u4e2d\u6ca1\u6709\u8bbe\u7f6e\u9002\u7528\u60c5\u666f\u3002", (String)"InvSheetTemplateEditPlugin_2", (String)CUR_APP, (Object[])new Object[0]));
        }
        List items = (List)tmplSceneMap.get("items");
        if (CollectionUtils.isEmpty((Collection)items)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u4e2d\u6ca1\u6709\u8bbe\u7f6e\u9002\u7528\u60c5\u666f\u3002", (String)"InvSheetTemplateEditPlugin_2", (String)CUR_APP, (Object[])new Object[0]));
        }
        KDAssert.assertTrue((template.get("spreadtype") != null ? 1 : 0) != 0, () -> new NotificationException(this.getInvSheetTemplateEditPlugin9()));
        template.put("spreadjson", (Object)spreadJson);
        SpreadManager spreadManager = this.getSpreadModel();
        Sheet sheet = spreadManager.getBook().getSheet(0);
        sheet.putUserObject("dataunit", (Object)0);
        String data = JsonSerializerUtil.toJson((SpreadManager)spreadManager);
        template.put("data", (Object)data);
        template.getGroup();
        if (this.getPageCache().get(ENABLE_FLAG) != null) {
            template.put("status", (Object)InvSheetTemplateConstant.BillStatusEnum.ENABLE.getCode());
        }
        template.put("modifier", (Object)this.getUserId());
        template.put("modifytime", (Object)new Date());
        template.setDataEntityNumber("bcm_papertemplate");
        return template;
    }

    private boolean isPreSaveOrNew(TemplateModel template) {
        return InvSheetTemplateConstant.BillStatusEnum.PRE_SAVE.getCode().equals(template.get("status")) || !template.isOldTemplate();
    }

    private List<DynamicObject> getSheetAccLayouts(DynamicObjectCollection entries, Long id) {
        TemplateModel templateModel = this.getTemplateModel();
        String spreadType = (String)templateModel.get("spreadtype");
        if (StringUtils.isEmpty((CharSequence)spreadType)) {
            return Collections.emptyList();
        }
        List<Cell> cells = this.getAccCells(spreadType);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
        HashSet<Long> extDims = new HashSet<Long>(16);
        HashMap<Long, String> dim2Position = new HashMap<Long, String>(cells.size());
        for (Cell cell1 : cells) {
            Object accId = cell1.getUserObject("id");
            if (accId == null) continue;
            Long extDimId = (Long)Long.class.cast(accId);
            String accName = (String)cell1.getUserObject("name");
            KDAssert.assertTrue((boolean)extDims.add(extDimId), () -> new KDBizException(this.getInvSheetTemplateEditPlugin21(accName)));
            int col1 = cell1.getCol();
            int row = cell1.getRow();
            String position = ExportUtil.getColumnLabel((int)(col1 + 1)) + (row + 1);
            dim2Position.put(extDimId, position);
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_invsheetacclayout");
            dynamicObject.set("template", (Object)id);
            dynamicObject.set("position", (Object)position);
            dynamicObject.set("extdimid", (Object)extDimId);
            list.add(dynamicObject);
        }
        this.validateExtDim(dim2Position, extDims);
        this.validateExtDim(entries, extDims);
        return list;
    }

    private void validateExtDim(Map<Long, String> dim2Position, Set<Long> extDims) {
        List ids = ExtDimensionHelper.getIdsByIds(extDims);
        List positions = extDims.stream().filter(id -> !ids.contains(id)).map(dim2Position::get).collect(Collectors.toList());
        KDAssert.assertTrue((boolean)positions.isEmpty(), () -> new KDBizException(String.format(this.getDimHadRemoveMsg(), String.join((CharSequence)",", positions))));
    }

    private void validateExtDim(DynamicObjectCollection query, Set<Long> extDims) {
        String ruleExprPro = "invelimtplentry.ruleexpr";
        String ruleExprDeptPro = "invelimtplentry.ruleexprdept";
        HashSet<String> validateResult = new HashSet<String>(16);
        for (DynamicObject dynamicObject : query) {
            if (dynamicObject.getString(ruleExprPro).equals("bn") || dynamicObject.getString(ruleExprDeptPro).equals("bn")) continue;
            long ruleExpr = dynamicObject.getLong(ruleExprPro);
            long ruleExprDept = dynamicObject.getLong(ruleExprDeptPro);
            if (ruleExpr != 0L && !extDims.contains(ruleExpr)) {
                validateResult.add(dynamicObject.getString("number") + " " + dynamicObject.getString("name"));
            }
            if (ruleExprDept == 0L || extDims.contains(ruleExprDept)) continue;
            validateResult.add(dynamicObject.getString("number") + " " + dynamicObject.getString("name"));
        }
        KDAssert.assertTrue((boolean)validateResult.isEmpty(), () -> new KDBizException(this.getInvSheetTemplateEditPlugin22(validateResult)));
    }

    private DynamicObjectCollection getSheetEntriesByTemplateId(Long id) {
        String ruleExprPro = "invelimtplentry.ruleexpr";
        String ruleExprDeptPro = "invelimtplentry.ruleexprdept";
        TemplateModel templateModel = this.getTemplateModel();
        QFBuilder qfBuilder = new QFBuilder("sheettemplate", "=", (Object)id).and("model", "=", (Object)templateModel.getModelId());
        String selectFields = new StringJoiner(",").add("number").add("name").add("relationtype").add("relationtype.name").add(ruleExprPro).add(ruleExprDeptPro).toString();
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_invsheetttplentrys", (String)selectFields, (QFilter[])qfBuilder.toArray());
        return query;
    }

    private List<Cell> getAccCells(String spreadType) {
        List cells;
        Sheet sheet = this.getEffectiveSheet();
        if (Objects.isNull(spreadType)) {
            return Collections.emptyList();
        }
        if (this.isFloatRow(spreadType)) {
            Object startRow = sheet.getUserObject(START_ROW);
            cells = sheet.getRow(((Integer)Integer.class.cast(startRow)).intValue());
        } else {
            Object startCol = sheet.getUserObject(START_COL);
            cells = sheet.getCol(((Integer)Integer.class.cast(startCol)).intValue());
        }
        return cells;
    }

    private void cellF7Enable(int r, int c) {
        HashMap<String, Serializable> features = new HashMap<String, Serializable>(16);
        ArrayList items = new ArrayList(10);
        HashMap<String, Integer> feature = new HashMap<String, Integer>(16);
        feature.put(SpreadProperties.SetF7TypeCellMethod.R.k(), r);
        feature.put(SpreadProperties.SetF7TypeCellMethod.C.k(), c);
        items.add(feature);
        features.put(SpreadProperties.SetF7TypeCellMethod.CELL.k(), items);
        features.put(SpreadProperties.SetF7TypeCellMethod.SELECTTYPE.k(), Integer.valueOf(1));
        SpreadClientInvoker.invokeSetF7TypeCellMethod(this.getClientViewProxy(), "template_spread", features);
    }

    private void deleteRank() {
        Sheet sheet = this.getEffectiveSheet();
        ArrayList cells = new ArrayList();
        sheet.iteratorCells(cells::add);
        if (cells.isEmpty() || sheet.getUserObject(START_ROW) == null) {
            return;
        }
        int minRow = (Integer)sheet.getUserObject(START_ROW);
        int maxRow = Integer.MIN_VALUE;
        int minCol = (Integer)sheet.getUserObject(START_COL);
        int maxCol = Integer.MIN_VALUE;
        for (Cell cell : cells) {
            if (cell.getUserObject().size() == 0) continue;
            maxRow = Math.max(maxRow, cell.getRow());
            maxCol = Math.max(maxCol, cell.getCol());
        }
        TemplateModel templateModel = this.getTemplateModel();
        String spreadType = (String)templateModel.get("spreadtype");
        if (!this.isFloatRow(spreadType)) {
            SearchHelper.clearCellsStyle(this.getClientViewProxy(), this.getSpreadKey(), minRow, minCol, maxRow - minRow + 1, 2);
            this.deleteCellValue(minRow, minCol, maxRow - minRow + 1, 2);
        } else {
            SearchHelper.clearCellsStyle(this.getClientViewProxy(), this.getSpreadKey(), minRow, minCol, 2, maxCol - minCol + 1);
            this.deleteCellValue(minRow, minCol, 2, maxCol - minCol + 1);
        }
        this.cacheSpreadModel(this.getSpreadModel());
    }

    private void handleCallBackBaseInfo(Map<String, Object> returnData) {
        TemplateModel template = this.getTemplateModel();
        template.put("number", returnData.get("number"));
        template.put("name", returnData.get("name"));
        template.put("mutiname", returnData.get("mutiname"));
        template.put("templatecatalog", returnData.get("templatecatalog"));
        template.put("permclass", returnData.get("permclass"));
        template.put("process", returnData.get("process"));
        template.put("effectivedata", returnData.get("effectivedata"));
        template.put("effectivetext", returnData.get("effectivetext"));
        Object tmplSceneMap = this.deSerializedBytes(returnData.get(TMPL_SCENE_CACHE).toString());
        template.put(TMPL_SCENE_CACHE, tmplSceneMap);
        this.reCacheTemplateModel(template);
    }

    private void showFormulaList(Expression e, String formula) {
        if (e instanceof FunctionExpr) {
            String selectedNodeNumber = ((FunctionExpr)e).getFuncionName().toLowerCase(Locale.ENGLISH);
            for (Object param : ((FunctionExpr)e).getParameters()) {
                if (param instanceof StringExpr) continue;
                this.showFormulaList(formula);
                return;
            }
            boolean exitformula = FormulaConfig.getInstance().getFormulaList().stream().anyMatch(f -> selectedNodeNumber.equals(((String)f.get("number")).toLowerCase(Locale.ENGLISH)));
            if (exitformula && !FormulaConstant.IGNORFORMULAS.contains(selectedNodeNumber)) {
                FormShowParameter parameter = new FormShowParameter();
                Formula formula1 = ResourcesLoaderUtil.getFormulaByNumber((String)selectedNodeNumber);
                ShowFormulaUtil.selectGuidePage(ResourcesLoaderUtil.getFormulaByNumber((String)selectedNodeNumber), parameter, this.getModelId());
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCaption(formula1.getNumber() + this.getInvSheetTemplateEditPlugin18());
                parameter.setStatus(OperationStatus.EDIT);
                parameter.setCustomParam("accttype", (Object)selectedNodeNumber);
                parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
                if (formula != null) {
                    parameter.setCustomParam("formula", (Object)ShowFormulaUtil.formula2LowerCase(formula));
                }
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_formulapicker_invest");
                parameter.setCloseCallBack(closeCallBack);
                if (formula1.getNumber().equalsIgnoreCase("v")) {
                    parameter.setFormId("bcm_invvformula");
                    FormulaTicketer ticketer = this.buildTicketer();
                    parameter.setCustomParam("FormulaTicketer", (Object)this.toByteSerialized(ticketer));
                    parameter.setCustomParam("is_draft", (Object)true);
                } else if (formula1.getNumber().equalsIgnoreCase("esp")) {
                    parameter.setCustomParam("sharescaletype", (Object)SharescaleTypeEnum.direct.getIndex());
                    parameter.setCustomParam("is_draft", (Object)true);
                    parameter.setFormId("bcm_espfunctionset");
                } else if (formula1.getNumber().equalsIgnoreCase("p")) {
                    HashSet disableBtn = Sets.newHashSet((Object[])new String[]{"inv", "bn"});
                    parameter.setCustomParam("is_draft", (Object)true);
                    parameter.setCustomParam("disable_btn", (Object)disableBtn);
                    parameter.setFormId("bcm_invchangeformula");
                    parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FORMULA_PICKER_P_BACK));
                    if (formula != null) {
                        parameter.setCustomParam("formula", (Object)ShowFormulaUtil.formula2LowerCase(formula.substring(2, formula.length() - 1)));
                    }
                } else if (formula1.getNumber().equalsIgnoreCase("getinvper")) {
                    parameter.setFormId("bcm_invperformula");
                    parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_formulapicker_invest"));
                } else if (formula1.getNumber().equalsIgnoreCase("getinvact")) {
                    parameter.setFormId("bcm_invactformula");
                    parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_formulapicker_invest"));
                } else if (formula1.getNumber().equalsIgnoreCase("desp")) {
                    parameter.setFormId("bcm_despfunctionset");
                    parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_formulapicker_invest"));
                } else if (formula1.getNumber().equalsIgnoreCase("getjlentry")) {
                    parameter.setFormId("bcm_getjlentryformula_inv");
                } else if (formula1.getNumber().equalsIgnoreCase("excrate")) {
                    FormulaTicketer<DynamicObject> ticketer = InvestFormulaRegisterHelper.buildExcRateTicketer(formula1, this.getModelId());
                    parameter.setCustomParam("FormulaTicketer", (Object)this.toByteSerialized(ticketer));
                    parameter.setFormId("bcm_invexrateformula");
                }
                this.getView().showForm(parameter);
                return;
            }
        }
        this.showFormulaList(formula);
    }

    private FormulaTicketer buildTicketer() {
        FormulaTicketer ticketer = new FormulaTicketer();
        IValidate notnull = (IValidate)IValidate.build(NotNullValidate.class);
        DynamicObjectCollection alldims = QueryDimensionServiceHelper.getDimensionBaseInfos((Object)this.getModelId());
        for (DynamicObject obj : alldims) {
            String sign;
            String entity = obj.getString("membermodel");
            String number = obj.getString("number");
            String name = obj.getString("name");
            if ("bcm_entitymembertree".equals(entity) || "bcm_icmembertree".equals(entity) || "bcm_mycompanymembertree".equals(entity) || "bcm_currencymembertree".equals(entity)) {
                ticketer.addTicket(entity, new FTicket(entity, name, null, false, false));
                continue;
            }
            if ("bcm_accountmembertree".equals(entity) || "bcm_changetypemembertree".equals(entity) || "bcm_userdefinedmembertree".equals(entity) || "bcm_audittrialmembertree".equals(entity)) {
                sign = this.sugarF7Key(entity, number);
                ticketer.addTicket(sign, new FTicket(entity, name, notnull, true, true, true));
                continue;
            }
            if ("bcm_scenemembertree".equals(entity) || "bcm_fymembertree".equals(entity) || "bcm_periodmembertree".equals(entity) || "bcm_processmembertree".equals(entity)) {
                ticketer.addTicket(entity, new FTicket(entity, name, null, true, true));
                continue;
            }
            sign = this.sugarF7Key(entity, number);
            ticketer.addTicket(sign, new FTicket(entity, name, notnull, true, true, true));
        }
        return ticketer;
    }

    private void handleCallBackCellF7(DynamicObject returnData) {
        int r = this.getF7SelectRow();
        int c = this.getF7SelectCol();
        this.getPageCache().remove("f7select");
        Cell cell = this.getEffectiveSheet().getCell(r, c);
        Map<Long, String> hadChangeAccounts = this.hadChangeAccounts();
        long accId = returnData.getLong("id");
        String name = returnData.getString("name");
        String number = returnData.getString("number");
        String position = hadChangeAccounts.get(accId);
        String accCellValue = this.buildAccCellValue(number, name);
        KDAssert.assertTrue((boolean)StringUtils.isEmpty((CharSequence)position), () -> new NotificationException(this.getInvSheetTemplateEditPlugin11(position, accCellValue)));
        cell.setUserObject("name", (Object)name);
        cell.setUserObject("number", (Object)number);
        cell.setUserObject("id", (Object)accId);
        cell.setValue((Object)accCellValue);
        HashMap<String, Object> valMap = new HashMap<String, Object>();
        valMap.put(SpreadProperties.UpdataValueMethod.R.k(), r);
        valMap.put(SpreadProperties.UpdataValueMethod.C.k(), c);
        valMap.put(SpreadProperties.UpdataValueMethod.V.k(), accCellValue);
        ArrayList<HashMap<String, Object>> cellValues = new ArrayList<HashMap<String, Object>>();
        cellValues.add(valMap);
        SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), "template_spread", Lists.newArrayList(cellValues));
    }

    private String buildAccCellValue(String number, String name) {
        return number + " " + name;
    }

    private void handleCallBackFormula(String returnData) {
        Cell cell = this.getEffectiveSheet().getCell(this.getSelectorStartRow(), this.getSelectorStartCol());
        cell.setFormula(returnData);
        HashMap<String, Object> formula = new HashMap<String, Object>();
        formula.put(SpreadProperties.SetFormulaMethod.R.k(), cell.getRow());
        formula.put(SpreadProperties.SetFormulaMethod.C.k(), cell.getCol());
        formula.put(SpreadProperties.SetFormulaMethod.F.k(), returnData);
        formula.put(SpreadProperties.SetFormulaMethod.isUndo.k(), true);
        SpreadClientInvoker.invokeSetFormulaMethod(this.getClientViewProxy(), "template_spread", Lists.newArrayList((Object[])new Map[]{formula}));
    }

    private Map<Long, String> hadChangeAccounts() {
        TemplateModel templateModel = this.getTemplateModel();
        String spreadType = (String)templateModel.get("spreadtype");
        if (StringUtils.isEmpty((CharSequence)spreadType)) {
            return Collections.emptyMap();
        }
        List<Cell> accCells = this.getAccCells(spreadType);
        HashMap<Long, String> accounts = new HashMap<Long, String>(accCells.size());
        for (Cell cell : accCells) {
            Object id = cell.getUserObject("id");
            if (id == null) continue;
            accounts.put((Long)Long.class.cast(id), ExportUtil.getColumnLabel((int)(cell.getCol() + 1)) + (cell.getRow() + 1));
        }
        return accounts;
    }

    private void resetExtDimId(TemplateModel templateModel) {
        String spreadType = (String)templateModel.get("spreadtype");
        List<Cell> accCells = this.getAccCells(spreadType);
        HashMap<String, Cell> number2Cell = new HashMap<String, Cell>(accCells.size());
        for (Cell cell : accCells) {
            Object number = cell.getUserObject("number");
            if (number == null) continue;
            number2Cell.put((String)number, cell);
        }
        long modelId = this.getModelId();
        Set numbers = number2Cell.keySet();
        Long extModelId = (Long)templateModel.get("extdimid");
        DynamicObjectCollection extDys = ExtDimensionHelper.getSheetExtMemberByExtModel((long)modelId, numbers, (Long)extModelId);
        for (DynamicObject extDy : extDys) {
            Cell cell = (Cell)number2Cell.get(extDy.getString("number"));
            cell.setUserObject("id", (Object)extDy.getLong("id"));
        }
        this.getPageCache().put(this.KEY_SPREAD_MODEL, this.toSerialSpreadModel(this.spread));
    }

    private String extDimensionF7Key() {
        return "bcm_invsheetaccountlist";
    }

    private void openEntrySetPage() {
        IFormView view;
        this.enableStatusEntryShouldNotNull();
        TemplateModel templateModel = this.getTemplateModel();
        HashMap<String, String> openParameter = new HashMap<String, String>();
        openParameter.put("type", "base");
        openParameter.put("formId", "bcm_invsheetttplentrys");
        BaseShowParameter formShowParameter = (BaseShowParameter)FormShowParameter.createFormShowParameter(openParameter);
        formShowParameter.setStatus(this.getOpenFormStatus());
        formShowParameter.setFormId("bcm_invsheetttplentrys");
        formShowParameter.setPageId(this.getView().getPageId() + "bcm_invsheetttplentrys");
        formShowParameter.setCaption(this.getInvSheetTemplateEditPlugin10());
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("model", (Object)this.getModelId());
        if (LongUtil.isvalidLong((Object)templateModel.get("scenario"))) {
            formShowParameter.setCustomParam("scenario", templateModel.get("scenario"));
        }
        formShowParameter.setCustomParam("id", templateModel.get("id"));
        formShowParameter.setCustomParam("templatecatalog", templateModel.get("templatecatalog"));
        formShowParameter.setCustomParam("number", templateModel.get("number"));
        formShowParameter.setCustomParam("cb_process_value", templateModel.get("cb_process_value"));
        formShowParameter.setCustomParam("process", templateModel.get("process"));
        if (this.getView().getMainView() != null && (view = this.getView().getMainView().getView(this.getView().getPageId() + "bcm_invsheetttplentrys")) != null) {
            view.activate();
        }
        this.getView().showForm((FormShowParameter)formShowParameter);
        this.writeOperationLog(this.getInvSheetTemplateEditPlugin32(), this.getInvSheetTemplateEditPlugin36());
    }

    private OperationStatus getOpenFormStatus() {
        if (this.isPreSaveOrNew(this.getTemplateModel())) {
            return OperationStatus.ADDNEW;
        }
        if (this.isViewStatus()) {
            return OperationStatus.VIEW;
        }
        return OperationStatus.EDIT;
    }

    private void enableStatusEntryShouldNotNull() {
        if (this.isViewStatus()) {
            TemplateModel templateModel = this.getTemplateModel();
            long id = templateModel.getId();
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_papertemplate", (String)"count", (QFilter[])new QFBuilder("id", "=", (Object)id).toArray());
            int count = dynamicObject.getInt("count");
            KDAssert.assertTrue((count > 0 ? 1 : 0) != 0, () -> new NotificationException(this.getInvSheetTemplateEditPlugin19()));
        }
    }

    private void setChange() {
        this.getPageCache().put(CHANGE_FLAG, "true");
    }

    private void removeChange() {
        this.getPageCache().remove(CHANGE_FLAG);
    }

    private String colNumbersToColName(String msg) {
        String[] split = msg.split(",");
        StringJoiner colMsg = new StringJoiner(",");
        for (String col : split) {
            colMsg.add(ExportUtil.getColumnLabel((int)Integer.parseInt(col)));
        }
        return colMsg.toString();
    }

    private void updateStatus(String status) {
        TemplateModel templateModel = this.getTemplateModel();
        long id = templateModel.getId();
        DynamicObject dynamicObject = this.loadById(id, false);
        dynamicObject.set("status", (Object)status);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private void reCacheTemplateModel(TemplateModel templateModel) {
        templateModel.setRptData(null);
        this.template = null;
        this.cacheTemplateModel(templateModel);
    }

    private void callSpreadJSToSave() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SpreadProperties.SetUpdateFrontFormula.SI.k(), "0");
        params.put(SpreadProperties.SetUpdateFrontFormula.OPTIONS.k(), "all");
        params.put(SpreadProperties.SetUpdateFrontFormula.CALLBACK.k(), "invokeAction");
        params.put(SpreadProperties.SetUpdateFrontFormula.INVOKEMETHOD.k(), "updateFormula");
        SpreadClientInvoker.invokeGetFormulaMethod(this.getClientViewProxy(), "template_spread", params);
    }

    public void updateFormula(Object formulaJson) {
        if (formulaJson instanceof String && kd.bos.util.StringUtils.isNotEmpty((String)formulaJson.toString())) {
            JSONArray objArray = JSON.parseArray((String)ObjectSerialUtil.uncompress((String)formulaJson.toString()));
            Sheet sheet = this.getSpreadModel().getBook().getSheet(0);
            ArrayListMultimap multimap = ArrayListMultimap.create();
            sheet.iteratorCells(cell -> multimap.put((Object)cell.getRow(), (Object)cell.getCol()));
            for (int i = 0; i < objArray.size(); ++i) {
                JSONObject json = objArray.getJSONObject(i);
                int r2 = json.getIntValue(SpreadProperties.SetUpdateFrontFormula.R.k());
                int c2 = json.getIntValue(SpreadProperties.SetUpdateFrontFormula.C.k());
                String f = json.getString(SpreadProperties.SetUpdateFrontFormula.F.k());
                sheet.getCell(r2, c2).setFormula(f);
                multimap.remove((Object)r2, (Object)c2);
            }
            multimap.forEach((r, c) -> {
                Cell cell = sheet.getCell(r.intValue(), c.intValue());
                if (Objects.nonNull(cell.getFormula())) {
                    cell.setFormula(null);
                    cell.setValue(null);
                }
            });
            this.cacheSpreadModel();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("callback", "invokeAction");
        params.put("invokemethod", "actionSave");
        SpreadClientInvoker.invokeGetSpreadJsonMethod(this.getClientViewProxy(), this.getSpreadKey(), params);
    }

    private void intViewByStatus() {
        TemplateModel templateModel = this.getTemplateModel();
        String status = (String)templateModel.get("status");
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_save", "btn_disable", "btn_enable", "btn_refresh"});
        if (this.isViewStatus()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_disable", "btn_enable", "btn_refresh"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_save"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_enable"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"btn_disable"});
            this.getView().setVisible(Boolean.valueOf(!super.isViewStatus()), new String[]{"btn_enable"});
        } else if (InvSheetTemplateConstant.BillStatusEnum.DISABLE.getCode().equals(status)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_save", "btn_disable", "btn_enable", "btn_refresh"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_disable"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"btn_enable"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_refresh", "btn_disable", "btn_enable"});
        }
    }

    private boolean changeNotViewStatus() {
        return this.getPageCache().get(CHANGE_FLAG) != null && !this.isViewStatus();
    }

    private void doRefresh() {
        TemplateModel template = this.getTemplateModel();
        Long id = (Long)template.get("id");
        DynamicObject dyna = this.loadById(id, true);
        TemplateModel templateModel = TemplateModel.genTemplateModelBy((DynamicObject)dyna);
        String json = templateModel.getSpreadJson();
        this.spread = null;
        this.getPageCache().put(this.KEY_SPREAD_MODEL, dyna.getString("data"));
        this.resetExtDimId(templateModel);
        SpreadClientInvoker.invokeSetSpreadJsonMethod(this.getClientViewProxy(), "template_spread", json);
        this.reCacheTemplateModel(templateModel);
        this.cacheSpreadModel();
        this.removeChange();
        this.intViewByStatus();
        this.writeOperationLog(this.getInvSheetTemplateEditPlugin35(), ResultStatusEnum.SUCCESS.getName());
    }

    private DynamicObject loadById(Long id, boolean changeModify) {
        DynamicObject[] dynamicObjects;
        String selectProperties = InvSheetTemplateConstant.allSelectFields();
        if (changeModify) {
            selectProperties = selectProperties + "," + "modifier" + "," + "modifytime";
        }
        KDAssert.assertFalse(((dynamicObjects = BusinessDataServiceHelper.load((String)"bcm_papertemplate", (String)selectProperties, (QFilter[])new QFBuilder("id", "=", (Object)id).toArray())).length == 0 ? 1 : 0) != 0, () -> new DataDeletedException(this.getInvSheetTemplateEditPlugin28(this.getView().getFormShowParameter().getCaption().split("-")[1])));
        return dynamicObjects[0];
    }

    private void closeAndShowError(DataDeletedException ex) {
        log.error((Throwable)ex);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.showErrorNotification(ex.getMessage());
        }
        this.getView().close();
    }

    private String getFirstRelationType() {
        DynamicObjectCollection invRelationTypes = (DynamicObjectCollection)this.getTemplateModel().get("invrelationtype");
        DynamicObjectCollection dynamicObjects = InvRelationTypeHelper.categorizedRelationDysInIds((Collection)invRelationTypes, (InvRelationTypeConstant.CatalogEnum)InvRelationTypeConstant.CatalogEnum.relation, dy -> dy.getLong("fbasedataid.id"));
        return Optional.ofNullable(dynamicObjects).filter(collection -> !collection.isEmpty()).map(collection -> (DynamicObject)collection.get(0)).map(dy -> dy.getString("number")).orElseGet(() -> ((InvRelaTypeEnum)InvRelaTypeEnum.DirectRelaType).getType());
    }

    private String getInvSheetTemplateEditPlugin3() {
        return ResManager.loadKDString((String)"\u5f53\u524d\u4f4d\u7f6e\u4e3a\u8868\u5934\uff0c\u8bf7\u901a\u8fc7F7\u9009\u62e9\u9879\u76ee\u3002", (String)"InvSheetTemplateEditPlugin_3", (String)CUR_APP, (Object[])new Object[0]);
    }

    private String getInvSheetTemplateEditPlugin4() {
        return ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u9875\u9762\u5e03\u5c40\u3002", (String)"InvSheetTemplateEditPlugin_4", (String)CUR_APP, (Object[])new Object[0]);
    }

    private String getInvSheetTemplateEditPlugin6() {
        return ResManager.loadKDString((String)"\u5b58\u5728\u672a\u4fdd\u5b58\u7684\u64cd\u4f5c\uff0c\u662f\u5426\u9000\u51fa\uff1f", (String)"InvSheetTemplateEditPlugin_5", (String)CUR_APP, (Object[])new Object[0]);
    }

    private String getInvSheetTemplateEditPlugin7() {
        return ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"InvSheetTemplateEditPlugin_1", (String)CUR_APP, (Object[])new Object[0]);
    }

    private String getInvSheetTemplateEditPlugin8() {
        return ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"InvSheetTemplateEditPlugin_6", (String)CUR_APP, (Object[])new Object[0]);
    }

    private String getInvSheetTemplateEditPlugin9() {
        return ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u9875\u9762\u5e03\u5c40\u3002", (String)"InvSheetTemplateEditPlugin_7", (String)CUR_APP, (Object[])new Object[0]);
    }

    private String getInvSheetTemplateEditPlugin10() {
        return ResManager.loadKDString((String)"\u6743\u76ca\u5e95\u7a3f\u6a21\u677f\u5206\u5f55", (String)"InvSheetTemplateEditPlugin_8", (String)CUR_APP, (Object[])new Object[0]);
    }

    private String getInvSheetTemplateEditPlugin11(String cellValue, String position) {
        return String.format(ResManager.loadKDString((String)"%1$s\u5df2\u9009\u62e9\u9879\u76ee\u201c%2$s\u201d\uff0c\u4e0d\u80fd\u91cd\u590d\u3002", (String)"InvSheetTemplateEditPlugin_9", (String)CUR_APP, (Object[])new Object[0]), cellValue, position);
    }

    private String getInvSheetTemplateEditPlugin12() {
        return ResManager.loadKDString((String)"\u516c\u5f0f\u89e3\u6790\u9519\u8bef\uff01", (String)"InvSheetTemplateEditPlugin_10", (String)CUR_APP, (Object[])new Object[0]);
    }

    private String getInvSheetTemplateEditPlugin13() {
        return ResManager.loadKDString((String)"\u65e0\u6cd5\u9009\u62e9\u6210\u5458\u3002\u6240\u9009\u5355\u5143\u683c\u4e2d\uff0c\u6210\u5458\u4e0d\u5728\u6709\u6548\u7684\u9879\u76ee\u533a\u57df\u5185\uff0c\u8bf7\u68c0\u67e5\uff01", (String)"InvSheetTemplateEditPlugin_11", (String)CUR_APP, (Object[])new Object[0]);
    }

    @NotNull
    private String getInvSheetTemplateEditPlugin14(String msg) {
        return ResManager.loadKDString((String)"\u7b2c%s\u884c\u4e3a\u8868\u5934\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"InvSheetTemplateEditPlugin_12", (String)CUR_APP, (Object[])new Object[]{msg});
    }

    @NotNull
    private String getInvSheetTemplateEditPlugin15(String msg) {
        return ResManager.loadKDString((String)"\u7b2c%s\u884c\u4e3a\u8868\u5934\uff0c\u4e0d\u80fd\u6dfb\u52a0\u201c\u884c\u201d\u6216\u8005\u201c\u5217\u201d\u3002", (String)"InvSheetTemplateEditPlugin_13", (String)CUR_APP, (Object[])new Object[]{msg});
    }

    @NotNull
    private String getInvSheetTemplateEditPlugin16(String msg) {
        return ResManager.loadKDString((String)"\u7b2c%s\u5217\u4e3a\u8868\u5934\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"InvSheetTemplateEditPlugin_14", (String)CUR_APP, (Object[])new Object[]{this.colNumbersToColName(msg)});
    }

    @NotNull
    private String getInvSheetTemplateEditPlugin17(String msg) {
        return ResManager.loadKDString((String)"\u7b2c%s\u5217\u4e3a\u8868\u5934\uff0c\u4e0d\u80fd\u6dfb\u52a0\u201c\u884c\u201d\u6216\u8005\u201c\u5217\u201d\u3002", (String)"InvSheetTemplateEditPlugin_15", (String)CUR_APP, (Object[])new Object[]{this.colNumbersToColName(msg)});
    }

    private String getInvSheetTemplateEditPlugin18() {
        return ResManager.loadKDString((String)"\u516c\u5f0f\u5411\u5bfc", (String)"InvSheetTemplateEditPlugin_16", (String)CUR_APP, (Object[])new Object[0]);
    }

    private String getInvSheetTemplateEditPlugin19() {
        return ResManager.loadKDString((String)"\u65e0\u5206\u5f55\u8bbe\u7f6e\u7684\u8bb0\u5f55\u3002", (String)"InvSheetTemplateEditPlugin_17", (String)CUR_APP, (Object[])new Object[0]);
    }

    private String getInvSheetTemplateEditPlugin20() {
        return ResManager.loadKDString((String)"\u662f\u5426\u653e\u5f03\u4fee\u6539\u5237\u65b0\uff1f", (String)"InvSheetTemplateEditPlugin_18", (String)CUR_APP, (Object[])new Object[0]);
    }

    @NotNull
    private String getInvSheetTemplateEditPlugin21(String accName) {
        return ResManager.loadKDString((String)"%s,\u9879\u76ee\u91cd\u590d\u9009\u62e9\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvSheetTemplateEditPlugin_19", (String)CUR_APP, (Object[])new Object[]{accName});
    }

    @NotNull
    private String getInvSheetTemplateEditPlugin22(Set<String> validateResult) {
        return ResManager.loadKDString((String)"\u5206\u5f55\u8bbe\u7f6e\u6a21\u677f\u4e2d\u201c%s\u201d\u6240\u9009\u9879\u76ee\u65e0\u6cd5\u5339\u914d\u62a5\u8868\u7684\u8868\u6837\u9879\u76ee\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvSheetTemplateEditPlugin_20", (String)CUR_APP, (Object[])new Object[]{validateResult});
    }

    private String getInvSheetTemplateEditPlugin23() {
        return ResManager.loadKDString((String)"\u65e0\u62d3\u5c55\u7ef4\u79d1\u76ee\u4fe1\u606f,\u8bf7\u524d\u5f80\u7ef4\u5ea6\u7ba1\u7406\u8bbe\u7f6e\u3002", (String)"InvSheetTemplateEditPlugin_21", (String)CUR_APP, (Object[])new Object[0]);
    }

    private String getInvSheetTemplateEditPlugin25() {
        return ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"InvSheetTemplateEditPlugin_22", (String)CUR_APP, (Object[])new Object[0]);
    }

    private String getInvSheetTemplateEditPlugin26() {
        return ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"InvSheetTemplateEditPlugin_23", (String)CUR_APP, (Object[])new Object[0]);
    }

    private String getInvSheetTemplateEditPlugin27(String number) {
        return ResManager.loadKDString((String)"%s:\u6a21\u677f\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"InvSheetTemplateEditPlugin_24", (String)CUR_APP, (Object[])new Object[]{number});
    }

    private String getInvSheetTemplateEditPlugin28(String template) {
        return ResManager.loadKDString((String)"%s\uff1a\u6a21\u677f\u5df2\u88ab\u5220\u9664\u3002", (String)"InvSheetTemplateEditPlugin_25", (String)CUR_APP, (Object[])new Object[]{template});
    }

    private OpNameMultiLangEnumBridge getInvSheetTemplateEditPlugin29() {
        return new OpNameMultiLangEnumBridge("\u4fdd\u5b58", "InvSheetTemplateEditPlugin_26", CUR_APP, "save");
    }

    private OpNameMultiLangEnumBridge getInvSheetTemplateEditPlugin30() {
        return new OpNameMultiLangEnumBridge("\u57fa\u672c\u4fe1\u606f", "InvSheetTemplateEditPlugin_1", CUR_APP, "basicInfo");
    }

    private OpNameMultiLangEnumBridge getInvSheetTemplateEditPlugin31() {
        return new OpNameMultiLangEnumBridge("\u9875\u9762\u5e03\u5c40", "InvSheetTemplateEditPlugin_27", CUR_APP, "layout");
    }

    private OpNameMultiLangEnumBridge getInvSheetTemplateEditPlugin32() {
        return new OpNameMultiLangEnumBridge("\u5206\u5f55\u8bbe\u7f6e", "InvSheetTemplateEditPlugin_28", CUR_APP, "journalSetting");
    }

    private OpNameMultiLangEnumBridge getInvSheetTemplateEditPlugin33() {
        return new OpNameMultiLangEnumBridge("\u542f\u7528", "InvSheetTemplateEditPlugin_29", CUR_APP, ENABLE_FLAG);
    }

    private OpNameMultiLangEnumBridge getInvSheetTemplateEditPlugin34() {
        return new OpNameMultiLangEnumBridge("\u7981\u7528", "InvSheetTemplateEditPlugin_30", CUR_APP, "disable");
    }

    private OpNameMultiLangEnumBridge getInvSheetTemplateEditPlugin35() {
        return new OpNameMultiLangEnumBridge("\u5237\u65b0", "InvSheetTemplateEditPlugin_31", CUR_APP, "refresh");
    }

    private String getInvSheetTemplateEditPlugin36() {
        return ResManager.loadKDString((String)"\u6253\u5f00", (String)"InvSheetTemplateEditPlugin_32", (String)CUR_APP, (Object[])new Object[0]);
    }

    private String getDimHadRemoveMsg() {
        return ResManager.loadKDString((String)"%1$s\u6240\u9009\u79d1\u76ee\u5df2\u88ab\u62d3\u5c55\u7ef4\u5220\u9664\uff0c\u8bf7\u4ece\u8868\u6837\u4e2d\u79fb\u9664\u3002", (String)"InvSheetTemplateEditPlugin_33", (String)CUR_APP, (Object[])new Object[0]);
    }

    private String getRelationTypeCheckMsg() {
        return ResManager.loadKDString((String)"\u9875\u9762\u5e03\u5c40\u672a\u5305\u542b\u5206\u5f55\u8bbe\u7f6e\u7684\u80a1\u6bd4\u7c7b\u578b\u3010%1$s\u3011\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"InvSheetTemplateEditPlugin_34", (String)CUR_APP, (Object[])new Object[0]);
    }

    private String relationTypeHadDelete() {
        return ResManager.loadKDString((String)"\u6301\u80a1\u6bd4\u4f8b\u7c7b\u578b\u4e3a\u7a7a\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"InvSheetTemplateEditPlugin_35", (String)CUR_APP, (Object[])new Object[0]);
    }

    private String dataModelHadDelete() {
        return ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u6a21\u578b\u4e3a\u7a7a\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"InvSheetTemplateEditPlugin_36", (String)CUR_APP, (Object[])new Object[0]);
    }

    private String effectiveDateIsNullMsg() {
        return ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u56e0\u751f\u6548\u65e5\u671f\u4e3a\u7a7a\u542f\u7528\u5931\u8d25\uff0c\u8bf7\u5728\u7248\u672c\u5316\u4e2d\u7ef4\u62a4\u751f\u6548\u65e5\u671f\u3002", (String)"InvSheetTemplateEditPlugin_37", (String)CUR_APP, (Object[])new Object[0]);
    }

    static {
        ITEM_CLICK.put("btn_save", InvSheetTemplateEditPlugin::save);
        ITEM_CLICK.put("btn_baseinfo", InvSheetTemplateEditPlugin::baseInfo);
        ITEM_CLICK.put("btn_dimsetting", InvSheetTemplateEditPlugin::dimSetting);
        ITEM_CLICK.put("btn_entryset", InvSheetTemplateEditPlugin::entrySet);
        ITEM_CLICK.put("btn_enable", InvSheetTemplateEditPlugin::enable);
        ITEM_CLICK.put("btn_disable", InvSheetTemplateEditPlugin::disable);
        ITEM_CLICK.put("btn_refresh", InvSheetTemplateEditPlugin::refresh);
        ITEM_CLICK.put("btn_close", InvSheetTemplateEditPlugin::close);
        CLOSED_CALL_BACK = new HashMap<String, Consumer<? super InvSheetTemplateEditPlugin>>();
        CLOSED_CALL_BACK.put(FORMULA_PICKER_P_BACK, InvSheetTemplateEditPlugin::showFormulaPanelPBack);
        CLOSED_CALL_BACK.put("bcm_formulapicker_invest", InvSheetTemplateEditPlugin::showFormulaPanelBack);
        CLOSED_CALL_BACK.put("bcm_invsheetaccountlist", InvSheetTemplateEditPlugin::spreadF7ClickBack);
        CLOSED_CALL_BACK.put("bcm_invsheet_rank", InvSheetTemplateEditPlugin::dimSettingBack);
        CLOSED_CALL_BACK.put("bcm_papertemplate", InvSheetTemplateEditPlugin::baseInfoBack);
    }

    static class ToolBarAp {
        public static final String TAG = "toolbarap";
        public static final String BTN_ENTRY_SET = "btn_entryset";
        public static final String BTN_SAVE = "btn_save";
        public static final String BTN_BASE_INFO = "btn_baseinfo";
        public static final String BTN_DIM_SETTING = "btn_dimsetting";
        public static final String BTN_ENABLE = "btn_enable";
        public static final String BTN_DISABLE = "btn_disable";
        public static final String BTN_REFRESH = "btn_refresh";
        public static final String BTN_CLOSE = "btn_close";

        ToolBarAp() {
        }
    }

    static class DataDeletedException
    extends RuntimeException {
        public DataDeletedException(String message) {
            super(message);
        }
    }
}

