/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest.sheet;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.logorm.LogORM;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.page.model.TextEditElement;
import kd.fi.bcm.business.page.model.entry.DynamicEntry;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.dataquery.MainQueryPlugin;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.util.ImportAndExportUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class InvSqlQueryResultPlugin
extends MainQueryPlugin
implements DynamicPage {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_MSG = "msgflex";
    private static final String TOOLBAR = "advcontoolbarap";
    private static final String TAB_AP = "tabap";
    private static final String COL_NAMES = "colNames";
    private static final String ENTITY_TYPE = "entityType";
    private static final String LIMIT = "limit";
    private static final String FILTER = "filter";
    private static final String LEFT = "left";
    private static final String MIDDLE = "middle";
    private static final String RIGHT = "right";
    private static final String TEXT_AREA = "infomationtextarea";
    private static final String BTN_EXPORT = "btn_export";
    private static final String DOWNLOAD = "download";
    private static final String VALUE = "10%";
    private static final String NEW_EDIT_VIEW = "new,edit,view";
    private static final String NAME = "name";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(TOOLBAR);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_MSG});
        if (this.isHideSql()) {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>(1);
            map.put("hideNav", true);
            this.getView().updateControlMetadata(TAB_AP, map);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TOOLBAR});
        }
        Map colNameMap = (Map)SerializationUtils.deSerializeFromBase64((String)((String)this.getFormCustomParam(COL_NAMES)));
        String entityType = (String)this.getFormCustomParam(ENTITY_TYPE);
        int limit = (Integer)this.getFormCustomParam(LIMIT);
        Set<String> colNames = colNameMap.keySet();
        JSONArray filter = (JSONArray)this.getFormCustomParam(FILTER);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityType);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        QFBuilder qfBuilder = this.buildQfBuilder(properties, filter);
        this.createTable(colNameMap);
        try (DataSet dataSet = this.executeSql(entityType, colNames, qfBuilder, limit);){
            this.fillData(dataSet, colNames, properties);
        }
        this.autoInCache(COL_NAMES, Lists.newArrayList(colNameMap.keySet()));
    }

    private QFBuilder buildQfBuilder(DataEntityPropertyCollection properties, JSONArray filter) {
        QFBuilder qfBuilder = new QFBuilder();
        filter.forEach(obj -> {
            JSONObject jsonObject = (JSONObject)obj;
            String field = jsonObject.getString(LEFT);
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)field);
            if (property instanceof DateTimeProp) {
                qfBuilder.and(field, jsonObject.getString(MIDDLE), (Object)jsonObject.getDate(RIGHT));
                return;
            }
            qfBuilder.and(field, jsonObject.getString(MIDDLE), jsonObject.get((Object)RIGHT));
        });
        return qfBuilder;
    }

    @Override
    protected void setMsg(String msg) {
        this.getModel().setValue(TEXT_AREA, (Object)msg);
    }

    private DataSet executeSql(String entityType, Collection<String> colNames, QFBuilder qfBuilder, int limit) {
        LogORM logORM = LogORM.create();
        return logORM.queryDataSet(entityType, String.join((CharSequence)",", colNames), qfBuilder.toArray(), 0, limit);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String url;
        super.itemClick(evt);
        if (BTN_EXPORT.equals(evt.getItemKey()) && StringUtils.isNotEmpty((CharSequence)(url = this.handleExportData()))) {
            this.getClientViewProxy().addAction(DOWNLOAD, (Object)url);
        }
    }

    private void createTable(Map<String, String> cols) {
        Page page = new Page();
        DynamicEntry entry = new DynamicEntry(KEY_ENTRYENTITY);
        LocaleString width = new LocaleString(VALUE);
        cols.forEach((k, v) -> {
            Element element = this.buildColEditElement((String)v, (String)k, width, 1);
            entry.addElement(element);
        });
        page.addEntry(entry);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
    }

    private Element buildColEditElement(String name, String sign, LocaleString width, int editStyle) {
        TextEditElement textEditElement = new TextEditElement(name, sign, "");
        textEditElement.setEditStyle(editStyle);
        textEditElement.setWidth(width);
        textEditElement.setLock(NEW_EDIT_VIEW);
        return textEditElement;
    }

    private void fillData(DataSet entryData, Collection<String> colNames, DataEntityPropertyCollection properties) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        HashMap<String, Map<String, Object>> sign2Combo = new HashMap<String, Map<String, Object>>(16);
        for (String colName : colNames) {
            vs.addField(colName, new Object[0]);
            IDataEntityProperty property1 = (IDataEntityProperty)properties.get((Object)colName);
            if (!(property1 instanceof ComboProp)) continue;
            ComboProp a = (ComboProp)property1;
            Map<String, Object> comboMap = a.getComboItems().stream().collect(Collectors.toMap(ValueMapItem::getValue, ValueMapItem::getName, (v1, v2) -> v1));
            sign2Combo.put(colName, comboMap);
        }
        this.fillDataToVs(colNames, entryData, vs, sign2Combo);
        model.batchCreateNewEntryRow(KEY_ENTRYENTITY, vs);
        model.endInit();
        this.getView().updateView(KEY_ENTRYENTITY);
    }

    private void fillDataToVs(Collection<String> colNames, DataSet entryData, TableValueSetter vs, Map<String, Map<String, Object>> sign2Combo) {
        while (entryData.hasNext()) {
            Row row = entryData.next();
            Object[] rowData = new Object[colNames.size()];
            int i = 0;
            for (String colName : colNames) {
                Object o = row.get(colName);
                rowData[i] = sign2Combo.getOrDefault(colName, Collections.emptyMap()).getOrDefault(String.valueOf(o), o);
                ++i;
            }
            vs.addRow(rowData);
        }
    }

    private List<String> getColNames() {
        String cloNamesCache = this.getPageCache().get(COL_NAMES);
        if (StringUtil.isEmptyString((String)cloNamesCache)) {
            return new ArrayList<String>(20);
        }
        return (List)ObjectSerialUtil.deSerializedBytes((String)cloNamesCache);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String handleExportData() {
        DynamicObjectCollection toExportData = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        if (toExportData == null) throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u6570\u636e", (String)"InvSqlQueryResultPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        if (toExportData.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u6570\u636e", (String)"InvSqlQueryResultPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        try (XSSFWorkbook workBook = new XSSFWorkbook();){
            XSSFCell cell;
            XSSFCellStyle style = workBook.createCellStyle();
            style.setAlignment(HorizontalAlignment.LEFT);
            style.setVerticalAlignment(VerticalAlignment.CENTER);
            XSSFCellStyle headerStyle = workBook.createCellStyle();
            headerStyle.setAlignment(HorizontalAlignment.CENTER);
            headerStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            headerStyle.setBorderTop(BorderStyle.THIN);
            headerStyle.setBorderRight(BorderStyle.THIN);
            headerStyle.setBorderBottom(BorderStyle.THIN);
            headerStyle.setBorderLeft(BorderStyle.THIN);
            short s = 0;
            headerStyle.setFillForegroundColor(s);
            headerStyle.setBottomBorderColor(s);
            headerStyle.setLocked(true);
            XSSFSheet xssfSheet = workBook.createSheet();
            List<String> headerList = this.getColNames();
            int rowNum = 0;
            XSSFRow headerRow1 = xssfSheet.createRow(rowNum);
            Map colNames = (Map)SerializationUtils.deSerializeFromBase64((String)((String)this.getFormCustomParam(COL_NAMES)));
            for (int i = 0; i < headerList.size(); ++i) {
                cell = headerRow1.createCell(i, CellType.STRING);
                String headName = headerList.get(i);
                cell.setCellValue(colNames == null ? headName : colNames.getOrDefault(headName.toLowerCase(Locale.ENGLISH), headName));
                cell.setCellStyle((CellStyle)headerStyle);
            }
            ++rowNum;
            List selectRows = entryGrid.getSelectRows().length > 0 ? Arrays.stream(entryGrid.getSelectRows()).boxed().collect(Collectors.toList()) : IntStream.range(0, toExportData.size() - 1).boxed().collect(Collectors.toList());
            Object string = selectRows.iterator();
            while (true) {
                XSSFRow xssfRow;
                ArrayList row;
                if (string.hasNext()) {
                    Integer r = (Integer)string.next();
                    DynamicObject rowData = (DynamicObject)toExportData.get(r.intValue());
                    row = Lists.newArrayListWithExpectedSize((int)headerList.size());
                    for (int i = 0; i < headerList.size(); ++i) {
                        row.add(rowData.get(headerList.get(i)));
                    }
                    xssfRow = xssfSheet.createRow(rowNum);
                } else {
                    string = ImportAndExportUtil.writeFile(workBook, ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c", (String)"InvSqlQueryResultPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return string;
                }
                for (int j = 0; j < row.size(); ++j) {
                    cell = xssfRow.createCell(j);
                    Object cellData = row.get(j);
                    if (cellData instanceof DynamicObject) {
                        cell.setCellValue(((DynamicObject)cellData).getString(NAME));
                    } else if (cellData != null) {
                        cell.setCellValue(cellData.toString().substring(0, Math.min(SpreadsheetVersion.EXCEL2007.getMaxTextLength(), cellData.toString().length())));
                    }
                    cell.setCellStyle((CellStyle)style);
                }
                ++rowNum;
            }
        }
        catch (IOException ex) {
            throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
        }
    }
}

