/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest.sheet;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.sheet.InvElimPaperGenerateService;
import kd.fi.bcm.business.invest.taskjob.InvElimSpreadGenerateJobHandler;
import kd.fi.bcm.business.invest.taskjob.InvPaperGenerateJobHandler;
import kd.fi.bcm.business.invest.taskjob.InvTaskJobService;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.model.UserSelectModel;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.UserSelectServiceHelper;
import kd.fi.bcm.business.tree.AbstractTreeNode;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.business.tree.TreeBuilder;
import kd.fi.bcm.business.tree.TreeModel;
import kd.fi.bcm.business.tree.dimension.OrgTreeNode;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.invsheet.InvLimSheetLogConstant;
import kd.fi.bcm.common.constant.invest.invsheet.InvSheetConstant;
import kd.fi.bcm.common.enums.CslSchemeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.json.JSONObjectUtil;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.KDAssert;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.guidemenu.GuidePageUtils;
import kd.fi.bcm.formplugin.invest.util.TreeNodeSearchUtil;
import kd.fi.bcm.formplugin.report.IIncreaseReportTab;
import kd.fi.bcm.formplugin.report.postman.AbstractReportPostman;
import kd.fi.bcm.formplugin.report.postman.ReportPostmanByEntity;
import kd.fi.bcm.formplugin.util.FormShowUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;

public class InvelimSheetListPlugin
extends AbstractBaseListPlugin
implements TreeNodeClickListener {
    private static final Set<String> dimKeys = Sets.newHashSet((Object[])new String[]{"scenario", "year", "period"});
    private static final String ROWLLIST = "llist";
    private static final String TREEVIEW_ENTITY = "treeview_entity";
    private static final String CACHE_TREEORG = "cache_treeentity";
    private static final String SELECTORGS = "selectorgs";
    private static final String ENTITYSELECTED_NODE_ID = "entityselectedNodeId";
    private static final String STR_MODEL = "model";
    private static final String STR_SCENE = "scenario";
    private static final String STR_YEAR = "year";
    private static final String STR_PERIOD = "period";
    private static final String CTL_CSLSCHEME = "cslscheme";
    private static final String MODEL_F7ID = "modelf7id";
    private static final String SCENE_F7ID = "scenariof7id";
    private static final String YEAR_F7ID = "yearf7id";
    private static final String PERIOD_F7ID = "periodf7id";
    public static final String BILLLISTAP = "billlistap";
    private static final String SHOWORGTYPE_CACHE = "showorgtype";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BTN_LOG = "btn_log";
    private static final String BTN_DELETE = "btn_delete";
    private static final String BTN_GENERATE = "btn_generate";
    private static final String BTN_GENERATEPAPER = "btn_generatepaper";
    private static final String BTN_EXIT = "btn_exit";
    private static final String DELETE_CONFIRM = "delete_confirm";
    private static final String BTN_COPY_FROM = "btn_copyfrom";
    private static final String PREFIX_ENT = "Prefix_Ent_";
    private static final String NUMBER = "number";
    private static final String SEARCH_BEFORE = "searchbefore";
    private static final String SEARCH_NEXT = "searchnext";
    public static final String COPYFROM = "copyfrom";
    public static final String GENERATE_PAPER = "generatePaper";
    public static final String NON_SELECT_NODE = "-1";
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(InvelimSheetListPlugin.class);

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(new ArrayList<String>(dimKeys), SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public boolean isSingleF7() {
        return true;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView orgTreeView = (TreeView)this.getControl(TREEVIEW_ENTITY);
        orgTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(SEARCH_BEFORE, SEARCH_NEXT);
        Search sl = (Search)this.getControl("entitysearchap");
        sl.addEnterListener(event -> {
            if (event.getText() != null && !"".equals(event.getText())) {
                new TreeNodeSearchUtil(this.getView(), TREEVIEW_ENTITY, CACHE_TREEORG).searchMember(event.getText().toLowerCase(Locale.ENGLISH).trim());
            } else {
                this.getPageCache().put(ROWLLIST, null);
                this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
            }
        });
        BasedataEditSingleMemberF7 period = (BasedataEditSingleMemberF7)this.getControl(STR_PERIOD);
        period.addBeforeF7SelectListener(this);
        BasedataEdit csl = (BasedataEdit)this.getControl(CTL_CSLSCHEME);
        csl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.getView().getPageId().startsWith("copyFrom")) {
            this.initCopyFromPage();
            this.refreshTree(LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID")));
        } else {
            Object conStr = this.getFormCustomParam("condition");
            if (conStr != null && !StringUtil.isEmptyString((String)conStr.toString())) {
                Map param = (Map)ObjectSerialUtil.deSerializedBytes((String)conStr.toString());
                this.getModel().beginInit();
                this.getModel().setValue(STR_MODEL, param.get(STR_MODEL));
                this.getModel().setValue(CTL_CSLSCHEME, param.get(CTL_CSLSCHEME));
                this.getModel().setValue(STR_SCENE, param.get(STR_SCENE));
                this.getModel().setValue(STR_YEAR, param.get(STR_YEAR));
                this.getModel().setValue(STR_PERIOD, param.get(STR_PERIOD));
                this.getModel().endInit();
                this.getView().updateView();
                ArrayList<String> selectnodes = new ArrayList<String>(10);
                selectnodes.add(((Long)param.get("entity")).toString());
                this.getPageCache().put(SELECTORGS, ObjectSerialUtil.toByteSerialized(selectnodes));
                this.refreshTree((Long)param.get(STR_MODEL));
            } else {
                this.refreshBillByUserSelect(new ArrayList<String>(dimKeys), false);
                String modelId = this.getPageCache().get("KEY_MODEL_ID");
                if (!StringUtils.isEmpty((CharSequence)modelId)) {
                    this.initCslschemeValue(modelId, false);
                    String selectOrgid = (String)this.getFormCustomParam("selectedOrgid");
                    if (!StringUtil.isEmptyString((String)selectOrgid)) {
                        this.setCslschemeValue(selectOrgid);
                        this.refreshTree(null);
                    } else {
                        this.refreshTree(Long.valueOf(modelId));
                    }
                } else {
                    this.setCslschemeValue(null);
                    this.refreshTree(null);
                }
            }
        }
        this.refreshBillList();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Boolean copyForm;
        super.beforeF7Select(beforeF7SelectEvent);
        String key = beforeF7SelectEvent.getProperty().getName();
        if (STR_PERIOD.equals(key) && Objects.nonNull(copyForm = (Boolean)this.getView().getFormShowParameter().getCustomParam(COPYFROM))) {
            HashMap<String, Object> customData = new HashMap<String, Object>(16);
            customData.put(COPYFROM, true);
            BasedataEditSingleMemberF7 period = (BasedataEditSingleMemberF7)this.getControl(STR_PERIOD);
            period.setCustomData(customData);
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (SEARCH_BEFORE.equals(key)) {
            new TreeNodeSearchUtil(this.getView(), TREEVIEW_ENTITY, CACHE_TREEORG).searchBefore();
        }
        if (SEARCH_NEXT.equals(key)) {
            new TreeNodeSearchUtil(this.getView(), TREEVIEW_ENTITY, CACHE_TREEORG).searchNext();
        }
    }

    private void setCslschemeValue(Object selectOrgid) {
        DynamicObject object;
        QFilter qFilter;
        DynamicObject cslSchemaDyn;
        long cslSchemeId = 0L;
        if (selectOrgid != null) {
            cslSchemeId = OrgServiceHelper.getCslSchemeId((long)LongUtil.toLong((Object)selectOrgid));
            this.getPageCache().put("selectedNodeId", selectOrgid.toString());
            UserSelectServiceHelper.setEntity((Long)this.getUserId(), (Long)this.getModelId(), (Object)selectOrgid);
        } else if (this.getModel().getValue(STR_MODEL) != null && (cslSchemaDyn = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"id", (QFilter[])(qFilter = new QFilter(STR_MODEL, "=", (Object)(object = (DynamicObject)this.getModel().getValue(STR_MODEL)).getLong("id")).and(NUMBER, "=", (Object)CslSchemeEnum.Default.getNumber())).toArray())) != null) {
            cslSchemeId = cslSchemaDyn.getLong("id");
        }
        if (cslSchemeId != 0L) {
            this.getModel().setValue(CTL_CSLSCHEME, (Object)cslSchemeId);
        }
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        BillListHyperLinkClickEvent hyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        ListSelectedRow currentRow = hyperLinkClickEvent.getCurrentRow();
        if (currentRow == null) {
            args.setCancel(true);
            return;
        }
        this.openMultTabReportProcessPage();
        args.setCancel(true);
        this.writeOperationLog(OpItemEnum.LOOKUP.getName(), currentRow.getNumber(), currentRow.getName(), ResultStatusEnum.SUCCESS.getName());
    }

    @Override
    public void listRowDoubleClick(ListRowClickEvent evt) {
        this.openMultTabReportProcessPage();
        evt.setCancel(true);
    }

    private void openMultTabReportProcessPage() {
        TreeMultimap<Long, DynamicObject> sortMap;
        DynamicObjectCollection finList = this.getSelectTemplates();
        if (finList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5e95\u7a3f\u5df2\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u5e95\u7a3f\u540e\u91cd\u8bd5\u3002", (String)"InvelimSheetListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        StringBuilder notificationMessage = new StringBuilder();
        if (notificationMessage.length() > 0) {
            this.refreshBillList();
            notificationMessage.deleteCharAt(notificationMessage.lastIndexOf("\u3001"));
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u6743\u76ca\u5e95\u7a3f\u6a21\u677f\u5df2\u7ecf\u88ab\u7981\u7528\uff0c\u4e0d\u80fd\u6253\u5f00\u9875\u9762\uff0c\u5982\u9700\u6253\u5f00\u8bf7\u5c06\u8be5\u6a21\u677f\u72b6\u6001\u6539\u4e3a\u542f\u7528\u3002", (String)"InvelimSheetListPlugin_46", (String)"fi-bcm-formplugin", (Object[])new Object[0]), notificationMessage));
        }
        if ((sortMap = this.sortTemplates((List<DynamicObject>)finList)) != null) {
            sortMap.keySet().forEach(e -> this.handleOpenFinTemplate(sortMap.get(e)));
        }
    }

    private void handleOpenFinTemplate(Collection<DynamicObject> templates) {
        AbstractReportPostman postman = null;
        for (DynamicObject dyn : templates) {
            if (postman == null) {
                postman = new ReportPostmanByEntity(dyn.get("entity"), dyn.get(STR_SCENE), dyn.get(STR_YEAR), dyn.get(STR_PERIOD), 1368916255217576969L, dyn.get(STR_MODEL));
            }
            if (postman.isSortByEntity()) {
                postman.addPair(dyn.get("template"), dyn.get("id"));
            } else {
                postman.addPair(dyn.get("entity"), dyn.get("id"));
            }
            postman.addReportListId(dyn.getLong("id"));
        }
        IFormView mainPageView = this.getView().getMainView();
        IFormView parentView = this.getView().getParentView();
        if (postman != null) {
            String menuPageID = this.getMenuPageId(postman);
            if (mainPageView == null || mainPageView.getView(menuPageID) == null) {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setPageId(menuPageID);
                formShowParameter.setFormId("bcm_invlimsheet");
                String moduleName = ResManager.loadKDString((String)"\u6743\u76ca\u62b5\u9500\u5e95\u7a3f", (String)"InvelimSheetListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                String caption = this.getOpenFormCaption(postman);
                formShowParameter.setCaption(moduleName + " : " + caption);
                formShowParameter.setCustomParam("reportpostman", (Object)ObjectSerialUtil.toByteSerialized((Object)postman));
                formShowParameter.setCustomParam("listPageID", (Object)this.getView().getPageId());
                formShowParameter.setCustomParam("yearId", (Object)((DynamicObject)this.getModel().getValue(STR_YEAR)).getLong("id"));
                formShowParameter.setCustomParam("periodId", (Object)((DynamicObject)this.getModel().getValue(STR_PERIOD)).getLong("id"));
                formShowParameter.setCustomParam("yearNum", ((DynamicObject)this.getModel().getValue(STR_YEAR)).get(NUMBER));
                formShowParameter.setCustomParam("periodNum", ((DynamicObject)this.getModel().getValue(STR_PERIOD)).get(NUMBER));
                formShowParameter.setCustomParam("scenarioId", (Object)((DynamicObject)this.getModel().getValue(STR_SCENE)).getLong("id"));
                DynamicObject[] templateArray = templates.toArray(new DynamicObject[0]);
                formShowParameter.setCustomParam("entityNumber", (Object)templateArray[0].getString("entity.number"));
                formShowParameter.setCustomParam("entityName", (Object)templateArray[0].getString("entity.name"));
                formShowParameter.setCustomParam("selectOrgId", (Object)this.getPageCache().get(ENTITYSELECTED_NODE_ID));
                formShowParameter.setCustomParam("pageId", (Object)this.getView().getPageId());
                formShowParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
                formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
                if (parentView == null) {
                    this.getView().showForm(formShowParameter);
                } else {
                    formShowParameter.setParentPageId(parentView.getPageId());
                    formShowParameter.setParentFormId(parentView.getEntityId());
                    parentView.showForm(formShowParameter);
                    this.getView().sendFormAction(parentView);
                }
            } else {
                IFormView childFormView = mainPageView.getView(menuPageID);
                childFormView.activate();
                FormViewPluginProxy pluginProxy = (FormViewPluginProxy)childFormView.getService(FormViewPluginProxy.class);
                AbstractReportPostman pm = postman;
                pluginProxy.getPlugIns().forEach(e -> {
                    if (IIncreaseReportTab.class.isAssignableFrom(e.getClass())) {
                        ((IIncreaseReportTab)IIncreaseReportTab.class.cast(e)).increaseReportTab(pm);
                    }
                });
                this.getView().sendFormAction(childFormView);
            }
        }
    }

    private String getOpenFormCaption(AbstractReportPostman pm) {
        DynamicObject entity = QueryServiceHelper.queryOne((String)pm.getTabSort().getEntityNumber(), (String)"name,id,number", (QFilter[])new QFilter[]{new QFilter("id", "=", pm.getSortViewPK())});
        return Optional.ofNullable(entity).map(e -> e.getString("name")).orElseThrow(() -> {
            List<Long> reportListIds = pm.getReportListId();
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            List sheetName = QueryServiceHelper.query((String)billList.getBillFormId(), (String)"name", (QFilter[])new QFBuilder("id", "in", reportListIds).toArray()).stream().map(dy -> dy.getString("name")).collect(Collectors.toList());
            String msg = ResManager.loadKDString((String)"%1$s\u5bf9\u5e94\u5408\u5e76\u8282\u70b9\u5df2\u88ab\u5220\u9664\u3002", (String)"InvelimSheetListPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return new KDBizException(String.format(msg, String.join((CharSequence)",", sheetName)));
        });
    }

    private String getMenuPageId(AbstractReportPostman pm) {
        return this.getMenuPagePrefix() + (pm.isSortByEntity() ? pm.getEntityPK(null) : pm.getTemplatePK(null)) + this.getView().getPageId() + this.isolationByPageFilterInfo(pm);
    }

    private String isolationByPageFilterInfo(AbstractReportPostman pm) {
        String modelNum = ((DynamicObject)this.getModel().getValue(STR_MODEL)).getString(NUMBER);
        ArrayList otherDim = Lists.newArrayList((Object[])new String[]{MemberReader.findScenaMemberById((String)modelNum, (Long)((Long)pm.getScenarioPK())).getNumber(), MemberReader.findFyMemberById((String)modelNum, (Long)((Long)pm.getYearPK())).getNumber(), MemberReader.findPeriodMemberById((String)modelNum, (Long)((Long)pm.getPeriodPK())).getNumber(), MemberReader.findCurrencyMemberById((String)modelNum, (Long)((Long)pm.getCurrencyPK())).getNumber()});
        return Joiner.on((char)'-').join((Iterable)otherDim);
    }

    private String getMenuPagePrefix() {
        return PREFIX_ENT;
    }

    private TreeMultimap<Long, DynamicObject> sortTemplates(List<DynamicObject> templates) {
        if (templates.isEmpty()) {
            return null;
        }
        Comparator<DynamicObject> cp = Comparator.comparing(d -> d.getString("template"));
        TreeMultimap multiMap = TreeMultimap.create((Comparator)Ordering.natural(), cp);
        templates.forEach(e -> {
            if (e.getLong("template") != 0L) {
                multiMap.put((Object)e.getLong("entity"), e);
            }
        });
        if (multiMap.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5e95\u7a3f\u6a21\u677f\u5df2\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u5e95\u7a3f\u540e\u91cd\u8bd5\u3002", (String)"InvelimSheetListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return null;
        }
        return multiMap;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (!this.checkSelectNode(itemKey)) {
            return;
        }
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection coll = billList.getSelectedRows();
        Object[] pks = new Object[coll.size()];
        for (int i = 0; i < coll.size(); ++i) {
            ListSelectedRow row = coll.get(i);
            pks[i] = row.getPrimaryKeyValue();
        }
        this.getPageCache().put("PKS", ObjectSerialUtil.toByteSerialized((Object)pks));
        if (BTN_REFRESH.equals(itemKey)) {
            this.refreshTree(null);
            this.refreshBillList();
        } else if (BTN_GENERATE.equals(itemKey)) {
            if (pks.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e95\u7a3f\u8bb0\u5f55\u3002", (String)"InvelimSheetListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                this.generate();
            }
        } else if (BTN_GENERATEPAPER.equals(itemKey)) {
            DynamicObject periodDyn = (DynamicObject)this.getModel().getValue(STR_PERIOD);
            if (Objects.nonNull(periodDyn) && !periodDyn.getBoolean("isleaf")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u660e\u7ec6\u671f\u95f4\u3002", (String)"InvelimSheetListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put(STR_MODEL, this.getModelId());
            String title = ResManager.loadKDString((String)"\u751f\u6210\u6743\u76ca\u62b5\u9500\u5e95\u7a3f", (String)"InvelimSheetListPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            FormShowUtil.openDynamicPage(this.getView(), title, "bcm_generatesheetset", paramMap, new CloseCallBack((IFormPlugin)this, GENERATE_PAPER));
        } else if (BTN_DELETE.equals(itemKey)) {
            if (pks.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e95\u7a3f\u8bb0\u5f55\u3002", (String)"InvelimSheetListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5e95\u7a3f\u542b\u5bf9\u5e94\u5206\u5f55\u53ca\u5171\u4eab\u81f3\u5176\u4ed6\u5e95\u7a3f\u7684\u62d3\u5c55\u7ef4\u6570\u636e\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"InvelimSheetListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(DELETE_CONFIRM, (IFormPlugin)this));
            }
        } else if (BTN_COPY_FROM.equals(itemKey)) {
            this.showCopyFrom();
        } else if (BTN_LOG.equals(itemKey)) {
            this.openLog();
        }
    }

    private boolean checkSelectNode(String itemKey) {
        if (Sets.newHashSet((Object[])new String[]{BTN_REFRESH, BTN_GENERATEPAPER, BTN_EXIT}).contains(itemKey)) {
            return true;
        }
        IDNumberTreeNode orgNode = this.getSelectedEntity();
        Long selectNode = orgNode.getId();
        if (orgNode != IDNumberTreeNode.NotFoundTreeNode && this.checkOrgMemberIsNoPerm(String.valueOf(selectNode))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u64cd\u4f5c\u5bf9\u5e94\u7684\u7ec4\u7ec7\u6210\u5458\u6743\u9650\u3002", (String)"InvelimSheetListPlugin_36", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void generatePaper(int calcRange, boolean isInvestWay, Set<String> templateSet) {
        IDNumberTreeNode selectedOrgNode = this.getSelectedEntity();
        if (selectedOrgNode == IDNumberTreeNode.NotFoundTreeNode) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"InvelimSheetListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            long modelId = this.getModelId();
            DynamicObject sceneDy = (DynamicObject)this.getModel().getValue(STR_SCENE);
            DynamicObject yearDy = (DynamicObject)this.getModel().getValue(STR_YEAR);
            DynamicObject periodDy = (DynamicObject)this.getModel().getValue(STR_PERIOD);
            this.checkParam(sceneDy, yearDy, periodDy, selectedOrgNode);
            long sceneId = sceneDy.getLong("id");
            long yearId = yearDy.getLong("id");
            long periodId = periodDy.getLong("id");
            try {
                Long selectedNodeId = selectedOrgNode.getId();
                TreeModel treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache(), (String)CACHE_TREEORG);
                ArrayList<Long> orgNodes = new ArrayList<Long>(16);
                orgNodes.add(LongUtil.toLong((Object)selectedNodeId));
                if (calcRange == InvSheetConstant.GenerateRangEnum.CURRENT_ORG_AND_SUB.getCode()) {
                    orgNodes.addAll(treeModel.seekAllChildren(String.valueOf(selectedNodeId), p -> StringUtils.isNotEmpty((CharSequence)p.getId())).stream().map(t -> LongUtil.toLong((Object)t.getId())).collect(Collectors.toSet()));
                }
                FixedItem fixedItem = FixedItem.newOne((SimpleItem)SimpleItem.newOne((Object)modelId, (String)""), (SimpleItem)SimpleItem.newOne((Object)sceneId, (String)""), (SimpleItem)SimpleItem.newOne((Object)yearId, (String)""), (SimpleItem)SimpleItem.newOne((Object)periodId, (String)""));
                fixedItem.setOrgList(orgNodes.stream().distinct().map(id -> SimpleItem.newOne((Object)id, (String)"")).collect(Collectors.toList()));
                InvTaskJobService jobService = new InvTaskJobService((AbstractFormPlugin)this, InvPaperGenerateJobHandler.class, ResManager.loadKDString((String)"\u751f\u6210\u5e95\u7a3f", (String)"InvelimSheetListPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                HashMap params = Maps.newHashMap();
                params.put("paperGenerateParam", ObjectSerialUtil.toByteSerialized((Object)fixedItem));
                params.put("isGenerateEmptySheet", ObjectSerialUtil.toByteSerialized((Object)isInvestWay));
                params.put("templates", ObjectSerialUtil.toByteSerialized(templateSet));
                jobService.createTask((Map)params, "generatePaperBack");
            }
            catch (Exception e) {
                log.error((Throwable)e);
                this.getView().showErrorNotification(e.getMessage());
            }
        }
    }

    private void initCopyFromPage() {
        String selectNode;
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"toolbarap"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{STR_MODEL});
        FormShowParameter parameter = this.getView().getFormShowParameter();
        this.getModel().setValue(STR_MODEL, parameter.getCustomParam("KEY_MODEL_ID"));
        this.getModel().setValue(STR_YEAR, parameter.getCustomParam("bcm_fymembertree"));
        this.getModel().setValue(STR_SCENE, parameter.getCustomParam("bcm_scenemember"));
        this.getModel().setValue(STR_PERIOD, parameter.getCustomParam("bcm_periodmembertree"));
        this.getModel().setValue(CTL_CSLSCHEME, parameter.getCustomParam(CTL_CSLSCHEME));
        String[] lastPeriod = PeriodUtils.getLastPeriodIncludeYear((String)((DynamicObject)this.getModel().getValue(STR_MODEL)).getString(NUMBER), (String)((DynamicObject)this.getModel().getValue(STR_YEAR)).getString(NUMBER), (String)((DynamicObject)this.getModel().getValue(STR_PERIOD)).getString(NUMBER), (boolean)true);
        if (lastPeriod[0] != null) {
            if ("M_M13".equals(((DynamicObject)this.getModel().getValue(STR_PERIOD)).getString(NUMBER))) {
                lastPeriod[1] = "M_M12";
            }
            String modelNumber = MemberReader.findModelNumberById((Object)this.getModelId());
            IDNumberTreeNode fyMember = MemberReader.findFyMemberByNum((String)modelNumber, (String)lastPeriod[0]);
            IDNumberTreeNode periodMember = MemberReader.findPeriodMemberByNum((String)modelNumber, (String)lastPeriod[1]);
            this.getModel().setValue(STR_YEAR, (Object)fyMember.getId());
            this.getModel().setValue(STR_PERIOD, (Object)periodMember.getId());
        }
        if ((selectNode = (String)this.getFormCustomParam("bcm_entitymembertree")) != null && !NON_SELECT_NODE.equals(selectNode)) {
            this.getPageCache().put(ENTITYSELECTED_NODE_ID, selectNode);
            ArrayList<String> selectNodes = new ArrayList<String>(10);
            selectNodes.add(selectNode);
            this.getPageCache().put(SELECTORGS, ObjectSerialUtil.toByteSerialized(selectNodes));
        }
    }

    private void showCopyFrom() {
        FormShowParameter parameter = new FormShowParameter();
        IDataModel dataModel = this.getModel();
        DynamicObject yearDyn = (DynamicObject)dataModel.getValue(STR_YEAR);
        DynamicObject modelDyn = (DynamicObject)dataModel.getValue(STR_MODEL);
        DynamicObject periodDyn = (DynamicObject)dataModel.getValue(STR_PERIOD);
        DynamicObject cslSchemeDyn = (DynamicObject)dataModel.getValue(CTL_CSLSCHEME);
        DynamicObject scenarioDyn = (DynamicObject)dataModel.getValue(STR_SCENE);
        if (yearDyn == null || modelDyn == null || periodDyn == null || cslSchemeDyn == null || scenarioDyn == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\uff0c\u89c6\u56fe\uff0c\u60c5\u666f\uff0c\u8d22\u5e74\uff0c\u671f\u95f4\u3002", (String)"InvelimSheetListPlugin_42", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!periodDyn.getBoolean("isleaf")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u660e\u7ec6\u671f\u95f4\u3002", (String)"InvelimSheetListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        InvestServiceHelper.checkOrgAccessible((long)this.getModelId(), (long)scenarioDyn.getLong("id"), (long)yearDyn.getLong("id"), (long)periodDyn.getLong("id"), (long)LongUtil.toLong((Object)this.getPageCache().get(ENTITYSELECTED_NODE_ID)));
        parameter.setCustomParam("KEY_MODEL_ID", (Object)modelDyn.getString("id"));
        parameter.setCustomParam("bcm_fymembertree", (Object)yearDyn.getLong("id"));
        parameter.setCustomParam("bcm_scenemember", (Object)scenarioDyn.getLong("id"));
        parameter.setCustomParam("bcm_periodmembertree", (Object)periodDyn.getLong("id"));
        parameter.setCustomParam(COPYFROM, (Object)true);
        parameter.setCustomParam("bcm_entitymembertree", (Object)this.getPageCache().get(ENTITYSELECTED_NODE_ID));
        parameter.setCustomParam(CTL_CSLSCHEME, cslSchemeDyn.getPkValue());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_invlimsheetcopyfrom"));
        parameter.setFormId("bcm_invlimsheetcopyfrom");
        String str = ResManager.loadKDString((String)"\u590d\u5236\u5176\u4ed6\u671f\u95f4\u5e95\u7a3f\u5230", (String)"InvelimSheetListPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        parameter.setCaption(String.format("%s %s%s", str, yearDyn.getString("name"), periodDyn.getString("name")));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("bcm_invlimsheetcopyfrom".equals(closedCallBackEvent.getActionId())) {
            String fail;
            this.refreshTree(null);
            this.refreshBillList();
            Object returnDataObj = closedCallBackEvent.getReturnData();
            if (Objects.isNull(returnDataObj)) {
                return;
            }
            Pair returnData = (Pair)returnDataObj;
            String success = (String)returnData.p1;
            if (!success.isEmpty()) {
                this.getView().showSuccessNotification(success);
            }
            if (!(fail = (String)returnData.p2).isEmpty()) {
                this.getView().showTipNotification(fail);
            }
        } else if (GENERATE_PAPER.equals(closedCallBackEvent.getActionId())) {
            Map returnDataObj = (Map)closedCallBackEvent.getReturnData();
            if (Objects.isNull(returnDataObj)) {
                return;
            }
            String orgRange = (String)returnDataObj.get("orgrangeradio");
            String generateType = (String)returnDataObj.get("generateradio");
            List templateList = (List)returnDataObj.get("invsheettemplate");
            Set<String> templateSet = new HashSet<String>(16);
            boolean isInvestWay = InvSheetConstant.GenerateTypeEnum.INVEST_WAY.getCode().equals(generateType);
            if (!isInvestWay) {
                templateSet = templateList.stream().map(DynamicObject.class::cast).map(tpl -> tpl.getDynamicObject("fbasedataid").getString(NUMBER)).collect(Collectors.toSet());
            }
            this.generatePaper(Integer.parseInt(orgRange), isInvestWay, templateSet);
        } else if ("generatePaperBack".equals(closedCallBackEvent.getActionId())) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData != null) {
                String taskInfoJson = (String)((Map)returnData).get("taskinfo");
                JSONObject taskInfo = JSONObjectUtil.parseObjectOrder((String)taskInfoJson);
                JSONObject data = taskInfo.getJSONObject("data");
                boolean success = data.getBoolean("success");
                JSONObject msgJson = data.getJSONObject("message");
                String title = ResManager.loadKDString((String)"\u5b58\u5728\u90e8\u5206\u7ec4\u7ec7\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u5177\u4f53\u8be6\u60c5\u3002", (String)"InvelimSheetListPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                if (success) {
                    title = ResManager.loadKDString((String)"\u5168\u90e8\u6267\u884c\u6210\u529f\u3002", (String)"InvelimSheetListPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                }
                TreeModel treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache(), (String)CACHE_TREEORG);
                ITreeNode root = treeModel.getRoot();
                String id = root.getId();
                String msg = treeModel.seekAllChildren(id, node -> msgJson.containsKey((Object)node.getId())).stream().map(OrgTreeNode.class::cast).map(node -> node.getNumber() + ":" + msgJson.get((Object)node.getId())).collect(Collectors.joining("\n"));
                if (success && msgJson.size() == 1) {
                    this.getView().showSuccessNotification(msg);
                } else {
                    this.getView().showMessage(title, msg, MessageTypes.Default);
                }
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u751f\u6210\u5e95\u7a3f", "InvelimSheetListPlugin_12", "fi-bcm-formplugin", "Generate a manuscript"), OPDescMultiLangEnumBridge.genUnTransBridge((String)msg));
            }
            this.getView().invokeOperation("refresh");
        } else if ("generateSpreadBack".equals(closedCallBackEvent.getActionId())) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData != null) {
                String taskInfoJson = (String)((Map)returnData).get("taskinfo");
                JSONObject taskInfo = JSONObjectUtil.parseObjectOrder((String)taskInfoJson);
                JSONObject data = taskInfo.getJSONObject("data");
                JSONArray success = data.getJSONArray("success");
                int dealCount = Math.max(data.getInteger("dealCount"), 0);
                JSONArray msgJson = data.getJSONArray("message");
                String genarate = String.format(ResManager.loadKDString((String)"\u751f\u6210%s\u4e2a\u8c03\u6574\u62b5\u9500\u5206\u5f55", (String)"InvelimSheetListPlugin_45", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dealCount);
                String msg = msgJson.isEmpty() ? ResManager.loadKDString((String)"\u8bf7\u8fdb\u5165\u8c03\u6574\u62b5\u9500\u5206\u5f55\u754c\u9762\u67e5\u770b\u3002", (String)"InvelimSheetListPlugin_44", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : String.join((CharSequence)"\n", (CharSequence[])msgJson.toArray((Object[])new String[0]));
                this.getView().showMessage(genarate, msg, MessageTypes.Default);
                this.writeOperationLog(genarate, ResultStatusEnum.SUCCESS.getName());
            }
            this.getView().invokeOperation("refresh");
        }
    }

    public boolean checkPeriodCanNotSave() {
        long modelId = this.getModelId();
        String orgNumber = this.getSelectedEntity().getNumber();
        long yearId = (Long)((DynamicObject)this.getModel().getValue(STR_YEAR)).get("id");
        long periodId = (Long)((DynamicObject)this.getModel().getValue(STR_PERIOD)).get("id");
        long scenarioId = (Long)((DynamicObject)this.getModel().getValue(STR_SCENE)).get("id");
        return ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM012") && !PeriodSettingHelper.checkPeriodStatus((long)modelId, (String)orgNumber, (long)scenarioId, (long)yearId, (long)periodId, (String)"datastatus");
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        if (DELETE_CONFIRM.equals(callBackId) && MessageBoxResult.Yes.equals((Object)mbce.getResult())) {
            long yearId = ((DynamicObject)this.getModel().getValue(STR_YEAR)).getLong("id");
            long periodId = ((DynamicObject)this.getModel().getValue(STR_PERIOD)).getLong("id");
            long scenarioId = ((DynamicObject)this.getModel().getValue(STR_SCENE)).getLong("id");
            IDNumberTreeNode selectedOrgNode = this.getSelectedEntity();
            Long orgId = selectedOrgNode.getId();
            InvestServiceHelper.checkOrgAccessible((long)this.getModelId(), (long)scenarioId, (long)yearId, (long)periodId, (long)orgId);
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            Object[] pks = (Object[])ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("PKS"));
            InvElimPaperGenerateService invElimPaperGenerateService = new InvElimPaperGenerateService(Long.valueOf(this.getModelId()), Long.valueOf(scenarioId), Long.valueOf(yearId), Long.valueOf(periodId), orgId, InvLimSheetLogConstant.Operation.DELETE_LIST);
            invElimPaperGenerateService.deletePaperNormal(this.array2Collection(pks));
            invElimPaperGenerateService.saveLog();
            if (CollectionUtil.isEmpty((Collection)invElimPaperGenerateService.getErrMsg())) {
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6210\u529f\u5220\u9664%1$s\u4e2a\u8c03\u6574\u62b5\u9500\u5e95\u7a3f\uff0c%2$s\u4e2a\u8c03\u6574\u62b5\u9500\u5206\u5f55\u3002", (String)"InvelimSheetListPlugin_48", (String)"fi-bcm-formplugin", (Object[])new Object[0]), invElimPaperGenerateService.delSheetCount(), invElimPaperGenerateService.delEntryCount()));
            } else {
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6210\u529f\u5220\u9664%1$s\u4e2a\u8c03\u6574\u62b5\u9500\u5e95\u7a3f\uff0c%2$s\u4e2a\u8c03\u6574\u62b5\u9500\u5206\u5f55,%3$s\u3002", (String)"InvelimSheetListPlugin_47", (String)"fi-bcm-formplugin", (Object[])new Object[0]), invElimPaperGenerateService.delSheetCount(), invElimPaperGenerateService.delEntryCount(), invElimPaperGenerateService.getErrMsg()));
            }
            for (int i = 0; i < billList.getSelectedRows().size(); ++i) {
                ListSelectedRow listSelectedRow = billList.getSelectedRows().get(i);
                this.writeOperationLog(OpItemEnum.DELETE.getName(), listSelectedRow.getNumber(), listSelectedRow.getName(), ResultStatusEnum.SUCCESS.getName());
            }
            this.refreshTree(null);
            this.refreshBillList();
        }
    }

    private Collection<Long> array2Collection(Object[] pks) {
        if (pks == null) {
            return Collections.emptySet();
        }
        HashSet<Long> result = new HashSet<Long>(pks.length);
        for (Object pk : pks) {
            result.add(LongUtil.toLong((Object)pk));
        }
        return result;
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        Object[] pks = evt.getListSelectedRowCollection().getPrimaryKeyValues();
        this.getPageCache().put("PKS", ObjectSerialUtil.toByteSerialized((Object)pks));
    }

    void generate() {
        long modelId = this.getModelId();
        DynamicObject sceneDy = (DynamicObject)this.getModel().getValue(STR_SCENE);
        DynamicObject yearDy = (DynamicObject)this.getModel().getValue(STR_YEAR);
        DynamicObject periodDy = (DynamicObject)this.getModel().getValue(STR_PERIOD);
        IDNumberTreeNode selectedOrgNode = this.getSelectedEntity();
        if (selectedOrgNode == IDNumberTreeNode.NotFoundTreeNode) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u7ec4\u7ec7", (String)"InvelimSheetListPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.checkParam(sceneDy, yearDy, periodDy, selectedOrgNode);
        Long sceneId = sceneDy.getLong("id");
        Long yearId = yearDy.getLong("id");
        Long periodId = periodDy.getLong("id");
        Long orgId = selectedOrgNode.getId();
        this.generateEntry(modelId, sceneId, yearId, periodId, orgId);
    }

    void checkParam(DynamicObject sceneDy, DynamicObject yearDy, DynamicObject periodDy, IDNumberTreeNode orgNode) {
        if (sceneDy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60c5\u666f\u4e0d\u53ef\u4e3a\u7a7a", (String)"InvelimSheetListPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (yearDy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u5e74\u4e0d\u53ef\u4e3a\u7a7a", (String)"InvelimSheetListPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (periodDy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u671f\u95f4\u4e0d\u53ef\u4e3a\u7a7a", (String)"InvelimSheetListPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if ("Entity".equals(orgNode.getNumber())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u7ec4\u7ec7", (String)"InvelimSheetListPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void generateEntry(Long modelId, Long sceneId, Long yearId, Long periodId, Long orgId) {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        Object[] pks = (Object[])ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("PKS"));
        ArrayList sheetList = new ArrayList(pks.length);
        sheetList.addAll(QueryServiceHelper.query((String)billList.getEntityType().getName(), (String)"id,template.id,template.number,data", (QFilter[])new QFBuilder("id", "in", (Object)pks).toArray()));
        FixedItem fixedItem = FixedItem.newOne((SimpleItem)SimpleItem.newOne((Object)modelId, (String)""), (SimpleItem)SimpleItem.newOne((Object)sceneId, (String)""), (SimpleItem)SimpleItem.newOne((Object)yearId, (String)""), (SimpleItem)SimpleItem.newOne((Object)periodId, (String)""));
        fixedItem.setOrg(SimpleItem.newOne((Object)orgId, (String)""));
        InvTaskJobService jobService = new InvTaskJobService((AbstractFormPlugin)this, InvElimSpreadGenerateJobHandler.class, ResManager.loadKDString((String)"\u751f\u6210\u5206\u5f55", (String)"InvelimSheetListPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        HashMap params = Maps.newHashMap();
        params.put("spreadGenerateParam", ObjectSerialUtil.toByteSerialized((Object)fixedItem));
        params.put("sheetList", ObjectSerialUtil.toByteSerialized(sheetList));
        jobService.createTask((Map)params, "generateSpreadBack");
    }

    private IDNumberTreeNode getSelectedEntity() {
        DynamicObject modelDy = (DynamicObject)this.getModel().getValue(STR_MODEL);
        long modelId = modelDy == null ? 0L : modelDy.getLong("id");
        return InvelimSheetListPlugin.getSelectedEntity(this.getView(), modelId);
    }

    public static IDNumberTreeNode getSelectedEntity(IFormView view, long modelId) {
        TreeView tree = (TreeView)view.getControl(TREEVIEW_ENTITY);
        Map node = tree.getTreeState().getFocusNode();
        if (view.getPageCache().get(ENTITYSELECTED_NODE_ID) != null) {
            Object orgId = node != null ? node.get("id") : view.getPageCache().get(ENTITYSELECTED_NODE_ID);
            return MemberReader.findEntityMemberById((String)MemberReader.findModelNumberById((Object)modelId), (Long)ConvertUtil.convertObjToLong(orgId));
        }
        return IDNumberTreeNode.NotFoundTreeNode;
    }

    public void treeNodeClick(TreeNodeEvent arg0) {
        String selectedNodeId = (String)arg0.getNodeId();
        if (selectedNodeId.isEmpty()) {
            selectedNodeId = NON_SELECT_NODE;
        } else {
            UserSelectServiceHelper.setEntity((Long)this.getUserId(), (Long)this.getModelId(), (Object)selectedNodeId);
        }
        ArrayList<String> selectNodes = Objects.nonNull(this.getPageCache().get(SELECTORGS)) ? (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(SELECTORGS)) : new ArrayList<String>();
        selectNodes.remove(selectedNodeId);
        selectNodes.add(selectedNodeId);
        this.getPageCache().put(SELECTORGS, ObjectSerialUtil.toByteSerialized(selectNodes));
        this.getPageCache().put(ENTITYSELECTED_NODE_ID, selectedNodeId);
        this.refreshBillList();
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.clearSelection();
        this.getPageCache().remove("PKS");
        FilterParameter filterParameter = new FilterParameter();
        filterParameter.setFilter(this.getBillFilter());
        billList.setFilterParameter(filterParameter);
        billList.refresh();
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter filter = this.getBillFilter();
        e.getQFilters().add(filter);
    }

    private QFilter getBillFilter() {
        IDNumberTreeNode orgNode = this.getSelectedEntity();
        Long selectNode = orgNode.getId();
        if (orgNode == IDNumberTreeNode.NotFoundTreeNode || this.checkOrgMemberIsNoPerm(String.valueOf(selectNode))) {
            return new QFilter("1", "!=", (Object)1);
        }
        DynamicObject modelDy = (DynamicObject)this.getModel().getValue(STR_MODEL);
        DynamicObject sceneDy = (DynamicObject)this.getModel().getValue(STR_SCENE);
        DynamicObject yearDy = (DynamicObject)this.getModel().getValue(STR_YEAR);
        DynamicObject periodDy = (DynamicObject)this.getModel().getValue(STR_PERIOD);
        long modelId = modelDy == null ? 0L : modelDy.getLong("id");
        QFilter filter = new QFilter(STR_MODEL, "=", (Object)modelId);
        filter.and(STR_SCENE, "=", (Object)(sceneDy == null ? 0L : sceneDy.getLong("id")));
        filter.and(STR_YEAR, "=", (Object)(yearDy == null ? 0L : yearDy.getLong("id")));
        if (periodDy != null && !periodDy.getBoolean("isleaf")) {
            filter.and("period.longnumber", "like", (Object)(periodDy.getString("longnumber") + '!' + "%"));
        } else {
            filter.and(STR_PERIOD, "=", (Object)(periodDy == null ? 0L : periodDy.getLong("id")));
        }
        filter.and("entity.number", "=", (Object)orgNode.getNumber());
        return filter;
    }

    private void refreshTree(Long modelId) {
        DynamicObject modelDyn;
        if (modelId == null && (modelDyn = (DynamicObject)this.getModel().getValue(STR_MODEL)) != null) {
            modelId = modelDyn.getLong("id");
        }
        TreeView treeView = (TreeView)this.getControl(TREEVIEW_ENTITY);
        treeView.deleteAllNodes();
        if (modelId == null) {
            return;
        }
        OrgTreeNode root = this.initOrgTree(modelId, (String)this.getModel().getValue(SHOWORGTYPE_CACHE), false, false);
        if (root == null || CollectionUtil.isEmpty((Collection)root.getChildren())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u6216\u8005\u6ca1\u6709\u6709\u6743\u9650\u7684\u7ec4\u7ec7\u3002", (String)"InvelimSheetListPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            TreeBuilder.setOpen((ITreeNode)root);
            root.SetIsOpened(true);
            this.initTree((AbstractTreeNode<Object>)root);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject newValue;
        super.propertyChanged(e);
        HashMap<Object, Object> dimensionMap = new HashMap();
        ArrayList otherDim = Lists.newArrayList((Object[])new String[]{STR_MODEL, STR_SCENE, STR_YEAR, STR_PERIOD});
        String propertyName = e.getProperty().getName();
        if (STR_MODEL.equals(propertyName)) {
            newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            this.propertyChangedModelUse(new ArrayList<String>(dimKeys));
            this.getPageCache().remove(SELECTORGS);
            this.getPageCache().remove(ENTITYSELECTED_NODE_ID);
            if (newValue != null) {
                this.initCslschemeValue(newValue.getString("id"), false);
                this.getView().updateView(CTL_CSLSCHEME);
                TreeView tree = (TreeView)this.getControl(TREEVIEW_ENTITY);
                tree.deleteAllNodes();
                this.refreshTree(newValue.getLong("id"));
            } else {
                dimensionMap = null;
            }
        } else if (dimKeys.contains(propertyName)) {
            newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            Boolean isSureReturn = this.propertyChangedDimUse(propertyName, newValue, false, true);
            if (Boolean.TRUE.equals(isSureReturn == false)) {
                return;
            }
            if (newValue == null) {
                dimensionMap = null;
            } else {
                otherDim.remove(propertyName);
                dimensionMap = this.doPrepareDimensionAndMemberId(propertyName, newValue, otherDim);
            }
            if ((STR_YEAR.equals(propertyName) || STR_PERIOD.equals(propertyName)) && this.getModel().getValue(STR_MODEL) != null && this.getModel().getValue(STR_YEAR) != null && this.getModel().getValue(STR_PERIOD) != null) {
                this.refreshTree(null);
            }
        } else if (CTL_CSLSCHEME.equals(propertyName)) {
            newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newValue != null) {
                this.savetUserSelectWhenOtherChange(CTL_CSLSCHEME, new UserSelectModel());
            }
            this.getPageCache().remove(SELECTORGS);
            this.getPageCache().remove(ENTITYSELECTED_NODE_ID);
            UserSelectServiceHelper.setEntity((Long)this.getUserId(), (Long)this.getModelId(), null);
            this.refreshTree(null);
            dimensionMap = this.getF7id();
        }
        if (dimensionMap != null && dimensionMap.size() != 0) {
            this.refreshBillList();
        } else if (SHOWORGTYPE_CACHE.equals(propertyName)) {
            String showType = (String)this.getModel().getValue(SHOWORGTYPE_CACHE);
            this.getPageCache().put(SHOWORGTYPE_CACHE, showType);
            this.refreshTree(null);
        } else {
            this.refreshBillList();
        }
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        if (ColumnDesc.class.isAssignableFrom(e.getSource().getClass())) {
            String key = ((ColumnDesc)e.getSource()).getKey();
            Map orgNode = ((TreeView)this.getControl(TREEVIEW_ENTITY)).getTreeState().getFocusNode();
            if ("entity.name".equals(key) && orgNode != null) {
                e.setFormatValue(orgNode.get("text"));
            }
        }
    }

    private HashMap<String, Long> doPrepareDimensionAndMemberId(String dataChangeDim, DynamicObject newValue, List<String> otherDim) {
        long dimId = newValue.getLong("dimension.id");
        HashMap<String, Long> dimensionMap = new HashMap<String, Long>();
        dimensionMap.put(dataChangeDim + "f7id", newValue.getLong("id"));
        if (STR_YEAR.equals(dataChangeDim)) {
            dimensionMap.put("bcm_fymembertree", dimId);
        } else {
            dimensionMap.put("bcm_" + dataChangeDim + "membertree", dimId);
        }
        for (String key : otherDim) {
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(key);
            if (dynamicObject == null) {
                return new HashMap<String, Long>();
            }
            dimensionMap.put(key + "f7id", dynamicObject.getLong("id"));
            if (STR_YEAR.equals(key)) {
                dimensionMap.put("bcm_fymembertree", dynamicObject.getLong("dimension.id"));
                continue;
            }
            if (STR_MODEL.equals(key)) continue;
            dimensionMap.put("bcm_" + key + "membertree", dynamicObject.getLong("dimension.id"));
        }
        return dimensionMap;
    }

    private DynamicObjectCollection getTreeListORM(Long modelId) {
        DynamicObjectCollection dynColl = null;
        if (this.f7Complete()) {
            QFBuilder builder = new QFBuilder();
            builder.add("isleaf", "!=", (Object)true);
            dynColl = this.getCustomOrgDynamicObjectCollection(modelId, builder);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u6574\u9009\u62e9F7\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"InvelimSheetListPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (dynColl != null) {
            this.delOrgMenberPerm(dynColl, modelId);
            if (!dynColl.isEmpty()) {
                ArrayList<String> idList = new ArrayList<String>(10);
                for (DynamicObject doc : dynColl) {
                    idList.add(doc.getString("id"));
                }
                this.getPageCache().put("delOrgMenberPerm", ObjectSerialUtil.toByteSerialized(idList));
            }
        } else {
            this.getPageCache().remove("delOrgMenberPerm");
        }
        return dynColl;
    }

    private boolean f7Complete() {
        return Objects.nonNull(this.getModel().getValue(STR_MODEL)) && Objects.nonNull(this.getModel().getValue(STR_SCENE)) && Objects.nonNull(this.getModel().getValue(STR_YEAR)) && Objects.nonNull(this.getModel().getValue(STR_PERIOD));
    }

    private void initTree(AbstractTreeNode<Object> root) {
        TreeView tree = (TreeView)this.getControl(TREEVIEW_ENTITY);
        tree.setRootVisible(false);
        if (root != null) {
            TreeModel treemodel = new TreeModel(root);
            treemodel.buildEntryTree(tree);
            if (CollectionUtils.isEmpty((Collection)root.getChildren())) {
                return;
            }
            TreeNode selectnode = this.findCacheNode(root);
            tree.focusNode(selectnode);
            this.getPageCache().put(ENTITYSELECTED_NODE_ID, selectnode.getId());
            this.expandAllSelected((TreeModel<AbstractTreeNode<Object>>)treemodel, tree);
            treemodel.ache2page(this.getPageCache(), CACHE_TREEORG);
        }
    }

    private TreeNode findCacheNode(AbstractTreeNode<Object> root) {
        DynamicObject modelDy = (DynamicObject)this.getModel().getValue(STR_MODEL);
        long modelId = modelDy == null ? 0L : modelDy.getLong("id");
        String selectNode = GuidePageUtils.getUserSelectOrg(this.getView(), this.getUserId(), modelId, false, false);
        String orgCache = this.getPageCache().get(SELECTORGS);
        if (orgCache != null) {
            List selects = (List)ObjectSerialUtil.deSerializedBytes((String)orgCache);
            selects.remove(NON_SELECT_NODE);
            selectNode = (String)selects.get(selects.size() - 1);
        } else {
            ArrayList<String> selectnodes = new ArrayList<String>();
            selectnodes.add(selectNode);
            this.getPageCache().put(SELECTORGS, ObjectSerialUtil.toByteSerialized(selectnodes));
        }
        if (selectNode == null || selectNode.equals(root.getId())) {
            return new TreeNode("0", ((ITreeNode)root.getChildren().get(0)).getId(), ((ITreeNode)root.getChildren().get(0)).getName());
        }
        LinkedList<AbstractTreeNode<Object>> queue = new LinkedList<AbstractTreeNode<Object>>();
        queue.add(root);
        while (!queue.isEmpty()) {
            ITreeNode node = (ITreeNode)queue.poll();
            if (node.getId().equals(selectNode)) {
                return new TreeNode(node.getParent().getId(), node.getId(), node.getName());
            }
            List children = node.getChildren();
            if (children.isEmpty()) continue;
            queue.addAll(children);
        }
        return new TreeNode("0", ((ITreeNode)root.getChildren().get(0)).getId(), ((ITreeNode)root.getChildren().get(0)).getName());
    }

    private void expandAllSelected(TreeModel<AbstractTreeNode<Object>> treemodel, TreeView treeView) {
        if (this.getPageCache().get(SELECTORGS) != null) {
            List selects = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(SELECTORGS));
            OrgTreeNode root = (OrgTreeNode)treemodel.getRoot();
            for (String nodeId : selects) {
                OrgTreeNode node = (OrgTreeNode)treemodel.searchByNodeId(nodeId);
                if (node == null || node.getId().equals(root.getId())) continue;
                String parentId = node.getParent().getId();
                while (!parentId.equals(root.getId())) {
                    treeView.expand(parentId);
                    node = (OrgTreeNode)node.getParent();
                    parentId = node.getParent().getId();
                }
            }
        }
    }

    private HashMap<String, Long> getF7id() {
        DynamicObject modelDyn = (DynamicObject)this.getModel().getValue(STR_MODEL);
        DynamicObject scenarioDyn = (DynamicObject)this.getModel().getValue(STR_SCENE);
        DynamicObject fyDyn = (DynamicObject)this.getModel().getValue(STR_YEAR);
        DynamicObject periodDyn = (DynamicObject)this.getModel().getValue(STR_PERIOD);
        HashMap<String, Long> map = new HashMap<String, Long>(16);
        if (modelDyn == null || scenarioDyn == null || fyDyn == null || periodDyn == null) {
            return map;
        }
        map.put(MODEL_F7ID, modelDyn.getLong("id"));
        map.put(SCENE_F7ID, scenarioDyn.getLong("id"));
        map.put("bcm_scenemembertree", scenarioDyn.getLong("dimension.id"));
        map.put(YEAR_F7ID, fyDyn.getLong("id"));
        map.put("bcm_fymembertree", fyDyn.getLong("dimension.id"));
        map.put(PERIOD_F7ID, periodDyn.getLong("id"));
        map.put("bcm_periodmembertree", periodDyn.getLong("dimension.id"));
        return map;
    }

    private DynamicObjectCollection getSelectTemplates() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        Object[] pks = billList.getSelectedRows().getPrimaryKeyValues();
        QFilter qf = new QFilter("id", "in", (Object)pks);
        String selectField = "id,template,model,scenario,year,period,entity,entity.id,entity.number,entity.name";
        return QueryServiceHelper.query((String)"bcm_invlimsheetentity", (String)selectField, (QFilter[])qf.toArray());
    }

    private void openLog() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_invlimsheetlogsearch");
        Object model = this.getValue(STR_MODEL);
        KDAssert.assertTrue((model != null ? 1 : 0) != 0, () -> new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"InvelimSheetListPlugin_41", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        Object scene = this.getValue(STR_SCENE);
        Object year = this.getValue(STR_YEAR);
        Object period = this.getValue(STR_PERIOD);
        IDNumberTreeNode selectedOrgNode = this.getSelectedEntity();
        formShowParameter.setCustomParam(STR_MODEL, ((DynamicObject)model).getPkValue());
        formShowParameter.setCustomParam(STR_SCENE, Optional.ofNullable(scene).map(DynamicObject.class::cast).map(DataEntityBase::getPkValue).orElseGet(() -> null));
        formShowParameter.setCustomParam(STR_YEAR, Optional.ofNullable(year).map(DynamicObject.class::cast).map(DataEntityBase::getPkValue).orElseGet(() -> null));
        formShowParameter.setCustomParam(STR_PERIOD, Optional.ofNullable(period).map(DynamicObject.class::cast).map(DataEntityBase::getPkValue).orElseGet(() -> null));
        formShowParameter.setCustomParam("entity", (Object)selectedOrgNode.getId());
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(formShowParameter);
    }
}

