/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest.sheet;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.bill.IBillPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.base.BaseModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.util.AccountMemberUtil;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.business.formula.model.FormulaEnum;
import kd.fi.bcm.business.invest.InvElimTemplateService;
import kd.fi.bcm.business.invest.InvSheetTemplateService;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.invsheet.InvSheetTemplateConstant;
import kd.fi.bcm.common.constant.invest.sharerela.InvRelationTypeConstant;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.exception.NotificationException;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.BCMTreeUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.util.AdjustCatalogUtil;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class InvsheetEntrySetPlugin
extends AbstractBaseFormPlugin
implements IBillPlugin {
    public static final String BCM_INVSHEETTPLENTRY = "bcm_invsheetttplentrys";
    private static final String CACHE_DIM = "cache_dim";
    private static final String CACHE_DEFAULT_DIM = "cache_default_dim";
    private static final String CTL_ENTRYENTITY = "invelimtplentry";
    public static final String ENTRYLISTTREE = "entrylisttree";
    public static final String FOCUSNODEID = "focusnodeid";
    public static final String TREELIST = "treelist";
    public static final String TOOLBARAP = "toolbarap";
    public static final String BTN_ADDENTRY = "btn_addentry";
    public static final String BTN_SAVE = "btn_save";
    public static final String BTN_DELETE = "btn_delete";
    public static final String BTN_COPYENTRY = "btn_copyentry";
    public static final String BTN_REFRESH = "btn_refresh";
    public static final String EXPORT_SETTING = "export_setting";
    private static final Map<String, String> dimKeys = new HashMap<String, String>();
    private static final Map<String, String> userdefineMap2Nums = new HashMap<String, String>();
    public static final String DEFAULT_ENTRY_ID = "9999999999";
    public static final String ROOT_ENTRY_ID = "0";
    public static final String BTN_REFRESH_CONFIRM = "btn_refresh_confirm";
    public static final String BTN_SAVE_CONFIRM = "btn_save_confirm";
    public static final String BTN_NODECHANGE_CONFIRM = "btn_nodechange_confirm";
    public static final String BTN_DELETE_CONFIRM = "btn_delete_confirm";
    public static final String IS_COPY = "isCopy";
    public static final String BCM_FORMPLUGIN = "fi-bcm-formplugin";
    public static final String CB_PROCESSTXT = "cb_processtxt";
    public static final String IMPORT_SETTING = "import_setting";
    public static final String MYCOMPANY = "mycompany";
    public static final String INTERCOMPANY = "internalcompany";
    private Long modelId;
    private Long scenarioId;
    private Long templateId;

    private String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"InvLimListPlugin_2", (String)BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private OpNameMultiLangEnumBridge getOperationExport() {
        return new OpNameMultiLangEnumBridge("\u5bfc\u51fa", "CheckUpChkListPlugin_5", BCM_FORMPLUGIN, "export");
    }

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(new ArrayList<String>(dimKeys.keySet()), SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
        this.getView().setVisible(Boolean.valueOf(!this.isViewStatus()), new String[]{BTN_SAVE, BTN_ADDENTRY, BTN_COPYENTRY, BTN_DELETE, EXPORT_SETTING});
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String f7Key = beforeF7SelectEvent.getProperty().getName();
        if ("account".equals(f7Key)) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("model.id", "=", (Object)this.getModelId()));
            qFilters.add(QFilter.of((String)"accountpart.isaccountoffset = ?", (Object[])new Object[]{true}));
            qFilters.add(QFilter.of((String)"storagetype != ?", (Object[])new Object[]{"3"}));
            qFilters.add(QFilter.of((String)"isleaf =?", (Object[])new Object[]{"1"}));
            if (!QueryServiceHelper.exists((String)"bcm_accountmembertree", (QFilter[])qFilters.toArray(new QFilter[3]))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u53c2\u4e0e\u62b5\u9500\u7684\u79d1\u76ee\uff0c\u8bf7\u5728\u7ef4\u5ea6\u7ba1\u7406\u4e2d\u5bf9\u79d1\u76ee\u8fdb\u884c\u76f8\u5173\u5c5e\u6027\u8bbe\u7f6e\u3002", (String)"InvsheetEntrySetPlugin_0", (String)BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setFormId("bos_listf7");
            formShowParameter.getListFilterParameter().setQFilters(qFilters);
        } else if ("audittrail".equals(f7Key)) {
            QFilter sourceFilter = new QFilter("datasource", "=", (Object)"3");
            if (beforeF7SelectEvent.getFormShowParameter() instanceof ListShowParameter) {
                ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                qFilters.add(sourceFilter);
                formShowParameter.setFormId("bos_listf7");
                formShowParameter.getListFilterParameter().getQFilters().addAll(qFilters);
            } else {
                FormShowParameter formShowParameter = beforeF7SelectEvent.getFormShowParameter();
                formShowParameter.setFormId("bos_listf7");
                formShowParameter.setCustomParam("customFilter", (Object)sourceFilter.toSerializedString());
            }
        } else if (MYCOMPANY.equals(f7Key) || INTERCOMPANY.equals(f7Key)) {
            BasedataEditSingleMemberF7 source = (BasedataEditSingleMemberF7)((Object)beforeF7SelectEvent.getSource());
            source.setSystemVariables(SystemVarsEnum.getInvDimVars());
            if ("getLookUpList".equals(beforeF7SelectEvent.getSourceMethod()) || "setItemByIdFromClient".equals(beforeF7SelectEvent.getSourceMethod())) {
                ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                List qFilters = formShowParameter.getListFilterParameter().getQFilters();
                AtomicReference qFilter = new AtomicReference();
                qFilters.stream().forEach(filter -> {
                    if (!Optional.ofNullable(qFilter.get()).isPresent()) {
                        qFilter.set(filter);
                        return;
                    }
                    ((QFilter)qFilter.get()).and(filter);
                });
                QFBuilder qfBuilders = new QFBuilder().add(new QFilter("model", "=", (Object)SystemVarsEnum.getDefaultModelId()).and("dimension", "=", (Object)SystemVarsEnum.getDefaultDimension()).and("number", "in", (Object)SystemVarsEnum.getInvDimVars())).or((QFilter)qFilter.get());
                formShowParameter.getListFilterParameter().setQFilters(qfBuilders.toList());
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("ruleexpr", "ruleexprdept", "description");
        TreeView tview = (TreeView)this.getControl(ENTRYLISTTREE);
        tview.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                String selectedNodeID;
                String focusnodeID = InvsheetEntrySetPlugin.this.getPageCache().get(InvsheetEntrySetPlugin.FOCUSNODEID);
                if (!focusnodeID.equals(selectedNodeID = evt.getNodeId().toString())) {
                    Long id = ((DynamicObject)InvsheetEntrySetPlugin.this.getModel().getValue("sheettemplate")).getLong("id");
                    DynamicObject invtemplation = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_papertemplate", (String)"id,name,number,count,status");
                    if (InvsheetEntrySetPlugin.this.getModel().getDataChanged() && invtemplation != null && !invtemplation.get("status").equals(InvSheetTemplateConstant.BillStatusEnum.ENABLE.getCode())) {
                        InvsheetEntrySetPlugin.this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4fee\u6539\uff0c\u662f\u5426\u4fdd\u5b58\u6570\u636e?", (String)"InvsheetEntrySetPlugin_6", (String)InvsheetEntrySetPlugin.BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(InvsheetEntrySetPlugin.BTN_NODECHANGE_CONFIRM));
                        return;
                    }
                    super.treeNodeClick(evt);
                    InvsheetEntrySetPlugin.this.getPageCache().put(InvsheetEntrySetPlugin.FOCUSNODEID, selectedNodeID);
                    InvsheetEntrySetPlugin.this.getPageCache().put("parent", evt.getParentNodeId().toString());
                    InvsheetEntrySetPlugin.this.refrushEntryInfo();
                }
            }
        });
        this.addItemClickListeners(TOOLBARAP);
        BasedataEdit account = (BasedataEdit)this.getControl("account");
        BasedataEdit at = (BasedataEdit)this.getControl("audittrail");
        BasedataEdit mycompany = (BasedataEdit)this.getControl(MYCOMPANY);
        BasedataEdit intercompany = (BasedataEdit)this.getControl(INTERCOMPANY);
        account.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        at.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        mycompany.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        intercompany.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEditSingleMemberF7 dataSort = (BasedataEditSingleMemberF7)this.getControl("datasource");
        BasedataEditSingleMemberF7 multiGap = (BasedataEditSingleMemberF7)this.getControl("multigaap");
        BasedataEditSingleMemberF7 changeType = (BasedataEditSingleMemberF7)this.getControl("changetype");
        dataSort.setCustomFilter(this.getDimMapFilter(DimTypesEnum.DATASORT.getNumber(), "account"));
        multiGap.setCustomFilter(this.getDimMapFilter(DimTypesEnum.MULTIGAAP.getNumber(), "account"));
        changeType.setCustomFilter(this.getDimMapFilter(DimTypesEnum.CHANGETYPE.getNumber(), "account"));
        Map<String, String> dimKeyCache = this.getDimKeyCache();
        for (int i = 1; i <= 6; ++i) {
            String userDefinedIndex = "userdefine" + i;
            String userDefinedNumber = dimKeyCache.get(userDefinedIndex);
            if (!StringUtils.isNotEmpty((String)userDefinedNumber)) continue;
            BasedataEditSingleMemberF7 userControl = (BasedataEditSingleMemberF7)this.getControl(userDefinedIndex);
            userControl.setCustomFilter(this.getDimMapFilter(userDefinedNumber, "account"));
        }
        BasedataEdit invRelationType = (BasedataEdit)this.getControl("relationtype");
        invRelationType.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            Object pkId = ((DynamicObject)this.getModel().getValue("sheettemplate")).get("id");
            String pkField = String.join((CharSequence)".", "invrelationtype", "fbasedataid");
            String process = MemberReader.findProcessMemberById((String)this.getCurModelNumber(), (Long)LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("process"))).getNumber();
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_papertemplate", (String)pkField, (QFilter[])new QFBuilder("id", "=", pkId).toArray());
            List pkIdList = query.stream().map(dy -> dy.getLong(pkField)).collect(Collectors.toList());
            FormShowParameter formShowParameter = beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setCustomParam("model", (Object)this.getModelId());
            formShowParameter.setCustomParam("process", (Object)process);
            formShowParameter.setCustomParam("pks", pkIdList);
            DynamicObject relationtype = (DynamicObject)this.getModel().getValue("relationtype");
            if (Objects.nonNull(relationtype)) {
                formShowParameter.setCustomParam("invrelatypebase", (Object)relationtype);
            }
            formShowParameter.setCustomParam("categorized", (Object)InvRelationTypeConstant.CatalogEnum.relation.getCode());
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", pkIdList));
        });
        AdjustCatalogUtil.setAdjustCatalogFilter((BasedataEdit)this.getControl("adjustcatalog"), String.valueOf((Long)this.getView().getFormShowParameter().getCustomParam("model")));
    }

    @Override
    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("description".equals(key)) {
            int[] selectRows = ((EntryGrid)this.getView().getControl(CTL_ENTRYENTITY)).getSelectRows();
            if (selectRows.length < 1) {
                return;
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bcm_largertextedit");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            int selectRow = selectRows[0];
            formShowParameter.setCustomParam("textareafield", this.getModel().getValue("description", selectRow));
            Object billstatus = this.getModel().getValue("billstatus");
            if (billstatus != null && BillStatus.C.name().equals(billstatus)) {
                formShowParameter.setCustomParam("lock", (Object)Boolean.TRUE);
            }
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if ("description".equals(actionId) && e.getReturnData() != null) {
            int[] selectRows = ((EntryGrid)this.getView().getControl(CTL_ENTRYENTITY)).getSelectRows();
            if (selectRows.length < 1) {
                return;
            }
            int selectRow = selectRows[0];
            HashMap returnData = (HashMap)e.getReturnData();
            this.getModel().setValue("description", (Object)returnData.getOrDefault("textareafield", ""), selectRow);
        } else if (IMPORT_SETTING.equals(actionId)) {
            String showOrgType = (String)this.getValue("showorgtype");
            this.updateEntryCount();
            this.initData();
            this.getView().invokeOperation("refresh");
            this.setValue("showorgtype", showOrgType);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (BTN_DELETE_CONFIRM.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            String focusnodeID = this.getPageCache().get(FOCUSNODEID);
            if (!DEFAULT_ENTRY_ID.equals(focusnodeID)) {
                DeleteServiceHelper.delete((IDataEntityType)this.getModel().getDataEntityType(), (Object[])new Long[]{(Long)this.getModel().getValue("id")});
                this.updateEntryCount();
            }
            this.initTree();
            this.refrushEntryInfo();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"InvsheetEntrySetPlugin_7", (String)BCM_FORMPLUGIN, (Object[])new Object[0]));
        } else if (BTN_SAVE_CONFIRM.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation("save");
        } else if (BTN_NODECHANGE_CONFIRM.equals(event.getCallBackId())) {
            TreeView tview = (TreeView)this.getControl(ENTRYLISTTREE);
            String focusNodeId = tview.getTreeState().getFocusNodeId();
            if (event.getResult() == MessageBoxResult.Yes) {
                OperationResult saveResult = this.getView().invokeOperation("save");
                if (saveResult.isSuccess()) {
                    this.getPageCache().put(FOCUSNODEID, focusNodeId);
                    tview.focusNode(new TreeNode("", focusNodeId, ""));
                    this.refrushEntryInfo();
                } else {
                    String oldNodeId = this.getPageCache().get(FOCUSNODEID);
                    tview.focusNode(new TreeNode("", oldNodeId, ""));
                }
            } else {
                this.getPageCache().put(FOCUSNODEID, focusNodeId);
                this.initTree();
                this.refrushEntryInfo();
            }
        } else if (BTN_REFRESH_CONFIRM.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            this.initTree();
            this.refrushEntryInfo();
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (StringUtils.isEmpty((String)key)) {
            return;
        }
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        if ("account".equals(key)) {
            DynamicObject account = (DynamicObject)this.getModel().getValue("account", rowIndex);
            if (account != null) {
                long accId = account.getLong("id");
                Map map = AccountMemberUtil.getAccountDimValMapWithCache((Long)accId, (long)this.getModelId(), (IPageCache)this.getPageCache());
                Map<String, String> dimNumberMap = this.getDimNumberMap();
                for (Map.Entry<String, String> entry : dimNumberMap.entrySet()) {
                    this.setDimMemFilter(rowIndex, map, entry.getKey(), entry.getValue());
                }
            }
        } else if ("showorgtype".equals(key)) {
            String showType = (String)this.getModel().getValue("showorgtype");
            this.getPageCache().put("showorgtype", showType);
            this.initTree();
        } else if ("ruleexpr".equals(key) || "ruleexprdept".equals(key)) {
            int[] selectRows = ((EntryGrid)this.getView().getControl(CTL_ENTRYENTITY)).getSelectRows();
            if (selectRows.length < 1 || Boolean.parseBoolean(this.getPageCache().get(IS_COPY))) {
                return;
            }
            int selectRow = selectRows[0];
            this.getModel().beginInit();
            if ("ruleexpr".equals(key)) {
                this.getModel().setValue("ruleexprdept", (Object)"", selectRow);
            } else {
                this.getModel().setValue("ruleexpr", (Object)"", selectRow);
            }
            this.getView().updateView();
            this.getModel().endInit();
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent args) {
        super.beforeClosed(args);
        if (!this.checkHasSave() && !Boolean.parseBoolean(this.getPageCache().get(IS_COPY))) {
            this.getModel().setDataChanged(false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Save && !this.checkRootNode()) {
            String process = MemberReader.findProcessMemberById((String)this.getCurModelNumber(), (Long)LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("process"))).getNumber();
            DynamicObjectCollection invTemplateEntry = (DynamicObjectCollection)this.getModel().getDataEntity(true).get(CTL_ENTRYENTITY);
            HashSet<Long> collect = new HashSet<Long>(16);
            int bncount = 0;
            String entitycomb = "";
            for (DynamicObject entry2 : invTemplateEntry) {
                entitycomb = entry2.getString("entitycomb");
                if (!(OrgRelaProcessMembPool.isRelaProcess((String)process) || StringUtils.isEmpty((String)entitycomb) || entitycomb.equals("1"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"ERADJ\u548cRADJ\u7684\u5206\u5f55\u8bbe\u7f6e\u7ec4\u7ec7\u5217\u53ea\u80fd\u8bbe\u7f6e\u6295\u8d44\u5355\u4f4d\u3002", (String)"InvsheetEntrySetPlugin_15", (String)BCM_FORMPLUGIN, (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                entitycomb = entry2.getString("entitycomb");
                String ruleexpr = entry2.getString("ruleexpr");
                String ruleexprdept = entry2.getString("ruleexprdept");
                if (!StringUtils.isEmpty((String)ruleexpr) && ruleexpr.equals("bn") || !StringUtils.isEmpty((String)ruleexprdept) && ruleexprdept.equals("bn")) {
                    if (++bncount <= 1) continue;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u5f55\u884c\u8bbe\u7f6e\u5e73\u8861\u6570\u8d85\u8fc71\u884c\u3002", (String)"InvsheetEntrySetPlugin_11", (String)BCM_FORMPLUGIN, (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (!StringUtils.isEmpty((String)ruleexpr)) {
                    collect.add(LongUtil.toLong((Object)ruleexpr));
                    continue;
                }
                if (StringUtils.isEmpty((String)ruleexprdept)) continue;
                collect.add(LongUtil.toLong((Object)ruleexprdept));
            }
            QFBuilder qfBuilder = new QFBuilder("template.id", "=", ((DynamicObject)this.getModel().getValue("sheettemplate")).get("id"));
            qfBuilder.add(new QFilter("extdimid.id", "in", collect));
            DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_invsheetacclayout", (String)"id,extdimid.id as extdimid,extdimid.name as name,extdimid.number as number", (QFilter[])qfBuilder.toArray());
            Set extdimids = doc.stream().map(acc -> acc.getLong("extdimid")).collect(Collectors.toSet());
            Sets.SetView difference = Sets.difference(collect, extdimids);
            if (!difference.isEmpty()) {
                Set numbers = invTemplateEntry.stream().filter(entry -> difference.contains((Object)LongUtil.toLong((Object)entry.get("ruleexpr")))).map(dy -> String.valueOf(dy.get("seq"))).collect(Collectors.toSet());
                String numbermsg = String.join((CharSequence)",", numbers);
                String msg = String.format(ResManager.loadKDString((String)"\u7b2c[%s]\u5206\u5f55\u884c\u501f\u8d37\u914d\u7f6e\u9879\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5e76\u91cd\u65b0\u9009\u62e9\u3002", (String)"InvsheetEntrySetPlugin_9", (String)BCM_FORMPLUGIN, (Object[])new Object[0]), numbermsg);
                this.getView().showErrorNotification(msg);
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("save".equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            if (!this.checkHasSave()) {
                this.getPageCache().put(FOCUSNODEID, String.valueOf(args.getOperationResult().getSuccessPkIds().get(0)));
                this.updateEntryCount();
            }
            this.initTree();
            this.getPageCache().put(IS_COPY, "false");
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
        }
    }

    private void updateEntryCount() {
        long id = (Long)((DynamicObject)this.getModel().getValue("sheettemplate")).get("id");
        int size = InvSheetTemplateService.getSheetEntryList((Long)this.getModelId(), (Long)id).size();
        DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_papertemplate");
        template.set("count", (Object)size);
        SaveServiceHelper.update((DynamicObject)template);
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        String f7Key = e.getKey();
        String cacheDim = this.getPageCache().get(CACHE_DIM);
        if (!StringUtils.isEmpty((String)cacheDim)) {
            Map cachDimKeys = (Map)ObjectSerialUtil.deSerializedBytes((String)cacheDim);
            String pagekey = (String)cachDimKeys.get(f7Key);
            if (this.getDimKeysFromCache().containsKey(f7Key)) {
                SingleF7TypeEnum type = this.getDimKeysFromCache().get(f7Key);
                Control ctrl = (Control)this.cacheControls.get(f7Key);
                if (ctrl != null) {
                    e.setControl(ctrl);
                } else {
                    BasedataEditSingleMemberF7 f7 = SingleMemberF7Util.getBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), pagekey, f7Key, ev -> this.getSingleMemberF7Handle(Lists.newArrayList(this.getDimKeysFromCache().keySet())).beforeSingleMemberF7Select(ev), false, type);
                    f7.setDisplayProp("name");
                    Map<String, Object> customData = f7.getCustomData();
                    if (customData == null) {
                        customData = new HashMap<String, Object>();
                        f7.setCustomData(customData);
                    }
                    customData.put("isContainShare", false);
                    e.setControl((Control)f7);
                    this.cacheControls.put(f7Key, f7);
                }
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initData();
    }

    private void initData() {
        try {
            this.initBaseInfo();
            this.initTree();
            this.refrushEntryInfo();
        }
        catch (NotificationException ex) {
            log.error((Throwable)ex);
            this.getView().getParentView().showTipNotification(ex.getMessage());
            this.getView().getParentView().close();
            this.getView().close();
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        if (this.isViewStatus()) {
            return;
        }
        super.itemClick(evt);
        if ((BTN_DELETE.equals(evt.getItemKey()) || BTN_COPYENTRY.equals(evt.getItemKey())) && this.checkRootNode()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u5220\u9664\u6216\u590d\u5236\u3002", (String)"InvsheetEntrySetPlugin_10", (String)BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if ((BTN_ADDENTRY.equals(evt.getItemKey()) || BTN_COPYENTRY.equals(evt.getItemKey())) && !this.checkHasSave()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u65b0\u589e\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u6570\u636e\u3002", (String)"InvsheetEntrySetPlugin_4", (String)BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.Toast);
            return;
        }
        if (BTN_REFRESH.equals(evt.getItemKey()) && (!this.checkHasSave() || this.getModel().getDataChanged())) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u662f\u5426\u7ee7\u7eed\u5237\u65b0?", (String)"InvsheetEntrySetPlugin_8", (String)BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(BTN_REFRESH_CONFIRM, (IFormPlugin)this));
            return;
        }
        if ((BTN_ADDENTRY.equals(evt.getItemKey()) || BTN_COPYENTRY.equals(evt.getItemKey())) && this.getModel().getDataChanged()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4fee\u6539\uff0c\u662f\u5426\u4fdd\u5b58\u6570\u636e?", (String)"InvsheetEntrySetPlugin_6", (String)BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(BTN_SAVE_CONFIRM, (IFormPlugin)this));
            return;
        }
        if (BTN_ADDENTRY.equals(evt.getItemKey())) {
            List treeList = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(TREELIST), Map.class);
            treeList.add(this.addNewEntryNode());
            this.updateTreeView(DEFAULT_ENTRY_ID, treeList);
            this.refrushEntryInfo();
        } else if (BTN_DELETE.equals(evt.getItemKey())) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u5206\u5f55\u6570\u636e\uff1f", (String)"InvsheetEntrySetPlugin_1", (String)BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(BTN_DELETE_CONFIRM, (IFormPlugin)this));
        } else if (BTN_COPYENTRY.equals(evt.getItemKey())) {
            this.getPageCache().put(IS_COPY, "true");
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            ((BaseModel)this.getModel()).copy(dataEntity.get("id"), true);
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"number"});
        } else if (BTN_REFRESH.equals(evt.getItemKey())) {
            this.initData();
        } else if (EXPORT_SETTING.equals(evt.getItemKey())) {
            this.exportSetting();
        } else if (IMPORT_SETTING.equals(evt.getItemKey())) {
            String str = ResManager.loadKDString((String)"\u6743\u76ca\u5e95\u7a3f\u5206\u5f55\u8bbe\u7f6e", (String)"InvsheetEntrySetPlugin_12", (String)BCM_FORMPLUGIN, (Object[])new Object[0]);
            super.invokeOperation(BCM_INVSHEETTPLENTRY, "kd.fi.bcm.formplugin.invest.InvSheetTemplatetSettingImportPlugin", str, IMPORT_SETTING);
        }
    }

    private void exportSetting() {
        try {
            long templateId = (Long)((DynamicObject)this.getModel().getValue("sheettemplate")).get("id");
            DynamicObjectCollection sheetEntryList = InvSheetTemplateService.getSheetEntryList((Long)this.getModelId(), (Long)templateId);
            Object[] ids = sheetEntryList.stream().map(entry -> entry.getLong("id")).collect(Collectors.toList()).toArray();
            Map entryMaps = BusinessDataServiceHelper.loadFromCache((Object[])ids, (String)BCM_INVSHEETTPLENTRY);
            DynamicObject[] dys = entryMaps.values().stream().collect(Collectors.toList()).toArray(new DynamicObject[0]);
            if (CollectionUtils.isEmpty(entryMaps.values())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u65e0\u5206\u5f55\u8bbe\u7f6e\u3002", (String)"InvsheetEntrySetPlugin_14", (String)BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            HashSet extIds = new HashSet(16);
            Arrays.stream(dys).forEach(e -> {
                e.set("categorized", e.get("relationtype.categorized"));
                DynamicObjectCollection entryDys = e.getDynamicObjectCollection(CTL_ENTRYENTITY);
                entryDys.stream().forEach(entry -> {
                    String ruleexpr = entry.getString("ruleexpr");
                    String ruleexprdept = entry.getString("ruleexprdept");
                    if (!StringUtils.isBlank((String)ruleexpr) && !"bn".equals(ruleexpr)) {
                        extIds.add(LongUtil.toLong((Object)ruleexpr));
                    }
                    if (!StringUtils.isBlank((String)ruleexprdept) && !"bn".equals(ruleexprdept)) {
                        extIds.add(LongUtil.toLong((Object)ruleexprdept));
                    }
                });
            });
            DynamicObjectCollection extDims = QueryServiceHelper.query((String)"bcm_structofextend", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", extIds)});
            Map<Long, DynamicObject> extDimMaps = extDims.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v, (v1, v2) -> v1));
            Arrays.stream(dys).forEach(e -> {
                DynamicObjectCollection entryDys = e.getDynamicObjectCollection(CTL_ENTRYENTITY);
                entryDys.stream().forEach(entry -> {
                    String ruleexpr = entry.getString("ruleexpr");
                    String ruleexprdept = entry.getString("ruleexprdept");
                    if (!StringUtils.isBlank((String)ruleexpr) && !"bn".equals(ruleexpr)) {
                        entry.set("ruleexpr", (Object)((DynamicObject)extDimMaps.get(LongUtil.toLong((Object)ruleexpr))).getString("number"));
                    }
                    if (!StringUtils.isBlank((String)ruleexprdept) && !"bn".equals(ruleexprdept)) {
                        entry.set("ruleexprdept", (Object)((DynamicObject)extDimMaps.get(LongUtil.toLong((Object)ruleexprdept))).getString("number"));
                    }
                });
            });
            String routeAppId = this.getView().getFormShowParameter().getServiceAppId();
            String url = ExportUtil.export((DynamicObject[])dys, (String)routeAppId, (String)BCM_INVSHEETTPLENTRY);
            if (StringUtils.isNotEmpty((String)url)) {
                this.downloadFile(url, "bcm_papertemplatelist", "3=3/NUOSE6ZU");
                this.writeOperationLog(this.getOperationExport(), this.getOperationStstusSuccess());
            }
        }
        catch (Exception e2) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff1a%s", (String)"InvsheetEntrySetPlugin_13", (String)BCM_FORMPLUGIN, (Object[])new Object[0]), e2.getMessage()));
        }
    }

    public boolean checkHasSave() {
        String nodeId = this.getPageCache().get(FOCUSNODEID);
        return !DEFAULT_ENTRY_ID.equals(nodeId);
    }

    public boolean checkRootNode() {
        String nodeId = this.getPageCache().get(FOCUSNODEID);
        return ROOT_ENTRY_ID.equals(nodeId);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject modelDyn = (DynamicObject)this.getModel().getValue("model");
        this.initComboItems();
        EntryGrid grid = (EntryGrid)this.getControl(CTL_ENTRYENTITY);
        Map<String, String> dimKeyCache = this.getDimKeyCache();
        for (int i = 1; i <= 6; ++i) {
            String userDefinedIndex = "userdefine" + i;
            String userDefinedNumber = dimKeyCache.get(userDefinedIndex);
            if (StringUtils.isNotEmpty((String)userDefinedNumber)) {
                String userDefinedName = dimKeyCache.get(userDefinedIndex + "name");
                grid.setColumnProperty(userDefinedIndex, "header", (Object)new LocaleString(userDefinedName));
                grid.setMustInput(userDefinedIndex, true);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{userDefinedIndex});
                continue;
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{userDefinedIndex});
        }
        boolean isspptdatasort = modelDyn.getBoolean("isspptdatasort");
        this.getView().setVisible(Boolean.valueOf(isspptdatasort), new String[]{"datasource"});
        grid.setMustInput("datasource", isspptdatasort);
        boolean isspptmultrule = modelDyn.getBoolean("isspptmultrule");
        this.getView().setVisible(Boolean.valueOf(isspptmultrule), new String[]{"multigaap"});
        grid.setMustInput("multigaap", isspptmultrule);
        boolean existsMyCompanyDim = DimensionServiceHelper.existsMyCompanyDim((long)modelDyn.getLong("id"));
        this.getView().setVisible(Boolean.valueOf(existsMyCompanyDim), new String[]{MYCOMPANY});
        grid.setMustInput(MYCOMPANY, existsMyCompanyDim);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        this.fillEntryRow(rowDataEntities);
    }

    private void fillEntryRow(RowDataEntity[] rowDataEntities) {
        IDataModel model = this.getModel();
        DynamicObject modelDyn = (DynamicObject)model.getValue("model");
        this.initDCCommon();
        if (modelDyn != null) {
            Map<String, String> dimDefaultId = this.geneDimDefaultId(modelDyn);
            for (RowDataEntity rowData : rowDataEntities) {
                for (Map.Entry<String, String> entry : dimDefaultId.entrySet()) {
                    model.setValue(entry.getKey(), (Object)Long.valueOf(entry.getValue()), rowData.getRowIndex());
                }
            }
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IDataModel model = this.getModel();
        String name = model.getDataEntity(true).getString("name");
        model.setValue("name", (Object)(name + "copy"));
        String templateNumber = (String)this.getView().getFormShowParameter().getCustomParam("number");
        long templateId = (Long)((DynamicObject)this.getModel().getValue("sheettemplate")).get("id");
        String seqStr = InvSheetTemplateService.getMaxEntrySeq((Long)this.getModelId(), (Long)templateId, (String)templateNumber);
        model.setValue("number", (Object)(templateNumber + seqStr));
        String showOrgType = this.getPageCache().get("showorgtype");
        model.setValue("showorgtype", (Object)showOrgType);
        List treeList = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(TREELIST), Map.class);
        treeList.add(this.addNewEntryNode());
        this.updateTreeView(DEFAULT_ENTRY_ID, treeList);
    }

    public void afterLoadData(EventObject e) {
        IDataModel model = this.getModel();
        String status = (String)model.getValue("billstatus");
        this.initComboItems();
        if ("C".equals(status)) {
            int entryRowCount = model.getEntryRowCount(CTL_ENTRYENTITY);
            boolean modify = false;
            Map<String, String> dimDefaultId = null;
            DynamicObject modelDyn = (DynamicObject)model.getValue("model");
            if (entryRowCount > 0) {
                String value;
                Map<String, String> cachDimKeys = this.getDimKeyCache();
                for (int i = 1; i <= 6 && StringUtils.isNotEmpty((String)(value = cachDimKeys.get("userdefine" + i))); ++i) {
                    if (model.getValue("userdefine" + i, 0) != null) continue;
                    for (int j = 0; j < entryRowCount; ++j) {
                        if (dimDefaultId == null) {
                            dimDefaultId = this.geneDimDefaultId(modelDyn);
                        }
                        if (!Objects.nonNull(dimDefaultId.get("userdefine" + i))) continue;
                        model.setValue("userdefine" + i, (Object)Long.valueOf(dimDefaultId.get("userdefine" + i)), j);
                        modify = true;
                    }
                }
            }
            if (modify) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{model.getDataEntity(true)});
            }
        }
    }

    private void initBaseInfo() {
        DynamicObject dynamicObject;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        this.modelId = (Long)formShowParameter.getCustomParam("model");
        this.scenarioId = (Long)formShowParameter.getCustomParam("scenario");
        this.templateId = (Long)formShowParameter.getCustomParam("id");
        if (this.modelId == null || this.templateId == null) {
            String errorMeg = ResManager.loadKDString((String)"\u4f53\u7cfb\u6216\u6a21\u677fID\u4e3a\u7a7a\u3002", (String)"InvsheetEntrySetPlugin_5", (String)BCM_FORMPLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMeg);
            throw new KDBizException(errorMeg);
        }
        IDataModel model = this.getModel();
        model.setValue("model", (Object)this.modelId);
        model.setValue("scenario", (Object)this.scenarioId);
        try {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)this.templateId, (String)"bcm_papertemplate", (String)"id,name,number,count");
        }
        catch (Exception e) {
            this.getModel().setDataChanged(false);
            throw new NotificationException((Throwable)e);
        }
        model.setValue("sheettemplate", (Object)dynamicObject);
        String showType = this.getPageCache().get("showorgtype");
        showType = StringUtils.isEmpty((String)showType) ? "2" : showType;
        this.getPageCache().put("showorgtype", showType);
        model.setValue("showorgtype", (Object)showType);
    }

    private void refrushEntryInfo() {
        String nodeid = this.getPageCache().get(FOCUSNODEID);
        String showorgtype = this.getPageCache().get("showorgtype");
        DynamicObject dynamicObject = new DynamicObject();
        if (nodeid.equals(DEFAULT_ENTRY_ID)) {
            String templateNumber = (String)this.getView().getFormShowParameter().getCustomParam("number");
            long id = (Long)((DynamicObject)this.getModel().getValue("sheettemplate")).get("id");
            DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_papertemplate");
            String seqStr = InvSheetTemplateService.getMaxEntrySeq((Long)this.getModelId(), (Long)id, (String)templateNumber);
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)BCM_INVSHEETTPLENTRY);
            dynamicObject.set("number", (Object)(StringUtils.isNotEmpty((String)templateNumber) ? templateNumber + seqStr : ""));
            dynamicObject.set("journaltype", (Object)1);
            dynamicObject.set("showorgtype", (Object)showorgtype);
            dynamicObject.set("sheettemplate", (Object)template);
            this.getModel().putContextVariable("MODEL_INIT_BY_WEBAPI", (Object)true);
            this.getModel().createNewData((Object)dynamicObject);
            this.initBaseInfo();
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"number"});
        } else {
            try {
                dynamicObject = BusinessDataServiceHelper.loadSingle((Object)nodeid, (String)BCM_INVSHEETTPLENTRY);
                dynamicObject.set("showorgtype", (Object)showorgtype);
                this.getModel().setValue("id", dynamicObject.get("id"));
                this.getModel().putContextVariable("MODEL_INIT_BY_WEBAPI", (Object)true);
                this.getModel().createNewData((Object)dynamicObject);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        this.initComboItems();
        String cbProcessValue = (String)this.getView().getFormShowParameter().getCustomParam("cb_process_value");
        Long processId = LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("process"));
        if (StringUtils.isBlank((String)cbProcessValue) && LongUtil.isvalidLong((Object)processId)) {
            DynamicObject process = this.getProcess(this.getModelId(), processId);
            cbProcessValue = process.getString("number") + " " + process.getString("name");
        }
        this.getModel().setValue(CB_PROCESSTXT, (Object)cbProcessValue);
        this.getModel().setValue("process", (Object)processId);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{CB_PROCESSTXT});
        this.initDCCommon();
        this.getView().updateView();
        this.getModel().setDataChanged(false);
        if (nodeid.equals(DEFAULT_ENTRY_ID)) {
            this.getModel().setDataChanged(true);
        } else {
            this.getModel().setDataChanged(false);
        }
        this.getPageCache().put(IS_COPY, "false");
    }

    protected void initTree() {
        String nodeid = this.getPageCache().get(FOCUSNODEID);
        String showType = this.getPageCache().get("showorgtype");
        this.getPageCache().remove(FOCUSNODEID);
        long templateId = (Long)((DynamicObject)this.getModel().getValue("sheettemplate")).get("id");
        DynamicObjectCollection sheetEntryList = InvSheetTemplateService.getSheetEntryList((Long)this.getModelId(), (Long)templateId);
        List<Map<String, String>> treeList = this.getEntryListTreeNode(sheetEntryList, showType);
        if (treeList.size() == 0) {
            LinkedHashMap<String, String> newEntryNode = this.addNewEntryNode();
            treeList.add(newEntryNode);
        }
        this.getPageCache().put(TREELIST, SerializationUtils.toJsonString(treeList));
        this.updateTreeView(nodeid, treeList);
    }

    private LinkedHashMap<String, String> addNewEntryNode() {
        LinkedHashMap<String, String> memberMap = new LinkedHashMap<String, String>();
        memberMap.put("id", DEFAULT_ENTRY_ID);
        memberMap.put("number", "number");
        memberMap.put("name", ResManager.loadKDString((String)"\u65b0\u5efa\u5206\u5f55", (String)"InvsheetEntrySetPlugin_2", (String)BCM_FORMPLUGIN, (Object[])new Object[0]));
        memberMap.put("parentid", ROOT_ENTRY_ID);
        return memberMap;
    }

    private void updateTreeView(String nodeid, List<Map<String, String>> treeList) {
        TreeNode treeRootNode = this.genListTreeRootNode(treeList);
        TreeView tree = (TreeView)this.getControl(ENTRYLISTTREE);
        tree.deleteAllNodes();
        tree.addNode(treeRootNode);
        TreeNode fo = this.findFocusNodeById(nodeid, treeRootNode);
        if (fo == null) {
            fo = treeRootNode.getChildren() != null && treeRootNode.getChildren().size() > 0 ? (TreeNode)treeRootNode.getChildren().get(0) : treeRootNode;
        }
        this.getPageCache().put(FOCUSNODEID, fo.getId());
        tree.focusNode(fo);
    }

    private static String formatDisplayName(String showType, String name, String number, String currencyName) {
        String formatName = name;
        switch (showType = StringUtils.isEmpty((String)showType) ? "2" : showType) {
            case "2": {
                formatName = number + " " + name;
                break;
            }
            case "3": {
                formatName = StringUtils.isNotEmpty((String)currencyName) ? name + " " + currencyName : name;
                break;
            }
            case "4": {
                formatName = StringUtils.isNotEmpty((String)currencyName) ? number + " " + name + " " + currencyName : name;
            }
        }
        return formatName;
    }

    private TreeNode genListTreeRootNode(List<Map<String, String>> treeList) {
        TreeNode treeRootNode = new TreeNode();
        String headid = ROOT_ENTRY_ID;
        String headName = ResManager.loadKDString((String)"\u6a21\u677f\u5206\u5f55", (String)"InvsheetEntrySetPlugin_3", (String)BCM_FORMPLUGIN, (Object[])new Object[0]);
        treeRootNode.setParentid("");
        treeRootNode.setId(headid);
        treeRootNode.setText(headName);
        BCMTreeUtils.setEntryNode((TreeNode)treeRootNode, treeList, (String)headid);
        BCMTreeUtils.spreadAllNode((TreeNode)treeRootNode);
        return treeRootNode;
    }

    private List<Map<String, String>> getEntryListTreeNode(DynamicObjectCollection dcs, String showType) {
        ArrayList<Map<String, String>> treeList = new ArrayList<Map<String, String>>();
        if (dcs != null && dcs.size() > 0) {
            for (DynamicObject task : dcs) {
                HashMap<String, String> memberMap = new HashMap<String, String>();
                memberMap.put("id", task.get("id").toString());
                String number = (String)task.get("number");
                memberMap.put("number", number);
                String name = (String)task.get("name");
                String displayName = InvsheetEntrySetPlugin.formatDisplayName(showType, name, number, "");
                memberMap.put("name", displayName);
                memberMap.put("parentid", ROOT_ENTRY_ID);
                treeList.add(memberMap);
            }
        }
        return treeList;
    }

    private Map<String, String> getDimNumberMap() {
        HashMap<String, String> dimNumberMap = new HashMap<String, String>();
        dimNumberMap.put(DimTypesEnum.DATASORT.getNumber(), "datasource");
        dimNumberMap.put(DimTypesEnum.MULTIGAAP.getNumber(), "multigaap");
        if (this.isExistChangeTypeDimension()) {
            dimNumberMap.put(DimTypesEnum.CHANGETYPE.getNumber(), "changetype");
        }
        Map<String, String> dimKeyCache = this.getDimKeyCache();
        for (int i = 1; i <= 6; ++i) {
            String userDefinedIndex = "userdefine" + i;
            String userDefinedNumber = dimKeyCache.get(userDefinedIndex);
            if (!StringUtils.isNotEmpty((String)userDefinedNumber)) continue;
            dimNumberMap.put(userDefinedNumber, userDefinedIndex);
        }
        return dimNumberMap;
    }

    private void setDimMemFilter(int rowIndex, Map<String, Set<Long>> map, String dimNumber, String fieldName) {
        Collection dataSortIds = map.get(dimNumber);
        if (dataSortIds != null) {
            QFilter idFilter = new QFilter("id", "in", (Object)dataSortIds);
            QFilter leafFiler = new QFilter("isleaf", "=", (Object)"1");
            String dsEntityId = DimensionServiceHelper.getDimMembEntityNumByDimNum((String)dimNumber);
            DynamicObjectCollection dync = QueryServiceHelper.query((String)dsEntityId, (String)"id,name,number,isleaf", (QFilter[])new QFilter[]{idFilter, leafFiler});
            if (dync.size() == 1) {
                DynamicObject dynamicObject = (DynamicObject)dync.get(0);
                this.getModel().setValue(fieldName, (Object)dynamicObject.getLong("id"), rowIndex);
            } else {
                DynamicObject dyn = (DynamicObject)this.getModel().getValue(fieldName, rowIndex);
                if (dyn != null) {
                    long id = dyn.getLong("id");
                    List ids = dync.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
                    if (!ids.contains(id)) {
                        this.getModel().setValue(fieldName, null, rowIndex);
                    }
                }
            }
        }
    }

    private QFilter getDimMapFilter(String dimNumber, String accKey) {
        long accId;
        Map map;
        Collection ids;
        int index;
        IDataModel model = this.getModel();
        DynamicObject acct = (DynamicObject)model.getValue(accKey, index = model.getEntryCurrentRowIndex(CTL_ENTRYENTITY));
        if (acct != null && (ids = (Collection)(map = AccountMemberUtil.getAccountDimValMapWithCache((Long)(accId = acct.getLong("id")), (long)this.getModelId(), (IPageCache)this.getPageCache())).get(dimNumber)) != null) {
            return new QFilter("id", "in", (Object)ids);
        }
        return null;
    }

    private Map<String, String> geneDimDefaultId(DynamicObject modelDyn) {
        HashMap<String, String> dimDefaultId;
        String defaultCache = this.getPageCache().get(CACHE_DEFAULT_DIM);
        if (StringUtils.isEmpty((String)defaultCache)) {
            String value;
            DynamicObject icBaseMember;
            DynamicObject mcBaseMember;
            DynamicObject queryOne;
            QFilter numberFilter;
            boolean isspptdatasort = modelDyn.getBoolean("isspptdatasort");
            boolean isspptmultrule = modelDyn.getBoolean("isspptmultrule");
            dimDefaultId = new HashMap<String, String>();
            Long modeId = modelDyn.getLong("id");
            QFilter modelFilter = QFilter.of((String)"model = ?", (Object[])new Object[]{modeId});
            if (isspptdatasort) {
                numberFilter = QFilter.of((String)"number = ?", (Object[])new Object[]{"Actual"});
                numberFilter.and("isleaf", "=", (Object)"1");
                queryOne = QueryServiceHelper.queryOne((String)SysDimensionEnum.DataSort.getMemberTreemodel(), (String)"id", (QFilter[])numberFilter.and(modelFilter).toArray());
                if (queryOne != null) {
                    dimDefaultId.put("datasource", queryOne.getString("id"));
                }
            }
            if (isspptmultrule) {
                numberFilter = QFilter.of((String)"number = ?", (Object[])new Object[]{"PRCGAAP"});
                numberFilter.and("isleaf", "=", (Object)"1");
                queryOne = QueryServiceHelper.queryOne((String)SysDimensionEnum.MultiGAAP.getMemberTreemodel(), (String)"id", (QFilter[])numberFilter.and(modelFilter).toArray());
                if (queryOne != null) {
                    dimDefaultId.put("multigaap", queryOne.getString("id"));
                }
            }
            if ((mcBaseMember = QueryServiceHelper.queryOne((String)SysDimensionEnum.MyCompany.getMemberTreemodel(), (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"MCNone").and("model", "=", (Object)modeId)})) != null) {
                dimDefaultId.put(MYCOMPANY, mcBaseMember.getString("id"));
            }
            if ((icBaseMember = QueryServiceHelper.queryOne((String)SysDimensionEnum.InternalCompany.getMemberTreemodel(), (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"ICNone").and("model", "=", (Object)modeId)})) != null) {
                dimDefaultId.put(INTERCOMPANY, icBaseMember.getString("id"));
            }
            String cacheDim = this.getPageCache().get(CACHE_DIM);
            Map cachDimKeys = (Map)ObjectSerialUtil.deSerializedBytes((String)cacheDim);
            for (int i = 1; i <= 6 && StringUtils.isNotEmpty((String)(value = (String)cachDimKeys.get("userdefine" + i))); ++i) {
                QFilter numberFilter2 = QFilter.of((String)"number = ?", (Object[])new Object[]{value + "None"});
                numberFilter2.and("isleaf", "=", (Object)"1");
                DynamicObject queryOne2 = QueryServiceHelper.queryOne((String)"bcm_userdefinedmembertree", (String)"id", (QFilter[])numberFilter2.and(modelFilter).toArray());
                if (queryOne2 == null) continue;
                dimDefaultId.put("userdefine" + i, queryOne2.getString("id"));
            }
            this.getPageCache().put(CACHE_DEFAULT_DIM, this.toByteSerialized(dimDefaultId));
        } else {
            dimDefaultId = (HashMap<String, String>)this.deSerializedBytes(defaultCache);
        }
        return dimDefaultId;
    }

    private TreeNode findFocusNodeById(String id, TreeNode tree) {
        if (StringUtils.isEmpty((String)id) || tree == null) {
            return null;
        }
        if (id.equals(tree.getId())) {
            return tree;
        }
        if (tree.getChildren() != null) {
            for (TreeNode c : tree.getChildren()) {
                TreeNode fc = this.findFocusNodeById(id, c);
                if (fc == null) continue;
                return fc;
            }
        }
        return null;
    }

    private void initComboItems() {
        InvElimTemplateService.initLinkCreateTypeCombo((IFormView)this.getView());
        InvElimTemplateService.initBalanceTypeCombo((IFormView)this.getView());
    }

    private void initDCCommon() {
        DynamicObject[] extdims;
        ComboEdit debit = (ComboEdit)this.getControl("ruleexpr");
        ComboEdit credit = (ComboEdit)this.getControl("ruleexprdept");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        Long templateId = ((DynamicObject)this.getModel().getValue("sheettemplate")).getLong("id");
        for (DynamicObject dy : extdims = InvSheetTemplateService.getInvSheetAccLayout((Long)templateId)) {
            String number = dy.getString("number");
            String name = dy.getString("name");
            long extdimId = dy.getLong("id");
            items.add(new ComboItem(new LocaleString(number + " " + name), extdimId + ""));
        }
        items.add(new ComboItem(new LocaleString(FormulaEnum.Bn.getCode() + " " + FormulaEnum.Bn.getText()), "bn"));
        debit.setComboItems(items);
        credit.setComboItems(items);
    }

    public DynamicObject getProcess(Long modelId, Long processId) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        qfBuilder.add("id", "=", (Object)processId);
        qfBuilder.add("isleaf", "=", (Object)true);
        return QueryServiceHelper.queryOne((String)"bcm_processmembertree", (String)"id,number,name", (QFilter[])qfBuilder.toArray());
    }

    public Map<String, String> getDimKeyCache() {
        String cacheDim = this.getPageCache().get(CACHE_DIM);
        if (StringUtils.isEmpty((String)cacheDim)) {
            List userDefineds = DimensionServiceHelper.getUserDefineDimensionNumListByModel((Object)this.getModelId());
            Map numMapped = DimensionServiceHelper.getDimensionNumMapped((Object)this.getModelId());
            Map userName = DimensionServiceHelper.getUserDefineDimensionNumAndNameByModel((Object)this.getModelId(), (boolean)false);
            for (int i = 1; i <= 6; ++i) {
                dimKeys.put(userdefineMap2Nums.get("dim" + i), "");
                dimKeys.put(userdefineMap2Nums.get("dim" + i) + "name", "");
            }
            for (int j = 0; j < userDefineds.size(); ++j) {
                String userDefinedNumber = (String)userDefineds.get(j);
                if (!StringUtils.isNotEmpty((String)userDefinedNumber)) continue;
                dimKeys.put(userdefineMap2Nums.get(numMapped.get(userDefinedNumber)), userDefinedNumber);
                dimKeys.put(userdefineMap2Nums.get(numMapped.get(userDefinedNumber)) + "name", (String)userName.get(userDefinedNumber));
            }
            this.getPageCache().put(CACHE_DIM, ObjectSerialUtil.toByteSerialized(dimKeys));
        } else {
            dimKeys.putAll((Map)ObjectSerialUtil.deSerializedBytes((String)cacheDim));
        }
        return dimKeys;
    }

    static {
        dimKeys.put("entity", "entity");
        dimKeys.put(MYCOMPANY, MYCOMPANY);
        dimKeys.put(INTERCOMPANY, INTERCOMPANY);
        dimKeys.put("process", "process");
        dimKeys.put("changetype", "changetype");
        dimKeys.put("audittrail", "audittrail");
        dimKeys.put("datasource", "datasort");
        dimKeys.put("multigaap", "multigaap");
        dimKeys.put("userdefine1", "");
        dimKeys.put("userdefine2", "");
        dimKeys.put("userdefine3", "");
        dimKeys.put("userdefine4", "");
        dimKeys.put("userdefine5", "");
        dimKeys.put("userdefine6", "");
        userdefineMap2Nums.put("dim1", "userdefine1");
        userdefineMap2Nums.put("dim2", "userdefine2");
        userdefineMap2Nums.put("dim3", "userdefine3");
        userdefineMap2Nums.put("dim4", "userdefine4");
        userdefineMap2Nums.put("dim5", "userdefine5");
        userdefineMap2Nums.put("dim6", "userdefine6");
    }
}

