/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest.sheet;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.fi.bcm.common.util.KDAssert;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;

public class SpreadCellStyleEntity {
    public static final int TOP = 0;
    public static final int RIGHT = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    IClientViewProxy view;
    String spreadKey;
    private int rowStart;
    private int colStart;
    private int rowSpan;
    private int colSpan;
    private String borderColor;
    private String borderStyle;
    private List<Map<String, Object>> rangeList = new ArrayList<Map<String, Object>>(10);
    private Map<String, Object> styleMap = new HashMap<String, Object>(16);

    public SpreadCellStyleEntity(IClientViewProxy view, String spreadKey, int rowStart, int colStart, int rowSpan, int colSpan) {
        this.view = view;
        this.spreadKey = spreadKey;
        this.rowStart = rowStart;
        this.colStart = colStart;
        this.rowSpan = rowSpan;
        this.colSpan = colSpan;
    }

    public void doBuildCellsStyle() {
        KDAssert.assertTrue((this.styleMap.size() > 0 ? 1 : 0) != 0, () -> new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6837\u5f0f", (String)"SpreadCellStyleEntity_0", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        this.initRangeList();
        this.doInvoke(this.rangeList, this.styleMap);
    }

    public void clearCellsStyle() {
        this.initRangeList();
        SpreadClientInvoker.clearCellsStyle(this.view, this.spreadKey, this.rangeList);
    }

    public void setAreaBorder(String borderColor, String borderStyle) {
        Map<String, Object> rangeMapTop = this.getRangeMap(this.rowStart, this.colStart, 1, this.colSpan);
        HashMap<Object, Object> borderStyleTop = this.getBorderStyle(borderColor, borderStyle, Sets.newHashSet((Object[])new Integer[]{0}));
        this.sendRangeAndBorderStyle(rangeMapTop, borderStyleTop);
        Map<String, Object> rangeMapRight = this.getRangeMap(this.rowStart, this.colStart + this.colSpan - 1, this.rowSpan, 1);
        HashMap<Object, Object> borderStyleRight = this.getBorderStyle(borderColor, borderStyle, Sets.newHashSet((Object[])new Integer[]{1}));
        this.sendRangeAndBorderStyle(rangeMapRight, borderStyleRight);
        Map<String, Object> rangeMapBottom = this.getRangeMap(this.rowStart + this.rowSpan - 1, this.colStart, 1, this.colSpan);
        HashMap<Object, Object> borderStyleBottom = this.getBorderStyle(borderColor, borderStyle, Sets.newHashSet((Object[])new Integer[]{2}));
        this.sendRangeAndBorderStyle(rangeMapBottom, borderStyleBottom);
        Map<String, Object> rangeMapLeft = this.getRangeMap(this.rowStart, this.colStart, this.rowSpan, 1);
        HashMap<Object, Object> borderStyleLeft = this.getBorderStyle(borderColor, borderStyle, Sets.newHashSet((Object[])new Integer[]{3}));
        this.sendRangeAndBorderStyle(rangeMapLeft, borderStyleLeft);
        Map<String, Object> rangeMapTopLeft = this.getRangeMap(this.rowStart, this.colStart, 1, 1);
        HashMap<Object, Object> borderStyleTopLeft = this.getBorderStyle(borderColor, borderStyle, Sets.newHashSet((Object[])new Integer[]{0, 3}));
        this.sendRangeAndBorderStyle(rangeMapTopLeft, borderStyleTopLeft);
        Map<String, Object> rangeMapTopRight = this.getRangeMap(this.rowStart, this.colStart + this.colSpan - 1, 1, 1);
        HashMap<Object, Object> borderStyleTopRight = this.getBorderStyle(borderColor, borderStyle, Sets.newHashSet((Object[])new Integer[]{0, 1}));
        this.sendRangeAndBorderStyle(rangeMapTopRight, borderStyleTopRight);
        Map<String, Object> rangeMapBottomLeft = this.getRangeMap(this.rowStart + this.rowSpan - 1, this.colStart, 1, 1);
        HashMap<Object, Object> borderStyleBottomLeft = this.getBorderStyle(borderColor, borderStyle, Sets.newHashSet((Object[])new Integer[]{2, 3}));
        this.sendRangeAndBorderStyle(rangeMapBottomLeft, borderStyleBottomLeft);
        Map<String, Object> rangeMapBottomRight = this.getRangeMap(this.rowStart + this.rowSpan - 1, this.colStart + this.colSpan - 1, 1, 1);
        HashMap<Object, Object> borderStyleBottomRight = this.getBorderStyle(borderColor, borderStyle, Sets.newHashSet((Object[])new Integer[]{2, 1}));
        this.sendRangeAndBorderStyle(rangeMapBottomRight, borderStyleBottomRight);
    }

    public void setBorder(String borderColor, String borderStyle) {
        this.borderColor = borderColor;
        this.borderStyle = borderStyle;
        HashMap<Object, Object> bl = this.getBorderStyle(borderColor, borderStyle, Collections.emptySet());
        this.styleMap.put(SpreadProperties.SetCellStyleMethod.BORDER.k(), bl);
    }

    public void setAutoWrap() {
        this.styleMap.put(SpreadProperties.SetCellStyleMethod.WW.k(), true);
    }

    public void setFont(String font) {
        this.styleMap.put(SpreadProperties.SetCellStyleMethod.FONT.k(), font);
    }

    public void setCellBackColor(String color) {
        this.styleMap.put(SpreadProperties.SetCellStyleMethod.BACKCOLOR.k(), color);
    }

    public void addRange(int rowStart, int colStart, int rowSpan, int colSpan) {
        HashMap<String, Integer> rangeMap = new HashMap<String, Integer>(4);
        rangeMap.put(SpreadProperties.ClearCellsStyleMethod.R.k(), rowStart);
        rangeMap.put(SpreadProperties.ClearCellsStyleMethod.C.k(), colStart);
        rangeMap.put(SpreadProperties.ClearCellsStyleMethod.RC.k(), rowSpan);
        rangeMap.put(SpreadProperties.ClearCellsStyleMethod.CC.k(), colSpan);
        this.rangeList.add(rangeMap);
    }

    public int getRowStart() {
        return this.rowStart;
    }

    public void setRowStart(int rowStart) {
        this.rowStart = rowStart;
    }

    public int getColStart() {
        return this.colStart;
    }

    public void setColStart(int colStart) {
        this.colStart = colStart;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public void setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
    }

    public int getColSpan() {
        return this.colSpan;
    }

    public void setColSpan(int colSpan) {
        this.colSpan = colSpan;
    }

    private void initRangeList() {
        Map<String, Object> rangeMap = this.getRangeMap(this.rowStart, this.colStart, this.rowSpan, this.colSpan);
        this.rangeList.add(rangeMap);
    }

    private Map<String, Object> getRangeMap(int rowStart, int colStart, int rowSpan, int colSpan) {
        HashMap<String, Object> rangeMap = new HashMap<String, Object>(4);
        rangeMap.put(SpreadProperties.ClearCellsStyleMethod.R.k(), rowStart);
        rangeMap.put(SpreadProperties.ClearCellsStyleMethod.C.k(), colStart);
        rangeMap.put(SpreadProperties.ClearCellsStyleMethod.RC.k(), rowSpan);
        rangeMap.put(SpreadProperties.ClearCellsStyleMethod.CC.k(), colSpan);
        return rangeMap;
    }

    private HashMap<Object, Object> getBorderStyle(String newColor, String newStyle, Set<Integer> point) {
        String[] colors = this.borderStyleArray(this.borderColor, newColor, point);
        String[] styles = this.borderStyleArray(this.borderStyle, newStyle, point);
        ArrayList borderColorList = new ArrayList(10);
        Collections.addAll(borderColorList, colors);
        ArrayList borderStyleList = new ArrayList(10);
        Collections.addAll(borderStyleList, styles);
        HashMap<Object, Object> bl = new HashMap<Object, Object>(16);
        bl.put(SpreadProperties.SetCellStyleMethod.BORDERCOLOR.k(), borderColorList);
        bl.put(SpreadProperties.SetCellStyleMethod.BORDERSTYLE.k(), borderStyleList);
        return bl;
    }

    private void doInvoke(List<Map<String, Object>> rangeList, Map<String, Object> styleMap) {
        ArrayList dataList = new ArrayList(1);
        HashMap<String, Object> dataMap = new HashMap<String, Object>(2);
        dataMap.put(SpreadProperties.SetCellStyleMethod.RANGE.k(), rangeList);
        dataMap.put(SpreadProperties.SetCellStyleMethod.STYLE.k(), styleMap);
        dataList.add(dataMap);
        HashMap data = new HashMap(16);
        data.put(SpreadProperties.SetCellStyleMethod.DATA.k(), dataList);
        SpreadClientInvoker.invokeSetCellStyleMethod(this.view, this.spreadKey, data);
    }

    private String[] borderStyleArray(String currentStyle, String newStyle, Set<Integer> point) {
        String[] array = new String[4];
        for (int i = 0; i < 4; ++i) {
            array[i] = point.contains(i) ? newStyle : currentStyle;
        }
        return array;
    }

    private void sendRangeAndBorderStyle(Map<String, Object> rangeMap, HashMap<Object, Object> borderStyle) {
        ArrayList<Map<String, Object>> ranges = new ArrayList<Map<String, Object>>(10);
        HashMap<String, Object> style = new HashMap<String, Object>(16);
        style.put(SpreadProperties.SetCellStyleMethod.BORDER.k(), borderStyle);
        ranges.add(rangeMap);
        this.doInvoke(ranges, style);
    }
}

