/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest.sheet.formula;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.formula.model.FormulaEnum;
import kd.fi.bcm.common.enums.invest.InvCurrencyType;
import kd.fi.bcm.common.enums.invest.InvFetchType;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.invest.sheet.formula.GetInvPerFormulaPlugin;

public class GetInvActFormulaPlugin
extends GetInvPerFormulaPlugin {
    private static final String CURRENCY = "cur";

    @Override
    protected void initFetchType() {
        ArrayList comboItems = Lists.newArrayList();
        ComboEdit comboEdit = (ComboEdit)this.getControl("invfetchtype");
        ComboItem item1 = new ComboItem(new LocaleString(InvFetchType.InvestAmount.getDesc()), "4");
        comboItems.add(item1);
        comboEdit.setComboItems((List)comboItems);
        this.getModel().setValue("invfetchtype", (Object)"4");
    }

    @Override
    protected ResultBox checkAndInitParameters(List<String> parameters) {
        ResultBox box = ResultBox.of();
        if (parameters == null) {
            box.addError(ResManager.loadKDString((String)"\u516c\u5f0f\u4e3a\u7a7a\u3002", (String)"VFormulaPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return box;
        }
        if (parameters.size() != 8) {
            box.addError(ResManager.loadKDString((String)"\u516c\u5f0f\u4e2a\u6570\u4e0d\u7b26\u5408\u89c4\u8303\u3002", (String)"VFormulaPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return box;
        }
        String planNumber = parameters.get(0);
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)this.getModelId());
        qfBuilder.and("number", "=", (Object)planNumber);
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_invsharecase", (QFilter[])qfBuilder.toArray());
        if (obj == null) {
            box.addError(String.format(ResManager.loadKDString((String)"%s\u65b9\u6848\u4e0d\u5b58\u5728\u3002", (String)"VFormulaPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), planNumber));
            return box;
        }
        this.getModel().setValue("invsharecase", (Object)obj);
        String changetype = parameters.get(1);
        this.reBuildCombo("invchangetype", changetype);
        String fetchtypename = parameters.get(2);
        this.getModel().setValue("invfetchtype", (Object)InvFetchType.getTypeByName((String)fetchtypename));
        String holder = parameters.get(3);
        this.reBuildCombo("holdorg", holder);
        String invest = parameters.get(4);
        this.reBuildCombo("investorg", invest);
        String startdatestr = parameters.get(6);
        this.reBuildCombo("startdate", startdatestr);
        String enddatestr = parameters.get(7);
        this.reBuildCombo("enddate", enddatestr);
        return box;
    }

    @Override
    public void click(EventObject evt) {
        String opkey = ((Control)evt.getSource()).getKey();
        if ("btn_ok".equals(opkey)) {
            String formuladetail = this.buildGentInvActFormula();
            HashMap maps = Maps.newHashMap();
            maps.put("formula", formuladetail);
            maps.put("name", FormulaEnum.Getinvact.getText());
            this.getView().returnDataToParent((Object)maps);
            this.getView().close();
        }
    }

    private String getCurrency() {
        String type = (String)this.getModel().getValue(CURRENCY);
        if ("1".equals(type)) {
            return InvCurrencyType.HOLDEREC.name();
        }
        return type;
    }

    String buildGentInvActFormula() {
        String shareCaseNumber = this.getModel().getDataEntity().getString("invsharecase.number");
        String changeTypeNumber = this.getChangeNumber();
        String fetchType = this.getFetchType();
        String holderNumber = this.getHoldNumber();
        String investNumber = this.getInvestNumber();
        String currency = this.getCurrency();
        String startdate = this.getStartDate();
        String enddate = this.getEndDate();
        StringBuilder sb = new StringBuilder("Getinvact(");
        sb.append("\"");
        sb.append(shareCaseNumber);
        sb.append("\",\"");
        sb.append(changeTypeNumber);
        sb.append("\",\"");
        sb.append(fetchType);
        sb.append("\",\"");
        sb.append(holderNumber);
        sb.append("\",\"");
        sb.append(investNumber);
        sb.append("\",\"");
        sb.append(currency);
        sb.append("\",\"");
        sb.append(startdate);
        sb.append("\",\"");
        sb.append(enddate);
        sb.append("\")");
        return sb.toString();
    }
}

