/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.invest.sheet.formula;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.formula.model.FormulaEnum;
import kd.fi.bcm.business.invest.helper.InvShareCaseHelper;
import kd.fi.bcm.business.invest.model.InvShareCase;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.invest.InvChangeType;
import kd.fi.bcm.common.enums.invest.InvDateType;
import kd.fi.bcm.common.enums.invest.InvFetchType;
import kd.fi.bcm.common.enums.invest.InvOrgType;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;

public class GetInvPerFormulaPlugin
extends AbstractBaseFormPlugin {
    protected static final String SHARE_CASE = "invsharecase";
    protected static final String CHANGE_TYPE = "invchangetype";
    protected static final String CHOOSE_TYPE = "changetype";
    protected static final String FETCH_TYPE = "invfetchtype";
    protected static final String HOLD_ORG = "holdorg";
    protected static final String INVEST_CORG = "investorg";
    protected static final String START_DATE = "startdate";
    protected static final String END_DATE = "enddate";
    protected static final String CHANGE_PROP = "propoldvalue";
    public static final String FORMULA = "formula";

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners("btn_cancel", "btn_ok");
        BasedataEdit basedata1 = (BasedataEdit)this.getControl(SHARE_CASE);
        if (basedata1 != null) {
            basedata1.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        beforeF7SelectEvent.addCustomQFilter(this.getPermCaseQfilter());
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{CHOOSE_TYPE});
        this.initParameterValues();
    }

    private void initPlan() {
        InvShareCase defaultCase = InvShareCaseHelper.getDefaultCaseBy((long)this.getModelId());
        this.getModel().setValue(SHARE_CASE, (Object)defaultCase.getId());
    }

    private QFilter getPermCaseQfilter() {
        Long modelId = this.getModelId();
        QFilter scopeFilter = InvShareCaseHelper.getScopeFilter((long)modelId);
        return scopeFilter;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        Object valueobj = e.getChangeSet()[0].getNewValue();
        Object oldobj = e.getChangeSet()[0].getOldValue();
        this.getPageCache().remove(CHANGE_PROP);
        HashMap changeObj = Maps.newHashMap();
        changeObj.put(propertyName, oldobj);
        this.getPageCache().put(CHANGE_PROP, ObjectSerialUtil.toByteSerialized((Object)changeObj));
        if (valueobj instanceof String) {
            String value = valueobj.toString();
            Long modelId = this.getModelId();
            if ((HOLD_ORG.equals(propertyName) || INVEST_CORG.equals(propertyName)) && "3".equals(value)) {
                Long dimId = 0L;
                HashMap<String, Object> customData = new HashMap<String, Object>();
                customData.put("f7Click", "true");
                if ("3".equals(value) && HOLD_ORG.equals(propertyName)) {
                    dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)DimTypesEnum.INTERCOMPANY.getNumber());
                    customData.put("enableScheme", false);
                } else if ("3".equals(value) && INVEST_CORG.equals(propertyName)) {
                    dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)DimTypesEnum.ENTITY.getNumber());
                    customData.put("enableScheme", true);
                }
                BasedataEditSingleMemberF7 basedataSingleF7 = SingleMemberF7Util.createBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), dimId, propertyName, null, false);
                basedataSingleF7.setF7title(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9", (String)"InvChangeDataCaseSettingPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                basedataSingleF7.setCallBackClassName(this.getClass().getName());
                basedataSingleF7.setCustomData(customData);
                QFilter qFilter = new QFilter("model", "=", (Object)modelId);
                basedataSingleF7.setCustomFilter(qFilter);
                basedataSingleF7.click();
            } else if ("4".equals(value) && (START_DATE.equals(propertyName) || END_DATE.equals(propertyName))) {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("bcm_datepick");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, propertyName));
                this.getView().showForm(formShowParameter);
            } else if ("2".equals(value) && CHANGE_TYPE.equals(propertyName)) {
                ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"bcm_invchangetype", (boolean)Boolean.FALSE, (int)0, (boolean)Boolean.TRUE);
                ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
                listFilterParameter.setFilter(this.getQFilter());
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CHANGE_TYPE);
                listShowParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)listShowParameter);
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String opkey = ((Control)evt.getSource()).getKey();
        if ("btn_ok".equals(opkey)) {
            String formuladetail = this.buildGentInvPerFormula();
            HashMap maps = Maps.newHashMap();
            maps.put(FORMULA, formuladetail);
            maps.put("name", FormulaEnum.Getinvper.getText());
            this.getView().returnDataToParent((Object)maps);
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection rows;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object obj = closedCallBackEvent.getReturnData();
        String oldStr = this.getPageCache().get(CHANGE_PROP);
        if (obj == null && !StringUtils.isEmpty((CharSequence)oldStr)) {
            HashMap oldValue = (HashMap)ObjectSerialUtil.deSerializedBytes((String)oldStr);
            if (oldValue.containsKey(actionId)) {
                this.getModel().setValue(actionId, oldValue.get(actionId));
                return;
            }
        } else if (obj == null) {
            return;
        }
        if (HOLD_ORG.equals(actionId) || INVEST_CORG.equals(actionId)) {
            DynamicObject dy = (DynamicObject)closedCallBackEvent.getReturnData();
            this.reBuildCombo(actionId, dy);
        } else if (START_DATE.equals(actionId) || END_DATE.equals(actionId)) {
            String date = (String)closedCallBackEvent.getReturnData();
            this.reBuildCombo(actionId, date);
        } else if (CHANGE_TYPE.equals(actionId) && (rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()).size() > 0) {
            Object id = rows.get(0).getPrimaryKeyValue();
            DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_invchangetype");
            this.reBuildCombo(actionId, dy);
        }
    }

    protected void reBuildCombo(String key, DynamicObject dy) {
        ArrayList comboItems = Lists.newArrayList();
        ComboEdit comboEdit = (ComboEdit)this.getControl(key);
        if (CHANGE_TYPE.equals(key)) {
            ComboItem item1 = new ComboItem(new LocaleString(InvChangeType.None.getDesc()), "1");
            ComboItem item2 = new ComboItem(new LocaleString(InvOrgType.MEMBER.getDesc()), "2");
            ComboItem item3 = new ComboItem(new LocaleString(dy.getString("name")), dy.getString("number"));
            item3.setItemVisible(false);
            comboItems.add(item1);
            comboItems.add(item2);
            comboItems.add(item3);
            comboEdit.setComboItems((List)comboItems);
        } else if (HOLD_ORG.equals(key) || INVEST_CORG.equals(key)) {
            ComboItem item1 = new ComboItem(new LocaleString(InvOrgType.HOLDER.getDesc()), "1");
            ComboItem item2 = new ComboItem(new LocaleString(InvOrgType.INVESTORG.getDesc()), "2");
            ComboItem item3 = new ComboItem(new LocaleString(InvOrgType.MEMBER.getDesc()), "3");
            ComboItem item4 = new ComboItem(new LocaleString(dy.getString("name")), dy.getString("number"));
            item4.setItemVisible(false);
            comboItems.add(item1);
            comboItems.add(item2);
            comboItems.add(item3);
            comboItems.add(item4);
            comboEdit.setComboItems((List)comboItems);
        }
        this.getModel().beginInit();
        this.getModel().setValue(key, (Object)dy.getString("number"));
        this.getModel().endInit();
        this.getView().updateView(key);
    }

    protected void reBuildCombo(String key, String valueStr) {
        ArrayList comboItems = Lists.newArrayList();
        ComboEdit comboEdit = (ComboEdit)this.getControl(key);
        if (START_DATE.equals(key)) {
            ComboItem item1 = new ComboItem(new LocaleString(InvDateType.PeriodBegin.getDesc()), "1");
            ComboItem item2 = new ComboItem(new LocaleString(InvDateType.BeginYear.getDesc()), "3");
            ComboItem item3 = new ComboItem(new LocaleString(InvDateType.None.getDesc()), "5");
            ComboItem item4 = new ComboItem(new LocaleString(InvDateType.SignedDate.getDesc()), "4");
            comboItems.add(item1);
            comboItems.add(item2);
            comboItems.add(item3);
            comboItems.add(item4);
            if (StringUtils.isEmpty((CharSequence)valueStr)) {
                valueStr = "5";
            } else if (StringUtils.isEmpty((CharSequence)InvDateType.getTypeByName((String)valueStr))) {
                ComboItem item5 = new ComboItem(new LocaleString(valueStr), valueStr);
                item5.setItemVisible(false);
                comboItems.add(item5);
            } else {
                valueStr = InvDateType.getTypeByName((String)valueStr);
            }
            comboEdit.setComboItems((List)comboItems);
        } else if (END_DATE.equals(key)) {
            ComboItem item1 = new ComboItem(new LocaleString(InvDateType.PeriodEnd.getDesc()), "2");
            ComboItem item4 = new ComboItem(new LocaleString(InvDateType.SignedDate.getDesc()), "4");
            comboItems.add(item1);
            comboItems.add(item4);
            if (StringUtils.isEmpty((CharSequence)valueStr) || InvDateType.PeriodEnd.name().equals(valueStr)) {
                valueStr = "2";
            } else if (StringUtils.isEmpty((CharSequence)InvDateType.getTypeByName((String)valueStr))) {
                ComboItem item5 = new ComboItem(new LocaleString(valueStr), valueStr);
                item5.setItemVisible(false);
                comboItems.add(item5);
            }
            comboEdit.setComboItems((List)comboItems);
        } else if (CHANGE_TYPE.equals(key)) {
            ComboItem item1 = new ComboItem(new LocaleString(InvChangeType.None.getDesc()), "1");
            ComboItem item2 = new ComboItem(new LocaleString(InvOrgType.MEMBER.getDesc()), "2");
            comboItems.add(item1);
            comboItems.add(item2);
            if (!StringUtils.isEmpty((CharSequence)valueStr) && !InvChangeType.None.name().equals(valueStr)) {
                DynamicObject obj = this.getDyByNumber("bcm_invchangetype", valueStr);
                ComboItem item3 = new ComboItem(new LocaleString(obj.getString("name")), obj.getString("number"));
                item3.setItemVisible(false);
                comboItems.add(item3);
            } else if (InvChangeType.None.name().equals(valueStr)) {
                valueStr = "1";
            }
            comboEdit.setComboItems((List)comboItems);
        } else if (HOLD_ORG.equals(key) || INVEST_CORG.equals(key)) {
            ComboItem item1 = new ComboItem(new LocaleString(InvOrgType.HOLDER.getDesc()), "1");
            ComboItem item2 = new ComboItem(new LocaleString(InvOrgType.INVESTORG.getDesc()), "2");
            ComboItem item3 = new ComboItem(new LocaleString(InvOrgType.MEMBER.getDesc()), "3");
            comboItems.add(item1);
            comboItems.add(item2);
            comboItems.add(item3);
            if (StringUtils.isEmpty((CharSequence)valueStr)) {
                valueStr = HOLD_ORG.equals(key) ? "1" : "2";
            } else if (StringUtils.isEmpty((CharSequence)InvOrgType.getTypeByName((String)valueStr))) {
                String entityname = "bcm_entitymembertree";
                if (HOLD_ORG.equals(key)) {
                    entityname = "bcm_icmembertree";
                }
                DynamicObject obj = this.getDyByNumber(entityname, valueStr);
                ComboItem item4 = new ComboItem(new LocaleString(obj.getString("name")), obj.getString("number"));
                item4.setItemVisible(false);
                comboItems.add(item4);
                comboEdit.setComboItems((List)comboItems);
            } else {
                valueStr = InvOrgType.getTypeByName((String)valueStr);
            }
        }
        this.getModel().beginInit();
        this.getModel().setValue(key, (Object)valueStr);
        this.getModel().endInit();
        comboEdit.getView().updateView(key);
    }

    private String buildGentInvPerFormula() {
        String shareCaseNumber = this.getModel().getDataEntity().getString("invsharecase.number");
        String changeTypeNumber = this.getChangeNumber();
        String fetchType = this.getFetchType();
        String holderNumber = this.getHoldNumber();
        String investNumber = this.getInvestNumber();
        String startdate = this.getStartDate();
        String enddate = this.getEndDate();
        StringBuilder sb = new StringBuilder("Getinvper(");
        sb.append("\"");
        sb.append(shareCaseNumber);
        sb.append("\",\"");
        sb.append(changeTypeNumber);
        sb.append("\",\"");
        sb.append(fetchType);
        sb.append("\",\"");
        sb.append(holderNumber);
        sb.append("\",\"");
        sb.append(investNumber);
        sb.append("\",\"");
        sb.append(startdate);
        sb.append("\",\"");
        sb.append(enddate);
        sb.append("\")");
        return sb.toString();
    }

    protected String getFetchType() {
        String type = (String)this.getModel().getValue(FETCH_TYPE);
        return InvFetchType.getNumberByType((String)type);
    }

    protected String getHoldNumber() {
        String orgNumber = this.getModel().getDataEntity().getString(HOLD_ORG);
        if ("1".equals(orgNumber)) {
            return InvOrgType.HOLDER.name();
        }
        if ("2".equals(orgNumber)) {
            return InvOrgType.INVESTORG.name();
        }
        return orgNumber;
    }

    protected String getChangeNumber() {
        String number = this.getModel().getDataEntity().getString(CHANGE_TYPE);
        if (StringUtils.isEmpty((CharSequence)number)) {
            return "";
        }
        if ("1".equals(number)) {
            return InvChangeType.None.name();
        }
        return number;
    }

    protected String getInvestNumber() {
        String orgNumber = this.getModel().getDataEntity().getString(INVEST_CORG);
        if ("1".equals(orgNumber)) {
            return InvOrgType.HOLDER.name();
        }
        if ("2".equals(orgNumber)) {
            return InvOrgType.INVESTORG.name();
        }
        return orgNumber;
    }

    protected String getStartDate() {
        String startTtype = (String)this.getModel().getValue(START_DATE);
        return InvDateType.getNameByType((String)startTtype);
    }

    protected String getEndDate() {
        String endtype = (String)this.getModel().getValue(END_DATE);
        return InvDateType.getNameByType((String)endtype);
    }

    /*
     * Unable to fully structure code
     */
    public void initParameterValues() {
        parameters = new ArrayList<String>(10);
        formula = (String)this.getFormCustomParam("formula");
        if (!StringUtils.isEmpty((CharSequence)formula)) {
            try {
                expr = (FunctionExpr)ExcelFormulaPaserHelper.parse((String)formula);
                expr.getParameters().forEach((Consumer<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$initParameterValues$0(java.util.List java.lang.Object ), (Ljava/lang/Object;)V)(parameters));
                resultBox = this.checkAndInitParameters(parameters);
                if (!resultBox.isError()) ** GOTO lbl14
                this.getView().showErrorNotification(resultBox.getMessageText());
            }
            catch (Exception e1) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s \u65e0\u6548\u516c\u5f0f", (String)"VFormulaPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), new Object[]{formula}));
            }
        } else {
            this.initPlan();
        }
lbl14:
        // 3 sources

        this.initFetchType();
        this.checkchangetypeMust();
    }

    private void checkchangetypeMust() {
        ComboEdit edit;
        String parentFormId = this.getView().getParentView().getFormShowParameter().getFormId();
        if (!"bcm_invsheettemplateedit".equalsIgnoreCase(parentFormId) && !"bcm_formulapicker_invest".equalsIgnoreCase(parentFormId) && (edit = (ComboEdit)this.getControl(CHANGE_TYPE)) != null) {
            edit.setMustInput(Boolean.TRUE.booleanValue());
        }
    }

    protected void initFetchType() {
    }

    protected ResultBox checkAndInitParameters(List<String> parameters) {
        ResultBox box = ResultBox.of();
        if (parameters == null) {
            box.addError(ResManager.loadKDString((String)"\u516c\u5f0f\u4e3a\u7a7a\u3002", (String)"VFormulaPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return box;
        }
        if (parameters.size() != 7) {
            box.addError(ResManager.loadKDString((String)"\u516c\u5f0f\u4e2a\u6570\u4e0d\u7b26\u5408\u89c4\u8303\u3002", (String)"VFormulaPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return box;
        }
        String planNumber = parameters.get(0);
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)this.getModelId());
        qfBuilder.and("number", "=", (Object)planNumber);
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_invsharecase", (QFilter[])qfBuilder.toArray());
        if (obj == null) {
            box.addError(String.format(ResManager.loadKDString((String)"%s\u65b9\u6848\u4e0d\u5b58\u5728\u3002", (String)"VFormulaPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), planNumber));
            return box;
        }
        this.getModel().setValue(SHARE_CASE, (Object)obj);
        String changetype = parameters.get(1);
        this.reBuildCombo(CHANGE_TYPE, changetype);
        String fetchtypename = parameters.get(2);
        this.getModel().setValue(FETCH_TYPE, (Object)InvFetchType.getTypeByName((String)fetchtypename));
        String holder = parameters.get(3);
        this.reBuildCombo(HOLD_ORG, holder);
        String invest = parameters.get(4);
        this.reBuildCombo(INVEST_CORG, invest);
        String startdatestr = parameters.get(5);
        this.reBuildCombo(START_DATE, startdatestr);
        String enddatestr = parameters.get(6);
        this.reBuildCombo(END_DATE, enddatestr);
        return box;
    }

    DynamicObject getDyByNumber(String entityname, String number) {
        QFBuilder qfBuilder = new QFBuilder("number", "=", (Object)number);
        if ("bcm_invchangetype".equalsIgnoreCase(entityname)) {
            qfBuilder.and(this.getQFilter());
        } else {
            qfBuilder.and("model", "=", (Object)this.getModelId());
        }
        return BusinessDataServiceHelper.loadSingleFromCache((String)entityname, (QFilter[])qfBuilder.toArray());
    }

    public QFilter getQFilter() {
        Long modelid = this.getModelId();
        return new QFilter("model", "=", (Object)modelid).and("enable", "=", (Object)"1");
    }

    private static /* synthetic */ void lambda$initParameterValues$0(List parameters, Object e) {
        String param = e.toString().replaceAll("\"", "");
        parameters.add(param);
    }
}

